package addons

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// OneTimeCharge enumerates the values for one time charge.
type OneTimeCharge string

const (
	// No ...
	No OneTimeCharge = "no"
	// OnEnabled ...
	OnEnabled OneTimeCharge = "onEnabled"
	// OnReenabled ...
	OnReenabled OneTimeCharge = "onReenabled"
)

// PossibleOneTimeChargeValues returns an array of possible values for the OneTimeCharge const type.
func PossibleOneTimeChargeValues() []OneTimeCharge {
	return []OneTimeCharge{No, OnEnabled, OnReenabled}
}

// PlanTypeName enumerates the values for plan type name.
type PlanTypeName string

const (
	// Advanced ...
	Advanced PlanTypeName = "Advanced"
	// Essential ...
	Essential PlanTypeName = "Essential"
	// Standard ...
	Standard PlanTypeName = "Standard"
)

// PossiblePlanTypeNameValues returns an array of possible values for the PlanTypeName const type.
func PossiblePlanTypeNameValues() []PlanTypeName {
	return []PlanTypeName{Advanced, Essential, Standard}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Cancelled ...
	Cancelled ProvisioningState = "Cancelled"
	// Cancelling ...
	Cancelling ProvisioningState = "Cancelling"
	// Downgrading ...
	Downgrading ProvisioningState = "Downgrading"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Purchasing ...
	Purchasing ProvisioningState = "Purchasing"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Upgrading ...
	Upgrading ProvisioningState = "Upgrading"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Cancelled, Cancelling, Downgrading, Failed, Purchasing, Succeeded, Upgrading}
}

// SupportPlanType enumerates the values for support plan type.
type SupportPlanType string

const (
	// SupportPlanTypeAdvanced ...
	SupportPlanTypeAdvanced SupportPlanType = "advanced"
	// SupportPlanTypeEssential ...
	SupportPlanTypeEssential SupportPlanType = "essential"
	// SupportPlanTypeStandard ...
	SupportPlanTypeStandard SupportPlanType = "standard"
)

// PossibleSupportPlanTypeValues returns an array of possible values for the SupportPlanType const type.
func PossibleSupportPlanTypeValues() []SupportPlanType {
	return []SupportPlanType{SupportPlanTypeAdvanced, SupportPlanTypeEssential, SupportPlanTypeStandard}
}
