package azureadb2c

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/azureadb2c/mgmt/2020-05-01-preview/azureadb2c"

// CloudError an error response for a resource management request.
type CloudError struct {
	Error *ErrorResponse `json:"error,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.)
type ErrorResponse struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorResponse `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// GuestUsagesResource guest Usages Resource
type GuestUsagesResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; An identifier that represents the Guest Usages resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the Guest Usages resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the Guest Usages resource.
	Type *string `json:"type,omitempty"`
	// Location - Location of the Guest Usages resource.
	Location *string `json:"location,omitempty"`
	// Tags - Key-value pairs of additional resource provisioning properties.
	Tags map[string]*string `json:"tags"`
	// GuestUsagesResourceProperties - The Guest Usages Resource Properties
	*GuestUsagesResourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for GuestUsagesResource.
func (gur GuestUsagesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gur.Location != nil {
		objectMap["location"] = gur.Location
	}
	if gur.Tags != nil {
		objectMap["tags"] = gur.Tags
	}
	if gur.GuestUsagesResourceProperties != nil {
		objectMap["properties"] = gur.GuestUsagesResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GuestUsagesResource struct.
func (gur *GuestUsagesResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gur.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gur.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gur.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gur.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gur.Tags = tags
			}
		case "properties":
			if v != nil {
				var guestUsagesResourceProperties GuestUsagesResourceProperties
				err = json.Unmarshal(*v, &guestUsagesResourceProperties)
				if err != nil {
					return err
				}
				gur.GuestUsagesResourceProperties = &guestUsagesResourceProperties
			}
		}
	}

	return nil
}

// GuestUsagesResourceList the collection of guest usages resources
type GuestUsagesResourceList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of guest usages resources
	Value *[]GuestUsagesResource `json:"value,omitempty"`
}

// GuestUsagesResourcePatch guest Usages Resource for Patch
type GuestUsagesResourcePatch struct {
	// Tags - Key-value pairs of additional resource provisioning properties.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GuestUsagesResourcePatch.
func (gurp GuestUsagesResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gurp.Tags != nil {
		objectMap["tags"] = gurp.Tags
	}
	return json.Marshal(objectMap)
}

// GuestUsagesResourceProperties guest Usages Resource Properties
type GuestUsagesResourceProperties struct {
	// TenantID - An identifier for the tenant for which the resource is being created
	TenantID *string `json:"tenantId,omitempty"`
}

// Operation microsoft.AzureActiveDirectory REST API operation.
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Service provider: Microsoft.AzureActiveDirectory.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource on which the operation is performed: GuestUsages, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Friendly name of the operation
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Description != nil {
		objectMap["description"] = o.Description
	}
	return json.Marshal(objectMap)
}

// OperationListResult result of listing operations for the resourceProvider
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of cpim service operations supported by the Microsoft.AzureActiveDirectory resource provider.
	Value *[]Operation `json:"value,omitempty"`
}
