package policyinsights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RemediationsClient is the client for the Remediations methods of the Policyinsights service.
type RemediationsClient struct {
	BaseClient
}

// NewRemediationsClient creates an instance of the RemediationsClient client.
func NewRemediationsClient() RemediationsClient {
	return NewRemediationsClientWithBaseURI(DefaultBaseURI)
}

// NewRemediationsClientWithBaseURI creates an instance of the RemediationsClient client using a custom endpoint.  Use
// this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewRemediationsClientWithBaseURI(baseURI string) RemediationsClient {
	return RemediationsClient{NewWithBaseURI(baseURI)}
}

// CancelAtManagementGroup cancels a remediation at management group scope.
// Parameters:
// managementGroupID - management group ID.
// remediationName - the name of the remediation.
func (client RemediationsClient) CancelAtManagementGroup(ctx context.Context, managementGroupID string, remediationName string) (result Remediation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.CancelAtManagementGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CancelAtManagementGroupPreparer(ctx, managementGroupID, remediationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CancelAtManagementGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.CancelAtManagementGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CancelAtManagementGroup", resp, "Failure sending request")
		return
	}

	result, err = client.CancelAtManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CancelAtManagementGroup", resp, "Failure responding to request")
		return
	}

	return
}

// CancelAtManagementGroupPreparer prepares the CancelAtManagementGroup request.
func (client RemediationsClient) CancelAtManagementGroupPreparer(ctx context.Context, managementGroupID string, remediationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managementGroupId":         autorest.Encode("path", managementGroupID),
		"managementGroupsNamespace": autorest.Encode("path", "Microsoft.Management"),
		"remediationName":           autorest.Encode("path", remediationName),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/cancel", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CancelAtManagementGroupSender sends the CancelAtManagementGroup request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) CancelAtManagementGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CancelAtManagementGroupResponder handles the response to the CancelAtManagementGroup request. The method always
// closes the http.Response Body.
func (client RemediationsClient) CancelAtManagementGroupResponder(resp *http.Response) (result Remediation, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CancelAtResource cancel a remediation at resource scope.
// Parameters:
// resourceID - resource ID.
// remediationName - the name of the remediation.
func (client RemediationsClient) CancelAtResource(ctx context.Context, resourceID string, remediationName string) (result Remediation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.CancelAtResource")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CancelAtResourcePreparer(ctx, resourceID, remediationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CancelAtResource", nil, "Failure preparing request")
		return
	}

	resp, err := client.CancelAtResourceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CancelAtResource", resp, "Failure sending request")
		return
	}

	result, err = client.CancelAtResourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CancelAtResource", resp, "Failure responding to request")
		return
	}

	return
}

// CancelAtResourcePreparer prepares the CancelAtResource request.
func (client RemediationsClient) CancelAtResourcePreparer(ctx context.Context, resourceID string, remediationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"remediationName": autorest.Encode("path", remediationName),
		"resourceId":      resourceID,
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/cancel", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CancelAtResourceSender sends the CancelAtResource request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) CancelAtResourceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CancelAtResourceResponder handles the response to the CancelAtResource request. The method always
// closes the http.Response Body.
func (client RemediationsClient) CancelAtResourceResponder(resp *http.Response) (result Remediation, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CancelAtResourceGroup cancels a remediation at resource group scope.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// resourceGroupName - resource group name.
// remediationName - the name of the remediation.
func (client RemediationsClient) CancelAtResourceGroup(ctx context.Context, subscriptionID string, resourceGroupName string, remediationName string) (result Remediation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.CancelAtResourceGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CancelAtResourceGroupPreparer(ctx, subscriptionID, resourceGroupName, remediationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CancelAtResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.CancelAtResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CancelAtResourceGroup", resp, "Failure sending request")
		return
	}

	result, err = client.CancelAtResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CancelAtResourceGroup", resp, "Failure responding to request")
		return
	}

	return
}

// CancelAtResourceGroupPreparer prepares the CancelAtResourceGroup request.
func (client RemediationsClient) CancelAtResourceGroupPreparer(ctx context.Context, subscriptionID string, resourceGroupName string, remediationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"remediationName":   autorest.Encode("path", remediationName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/cancel", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CancelAtResourceGroupSender sends the CancelAtResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) CancelAtResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CancelAtResourceGroupResponder handles the response to the CancelAtResourceGroup request. The method always
// closes the http.Response Body.
func (client RemediationsClient) CancelAtResourceGroupResponder(resp *http.Response) (result Remediation, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CancelAtSubscription cancels a remediation at subscription scope.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// remediationName - the name of the remediation.
func (client RemediationsClient) CancelAtSubscription(ctx context.Context, subscriptionID string, remediationName string) (result Remediation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.CancelAtSubscription")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CancelAtSubscriptionPreparer(ctx, subscriptionID, remediationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CancelAtSubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.CancelAtSubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CancelAtSubscription", resp, "Failure sending request")
		return
	}

	result, err = client.CancelAtSubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CancelAtSubscription", resp, "Failure responding to request")
		return
	}

	return
}

// CancelAtSubscriptionPreparer prepares the CancelAtSubscription request.
func (client RemediationsClient) CancelAtSubscriptionPreparer(ctx context.Context, subscriptionID string, remediationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"remediationName": autorest.Encode("path", remediationName),
		"subscriptionId":  autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/cancel", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CancelAtSubscriptionSender sends the CancelAtSubscription request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) CancelAtSubscriptionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CancelAtSubscriptionResponder handles the response to the CancelAtSubscription request. The method always
// closes the http.Response Body.
func (client RemediationsClient) CancelAtSubscriptionResponder(resp *http.Response) (result Remediation, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateAtManagementGroup creates or updates a remediation at management group scope.
// Parameters:
// managementGroupID - management group ID.
// remediationName - the name of the remediation.
// parameters - the remediation parameters.
func (client RemediationsClient) CreateOrUpdateAtManagementGroup(ctx context.Context, managementGroupID string, remediationName string, parameters Remediation) (result Remediation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.CreateOrUpdateAtManagementGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateAtManagementGroupPreparer(ctx, managementGroupID, remediationName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CreateOrUpdateAtManagementGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateAtManagementGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CreateOrUpdateAtManagementGroup", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateAtManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CreateOrUpdateAtManagementGroup", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateAtManagementGroupPreparer prepares the CreateOrUpdateAtManagementGroup request.
func (client RemediationsClient) CreateOrUpdateAtManagementGroupPreparer(ctx context.Context, managementGroupID string, remediationName string, parameters Remediation) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managementGroupId":         autorest.Encode("path", managementGroupID),
		"managementGroupsNamespace": autorest.Encode("path", "Microsoft.Management"),
		"remediationName":           autorest.Encode("path", remediationName),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.ID = nil
	parameters.Type = nil
	parameters.Name = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateAtManagementGroupSender sends the CreateOrUpdateAtManagementGroup request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) CreateOrUpdateAtManagementGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateOrUpdateAtManagementGroupResponder handles the response to the CreateOrUpdateAtManagementGroup request. The method always
// closes the http.Response Body.
func (client RemediationsClient) CreateOrUpdateAtManagementGroupResponder(resp *http.Response) (result Remediation, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateAtResource creates or updates a remediation at resource scope.
// Parameters:
// resourceID - resource ID.
// remediationName - the name of the remediation.
// parameters - the remediation parameters.
func (client RemediationsClient) CreateOrUpdateAtResource(ctx context.Context, resourceID string, remediationName string, parameters Remediation) (result Remediation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.CreateOrUpdateAtResource")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateAtResourcePreparer(ctx, resourceID, remediationName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CreateOrUpdateAtResource", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateAtResourceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CreateOrUpdateAtResource", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateAtResourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CreateOrUpdateAtResource", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateAtResourcePreparer prepares the CreateOrUpdateAtResource request.
func (client RemediationsClient) CreateOrUpdateAtResourcePreparer(ctx context.Context, resourceID string, remediationName string, parameters Remediation) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"remediationName": autorest.Encode("path", remediationName),
		"resourceId":      resourceID,
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.ID = nil
	parameters.Type = nil
	parameters.Name = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateAtResourceSender sends the CreateOrUpdateAtResource request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) CreateOrUpdateAtResourceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateOrUpdateAtResourceResponder handles the response to the CreateOrUpdateAtResource request. The method always
// closes the http.Response Body.
func (client RemediationsClient) CreateOrUpdateAtResourceResponder(resp *http.Response) (result Remediation, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateAtResourceGroup creates or updates a remediation at resource group scope.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// resourceGroupName - resource group name.
// remediationName - the name of the remediation.
// parameters - the remediation parameters.
func (client RemediationsClient) CreateOrUpdateAtResourceGroup(ctx context.Context, subscriptionID string, resourceGroupName string, remediationName string, parameters Remediation) (result Remediation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.CreateOrUpdateAtResourceGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateAtResourceGroupPreparer(ctx, subscriptionID, resourceGroupName, remediationName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CreateOrUpdateAtResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateAtResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CreateOrUpdateAtResourceGroup", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateAtResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CreateOrUpdateAtResourceGroup", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateAtResourceGroupPreparer prepares the CreateOrUpdateAtResourceGroup request.
func (client RemediationsClient) CreateOrUpdateAtResourceGroupPreparer(ctx context.Context, subscriptionID string, resourceGroupName string, remediationName string, parameters Remediation) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"remediationName":   autorest.Encode("path", remediationName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.ID = nil
	parameters.Type = nil
	parameters.Name = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateAtResourceGroupSender sends the CreateOrUpdateAtResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) CreateOrUpdateAtResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateAtResourceGroupResponder handles the response to the CreateOrUpdateAtResourceGroup request. The method always
// closes the http.Response Body.
func (client RemediationsClient) CreateOrUpdateAtResourceGroupResponder(resp *http.Response) (result Remediation, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateAtSubscription creates or updates a remediation at subscription scope.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// remediationName - the name of the remediation.
// parameters - the remediation parameters.
func (client RemediationsClient) CreateOrUpdateAtSubscription(ctx context.Context, subscriptionID string, remediationName string, parameters Remediation) (result Remediation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.CreateOrUpdateAtSubscription")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateAtSubscriptionPreparer(ctx, subscriptionID, remediationName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CreateOrUpdateAtSubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateAtSubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CreateOrUpdateAtSubscription", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateAtSubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "CreateOrUpdateAtSubscription", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateAtSubscriptionPreparer prepares the CreateOrUpdateAtSubscription request.
func (client RemediationsClient) CreateOrUpdateAtSubscriptionPreparer(ctx context.Context, subscriptionID string, remediationName string, parameters Remediation) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"remediationName": autorest.Encode("path", remediationName),
		"subscriptionId":  autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.ID = nil
	parameters.Type = nil
	parameters.Name = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateAtSubscriptionSender sends the CreateOrUpdateAtSubscription request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) CreateOrUpdateAtSubscriptionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateAtSubscriptionResponder handles the response to the CreateOrUpdateAtSubscription request. The method always
// closes the http.Response Body.
func (client RemediationsClient) CreateOrUpdateAtSubscriptionResponder(resp *http.Response) (result Remediation, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteAtManagementGroup deletes an existing remediation at management group scope.
// Parameters:
// managementGroupID - management group ID.
// remediationName - the name of the remediation.
func (client RemediationsClient) DeleteAtManagementGroup(ctx context.Context, managementGroupID string, remediationName string) (result Remediation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.DeleteAtManagementGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteAtManagementGroupPreparer(ctx, managementGroupID, remediationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "DeleteAtManagementGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteAtManagementGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "DeleteAtManagementGroup", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteAtManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "DeleteAtManagementGroup", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteAtManagementGroupPreparer prepares the DeleteAtManagementGroup request.
func (client RemediationsClient) DeleteAtManagementGroupPreparer(ctx context.Context, managementGroupID string, remediationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managementGroupId":         autorest.Encode("path", managementGroupID),
		"managementGroupsNamespace": autorest.Encode("path", "Microsoft.Management"),
		"remediationName":           autorest.Encode("path", remediationName),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteAtManagementGroupSender sends the DeleteAtManagementGroup request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) DeleteAtManagementGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteAtManagementGroupResponder handles the response to the DeleteAtManagementGroup request. The method always
// closes the http.Response Body.
func (client RemediationsClient) DeleteAtManagementGroupResponder(resp *http.Response) (result Remediation, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteAtResource deletes an existing remediation at individual resource scope.
// Parameters:
// resourceID - resource ID.
// remediationName - the name of the remediation.
func (client RemediationsClient) DeleteAtResource(ctx context.Context, resourceID string, remediationName string) (result Remediation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.DeleteAtResource")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteAtResourcePreparer(ctx, resourceID, remediationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "DeleteAtResource", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteAtResourceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "DeleteAtResource", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteAtResourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "DeleteAtResource", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteAtResourcePreparer prepares the DeleteAtResource request.
func (client RemediationsClient) DeleteAtResourcePreparer(ctx context.Context, resourceID string, remediationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"remediationName": autorest.Encode("path", remediationName),
		"resourceId":      resourceID,
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteAtResourceSender sends the DeleteAtResource request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) DeleteAtResourceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteAtResourceResponder handles the response to the DeleteAtResource request. The method always
// closes the http.Response Body.
func (client RemediationsClient) DeleteAtResourceResponder(resp *http.Response) (result Remediation, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteAtResourceGroup deletes an existing remediation at resource group scope.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// resourceGroupName - resource group name.
// remediationName - the name of the remediation.
func (client RemediationsClient) DeleteAtResourceGroup(ctx context.Context, subscriptionID string, resourceGroupName string, remediationName string) (result Remediation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.DeleteAtResourceGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteAtResourceGroupPreparer(ctx, subscriptionID, resourceGroupName, remediationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "DeleteAtResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteAtResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "DeleteAtResourceGroup", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteAtResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "DeleteAtResourceGroup", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteAtResourceGroupPreparer prepares the DeleteAtResourceGroup request.
func (client RemediationsClient) DeleteAtResourceGroupPreparer(ctx context.Context, subscriptionID string, resourceGroupName string, remediationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"remediationName":   autorest.Encode("path", remediationName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteAtResourceGroupSender sends the DeleteAtResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) DeleteAtResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteAtResourceGroupResponder handles the response to the DeleteAtResourceGroup request. The method always
// closes the http.Response Body.
func (client RemediationsClient) DeleteAtResourceGroupResponder(resp *http.Response) (result Remediation, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteAtSubscription deletes an existing remediation at subscription scope.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// remediationName - the name of the remediation.
func (client RemediationsClient) DeleteAtSubscription(ctx context.Context, subscriptionID string, remediationName string) (result Remediation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.DeleteAtSubscription")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteAtSubscriptionPreparer(ctx, subscriptionID, remediationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "DeleteAtSubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteAtSubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "DeleteAtSubscription", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteAtSubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "DeleteAtSubscription", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteAtSubscriptionPreparer prepares the DeleteAtSubscription request.
func (client RemediationsClient) DeleteAtSubscriptionPreparer(ctx context.Context, subscriptionID string, remediationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"remediationName": autorest.Encode("path", remediationName),
		"subscriptionId":  autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteAtSubscriptionSender sends the DeleteAtSubscription request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) DeleteAtSubscriptionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteAtSubscriptionResponder handles the response to the DeleteAtSubscription request. The method always
// closes the http.Response Body.
func (client RemediationsClient) DeleteAtSubscriptionResponder(resp *http.Response) (result Remediation, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAtManagementGroup gets an existing remediation at management group scope.
// Parameters:
// managementGroupID - management group ID.
// remediationName - the name of the remediation.
func (client RemediationsClient) GetAtManagementGroup(ctx context.Context, managementGroupID string, remediationName string) (result Remediation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.GetAtManagementGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAtManagementGroupPreparer(ctx, managementGroupID, remediationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "GetAtManagementGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAtManagementGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "GetAtManagementGroup", resp, "Failure sending request")
		return
	}

	result, err = client.GetAtManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "GetAtManagementGroup", resp, "Failure responding to request")
		return
	}

	return
}

// GetAtManagementGroupPreparer prepares the GetAtManagementGroup request.
func (client RemediationsClient) GetAtManagementGroupPreparer(ctx context.Context, managementGroupID string, remediationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managementGroupId":         autorest.Encode("path", managementGroupID),
		"managementGroupsNamespace": autorest.Encode("path", "Microsoft.Management"),
		"remediationName":           autorest.Encode("path", remediationName),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAtManagementGroupSender sends the GetAtManagementGroup request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) GetAtManagementGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAtManagementGroupResponder handles the response to the GetAtManagementGroup request. The method always
// closes the http.Response Body.
func (client RemediationsClient) GetAtManagementGroupResponder(resp *http.Response) (result Remediation, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAtResource gets an existing remediation at resource scope.
// Parameters:
// resourceID - resource ID.
// remediationName - the name of the remediation.
func (client RemediationsClient) GetAtResource(ctx context.Context, resourceID string, remediationName string) (result Remediation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.GetAtResource")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAtResourcePreparer(ctx, resourceID, remediationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "GetAtResource", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAtResourceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "GetAtResource", resp, "Failure sending request")
		return
	}

	result, err = client.GetAtResourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "GetAtResource", resp, "Failure responding to request")
		return
	}

	return
}

// GetAtResourcePreparer prepares the GetAtResource request.
func (client RemediationsClient) GetAtResourcePreparer(ctx context.Context, resourceID string, remediationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"remediationName": autorest.Encode("path", remediationName),
		"resourceId":      resourceID,
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAtResourceSender sends the GetAtResource request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) GetAtResourceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAtResourceResponder handles the response to the GetAtResource request. The method always
// closes the http.Response Body.
func (client RemediationsClient) GetAtResourceResponder(resp *http.Response) (result Remediation, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAtResourceGroup gets an existing remediation at resource group scope.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// resourceGroupName - resource group name.
// remediationName - the name of the remediation.
func (client RemediationsClient) GetAtResourceGroup(ctx context.Context, subscriptionID string, resourceGroupName string, remediationName string) (result Remediation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.GetAtResourceGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAtResourceGroupPreparer(ctx, subscriptionID, resourceGroupName, remediationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "GetAtResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAtResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "GetAtResourceGroup", resp, "Failure sending request")
		return
	}

	result, err = client.GetAtResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "GetAtResourceGroup", resp, "Failure responding to request")
		return
	}

	return
}

// GetAtResourceGroupPreparer prepares the GetAtResourceGroup request.
func (client RemediationsClient) GetAtResourceGroupPreparer(ctx context.Context, subscriptionID string, resourceGroupName string, remediationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"remediationName":   autorest.Encode("path", remediationName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAtResourceGroupSender sends the GetAtResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) GetAtResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetAtResourceGroupResponder handles the response to the GetAtResourceGroup request. The method always
// closes the http.Response Body.
func (client RemediationsClient) GetAtResourceGroupResponder(resp *http.Response) (result Remediation, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAtSubscription gets an existing remediation at subscription scope.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// remediationName - the name of the remediation.
func (client RemediationsClient) GetAtSubscription(ctx context.Context, subscriptionID string, remediationName string) (result Remediation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.GetAtSubscription")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAtSubscriptionPreparer(ctx, subscriptionID, remediationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "GetAtSubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAtSubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "GetAtSubscription", resp, "Failure sending request")
		return
	}

	result, err = client.GetAtSubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "GetAtSubscription", resp, "Failure responding to request")
		return
	}

	return
}

// GetAtSubscriptionPreparer prepares the GetAtSubscription request.
func (client RemediationsClient) GetAtSubscriptionPreparer(ctx context.Context, subscriptionID string, remediationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"remediationName": autorest.Encode("path", remediationName),
		"subscriptionId":  autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAtSubscriptionSender sends the GetAtSubscription request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) GetAtSubscriptionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetAtSubscriptionResponder handles the response to the GetAtSubscription request. The method always
// closes the http.Response Body.
func (client RemediationsClient) GetAtSubscriptionResponder(resp *http.Response) (result Remediation, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListDeploymentsAtManagementGroup gets all deployments for a remediation at management group scope.
// Parameters:
// managementGroupID - management group ID.
// remediationName - the name of the remediation.
// top - maximum number of records to return.
func (client RemediationsClient) ListDeploymentsAtManagementGroup(ctx context.Context, managementGroupID string, remediationName string, top *int32) (result RemediationDeploymentsListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.ListDeploymentsAtManagementGroup")
		defer func() {
			sc := -1
			if result.rdlr.Response.Response != nil {
				sc = result.rdlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.RemediationsClient", "ListDeploymentsAtManagementGroup", err.Error())
	}

	result.fn = client.listDeploymentsAtManagementGroupNextResults
	req, err := client.ListDeploymentsAtManagementGroupPreparer(ctx, managementGroupID, remediationName, top)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListDeploymentsAtManagementGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDeploymentsAtManagementGroupSender(req)
	if err != nil {
		result.rdlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListDeploymentsAtManagementGroup", resp, "Failure sending request")
		return
	}

	result.rdlr, err = client.ListDeploymentsAtManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListDeploymentsAtManagementGroup", resp, "Failure responding to request")
		return
	}
	if result.rdlr.hasNextLink() && result.rdlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListDeploymentsAtManagementGroupPreparer prepares the ListDeploymentsAtManagementGroup request.
func (client RemediationsClient) ListDeploymentsAtManagementGroupPreparer(ctx context.Context, managementGroupID string, remediationName string, top *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managementGroupId":         autorest.Encode("path", managementGroupID),
		"managementGroupsNamespace": autorest.Encode("path", "Microsoft.Management"),
		"remediationName":           autorest.Encode("path", remediationName),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/listDeployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDeploymentsAtManagementGroupSender sends the ListDeploymentsAtManagementGroup request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) ListDeploymentsAtManagementGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListDeploymentsAtManagementGroupResponder handles the response to the ListDeploymentsAtManagementGroup request. The method always
// closes the http.Response Body.
func (client RemediationsClient) ListDeploymentsAtManagementGroupResponder(resp *http.Response) (result RemediationDeploymentsListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listDeploymentsAtManagementGroupNextResults retrieves the next set of results, if any.
func (client RemediationsClient) listDeploymentsAtManagementGroupNextResults(ctx context.Context, lastResults RemediationDeploymentsListResult) (result RemediationDeploymentsListResult, err error) {
	req, err := lastResults.remediationDeploymentsListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listDeploymentsAtManagementGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListDeploymentsAtManagementGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listDeploymentsAtManagementGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListDeploymentsAtManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listDeploymentsAtManagementGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListDeploymentsAtManagementGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client RemediationsClient) ListDeploymentsAtManagementGroupComplete(ctx context.Context, managementGroupID string, remediationName string, top *int32) (result RemediationDeploymentsListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.ListDeploymentsAtManagementGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListDeploymentsAtManagementGroup(ctx, managementGroupID, remediationName, top)
	return
}

// ListDeploymentsAtResource gets all deployments for a remediation at resource scope.
// Parameters:
// resourceID - resource ID.
// remediationName - the name of the remediation.
// top - maximum number of records to return.
func (client RemediationsClient) ListDeploymentsAtResource(ctx context.Context, resourceID string, remediationName string, top *int32) (result RemediationDeploymentsListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.ListDeploymentsAtResource")
		defer func() {
			sc := -1
			if result.rdlr.Response.Response != nil {
				sc = result.rdlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.RemediationsClient", "ListDeploymentsAtResource", err.Error())
	}

	result.fn = client.listDeploymentsAtResourceNextResults
	req, err := client.ListDeploymentsAtResourcePreparer(ctx, resourceID, remediationName, top)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListDeploymentsAtResource", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDeploymentsAtResourceSender(req)
	if err != nil {
		result.rdlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListDeploymentsAtResource", resp, "Failure sending request")
		return
	}

	result.rdlr, err = client.ListDeploymentsAtResourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListDeploymentsAtResource", resp, "Failure responding to request")
		return
	}
	if result.rdlr.hasNextLink() && result.rdlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListDeploymentsAtResourcePreparer prepares the ListDeploymentsAtResource request.
func (client RemediationsClient) ListDeploymentsAtResourcePreparer(ctx context.Context, resourceID string, remediationName string, top *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"remediationName": autorest.Encode("path", remediationName),
		"resourceId":      resourceID,
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/listDeployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDeploymentsAtResourceSender sends the ListDeploymentsAtResource request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) ListDeploymentsAtResourceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListDeploymentsAtResourceResponder handles the response to the ListDeploymentsAtResource request. The method always
// closes the http.Response Body.
func (client RemediationsClient) ListDeploymentsAtResourceResponder(resp *http.Response) (result RemediationDeploymentsListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listDeploymentsAtResourceNextResults retrieves the next set of results, if any.
func (client RemediationsClient) listDeploymentsAtResourceNextResults(ctx context.Context, lastResults RemediationDeploymentsListResult) (result RemediationDeploymentsListResult, err error) {
	req, err := lastResults.remediationDeploymentsListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listDeploymentsAtResourceNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListDeploymentsAtResourceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listDeploymentsAtResourceNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListDeploymentsAtResourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listDeploymentsAtResourceNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListDeploymentsAtResourceComplete enumerates all values, automatically crossing page boundaries as required.
func (client RemediationsClient) ListDeploymentsAtResourceComplete(ctx context.Context, resourceID string, remediationName string, top *int32) (result RemediationDeploymentsListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.ListDeploymentsAtResource")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListDeploymentsAtResource(ctx, resourceID, remediationName, top)
	return
}

// ListDeploymentsAtResourceGroup gets all deployments for a remediation at resource group scope.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// resourceGroupName - resource group name.
// remediationName - the name of the remediation.
// top - maximum number of records to return.
func (client RemediationsClient) ListDeploymentsAtResourceGroup(ctx context.Context, subscriptionID string, resourceGroupName string, remediationName string, top *int32) (result RemediationDeploymentsListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.ListDeploymentsAtResourceGroup")
		defer func() {
			sc := -1
			if result.rdlr.Response.Response != nil {
				sc = result.rdlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.RemediationsClient", "ListDeploymentsAtResourceGroup", err.Error())
	}

	result.fn = client.listDeploymentsAtResourceGroupNextResults
	req, err := client.ListDeploymentsAtResourceGroupPreparer(ctx, subscriptionID, resourceGroupName, remediationName, top)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListDeploymentsAtResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDeploymentsAtResourceGroupSender(req)
	if err != nil {
		result.rdlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListDeploymentsAtResourceGroup", resp, "Failure sending request")
		return
	}

	result.rdlr, err = client.ListDeploymentsAtResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListDeploymentsAtResourceGroup", resp, "Failure responding to request")
		return
	}
	if result.rdlr.hasNextLink() && result.rdlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListDeploymentsAtResourceGroupPreparer prepares the ListDeploymentsAtResourceGroup request.
func (client RemediationsClient) ListDeploymentsAtResourceGroupPreparer(ctx context.Context, subscriptionID string, resourceGroupName string, remediationName string, top *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"remediationName":   autorest.Encode("path", remediationName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/listDeployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDeploymentsAtResourceGroupSender sends the ListDeploymentsAtResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) ListDeploymentsAtResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListDeploymentsAtResourceGroupResponder handles the response to the ListDeploymentsAtResourceGroup request. The method always
// closes the http.Response Body.
func (client RemediationsClient) ListDeploymentsAtResourceGroupResponder(resp *http.Response) (result RemediationDeploymentsListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listDeploymentsAtResourceGroupNextResults retrieves the next set of results, if any.
func (client RemediationsClient) listDeploymentsAtResourceGroupNextResults(ctx context.Context, lastResults RemediationDeploymentsListResult) (result RemediationDeploymentsListResult, err error) {
	req, err := lastResults.remediationDeploymentsListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listDeploymentsAtResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListDeploymentsAtResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listDeploymentsAtResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListDeploymentsAtResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listDeploymentsAtResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListDeploymentsAtResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client RemediationsClient) ListDeploymentsAtResourceGroupComplete(ctx context.Context, subscriptionID string, resourceGroupName string, remediationName string, top *int32) (result RemediationDeploymentsListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.ListDeploymentsAtResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListDeploymentsAtResourceGroup(ctx, subscriptionID, resourceGroupName, remediationName, top)
	return
}

// ListDeploymentsAtSubscription gets all deployments for a remediation at subscription scope.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// remediationName - the name of the remediation.
// top - maximum number of records to return.
func (client RemediationsClient) ListDeploymentsAtSubscription(ctx context.Context, subscriptionID string, remediationName string, top *int32) (result RemediationDeploymentsListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.ListDeploymentsAtSubscription")
		defer func() {
			sc := -1
			if result.rdlr.Response.Response != nil {
				sc = result.rdlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.RemediationsClient", "ListDeploymentsAtSubscription", err.Error())
	}

	result.fn = client.listDeploymentsAtSubscriptionNextResults
	req, err := client.ListDeploymentsAtSubscriptionPreparer(ctx, subscriptionID, remediationName, top)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListDeploymentsAtSubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDeploymentsAtSubscriptionSender(req)
	if err != nil {
		result.rdlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListDeploymentsAtSubscription", resp, "Failure sending request")
		return
	}

	result.rdlr, err = client.ListDeploymentsAtSubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListDeploymentsAtSubscription", resp, "Failure responding to request")
		return
	}
	if result.rdlr.hasNextLink() && result.rdlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListDeploymentsAtSubscriptionPreparer prepares the ListDeploymentsAtSubscription request.
func (client RemediationsClient) ListDeploymentsAtSubscriptionPreparer(ctx context.Context, subscriptionID string, remediationName string, top *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"remediationName": autorest.Encode("path", remediationName),
		"subscriptionId":  autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/listDeployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDeploymentsAtSubscriptionSender sends the ListDeploymentsAtSubscription request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) ListDeploymentsAtSubscriptionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListDeploymentsAtSubscriptionResponder handles the response to the ListDeploymentsAtSubscription request. The method always
// closes the http.Response Body.
func (client RemediationsClient) ListDeploymentsAtSubscriptionResponder(resp *http.Response) (result RemediationDeploymentsListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listDeploymentsAtSubscriptionNextResults retrieves the next set of results, if any.
func (client RemediationsClient) listDeploymentsAtSubscriptionNextResults(ctx context.Context, lastResults RemediationDeploymentsListResult) (result RemediationDeploymentsListResult, err error) {
	req, err := lastResults.remediationDeploymentsListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listDeploymentsAtSubscriptionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListDeploymentsAtSubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listDeploymentsAtSubscriptionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListDeploymentsAtSubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listDeploymentsAtSubscriptionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListDeploymentsAtSubscriptionComplete enumerates all values, automatically crossing page boundaries as required.
func (client RemediationsClient) ListDeploymentsAtSubscriptionComplete(ctx context.Context, subscriptionID string, remediationName string, top *int32) (result RemediationDeploymentsListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.ListDeploymentsAtSubscription")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListDeploymentsAtSubscription(ctx, subscriptionID, remediationName, top)
	return
}

// ListForManagementGroup gets all remediations for the management group.
// Parameters:
// managementGroupID - management group ID.
// top - maximum number of records to return.
// filter - oData filter expression.
func (client RemediationsClient) ListForManagementGroup(ctx context.Context, managementGroupID string, top *int32, filter string) (result RemediationListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.ListForManagementGroup")
		defer func() {
			sc := -1
			if result.rlr.Response.Response != nil {
				sc = result.rlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.RemediationsClient", "ListForManagementGroup", err.Error())
	}

	result.fn = client.listForManagementGroupNextResults
	req, err := client.ListForManagementGroupPreparer(ctx, managementGroupID, top, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListForManagementGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListForManagementGroupSender(req)
	if err != nil {
		result.rlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListForManagementGroup", resp, "Failure sending request")
		return
	}

	result.rlr, err = client.ListForManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListForManagementGroup", resp, "Failure responding to request")
		return
	}
	if result.rlr.hasNextLink() && result.rlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListForManagementGroupPreparer prepares the ListForManagementGroup request.
func (client RemediationsClient) ListForManagementGroupPreparer(ctx context.Context, managementGroupID string, top *int32, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managementGroupId":         autorest.Encode("path", managementGroupID),
		"managementGroupsNamespace": autorest.Encode("path", "Microsoft.Management"),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListForManagementGroupSender sends the ListForManagementGroup request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) ListForManagementGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListForManagementGroupResponder handles the response to the ListForManagementGroup request. The method always
// closes the http.Response Body.
func (client RemediationsClient) ListForManagementGroupResponder(resp *http.Response) (result RemediationListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listForManagementGroupNextResults retrieves the next set of results, if any.
func (client RemediationsClient) listForManagementGroupNextResults(ctx context.Context, lastResults RemediationListResult) (result RemediationListResult, err error) {
	req, err := lastResults.remediationListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listForManagementGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListForManagementGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listForManagementGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListForManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listForManagementGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListForManagementGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client RemediationsClient) ListForManagementGroupComplete(ctx context.Context, managementGroupID string, top *int32, filter string) (result RemediationListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.ListForManagementGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListForManagementGroup(ctx, managementGroupID, top, filter)
	return
}

// ListForResource gets all remediations for a resource.
// Parameters:
// resourceID - resource ID.
// top - maximum number of records to return.
// filter - oData filter expression.
func (client RemediationsClient) ListForResource(ctx context.Context, resourceID string, top *int32, filter string) (result RemediationListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.ListForResource")
		defer func() {
			sc := -1
			if result.rlr.Response.Response != nil {
				sc = result.rlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.RemediationsClient", "ListForResource", err.Error())
	}

	result.fn = client.listForResourceNextResults
	req, err := client.ListForResourcePreparer(ctx, resourceID, top, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListForResource", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListForResourceSender(req)
	if err != nil {
		result.rlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListForResource", resp, "Failure sending request")
		return
	}

	result.rlr, err = client.ListForResourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListForResource", resp, "Failure responding to request")
		return
	}
	if result.rlr.hasNextLink() && result.rlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListForResourcePreparer prepares the ListForResource request.
func (client RemediationsClient) ListForResourcePreparer(ctx context.Context, resourceID string, top *int32, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceId": resourceID,
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceId}/providers/Microsoft.PolicyInsights/remediations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListForResourceSender sends the ListForResource request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) ListForResourceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListForResourceResponder handles the response to the ListForResource request. The method always
// closes the http.Response Body.
func (client RemediationsClient) ListForResourceResponder(resp *http.Response) (result RemediationListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listForResourceNextResults retrieves the next set of results, if any.
func (client RemediationsClient) listForResourceNextResults(ctx context.Context, lastResults RemediationListResult) (result RemediationListResult, err error) {
	req, err := lastResults.remediationListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listForResourceNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListForResourceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listForResourceNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListForResourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listForResourceNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListForResourceComplete enumerates all values, automatically crossing page boundaries as required.
func (client RemediationsClient) ListForResourceComplete(ctx context.Context, resourceID string, top *int32, filter string) (result RemediationListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.ListForResource")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListForResource(ctx, resourceID, top, filter)
	return
}

// ListForResourceGroup gets all remediations for the subscription.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// resourceGroupName - resource group name.
// top - maximum number of records to return.
// filter - oData filter expression.
func (client RemediationsClient) ListForResourceGroup(ctx context.Context, subscriptionID string, resourceGroupName string, top *int32, filter string) (result RemediationListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.ListForResourceGroup")
		defer func() {
			sc := -1
			if result.rlr.Response.Response != nil {
				sc = result.rlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.RemediationsClient", "ListForResourceGroup", err.Error())
	}

	result.fn = client.listForResourceGroupNextResults
	req, err := client.ListForResourceGroupPreparer(ctx, subscriptionID, resourceGroupName, top, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListForResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListForResourceGroupSender(req)
	if err != nil {
		result.rlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListForResourceGroup", resp, "Failure sending request")
		return
	}

	result.rlr, err = client.ListForResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListForResourceGroup", resp, "Failure responding to request")
		return
	}
	if result.rlr.hasNextLink() && result.rlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListForResourceGroupPreparer prepares the ListForResourceGroup request.
func (client RemediationsClient) ListForResourceGroupPreparer(ctx context.Context, subscriptionID string, resourceGroupName string, top *int32, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListForResourceGroupSender sends the ListForResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) ListForResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListForResourceGroupResponder handles the response to the ListForResourceGroup request. The method always
// closes the http.Response Body.
func (client RemediationsClient) ListForResourceGroupResponder(resp *http.Response) (result RemediationListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listForResourceGroupNextResults retrieves the next set of results, if any.
func (client RemediationsClient) listForResourceGroupNextResults(ctx context.Context, lastResults RemediationListResult) (result RemediationListResult, err error) {
	req, err := lastResults.remediationListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listForResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListForResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listForResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListForResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listForResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListForResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client RemediationsClient) ListForResourceGroupComplete(ctx context.Context, subscriptionID string, resourceGroupName string, top *int32, filter string) (result RemediationListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.ListForResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListForResourceGroup(ctx, subscriptionID, resourceGroupName, top, filter)
	return
}

// ListForSubscription gets all remediations for the subscription.
// Parameters:
// subscriptionID - microsoft Azure subscription ID.
// top - maximum number of records to return.
// filter - oData filter expression.
func (client RemediationsClient) ListForSubscription(ctx context.Context, subscriptionID string, top *int32, filter string) (result RemediationListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.ListForSubscription")
		defer func() {
			sc := -1
			if result.rlr.Response.Response != nil {
				sc = result.rlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.RemediationsClient", "ListForSubscription", err.Error())
	}

	result.fn = client.listForSubscriptionNextResults
	req, err := client.ListForSubscriptionPreparer(ctx, subscriptionID, top, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListForSubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListForSubscriptionSender(req)
	if err != nil {
		result.rlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListForSubscription", resp, "Failure sending request")
		return
	}

	result.rlr, err = client.ListForSubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "ListForSubscription", resp, "Failure responding to request")
		return
	}
	if result.rlr.hasNextLink() && result.rlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListForSubscriptionPreparer prepares the ListForSubscription request.
func (client RemediationsClient) ListForSubscriptionPreparer(ctx context.Context, subscriptionID string, top *int32, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListForSubscriptionSender sends the ListForSubscription request. The method will close the
// http.Response Body if it receives an error.
func (client RemediationsClient) ListForSubscriptionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListForSubscriptionResponder handles the response to the ListForSubscription request. The method always
// closes the http.Response Body.
func (client RemediationsClient) ListForSubscriptionResponder(resp *http.Response) (result RemediationListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listForSubscriptionNextResults retrieves the next set of results, if any.
func (client RemediationsClient) listForSubscriptionNextResults(ctx context.Context, lastResults RemediationListResult) (result RemediationListResult, err error) {
	req, err := lastResults.remediationListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listForSubscriptionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListForSubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listForSubscriptionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListForSubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.RemediationsClient", "listForSubscriptionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListForSubscriptionComplete enumerates all values, automatically crossing page boundaries as required.
func (client RemediationsClient) ListForSubscriptionComplete(ctx context.Context, subscriptionID string, top *int32, filter string) (result RemediationListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RemediationsClient.ListForSubscription")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListForSubscription(ctx, subscriptionID, top, filter)
	return
}
