package security

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// IotSensorsClient is the API spec for Microsoft.Security (Azure Security Center) resource provider
type IotSensorsClient struct {
	BaseClient
}

// NewIotSensorsClient creates an instance of the IotSensorsClient client.
func NewIotSensorsClient(subscriptionID string, ascLocation string) IotSensorsClient {
	return NewIotSensorsClientWithBaseURI(DefaultBaseURI, subscriptionID, ascLocation)
}

// NewIotSensorsClientWithBaseURI creates an instance of the IotSensorsClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewIotSensorsClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) IotSensorsClient {
	return IotSensorsClient{NewWithBaseURI(baseURI, subscriptionID, ascLocation)}
}

// CreateOrUpdate create or update IoT sensor
// Parameters:
// scope - scope of the query (IoT Hub, /providers/Microsoft.Devices/iotHubs/myHub)
// iotSensorName - name of the IoT sensor
// iotSensorsModel - the IoT sensor model
func (client IotSensorsClient) CreateOrUpdate(ctx context.Context, scope string, iotSensorName string, iotSensorsModel IotSensorsModel) (result IotSensorsModel, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotSensorsClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdatePreparer(ctx, scope, iotSensorName, iotSensorsModel)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "CreateOrUpdate", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client IotSensorsClient) CreateOrUpdatePreparer(ctx context.Context, scope string, iotSensorName string, iotSensorsModel IotSensorsModel) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"iotSensorName": autorest.Encode("path", iotSensorName),
		"scope":         scope,
	}

	const APIVersion = "2020-08-06-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Security/iotSensors/{iotSensorName}", pathParameters),
		autorest.WithJSON(iotSensorsModel),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client IotSensorsClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client IotSensorsClient) CreateOrUpdateResponder(resp *http.Response) (result IotSensorsModel, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete IoT sensor
// Parameters:
// scope - scope of the query (IoT Hub, /providers/Microsoft.Devices/iotHubs/myHub)
// iotSensorName - name of the IoT sensor
func (client IotSensorsClient) Delete(ctx context.Context, scope string, iotSensorName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotSensorsClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, scope, iotSensorName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "Delete", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client IotSensorsClient) DeletePreparer(ctx context.Context, scope string, iotSensorName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"iotSensorName": autorest.Encode("path", iotSensorName),
		"scope":         scope,
	}

	const APIVersion = "2020-08-06-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Security/iotSensors/{iotSensorName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client IotSensorsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client IotSensorsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DownloadActivation download sensor activation file
// Parameters:
// scope - scope of the query (IoT Hub, /providers/Microsoft.Devices/iotHubs/myHub)
// iotSensorName - name of the IoT sensor
func (client IotSensorsClient) DownloadActivation(ctx context.Context, scope string, iotSensorName string) (result ReadCloser, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotSensorsClient.DownloadActivation")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DownloadActivationPreparer(ctx, scope, iotSensorName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "DownloadActivation", nil, "Failure preparing request")
		return
	}

	resp, err := client.DownloadActivationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "DownloadActivation", resp, "Failure sending request")
		return
	}

	result, err = client.DownloadActivationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "DownloadActivation", resp, "Failure responding to request")
		return
	}

	return
}

// DownloadActivationPreparer prepares the DownloadActivation request.
func (client IotSensorsClient) DownloadActivationPreparer(ctx context.Context, scope string, iotSensorName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"iotSensorName": autorest.Encode("path", iotSensorName),
		"scope":         scope,
	}

	const APIVersion = "2020-08-06-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Security/iotSensors/{iotSensorName}/downloadActivation", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DownloadActivationSender sends the DownloadActivation request. The method will close the
// http.Response Body if it receives an error.
func (client IotSensorsClient) DownloadActivationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DownloadActivationResponder handles the response to the DownloadActivation request. The method always
// closes the http.Response Body.
func (client IotSensorsClient) DownloadActivationResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK))
	result.Response = autorest.Response{Response: resp}
	return
}

// DownloadResetPassword download file for reset password of the sensor
// Parameters:
// scope - scope of the query (IoT Hub, /providers/Microsoft.Devices/iotHubs/myHub)
// iotSensorName - name of the IoT sensor
// body - the reset password input.
func (client IotSensorsClient) DownloadResetPassword(ctx context.Context, scope string, iotSensorName string, body ResetPasswordInput) (result ReadCloser, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotSensorsClient.DownloadResetPassword")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DownloadResetPasswordPreparer(ctx, scope, iotSensorName, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "DownloadResetPassword", nil, "Failure preparing request")
		return
	}

	resp, err := client.DownloadResetPasswordSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "DownloadResetPassword", resp, "Failure sending request")
		return
	}

	result, err = client.DownloadResetPasswordResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "DownloadResetPassword", resp, "Failure responding to request")
		return
	}

	return
}

// DownloadResetPasswordPreparer prepares the DownloadResetPassword request.
func (client IotSensorsClient) DownloadResetPasswordPreparer(ctx context.Context, scope string, iotSensorName string, body ResetPasswordInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"iotSensorName": autorest.Encode("path", iotSensorName),
		"scope":         scope,
	}

	const APIVersion = "2020-08-06-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Security/iotSensors/{iotSensorName}/downloadResetPassword", pathParameters),
		autorest.WithJSON(body),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DownloadResetPasswordSender sends the DownloadResetPassword request. The method will close the
// http.Response Body if it receives an error.
func (client IotSensorsClient) DownloadResetPasswordSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DownloadResetPasswordResponder handles the response to the DownloadResetPassword request. The method always
// closes the http.Response Body.
func (client IotSensorsClient) DownloadResetPasswordResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK))
	result.Response = autorest.Response{Response: resp}
	return
}

// Get get IoT sensor
// Parameters:
// scope - scope of the query (IoT Hub, /providers/Microsoft.Devices/iotHubs/myHub)
// iotSensorName - name of the IoT sensor
func (client IotSensorsClient) Get(ctx context.Context, scope string, iotSensorName string) (result IotSensorsModel, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotSensorsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, scope, iotSensorName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client IotSensorsClient) GetPreparer(ctx context.Context, scope string, iotSensorName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"iotSensorName": autorest.Encode("path", iotSensorName),
		"scope":         scope,
	}

	const APIVersion = "2020-08-06-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Security/iotSensors/{iotSensorName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client IotSensorsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client IotSensorsClient) GetResponder(resp *http.Response) (result IotSensorsModel, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List list IoT sensors
// Parameters:
// scope - scope of the query (IoT Hub, /providers/Microsoft.Devices/iotHubs/myHub)
func (client IotSensorsClient) List(ctx context.Context, scope string) (result IotSensorsList, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotSensorsClient.List")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListPreparer(ctx, scope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "List", resp, "Failure responding to request")
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client IotSensorsClient) ListPreparer(ctx context.Context, scope string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"scope": scope,
	}

	const APIVersion = "2020-08-06-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Security/iotSensors", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client IotSensorsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client IotSensorsClient) ListResponder(resp *http.Response) (result IotSensorsList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// TriggerTiPackageUpdate trigger threat intelligence package update
// Parameters:
// scope - scope of the query (IoT Hub, /providers/Microsoft.Devices/iotHubs/myHub)
// iotSensorName - name of the IoT sensor
func (client IotSensorsClient) TriggerTiPackageUpdate(ctx context.Context, scope string, iotSensorName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IotSensorsClient.TriggerTiPackageUpdate")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.TriggerTiPackageUpdatePreparer(ctx, scope, iotSensorName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "TriggerTiPackageUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.TriggerTiPackageUpdateSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "TriggerTiPackageUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.TriggerTiPackageUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.IotSensorsClient", "TriggerTiPackageUpdate", resp, "Failure responding to request")
		return
	}

	return
}

// TriggerTiPackageUpdatePreparer prepares the TriggerTiPackageUpdate request.
func (client IotSensorsClient) TriggerTiPackageUpdatePreparer(ctx context.Context, scope string, iotSensorName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"iotSensorName": autorest.Encode("path", iotSensorName),
		"scope":         scope,
	}

	const APIVersion = "2020-08-06-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Security/iotSensors/{iotSensorName}/triggerTiPackageUpdate", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// TriggerTiPackageUpdateSender sends the TriggerTiPackageUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client IotSensorsClient) TriggerTiPackageUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// TriggerTiPackageUpdateResponder handles the response to the TriggerTiPackageUpdate request. The method always
// closes the http.Response Body.
func (client IotSensorsClient) TriggerTiPackageUpdateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}
