/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.cli.CommandNotificationListener;
import org.netbeans.modules.subversion.client.cli.CommandlineClient;
import org.netbeans.modules.subversion.client.cli.Parser;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.FileUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.Utilities;
import org.tigris.subversion.svnclientadapter.SVNBaseDir;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public abstract class SvnCommand
implements CommandNotificationListener {
    private final List<String> cmdError = new ArrayList<String>(10);
    private Exception thrownException;
    private boolean hasFailed;
    private Integer exitCode;
    private boolean commandExecuted;
    private Arguments arguments = new Arguments();
    private CommandlineClient.NotificationHandler notificationHandler;
    private File configDir;
    private String username;
    private String password;
    private File tmpFolder;

    protected SvnCommand() {
    }

    public void setConfigDir(File configDir) {
        this.configDir = configDir;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    CommandlineClient.NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    void setNotificationHandler(CommandlineClient.NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
        if (this.notifyOutput()) {
            notificationHandler.enableLog();
        } else {
            notificationHandler.disableLog();
        }
    }

    void prepareCommand() throws IOException {
        assert (this.notificationHandler != null);
        this.prepareCommand(this.arguments);
        this.config(this.configDir, this.username, this.password, this.arguments);
    }

    public abstract void prepareCommand(Arguments var1) throws IOException;

    protected abstract int getCommand();

    public void setCommandWorkingDirectory(File ... files) {
        this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File[])files));
    }

    protected boolean hasBinaryOutput() {
        return false;
    }

    protected boolean notifyOutput() {
        return true;
    }

    @Override
    public void commandStarted() {
        assert (!this.commandExecuted) : "Command re-use is not supported";
        this.commandExecuted = true;
        String cmdString = SvnCommand.toString(this.arguments, true).toString();
        this.notificationHandler.logCommandLine(cmdString);
    }

    @Override
    public void outputText(String lineString) {
        Subversion.LOG.fine("outputText [" + lineString + "]");
        if (!this.notifyOutput()) {
            return;
        }
        Parser.Line line = Parser.getInstance().parse(lineString);
        if (line != null) {
            if (this.notificationHandler != null && line.getPath() != null) {
                Subversion.LOG.fine("outputText [" + line.getPath() + "]");
                this.notificationHandler.notifyListenersOfChange(line.getPath());
            }
            this.notify(line);
            this.notificationHandler.logMessage(lineString);
        }
    }

    public void output(byte[] bytes) {
    }

    @Override
    public void errorText(String line) {
        if (line.toLowerCase().contains("killed by signal")) {
            return;
        }
        this.cmdError.add(line);
        if (this.isErrorMessage(line)) {
            this.hasFailed = true;
        }
        this.notificationHandler.logError(line);
    }

    public void commandCompleted(int exitCode) {
        this.exitCode = exitCode;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    @Override
    public final void commandFinished() {
        File f = this.getTempCommandFolder(false);
        if (f != null) {
            FileUtils.deleteRecursively((File)f);
        }
        this.notificationHandler.logCompleted("");
    }

    public boolean hasFailed() {
        return this.hasFailed;
    }

    public List<String> getCmdError() {
        return this.cmdError;
    }

    public void setException(Exception e) {
        this.thrownException = e;
    }

    public Exception getThrownException() {
        return this.thrownException;
    }

    protected void notify(Parser.Line line) {
    }

    protected boolean isErrorMessage(String s) {
        return true;
    }

    public String getStringCommand() {
        return SvnCommand.toString(this.arguments, false).toString();
    }

    String[] getCliArguments(String executable) {
        ArrayList<String> l = new ArrayList<String>(this.arguments.size() + 1);
        l.add(executable);
        for (String arg : this.arguments.toArray()) {
            l.add(arg);
        }
        return l.toArray(new String[0]);
    }

    private static StringBuilder toString(Arguments args, boolean scramble) {
        StringBuilder cmd = new StringBuilder(100);
        boolean psswd = false;
        for (String arg : args) {
            cmd.append(psswd && scramble ? "******" : arg);
            cmd.append(' ');
            if (!scramble) continue;
            psswd = arg.equals("--password");
        }
        cmd.delete(cmd.length() - 1, cmd.length());
        return cmd;
    }

    protected String createTempCommandFile(String value) throws IOException {
        return this.createTempCommandFile(new String[]{value});
    }

    protected String createTempCommandFile(File[] files) throws IOException {
        String[] lines = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            lines[i] = files[i].getAbsolutePath();
            if (files[i].getAbsolutePath().indexOf(64) == -1) continue;
            int n = i;
            lines[n] = lines[n] + '@';
        }
        return this.createTempCommandFile(lines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createTempCommandFile(String[] lines) throws IOException {
        File targetFile = Files.createTempFile(this.getTempCommandFolder(true).toPath(), "svn_", "", new FileAttribute[0]).toFile();
        targetFile.deleteOnExit();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(targetFile)));
            for (int i = 0; i < lines.length; ++i) {
                writer.print(i < lines.length - 1 ? lines[i] + "\n" : lines[i]);
            }
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        return targetFile.getAbsolutePath();
    }

    protected void config(File configDir, String username, String password, Arguments arguments) {
        arguments.addConfigDir(configDir);
        arguments.add("--non-interactive");
        arguments.addCredentials(username, password);
    }

    protected static SVNUrl encodeUrl(SVNUrl url) {
        try {
            url = SvnUtils.decodeAndEncodeUrl(url);
        }
        catch (MalformedURLException ex) {
            Subversion.LOG.log(Level.INFO, "Url: " + url, ex);
        }
        return url;
    }

    private File getTempCommandFolder(boolean forceCreation) {
        if (this.tmpFolder == null && forceCreation) {
            this.tmpFolder = Utils.getTempFolder((boolean)true);
        }
        return this.tmpFolder;
    }

    public final class Arguments
    implements Iterable<String> {
        private final List<String> args = new ArrayList<String>(5);

        public void add(String argument) {
            this.args.add(argument);
        }

        public void add(File ... files) {
            for (File file : files) {
                this.add(file);
            }
        }

        public void add(File file) {
            String absolutePath = file.getAbsolutePath();
            if (absolutePath.indexOf(64) == -1) {
                this.add(absolutePath);
            } else {
                this.add(absolutePath + '@');
            }
        }

        public void add(SVNUrl url) {
            if (url != null) {
                this.add(this.makeCliUrlString(url, true));
            }
        }

        public void addNonExistent(SVNUrl url) {
            if (url != null) {
                this.add(this.makeCliUrlString(url, false));
            }
        }

        public void add(SVNRevision rev1, SVNRevision rev2) {
            this.add("-r");
            this.add((rev1 == null || rev1.toString().trim().equals("") ? "HEAD" : rev1.toString()) + ":" + (rev2 == null || rev2.toString().trim().equals("") ? "HEAD" : rev2.toString()));
        }

        public void add(SVNUrl url, SVNRevision pegging) {
            if (url != null) {
                this.add(this.makeCliUrlString(url, pegging));
            }
        }

        public void add(SVNRevision revision) {
            this.add("-r");
            this.add(revision == null || revision.toString().trim().equals("") ? "HEAD" : revision.toString());
        }

        public void addPathArguments(String ... paths) throws IOException {
            this.add("--targets");
            this.add(SvnCommand.this.createTempCommandFile(paths));
        }

        public void addFileArguments(File ... files) throws IOException {
            this.add("--targets");
            this.add(SvnCommand.this.createTempCommandFile(files));
        }

        public void addUrlArguments(SVNUrl ... urls) throws IOException {
            String[] paths = new String[urls.length];
            for (int i = 0; i < urls.length; ++i) {
                paths[i] = this.makeCliUrlString(urls[i], true);
            }
            this.add("--targets");
            this.add(SvnCommand.this.createTempCommandFile(paths));
        }

        private String makeCliUrlString(SVNUrl url, boolean appendAtSign) {
            String cliUrlString = SvnCommand.encodeUrl(url).toString();
            if (appendAtSign) {
                for (String pathSegment : url.getPathSegments()) {
                    if (pathSegment.indexOf(64) == -1) continue;
                    cliUrlString = cliUrlString + '@';
                    break;
                }
            }
            return cliUrlString;
        }

        private String makeCliUrlString(SVNUrl url, SVNRevision pegRev) {
            return SvnCommand.encodeUrl(url).toString() + '@' + (pegRev == null ? "HEAD" : pegRev);
        }

        public void addMessage(String message) throws IOException {
            if (message == null) {
                return;
            }
            this.add("--force-log");
            this.add("-F");
            String msgFile = SvnCommand.this.createTempCommandFile(message != null ? message : "");
            this.add(msgFile);
        }

        public void addConfigDir(File configDir) {
            if (configDir != null) {
                SvnCommand.this.arguments.add("--config-dir");
                SvnCommand.this.arguments.add(configDir);
            }
        }

        public void addCredentials(String user, String psswd) {
            if (user == null || user.trim().equals("")) {
                return;
            }
            this.add("--username");
            this.add(user);
            if (psswd == null) {
                psswd = "";
            }
            if (Utilities.isWindows() && psswd.trim().equals("")) {
                psswd = "\"" + psswd + "\"";
            }
            this.add("--password");
            this.add(psswd);
        }

        @Override
        public Iterator<String> iterator() {
            return this.args.iterator();
        }

        String[] toArray() {
            return this.args.toArray(new String[0]);
        }

        int size() {
            return this.args.size();
        }
    }
}

