/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.websvc.rest.codegen.ClientStubsGenerator;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.TokenReplacer;
import org.netbeans.modules.websvc.rest.codegen.model.Method;
import org.netbeans.modules.websvc.rest.codegen.model.Resource;
import org.netbeans.modules.websvc.rest.codegen.model.RestEntity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class ResourceJavaScript
extends TokenReplacer {
    private static final String ENTITY_NAME_VAR = "entity_name";
    static final String RJSSUPPORT = "rjsSupport";
    private Resource resource;
    private FileObject jsFolder;
    private String pkg;
    private String object;
    private Map<String, String> entities;
    private Set<String> ignoredEntities;

    ResourceJavaScript(ClientStubsGenerator generator, Resource r, FileObject jsFolder, Set<String> existingEntities) {
        super(generator);
        this.ignoredEntities = existingEntities;
        this.resource = r;
        this.jsFolder = jsFolder;
        this.pkg = "";
        this.object = "";
        HashMap<String, String> tokens = new HashMap<String, String>();
        this.entities = new HashMap<String, String>();
        StringBuilder restMethods = new StringBuilder();
        StringBuilder stubsMethods = new StringBuilder();
        this.createRestMethods(this.resource, this.object, this.pkg, restMethods, stubsMethods);
        tokens.put("generic_name", this.resource.getName());
        tokens.put("rest_methods", restMethods.toString());
        tokens.put("stub_methods", stubsMethods.toString());
        this.setTokens(tokens);
    }

    public FileObject getFolder() {
        return this.jsFolder;
    }

    public FileObject generate() throws IOException {
        HashSet<String> entityFiles = new HashSet<String>();
        for (String entityName : this.entities.keySet()) {
            if (this.ignoredEntities.contains(entityName)) continue;
            HashMap<String, String> tokens = new HashMap<String, String>();
            tokens.put(ENTITY_NAME_VAR, entityName);
            FileObject entity = this.createResource("Templates/WebServices/JsEntity.js", entityName, tokens);
            entityFiles.add(entity.getName());
        }
        StringBuilder wsName = new StringBuilder(this.resource.getName());
        while (entityFiles.contains(wsName)) {
            wsName.append("REST");
        }
        this.resource.setEntities(entityFiles);
        FileObject fo = this.createResource("Templates/WebServices/JsStub.js", wsName.toString(), null);
        return fo;
    }

    private FileObject createResource(String templateName, String name, Map<String, String> tokens) throws IOException {
        String fileNameExt = name + "." + "js";
        FileObject fo = this.jsFolder.getFileObject(fileNameExt);
        if (fo != null) {
            if (this.getGenerator().canOverwrite()) {
                fo.delete();
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, NbBundle.getMessage(ClientStubsGenerator.class, (String)"MSG_SkippingStubGeneration", (Object)(this.jsFolder.getPath() + File.separator + fileNameExt)));
            }
        }
        fo = tokens == null ? this.getGenerator().createDataObjectFromTemplate(templateName, this.jsFolder, name, "js", this.getGenerator().canOverwrite(), this.getTokens()) : this.getGenerator().createDataObjectFromTemplate(templateName, this.jsFolder, name, "js", this.getGenerator().canOverwrite(), tokens);
        return fo;
    }

    protected void createRestMethods(Resource r, String object, String pkg, StringBuilder restMethods, StringBuilder stubMethods) {
        String rjSupport = "rjsSupport.";
        HashSet<String> methodNames = new HashSet<String>();
        HashMap<String, Method> httpMethods = new HashMap<String, Method>();
        for (Method method : r.getMethods()) {
            this.createStubMethod(method, rjSupport, pkg, methodNames, stubMethods);
            this.addMethodName(method.getName(), method, httpMethods);
        }
        for (Map.Entry entry : httpMethods.entrySet()) {
            String name = (String)entry.getKey();
            Method method = (Method)entry.getValue();
            this.createRestMethod(name, method, restMethods);
        }
        if (stubMethods.length() > 3) {
            stubMethods.delete(stubMethods.length() - 3, stubMethods.length());
        }
    }

    private void addMethodName(String name, Method method, Map<String, Method> methods) {
        Method stored = methods.get(name);
        if (stored == null) {
            methods.put(name, method);
        } else {
            String[] methodSplit;
            int methodLength;
            String storedPath = stored.getPath();
            String methodPath = method.getPath();
            String[] storedSplit = this.split(storedPath);
            int storedLength = storedSplit.length;
            if (storedLength == (methodLength = (methodSplit = this.split(methodPath)).length)) {
                name = name + method.getType().toString();
                methods.put(name, method);
            } else if (storedLength > methodLength) {
                methods.put(name, method);
                name = name + this.getPostfix(storedSplit);
                this.addMethodName(name, stored, methods);
            } else {
                name = name + this.getPostfix(methodSplit);
                this.addMethodName(name, method, methods);
            }
        }
    }

    private String[] split(String path) {
        String splitter = "/";
        String result = path;
        if (result == null) {
            return new String[0];
        }
        if (result.startsWith(splitter)) {
            result = result.substring(1);
        }
        if (result.endsWith(splitter)) {
            result = result.substring(0, result.length() - 1);
        }
        return result.split(splitter);
    }

    private String getPostfix(String[] path) {
        for (int i = 1; i <= path.length; ++i) {
            String part = path[path.length - i];
            String postfix = this.getPostfix(part);
            if (postfix == null) continue;
            return this.capitalize(postfix);
        }
        return "1";
    }

    private String capitalize(String str) {
        if (str == null || str.length() == 0 || str.length() == 1) {
            return str;
        }
        char first = str.charAt(0);
        return Character.toUpperCase(first) + str.substring(1);
    }

    private String getPostfix(String path) {
        String result = path.trim();
        if (result.length() == 0) {
            return null;
        }
        int index = result.indexOf(123);
        if (index == 0) {
            result = result.substring(1);
        } else if (index > 0) {
            result = result.substring(0, index);
        }
        index = result.indexOf(58);
        if (index != -1) {
            result = result.substring(0, index);
        } else {
            index = result.indexOf(125);
            if (index != -1) {
                result = result.substring(0, index);
            }
        }
        if (result.length() != 0 && Utilities.isJavaIdentifier((String)result)) {
            return result;
        }
        return null;
    }

    private void createRestMethod(String name, Method method, StringBuilder restMethods) {
        boolean jsonAware;
        Constants.HttpMethodType type = method.getType();
        String path = method.getPath();
        RestEntity returnType = method.getReturnType();
        RestEntity parameterType = method.getParameterType();
        List<String> requestMimes = method.getRequestMimes();
        List<String> responseMimes = method.getResponseMimes();
        boolean isDefault = false;
        if (type == Constants.HttpMethodType.GET && path == null && returnType.getKind() != RestEntity.EntityKind.VOID) {
            isDefault = true;
            this.createEntitiesMethod(restMethods, name, returnType, responseMimes);
        }
        boolean bl = jsonAware = responseMimes == null && requestMimes == null;
        if (!jsonAware) {
            if (responseMimes != null && responseMimes.contains(Constants.MimeType.JSON.value())) {
                jsonAware = true;
            }
            if (!jsonAware && requestMimes != null && requestMimes.contains(Constants.MimeType.JSON.value())) {
                jsonAware = true;
            }
        }
        if (jsonAware) {
            String returnEntity = this.addEntity(returnType, isDefault);
            String paramEntity = this.addEntity(parameterType, false);
            this.addComment(method, restMethods, type, path, returnType.getKind(), returnEntity, parameterType.getKind(), paramEntity);
            restMethods.append("   ");
            restMethods.append(name);
            restMethods.append(" : function(uri_");
            if (parameterType.getKind() != RestEntity.EntityKind.VOID) {
                restMethods.append(", param ");
            }
            restMethods.append(" ) {\n");
            restMethods.append("    var url = \"\";\n");
            restMethods.append("    if ( uri_ != null && uri_ !=undefined ){\n");
            restMethods.append("        url = uri_;\n");
            restMethods.append("    }\n");
            restMethods.append("    var  remote = new ");
            restMethods.append(this.resource.getName());
            restMethods.append("Remote(this.uri);\n");
            restMethods.append("    var  c= remote.");
            restMethods.append(method.getType().prefix());
            restMethods.append(Constants.MimeType.JSON.suffix());
            restMethods.append("_(url");
            if (parameterType.getKind() == RestEntity.EntityKind.PRIMITIVE) {
                restMethods.append(", param ");
            } else if (parameterType.getKind() == RestEntity.EntityKind.ENTITY || parameterType.getKind() == RestEntity.EntityKind.COLLECTION) {
                restMethods.append(", this.asString(param)");
            }
            restMethods.append(");\n");
            restMethods.append("    if ( c== -1 ){\n");
            restMethods.append("        return -1;\n");
            restMethods.append("    }\n");
            if (returnType.getKind() == RestEntity.EntityKind.VOID) {
                restMethods.append("   },\n\n");
                return;
            }
            if (returnType.getKind() == RestEntity.EntityKind.PRIMITIVE) {
                if (isDefault) {
                    restMethods.append("    return new ");
                    restMethods.append(returnEntity);
                    restMethods.append("( c );\n");
                } else {
                    restMethods.append("    return c;\n");
                }
                restMethods.append("   },\n\n");
                return;
            }
            restMethods.append("    var  myObj = eval('('+c+')');\n");
            if (returnType.getKind() == RestEntity.EntityKind.ENTITY) {
                restMethods.append("    if ( myObj['@uri'] != null && myObj['@uri']!= undefined ){\n");
                restMethods.append("       return new ");
                restMethods.append(returnEntity);
                restMethods.append("( myObj, myObj['@uri']);\n");
                restMethods.append("     }\n");
                restMethods.append("     else {\n");
                restMethods.append("       return new ");
                restMethods.append(returnEntity);
                restMethods.append("( myObj );\n");
                restMethods.append("     }\n");
            } else if (returnType.getKind() == RestEntity.EntityKind.COLLECTION) {
                restMethods.append("    var result = new Array();\n");
                restMethods.append("    for ( var prop in myObj ){\n");
                restMethods.append("       var ref= myObj[prop];\n");
                restMethods.append("       var j=0;\n");
                restMethods.append("       for( j=0; j<ref.length; j++){\n");
                restMethods.append("           if ( ref[j]['@uri'] != null && ref[j]['@uri']!= undefined ){\n");
                restMethods.append("               result[j] = new ");
                restMethods.append(returnEntity);
                restMethods.append("( ref[j], ref[j]['@uri']);\n");
                restMethods.append("           }\n");
                restMethods.append("           else {\n");
                restMethods.append("           result[j] = new ");
                restMethods.append(returnEntity);
                restMethods.append("( ref[j] );\n");
                restMethods.append("           }\n");
                restMethods.append("       }\n");
                restMethods.append("    }\n");
                restMethods.append("    return result;\n");
            }
            restMethods.append("   },\n\n");
        }
    }

    private String addEntity(RestEntity entity, boolean wrapPrimitive) {
        int index;
        String simpleName;
        String storedFqn;
        RestEntity.EntityKind kind = entity.getKind();
        if (kind == RestEntity.EntityKind.VOID || !wrapPrimitive && kind == RestEntity.EntityKind.PRIMITIVE) {
            return null;
        }
        String fqn = entity.getFqn();
        if (kind == RestEntity.EntityKind.PRIMITIVE) {
            fqn = String.class.getName();
        }
        if ((storedFqn = this.entities.get(simpleName = fqn.substring((index = fqn.lastIndexOf(46)) + 1))) != null && !storedFqn.equals(fqn)) {
            simpleName = fqn.replace('.', '_');
        }
        this.entities.put(simpleName, fqn);
        return simpleName;
    }

    private void addComment(Method method, StringBuilder restMethods, Constants.HttpMethodType type, String path, RestEntity.EntityKind returnKind, String returnType, RestEntity.EntityKind paramKind, String paramType) {
        restMethods.append("   /* Method ");
        restMethods.append(method.getName());
        restMethods.append(" with HTTP request metod ");
        restMethods.append((Object)type);
        if (path != null) {
            restMethods.append(" and path : ");
            restMethods.append(path);
        }
        if (returnType != null) {
            restMethods.append(", its return type is ");
            if (returnKind == RestEntity.EntityKind.COLLECTION) {
                restMethods.append("array of ");
            }
            restMethods.append(returnType);
        }
        if (paramType != null) {
            restMethods.append(", its parameter type is ");
            if (paramKind == RestEntity.EntityKind.COLLECTION) {
                restMethods.append("array of ");
            }
            restMethods.append(paramType);
        }
        restMethods.append("  */\n");
    }

    private void createEntitiesMethod(StringBuilder buffer, String restMethodName, RestEntity entity, List<String> mimes) {
        RestEntity.EntityKind kind = entity.getKind();
        if (mimes != null && !mimes.contains(Constants.MimeType.JSON.value())) {
            return;
        }
        buffer.append("   getEntities : function() {\n");
        if (kind == RestEntity.EntityKind.COLLECTION) {
            buffer.append("     return this.");
            buffer.append(restMethodName);
            buffer.append("(null);\n");
        } else {
            buffer.append("     var result = new Array();\n");
            buffer.append("     result[0] = this.");
            buffer.append(restMethodName);
            buffer.append("(null);\n");
            buffer.append("     return result;\n");
        }
        buffer.append("   },\n\n");
        this.resource.setDefaultGet();
    }

    private void createStubMethod(Method method, String object, String pkg, Set<String> names, StringBuilder stubMethods) {
        Constants.HttpMethodType type = method.getType();
        if (type == Constants.HttpMethodType.GET) {
            List<String> response = method.getResponseMimes();
            if (response == null) {
                response = Collections.singletonList(Constants.MimeType.XML.value());
            }
            for (String mime : response) {
                String stubMethodName = this.createMethodName(method, mime = mime.replace("\"", "").trim(), response.size());
                if (names.contains(stubMethodName)) continue;
                names.add(stubMethodName);
                stubMethods.append("   ");
                stubMethods.append(stubMethodName);
                stubMethods.append(" : function(uri_) {\n");
                stubMethods.append("   return ");
                stubMethods.append(object);
                stubMethods.append("get(this.uri+uri_, '");
                stubMethods.append(mime);
                stubMethods.append("');\n   },\n\n");
            }
        } else {
            String prefix = type.prefix();
            List<String> request = method.getRequestMimes();
            if (request == null) {
                request = Collections.singletonList(Constants.MimeType.XML.value());
            }
            for (String mime : request) {
                String stubMethodName = this.createMethodName(method, mime = mime.replace("\"", "").trim(), request.size());
                if (names.contains(stubMethodName)) continue;
                names.add(stubMethodName);
                stubMethods.append("   ");
                stubMethods.append(stubMethodName);
                stubMethods.append(" : function(uri_, content) {\n");
                stubMethods.append("   return ");
                stubMethods.append(object);
                stubMethods.append(prefix);
                stubMethods.append("(this.uri+uri_, '");
                stubMethods.append(mime);
                stubMethods.append("', content);\n   },\n\n");
            }
        }
    }

    private String createMethodName(Method method, String mimeType, int length) {
        if (length > 1) {
            for (Constants.MimeType mime : Constants.MimeType.values()) {
                if (!mime.value().equals(mimeType)) continue;
                return method.getType().prefix() + mime.suffix();
            }
        }
        return method.getType().prefix();
    }
}

