/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.spi.ImportantFilesImplementation;
import org.netbeans.modules.web.common.ui.Bundle;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.StatusDecorator;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class ImportantFiles {
    static final Logger LOGGER = Logger.getLogger(ImportantFiles.class.getName());

    private ImportantFiles() {
    }

    public static NodeFactory forHtml5Project() {
        return new ImportantFilesNodeFactory();
    }

    public static NodeFactory forPhpProject() {
        return new ImportantFilesNodeFactory();
    }

    private static final class ImportantFilesNodeFactory
    implements NodeFactory {
        private ImportantFilesNodeFactory() {
        }

        public NodeList<?> createNodes(Project project) {
            assert (project != null);
            return new ImportantFilesNodeList(project);
        }
    }

    private static final class FileInfoComparator
    implements Comparator<ImportantFilesImplementation.FileInfo> {
        private FileInfoComparator() {
        }

        @Override
        public int compare(ImportantFilesImplementation.FileInfo fileInfo1, ImportantFilesImplementation.FileInfo fileInfo2) {
            FileObject file1 = fileInfo1.getFile();
            FileObject file2 = fileInfo2.getFile();
            try {
                return DataFolder.SortMode.FOLDER_NAMES.compare((Object)DataObject.find((FileObject)file1), (Object)DataObject.find((FileObject)file2));
            }
            catch (DataObjectNotFoundException ex) {
                return file1.getNameExt().compareToIgnoreCase(file2.getNameExt());
            }
        }
    }

    private static final class ImportantFileNode
    extends FilterNode {
        private final ImportantFilesImplementation.FileInfo fileInfo;

        ImportantFileNode(ImportantFilesImplementation.FileInfo fileInfo) throws DataObjectNotFoundException {
            super(DataObject.find((FileObject)fileInfo.getFile()).getNodeDelegate());
            this.fileInfo = fileInfo;
        }

        public String getDisplayName() {
            String displayName = this.fileInfo.getDisplayName();
            if (displayName != null) {
                return displayName;
            }
            return super.getDisplayName();
        }

        public String getHtmlDisplayName() {
            String displayName = this.getDisplayName();
            assert (displayName != null) : this.fileInfo;
            StatusDecorator statusDecorator = this.getStatusDecorator();
            if (statusDecorator != null) {
                return statusDecorator.annotateNameHtml(displayName, Collections.singleton(this.fileInfo.getFile()));
            }
            return displayName;
        }

        public String getShortDescription() {
            String description = this.fileInfo.getDescription();
            if (description != null) {
                return description;
            }
            return super.getShortDescription();
        }

        @CheckForNull
        private StatusDecorator getStatusDecorator() {
            try {
                return this.fileInfo.getFile().getFileSystem().getDecorator();
            }
            catch (FileStateInvalidException ex) {
                LOGGER.log(Level.INFO, null, ex);
                return null;
            }
        }
    }

    private static final class ImportantFilesChildren
    extends Children.Keys<ImportantFilesImplementation.FileInfo> {
        private static final Logger LOGGER = Logger.getLogger(ImportantFilesChildren.class.getName());
        private final Lookup.Result<ImportantFilesImplementation> lookupResult;

        ImportantFilesChildren(Lookup.Result<ImportantFilesImplementation> lookupResult) {
            super(true);
            assert (lookupResult != null);
            this.lookupResult = lookupResult;
        }

        public boolean hasImportantFiles() {
            return !this.getImportantFiles().isEmpty();
        }

        private void refreshImportantFiles() {
            this.setKeys();
        }

        protected Node[] createNodes(ImportantFilesImplementation.FileInfo key) {
            assert (key != null);
            try {
                return new Node[]{new ImportantFileNode(key)};
            }
            catch (DataObjectNotFoundException ex) {
                LOGGER.log(Level.WARNING, null, ex);
                return new Node[0];
            }
        }

        protected void addNotify() {
            this.setKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptyList());
        }

        private void setKeys() {
            List<ImportantFilesImplementation.FileInfo> importantFiles = this.getImportantFiles();
            importantFiles.sort(new FileInfoComparator());
            this.setKeys(importantFiles);
        }

        private List<ImportantFilesImplementation.FileInfo> getImportantFiles() {
            LinkedHashSet importantFiles = new LinkedHashSet();
            for (ImportantFilesImplementation provider : this.lookupResult.allInstances()) {
                importantFiles.addAll(provider.getFiles());
            }
            return new ArrayList<ImportantFilesImplementation.FileInfo>(importantFiles);
        }
    }

    private static final class ImportantFilesNode
    extends AbstractNode {
        private static final String BADGE = "org/netbeans/modules/web/common/ui/resources/config-badge.gif";
        private final Node iconDelegate = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();

        ImportantFilesNode(Children children) {
            super(children);
        }

        public String getDisplayName() {
            return Bundle.ImportantFilesNode_name();
        }

        public Image getIcon(int type) {
            return ImageUtilities.mergeImages((Image)this.iconDelegate.getIcon(type), (Image)ImageUtilities.loadImage((String)BADGE), (int)7, (int)7);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }

    private static final class ImportantFilesNodeList
    implements NodeList<Object>,
    LookupListener,
    ChangeListener {
        private static final Object IMPORTANT_FILES_KEY = new Object();
        private static final RequestProcessor RP = new RequestProcessor(ImportantFilesNodeList.class);
        private final Lookup.Result<ImportantFilesImplementation> lookupResult;
        private final ImportantFilesChildren importantFilesChildren;
        private final RequestProcessor.Task refreshTask;
        final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private Node importantFilesNode;

        ImportantFilesNodeList(Project project) {
            assert (project != null);
            this.lookupResult = project.getLookup().lookupResult(ImportantFilesImplementation.class);
            this.importantFilesChildren = new ImportantFilesChildren(this.lookupResult);
            this.refreshTask = RP.create(new Runnable(){

                @Override
                public void run() {
                    this.stateChangedInternal();
                }
            });
        }

        public List<Object> keys() {
            if (!this.importantFilesChildren.hasImportantFiles()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(IMPORTANT_FILES_KEY);
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        public synchronized Node node(Object key) {
            assert (key == IMPORTANT_FILES_KEY) : "Unexpected key " + key;
            if (this.importantFilesNode == null) {
                this.importantFilesNode = new ImportantFilesNode((Children)this.importantFilesChildren);
            }
            return this.importantFilesNode;
        }

        public void addNotify() {
            this.lookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.lookupResult));
            for (ImportantFilesImplementation provider : this.lookupResult.allInstances()) {
                provider.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)provider));
            }
        }

        public void removeNotify() {
        }

        public void resultChanged(LookupEvent ev) {
            this.fireChange();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refreshTask.schedule(100);
        }

        void stateChangedInternal() {
            this.importantFilesChildren.refreshImportantFiles();
            this.fireChange();
        }

        private void fireChange() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    changeSupport.fireChange();
                }
            });
        }
    }
}

