/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug.ui.models;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.netbeans.lib.chrome_devtools_protocol.debugger.CallFrame;
import org.netbeans.modules.javascript.cdtdebug.CDTDebugger;
import org.netbeans.modules.javascript.cdtdebug.CDTScript;
import org.netbeans.modules.javascript.cdtdebug.ScriptsHandler;
import org.netbeans.modules.javascript.cdtdebug.ui.models.Bundle;
import org.netbeans.modules.javascript2.debug.ui.models.ViewModelSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.filesystems.FileObject;
import org.openide.util.datatransfer.PasteType;

public class DebuggingModel
extends ViewModelSupport
implements TreeModel,
ExtendedNodeModel {
    private static final String ICON_CALL_STACK = "org/netbeans/modules/debugger/resources/threadsView/call_stack_16.png";
    private static final String ICON_EMPTY = "org/netbeans/modules/debugger/resources/empty.gif";
    private static final Object DBG_RUNNING_NODE = new Object();
    private final CDTDebugger dbg;

    public DebuggingModel(ContextProvider contextProvider) {
        this.dbg = (CDTDebugger)contextProvider.lookupFirst(null, CDTDebugger.class);
        ChangeListener changeListener = new ChangeListener();
        this.dbg.addListener((CDTDebugger.Listener)changeListener);
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            if (this.dbg.isSuspended()) {
                List cs = this.dbg.getCurrentCallStack();
                if (cs != null) {
                    return cs.toArray();
                }
            } else {
                return new Object[]{DBG_RUNNING_NODE};
            }
            return EMPTY_CHILDREN;
        }
        throw new UnknownTypeException(parent);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof List) {
            return true;
        }
        if (node == DBG_RUNNING_NODE) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    public boolean canRename(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCopy(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(Object node) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(Object node) throws IOException, UnknownTypeException {
        return null;
    }

    public Transferable clipboardCut(Object node) throws IOException, UnknownTypeException {
        return null;
    }

    public PasteType[] getPasteTypes(Object node, Transferable t) throws UnknownTypeException {
        return null;
    }

    public void setName(Object node, String name) throws UnknownTypeException {
    }

    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        if (node instanceof CallFrame) {
            return ICON_CALL_STACK;
        }
        if (node == DBG_RUNNING_NODE) {
            return ICON_EMPTY;
        }
        throw new UnknownTypeException(node);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof CallFrame) {
            long column;
            long line;
            String scriptName;
            CallFrame cf = (CallFrame)node;
            Object translatedLocation = null;
            String thisName = cf.getThisObject().getClassName();
            if ("Object".equals(thisName) || "global".equals(thisName)) {
                thisName = null;
            }
            String functionName = cf.getFunctionName();
            if (translatedLocation != null) {
                scriptName = DebuggingModel.getScriptName(translatedLocation.getFile());
                line = translatedLocation.getLine() + 1;
                column = translatedLocation.getColumn() + 1;
            } else {
                scriptName = DebuggingModel.getScriptName(this.dbg.getScriptsHandler(), cf);
                line = cf.getLocation().getLineNumber() + 1;
                column = (cf.getLocation().getColumnNumber() != null ? cf.getLocation().getColumnNumber() : 0) + 1;
            }
            String text = (String)(thisName != null && !thisName.isEmpty() ? thisName + "." : "") + functionName + " (" + (scriptName != null ? scriptName : "?") + ":" + line + ":" + column + ")";
            return text;
        }
        if (node == DBG_RUNNING_NODE) {
            return Bundle.CTL_DebuggerRunning();
        }
        throw new UnknownTypeException(node);
    }

    static String getScriptName(ScriptsHandler scriptsHandler, CallFrame cf) {
        CDTScript script = scriptsHandler.getScript(cf.getLocation().getScriptId());
        if (script != null) {
            String urlString;
            String scriptName = urlString = script.getUrl();
            try {
                URI url = new URI(urlString);
                if (url.getPath() != null) {
                    scriptName = url.getPath();
                }
            }
            catch (URISyntaxException ex) {
                return urlString;
            }
            if (scriptName == null) {
                return null;
            }
            int i = scriptName.lastIndexOf(47);
            if (i < 0) {
                i = scriptName.lastIndexOf(92);
            }
            if (i > 0) {
                scriptName = scriptName.substring(i + 1);
            }
            return scriptName;
        }
        return null;
    }

    private static String getScriptName(FileObject fo) {
        return fo.getNameExt();
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not to be called.");
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof CallFrame) {
            CallFrame frame = (CallFrame)node;
            String text = frame.getFunctionName();
            if (text != null) {
                text = text.replace("\\n", "\n");
            }
            return text;
        }
        if (node == DBG_RUNNING_NODE) {
            return Bundle.CTL_DebuggerRunningDescr();
        }
        throw new UnknownTypeException(node);
    }

    private class ChangeListener
    implements CDTDebugger.Listener {
        private WeakReference<CallFrame> lastCurrentFrame = new WeakReference<Object>(null);

        public void notifySuspended(boolean suspended) {
            DebuggingModel.this.fireChangeEvent((ModelEvent)new ModelEvent.TreeChanged((Object)DebuggingModel.this));
        }

        public void notifyCurrentFrame(CallFrame cf) {
            CallFrame last = (CallFrame)this.lastCurrentFrame.get();
            if (last != null) {
                DebuggingModel.this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)DebuggingModel.this, (Object)last));
            }
            if (cf != null) {
                DebuggingModel.this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)DebuggingModel.this, (Object)cf));
            }
            this.lastCurrentFrame = new WeakReference<CallFrame>(cf);
        }

        public void notifyFinished() {
        }
    }
}

