/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.svg;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class Utils {
    public static BufferedImage createChestTilePattern(int tileSize, boolean transparent) {
        int patternSize = tileSize * 2;
        BufferedImage image = new BufferedImage(patternSize, patternSize, 2);
        Graphics2D g2d = image.createGraphics();
        Utils.drawSmallChestTilePattern(g2d, 0, 0, patternSize, patternSize, transparent);
        return image;
    }

    public static void drawChestTilePattern(Graphics g, Rectangle visibleRect, int tileSize, boolean transparent) {
        BufferedImage backgroundImage = Utils.createChestTilePattern(tileSize, transparent);
        int imgWidth = backgroundImage.getWidth();
        int imgHeight = backgroundImage.getHeight();
        for (int y = visibleRect.y; y < visibleRect.y + visibleRect.height; y += imgHeight) {
            for (int x = visibleRect.x; x < visibleRect.x + visibleRect.width; x += imgWidth) {
                g.drawImage(backgroundImage, x, y, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawSmallChestTilePattern(Graphics2D g2d, int x, int y, int width, int height, boolean transparentOverlay) {
        int tileSize = width / 2;
        try {
            for (int row = 0; row < 2; ++row) {
                for (int col = 0; col < 2; ++col) {
                    if ((row + col) % 2 == 0) {
                        g2d.setColor(Color.LIGHT_GRAY);
                    } else {
                        g2d.setColor(Color.WHITE);
                    }
                    g2d.fillRect(x + col * tileSize, y + row * tileSize, tileSize, tileSize);
                }
            }
            if (transparentOverlay) {
                g2d.setColor(new Color(0, 0, 0, 128));
                g2d.fillRect(x, y, width, height);
            }
        }
        finally {
            g2d.dispose();
        }
    }
}

