/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.icefaces;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.netbeans.modules.web.jsfapi.api.Attribute;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.Tag;
import org.netbeans.modules.web.jsfapi.api.TagFeature;
import org.netbeans.modules.web.jsfapi.spi.TagFeatureProvider;

public class IceFacesTagFeatureProvider
implements TagFeatureProvider {
    private static final String ICESOFT_COMPONENT_NAMESPACE = "http://www.icesoft.com/icefaces/component";
    private static final String ICEFACES_COMPONENT_NAMESPACE = "http://www.icefaces.org/icefaces/components";
    private static final String ICEFACES_CORE_NAMESPACE = "http://www.icefaces.org/icefaces/core";
    private static final String VALUE = "value";
    private static final String VAR = "var";

    public <T extends TagFeature> Collection<T> getFeatures(final Tag tag, Library library, Class<T> clazz) {
        IterableTag iterableTag;
        if (clazz.equals(TagFeature.IterableTagPattern.class) && (iterableTag = this.resolveIterableTag(library, tag)) != null) {
            return Collections.singleton((TagFeature)clazz.cast(new TagFeature.IterableTagPattern(){

                public Attribute getVariable() {
                    return tag.getAttribute(iterableTag.getVariableAttribute());
                }

                public Attribute getItems() {
                    return tag.getAttribute(iterableTag.getItemsAttribute());
                }
            }));
        }
        return Collections.emptyList();
    }

    private IterableTag resolveIterableTag(Library library, Tag tag) {
        String libraryNamespace = library.getNamespace();
        if (libraryNamespace == null) {
            return null;
        }
        for (IterableTag iterableTag : IterableTag.values()) {
            if (!Objects.equals(libraryNamespace, iterableTag.getNamespace()) || !Objects.equals(tag.getName(), iterableTag.getName())) continue;
            return iterableTag;
        }
        return null;
    }

    private static enum IterableTag {
        ICESOFT_COLUMNS("http://www.icesoft.com/icefaces/component", "columns", "value", "var"),
        ICESOFT_DATA_TABLE("http://www.icesoft.com/icefaces/component", "dataTable", "value", "var"),
        ICESOFT_TREE("http://www.icesoft.com/icefaces/component", "tree", "value", "var"),
        ICESOFT_REPEAT("http://www.icesoft.com/icefaces/component", "repeat", "value", "var"),
        ICEFACES_DATA_TABLE("http://www.icefaces.org/icefaces/components", "dataTable", "value", "var"),
        ICEFACES_LIST("http://www.icefaces.org/icefaces/components", "list", "value", "var"),
        ICEFACES_SCHEDULE("http://www.icefaces.org/icefaces/components", "schedule", "value", "var"),
        ICEFACES_TREE("http://www.icefaces.org/icefaces/components", "tree", "value", "var"),
        ICECORE_REPEAT("http://www.icefaces.org/icefaces/core", "repeat", "value", "var");

        private final String namespace;
        private final String name;
        private final String itemsAttribute;
        private final String variableAttribute;

        private IterableTag(String namespace, String name, String itemsAttribute, String variableAttribute) {
            this.namespace = namespace;
            this.name = name;
            this.itemsAttribute = itemsAttribute;
            this.variableAttribute = variableAttribute;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getItemsAttribute() {
            return this.itemsAttribute;
        }

        public String getVariableAttribute() {
            return this.variableAttribute;
        }
    }
}

