/*
 * Decompiled with CFR 0.152.
 */
package com.bda.controller;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import com.bda.controller.BaseEvent;

public final class MotionEvent
extends BaseEvent
implements Parcelable {
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    public static final int AXIS_Z = 11;
    public static final int AXIS_RZ = 14;
    public static final int AXIS_LTRIGGER = 17;
    public static final int AXIS_RTRIGGER = 18;
    public static final Parcelable.Creator<MotionEvent> CREATOR = new ParcelableCreator();
    final SparseArray<Float> mAxis;
    final SparseArray<Float> mPrecision;

    public MotionEvent(long eventTime, int deviceId, float x, float y, float z, float rz, float xPrecision, float yPrecision) {
        super(eventTime, deviceId);
        int axis = 4;
        this.mAxis = new SparseArray(4);
        this.mAxis.put(0, (Object)Float.valueOf(x));
        this.mAxis.put(1, (Object)Float.valueOf(y));
        this.mAxis.put(11, (Object)Float.valueOf(z));
        this.mAxis.put(14, (Object)Float.valueOf(rz));
        int precision = 2;
        this.mPrecision = new SparseArray(2);
        this.mPrecision.put(0, (Object)Float.valueOf(xPrecision));
        this.mPrecision.put(1, (Object)Float.valueOf(yPrecision));
    }

    public MotionEvent(long eventTime, int deviceId, int[] axisKey, float[] axisValue, int[] precisionKey, float[] precisionValue) {
        super(eventTime, deviceId);
        int axis = axisKey.length;
        this.mAxis = new SparseArray(axis);
        int index = 0;
        while (index < axis) {
            this.mAxis.put(axisKey[index], (Object)Float.valueOf(axisValue[index]));
            ++index;
        }
        int precision = precisionKey.length;
        this.mPrecision = new SparseArray(precision);
        int index2 = 0;
        while (index2 < precision) {
            this.mPrecision.put(precisionKey[index2], (Object)Float.valueOf(precisionValue[index2]));
            ++index2;
        }
    }

    MotionEvent(Parcel parcel) {
        super(parcel);
        int axis = parcel.readInt();
        this.mAxis = new SparseArray(axis);
        int index = 0;
        while (index < axis) {
            int key = parcel.readInt();
            float value = parcel.readFloat();
            this.mAxis.put(key, (Object)Float.valueOf(value));
            ++index;
        }
        int precision = parcel.readInt();
        this.mPrecision = new SparseArray(precision);
        int index2 = 0;
        while (index2 < axis) {
            int key = parcel.readInt();
            float value = parcel.readFloat();
            this.mPrecision.put(key, (Object)Float.valueOf(value));
            ++index2;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public final int findPointerIndex(int pointerId) {
        return -1;
    }

    public final float getAxisValue(int axis) {
        return this.getAxisValue(axis, 0);
    }

    public final float getAxisValue(int axis, int pointerIndex) {
        if (pointerIndex == 0) {
            return ((Float)this.mAxis.get(axis, (Object)Float.valueOf(0.0f))).floatValue();
        }
        return 0.0f;
    }

    public final int getPointerCount() {
        return 1;
    }

    public final int getPointerId(int pointerIndex) {
        return 0;
    }

    public final float getRawX() {
        return this.getX();
    }

    public final float getRawY() {
        return this.getY();
    }

    public final float getX() {
        return this.getAxisValue(0, 0);
    }

    public final float getX(int pointerIndex) {
        return this.getAxisValue(0, pointerIndex);
    }

    public final float getXPrecision() {
        return ((Float)this.mPrecision.get(0, (Object)Float.valueOf(0.0f))).floatValue();
    }

    public final float getY() {
        return this.getAxisValue(1, 0);
    }

    public final float getY(int pointerIndex) {
        return this.getAxisValue(1, pointerIndex);
    }

    public final float getYPrecision() {
        return ((Float)this.mPrecision.get(1, (Object)Float.valueOf(0.0f))).floatValue();
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        super.writeToParcel(parcel, flags);
        int axis = this.mAxis.size();
        parcel.writeInt(axis);
        int index = 0;
        while (index < axis) {
            parcel.writeInt(this.mAxis.keyAt(index));
            parcel.writeFloat(((Float)this.mAxis.valueAt(index)).floatValue());
            ++index;
        }
        int precision = this.mPrecision.size();
        parcel.writeInt(precision);
        int index2 = 0;
        while (index2 < precision) {
            parcel.writeInt(this.mPrecision.keyAt(index2));
            parcel.writeFloat(((Float)this.mPrecision.valueAt(index2)).floatValue());
            ++index2;
        }
    }

    static class ParcelableCreator
    implements Parcelable.Creator<MotionEvent> {
        ParcelableCreator() {
        }

        public MotionEvent createFromParcel(Parcel source) {
            return new MotionEvent(source);
        }

        public MotionEvent[] newArray(int size) {
            return new MotionEvent[size];
        }
    }
}

