// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/contentwarehouse/v1/document_link_service.proto

package contentwarehouse

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The state of a document-link.
type DocumentLink_State int32

const (
	// Unknown state of documentlink.
	DocumentLink_STATE_UNSPECIFIED DocumentLink_State = 0
	// The documentlink has both source and target documents detected.
	DocumentLink_ACTIVE DocumentLink_State = 1
	// Target document is deleted, and mark the documentlink as soft-deleted.
	DocumentLink_SOFT_DELETED DocumentLink_State = 2
)

// Enum value maps for DocumentLink_State.
var (
	DocumentLink_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "SOFT_DELETED",
	}
	DocumentLink_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"SOFT_DELETED":      2,
	}
)

func (x DocumentLink_State) Enum() *DocumentLink_State {
	p := new(DocumentLink_State)
	*p = x
	return p
}

func (x DocumentLink_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DocumentLink_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contentwarehouse_v1_document_link_service_proto_enumTypes[0].Descriptor()
}

func (DocumentLink_State) Type() protoreflect.EnumType {
	return &file_google_cloud_contentwarehouse_v1_document_link_service_proto_enumTypes[0]
}

func (x DocumentLink_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DocumentLink_State.Descriptor instead.
func (DocumentLink_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDescGZIP(), []int{4, 0}
}

// Response message for DocumentLinkService.ListLinkedTargets.
type ListLinkedTargetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target document-links.
	DocumentLinks []*DocumentLink `protobuf:"bytes,1,rep,name=document_links,json=documentLinks,proto3" json:"document_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListLinkedTargetsResponse) Reset() {
	*x = ListLinkedTargetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLinkedTargetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLinkedTargetsResponse) ProtoMessage() {}

func (x *ListLinkedTargetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLinkedTargetsResponse.ProtoReflect.Descriptor instead.
func (*ListLinkedTargetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDescGZIP(), []int{0}
}

func (x *ListLinkedTargetsResponse) GetDocumentLinks() []*DocumentLink {
	if x != nil {
		return x.DocumentLinks
	}
	return nil
}

func (x *ListLinkedTargetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for DocumentLinkService.ListLinkedTargets.
type ListLinkedTargetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the document, for which all target links are returned.
	// Format:
	// projects/{project_number}/locations/{location}/documents/{target_document_id}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The meta information collected about the document creator, used to enforce
	// access control for the service.
	RequestMetadata *RequestMetadata `protobuf:"bytes,2,opt,name=request_metadata,json=requestMetadata,proto3" json:"request_metadata,omitempty"`
}

func (x *ListLinkedTargetsRequest) Reset() {
	*x = ListLinkedTargetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLinkedTargetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLinkedTargetsRequest) ProtoMessage() {}

func (x *ListLinkedTargetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLinkedTargetsRequest.ProtoReflect.Descriptor instead.
func (*ListLinkedTargetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListLinkedTargetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListLinkedTargetsRequest) GetRequestMetadata() *RequestMetadata {
	if x != nil {
		return x.RequestMetadata
	}
	return nil
}

// Response message for DocumentLinkService.ListLinkedSources.
type ListLinkedSourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source document-links.
	DocumentLinks []*DocumentLink `protobuf:"bytes,1,rep,name=document_links,json=documentLinks,proto3" json:"document_links,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListLinkedSourcesResponse) Reset() {
	*x = ListLinkedSourcesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLinkedSourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLinkedSourcesResponse) ProtoMessage() {}

func (x *ListLinkedSourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLinkedSourcesResponse.ProtoReflect.Descriptor instead.
func (*ListLinkedSourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListLinkedSourcesResponse) GetDocumentLinks() []*DocumentLink {
	if x != nil {
		return x.DocumentLinks
	}
	return nil
}

func (x *ListLinkedSourcesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Response message for DocumentLinkService.ListLinkedSources.
type ListLinkedSourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the document, for which all source links are returned.
	// Format:
	// projects/{project_number}/locations/{location}/documents/{source_document_id}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of document-links to return. The service may return
	// fewer than this value.
	//
	// If unspecified, at most 50 document-links will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListLinkedSources` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListLinkedSources`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The meta information collected about the document creator, used to enforce
	// access control for the service.
	RequestMetadata *RequestMetadata `protobuf:"bytes,2,opt,name=request_metadata,json=requestMetadata,proto3" json:"request_metadata,omitempty"`
}

func (x *ListLinkedSourcesRequest) Reset() {
	*x = ListLinkedSourcesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLinkedSourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLinkedSourcesRequest) ProtoMessage() {}

func (x *ListLinkedSourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLinkedSourcesRequest.ProtoReflect.Descriptor instead.
func (*ListLinkedSourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListLinkedSourcesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListLinkedSourcesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListLinkedSourcesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListLinkedSourcesRequest) GetRequestMetadata() *RequestMetadata {
	if x != nil {
		return x.RequestMetadata
	}
	return nil
}

// A document-link between source and target document.
type DocumentLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of this document-link.
	// It is required that the parent derived form the name to be consistent with
	// the source document reference. Otherwise an exception will be thrown.
	// Format:
	// projects/{project_number}/locations/{location}/documents/{source_document_id}/documentLinks/{document_link_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Document references of the source document.
	SourceDocumentReference *DocumentReference `protobuf:"bytes,2,opt,name=source_document_reference,json=sourceDocumentReference,proto3" json:"source_document_reference,omitempty"`
	// Document references of the target document.
	TargetDocumentReference *DocumentReference `protobuf:"bytes,3,opt,name=target_document_reference,json=targetDocumentReference,proto3" json:"target_document_reference,omitempty"`
	// Description of this document-link.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The time when the documentLink is last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The time when the documentLink is created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The state of the documentlink. If target node has been deleted, the
	// link is marked as invalid. Removing a source node will result in removal
	// of all associated links.
	State DocumentLink_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.contentwarehouse.v1.DocumentLink_State" json:"state,omitempty"`
}

func (x *DocumentLink) Reset() {
	*x = DocumentLink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DocumentLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentLink) ProtoMessage() {}

func (x *DocumentLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentLink.ProtoReflect.Descriptor instead.
func (*DocumentLink) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDescGZIP(), []int{4}
}

func (x *DocumentLink) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DocumentLink) GetSourceDocumentReference() *DocumentReference {
	if x != nil {
		return x.SourceDocumentReference
	}
	return nil
}

func (x *DocumentLink) GetTargetDocumentReference() *DocumentReference {
	if x != nil {
		return x.TargetDocumentReference
	}
	return nil
}

func (x *DocumentLink) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *DocumentLink) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *DocumentLink) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DocumentLink) GetState() DocumentLink_State {
	if x != nil {
		return x.State
	}
	return DocumentLink_STATE_UNSPECIFIED
}

// Request message for DocumentLinkService.CreateDocumentLink.
type CreateDocumentLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent of the document-link to be created.
	// parent of document-link should be a document.
	// Format:
	// projects/{project_number}/locations/{location}/documents/{source_document_id}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Document links associated with the source documents (source_document_id).
	DocumentLink *DocumentLink `protobuf:"bytes,2,opt,name=document_link,json=documentLink,proto3" json:"document_link,omitempty"`
	// The meta information collected about the document creator, used to enforce
	// access control for the service.
	RequestMetadata *RequestMetadata `protobuf:"bytes,3,opt,name=request_metadata,json=requestMetadata,proto3" json:"request_metadata,omitempty"`
}

func (x *CreateDocumentLinkRequest) Reset() {
	*x = CreateDocumentLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDocumentLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDocumentLinkRequest) ProtoMessage() {}

func (x *CreateDocumentLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDocumentLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateDocumentLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDescGZIP(), []int{5}
}

func (x *CreateDocumentLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDocumentLinkRequest) GetDocumentLink() *DocumentLink {
	if x != nil {
		return x.DocumentLink
	}
	return nil
}

func (x *CreateDocumentLinkRequest) GetRequestMetadata() *RequestMetadata {
	if x != nil {
		return x.RequestMetadata
	}
	return nil
}

// Request message for DocumentLinkService.DeleteDocumentLink.
type DeleteDocumentLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the document-link to be deleted.
	// Format:
	// projects/{project_number}/locations/{location}/documents/{source_document_id}/documentLinks/{document_link_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The meta information collected about the document creator, used to enforce
	// access control for the service.
	RequestMetadata *RequestMetadata `protobuf:"bytes,2,opt,name=request_metadata,json=requestMetadata,proto3" json:"request_metadata,omitempty"`
}

func (x *DeleteDocumentLinkRequest) Reset() {
	*x = DeleteDocumentLinkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDocumentLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDocumentLinkRequest) ProtoMessage() {}

func (x *DeleteDocumentLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDocumentLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteDocumentLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteDocumentLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteDocumentLinkRequest) GetRequestMetadata() *RequestMetadata {
	if x != nil {
		return x.RequestMetadata
	}
	return nil
}

var File_google_cloud_contentwarehouse_v1_document_link_service_proto protoreflect.FileDescriptor

var file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75,
	0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73,
	0x65, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x9a, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x55, 0x0a, 0x0e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61,
	0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc2,
	0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65,
	0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5c, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x22, 0x9a, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x6e, 0x6b,
	0x65, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x55, 0x0a, 0x0e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xfe, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61,
	0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x5c, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x52, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x22, 0xc5, 0x05, 0x0a, 0x0c, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x69,
	0x6e, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x6f, 0x0a, 0x19, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x17,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x6f, 0x0a, 0x19, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x17, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4a,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x3c, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x4f, 0x46, 0x54, 0x5f, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x02, 0x3a, 0x8e, 0x01, 0xea, 0x41, 0x8a, 0x01, 0x0a,
	0x2c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x5a, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x7b, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x7b, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x7d, 0x22, 0x9d, 0x02, 0x0a, 0x19, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a,
	0x28, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x58, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77,
	0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x5c, 0x0a, 0x10, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65,
	0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xc3, 0x01, 0x0a, 0x19, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x5c, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x32,
	0xd7, 0x07, 0x0a, 0x13, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xdf, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74,
	0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x22, 0x3d,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x3a, 0x01, 0x2a,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xdf, 0x01, 0x0a, 0x11, 0x4c, 0x69,
	0x73, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42,
	0x22, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xe2, 0x01, 0x0a, 0x12,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x69,
	0x6e, 0x6b, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x22,
	0x5f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x22, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x14, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x12, 0xc1, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61,
	0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x56, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x49, 0x22, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x53, 0xca, 0x41, 0x1f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x94, 0x01, 0x0a, 0x24, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x42, 0x18, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x50,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x3b,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDescOnce sync.Once
	file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDescData = file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDesc
)

func file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDescGZIP() []byte {
	file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDescData)
	})
	return file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDescData
}

var file_google_cloud_contentwarehouse_v1_document_link_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_contentwarehouse_v1_document_link_service_proto_goTypes = []interface{}{
	(DocumentLink_State)(0),           // 0: google.cloud.contentwarehouse.v1.DocumentLink.State
	(*ListLinkedTargetsResponse)(nil), // 1: google.cloud.contentwarehouse.v1.ListLinkedTargetsResponse
	(*ListLinkedTargetsRequest)(nil),  // 2: google.cloud.contentwarehouse.v1.ListLinkedTargetsRequest
	(*ListLinkedSourcesResponse)(nil), // 3: google.cloud.contentwarehouse.v1.ListLinkedSourcesResponse
	(*ListLinkedSourcesRequest)(nil),  // 4: google.cloud.contentwarehouse.v1.ListLinkedSourcesRequest
	(*DocumentLink)(nil),              // 5: google.cloud.contentwarehouse.v1.DocumentLink
	(*CreateDocumentLinkRequest)(nil), // 6: google.cloud.contentwarehouse.v1.CreateDocumentLinkRequest
	(*DeleteDocumentLinkRequest)(nil), // 7: google.cloud.contentwarehouse.v1.DeleteDocumentLinkRequest
	(*RequestMetadata)(nil),           // 8: google.cloud.contentwarehouse.v1.RequestMetadata
	(*DocumentReference)(nil),         // 9: google.cloud.contentwarehouse.v1.DocumentReference
	(*timestamppb.Timestamp)(nil),     // 10: google.protobuf.Timestamp
	(*emptypb.Empty)(nil),             // 11: google.protobuf.Empty
}
var file_google_cloud_contentwarehouse_v1_document_link_service_proto_depIdxs = []int32{
	5,  // 0: google.cloud.contentwarehouse.v1.ListLinkedTargetsResponse.document_links:type_name -> google.cloud.contentwarehouse.v1.DocumentLink
	8,  // 1: google.cloud.contentwarehouse.v1.ListLinkedTargetsRequest.request_metadata:type_name -> google.cloud.contentwarehouse.v1.RequestMetadata
	5,  // 2: google.cloud.contentwarehouse.v1.ListLinkedSourcesResponse.document_links:type_name -> google.cloud.contentwarehouse.v1.DocumentLink
	8,  // 3: google.cloud.contentwarehouse.v1.ListLinkedSourcesRequest.request_metadata:type_name -> google.cloud.contentwarehouse.v1.RequestMetadata
	9,  // 4: google.cloud.contentwarehouse.v1.DocumentLink.source_document_reference:type_name -> google.cloud.contentwarehouse.v1.DocumentReference
	9,  // 5: google.cloud.contentwarehouse.v1.DocumentLink.target_document_reference:type_name -> google.cloud.contentwarehouse.v1.DocumentReference
	10, // 6: google.cloud.contentwarehouse.v1.DocumentLink.update_time:type_name -> google.protobuf.Timestamp
	10, // 7: google.cloud.contentwarehouse.v1.DocumentLink.create_time:type_name -> google.protobuf.Timestamp
	0,  // 8: google.cloud.contentwarehouse.v1.DocumentLink.state:type_name -> google.cloud.contentwarehouse.v1.DocumentLink.State
	5,  // 9: google.cloud.contentwarehouse.v1.CreateDocumentLinkRequest.document_link:type_name -> google.cloud.contentwarehouse.v1.DocumentLink
	8,  // 10: google.cloud.contentwarehouse.v1.CreateDocumentLinkRequest.request_metadata:type_name -> google.cloud.contentwarehouse.v1.RequestMetadata
	8,  // 11: google.cloud.contentwarehouse.v1.DeleteDocumentLinkRequest.request_metadata:type_name -> google.cloud.contentwarehouse.v1.RequestMetadata
	2,  // 12: google.cloud.contentwarehouse.v1.DocumentLinkService.ListLinkedTargets:input_type -> google.cloud.contentwarehouse.v1.ListLinkedTargetsRequest
	4,  // 13: google.cloud.contentwarehouse.v1.DocumentLinkService.ListLinkedSources:input_type -> google.cloud.contentwarehouse.v1.ListLinkedSourcesRequest
	6,  // 14: google.cloud.contentwarehouse.v1.DocumentLinkService.CreateDocumentLink:input_type -> google.cloud.contentwarehouse.v1.CreateDocumentLinkRequest
	7,  // 15: google.cloud.contentwarehouse.v1.DocumentLinkService.DeleteDocumentLink:input_type -> google.cloud.contentwarehouse.v1.DeleteDocumentLinkRequest
	1,  // 16: google.cloud.contentwarehouse.v1.DocumentLinkService.ListLinkedTargets:output_type -> google.cloud.contentwarehouse.v1.ListLinkedTargetsResponse
	3,  // 17: google.cloud.contentwarehouse.v1.DocumentLinkService.ListLinkedSources:output_type -> google.cloud.contentwarehouse.v1.ListLinkedSourcesResponse
	5,  // 18: google.cloud.contentwarehouse.v1.DocumentLinkService.CreateDocumentLink:output_type -> google.cloud.contentwarehouse.v1.DocumentLink
	11, // 19: google.cloud.contentwarehouse.v1.DocumentLinkService.DeleteDocumentLink:output_type -> google.protobuf.Empty
	16, // [16:20] is the sub-list for method output_type
	12, // [12:16] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_contentwarehouse_v1_document_link_service_proto_init() }
func file_google_cloud_contentwarehouse_v1_document_link_service_proto_init() {
	if File_google_cloud_contentwarehouse_v1_document_link_service_proto != nil {
		return
	}
	file_google_cloud_contentwarehouse_v1_common_proto_init()
	file_google_cloud_contentwarehouse_v1_document_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLinkedTargetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLinkedTargetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLinkedSourcesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLinkedSourcesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DocumentLink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDocumentLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDocumentLinkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_contentwarehouse_v1_document_link_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_contentwarehouse_v1_document_link_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_contentwarehouse_v1_document_link_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_contentwarehouse_v1_document_link_service_proto_msgTypes,
	}.Build()
	File_google_cloud_contentwarehouse_v1_document_link_service_proto = out.File
	file_google_cloud_contentwarehouse_v1_document_link_service_proto_rawDesc = nil
	file_google_cloud_contentwarehouse_v1_document_link_service_proto_goTypes = nil
	file_google_cloud_contentwarehouse_v1_document_link_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DocumentLinkServiceClient is the client API for DocumentLinkService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DocumentLinkServiceClient interface {
	// Return all target document-links from the document.
	ListLinkedTargets(ctx context.Context, in *ListLinkedTargetsRequest, opts ...grpc.CallOption) (*ListLinkedTargetsResponse, error)
	// Return all source document-links from the document.
	ListLinkedSources(ctx context.Context, in *ListLinkedSourcesRequest, opts ...grpc.CallOption) (*ListLinkedSourcesResponse, error)
	// Create a link between a source document and a target document.
	CreateDocumentLink(ctx context.Context, in *CreateDocumentLinkRequest, opts ...grpc.CallOption) (*DocumentLink, error)
	// Remove the link between the source and target documents.
	DeleteDocumentLink(ctx context.Context, in *DeleteDocumentLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type documentLinkServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDocumentLinkServiceClient(cc grpc.ClientConnInterface) DocumentLinkServiceClient {
	return &documentLinkServiceClient{cc}
}

func (c *documentLinkServiceClient) ListLinkedTargets(ctx context.Context, in *ListLinkedTargetsRequest, opts ...grpc.CallOption) (*ListLinkedTargetsResponse, error) {
	out := new(ListLinkedTargetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.contentwarehouse.v1.DocumentLinkService/ListLinkedTargets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentLinkServiceClient) ListLinkedSources(ctx context.Context, in *ListLinkedSourcesRequest, opts ...grpc.CallOption) (*ListLinkedSourcesResponse, error) {
	out := new(ListLinkedSourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.contentwarehouse.v1.DocumentLinkService/ListLinkedSources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentLinkServiceClient) CreateDocumentLink(ctx context.Context, in *CreateDocumentLinkRequest, opts ...grpc.CallOption) (*DocumentLink, error) {
	out := new(DocumentLink)
	err := c.cc.Invoke(ctx, "/google.cloud.contentwarehouse.v1.DocumentLinkService/CreateDocumentLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentLinkServiceClient) DeleteDocumentLink(ctx context.Context, in *DeleteDocumentLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.contentwarehouse.v1.DocumentLinkService/DeleteDocumentLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DocumentLinkServiceServer is the server API for DocumentLinkService service.
type DocumentLinkServiceServer interface {
	// Return all target document-links from the document.
	ListLinkedTargets(context.Context, *ListLinkedTargetsRequest) (*ListLinkedTargetsResponse, error)
	// Return all source document-links from the document.
	ListLinkedSources(context.Context, *ListLinkedSourcesRequest) (*ListLinkedSourcesResponse, error)
	// Create a link between a source document and a target document.
	CreateDocumentLink(context.Context, *CreateDocumentLinkRequest) (*DocumentLink, error)
	// Remove the link between the source and target documents.
	DeleteDocumentLink(context.Context, *DeleteDocumentLinkRequest) (*emptypb.Empty, error)
}

// UnimplementedDocumentLinkServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDocumentLinkServiceServer struct {
}

func (*UnimplementedDocumentLinkServiceServer) ListLinkedTargets(context.Context, *ListLinkedTargetsRequest) (*ListLinkedTargetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLinkedTargets not implemented")
}
func (*UnimplementedDocumentLinkServiceServer) ListLinkedSources(context.Context, *ListLinkedSourcesRequest) (*ListLinkedSourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLinkedSources not implemented")
}
func (*UnimplementedDocumentLinkServiceServer) CreateDocumentLink(context.Context, *CreateDocumentLinkRequest) (*DocumentLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDocumentLink not implemented")
}
func (*UnimplementedDocumentLinkServiceServer) DeleteDocumentLink(context.Context, *DeleteDocumentLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDocumentLink not implemented")
}

func RegisterDocumentLinkServiceServer(s *grpc.Server, srv DocumentLinkServiceServer) {
	s.RegisterService(&_DocumentLinkService_serviceDesc, srv)
}

func _DocumentLinkService_ListLinkedTargets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLinkedTargetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentLinkServiceServer).ListLinkedTargets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contentwarehouse.v1.DocumentLinkService/ListLinkedTargets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentLinkServiceServer).ListLinkedTargets(ctx, req.(*ListLinkedTargetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentLinkService_ListLinkedSources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLinkedSourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentLinkServiceServer).ListLinkedSources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contentwarehouse.v1.DocumentLinkService/ListLinkedSources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentLinkServiceServer).ListLinkedSources(ctx, req.(*ListLinkedSourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentLinkService_CreateDocumentLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDocumentLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentLinkServiceServer).CreateDocumentLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contentwarehouse.v1.DocumentLinkService/CreateDocumentLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentLinkServiceServer).CreateDocumentLink(ctx, req.(*CreateDocumentLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentLinkService_DeleteDocumentLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDocumentLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentLinkServiceServer).DeleteDocumentLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contentwarehouse.v1.DocumentLinkService/DeleteDocumentLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentLinkServiceServer).DeleteDocumentLink(ctx, req.(*DeleteDocumentLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DocumentLinkService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.contentwarehouse.v1.DocumentLinkService",
	HandlerType: (*DocumentLinkServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListLinkedTargets",
			Handler:    _DocumentLinkService_ListLinkedTargets_Handler,
		},
		{
			MethodName: "ListLinkedSources",
			Handler:    _DocumentLinkService_ListLinkedSources_Handler,
		},
		{
			MethodName: "CreateDocumentLink",
			Handler:    _DocumentLinkService_CreateDocumentLink_Handler,
		},
		{
			MethodName: "DeleteDocumentLink",
			Handler:    _DocumentLinkService_DeleteDocumentLink_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/contentwarehouse/v1/document_link_service.proto",
}
