package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// ListGlobalMalwareRequest Request Object
type ListGlobalMalwareRequest struct {

	// Region ID
	Region string `json:"region"`

	// 主机所属的企业项目ID。 开通企业项目功能后才需要配置企业项目。 企业项目ID默认取值为“0”，表示默认企业项目。如果需要查询所有企业项目下的主机，请传参“all_granted_eps”。如果您只有某个企业项目的权限，则需要传递该企业项目ID，查询该企业项目下的主机，否则会因权限不足而报错。
	EnterpriseProjectId *string `json:"enterprise_project_id,omitempty"`

	// 镜像类型，包含如下:   - registry : 仓库镜像   - cicd : cicd镜像
	ImageType string `json:"image_type"`

	// 文件名称（支持模糊查询）
	FileName *string `json:"file_name,omitempty"`

	// 默认10
	Limit *int32 `json:"limit,omitempty"`

	// 默认0
	Offset *int32 `json:"offset,omitempty"`
}

func (o ListGlobalMalwareRequest) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ListGlobalMalwareRequest struct{}"
	}

	return strings.Join([]string{"ListGlobalMalwareRequest", string(data)}, " ")
}
