/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.stack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFileKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterError;
import org.jetbrains.kotlin.ir.interpreter.stack.SubFrame;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0000\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0000J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u0004\u0018\u00010\fJ\u001d\u0010\u001f\u001a\u00020\u00152\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00150!H\u0082\bJ\u001a\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020%0$0#H\u0002J\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020'H\u0002J\u0006\u0010)\u001a\u00020\u0017J\u0006\u0010*\u001a\u00020\u0017J\u000e\u0010+\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010-\u001a\u0004\u0018\u00010,J\u0006\u0010.\u001a\u00020\fJ\u0006\u0010/\u001a\u00020,J\u000e\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020\fJ\u000e\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u00020,J\u0006\u00104\u001a\u00020\u0015J\u0006\u00105\u001a\u00020\u0015J\u0016\u00106\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00107\u001a\u00020,J\u0016\u00108\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00109\u001a\u00020%J\u0018\u00108\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\b\u00103\u001a\u0004\u0018\u00010,J\b\u0010:\u001a\u00020'H\u0016R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/stack/Frame;", "", "subFrameOwner", "Lorg/jetbrains/kotlin/ir/IrElement;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "currentFrame", "Lorg/jetbrains/kotlin/ir/interpreter/stack/SubFrame;", "getCurrentFrame", "()Lorg/jetbrains/kotlin/ir/interpreter/stack/SubFrame;", "currentInstruction", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "currentSubFrameOwner", "getCurrentSubFrameOwner", "()Lorg/jetbrains/kotlin/ir/IrElement;", "innerStack", "Lkotlin/collections/ArrayDeque;", "getIrFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "addSubFrame", "", "containsStateInMemory", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "copyMemoryInto", "newFrame", "closure", "Lorg/jetbrains/kotlin/ir/interpreter/state/StateWithClosure;", "dropInstructions", "forEachSubFrame", "block", "Lkotlin/Function1;", "getAll", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "getFileAndPositionInfo", "", "getLineNumberForCurrentInstruction", "hasNoInstructions", "hasNoSubFrames", "loadState", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "peekState", "popInstruction", "popState", "pushInstruction", "instruction", "pushState", "state", "removeSubFrame", "removeSubFrameWithoutDataPropagation", "rewriteState", "newState", "storeState", "variable", "toString", "Companion", "ir.interpreter"})
public final class Frame {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final IrFile irFile;
    @NotNull
    private final ArrayDeque<SubFrame> innerStack;
    @Nullable
    private Instruction currentInstruction;
    @NotNull
    public static final String NOT_DEFINED = "Not defined";

    /*
     * WARNING - void declaration
     */
    public Frame(@NotNull IrElement subFrameOwner, @Nullable IrFile irFile) {
        void $this$innerStack_u24lambda_u2d0;
        ArrayDeque arrayDeque;
        Intrinsics.checkNotNullParameter(subFrameOwner, "subFrameOwner");
        this.irFile = irFile;
        ArrayDeque arrayDeque2 = arrayDeque = new ArrayDeque();
        Frame frame = this;
        boolean bl = false;
        $this$innerStack_u24lambda_u2d0.add(new SubFrame(subFrameOwner));
        frame.innerStack = arrayDeque;
    }

    public /* synthetic */ Frame(IrElement irElement, IrFile irFile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            irFile = null;
        }
        this(irElement, irFile);
    }

    @Nullable
    public final IrFile getIrFile() {
        return this.irFile;
    }

    private final SubFrame getCurrentFrame() {
        return this.innerStack.last();
    }

    @NotNull
    public final IrElement getCurrentSubFrameOwner() {
        return this.getCurrentFrame().getOwner();
    }

    public final void addSubFrame(@NotNull IrElement subFrameOwner) {
        Intrinsics.checkNotNullParameter(subFrameOwner, "subFrameOwner");
        this.innerStack.add(new SubFrame(subFrameOwner));
    }

    public final void removeSubFrame() {
        State state = this.getCurrentFrame().peekState();
        this.removeSubFrameWithoutDataPropagation();
        if (!this.hasNoSubFrames() && state != null) {
            this.getCurrentFrame().pushState(state);
        }
    }

    public final void removeSubFrameWithoutDataPropagation() {
        this.innerStack.removeLast();
    }

    public final boolean hasNoSubFrames() {
        return this.innerStack.isEmpty();
    }

    public final boolean hasNoInstructions() {
        return this.hasNoSubFrames() || this.innerStack.size() == 1 && this.innerStack.first().isEmpty();
    }

    public final void pushInstruction(@NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter(instruction, "instruction");
        this.getCurrentFrame().pushInstruction(instruction);
    }

    @NotNull
    public final Instruction popInstruction() {
        Instruction instruction;
        Instruction $this$popInstruction_u24lambda_u2d1 = instruction = this.getCurrentFrame().popInstruction();
        boolean bl = false;
        this.currentInstruction = $this$popInstruction_u24lambda_u2d1;
        return instruction;
    }

    @Nullable
    public final Instruction dropInstructions() {
        return this.getCurrentFrame().dropInstructions();
    }

    public final void pushState(@NotNull State state) {
        Intrinsics.checkNotNullParameter(state, "state");
        this.getCurrentFrame().pushState(state);
    }

    @NotNull
    public final State popState() {
        return this.getCurrentFrame().popState();
    }

    @Nullable
    public final State peekState() {
        return this.getCurrentFrame().peekState();
    }

    public final void storeState(@NotNull IrSymbol symbol2, @Nullable State state) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        this.getCurrentFrame().storeState(symbol2, state);
    }

    public final void storeState(@NotNull IrSymbol symbol2, @NotNull Variable variable2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        Intrinsics.checkNotNullParameter(variable2, "variable");
        this.getCurrentFrame().storeState(symbol2, variable2);
    }

    @NotNull
    public final State loadState(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        Frame this_$iv = this;
        boolean $i$f$forEachSubFrame = false;
        Iterable $this$forEach$iv$iv = RangesKt.downTo(CollectionsKt.getLastIndex((List)this_$iv.innerStack), 0);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv$iv;
            int it$iv = element$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            SubFrame it = this_$iv.innerStack.get(it$iv);
            boolean bl2 = false;
            State state = it.loadState(symbol2);
            if (state == null) continue;
            State state2 = state;
            boolean bl3 = false;
            return state2;
        }
        throw new InterpreterError(symbol2 + " not found");
    }

    public final void rewriteState(@NotNull IrSymbol symbol2, @NotNull State newState) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        Intrinsics.checkNotNullParameter(newState, "newState");
        Frame this_$iv = this;
        boolean $i$f$forEachSubFrame = false;
        Iterable $this$forEach$iv$iv = RangesKt.downTo(CollectionsKt.getLastIndex((List)this_$iv.innerStack), 0);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv$iv;
            int it$iv = element$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            SubFrame it = this_$iv.innerStack.get(it$iv);
            boolean bl2 = false;
            if (!it.containsStateInMemory(symbol2)) continue;
            it.rewriteState(symbol2, newState);
            return;
        }
    }

    public final boolean containsStateInMemory(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        Frame this_$iv = this;
        boolean $i$f$forEachSubFrame = false;
        Iterable $this$forEach$iv$iv = RangesKt.downTo(CollectionsKt.getLastIndex((List)this_$iv.innerStack), 0);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv$iv;
            int it$iv = element$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            SubFrame it = this_$iv.innerStack.get(it$iv);
            boolean bl2 = false;
            if (!it.containsStateInMemory(symbol2)) continue;
            return true;
        }
        return false;
    }

    public final void copyMemoryInto(@NotNull Frame newFrame2) {
        Intrinsics.checkNotNullParameter(newFrame2, "newFrame");
        Iterable $this$forEach$iv = this.getAll();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            IrSymbol symbol2 = (IrSymbol)pair.component1();
            Variable variable2 = (Variable)pair.component2();
            if (newFrame2.containsStateInMemory(symbol2)) continue;
            newFrame2.storeState(symbol2, variable2);
        }
    }

    public final void copyMemoryInto(@NotNull StateWithClosure closure) {
        Intrinsics.checkNotNullParameter(closure, "closure");
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)this.getAll());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            IrSymbol symbol2 = (IrSymbol)pair.component1();
            Variable variable2 = (Variable)pair.component2();
            closure.getUpValues().put(symbol2, variable2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<IrSymbol, Variable>> getAll() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.innerStack;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SubFrame it = (SubFrame)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getAll();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String getLineNumberForCurrentInstruction() {
        if (this.irFile == null) {
            return "";
        }
        Instruction instruction = this.currentInstruction;
        IrElement frameOwner = instruction != null ? instruction.getElement() : null;
        return frameOwner instanceof IrExpression || frameOwner instanceof IrDeclaration && Intrinsics.areEqual(((IrDeclaration)frameOwner).getOrigin(), IrDeclarationOrigin.DEFINED.INSTANCE) ? "" + ':' + (this.irFile.getFileEntry().getLineNumber(frameOwner.getStartOffset()) + 1) : "";
    }

    @NotNull
    public final String getFileAndPositionInfo() {
        if (this.irFile == null) {
            return NOT_DEFINED;
        }
        String lineNum = this.getLineNumberForCurrentInstruction();
        return IrFileKt.getName(this.irFile) + lineNum;
    }

    @NotNull
    public String toString() {
        Object v0;
        String fileNameCapitalized;
        block3: {
            if (this.irFile == null) {
                return NOT_DEFINED;
            }
            fileNameCapitalized = CapitalizeDecapitalizeKt.capitalizeAsciiOnly(StringsKt.replace$default(IrFileKt.getName(this.irFile), ".kt", "Kt", false, 4, null));
            Iterable $this$firstOrNull$iv = this.innerStack;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SubFrame it = (SubFrame)element$iv;
                boolean bl = false;
                if (!(it.getOwner() instanceof IrFunction)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        SubFrame subFrame = v0;
        IrElement irElement = subFrame != null ? subFrame.getOwner() : null;
        IrFunction entryPoint = irElement instanceof IrFunction ? (IrFunction)irElement : null;
        String lineNum = this.getLineNumberForCurrentInstruction();
        StringBuilder stringBuilder2 = new StringBuilder().append("at ").append(fileNameCapitalized).append('.');
        Object object = entryPoint;
        if (object == null || (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) == null) {
            object = "<clinit>";
        }
        return stringBuilder2.append(object).append('(').append(IrFileKt.getName(this.irFile)).append(lineNum).append(')').toString();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/stack/Frame$Companion;", "", "()V", "NOT_DEFINED", "", "ir.interpreter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

