/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.errorprone.SubContext;
import com.google.errorprone.refaster.Bindings;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.ImportPolicy;
import com.google.errorprone.refaster.Inlineable;
import com.google.errorprone.refaster.URepeated;
import com.google.errorprone.refaster.UTypeVar;
import com.google.errorprone.util.ASTHelpers;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class Inliner {
    private final Context context;
    private final Set<String> importsToAdd;
    private final Set<String> staticImportsToAdd;
    public final Bindings bindings;
    private final Map<String, Type.TypeVar> typeVarCache;
    private static final Types.SimpleVisitor<JCTree.JCExpression, Inliner> INLINE_AS_TREE = new Types.SimpleVisitor<JCTree.JCExpression, Inliner>(){

        @Override
        public JCTree.JCExpression visitType(Type t, Inliner inliner) {
            return inliner.maker().Type(t);
        }

        @Override
        public JCTree.JCExpression visitClassType(Type.ClassType type, Inliner inliner) {
            Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)type.tsym;
            JCTree.JCExpression classExpr = inliner.importPolicy().classReference(inliner, ASTHelpers.outermostClass((Symbol)classSym).getQualifiedName().toString(), classSym.getQualifiedName().toString());
            List<JCTree.JCExpression> argExprs = List.nil();
            for (Type argType : type.getTypeArguments()) {
                argExprs = argExprs.append((JCTree.JCExpression)this.visit(argType, inliner));
            }
            return argExprs.isEmpty() ? classExpr : inliner.maker().TypeApply(classExpr, argExprs);
        }

        @Override
        public JCTree.JCExpression visitWildcardType(Type.WildcardType type, Inliner inliner) {
            TreeMaker maker = inliner.maker();
            return maker.Wildcard(maker.TypeBoundKind(type.kind), (JCTree)this.visit(type.type, inliner));
        }

        @Override
        public JCTree.JCExpression visitArrayType(Type.ArrayType type, Inliner inliner) {
            return inliner.maker().TypeArray((JCTree.JCExpression)this.visit(type.getComponentType(), inliner));
        }
    };

    public Inliner(Context context, Bindings bindings) {
        this.context = new SubContext(context);
        this.bindings = new Bindings(bindings).unmodifiable();
        this.importsToAdd = Sets.newHashSet();
        this.staticImportsToAdd = Sets.newHashSet();
        this.typeVarCache = Maps.newHashMap();
    }

    public void addImport(String qualifiedImport) {
        if (!qualifiedImport.startsWith("java.lang")) {
            this.importsToAdd.add(qualifiedImport);
        }
    }

    public void addStaticImport(String qualifiedImport) {
        this.staticImportsToAdd.add(qualifiedImport);
    }

    public Symbol.ClassSymbol resolveClass(CharSequence qualifiedClass) throws CouldNotResolveImportException {
        try {
            Symbol symbol = JavaCompiler.instance(this.context).resolveBinaryNameOrIdent(qualifiedClass.toString());
            if (symbol.equals(this.symtab().errSymbol) || !(symbol instanceof Symbol.ClassSymbol)) {
                throw new CouldNotResolveImportException(qualifiedClass);
            }
            return (Symbol.ClassSymbol)symbol;
        }
        catch (NullPointerException e) {
            throw new CouldNotResolveImportException(qualifiedClass);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public Types types() {
        return Types.instance(this.context);
    }

    public Symtab symtab() {
        return Symtab.instance(this.context);
    }

    public Enter enter() {
        return Enter.instance(this.context);
    }

    public Names names() {
        return Names.instance(this.context);
    }

    public TreeMaker maker() {
        return TreeMaker.instance(this.context);
    }

    public Infer infer() {
        return Infer.instance(this.context);
    }

    public ImportPolicy importPolicy() {
        return ImportPolicy.instance(this.context);
    }

    public Name asName(CharSequence str) {
        return this.names().fromString(str.toString());
    }

    public JCTree.JCExpression inlineAsTree(Type type) {
        return (JCTree.JCExpression)INLINE_AS_TREE.visit(type, this);
    }

    public <V> V getBinding(Bindings.Key<V> key) {
        V value = this.bindings.getBinding(key);
        if (value == null) {
            throw new IllegalStateException("No binding for " + key);
        }
        return value;
    }

    public <V> Optional<V> getOptionalBinding(Bindings.Key<V> key) {
        return Optional.fromNullable(this.bindings.getBinding(key));
    }

    public <R> List<R> inlineList(Iterable<? extends Inlineable<? extends R>> elements) throws CouldNotResolveImportException {
        ListBuffer<JCTree.JCExpression> result = new ListBuffer<JCTree.JCExpression>();
        for (Inlineable<R> e : elements) {
            if (e instanceof URepeated) {
                URepeated repeated = (URepeated)e;
                Iterator<JCTree.JCExpression> iterator = this.getBinding(repeated.key()).iterator();
                while (iterator.hasNext()) {
                    JCTree.JCExpression expr;
                    JCTree.JCExpression r = expr = iterator.next();
                    result.append(r);
                }
                continue;
            }
            result.append((JCTree.JCExpression)e.inline(this));
        }
        return result.toList();
    }

    public ImmutableSet<String> getImportsToAdd() {
        return ImmutableSet.copyOf(this.importsToAdd);
    }

    public ImmutableSet<String> getStaticImportsToAdd() {
        return ImmutableSet.copyOf(this.staticImportsToAdd);
    }

    public Type.TypeVar inlineAsVar(UTypeVar var) throws CouldNotResolveImportException {
        Type.TypeVar typeVar = this.typeVarCache.get(var.getName());
        if (typeVar != null) {
            return typeVar;
        }
        Name name = this.asName(var.getName());
        Symbol.TypeVariableSymbol sym = new Symbol.TypeVariableSymbol(0L, name, null, this.symtab().noSymbol);
        typeVar = new Type.TypeVar(sym, null, this.symtab().botType);
        sym.type = typeVar;
        this.typeVarCache.put(var.getName(), typeVar);
        typeVar.setUpperBound((Type)var.getUpperBound().inline(this));
        typeVar.lower = (Type)var.getLowerBound().inline(this);
        return typeVar;
    }

    Type inlineTypeVar(UTypeVar var) throws CouldNotResolveImportException {
        Optional<UTypeVar.TypeWithExpression> typeVarBinding = this.getOptionalBinding(var.key());
        if (typeVarBinding.isPresent()) {
            return ((UTypeVar.TypeWithExpression)typeVarBinding.get()).type();
        }
        return this.inlineAsVar(var);
    }
}

