/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class StringLiteral
implements Matcher<ExpressionTree> {
    private final Predicate<String> matcher;

    public StringLiteral(String value) {
        this.matcher = value::equals;
    }

    public StringLiteral(Pattern pattern) {
        this.matcher = pattern.asPredicate();
    }

    @Override
    public boolean matches(ExpressionTree expressionTree, VisitorState state) {
        if (expressionTree instanceof LiteralTree) {
            LiteralTree literalTree = (LiteralTree)expressionTree;
            Object actualValue = literalTree.getValue();
            return actualValue instanceof String && this.matcher.test((String)actualValue);
        }
        return false;
    }
}

