// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/cloud/securitycenter/v2/vulnerability.proto

package securitycenterpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The possible values of impact of the vulnerability if it was to be
// exploited.
type Cve_RiskRating int32

const (
	// Invalid or empty value.
	Cve_RISK_RATING_UNSPECIFIED Cve_RiskRating = 0
	// Exploitation would have little to no security impact.
	Cve_LOW Cve_RiskRating = 1
	// Exploitation would enable attackers to perform activities, or could allow
	// attackers to have a direct impact, but would require additional steps.
	Cve_MEDIUM Cve_RiskRating = 2
	// Exploitation would enable attackers to have a notable direct impact
	// without needing to overcome any major mitigating factors.
	Cve_HIGH Cve_RiskRating = 3
	// Exploitation would fundamentally undermine the security of affected
	// systems, enable actors to perform significant attacks with minimal
	// effort, with little to no mitigating factors to overcome.
	Cve_CRITICAL Cve_RiskRating = 4
)

// Enum value maps for Cve_RiskRating.
var (
	Cve_RiskRating_name = map[int32]string{
		0: "RISK_RATING_UNSPECIFIED",
		1: "LOW",
		2: "MEDIUM",
		3: "HIGH",
		4: "CRITICAL",
	}
	Cve_RiskRating_value = map[string]int32{
		"RISK_RATING_UNSPECIFIED": 0,
		"LOW":                     1,
		"MEDIUM":                  2,
		"HIGH":                    3,
		"CRITICAL":                4,
	}
)

func (x Cve_RiskRating) Enum() *Cve_RiskRating {
	p := new(Cve_RiskRating)
	*p = x
	return p
}

func (x Cve_RiskRating) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cve_RiskRating) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_enumTypes[0].Descriptor()
}

func (Cve_RiskRating) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_vulnerability_proto_enumTypes[0]
}

func (x Cve_RiskRating) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cve_RiskRating.Descriptor instead.
func (Cve_RiskRating) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescGZIP(), []int{1, 0}
}

// The possible values of exploitation activity of the vulnerability in the
// wild.
type Cve_ExploitationActivity int32

const (
	// Invalid or empty value.
	Cve_EXPLOITATION_ACTIVITY_UNSPECIFIED Cve_ExploitationActivity = 0
	// Exploitation has been reported or confirmed to widely occur.
	Cve_WIDE Cve_ExploitationActivity = 1
	// Limited reported or confirmed exploitation activities.
	Cve_CONFIRMED Cve_ExploitationActivity = 2
	// Exploit is publicly available.
	Cve_AVAILABLE Cve_ExploitationActivity = 3
	// No known exploitation activity, but has a high potential for
	// exploitation.
	Cve_ANTICIPATED Cve_ExploitationActivity = 4
	// No known exploitation activity.
	Cve_NO_KNOWN Cve_ExploitationActivity = 5
)

// Enum value maps for Cve_ExploitationActivity.
var (
	Cve_ExploitationActivity_name = map[int32]string{
		0: "EXPLOITATION_ACTIVITY_UNSPECIFIED",
		1: "WIDE",
		2: "CONFIRMED",
		3: "AVAILABLE",
		4: "ANTICIPATED",
		5: "NO_KNOWN",
	}
	Cve_ExploitationActivity_value = map[string]int32{
		"EXPLOITATION_ACTIVITY_UNSPECIFIED": 0,
		"WIDE":                              1,
		"CONFIRMED":                         2,
		"AVAILABLE":                         3,
		"ANTICIPATED":                       4,
		"NO_KNOWN":                          5,
	}
)

func (x Cve_ExploitationActivity) Enum() *Cve_ExploitationActivity {
	p := new(Cve_ExploitationActivity)
	*p = x
	return p
}

func (x Cve_ExploitationActivity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cve_ExploitationActivity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_enumTypes[1].Descriptor()
}

func (Cve_ExploitationActivity) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_vulnerability_proto_enumTypes[1]
}

func (x Cve_ExploitationActivity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cve_ExploitationActivity.Descriptor instead.
func (Cve_ExploitationActivity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescGZIP(), []int{1, 1}
}

// This metric reflects the context by which vulnerability exploitation is
// possible.
type Cvssv3_AttackVector int32

const (
	// Invalid value.
	Cvssv3_ATTACK_VECTOR_UNSPECIFIED Cvssv3_AttackVector = 0
	// The vulnerable component is bound to the network stack and the set of
	// possible attackers extends beyond the other options listed below, up to
	// and including the entire Internet.
	Cvssv3_ATTACK_VECTOR_NETWORK Cvssv3_AttackVector = 1
	// The vulnerable component is bound to the network stack, but the attack is
	// limited at the protocol level to a logically adjacent topology.
	Cvssv3_ATTACK_VECTOR_ADJACENT Cvssv3_AttackVector = 2
	// The vulnerable component is not bound to the network stack and the
	// attacker's path is via read/write/execute capabilities.
	Cvssv3_ATTACK_VECTOR_LOCAL Cvssv3_AttackVector = 3
	// The attack requires the attacker to physically touch or manipulate the
	// vulnerable component.
	Cvssv3_ATTACK_VECTOR_PHYSICAL Cvssv3_AttackVector = 4
)

// Enum value maps for Cvssv3_AttackVector.
var (
	Cvssv3_AttackVector_name = map[int32]string{
		0: "ATTACK_VECTOR_UNSPECIFIED",
		1: "ATTACK_VECTOR_NETWORK",
		2: "ATTACK_VECTOR_ADJACENT",
		3: "ATTACK_VECTOR_LOCAL",
		4: "ATTACK_VECTOR_PHYSICAL",
	}
	Cvssv3_AttackVector_value = map[string]int32{
		"ATTACK_VECTOR_UNSPECIFIED": 0,
		"ATTACK_VECTOR_NETWORK":     1,
		"ATTACK_VECTOR_ADJACENT":    2,
		"ATTACK_VECTOR_LOCAL":       3,
		"ATTACK_VECTOR_PHYSICAL":    4,
	}
)

func (x Cvssv3_AttackVector) Enum() *Cvssv3_AttackVector {
	p := new(Cvssv3_AttackVector)
	*p = x
	return p
}

func (x Cvssv3_AttackVector) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cvssv3_AttackVector) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_enumTypes[2].Descriptor()
}

func (Cvssv3_AttackVector) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_vulnerability_proto_enumTypes[2]
}

func (x Cvssv3_AttackVector) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cvssv3_AttackVector.Descriptor instead.
func (Cvssv3_AttackVector) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescGZIP(), []int{3, 0}
}

// This metric describes the conditions beyond the attacker's control that
// must exist in order to exploit the vulnerability.
type Cvssv3_AttackComplexity int32

const (
	// Invalid value.
	Cvssv3_ATTACK_COMPLEXITY_UNSPECIFIED Cvssv3_AttackComplexity = 0
	// Specialized access conditions or extenuating circumstances do not exist.
	// An attacker can expect repeatable success when attacking the vulnerable
	// component.
	Cvssv3_ATTACK_COMPLEXITY_LOW Cvssv3_AttackComplexity = 1
	// A successful attack depends on conditions beyond the attacker's control.
	// That is, a successful attack cannot be accomplished at will, but requires
	// the attacker to invest in some measurable amount of effort in preparation
	// or execution against the vulnerable component before a successful attack
	// can be expected.
	Cvssv3_ATTACK_COMPLEXITY_HIGH Cvssv3_AttackComplexity = 2
)

// Enum value maps for Cvssv3_AttackComplexity.
var (
	Cvssv3_AttackComplexity_name = map[int32]string{
		0: "ATTACK_COMPLEXITY_UNSPECIFIED",
		1: "ATTACK_COMPLEXITY_LOW",
		2: "ATTACK_COMPLEXITY_HIGH",
	}
	Cvssv3_AttackComplexity_value = map[string]int32{
		"ATTACK_COMPLEXITY_UNSPECIFIED": 0,
		"ATTACK_COMPLEXITY_LOW":         1,
		"ATTACK_COMPLEXITY_HIGH":        2,
	}
)

func (x Cvssv3_AttackComplexity) Enum() *Cvssv3_AttackComplexity {
	p := new(Cvssv3_AttackComplexity)
	*p = x
	return p
}

func (x Cvssv3_AttackComplexity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cvssv3_AttackComplexity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_enumTypes[3].Descriptor()
}

func (Cvssv3_AttackComplexity) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_vulnerability_proto_enumTypes[3]
}

func (x Cvssv3_AttackComplexity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cvssv3_AttackComplexity.Descriptor instead.
func (Cvssv3_AttackComplexity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescGZIP(), []int{3, 1}
}

// This metric describes the level of privileges an attacker must possess
// before successfully exploiting the vulnerability.
type Cvssv3_PrivilegesRequired int32

const (
	// Invalid value.
	Cvssv3_PRIVILEGES_REQUIRED_UNSPECIFIED Cvssv3_PrivilegesRequired = 0
	// The attacker is unauthorized prior to attack, and therefore does not
	// require any access to settings or files of the vulnerable system to
	// carry out an attack.
	Cvssv3_PRIVILEGES_REQUIRED_NONE Cvssv3_PrivilegesRequired = 1
	// The attacker requires privileges that provide basic user capabilities
	// that could normally affect only settings and files owned by a user.
	// Alternatively, an attacker with Low privileges has the ability to access
	// only non-sensitive resources.
	Cvssv3_PRIVILEGES_REQUIRED_LOW Cvssv3_PrivilegesRequired = 2
	// The attacker requires privileges that provide significant (e.g.,
	// administrative) control over the vulnerable component allowing access to
	// component-wide settings and files.
	Cvssv3_PRIVILEGES_REQUIRED_HIGH Cvssv3_PrivilegesRequired = 3
)

// Enum value maps for Cvssv3_PrivilegesRequired.
var (
	Cvssv3_PrivilegesRequired_name = map[int32]string{
		0: "PRIVILEGES_REQUIRED_UNSPECIFIED",
		1: "PRIVILEGES_REQUIRED_NONE",
		2: "PRIVILEGES_REQUIRED_LOW",
		3: "PRIVILEGES_REQUIRED_HIGH",
	}
	Cvssv3_PrivilegesRequired_value = map[string]int32{
		"PRIVILEGES_REQUIRED_UNSPECIFIED": 0,
		"PRIVILEGES_REQUIRED_NONE":        1,
		"PRIVILEGES_REQUIRED_LOW":         2,
		"PRIVILEGES_REQUIRED_HIGH":        3,
	}
)

func (x Cvssv3_PrivilegesRequired) Enum() *Cvssv3_PrivilegesRequired {
	p := new(Cvssv3_PrivilegesRequired)
	*p = x
	return p
}

func (x Cvssv3_PrivilegesRequired) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cvssv3_PrivilegesRequired) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_enumTypes[4].Descriptor()
}

func (Cvssv3_PrivilegesRequired) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_vulnerability_proto_enumTypes[4]
}

func (x Cvssv3_PrivilegesRequired) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cvssv3_PrivilegesRequired.Descriptor instead.
func (Cvssv3_PrivilegesRequired) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescGZIP(), []int{3, 2}
}

// This metric captures the requirement for a human user, other than the
// attacker, to participate in the successful compromise of the vulnerable
// component.
type Cvssv3_UserInteraction int32

const (
	// Invalid value.
	Cvssv3_USER_INTERACTION_UNSPECIFIED Cvssv3_UserInteraction = 0
	// The vulnerable system can be exploited without interaction from any user.
	Cvssv3_USER_INTERACTION_NONE Cvssv3_UserInteraction = 1
	// Successful exploitation of this vulnerability requires a user to take
	// some action before the vulnerability can be exploited.
	Cvssv3_USER_INTERACTION_REQUIRED Cvssv3_UserInteraction = 2
)

// Enum value maps for Cvssv3_UserInteraction.
var (
	Cvssv3_UserInteraction_name = map[int32]string{
		0: "USER_INTERACTION_UNSPECIFIED",
		1: "USER_INTERACTION_NONE",
		2: "USER_INTERACTION_REQUIRED",
	}
	Cvssv3_UserInteraction_value = map[string]int32{
		"USER_INTERACTION_UNSPECIFIED": 0,
		"USER_INTERACTION_NONE":        1,
		"USER_INTERACTION_REQUIRED":    2,
	}
)

func (x Cvssv3_UserInteraction) Enum() *Cvssv3_UserInteraction {
	p := new(Cvssv3_UserInteraction)
	*p = x
	return p
}

func (x Cvssv3_UserInteraction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cvssv3_UserInteraction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_enumTypes[5].Descriptor()
}

func (Cvssv3_UserInteraction) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_vulnerability_proto_enumTypes[5]
}

func (x Cvssv3_UserInteraction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cvssv3_UserInteraction.Descriptor instead.
func (Cvssv3_UserInteraction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescGZIP(), []int{3, 3}
}

// The Scope metric captures whether a vulnerability in one vulnerable
// component impacts resources in components beyond its security scope.
type Cvssv3_Scope int32

const (
	// Invalid value.
	Cvssv3_SCOPE_UNSPECIFIED Cvssv3_Scope = 0
	// An exploited vulnerability can only affect resources managed by the same
	// security authority.
	Cvssv3_SCOPE_UNCHANGED Cvssv3_Scope = 1
	// An exploited vulnerability can affect resources beyond the security scope
	// managed by the security authority of the vulnerable component.
	Cvssv3_SCOPE_CHANGED Cvssv3_Scope = 2
)

// Enum value maps for Cvssv3_Scope.
var (
	Cvssv3_Scope_name = map[int32]string{
		0: "SCOPE_UNSPECIFIED",
		1: "SCOPE_UNCHANGED",
		2: "SCOPE_CHANGED",
	}
	Cvssv3_Scope_value = map[string]int32{
		"SCOPE_UNSPECIFIED": 0,
		"SCOPE_UNCHANGED":   1,
		"SCOPE_CHANGED":     2,
	}
)

func (x Cvssv3_Scope) Enum() *Cvssv3_Scope {
	p := new(Cvssv3_Scope)
	*p = x
	return p
}

func (x Cvssv3_Scope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cvssv3_Scope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_enumTypes[6].Descriptor()
}

func (Cvssv3_Scope) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_vulnerability_proto_enumTypes[6]
}

func (x Cvssv3_Scope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cvssv3_Scope.Descriptor instead.
func (Cvssv3_Scope) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescGZIP(), []int{3, 4}
}

// The Impact metrics capture the effects of a successfully exploited
// vulnerability on the component that suffers the worst outcome that is most
// directly and predictably associated with the attack.
type Cvssv3_Impact int32

const (
	// Invalid value.
	Cvssv3_IMPACT_UNSPECIFIED Cvssv3_Impact = 0
	// High impact.
	Cvssv3_IMPACT_HIGH Cvssv3_Impact = 1
	// Low impact.
	Cvssv3_IMPACT_LOW Cvssv3_Impact = 2
	// No impact.
	Cvssv3_IMPACT_NONE Cvssv3_Impact = 3
)

// Enum value maps for Cvssv3_Impact.
var (
	Cvssv3_Impact_name = map[int32]string{
		0: "IMPACT_UNSPECIFIED",
		1: "IMPACT_HIGH",
		2: "IMPACT_LOW",
		3: "IMPACT_NONE",
	}
	Cvssv3_Impact_value = map[string]int32{
		"IMPACT_UNSPECIFIED": 0,
		"IMPACT_HIGH":        1,
		"IMPACT_LOW":         2,
		"IMPACT_NONE":        3,
	}
)

func (x Cvssv3_Impact) Enum() *Cvssv3_Impact {
	p := new(Cvssv3_Impact)
	*p = x
	return p
}

func (x Cvssv3_Impact) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cvssv3_Impact) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_enumTypes[7].Descriptor()
}

func (Cvssv3_Impact) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_vulnerability_proto_enumTypes[7]
}

func (x Cvssv3_Impact) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cvssv3_Impact.Descriptor instead.
func (Cvssv3_Impact) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescGZIP(), []int{3, 5}
}

// Refers to common vulnerability fields e.g. cve, cvss, cwe etc.
type Vulnerability struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CVE stands for Common Vulnerabilities and Exposures
	// (https://cve.mitre.org/about/)
	Cve *Cve `protobuf:"bytes,1,opt,name=cve,proto3" json:"cve,omitempty"`
	// The offending package is relevant to the finding.
	OffendingPackage *Package `protobuf:"bytes,2,opt,name=offending_package,json=offendingPackage,proto3" json:"offending_package,omitempty"`
	// The fixed package is relevant to the finding.
	FixedPackage *Package `protobuf:"bytes,3,opt,name=fixed_package,json=fixedPackage,proto3" json:"fixed_package,omitempty"`
	// The security bulletin is relevant to this finding.
	SecurityBulletin *SecurityBulletin `protobuf:"bytes,4,opt,name=security_bulletin,json=securityBulletin,proto3" json:"security_bulletin,omitempty"`
}

func (x *Vulnerability) Reset() {
	*x = Vulnerability{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Vulnerability) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Vulnerability) ProtoMessage() {}

func (x *Vulnerability) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Vulnerability.ProtoReflect.Descriptor instead.
func (*Vulnerability) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescGZIP(), []int{0}
}

func (x *Vulnerability) GetCve() *Cve {
	if x != nil {
		return x.Cve
	}
	return nil
}

func (x *Vulnerability) GetOffendingPackage() *Package {
	if x != nil {
		return x.OffendingPackage
	}
	return nil
}

func (x *Vulnerability) GetFixedPackage() *Package {
	if x != nil {
		return x.FixedPackage
	}
	return nil
}

func (x *Vulnerability) GetSecurityBulletin() *SecurityBulletin {
	if x != nil {
		return x.SecurityBulletin
	}
	return nil
}

// CVE stands for Common Vulnerabilities and Exposures.
// Information from the [CVE
// record](https://www.cve.org/ResourcesSupport/Glossary) that describes this
// vulnerability.
type Cve struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier for the vulnerability. e.g. CVE-2021-34527
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Additional information about the CVE.
	// e.g. https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
	References []*Reference `protobuf:"bytes,2,rep,name=references,proto3" json:"references,omitempty"`
	// Describe Common Vulnerability Scoring System specified at
	// https://www.first.org/cvss/v3.1/specification-document
	Cvssv3 *Cvssv3 `protobuf:"bytes,3,opt,name=cvssv3,proto3" json:"cvssv3,omitempty"`
	// Whether upstream fix is available for the CVE.
	UpstreamFixAvailable bool `protobuf:"varint,4,opt,name=upstream_fix_available,json=upstreamFixAvailable,proto3" json:"upstream_fix_available,omitempty"`
	// The potential impact of the vulnerability if it was to be exploited.
	Impact Cve_RiskRating `protobuf:"varint,5,opt,name=impact,proto3,enum=google.cloud.securitycenter.v2.Cve_RiskRating" json:"impact,omitempty"`
	// The exploitation activity of the vulnerability in the wild.
	ExploitationActivity Cve_ExploitationActivity `protobuf:"varint,6,opt,name=exploitation_activity,json=exploitationActivity,proto3,enum=google.cloud.securitycenter.v2.Cve_ExploitationActivity" json:"exploitation_activity,omitempty"`
	// Whether or not the vulnerability has been observed in the wild.
	ObservedInTheWild bool `protobuf:"varint,7,opt,name=observed_in_the_wild,json=observedInTheWild,proto3" json:"observed_in_the_wild,omitempty"`
	// Whether or not the vulnerability was zero day when the finding was
	// published.
	ZeroDay bool `protobuf:"varint,8,opt,name=zero_day,json=zeroDay,proto3" json:"zero_day,omitempty"`
}

func (x *Cve) Reset() {
	*x = Cve{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cve) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cve) ProtoMessage() {}

func (x *Cve) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cve.ProtoReflect.Descriptor instead.
func (*Cve) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescGZIP(), []int{1}
}

func (x *Cve) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Cve) GetReferences() []*Reference {
	if x != nil {
		return x.References
	}
	return nil
}

func (x *Cve) GetCvssv3() *Cvssv3 {
	if x != nil {
		return x.Cvssv3
	}
	return nil
}

func (x *Cve) GetUpstreamFixAvailable() bool {
	if x != nil {
		return x.UpstreamFixAvailable
	}
	return false
}

func (x *Cve) GetImpact() Cve_RiskRating {
	if x != nil {
		return x.Impact
	}
	return Cve_RISK_RATING_UNSPECIFIED
}

func (x *Cve) GetExploitationActivity() Cve_ExploitationActivity {
	if x != nil {
		return x.ExploitationActivity
	}
	return Cve_EXPLOITATION_ACTIVITY_UNSPECIFIED
}

func (x *Cve) GetObservedInTheWild() bool {
	if x != nil {
		return x.ObservedInTheWild
	}
	return false
}

func (x *Cve) GetZeroDay() bool {
	if x != nil {
		return x.ZeroDay
	}
	return false
}

// Additional Links
type Reference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source of the reference e.g. NVD
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Uri for the mentioned source e.g.
	// https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *Reference) Reset() {
	*x = Reference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Reference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Reference) ProtoMessage() {}

func (x *Reference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Reference.ProtoReflect.Descriptor instead.
func (*Reference) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescGZIP(), []int{2}
}

func (x *Reference) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *Reference) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Common Vulnerability Scoring System version 3.
type Cvssv3 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The base score is a function of the base metric scores.
	BaseScore float64 `protobuf:"fixed64,1,opt,name=base_score,json=baseScore,proto3" json:"base_score,omitempty"`
	// Base Metrics
	// Represents the intrinsic characteristics of a vulnerability that are
	// constant over time and across user environments.
	// This metric reflects the context by which vulnerability exploitation is
	// possible.
	AttackVector Cvssv3_AttackVector `protobuf:"varint,2,opt,name=attack_vector,json=attackVector,proto3,enum=google.cloud.securitycenter.v2.Cvssv3_AttackVector" json:"attack_vector,omitempty"`
	// This metric describes the conditions beyond the attacker's control that
	// must exist in order to exploit the vulnerability.
	AttackComplexity Cvssv3_AttackComplexity `protobuf:"varint,3,opt,name=attack_complexity,json=attackComplexity,proto3,enum=google.cloud.securitycenter.v2.Cvssv3_AttackComplexity" json:"attack_complexity,omitempty"`
	// This metric describes the level of privileges an attacker must possess
	// before successfully exploiting the vulnerability.
	PrivilegesRequired Cvssv3_PrivilegesRequired `protobuf:"varint,4,opt,name=privileges_required,json=privilegesRequired,proto3,enum=google.cloud.securitycenter.v2.Cvssv3_PrivilegesRequired" json:"privileges_required,omitempty"`
	// This metric captures the requirement for a human user, other than the
	// attacker, to participate in the successful compromise of the vulnerable
	// component.
	UserInteraction Cvssv3_UserInteraction `protobuf:"varint,5,opt,name=user_interaction,json=userInteraction,proto3,enum=google.cloud.securitycenter.v2.Cvssv3_UserInteraction" json:"user_interaction,omitempty"`
	// The Scope metric captures whether a vulnerability in one vulnerable
	// component impacts resources in components beyond its security scope.
	Scope Cvssv3_Scope `protobuf:"varint,6,opt,name=scope,proto3,enum=google.cloud.securitycenter.v2.Cvssv3_Scope" json:"scope,omitempty"`
	// This metric measures the impact to the confidentiality of the information
	// resources managed by a software component due to a successfully exploited
	// vulnerability.
	ConfidentialityImpact Cvssv3_Impact `protobuf:"varint,7,opt,name=confidentiality_impact,json=confidentialityImpact,proto3,enum=google.cloud.securitycenter.v2.Cvssv3_Impact" json:"confidentiality_impact,omitempty"`
	// This metric measures the impact to integrity of a successfully exploited
	// vulnerability.
	IntegrityImpact Cvssv3_Impact `protobuf:"varint,8,opt,name=integrity_impact,json=integrityImpact,proto3,enum=google.cloud.securitycenter.v2.Cvssv3_Impact" json:"integrity_impact,omitempty"`
	// This metric measures the impact to the availability of the impacted
	// component resulting from a successfully exploited vulnerability.
	AvailabilityImpact Cvssv3_Impact `protobuf:"varint,9,opt,name=availability_impact,json=availabilityImpact,proto3,enum=google.cloud.securitycenter.v2.Cvssv3_Impact" json:"availability_impact,omitempty"`
}

func (x *Cvssv3) Reset() {
	*x = Cvssv3{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cvssv3) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cvssv3) ProtoMessage() {}

func (x *Cvssv3) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cvssv3.ProtoReflect.Descriptor instead.
func (*Cvssv3) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescGZIP(), []int{3}
}

func (x *Cvssv3) GetBaseScore() float64 {
	if x != nil {
		return x.BaseScore
	}
	return 0
}

func (x *Cvssv3) GetAttackVector() Cvssv3_AttackVector {
	if x != nil {
		return x.AttackVector
	}
	return Cvssv3_ATTACK_VECTOR_UNSPECIFIED
}

func (x *Cvssv3) GetAttackComplexity() Cvssv3_AttackComplexity {
	if x != nil {
		return x.AttackComplexity
	}
	return Cvssv3_ATTACK_COMPLEXITY_UNSPECIFIED
}

func (x *Cvssv3) GetPrivilegesRequired() Cvssv3_PrivilegesRequired {
	if x != nil {
		return x.PrivilegesRequired
	}
	return Cvssv3_PRIVILEGES_REQUIRED_UNSPECIFIED
}

func (x *Cvssv3) GetUserInteraction() Cvssv3_UserInteraction {
	if x != nil {
		return x.UserInteraction
	}
	return Cvssv3_USER_INTERACTION_UNSPECIFIED
}

func (x *Cvssv3) GetScope() Cvssv3_Scope {
	if x != nil {
		return x.Scope
	}
	return Cvssv3_SCOPE_UNSPECIFIED
}

func (x *Cvssv3) GetConfidentialityImpact() Cvssv3_Impact {
	if x != nil {
		return x.ConfidentialityImpact
	}
	return Cvssv3_IMPACT_UNSPECIFIED
}

func (x *Cvssv3) GetIntegrityImpact() Cvssv3_Impact {
	if x != nil {
		return x.IntegrityImpact
	}
	return Cvssv3_IMPACT_UNSPECIFIED
}

func (x *Cvssv3) GetAvailabilityImpact() Cvssv3_Impact {
	if x != nil {
		return x.AvailabilityImpact
	}
	return Cvssv3_IMPACT_UNSPECIFIED
}

// Package is a generic definition of a package.
type Package struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the package where the vulnerability was detected.
	PackageName string `protobuf:"bytes,1,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	// The CPE URI where the vulnerability was detected.
	CpeUri string `protobuf:"bytes,2,opt,name=cpe_uri,json=cpeUri,proto3" json:"cpe_uri,omitempty"`
	// Type of package, for example, os, maven, or go.
	PackageType string `protobuf:"bytes,3,opt,name=package_type,json=packageType,proto3" json:"package_type,omitempty"`
	// The version of the package.
	PackageVersion string `protobuf:"bytes,4,opt,name=package_version,json=packageVersion,proto3" json:"package_version,omitempty"`
}

func (x *Package) Reset() {
	*x = Package{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Package) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Package) ProtoMessage() {}

func (x *Package) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Package.ProtoReflect.Descriptor instead.
func (*Package) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescGZIP(), []int{4}
}

func (x *Package) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

func (x *Package) GetCpeUri() string {
	if x != nil {
		return x.CpeUri
	}
	return ""
}

func (x *Package) GetPackageType() string {
	if x != nil {
		return x.PackageType
	}
	return ""
}

func (x *Package) GetPackageVersion() string {
	if x != nil {
		return x.PackageVersion
	}
	return ""
}

// SecurityBulletin are notifications of vulnerabilities of Google products.
type SecurityBulletin struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the bulletin corresponding to the vulnerability.
	BulletinId string `protobuf:"bytes,1,opt,name=bulletin_id,json=bulletinId,proto3" json:"bulletin_id,omitempty"`
	// Submission time of this Security Bulletin.
	SubmissionTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=submission_time,json=submissionTime,proto3" json:"submission_time,omitempty"`
	// This represents a version that the cluster receiving this notification
	// should be upgraded to, based on its current version. For example, 1.15.0
	SuggestedUpgradeVersion string `protobuf:"bytes,3,opt,name=suggested_upgrade_version,json=suggestedUpgradeVersion,proto3" json:"suggested_upgrade_version,omitempty"`
}

func (x *SecurityBulletin) Reset() {
	*x = SecurityBulletin{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecurityBulletin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityBulletin) ProtoMessage() {}

func (x *SecurityBulletin) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityBulletin.ProtoReflect.Descriptor instead.
func (*SecurityBulletin) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescGZIP(), []int{5}
}

func (x *SecurityBulletin) GetBulletinId() string {
	if x != nil {
		return x.BulletinId
	}
	return ""
}

func (x *SecurityBulletin) GetSubmissionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SubmissionTime
	}
	return nil
}

func (x *SecurityBulletin) GetSuggestedUpgradeVersion() string {
	if x != nil {
		return x.SuggestedUpgradeVersion
	}
	return ""
}

var File_google_cloud_securitycenter_v2_vulnerability_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_v2_vulnerability_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc9, 0x02, 0x0a, 0x0d, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x35, 0x0a, 0x03, 0x63, 0x76, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x76, 0x65, 0x52, 0x03, 0x63, 0x76, 0x65, 0x12, 0x54,
	0x0a, 0x11, 0x6f, 0x66, 0x66, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x52, 0x10, 0x6f, 0x66, 0x66, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x12, 0x4c, 0x0a, 0x0d, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x52, 0x0c, 0x66, 0x69, 0x78, 0x65, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x12, 0x5d, 0x0a, 0x11, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x62,
	0x75, 0x6c, 0x6c, 0x65, 0x74, 0x69, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x42, 0x75, 0x6c, 0x6c, 0x65, 0x74, 0x69, 0x6e, 0x52,
	0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x42, 0x75, 0x6c, 0x6c, 0x65, 0x74, 0x69,
	0x6e, 0x22, 0xb8, 0x05, 0x0a, 0x03, 0x43, 0x76, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x49, 0x0a, 0x0a, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0a, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x12, 0x3e, 0x0a, 0x06, 0x63, 0x76, 0x73, 0x73, 0x76, 0x33, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x76, 0x73, 0x73, 0x76, 0x33, 0x52, 0x06, 0x63, 0x76,
	0x73, 0x73, 0x76, 0x33, 0x12, 0x34, 0x0a, 0x16, 0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x5f, 0x66, 0x69, 0x78, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x46, 0x69,
	0x78, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x46, 0x0a, 0x06, 0x69, 0x6d,
	0x70, 0x61, 0x63, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x76, 0x65, 0x2e,
	0x52, 0x69, 0x73, 0x6b, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x06, 0x69, 0x6d, 0x70, 0x61,
	0x63, 0x74, 0x12, 0x6d, 0x0a, 0x15, 0x65, 0x78, 0x70, 0x6c, 0x6f, 0x69, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x76, 0x65, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x6f, 0x69, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x52, 0x14, 0x65, 0x78, 0x70,
	0x6c, 0x6f, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x12, 0x2f, 0x0a, 0x14, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x69, 0x6e,
	0x5f, 0x74, 0x68, 0x65, 0x5f, 0x77, 0x69, 0x6c, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x11, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x49, 0x6e, 0x54, 0x68, 0x65, 0x57, 0x69,
	0x6c, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x7a, 0x65, 0x72, 0x6f, 0x5f, 0x64, 0x61, 0x79, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x7a, 0x65, 0x72, 0x6f, 0x44, 0x61, 0x79, 0x22, 0x56, 0x0a,
	0x0a, 0x52, 0x69, 0x73, 0x6b, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x1b, 0x0a, 0x17, 0x52,
	0x49, 0x53, 0x4b, 0x5f, 0x52, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x4f, 0x57, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x02, 0x12, 0x08, 0x0a,
	0x04, 0x48, 0x49, 0x47, 0x48, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x49, 0x54, 0x49,
	0x43, 0x41, 0x4c, 0x10, 0x04, 0x22, 0x84, 0x01, 0x0a, 0x14, 0x45, 0x78, 0x70, 0x6c, 0x6f, 0x69,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x12, 0x25,
	0x0a, 0x21, 0x45, 0x58, 0x50, 0x4c, 0x4f, 0x49, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x57, 0x49, 0x44, 0x45, 0x10, 0x01, 0x12,
	0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d,
	0x0a, 0x09, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x03, 0x12, 0x0f, 0x0a,
	0x0b, 0x41, 0x4e, 0x54, 0x49, 0x43, 0x49, 0x50, 0x41, 0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0c,
	0x0a, 0x08, 0x4e, 0x4f, 0x5f, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x05, 0x22, 0x35, 0x0a, 0x09,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x75, 0x72, 0x69, 0x22, 0xc4, 0x0b, 0x0a, 0x06, 0x43, 0x76, 0x73, 0x73, 0x76, 0x33, 0x12, 0x1d,
	0x0a, 0x0a, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x09, 0x62, 0x61, 0x73, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x58, 0x0a,
	0x0d, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x76, 0x73, 0x73, 0x76, 0x33, 0x2e, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x6b, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x0c, 0x61, 0x74, 0x74, 0x61, 0x63,
	0x6b, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x64, 0x0a, 0x11, 0x61, 0x74, 0x74, 0x61, 0x63,
	0x6b, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x76, 0x73, 0x73, 0x76, 0x33, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x69, 0x74, 0x79, 0x52, 0x10, 0x61, 0x74, 0x74,
	0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x69, 0x74, 0x79, 0x12, 0x6a, 0x0a,
	0x13, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x76, 0x73, 0x73,
	0x76, 0x33, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x64, 0x52, 0x12, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x12, 0x61, 0x0a, 0x10, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x76, 0x73, 0x73, 0x76, 0x33, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x75, 0x73, 0x65,
	0x72, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x05,
	0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x76, 0x73,
	0x73, 0x76, 0x33, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x12, 0x64, 0x0a, 0x16, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x5f, 0x69, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x76, 0x73, 0x73, 0x76, 0x33, 0x2e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x52,
	0x15, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x12, 0x58, 0x0a, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72,
	0x69, 0x74, 0x79, 0x5f, 0x69, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x76, 0x73, 0x73, 0x76, 0x33, 0x2e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x52,
	0x0f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74, 0x79, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74,
	0x12, 0x5e, 0x0a, 0x13, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x5f, 0x69, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x76, 0x73, 0x73, 0x76, 0x33, 0x2e, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x52, 0x12, 0x61, 0x76,
	0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74,
	0x22, 0x99, 0x01, 0x0a, 0x0c, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x56, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x12, 0x1d, 0x0a, 0x19, 0x41, 0x54, 0x54, 0x41, 0x43, 0x4b, 0x5f, 0x56, 0x45, 0x43, 0x54,
	0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x19, 0x0a, 0x15, 0x41, 0x54, 0x54, 0x41, 0x43, 0x4b, 0x5f, 0x56, 0x45, 0x43, 0x54, 0x4f,
	0x52, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x41,
	0x54, 0x54, 0x41, 0x43, 0x4b, 0x5f, 0x56, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x41, 0x44, 0x4a,
	0x41, 0x43, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x54, 0x54, 0x41, 0x43,
	0x4b, 0x5f, 0x56, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x10, 0x03,
	0x12, 0x1a, 0x0a, 0x16, 0x41, 0x54, 0x54, 0x41, 0x43, 0x4b, 0x5f, 0x56, 0x45, 0x43, 0x54, 0x4f,
	0x52, 0x5f, 0x50, 0x48, 0x59, 0x53, 0x49, 0x43, 0x41, 0x4c, 0x10, 0x04, 0x22, 0x6c, 0x0a, 0x10,
	0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x69, 0x74, 0x79,
	0x12, 0x21, 0x0a, 0x1d, 0x41, 0x54, 0x54, 0x41, 0x43, 0x4b, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c,
	0x45, 0x58, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x41, 0x54, 0x54, 0x41, 0x43, 0x4b, 0x5f, 0x43, 0x4f,
	0x4d, 0x50, 0x4c, 0x45, 0x58, 0x49, 0x54, 0x59, 0x5f, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x1a,
	0x0a, 0x16, 0x41, 0x54, 0x54, 0x41, 0x43, 0x4b, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x58,
	0x49, 0x54, 0x59, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x02, 0x22, 0x92, 0x01, 0x0a, 0x12, 0x50,
	0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x64, 0x12, 0x23, 0x0a, 0x1f, 0x50, 0x52, 0x49, 0x56, 0x49, 0x4c, 0x45, 0x47, 0x45, 0x53, 0x5f,
	0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x52, 0x49, 0x56, 0x49, 0x4c,
	0x45, 0x47, 0x45, 0x53, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x5f, 0x4e, 0x4f,
	0x4e, 0x45, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x52, 0x49, 0x56, 0x49, 0x4c, 0x45, 0x47,
	0x45, 0x53, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x5f, 0x4c, 0x4f, 0x57, 0x10,
	0x02, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x52, 0x49, 0x56, 0x49, 0x4c, 0x45, 0x47, 0x45, 0x53, 0x5f,
	0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x03, 0x22,
	0x6d, 0x0a, 0x0f, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x1c, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52,
	0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x49, 0x4e, 0x54,
	0x45, 0x52, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12,
	0x1d, 0x0a, 0x19, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x41, 0x43, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x10, 0x02, 0x22, 0x46,
	0x0a, 0x05, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x43, 0x4f, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13,
	0x0a, 0x0f, 0x53, 0x43, 0x4f, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x43, 0x4f, 0x50, 0x45, 0x5f, 0x43, 0x48, 0x41,
	0x4e, 0x47, 0x45, 0x44, 0x10, 0x02, 0x22, 0x52, 0x0a, 0x06, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74,
	0x12, 0x16, 0x0a, 0x12, 0x49, 0x4d, 0x50, 0x41, 0x43, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4d, 0x50, 0x41,
	0x43, 0x54, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x4d, 0x50,
	0x41, 0x43, 0x54, 0x5f, 0x4c, 0x4f, 0x57, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4d, 0x50,
	0x41, 0x43, 0x54, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x03, 0x22, 0x91, 0x01, 0x0a, 0x07, 0x50,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x63, 0x70, 0x65,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x70, 0x65, 0x55,
	0x72, 0x69, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xb4,
	0x01, 0x0a, 0x10, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x42, 0x75, 0x6c, 0x6c, 0x65,
	0x74, 0x69, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x75, 0x6c, 0x6c, 0x65, 0x74, 0x69, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x62, 0x75, 0x6c, 0x6c, 0x65, 0x74,
	0x69, 0x6e, 0x49, 0x64, 0x12, 0x43, 0x0a, 0x0f, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x73, 0x75, 0x62, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x19, 0x73, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x73, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0xec, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x42, 0x12, 0x56, 0x75,
	0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0xaa, 0x02,
	0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x56, 0x32, 0xca,
	0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5c, 0x56, 0x32,
	0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescData = file_google_cloud_securitycenter_v2_vulnerability_proto_rawDesc
)

func file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_v2_vulnerability_proto_rawDescData
}

var file_google_cloud_securitycenter_v2_vulnerability_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_securitycenter_v2_vulnerability_proto_goTypes = []interface{}{
	(Cve_RiskRating)(0),            // 0: google.cloud.securitycenter.v2.Cve.RiskRating
	(Cve_ExploitationActivity)(0),  // 1: google.cloud.securitycenter.v2.Cve.ExploitationActivity
	(Cvssv3_AttackVector)(0),       // 2: google.cloud.securitycenter.v2.Cvssv3.AttackVector
	(Cvssv3_AttackComplexity)(0),   // 3: google.cloud.securitycenter.v2.Cvssv3.AttackComplexity
	(Cvssv3_PrivilegesRequired)(0), // 4: google.cloud.securitycenter.v2.Cvssv3.PrivilegesRequired
	(Cvssv3_UserInteraction)(0),    // 5: google.cloud.securitycenter.v2.Cvssv3.UserInteraction
	(Cvssv3_Scope)(0),              // 6: google.cloud.securitycenter.v2.Cvssv3.Scope
	(Cvssv3_Impact)(0),             // 7: google.cloud.securitycenter.v2.Cvssv3.Impact
	(*Vulnerability)(nil),          // 8: google.cloud.securitycenter.v2.Vulnerability
	(*Cve)(nil),                    // 9: google.cloud.securitycenter.v2.Cve
	(*Reference)(nil),              // 10: google.cloud.securitycenter.v2.Reference
	(*Cvssv3)(nil),                 // 11: google.cloud.securitycenter.v2.Cvssv3
	(*Package)(nil),                // 12: google.cloud.securitycenter.v2.Package
	(*SecurityBulletin)(nil),       // 13: google.cloud.securitycenter.v2.SecurityBulletin
	(*timestamppb.Timestamp)(nil),  // 14: google.protobuf.Timestamp
}
var file_google_cloud_securitycenter_v2_vulnerability_proto_depIdxs = []int32{
	9,  // 0: google.cloud.securitycenter.v2.Vulnerability.cve:type_name -> google.cloud.securitycenter.v2.Cve
	12, // 1: google.cloud.securitycenter.v2.Vulnerability.offending_package:type_name -> google.cloud.securitycenter.v2.Package
	12, // 2: google.cloud.securitycenter.v2.Vulnerability.fixed_package:type_name -> google.cloud.securitycenter.v2.Package
	13, // 3: google.cloud.securitycenter.v2.Vulnerability.security_bulletin:type_name -> google.cloud.securitycenter.v2.SecurityBulletin
	10, // 4: google.cloud.securitycenter.v2.Cve.references:type_name -> google.cloud.securitycenter.v2.Reference
	11, // 5: google.cloud.securitycenter.v2.Cve.cvssv3:type_name -> google.cloud.securitycenter.v2.Cvssv3
	0,  // 6: google.cloud.securitycenter.v2.Cve.impact:type_name -> google.cloud.securitycenter.v2.Cve.RiskRating
	1,  // 7: google.cloud.securitycenter.v2.Cve.exploitation_activity:type_name -> google.cloud.securitycenter.v2.Cve.ExploitationActivity
	2,  // 8: google.cloud.securitycenter.v2.Cvssv3.attack_vector:type_name -> google.cloud.securitycenter.v2.Cvssv3.AttackVector
	3,  // 9: google.cloud.securitycenter.v2.Cvssv3.attack_complexity:type_name -> google.cloud.securitycenter.v2.Cvssv3.AttackComplexity
	4,  // 10: google.cloud.securitycenter.v2.Cvssv3.privileges_required:type_name -> google.cloud.securitycenter.v2.Cvssv3.PrivilegesRequired
	5,  // 11: google.cloud.securitycenter.v2.Cvssv3.user_interaction:type_name -> google.cloud.securitycenter.v2.Cvssv3.UserInteraction
	6,  // 12: google.cloud.securitycenter.v2.Cvssv3.scope:type_name -> google.cloud.securitycenter.v2.Cvssv3.Scope
	7,  // 13: google.cloud.securitycenter.v2.Cvssv3.confidentiality_impact:type_name -> google.cloud.securitycenter.v2.Cvssv3.Impact
	7,  // 14: google.cloud.securitycenter.v2.Cvssv3.integrity_impact:type_name -> google.cloud.securitycenter.v2.Cvssv3.Impact
	7,  // 15: google.cloud.securitycenter.v2.Cvssv3.availability_impact:type_name -> google.cloud.securitycenter.v2.Cvssv3.Impact
	14, // 16: google.cloud.securitycenter.v2.SecurityBulletin.submission_time:type_name -> google.protobuf.Timestamp
	17, // [17:17] is the sub-list for method output_type
	17, // [17:17] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_v2_vulnerability_proto_init() }
func file_google_cloud_securitycenter_v2_vulnerability_proto_init() {
	if File_google_cloud_securitycenter_v2_vulnerability_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Vulnerability); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cve); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Reference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cvssv3); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Package); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecurityBulletin); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_v2_vulnerability_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_securitycenter_v2_vulnerability_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_v2_vulnerability_proto_depIdxs,
		EnumInfos:         file_google_cloud_securitycenter_v2_vulnerability_proto_enumTypes,
		MessageInfos:      file_google_cloud_securitycenter_v2_vulnerability_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_v2_vulnerability_proto = out.File
	file_google_cloud_securitycenter_v2_vulnerability_proto_rawDesc = nil
	file_google_cloud_securitycenter_v2_vulnerability_proto_goTypes = nil
	file_google_cloud_securitycenter_v2_vulnerability_proto_depIdxs = nil
}
