# Go API client for edgeapplications

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [OpenAPI-spec](https://www.openapis.org/) from a remote server, you can easily generate an API client.

- API version: 2.0.0
- Package version: 1.0.0
- Generator version: 7.11.0
- Build package: org.openapitools.codegen.languages.GoClientCodegen

## Installation

Install the following dependencies:

```sh
go get github.com/stretchr/testify/assert
go get golang.org/x/net/context
```

Put the package under your project folder and add the following in import:

```go
import edgeapplications "github.com/GIT_USER_ID/GIT_REPO_ID"
```

To use a proxy, set the environment variable `HTTP_PROXY`:

```go
os.Setenv("HTTP_PROXY", "http://proxy_name:proxy_port")
```

## Configuration of Server URL

Default configuration comes with `Servers` field that contains server objects as defined in the OpenAPI specification.

### Select Server Configuration

For using other server than the one defined on index 0 set context value `edgeapplications.ContextServerIndex` of type `int`.

```go
ctx := context.WithValue(context.Background(), edgeapplications.ContextServerIndex, 1)
```

### Templated Server URL

Templated server URL is formatted using default variables from configuration or from context value `edgeapplications.ContextServerVariables` of type `map[string]string`.

```go
ctx := context.WithValue(context.Background(), edgeapplications.ContextServerVariables, map[string]string{
	"basePath": "v2",
})
```

Note, enum values are always validated and all unused variables are silently ignored.

### URLs Configuration per Operation

Each operation can use different server URL defined using `OperationServers` map in the `Configuration`.
An operation is uniquely identified by `"{classname}Service.{nickname}"` string.
Similar rules for overriding default operation server index and variables applies by using `edgeapplications.ContextOperationServerIndices` and `edgeapplications.ContextOperationServerVariables` context maps.

```go
ctx := context.WithValue(context.Background(), edgeapplications.ContextOperationServerIndices, map[string]int{
	"{classname}Service.{nickname}": 2,
})
ctx = context.WithValue(context.Background(), edgeapplications.ContextOperationServerVariables, map[string]map[string]string{
	"{classname}Service.{nickname}": {
		"port": "8443",
	},
})
```

## Documentation for API Endpoints

All URIs are relative to *https://api.azionapi.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*EdgeApplicationsCacheSettingsAPI* | [**EdgeApplicationsEdgeApplicationIdCacheSettingsCacheSettingsIdDelete**](docs/EdgeApplicationsCacheSettingsAPI.md#edgeapplicationsedgeapplicationidcachesettingscachesettingsiddelete) | **Delete** /edge_applications/{edge_application_id}/cache_settings/{cache_settings_id} | /edge_applications/:edge_application_id:/cache_settings/:cache_settings_id:
*EdgeApplicationsCacheSettingsAPI* | [**EdgeApplicationsEdgeApplicationIdCacheSettingsCacheSettingsIdGet**](docs/EdgeApplicationsCacheSettingsAPI.md#edgeapplicationsedgeapplicationidcachesettingscachesettingsidget) | **Get** /edge_applications/{edge_application_id}/cache_settings/{cache_settings_id} | /edge_applications/:edge_application_id:/cache_settings/:cache_settings_id:
*EdgeApplicationsCacheSettingsAPI* | [**EdgeApplicationsEdgeApplicationIdCacheSettingsCacheSettingsIdPatch**](docs/EdgeApplicationsCacheSettingsAPI.md#edgeapplicationsedgeapplicationidcachesettingscachesettingsidpatch) | **Patch** /edge_applications/{edge_application_id}/cache_settings/{cache_settings_id} | /edge_applications/:edge_application_id:/cache_settings/:cache_settings_id:
*EdgeApplicationsCacheSettingsAPI* | [**EdgeApplicationsEdgeApplicationIdCacheSettingsCacheSettingsIdPut**](docs/EdgeApplicationsCacheSettingsAPI.md#edgeapplicationsedgeapplicationidcachesettingscachesettingsidput) | **Put** /edge_applications/{edge_application_id}/cache_settings/{cache_settings_id} | /edge_applications/:edge_application_id:/cache_settings/ca
*EdgeApplicationsCacheSettingsAPI* | [**EdgeApplicationsEdgeApplicationIdCacheSettingsGet**](docs/EdgeApplicationsCacheSettingsAPI.md#edgeapplicationsedgeapplicationidcachesettingsget) | **Get** /edge_applications/{edge_application_id}/cache_settings | /edge_applications/{edge_application_id}/cache_settings
*EdgeApplicationsCacheSettingsAPI* | [**EdgeApplicationsEdgeApplicationIdCacheSettingsPost**](docs/EdgeApplicationsCacheSettingsAPI.md#edgeapplicationsedgeapplicationidcachesettingspost) | **Post** /edge_applications/{edge_application_id}/cache_settings | /edge_applications/:edge_application_id:/cache_settings
*EdgeApplicationsDeviceGroupsAPI* | [**EdgeApplicationsEdgeApplicationIdDeviceGroupsDeviceGroupIdDelete**](docs/EdgeApplicationsDeviceGroupsAPI.md#edgeapplicationsedgeapplicationiddevicegroupsdevicegroupiddelete) | **Delete** /edge_applications/{edge_application_id}/device_groups/{device_group_id} | /edge_applications/{edge_application_id}/device_groups/{device_group_id}
*EdgeApplicationsDeviceGroupsAPI* | [**EdgeApplicationsEdgeApplicationIdDeviceGroupsDeviceGroupIdGet**](docs/EdgeApplicationsDeviceGroupsAPI.md#edgeapplicationsedgeapplicationiddevicegroupsdevicegroupidget) | **Get** /edge_applications/{edge_application_id}/device_groups/{device_group_id} | /edge_applications/{edge_application_id}/device_groups/{device_group_id}
*EdgeApplicationsDeviceGroupsAPI* | [**EdgeApplicationsEdgeApplicationIdDeviceGroupsDeviceGroupIdPatch**](docs/EdgeApplicationsDeviceGroupsAPI.md#edgeapplicationsedgeapplicationiddevicegroupsdevicegroupidpatch) | **Patch** /edge_applications/{edge_application_id}/device_groups/{device_group_id} | /edge_applications/{edge_application_id}/device_groups/{device_group_id}
*EdgeApplicationsDeviceGroupsAPI* | [**EdgeApplicationsEdgeApplicationIdDeviceGroupsDeviceGroupIdPut**](docs/EdgeApplicationsDeviceGroupsAPI.md#edgeapplicationsedgeapplicationiddevicegroupsdevicegroupidput) | **Put** /edge_applications/{edge_application_id}/device_groups/{device_group_id} | /edge_applications/{edge_application_id}/device_groups/{device_group_id}
*EdgeApplicationsDeviceGroupsAPI* | [**EdgeApplicationsEdgeApplicationIdDeviceGroupsGet**](docs/EdgeApplicationsDeviceGroupsAPI.md#edgeapplicationsedgeapplicationiddevicegroupsget) | **Get** /edge_applications/{edge_application_id}/device_groups | /edge_applications/{edge_application_id}/device_groups
*EdgeApplicationsDeviceGroupsAPI* | [**EdgeApplicationsEdgeApplicationIdDeviceGroupsPost**](docs/EdgeApplicationsDeviceGroupsAPI.md#edgeapplicationsedgeapplicationiddevicegroupspost) | **Post** /edge_applications/{edge_application_id}/device_groups | /edge_applications/{edge_application_id}/device_groups
*EdgeApplicationsEdgeFunctionsInstancesAPI* | [**EdgeApplicationsEdgeApplicationIdFunctionsInstancesFunctionsInstancesIdDelete**](docs/EdgeApplicationsEdgeFunctionsInstancesAPI.md#edgeapplicationsedgeapplicationidfunctionsinstancesfunctionsinstancesiddelete) | **Delete** /edge_applications/{edge_application_id}/functions_instances/{functions_instances_id} | /edge_applications/:edge_application_id:/functions_instances/:functions_instances_id:
*EdgeApplicationsEdgeFunctionsInstancesAPI* | [**EdgeApplicationsEdgeApplicationIdFunctionsInstancesFunctionsInstancesIdGet**](docs/EdgeApplicationsEdgeFunctionsInstancesAPI.md#edgeapplicationsedgeapplicationidfunctionsinstancesfunctionsinstancesidget) | **Get** /edge_applications/{edge_application_id}/functions_instances/{functions_instances_id} | /edge_applications/:edge_application_id:/functions_instances/:functions_instances_id:
*EdgeApplicationsEdgeFunctionsInstancesAPI* | [**EdgeApplicationsEdgeApplicationIdFunctionsInstancesFunctionsInstancesIdPatch**](docs/EdgeApplicationsEdgeFunctionsInstancesAPI.md#edgeapplicationsedgeapplicationidfunctionsinstancesfunctionsinstancesidpatch) | **Patch** /edge_applications/{edge_application_id}/functions_instances/{functions_instances_id} | /edge_applications/:edge_application_id:/functions_instances/:functions_instances_id:
*EdgeApplicationsEdgeFunctionsInstancesAPI* | [**EdgeApplicationsEdgeApplicationIdFunctionsInstancesFunctionsInstancesIdPut**](docs/EdgeApplicationsEdgeFunctionsInstancesAPI.md#edgeapplicationsedgeapplicationidfunctionsinstancesfunctionsinstancesidput) | **Put** /edge_applications/{edge_application_id}/functions_instances/{functions_instances_id} | /edge_applications/:edge_application_id:/functions_instances/:functions_instances_id:
*EdgeApplicationsEdgeFunctionsInstancesAPI* | [**EdgeApplicationsEdgeApplicationIdFunctionsInstancesGet**](docs/EdgeApplicationsEdgeFunctionsInstancesAPI.md#edgeapplicationsedgeapplicationidfunctionsinstancesget) | **Get** /edge_applications/{edge_application_id}/functions_instances | /edge_applications/:edge_application_id:/functions_instances
*EdgeApplicationsEdgeFunctionsInstancesAPI* | [**EdgeApplicationsEdgeApplicationIdFunctionsInstancesPost**](docs/EdgeApplicationsEdgeFunctionsInstancesAPI.md#edgeapplicationsedgeapplicationidfunctionsinstancespost) | **Post** /edge_applications/{edge_application_id}/functions_instances | edge_application/:edge_application_id:/functions_instances
*EdgeApplicationsMainSettingsAPI* | [**EdgeApplicationsGet**](docs/EdgeApplicationsMainSettingsAPI.md#edgeapplicationsget) | **Get** /edge_applications | /edge_applications
*EdgeApplicationsMainSettingsAPI* | [**EdgeApplicationsIdDelete**](docs/EdgeApplicationsMainSettingsAPI.md#edgeapplicationsiddelete) | **Delete** /edge_applications/{id} | /edge_applications/:id
*EdgeApplicationsMainSettingsAPI* | [**EdgeApplicationsIdGet**](docs/EdgeApplicationsMainSettingsAPI.md#edgeapplicationsidget) | **Get** /edge_applications/{id} | /edge_applications/:id
*EdgeApplicationsMainSettingsAPI* | [**EdgeApplicationsIdPatch**](docs/EdgeApplicationsMainSettingsAPI.md#edgeapplicationsidpatch) | **Patch** /edge_applications/{id} | /edge_applications/:id
*EdgeApplicationsMainSettingsAPI* | [**EdgeApplicationsIdPut**](docs/EdgeApplicationsMainSettingsAPI.md#edgeapplicationsidput) | **Put** /edge_applications/{id} | /edge_applications/:id
*EdgeApplicationsMainSettingsAPI* | [**EdgeApplicationsPost**](docs/EdgeApplicationsMainSettingsAPI.md#edgeapplicationspost) | **Post** /edge_applications | /edge_applications
*EdgeApplicationsOriginsAPI* | [**EdgeApplicationsEdgeApplicationIdOriginsGet**](docs/EdgeApplicationsOriginsAPI.md#edgeapplicationsedgeapplicationidoriginsget) | **Get** /edge_applications/{edge_application_id}/origins | /edge_applications/{edge_application_id}/origins
*EdgeApplicationsOriginsAPI* | [**EdgeApplicationsEdgeApplicationIdOriginsOriginKeyDelete**](docs/EdgeApplicationsOriginsAPI.md#edgeapplicationsedgeapplicationidoriginsoriginkeydelete) | **Delete** /edge_applications/{edge_application_id}/origins/{origin_key} | /edge_applications/{edge_application_id}/origins/{origin_id}
*EdgeApplicationsOriginsAPI* | [**EdgeApplicationsEdgeApplicationIdOriginsOriginKeyGet**](docs/EdgeApplicationsOriginsAPI.md#edgeapplicationsedgeapplicationidoriginsoriginkeyget) | **Get** /edge_applications/{edge_application_id}/origins/{origin_key} | /edge_applications/{edge_application_id}/origins/{origin_key}
*EdgeApplicationsOriginsAPI* | [**EdgeApplicationsEdgeApplicationIdOriginsOriginKeyPatch**](docs/EdgeApplicationsOriginsAPI.md#edgeapplicationsedgeapplicationidoriginsoriginkeypatch) | **Patch** /edge_applications/{edge_application_id}/origins/{origin_key} | /edge_applications/:edge_application_id:/origins/:origin_id:
*EdgeApplicationsOriginsAPI* | [**EdgeApplicationsEdgeApplicationIdOriginsOriginKeyPut**](docs/EdgeApplicationsOriginsAPI.md#edgeapplicationsedgeapplicationidoriginsoriginkeyput) | **Put** /edge_applications/{edge_application_id}/origins/{origin_key} | /edge_applications/{edge_application_id}/origins/{origin_id}
*EdgeApplicationsOriginsAPI* | [**EdgeApplicationsEdgeApplicationIdOriginsPost**](docs/EdgeApplicationsOriginsAPI.md#edgeapplicationsedgeapplicationidoriginspost) | **Post** /edge_applications/{edge_application_id}/origins | /edge_applications/{edge_application_id}/origins
*EdgeApplicationsRulesEngineAPI* | [**EdgeApplicationsEdgeApplicationIdRulesEnginePhaseRulesGet**](docs/EdgeApplicationsRulesEngineAPI.md#edgeapplicationsedgeapplicationidrulesenginephaserulesget) | **Get** /edge_applications/{edge_application_id}/rules_engine/{phase}/rules | /edge_applications/{edge_application_id}/rules_engine/{phase}/rules
*EdgeApplicationsRulesEngineAPI* | [**EdgeApplicationsEdgeApplicationIdRulesEnginePhaseRulesPost**](docs/EdgeApplicationsRulesEngineAPI.md#edgeapplicationsedgeapplicationidrulesenginephaserulespost) | **Post** /edge_applications/{edge_application_id}/rules_engine/{phase}/rules | /edge_applications/{edge_application_id}/rules_engine/{phase}/rules
*EdgeApplicationsRulesEngineAPI* | [**EdgeApplicationsEdgeApplicationIdRulesEnginePhaseRulesRuleIdDelete**](docs/EdgeApplicationsRulesEngineAPI.md#edgeapplicationsedgeapplicationidrulesenginephaserulesruleiddelete) | **Delete** /edge_applications/{edge_application_id}/rules_engine/{phase}/rules/{rule_id} | /edge_applications/{edge_application_id}/rules_engine/{phase}/rules
*EdgeApplicationsRulesEngineAPI* | [**EdgeApplicationsEdgeApplicationIdRulesEnginePhaseRulesRuleIdGet**](docs/EdgeApplicationsRulesEngineAPI.md#edgeapplicationsedgeapplicationidrulesenginephaserulesruleidget) | **Get** /edge_applications/{edge_application_id}/rules_engine/{phase}/rules/{rule_id} | /edge_applications/{edge_application_id}/rules_engine/{phase}/rules
*EdgeApplicationsRulesEngineAPI* | [**EdgeApplicationsEdgeApplicationIdRulesEnginePhaseRulesRuleIdPatch**](docs/EdgeApplicationsRulesEngineAPI.md#edgeapplicationsedgeapplicationidrulesenginephaserulesruleidpatch) | **Patch** /edge_applications/{edge_application_id}/rules_engine/{phase}/rules/{rule_id} | /edge_applications/:edge_application_id:/rules_engine/:phase:/rules/:rule_id:
*EdgeApplicationsRulesEngineAPI* | [**EdgeApplicationsEdgeApplicationIdRulesEnginePhaseRulesRuleIdPut**](docs/EdgeApplicationsRulesEngineAPI.md#edgeapplicationsedgeapplicationidrulesenginephaserulesruleidput) | **Put** /edge_applications/{edge_application_id}/rules_engine/{phase}/rules/{rule_id} | /edge_applications/:edge_application_id:/rules_engine/:phase:/rules/:rule_id:


## Documentation For Models

 - [ApplicationCacheCreateRequest](docs/ApplicationCacheCreateRequest.md)
 - [ApplicationCacheCreateResponse](docs/ApplicationCacheCreateResponse.md)
 - [ApplicationCacheCreateResults](docs/ApplicationCacheCreateResults.md)
 - [ApplicationCacheGetOneResponse](docs/ApplicationCacheGetOneResponse.md)
 - [ApplicationCacheGetResponse](docs/ApplicationCacheGetResponse.md)
 - [ApplicationCachePatchRequest](docs/ApplicationCachePatchRequest.md)
 - [ApplicationCachePatchResponse](docs/ApplicationCachePatchResponse.md)
 - [ApplicationCachePutRequest](docs/ApplicationCachePutRequest.md)
 - [ApplicationCachePutResponse](docs/ApplicationCachePutResponse.md)
 - [ApplicationCacheResponseDetails](docs/ApplicationCacheResponseDetails.md)
 - [ApplicationCacheResults](docs/ApplicationCacheResults.md)
 - [ApplicationCreateInstanceRequest](docs/ApplicationCreateInstanceRequest.md)
 - [ApplicationInstanceResults](docs/ApplicationInstanceResults.md)
 - [ApplicationInstancesGetOneResponse](docs/ApplicationInstancesGetOneResponse.md)
 - [ApplicationInstancesGetResponse](docs/ApplicationInstancesGetResponse.md)
 - [ApplicationInstancesResults](docs/ApplicationInstancesResults.md)
 - [ApplicationLinks](docs/ApplicationLinks.md)
 - [ApplicationOrigins](docs/ApplicationOrigins.md)
 - [ApplicationPutInstanceRequest](docs/ApplicationPutInstanceRequest.md)
 - [ApplicationPutRequest](docs/ApplicationPutRequest.md)
 - [ApplicationPutResult](docs/ApplicationPutResult.md)
 - [ApplicationResults](docs/ApplicationResults.md)
 - [ApplicationResultsCreate](docs/ApplicationResultsCreate.md)
 - [ApplicationUpdateInstanceRequest](docs/ApplicationUpdateInstanceRequest.md)
 - [ApplicationUpdateRequest](docs/ApplicationUpdateRequest.md)
 - [ApplicationUpdateResponse](docs/ApplicationUpdateResponse.md)
 - [ApplicationUpdateResults](docs/ApplicationUpdateResults.md)
 - [ApplicationsResults](docs/ApplicationsResults.md)
 - [CreateApplicationRequest](docs/CreateApplicationRequest.md)
 - [CreateApplicationResult](docs/CreateApplicationResult.md)
 - [CreateDeviceGroupsRequest](docs/CreateDeviceGroupsRequest.md)
 - [CreateOriginsRequest](docs/CreateOriginsRequest.md)
 - [CreateOriginsRequestAddresses](docs/CreateOriginsRequestAddresses.md)
 - [CreateRulesEngineRequest](docs/CreateRulesEngineRequest.md)
 - [DeviceGroupsIdResponse](docs/DeviceGroupsIdResponse.md)
 - [DeviceGroupsResponse](docs/DeviceGroupsResponse.md)
 - [DeviceGroupsResponseLinks](docs/DeviceGroupsResponseLinks.md)
 - [DeviceGroupsResultResponse](docs/DeviceGroupsResultResponse.md)
 - [GetApplicationResponse](docs/GetApplicationResponse.md)
 - [GetApplicationsResponse](docs/GetApplicationsResponse.md)
 - [OriginsIdResponse](docs/OriginsIdResponse.md)
 - [OriginsResponse](docs/OriginsResponse.md)
 - [OriginsResponseLinks](docs/OriginsResponseLinks.md)
 - [OriginsResultResponse](docs/OriginsResultResponse.md)
 - [OriginsResultResponseAddresses](docs/OriginsResultResponseAddresses.md)
 - [PatchDeviceGroupsRequest](docs/PatchDeviceGroupsRequest.md)
 - [PatchOriginsRequest](docs/PatchOriginsRequest.md)
 - [PatchRulesEngineRequest](docs/PatchRulesEngineRequest.md)
 - [RulesEngineBehaviorEntry](docs/RulesEngineBehaviorEntry.md)
 - [RulesEngineBehaviorInteger](docs/RulesEngineBehaviorInteger.md)
 - [RulesEngineBehaviorObject](docs/RulesEngineBehaviorObject.md)
 - [RulesEngineBehaviorObjectTarget](docs/RulesEngineBehaviorObjectTarget.md)
 - [RulesEngineBehaviorString](docs/RulesEngineBehaviorString.md)
 - [RulesEngineCriteria](docs/RulesEngineCriteria.md)
 - [RulesEngineIdResponse](docs/RulesEngineIdResponse.md)
 - [RulesEngineResponse](docs/RulesEngineResponse.md)
 - [RulesEngineResultResponse](docs/RulesEngineResultResponse.md)
 - [UpdateDeviceGroupsRequest](docs/UpdateDeviceGroupsRequest.md)
 - [UpdateOriginsRequest](docs/UpdateOriginsRequest.md)
 - [UpdateRulesEngineRequest](docs/UpdateRulesEngineRequest.md)


## Documentation For Authorization


Authentication schemes defined for the API:
### tokenAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header

Note, each API key must be added to a map of `map[string]APIKey` where the key is: tokenAuth and passed in as the auth context for each request.

Example

```go
auth := context.WithValue(
		context.Background(),
		edgeapplications.ContextAPIKeys,
		map[string]edgeapplications.APIKey{
			"tokenAuth": {Key: "API_KEY_STRING"},
		},
	)
r, err := client.Service.Operation(auth, args)
```


## Documentation for Utility Methods

Due to the fact that model structure members are all pointers, this package contains
a number of utility functions to easily obtain pointers to values of basic types.
Each of these functions takes a value of the given basic type and returns a pointer to it:

* `PtrBool`
* `PtrInt`
* `PtrInt32`
* `PtrInt64`
* `PtrFloat`
* `PtrFloat32`
* `PtrFloat64`
* `PtrString`
* `PtrTime`

## Author



