/*
Object Storage

REST API OpenAPI documentation for the Object Storage

API version: 1.0.0 (v1)
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package storage

import (
	"encoding/json"
	"fmt"
)

// checks if the ResponseDeleteBucket type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ResponseDeleteBucket{}

// ResponseDeleteBucket struct for ResponseDeleteBucket
type ResponseDeleteBucket struct {
	State StateEnum `json:"state"`
	Data NullableResponseDeleteBucketData `json:"data"`
}

type _ResponseDeleteBucket ResponseDeleteBucket

// NewResponseDeleteBucket instantiates a new ResponseDeleteBucket object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewResponseDeleteBucket(state StateEnum, data NullableResponseDeleteBucketData) *ResponseDeleteBucket {
	this := ResponseDeleteBucket{}
	this.State = state
	this.Data = data
	return &this
}

// NewResponseDeleteBucketWithDefaults instantiates a new ResponseDeleteBucket object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewResponseDeleteBucketWithDefaults() *ResponseDeleteBucket {
	this := ResponseDeleteBucket{}
	return &this
}

// GetState returns the State field value
func (o *ResponseDeleteBucket) GetState() StateEnum {
	if o == nil {
		var ret StateEnum
		return ret
	}

	return o.State
}

// GetStateOk returns a tuple with the State field value
// and a boolean to check if the value has been set.
func (o *ResponseDeleteBucket) GetStateOk() (*StateEnum, bool) {
	if o == nil {
		return nil, false
	}
	return &o.State, true
}

// SetState sets field value
func (o *ResponseDeleteBucket) SetState(v StateEnum) {
	o.State = v
}

// GetData returns the Data field value
// If the value is explicit nil, the zero value for ResponseDeleteBucketData will be returned
func (o *ResponseDeleteBucket) GetData() ResponseDeleteBucketData {
	if o == nil || o.Data.Get() == nil {
		var ret ResponseDeleteBucketData
		return ret
	}

	return *o.Data.Get()
}

// GetDataOk returns a tuple with the Data field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResponseDeleteBucket) GetDataOk() (*ResponseDeleteBucketData, bool) {
	if o == nil {
		return nil, false
	}
	return o.Data.Get(), o.Data.IsSet()
}

// SetData sets field value
func (o *ResponseDeleteBucket) SetData(v ResponseDeleteBucketData) {
	o.Data.Set(&v)
}

func (o ResponseDeleteBucket) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ResponseDeleteBucket) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["state"] = o.State
	toSerialize["data"] = o.Data.Get()
	return toSerialize, nil
}

func (o *ResponseDeleteBucket) UnmarshalJSON(bytes []byte) (err error) {
    // This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"state",
		"data",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(bytes, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varResponseDeleteBucket := _ResponseDeleteBucket{}

	err = json.Unmarshal(bytes, &varResponseDeleteBucket)

	if err != nil {
		return err
	}

	*o = ResponseDeleteBucket(varResponseDeleteBucket)

	return err
}

type NullableResponseDeleteBucket struct {
	value *ResponseDeleteBucket
	isSet bool
}

func (v NullableResponseDeleteBucket) Get() *ResponseDeleteBucket {
	return v.value
}

func (v *NullableResponseDeleteBucket) Set(val *ResponseDeleteBucket) {
	v.value = val
	v.isSet = true
}

func (v NullableResponseDeleteBucket) IsSet() bool {
	return v.isSet
}

func (v *NullableResponseDeleteBucket) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableResponseDeleteBucket(val *ResponseDeleteBucket) *NullableResponseDeleteBucket {
	return &NullableResponseDeleteBucket{value: val, isSet: true}
}

func (v NullableResponseDeleteBucket) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableResponseDeleteBucket) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


