// Code generated by tools/cmd/genjwa/main.go. DO NOT EDIT.

package jwa

import (
	"fmt"
	"sort"
	"sync"
)

// EllipticCurveAlgorithm represents the algorithms used for EC keys
type EllipticCurveAlgorithm string

// Supported values for EllipticCurveAlgorithm
const (
	Ed25519              EllipticCurveAlgorithm = "Ed25519"
	Ed448                EllipticCurveAlgorithm = "Ed448"
	InvalidEllipticCurve EllipticCurveAlgorithm = "P-invalid"
	P256                 EllipticCurveAlgorithm = "P-256"
	P384                 EllipticCurveAlgorithm = "P-384"
	P521                 EllipticCurveAlgorithm = "P-521"
	X25519               EllipticCurveAlgorithm = "X25519"
	X448                 EllipticCurveAlgorithm = "X448"
)

var muEllipticCurveAlgorithms sync.RWMutex
var allEllipticCurveAlgorithms map[EllipticCurveAlgorithm]struct{}
var listEllipticCurveAlgorithm []EllipticCurveAlgorithm

func init() {
	muEllipticCurveAlgorithms.Lock()
	defer muEllipticCurveAlgorithms.Unlock()
	allEllipticCurveAlgorithms = make(map[EllipticCurveAlgorithm]struct{})
	allEllipticCurveAlgorithms[Ed25519] = struct{}{}
	allEllipticCurveAlgorithms[Ed448] = struct{}{}
	allEllipticCurveAlgorithms[P256] = struct{}{}
	allEllipticCurveAlgorithms[P384] = struct{}{}
	allEllipticCurveAlgorithms[P521] = struct{}{}
	allEllipticCurveAlgorithms[X25519] = struct{}{}
	allEllipticCurveAlgorithms[X448] = struct{}{}
	rebuildEllipticCurveAlgorithm()
}

// RegisterEllipticCurveAlgorithm registers a new EllipticCurveAlgorithm so that the jwx can properly handle the new value.
// Duplicates will silently be ignored
func RegisterEllipticCurveAlgorithm(v EllipticCurveAlgorithm) {
	muEllipticCurveAlgorithms.Lock()
	defer muEllipticCurveAlgorithms.Unlock()
	if _, ok := allEllipticCurveAlgorithms[v]; !ok {
		allEllipticCurveAlgorithms[v] = struct{}{}
		rebuildEllipticCurveAlgorithm()
	}
}

// UnregisterEllipticCurveAlgorithm unregisters a EllipticCurveAlgorithm from its known database.
// Non-existentn entries will silently be ignored
func UnregisterEllipticCurveAlgorithm(v EllipticCurveAlgorithm) {
	muEllipticCurveAlgorithms.Lock()
	defer muEllipticCurveAlgorithms.Unlock()
	if _, ok := allEllipticCurveAlgorithms[v]; ok {
		delete(allEllipticCurveAlgorithms, v)
		rebuildEllipticCurveAlgorithm()
	}
}

func rebuildEllipticCurveAlgorithm() {
	listEllipticCurveAlgorithm = make([]EllipticCurveAlgorithm, 0, len(allEllipticCurveAlgorithms))
	for v := range allEllipticCurveAlgorithms {
		listEllipticCurveAlgorithm = append(listEllipticCurveAlgorithm, v)
	}
	sort.Slice(listEllipticCurveAlgorithm, func(i, j int) bool {
		return string(listEllipticCurveAlgorithm[i]) < string(listEllipticCurveAlgorithm[j])
	})
}

// EllipticCurveAlgorithms returns a list of all available values for EllipticCurveAlgorithm
func EllipticCurveAlgorithms() []EllipticCurveAlgorithm {
	muEllipticCurveAlgorithms.RLock()
	defer muEllipticCurveAlgorithms.RUnlock()
	return listEllipticCurveAlgorithm
}

// Accept is used when conversion from values given by
// outside sources (such as JSON payloads) is required
func (v *EllipticCurveAlgorithm) Accept(value interface{}) error {
	var tmp EllipticCurveAlgorithm
	if x, ok := value.(EllipticCurveAlgorithm); ok {
		tmp = x
	} else {
		var s string
		switch x := value.(type) {
		case fmt.Stringer:
			s = x.String()
		case string:
			s = x
		default:
			return fmt.Errorf(`invalid type for jwa.EllipticCurveAlgorithm: %T`, value)
		}
		tmp = EllipticCurveAlgorithm(s)
	}
	if _, ok := allEllipticCurveAlgorithms[tmp]; !ok {
		return fmt.Errorf(`invalid jwa.EllipticCurveAlgorithm value`)
	}

	*v = tmp
	return nil
}

// String returns the string representation of a EllipticCurveAlgorithm
func (v EllipticCurveAlgorithm) String() string {
	return string(v)
}
