// Code generated by fileb0x at "2017-05-06 21:06:04.400581277 -0300 ADT" from config file "b0x.toml" DO NOT EDIT.

package updater

import (
	"bytes"

	"io"
	"log"
	"net/http"
	"os"
	"path"
	"path/filepath"
	"strings"

	"context"
	"golang.org/x/net/webdav"

	"crypto/sha256"
	"encoding/hex"

	"github.com/labstack/echo"
	"github.com/labstack/echo/middleware"
)

var (
	// CTX is a context for webdav vfs
	CTX = context.Background()

	// FS is a virtual memory file system
	FS = webdav.NewMemFS()

	// Handler is used to server files through a http handler
	Handler *webdav.Handler

	// HTTP is the http file system
	HTTP http.FileSystem = new(HTTPFS)
)

// HTTPFS implements http.FileSystem
type HTTPFS struct{}

func init() {
	if CTX.Err() != nil {
		log.Fatal(CTX.Err())
	}

	Handler = &webdav.Handler{
		FileSystem: FS,
		LockSystem: webdav.NewMemLS(),
	}
}

// Open a file
func (hfs *HTTPFS) Open(path string) (http.File, error) {
	f, err := FS.OpenFile(CTX, path, os.O_RDONLY, 0644)
	if err != nil {
		return nil, err
	}

	return f, nil
}

// ReadFile is adapTed from ioutil
func ReadFile(path string) ([]byte, error) {
	f, err := FS.OpenFile(CTX, path, os.O_RDONLY, 0644)
	if err != nil {
		return nil, err
	}

	buf := bytes.NewBuffer(make([]byte, 0, bytes.MinRead))

	// If the buffer overflows, we will get bytes.ErrTooLarge.
	// Return that as an error. Any other panic remains.
	defer func() {
		e := recover()
		if e == nil {
			return
		}
		if panicErr, ok := e.(error); ok && panicErr == bytes.ErrTooLarge {
			err = panicErr
		} else {
			panic(e)
		}
	}()
	_, err = buf.ReadFrom(f)
	return buf.Bytes(), err
}

// WriteFile is adapTed from ioutil
func WriteFile(filename string, data []byte, perm os.FileMode) error {
	f, err := FS.OpenFile(CTX, filename, os.O_WRONLY|os.O_CREATE|os.O_TRUNC, perm)
	if err != nil {
		return err
	}
	n, err := f.Write(data)
	if err == nil && n < len(data) {
		err = io.ErrShortWrite
	}
	if err1 := f.Close(); err == nil {
		err = err1
	}
	return err
}

// WalkDirs looks for files in the given dir and returns a list of files in it
// usage for all files in the b0x: WalkDirs("", false)
func WalkDirs(name string, includeDirsInList bool, files ...string) ([]string, error) {
	f, err := FS.OpenFile(CTX, name, os.O_RDONLY, 0)
	if err != nil {
		return nil, err
	}

	fileInfos, err := f.Readdir(0)
	f.Close()
	if err != nil {
		return nil, err
	}

	for _, info := range fileInfos {
		filename := path.Join(name, info.Name())

		if includeDirsInList || !info.IsDir() {
			files = append(files, filename)
		}

		if info.IsDir() {
			files, err = WalkDirs(filename, includeDirsInList, files...)
			if err != nil {
				return nil, err
			}
		}
	}

	return files, nil
}

// Server holds information about the http server
// used to update files remotely
type Server struct {
	Auth  Auth
	Files []string
}

// Init sets the routes and basic http auth
// before starting the http server
func (s *Server) Init() {
	s.Auth = Auth{
		Username: "user",
		Password: "pass",
	}

	e := echo.New()
	e.Use(middleware.Recover())
	e.Use(s.BasicAuth())
	e.POST("/", s.Post)
	e.GET("/", s.Get)

	if err := e.Start(":8041"); err != nil {
		panic(err)
	}
}

// Get gives a list of file names and hashes
func (s *Server) Get(c echo.Context) error {
	log.Println("[fileb0x.Server]: Hashing server files...")

	// file:hash
	hashes := map[string]string{}

	// get all files in the virtual memory file system
	var err error
	s.Files, err = WalkDirs("", false)
	if err != nil {
		return err
	}

	// get a hash for each file
	for _, filePath := range s.Files {
		f, err := FS.OpenFile(CTX, filePath, os.O_RDONLY, 0644)
		if err != nil {
			return err
		}

		hash := sha256.New()
		_, err = io.Copy(hash, f)
		if err != nil {
			return err
		}

		hashes[filePath] = hex.EncodeToString(hash.Sum(nil))
	}

	log.Println("[fileb0x.Server]: Done hashing files")
	return c.JSON(http.StatusOK, &ResponseInit{
		Success: true,
		Hashes:  hashes,
	})
}

// Post is used to upload a file and replace
// it in the virtual memory file system
func (s *Server) Post(c echo.Context) error {
	file, err := c.FormFile("file")
	if err != nil {
		return err
	}

	log.Println("[fileb0x.Server]:", file.Filename, "Found request to upload a file")

	src, err := file.Open()
	if err != nil {
		return err
	}
	defer src.Close()

	newDir := filepath.Dir(file.Filename)
	_, err = FS.Stat(CTX, newDir)
	if err == os.ErrNotExist {
		list := strings.Split(newDir, "/")
		var tree string

		for _, dir := range list {
			if dir == "" || dir == "." || dir == "/" || dir == "./" {
				continue
			}

			tree += dir + "/"
			log.Println("dir", tree)
			err = FS.Mkdir(CTX, tree, 0777)
			if err != nil && err != os.ErrExist {
				log.Println("failed", err)
				return err
			}
		}
	}

	log.Println("[fileb0x.Server]:", file.Filename, "Opening file...")
	f, err := FS.OpenFile(CTX, file.Filename, os.O_RDWR|os.O_CREATE|os.O_TRUNC, 0644)
	if err != nil {
		return err
	}

	log.Println("[fileb0x.Server]:", file.Filename, "Writing file into Virutal Memory FileSystem...")
	if _, err = io.Copy(f, src); err != nil {
		return err
	}

	log.Println("[fileb0x.Server]:", file.Filename, "Done writing file")
	return c.String(http.StatusOK, "ok")
}

// BasicAuth is a middleware to check if
// the username and password are valid
// echo's middleware isn't used because of golint issues
func (s *Server) BasicAuth() echo.MiddlewareFunc {
	return func(next echo.HandlerFunc) echo.HandlerFunc {
		return func(c echo.Context) error {
			u, p, _ := c.Request().BasicAuth()
			if u != s.Auth.Username || p != s.Auth.Password {
				return echo.ErrUnauthorized
			}

			return next(c)
		}
	}
}
