// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/networkmanagement/v1/trace.proto

package networkmanagement

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of states that are defined in the network state machine.
// Each step in the packet trace is in a specific state.
type Step_State int32

const (
	// Unspecified state.
	Step_STATE_UNSPECIFIED Step_State = 0
	// Initial state: packet originating from a Compute Engine instance.
	// An InstanceInfo is populated with starting instance information.
	Step_START_FROM_INSTANCE Step_State = 1
	// Initial state: packet originating from the internet.
	// The endpoint information is populated.
	Step_START_FROM_INTERNET Step_State = 2
	// Initial state: packet originating from a VPC or on-premises network
	// with internal source IP.
	// If the source is a VPC network visible to the user, a NetworkInfo
	// is populated with details of the network.
	Step_START_FROM_PRIVATE_NETWORK Step_State = 3
	// Initial state: packet originating from a Google Kubernetes Engine cluster
	// master. A GKEMasterInfo is populated with starting instance information.
	Step_START_FROM_GKE_MASTER Step_State = 21
	// Initial state: packet originating from a Cloud SQL instance.
	// A CloudSQLInstanceInfo is populated with starting instance information.
	Step_START_FROM_CLOUD_SQL_INSTANCE Step_State = 22
	// Config checking state: verify ingress firewall rule.
	Step_APPLY_INGRESS_FIREWALL_RULE Step_State = 4
	// Config checking state: verify egress firewall rule.
	Step_APPLY_EGRESS_FIREWALL_RULE Step_State = 5
	// Config checking state: verify route.
	Step_APPLY_ROUTE Step_State = 6
	// Config checking state: match forwarding rule.
	Step_APPLY_FORWARDING_RULE Step_State = 7
	// Config checking state: packet sent or received under foreign IP
	// address and allowed.
	Step_SPOOFING_APPROVED Step_State = 8
	// Forwarding state: arriving at a Compute Engine instance.
	Step_ARRIVE_AT_INSTANCE Step_State = 9
	// Forwarding state: arriving at a Compute Engine internal load balancer.
	Step_ARRIVE_AT_INTERNAL_LOAD_BALANCER Step_State = 10
	// Forwarding state: arriving at a Compute Engine external load balancer.
	Step_ARRIVE_AT_EXTERNAL_LOAD_BALANCER Step_State = 11
	// Forwarding state: arriving at a Cloud VPN gateway.
	Step_ARRIVE_AT_VPN_GATEWAY Step_State = 12
	// Forwarding state: arriving at a Cloud VPN tunnel.
	Step_ARRIVE_AT_VPN_TUNNEL Step_State = 13
	// Transition state: packet header translated.
	Step_NAT Step_State = 14
	// Transition state: original connection is terminated and a new proxied
	// connection is initiated.
	Step_PROXY_CONNECTION Step_State = 15
	// Final state: packet could be delivered.
	Step_DELIVER Step_State = 16
	// Final state: packet could be dropped.
	Step_DROP Step_State = 17
	// Final state: packet could be forwarded to a network with an unknown
	// configuration.
	Step_FORWARD Step_State = 18
	// Final state: analysis is aborted.
	Step_ABORT Step_State = 19
	// Special state: viewer of the test result does not have permission to
	// see the configuration in this step.
	Step_VIEWER_PERMISSION_MISSING Step_State = 20
)

// Enum value maps for Step_State.
var (
	Step_State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "START_FROM_INSTANCE",
		2:  "START_FROM_INTERNET",
		3:  "START_FROM_PRIVATE_NETWORK",
		21: "START_FROM_GKE_MASTER",
		22: "START_FROM_CLOUD_SQL_INSTANCE",
		4:  "APPLY_INGRESS_FIREWALL_RULE",
		5:  "APPLY_EGRESS_FIREWALL_RULE",
		6:  "APPLY_ROUTE",
		7:  "APPLY_FORWARDING_RULE",
		8:  "SPOOFING_APPROVED",
		9:  "ARRIVE_AT_INSTANCE",
		10: "ARRIVE_AT_INTERNAL_LOAD_BALANCER",
		11: "ARRIVE_AT_EXTERNAL_LOAD_BALANCER",
		12: "ARRIVE_AT_VPN_GATEWAY",
		13: "ARRIVE_AT_VPN_TUNNEL",
		14: "NAT",
		15: "PROXY_CONNECTION",
		16: "DELIVER",
		17: "DROP",
		18: "FORWARD",
		19: "ABORT",
		20: "VIEWER_PERMISSION_MISSING",
	}
	Step_State_value = map[string]int32{
		"STATE_UNSPECIFIED":                0,
		"START_FROM_INSTANCE":              1,
		"START_FROM_INTERNET":              2,
		"START_FROM_PRIVATE_NETWORK":       3,
		"START_FROM_GKE_MASTER":            21,
		"START_FROM_CLOUD_SQL_INSTANCE":    22,
		"APPLY_INGRESS_FIREWALL_RULE":      4,
		"APPLY_EGRESS_FIREWALL_RULE":       5,
		"APPLY_ROUTE":                      6,
		"APPLY_FORWARDING_RULE":            7,
		"SPOOFING_APPROVED":                8,
		"ARRIVE_AT_INSTANCE":               9,
		"ARRIVE_AT_INTERNAL_LOAD_BALANCER": 10,
		"ARRIVE_AT_EXTERNAL_LOAD_BALANCER": 11,
		"ARRIVE_AT_VPN_GATEWAY":            12,
		"ARRIVE_AT_VPN_TUNNEL":             13,
		"NAT":                              14,
		"PROXY_CONNECTION":                 15,
		"DELIVER":                          16,
		"DROP":                             17,
		"FORWARD":                          18,
		"ABORT":                            19,
		"VIEWER_PERMISSION_MISSING":        20,
	}
)

func (x Step_State) Enum() *Step_State {
	p := new(Step_State)
	*p = x
	return p
}

func (x Step_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Step_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[0].Descriptor()
}

func (Step_State) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[0]
}

func (x Step_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Step_State.Descriptor instead.
func (Step_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{1, 0}
}

// The firewall rule's type.
type FirewallInfo_FirewallRuleType int32

const (
	// Unspecified type.
	FirewallInfo_FIREWALL_RULE_TYPE_UNSPECIFIED FirewallInfo_FirewallRuleType = 0
	// Hierarchical firewall policy rule. For details, see
	// [Hierarchical firewall policies
	// overview](https://cloud.google.com/vpc/docs/firewall-policies).
	FirewallInfo_HIERARCHICAL_FIREWALL_POLICY_RULE FirewallInfo_FirewallRuleType = 1
	// VPC firewall rule. For details, see
	// [VPC firewall rules
	// overview](https://cloud.google.com/vpc/docs/firewalls).
	FirewallInfo_VPC_FIREWALL_RULE FirewallInfo_FirewallRuleType = 2
	// Implied VPC firewall rule. For details, see
	// [Implied
	// rules](https://cloud.google.com/vpc/docs/firewalls#default_firewall_rules).
	FirewallInfo_IMPLIED_VPC_FIREWALL_RULE FirewallInfo_FirewallRuleType = 3
)

// Enum value maps for FirewallInfo_FirewallRuleType.
var (
	FirewallInfo_FirewallRuleType_name = map[int32]string{
		0: "FIREWALL_RULE_TYPE_UNSPECIFIED",
		1: "HIERARCHICAL_FIREWALL_POLICY_RULE",
		2: "VPC_FIREWALL_RULE",
		3: "IMPLIED_VPC_FIREWALL_RULE",
	}
	FirewallInfo_FirewallRuleType_value = map[string]int32{
		"FIREWALL_RULE_TYPE_UNSPECIFIED":    0,
		"HIERARCHICAL_FIREWALL_POLICY_RULE": 1,
		"VPC_FIREWALL_RULE":                 2,
		"IMPLIED_VPC_FIREWALL_RULE":         3,
	}
)

func (x FirewallInfo_FirewallRuleType) Enum() *FirewallInfo_FirewallRuleType {
	p := new(FirewallInfo_FirewallRuleType)
	*p = x
	return p
}

func (x FirewallInfo_FirewallRuleType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FirewallInfo_FirewallRuleType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[1].Descriptor()
}

func (FirewallInfo_FirewallRuleType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[1]
}

func (x FirewallInfo_FirewallRuleType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FirewallInfo_FirewallRuleType.Descriptor instead.
func (FirewallInfo_FirewallRuleType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{4, 0}
}

// Type of route:
type RouteInfo_RouteType int32

const (
	// Unspecified type. Default value.
	RouteInfo_ROUTE_TYPE_UNSPECIFIED RouteInfo_RouteType = 0
	// Route is a subnet route automatically created by the system.
	RouteInfo_SUBNET RouteInfo_RouteType = 1
	// Static route created by the user, including the default route to the
	// internet.
	RouteInfo_STATIC RouteInfo_RouteType = 2
	// Dynamic route exchanged between BGP peers.
	RouteInfo_DYNAMIC RouteInfo_RouteType = 3
	// A subnet route received from peering network.
	RouteInfo_PEERING_SUBNET RouteInfo_RouteType = 4
	// A static route received from peering network.
	RouteInfo_PEERING_STATIC RouteInfo_RouteType = 5
	// A dynamic route received from peering network.
	RouteInfo_PEERING_DYNAMIC RouteInfo_RouteType = 6
)

// Enum value maps for RouteInfo_RouteType.
var (
	RouteInfo_RouteType_name = map[int32]string{
		0: "ROUTE_TYPE_UNSPECIFIED",
		1: "SUBNET",
		2: "STATIC",
		3: "DYNAMIC",
		4: "PEERING_SUBNET",
		5: "PEERING_STATIC",
		6: "PEERING_DYNAMIC",
	}
	RouteInfo_RouteType_value = map[string]int32{
		"ROUTE_TYPE_UNSPECIFIED": 0,
		"SUBNET":                 1,
		"STATIC":                 2,
		"DYNAMIC":                3,
		"PEERING_SUBNET":         4,
		"PEERING_STATIC":         5,
		"PEERING_DYNAMIC":        6,
	}
)

func (x RouteInfo_RouteType) Enum() *RouteInfo_RouteType {
	p := new(RouteInfo_RouteType)
	*p = x
	return p
}

func (x RouteInfo_RouteType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouteInfo_RouteType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[2].Descriptor()
}

func (RouteInfo_RouteType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[2]
}

func (x RouteInfo_RouteType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouteInfo_RouteType.Descriptor instead.
func (RouteInfo_RouteType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{5, 0}
}

// Type of next hop:
type RouteInfo_NextHopType int32

const (
	// Unspecified type. Default value.
	RouteInfo_NEXT_HOP_TYPE_UNSPECIFIED RouteInfo_NextHopType = 0
	// Next hop is an IP address.
	RouteInfo_NEXT_HOP_IP RouteInfo_NextHopType = 1
	// Next hop is a Compute Engine instance.
	RouteInfo_NEXT_HOP_INSTANCE RouteInfo_NextHopType = 2
	// Next hop is a VPC network gateway.
	RouteInfo_NEXT_HOP_NETWORK RouteInfo_NextHopType = 3
	// Next hop is a peering VPC.
	RouteInfo_NEXT_HOP_PEERING RouteInfo_NextHopType = 4
	// Next hop is an interconnect.
	RouteInfo_NEXT_HOP_INTERCONNECT RouteInfo_NextHopType = 5
	// Next hop is a VPN tunnel.
	RouteInfo_NEXT_HOP_VPN_TUNNEL RouteInfo_NextHopType = 6
	// Next hop is a VPN gateway. This scenario only happens when tracing
	// connectivity from an on-premises network to Google Cloud through a VPN.
	// The analysis simulates a packet departing from the on-premises network
	// through a VPN tunnel and arriving at a Cloud VPN gateway.
	RouteInfo_NEXT_HOP_VPN_GATEWAY RouteInfo_NextHopType = 7
	// Next hop is an internet gateway.
	RouteInfo_NEXT_HOP_INTERNET_GATEWAY RouteInfo_NextHopType = 8
	// Next hop is blackhole; that is, the next hop either does not exist or is
	// not running.
	RouteInfo_NEXT_HOP_BLACKHOLE RouteInfo_NextHopType = 9
	// Next hop is the forwarding rule of an Internal Load Balancer.
	RouteInfo_NEXT_HOP_ILB RouteInfo_NextHopType = 10
)

// Enum value maps for RouteInfo_NextHopType.
var (
	RouteInfo_NextHopType_name = map[int32]string{
		0:  "NEXT_HOP_TYPE_UNSPECIFIED",
		1:  "NEXT_HOP_IP",
		2:  "NEXT_HOP_INSTANCE",
		3:  "NEXT_HOP_NETWORK",
		4:  "NEXT_HOP_PEERING",
		5:  "NEXT_HOP_INTERCONNECT",
		6:  "NEXT_HOP_VPN_TUNNEL",
		7:  "NEXT_HOP_VPN_GATEWAY",
		8:  "NEXT_HOP_INTERNET_GATEWAY",
		9:  "NEXT_HOP_BLACKHOLE",
		10: "NEXT_HOP_ILB",
	}
	RouteInfo_NextHopType_value = map[string]int32{
		"NEXT_HOP_TYPE_UNSPECIFIED": 0,
		"NEXT_HOP_IP":               1,
		"NEXT_HOP_INSTANCE":         2,
		"NEXT_HOP_NETWORK":          3,
		"NEXT_HOP_PEERING":          4,
		"NEXT_HOP_INTERCONNECT":     5,
		"NEXT_HOP_VPN_TUNNEL":       6,
		"NEXT_HOP_VPN_GATEWAY":      7,
		"NEXT_HOP_INTERNET_GATEWAY": 8,
		"NEXT_HOP_BLACKHOLE":        9,
		"NEXT_HOP_ILB":              10,
	}
)

func (x RouteInfo_NextHopType) Enum() *RouteInfo_NextHopType {
	p := new(RouteInfo_NextHopType)
	*p = x
	return p
}

func (x RouteInfo_NextHopType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouteInfo_NextHopType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[3].Descriptor()
}

func (RouteInfo_NextHopType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[3]
}

func (x RouteInfo_NextHopType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouteInfo_NextHopType.Descriptor instead.
func (RouteInfo_NextHopType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{5, 1}
}

// The type definition for a load balancer:
type LoadBalancerInfo_LoadBalancerType int32

const (
	// Type is unspecified.
	LoadBalancerInfo_LOAD_BALANCER_TYPE_UNSPECIFIED LoadBalancerInfo_LoadBalancerType = 0
	// Internal TCP/UDP load balancer.
	LoadBalancerInfo_INTERNAL_TCP_UDP LoadBalancerInfo_LoadBalancerType = 1
	// Network TCP/UDP load balancer.
	LoadBalancerInfo_NETWORK_TCP_UDP LoadBalancerInfo_LoadBalancerType = 2
	// HTTP(S) proxy load balancer.
	LoadBalancerInfo_HTTP_PROXY LoadBalancerInfo_LoadBalancerType = 3
	// TCP proxy load balancer.
	LoadBalancerInfo_TCP_PROXY LoadBalancerInfo_LoadBalancerType = 4
	// SSL proxy load balancer.
	LoadBalancerInfo_SSL_PROXY LoadBalancerInfo_LoadBalancerType = 5
)

// Enum value maps for LoadBalancerInfo_LoadBalancerType.
var (
	LoadBalancerInfo_LoadBalancerType_name = map[int32]string{
		0: "LOAD_BALANCER_TYPE_UNSPECIFIED",
		1: "INTERNAL_TCP_UDP",
		2: "NETWORK_TCP_UDP",
		3: "HTTP_PROXY",
		4: "TCP_PROXY",
		5: "SSL_PROXY",
	}
	LoadBalancerInfo_LoadBalancerType_value = map[string]int32{
		"LOAD_BALANCER_TYPE_UNSPECIFIED": 0,
		"INTERNAL_TCP_UDP":               1,
		"NETWORK_TCP_UDP":                2,
		"HTTP_PROXY":                     3,
		"TCP_PROXY":                      4,
		"SSL_PROXY":                      5,
	}
)

func (x LoadBalancerInfo_LoadBalancerType) Enum() *LoadBalancerInfo_LoadBalancerType {
	p := new(LoadBalancerInfo_LoadBalancerType)
	*p = x
	return p
}

func (x LoadBalancerInfo_LoadBalancerType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoadBalancerInfo_LoadBalancerType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[4].Descriptor()
}

func (LoadBalancerInfo_LoadBalancerType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[4]
}

func (x LoadBalancerInfo_LoadBalancerType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoadBalancerInfo_LoadBalancerType.Descriptor instead.
func (LoadBalancerInfo_LoadBalancerType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{7, 0}
}

// The type definition for a load balancer backend configuration:
type LoadBalancerInfo_BackendType int32

const (
	// Type is unspecified.
	LoadBalancerInfo_BACKEND_TYPE_UNSPECIFIED LoadBalancerInfo_BackendType = 0
	// Backend Service as the load balancer's backend.
	LoadBalancerInfo_BACKEND_SERVICE LoadBalancerInfo_BackendType = 1
	// Target Pool as the load balancer's backend.
	LoadBalancerInfo_TARGET_POOL LoadBalancerInfo_BackendType = 2
)

// Enum value maps for LoadBalancerInfo_BackendType.
var (
	LoadBalancerInfo_BackendType_name = map[int32]string{
		0: "BACKEND_TYPE_UNSPECIFIED",
		1: "BACKEND_SERVICE",
		2: "TARGET_POOL",
	}
	LoadBalancerInfo_BackendType_value = map[string]int32{
		"BACKEND_TYPE_UNSPECIFIED": 0,
		"BACKEND_SERVICE":          1,
		"TARGET_POOL":              2,
	}
)

func (x LoadBalancerInfo_BackendType) Enum() *LoadBalancerInfo_BackendType {
	p := new(LoadBalancerInfo_BackendType)
	*p = x
	return p
}

func (x LoadBalancerInfo_BackendType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoadBalancerInfo_BackendType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[5].Descriptor()
}

func (LoadBalancerInfo_BackendType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[5]
}

func (x LoadBalancerInfo_BackendType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoadBalancerInfo_BackendType.Descriptor instead.
func (LoadBalancerInfo_BackendType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{7, 1}
}

// State of a health check firewall configuration:
type LoadBalancerBackend_HealthCheckFirewallState int32

const (
	// State is unspecified. Default state if not populated.
	LoadBalancerBackend_HEALTH_CHECK_FIREWALL_STATE_UNSPECIFIED LoadBalancerBackend_HealthCheckFirewallState = 0
	// There are configured firewall rules to allow health check probes to the
	// backend.
	LoadBalancerBackend_CONFIGURED LoadBalancerBackend_HealthCheckFirewallState = 1
	// There are firewall rules configured to allow partial health check ranges
	// or block all health check ranges.
	// If a health check probe is sent from denied IP ranges,
	// the health check to the backend will fail. Then, the backend will be
	// marked unhealthy and will not receive traffic sent to the load balancer.
	LoadBalancerBackend_MISCONFIGURED LoadBalancerBackend_HealthCheckFirewallState = 2
)

// Enum value maps for LoadBalancerBackend_HealthCheckFirewallState.
var (
	LoadBalancerBackend_HealthCheckFirewallState_name = map[int32]string{
		0: "HEALTH_CHECK_FIREWALL_STATE_UNSPECIFIED",
		1: "CONFIGURED",
		2: "MISCONFIGURED",
	}
	LoadBalancerBackend_HealthCheckFirewallState_value = map[string]int32{
		"HEALTH_CHECK_FIREWALL_STATE_UNSPECIFIED": 0,
		"CONFIGURED":    1,
		"MISCONFIGURED": 2,
	}
)

func (x LoadBalancerBackend_HealthCheckFirewallState) Enum() *LoadBalancerBackend_HealthCheckFirewallState {
	p := new(LoadBalancerBackend_HealthCheckFirewallState)
	*p = x
	return p
}

func (x LoadBalancerBackend_HealthCheckFirewallState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoadBalancerBackend_HealthCheckFirewallState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[6].Descriptor()
}

func (LoadBalancerBackend_HealthCheckFirewallState) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[6]
}

func (x LoadBalancerBackend_HealthCheckFirewallState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoadBalancerBackend_HealthCheckFirewallState.Descriptor instead.
func (LoadBalancerBackend_HealthCheckFirewallState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{8, 0}
}

// Types of VPN routing policy. For details, refer to [Networks and Tunnel
// routing](https://cloud.google.com/network-connectivity/docs/vpn/concepts/choosing-networks-routing/).
type VpnTunnelInfo_RoutingType int32

const (
	// Unspecified type. Default value.
	VpnTunnelInfo_ROUTING_TYPE_UNSPECIFIED VpnTunnelInfo_RoutingType = 0
	// Route based VPN.
	VpnTunnelInfo_ROUTE_BASED VpnTunnelInfo_RoutingType = 1
	// Policy based routing.
	VpnTunnelInfo_POLICY_BASED VpnTunnelInfo_RoutingType = 2
	// Dynamic (BGP) routing.
	VpnTunnelInfo_DYNAMIC VpnTunnelInfo_RoutingType = 3
)

// Enum value maps for VpnTunnelInfo_RoutingType.
var (
	VpnTunnelInfo_RoutingType_name = map[int32]string{
		0: "ROUTING_TYPE_UNSPECIFIED",
		1: "ROUTE_BASED",
		2: "POLICY_BASED",
		3: "DYNAMIC",
	}
	VpnTunnelInfo_RoutingType_value = map[string]int32{
		"ROUTING_TYPE_UNSPECIFIED": 0,
		"ROUTE_BASED":              1,
		"POLICY_BASED":             2,
		"DYNAMIC":                  3,
	}
)

func (x VpnTunnelInfo_RoutingType) Enum() *VpnTunnelInfo_RoutingType {
	p := new(VpnTunnelInfo_RoutingType)
	*p = x
	return p
}

func (x VpnTunnelInfo_RoutingType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VpnTunnelInfo_RoutingType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[7].Descriptor()
}

func (VpnTunnelInfo_RoutingType) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[7]
}

func (x VpnTunnelInfo_RoutingType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VpnTunnelInfo_RoutingType.Descriptor instead.
func (VpnTunnelInfo_RoutingType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{10, 0}
}

// Deliver target types:
type DeliverInfo_Target int32

const (
	// Target not specified.
	DeliverInfo_TARGET_UNSPECIFIED DeliverInfo_Target = 0
	// Target is a Compute Engine instance.
	DeliverInfo_INSTANCE DeliverInfo_Target = 1
	// Target is the internet.
	DeliverInfo_INTERNET DeliverInfo_Target = 2
	// Target is a Google API.
	DeliverInfo_GOOGLE_API DeliverInfo_Target = 3
	// Target is a Google Kubernetes Engine cluster master.
	DeliverInfo_GKE_MASTER DeliverInfo_Target = 4
	// Target is a Cloud SQL instance.
	DeliverInfo_CLOUD_SQL_INSTANCE DeliverInfo_Target = 5
)

// Enum value maps for DeliverInfo_Target.
var (
	DeliverInfo_Target_name = map[int32]string{
		0: "TARGET_UNSPECIFIED",
		1: "INSTANCE",
		2: "INTERNET",
		3: "GOOGLE_API",
		4: "GKE_MASTER",
		5: "CLOUD_SQL_INSTANCE",
	}
	DeliverInfo_Target_value = map[string]int32{
		"TARGET_UNSPECIFIED": 0,
		"INSTANCE":           1,
		"INTERNET":           2,
		"GOOGLE_API":         3,
		"GKE_MASTER":         4,
		"CLOUD_SQL_INSTANCE": 5,
	}
)

func (x DeliverInfo_Target) Enum() *DeliverInfo_Target {
	p := new(DeliverInfo_Target)
	*p = x
	return p
}

func (x DeliverInfo_Target) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeliverInfo_Target) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[8].Descriptor()
}

func (DeliverInfo_Target) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[8]
}

func (x DeliverInfo_Target) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeliverInfo_Target.Descriptor instead.
func (DeliverInfo_Target) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{12, 0}
}

// Forward target types.
type ForwardInfo_Target int32

const (
	// Target not specified.
	ForwardInfo_TARGET_UNSPECIFIED ForwardInfo_Target = 0
	// Forwarded to a VPC peering network.
	ForwardInfo_PEERING_VPC ForwardInfo_Target = 1
	// Forwarded to a Cloud VPN gateway.
	ForwardInfo_VPN_GATEWAY ForwardInfo_Target = 2
	// Forwarded to a Cloud Interconnect connection.
	ForwardInfo_INTERCONNECT ForwardInfo_Target = 3
	// Forwarded to a Google Kubernetes Engine Container cluster master.
	ForwardInfo_GKE_MASTER ForwardInfo_Target = 4
	// Forwarded to the next hop of a custom route imported from a peering VPC.
	ForwardInfo_IMPORTED_CUSTOM_ROUTE_NEXT_HOP ForwardInfo_Target = 5
	// Forwarded to a Cloud SQL instance.
	ForwardInfo_CLOUD_SQL_INSTANCE ForwardInfo_Target = 6
)

// Enum value maps for ForwardInfo_Target.
var (
	ForwardInfo_Target_name = map[int32]string{
		0: "TARGET_UNSPECIFIED",
		1: "PEERING_VPC",
		2: "VPN_GATEWAY",
		3: "INTERCONNECT",
		4: "GKE_MASTER",
		5: "IMPORTED_CUSTOM_ROUTE_NEXT_HOP",
		6: "CLOUD_SQL_INSTANCE",
	}
	ForwardInfo_Target_value = map[string]int32{
		"TARGET_UNSPECIFIED":             0,
		"PEERING_VPC":                    1,
		"VPN_GATEWAY":                    2,
		"INTERCONNECT":                   3,
		"GKE_MASTER":                     4,
		"IMPORTED_CUSTOM_ROUTE_NEXT_HOP": 5,
		"CLOUD_SQL_INSTANCE":             6,
	}
)

func (x ForwardInfo_Target) Enum() *ForwardInfo_Target {
	p := new(ForwardInfo_Target)
	*p = x
	return p
}

func (x ForwardInfo_Target) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForwardInfo_Target) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[9].Descriptor()
}

func (ForwardInfo_Target) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[9]
}

func (x ForwardInfo_Target) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForwardInfo_Target.Descriptor instead.
func (ForwardInfo_Target) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{13, 0}
}

// Abort cause types:
type AbortInfo_Cause int32

const (
	// Cause is unspecified.
	AbortInfo_CAUSE_UNSPECIFIED AbortInfo_Cause = 0
	// Aborted due to unknown network.
	// The reachability analysis cannot proceed because the user does not have
	// access to the host project's network configurations, including firewall
	// rules and routes. This happens when the project is a service project and
	// the endpoints being traced are in the host project's network.
	AbortInfo_UNKNOWN_NETWORK AbortInfo_Cause = 1
	// Aborted because the IP address(es) are unknown.
	AbortInfo_UNKNOWN_IP AbortInfo_Cause = 2
	// Aborted because no project information can be derived from the test
	// input.
	AbortInfo_UNKNOWN_PROJECT AbortInfo_Cause = 3
	// Aborted because the user lacks the permission to access all or part of
	// the network configurations required to run the test.
	AbortInfo_PERMISSION_DENIED AbortInfo_Cause = 4
	// Aborted because no valid source endpoint is derived from the input test
	// request.
	AbortInfo_NO_SOURCE_LOCATION AbortInfo_Cause = 5
	// Aborted because the source and/or destination endpoint specified in
	// the test are invalid. The possible reasons that an endpoint is
	// invalid include: malformed IP address; nonexistent instance or
	// network URI; IP address not in the range of specified network URI; and
	// instance not owning the network interface in the specified network.
	AbortInfo_INVALID_ARGUMENT AbortInfo_Cause = 6
	// Aborted because traffic is sent from a public IP to an instance without
	// an external IP.
	AbortInfo_NO_EXTERNAL_IP AbortInfo_Cause = 7
	// Aborted because none of the traces matches destination information
	// specified in the input test request.
	AbortInfo_UNINTENDED_DESTINATION AbortInfo_Cause = 8
	// Aborted because the number of steps in the trace exceeding a certain
	// limit which may be caused by routing loop.
	AbortInfo_TRACE_TOO_LONG AbortInfo_Cause = 9
	// Aborted due to internal server error.
	AbortInfo_INTERNAL_ERROR AbortInfo_Cause = 10
	// Aborted because the source endpoint could not be found.
	AbortInfo_SOURCE_ENDPOINT_NOT_FOUND AbortInfo_Cause = 11
	// Aborted because the source network does not match the source endpoint.
	AbortInfo_MISMATCHED_SOURCE_NETWORK AbortInfo_Cause = 12
	// Aborted because the destination endpoint could not be found.
	AbortInfo_DESTINATION_ENDPOINT_NOT_FOUND AbortInfo_Cause = 13
	// Aborted because the destination network does not match the destination
	// endpoint.
	AbortInfo_MISMATCHED_DESTINATION_NETWORK AbortInfo_Cause = 14
)

// Enum value maps for AbortInfo_Cause.
var (
	AbortInfo_Cause_name = map[int32]string{
		0:  "CAUSE_UNSPECIFIED",
		1:  "UNKNOWN_NETWORK",
		2:  "UNKNOWN_IP",
		3:  "UNKNOWN_PROJECT",
		4:  "PERMISSION_DENIED",
		5:  "NO_SOURCE_LOCATION",
		6:  "INVALID_ARGUMENT",
		7:  "NO_EXTERNAL_IP",
		8:  "UNINTENDED_DESTINATION",
		9:  "TRACE_TOO_LONG",
		10: "INTERNAL_ERROR",
		11: "SOURCE_ENDPOINT_NOT_FOUND",
		12: "MISMATCHED_SOURCE_NETWORK",
		13: "DESTINATION_ENDPOINT_NOT_FOUND",
		14: "MISMATCHED_DESTINATION_NETWORK",
	}
	AbortInfo_Cause_value = map[string]int32{
		"CAUSE_UNSPECIFIED":              0,
		"UNKNOWN_NETWORK":                1,
		"UNKNOWN_IP":                     2,
		"UNKNOWN_PROJECT":                3,
		"PERMISSION_DENIED":              4,
		"NO_SOURCE_LOCATION":             5,
		"INVALID_ARGUMENT":               6,
		"NO_EXTERNAL_IP":                 7,
		"UNINTENDED_DESTINATION":         8,
		"TRACE_TOO_LONG":                 9,
		"INTERNAL_ERROR":                 10,
		"SOURCE_ENDPOINT_NOT_FOUND":      11,
		"MISMATCHED_SOURCE_NETWORK":      12,
		"DESTINATION_ENDPOINT_NOT_FOUND": 13,
		"MISMATCHED_DESTINATION_NETWORK": 14,
	}
)

func (x AbortInfo_Cause) Enum() *AbortInfo_Cause {
	p := new(AbortInfo_Cause)
	*p = x
	return p
}

func (x AbortInfo_Cause) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AbortInfo_Cause) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[10].Descriptor()
}

func (AbortInfo_Cause) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[10]
}

func (x AbortInfo_Cause) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AbortInfo_Cause.Descriptor instead.
func (AbortInfo_Cause) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{14, 0}
}

// Drop cause types:
type DropInfo_Cause int32

const (
	// Cause is unspecified.
	DropInfo_CAUSE_UNSPECIFIED DropInfo_Cause = 0
	// Destination external address cannot be resolved to a known target. If
	// the address is used in a Google Cloud project, provide the project ID
	// as test input.
	DropInfo_UNKNOWN_EXTERNAL_ADDRESS DropInfo_Cause = 1
	// A Compute Engine instance can only send or receive a packet with a
	// foreign IP address if ip_forward is enabled.
	DropInfo_FOREIGN_IP_DISALLOWED DropInfo_Cause = 2
	// Dropped due to a firewall rule, unless allowed due to connection
	// tracking.
	DropInfo_FIREWALL_RULE DropInfo_Cause = 3
	// Dropped due to no routes.
	DropInfo_NO_ROUTE DropInfo_Cause = 4
	// Dropped due to invalid route. Route's next hop is a blackhole.
	DropInfo_ROUTE_BLACKHOLE DropInfo_Cause = 5
	// Packet is sent to a wrong (unintended) network. Example: you trace a
	// packet from VM1:Network1 to VM2:Network2, however, the route configured
	// in Network1 sends the packet destined for VM2's IP addresss to Network3.
	DropInfo_ROUTE_WRONG_NETWORK DropInfo_Cause = 6
	// Packet with internal destination address sent to the internet gateway.
	DropInfo_PRIVATE_TRAFFIC_TO_INTERNET DropInfo_Cause = 7
	// Instance with only an internal IP address tries to access Google API and
	// services, but private Google access is not enabled.
	DropInfo_PRIVATE_GOOGLE_ACCESS_DISALLOWED DropInfo_Cause = 8
	// Instance with only an internal IP address tries to access external hosts,
	// but Cloud NAT is not enabled in the subnet, unless special configurations
	// on a VM allow this connection. For more details, see [Special
	// configurations for VM
	// instances](https://cloud.google.com/vpc/docs/special-configurations).
	DropInfo_NO_EXTERNAL_ADDRESS DropInfo_Cause = 9
	// Destination internal address cannot be resolved to a known target. If
	// this is a shared VPC scenario, verify if the service project ID is
	// provided as test input. Otherwise, verify if the IP address is being
	// used in the project.
	DropInfo_UNKNOWN_INTERNAL_ADDRESS DropInfo_Cause = 10
	// Forwarding rule's protocol and ports do not match the packet header.
	DropInfo_FORWARDING_RULE_MISMATCH DropInfo_Cause = 11
	// Forwarding rule does not have backends configured.
	DropInfo_FORWARDING_RULE_NO_INSTANCES DropInfo_Cause = 12
	// Firewalls block the health check probes to the backends and cause
	// the backends to be unavailable for traffic from the load balancer.
	// For more details, see [Health check firewall
	// rules](https://cloud.google.com/load-balancing/docs/health-checks#firewall_rules).
	DropInfo_FIREWALL_BLOCKING_LOAD_BALANCER_BACKEND_HEALTH_CHECK DropInfo_Cause = 13
	// Packet is sent from or to a Compute Engine instance that is not in a
	// running state.
	DropInfo_INSTANCE_NOT_RUNNING DropInfo_Cause = 14
	// The type of traffic is blocked and the user cannot configure a firewall
	// rule to enable it. See [Always blocked
	// traffic](https://cloud.google.com/vpc/docs/firewalls#blockedtraffic) for
	// more details.
	DropInfo_TRAFFIC_TYPE_BLOCKED DropInfo_Cause = 15
	// Access to Google Kubernetes Engine cluster master's endpoint is not
	// authorized. See [Access to the cluster
	// endpoints](https://cloud.google.com/kubernetes-engine/docs/how-to/private-clusters#access_to_the_cluster_endpoints)
	// for more details.
	DropInfo_GKE_MASTER_UNAUTHORIZED_ACCESS DropInfo_Cause = 16
	// Access to the Cloud SQL instance endpoint is not authorized.
	// See [Authorizing with authorized
	// networks](https://cloud.google.com/sql/docs/mysql/authorize-networks) for
	// more details.
	DropInfo_CLOUD_SQL_INSTANCE_UNAUTHORIZED_ACCESS DropInfo_Cause = 17
	// Packet was dropped inside Google Kubernetes Engine Service.
	DropInfo_DROPPED_INSIDE_GKE_SERVICE DropInfo_Cause = 18
	// Packet was dropped inside Cloud SQL Service.
	DropInfo_DROPPED_INSIDE_CLOUD_SQL_SERVICE DropInfo_Cause = 19
	// Packet was dropped because there is no peering between the originating
	// network and the Google Managed Services Network.
	DropInfo_GOOGLE_MANAGED_SERVICE_NO_PEERING DropInfo_Cause = 20
	// Packet was dropped because the Cloud SQL instance has neither a private
	// nor a public IP address.
	DropInfo_CLOUD_SQL_INSTANCE_NO_IP_ADDRESS DropInfo_Cause = 21
)

// Enum value maps for DropInfo_Cause.
var (
	DropInfo_Cause_name = map[int32]string{
		0:  "CAUSE_UNSPECIFIED",
		1:  "UNKNOWN_EXTERNAL_ADDRESS",
		2:  "FOREIGN_IP_DISALLOWED",
		3:  "FIREWALL_RULE",
		4:  "NO_ROUTE",
		5:  "ROUTE_BLACKHOLE",
		6:  "ROUTE_WRONG_NETWORK",
		7:  "PRIVATE_TRAFFIC_TO_INTERNET",
		8:  "PRIVATE_GOOGLE_ACCESS_DISALLOWED",
		9:  "NO_EXTERNAL_ADDRESS",
		10: "UNKNOWN_INTERNAL_ADDRESS",
		11: "FORWARDING_RULE_MISMATCH",
		12: "FORWARDING_RULE_NO_INSTANCES",
		13: "FIREWALL_BLOCKING_LOAD_BALANCER_BACKEND_HEALTH_CHECK",
		14: "INSTANCE_NOT_RUNNING",
		15: "TRAFFIC_TYPE_BLOCKED",
		16: "GKE_MASTER_UNAUTHORIZED_ACCESS",
		17: "CLOUD_SQL_INSTANCE_UNAUTHORIZED_ACCESS",
		18: "DROPPED_INSIDE_GKE_SERVICE",
		19: "DROPPED_INSIDE_CLOUD_SQL_SERVICE",
		20: "GOOGLE_MANAGED_SERVICE_NO_PEERING",
		21: "CLOUD_SQL_INSTANCE_NO_IP_ADDRESS",
	}
	DropInfo_Cause_value = map[string]int32{
		"CAUSE_UNSPECIFIED":                                    0,
		"UNKNOWN_EXTERNAL_ADDRESS":                             1,
		"FOREIGN_IP_DISALLOWED":                                2,
		"FIREWALL_RULE":                                        3,
		"NO_ROUTE":                                             4,
		"ROUTE_BLACKHOLE":                                      5,
		"ROUTE_WRONG_NETWORK":                                  6,
		"PRIVATE_TRAFFIC_TO_INTERNET":                          7,
		"PRIVATE_GOOGLE_ACCESS_DISALLOWED":                     8,
		"NO_EXTERNAL_ADDRESS":                                  9,
		"UNKNOWN_INTERNAL_ADDRESS":                             10,
		"FORWARDING_RULE_MISMATCH":                             11,
		"FORWARDING_RULE_NO_INSTANCES":                         12,
		"FIREWALL_BLOCKING_LOAD_BALANCER_BACKEND_HEALTH_CHECK": 13,
		"INSTANCE_NOT_RUNNING":                                 14,
		"TRAFFIC_TYPE_BLOCKED":                                 15,
		"GKE_MASTER_UNAUTHORIZED_ACCESS":                       16,
		"CLOUD_SQL_INSTANCE_UNAUTHORIZED_ACCESS":               17,
		"DROPPED_INSIDE_GKE_SERVICE":                           18,
		"DROPPED_INSIDE_CLOUD_SQL_SERVICE":                     19,
		"GOOGLE_MANAGED_SERVICE_NO_PEERING":                    20,
		"CLOUD_SQL_INSTANCE_NO_IP_ADDRESS":                     21,
	}
)

func (x DropInfo_Cause) Enum() *DropInfo_Cause {
	p := new(DropInfo_Cause)
	*p = x
	return p
}

func (x DropInfo_Cause) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DropInfo_Cause) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[11].Descriptor()
}

func (DropInfo_Cause) Type() protoreflect.EnumType {
	return &file_google_cloud_networkmanagement_v1_trace_proto_enumTypes[11]
}

func (x DropInfo_Cause) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DropInfo_Cause.Descriptor instead.
func (DropInfo_Cause) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{15, 0}
}

// Trace represents one simulated packet forwarding path.
//
//   * Each trace contains multiple ordered steps.
//   * Each step is in a particular state with associated configuration.
//   * State is categorized as final or non-final states.
//   * Each final state has a reason associated.
//   * Each trace must end with a final state (the last step).
// ```
//   |---------------------Trace----------------------|
//   Step1(State) Step2(State) ---  StepN(State(final))
// ```
type Trace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Derived from the source and destination endpoints definition specified by
	// user request, and validated by the data plane model.
	// If there are multiple traces starting from different source locations, then
	// the endpoint_info may be different between traces.
	EndpointInfo *EndpointInfo `protobuf:"bytes,1,opt,name=endpoint_info,json=endpointInfo,proto3" json:"endpoint_info,omitempty"`
	// A trace of a test contains multiple steps from the initial state to the
	// final state (delivered, dropped, forwarded, or aborted).
	//
	// The steps are ordered by the processing sequence within the simulated
	// network state machine. It is critical to preserve the order of the steps
	// and avoid reordering or sorting them.
	Steps []*Step `protobuf:"bytes,2,rep,name=steps,proto3" json:"steps,omitempty"`
}

func (x *Trace) Reset() {
	*x = Trace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trace) ProtoMessage() {}

func (x *Trace) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trace.ProtoReflect.Descriptor instead.
func (*Trace) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{0}
}

func (x *Trace) GetEndpointInfo() *EndpointInfo {
	if x != nil {
		return x.EndpointInfo
	}
	return nil
}

func (x *Trace) GetSteps() []*Step {
	if x != nil {
		return x.Steps
	}
	return nil
}

// A simulated forwarding path is composed of multiple steps.
// Each step has a well-defined state and an associated configuration.
type Step struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A description of the step. Usually this is a summary of the state.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Each step is in one of the pre-defined states.
	State Step_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.networkmanagement.v1.Step_State" json:"state,omitempty"`
	// This is a step that leads to the final state Drop.
	CausesDrop bool `protobuf:"varint,3,opt,name=causes_drop,json=causesDrop,proto3" json:"causes_drop,omitempty"`
	// Project ID that contains the configuration this step is validating.
	ProjectId string `protobuf:"bytes,4,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Configuration or metadata associated with each step.
	// The configuration is filtered based on viewer's permission. If a viewer
	// has no permission to view the configuration in this step, for non-final
	// states a special state is populated (VIEWER_PERMISSION_MISSING), and for
	// final state the configuration is cleared.
	//
	// Types that are assignable to StepInfo:
	//	*Step_Instance
	//	*Step_Firewall
	//	*Step_Route
	//	*Step_Endpoint
	//	*Step_ForwardingRule
	//	*Step_VpnGateway
	//	*Step_VpnTunnel
	//	*Step_Deliver
	//	*Step_Forward
	//	*Step_Abort
	//	*Step_Drop
	//	*Step_LoadBalancer
	//	*Step_Network
	//	*Step_GkeMaster
	//	*Step_CloudSqlInstance
	StepInfo isStep_StepInfo `protobuf_oneof:"step_info"`
}

func (x *Step) Reset() {
	*x = Step{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Step) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Step) ProtoMessage() {}

func (x *Step) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Step.ProtoReflect.Descriptor instead.
func (*Step) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{1}
}

func (x *Step) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Step) GetState() Step_State {
	if x != nil {
		return x.State
	}
	return Step_STATE_UNSPECIFIED
}

func (x *Step) GetCausesDrop() bool {
	if x != nil {
		return x.CausesDrop
	}
	return false
}

func (x *Step) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (m *Step) GetStepInfo() isStep_StepInfo {
	if m != nil {
		return m.StepInfo
	}
	return nil
}

func (x *Step) GetInstance() *InstanceInfo {
	if x, ok := x.GetStepInfo().(*Step_Instance); ok {
		return x.Instance
	}
	return nil
}

func (x *Step) GetFirewall() *FirewallInfo {
	if x, ok := x.GetStepInfo().(*Step_Firewall); ok {
		return x.Firewall
	}
	return nil
}

func (x *Step) GetRoute() *RouteInfo {
	if x, ok := x.GetStepInfo().(*Step_Route); ok {
		return x.Route
	}
	return nil
}

func (x *Step) GetEndpoint() *EndpointInfo {
	if x, ok := x.GetStepInfo().(*Step_Endpoint); ok {
		return x.Endpoint
	}
	return nil
}

func (x *Step) GetForwardingRule() *ForwardingRuleInfo {
	if x, ok := x.GetStepInfo().(*Step_ForwardingRule); ok {
		return x.ForwardingRule
	}
	return nil
}

func (x *Step) GetVpnGateway() *VpnGatewayInfo {
	if x, ok := x.GetStepInfo().(*Step_VpnGateway); ok {
		return x.VpnGateway
	}
	return nil
}

func (x *Step) GetVpnTunnel() *VpnTunnelInfo {
	if x, ok := x.GetStepInfo().(*Step_VpnTunnel); ok {
		return x.VpnTunnel
	}
	return nil
}

func (x *Step) GetDeliver() *DeliverInfo {
	if x, ok := x.GetStepInfo().(*Step_Deliver); ok {
		return x.Deliver
	}
	return nil
}

func (x *Step) GetForward() *ForwardInfo {
	if x, ok := x.GetStepInfo().(*Step_Forward); ok {
		return x.Forward
	}
	return nil
}

func (x *Step) GetAbort() *AbortInfo {
	if x, ok := x.GetStepInfo().(*Step_Abort); ok {
		return x.Abort
	}
	return nil
}

func (x *Step) GetDrop() *DropInfo {
	if x, ok := x.GetStepInfo().(*Step_Drop); ok {
		return x.Drop
	}
	return nil
}

func (x *Step) GetLoadBalancer() *LoadBalancerInfo {
	if x, ok := x.GetStepInfo().(*Step_LoadBalancer); ok {
		return x.LoadBalancer
	}
	return nil
}

func (x *Step) GetNetwork() *NetworkInfo {
	if x, ok := x.GetStepInfo().(*Step_Network); ok {
		return x.Network
	}
	return nil
}

func (x *Step) GetGkeMaster() *GKEMasterInfo {
	if x, ok := x.GetStepInfo().(*Step_GkeMaster); ok {
		return x.GkeMaster
	}
	return nil
}

func (x *Step) GetCloudSqlInstance() *CloudSQLInstanceInfo {
	if x, ok := x.GetStepInfo().(*Step_CloudSqlInstance); ok {
		return x.CloudSqlInstance
	}
	return nil
}

type isStep_StepInfo interface {
	isStep_StepInfo()
}

type Step_Instance struct {
	// Display information of a Compute Engine instance.
	Instance *InstanceInfo `protobuf:"bytes,5,opt,name=instance,proto3,oneof"`
}

type Step_Firewall struct {
	// Display information of a Compute Engine firewall rule.
	Firewall *FirewallInfo `protobuf:"bytes,6,opt,name=firewall,proto3,oneof"`
}

type Step_Route struct {
	// Display information of a Compute Engine route.
	Route *RouteInfo `protobuf:"bytes,7,opt,name=route,proto3,oneof"`
}

type Step_Endpoint struct {
	// Display information of the source and destination under analysis.
	// The endpoint information in an intermediate state may differ with the
	// initial input, as it might be modified by state like NAT,
	// or Connection Proxy.
	Endpoint *EndpointInfo `protobuf:"bytes,8,opt,name=endpoint,proto3,oneof"`
}

type Step_ForwardingRule struct {
	// Display information of a Compute Engine forwarding rule.
	ForwardingRule *ForwardingRuleInfo `protobuf:"bytes,9,opt,name=forwarding_rule,json=forwardingRule,proto3,oneof"`
}

type Step_VpnGateway struct {
	// Display information of a Compute Engine VPN gateway.
	VpnGateway *VpnGatewayInfo `protobuf:"bytes,10,opt,name=vpn_gateway,json=vpnGateway,proto3,oneof"`
}

type Step_VpnTunnel struct {
	// Display information of a Compute Engine VPN tunnel.
	VpnTunnel *VpnTunnelInfo `protobuf:"bytes,11,opt,name=vpn_tunnel,json=vpnTunnel,proto3,oneof"`
}

type Step_Deliver struct {
	// Display information of the final state "deliver" and reason.
	Deliver *DeliverInfo `protobuf:"bytes,12,opt,name=deliver,proto3,oneof"`
}

type Step_Forward struct {
	// Display information of the final state "forward" and reason.
	Forward *ForwardInfo `protobuf:"bytes,13,opt,name=forward,proto3,oneof"`
}

type Step_Abort struct {
	// Display information of the final state "abort" and reason.
	Abort *AbortInfo `protobuf:"bytes,14,opt,name=abort,proto3,oneof"`
}

type Step_Drop struct {
	// Display information of the final state "drop" and reason.
	Drop *DropInfo `protobuf:"bytes,15,opt,name=drop,proto3,oneof"`
}

type Step_LoadBalancer struct {
	// Display information of the load balancers.
	LoadBalancer *LoadBalancerInfo `protobuf:"bytes,16,opt,name=load_balancer,json=loadBalancer,proto3,oneof"`
}

type Step_Network struct {
	// Display information of a Google Cloud network.
	Network *NetworkInfo `protobuf:"bytes,17,opt,name=network,proto3,oneof"`
}

type Step_GkeMaster struct {
	// Display information of a Google Kubernetes Engine cluster master.
	GkeMaster *GKEMasterInfo `protobuf:"bytes,18,opt,name=gke_master,json=gkeMaster,proto3,oneof"`
}

type Step_CloudSqlInstance struct {
	// Display information of a Cloud SQL instance.
	CloudSqlInstance *CloudSQLInstanceInfo `protobuf:"bytes,19,opt,name=cloud_sql_instance,json=cloudSqlInstance,proto3,oneof"`
}

func (*Step_Instance) isStep_StepInfo() {}

func (*Step_Firewall) isStep_StepInfo() {}

func (*Step_Route) isStep_StepInfo() {}

func (*Step_Endpoint) isStep_StepInfo() {}

func (*Step_ForwardingRule) isStep_StepInfo() {}

func (*Step_VpnGateway) isStep_StepInfo() {}

func (*Step_VpnTunnel) isStep_StepInfo() {}

func (*Step_Deliver) isStep_StepInfo() {}

func (*Step_Forward) isStep_StepInfo() {}

func (*Step_Abort) isStep_StepInfo() {}

func (*Step_Drop) isStep_StepInfo() {}

func (*Step_LoadBalancer) isStep_StepInfo() {}

func (*Step_Network) isStep_StepInfo() {}

func (*Step_GkeMaster) isStep_StepInfo() {}

func (*Step_CloudSqlInstance) isStep_StepInfo() {}

// For display only. Metadata associated with a Compute Engine instance.
type InstanceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a Compute Engine instance.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a Compute Engine instance.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Name of the network interface of a Compute Engine instance.
	Interface string `protobuf:"bytes,3,opt,name=interface,proto3" json:"interface,omitempty"`
	// URI of a Compute Engine network.
	NetworkUri string `protobuf:"bytes,4,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// Internal IP address of the network interface.
	InternalIp string `protobuf:"bytes,5,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// External IP address of the network interface.
	ExternalIp string `protobuf:"bytes,6,opt,name=external_ip,json=externalIp,proto3" json:"external_ip,omitempty"`
	// Network tags configured on the instance.
	NetworkTags []string `protobuf:"bytes,7,rep,name=network_tags,json=networkTags,proto3" json:"network_tags,omitempty"`
	// Service account authorized for the instance.
	//
	// Deprecated: Do not use.
	ServiceAccount string `protobuf:"bytes,8,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
}

func (x *InstanceInfo) Reset() {
	*x = InstanceInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstanceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceInfo) ProtoMessage() {}

func (x *InstanceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceInfo.ProtoReflect.Descriptor instead.
func (*InstanceInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{2}
}

func (x *InstanceInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *InstanceInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *InstanceInfo) GetInterface() string {
	if x != nil {
		return x.Interface
	}
	return ""
}

func (x *InstanceInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

func (x *InstanceInfo) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *InstanceInfo) GetExternalIp() string {
	if x != nil {
		return x.ExternalIp
	}
	return ""
}

func (x *InstanceInfo) GetNetworkTags() []string {
	if x != nil {
		return x.NetworkTags
	}
	return nil
}

// Deprecated: Do not use.
func (x *InstanceInfo) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

// For display only. Metadata associated with a Compute Engine network.
type NetworkInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a Compute Engine network.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a Compute Engine network.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// The IP range that matches the test.
	MatchedIpRange string `protobuf:"bytes,4,opt,name=matched_ip_range,json=matchedIpRange,proto3" json:"matched_ip_range,omitempty"`
}

func (x *NetworkInfo) Reset() {
	*x = NetworkInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkInfo) ProtoMessage() {}

func (x *NetworkInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkInfo.ProtoReflect.Descriptor instead.
func (*NetworkInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{3}
}

func (x *NetworkInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *NetworkInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *NetworkInfo) GetMatchedIpRange() string {
	if x != nil {
		return x.MatchedIpRange
	}
	return ""
}

// For display only. Metadata associated with a VPC firewall rule, an implied
// VPC firewall rule, or a hierarchical firewall policy rule.
type FirewallInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The display name of the VPC firewall rule. This field is not applicable
	// to hierarchical firewall policy rules.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The URI of the VPC firewall rule. This field is not applicable to
	// implied firewall rules or hierarchical firewall policy rules.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Possible values: INGRESS, EGRESS
	Direction string `protobuf:"bytes,3,opt,name=direction,proto3" json:"direction,omitempty"`
	// Possible values: ALLOW, DENY
	Action string `protobuf:"bytes,4,opt,name=action,proto3" json:"action,omitempty"`
	// The priority of the firewall rule.
	Priority int32 `protobuf:"varint,5,opt,name=priority,proto3" json:"priority,omitempty"`
	// The URI of the VPC network that the firewall rule is associated with.
	// This field is not applicable to hierarchical firewall policy rules.
	NetworkUri string `protobuf:"bytes,6,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// The target tags defined by the VPC firewall rule. This field is not
	// applicable to hierarchical firewall policy rules.
	TargetTags []string `protobuf:"bytes,7,rep,name=target_tags,json=targetTags,proto3" json:"target_tags,omitempty"`
	// The target service accounts specified by the firewall rule.
	TargetServiceAccounts []string `protobuf:"bytes,8,rep,name=target_service_accounts,json=targetServiceAccounts,proto3" json:"target_service_accounts,omitempty"`
	// The hierarchical firewall policy that this rule is associated with.
	// This field is not applicable to VPC firewall rules.
	Policy string `protobuf:"bytes,9,opt,name=policy,proto3" json:"policy,omitempty"`
	// The firewall rule's type.
	FirewallRuleType FirewallInfo_FirewallRuleType `protobuf:"varint,10,opt,name=firewall_rule_type,json=firewallRuleType,proto3,enum=google.cloud.networkmanagement.v1.FirewallInfo_FirewallRuleType" json:"firewall_rule_type,omitempty"`
}

func (x *FirewallInfo) Reset() {
	*x = FirewallInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FirewallInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FirewallInfo) ProtoMessage() {}

func (x *FirewallInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FirewallInfo.ProtoReflect.Descriptor instead.
func (*FirewallInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{4}
}

func (x *FirewallInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *FirewallInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *FirewallInfo) GetDirection() string {
	if x != nil {
		return x.Direction
	}
	return ""
}

func (x *FirewallInfo) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

func (x *FirewallInfo) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *FirewallInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

func (x *FirewallInfo) GetTargetTags() []string {
	if x != nil {
		return x.TargetTags
	}
	return nil
}

func (x *FirewallInfo) GetTargetServiceAccounts() []string {
	if x != nil {
		return x.TargetServiceAccounts
	}
	return nil
}

func (x *FirewallInfo) GetPolicy() string {
	if x != nil {
		return x.Policy
	}
	return ""
}

func (x *FirewallInfo) GetFirewallRuleType() FirewallInfo_FirewallRuleType {
	if x != nil {
		return x.FirewallRuleType
	}
	return FirewallInfo_FIREWALL_RULE_TYPE_UNSPECIFIED
}

// For display only. Metadata associated with a Compute Engine route.
type RouteInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of route.
	RouteType RouteInfo_RouteType `protobuf:"varint,8,opt,name=route_type,json=routeType,proto3,enum=google.cloud.networkmanagement.v1.RouteInfo_RouteType" json:"route_type,omitempty"`
	// Type of next hop.
	NextHopType RouteInfo_NextHopType `protobuf:"varint,9,opt,name=next_hop_type,json=nextHopType,proto3,enum=google.cloud.networkmanagement.v1.RouteInfo_NextHopType" json:"next_hop_type,omitempty"`
	// Name of a Compute Engine route.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a Compute Engine route.
	// Dynamic route from cloud router does not have a URI.
	// Advertised route from Google Cloud VPC to on-premises network also does
	// not have a URI.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Destination IP range of the route.
	DestIpRange string `protobuf:"bytes,3,opt,name=dest_ip_range,json=destIpRange,proto3" json:"dest_ip_range,omitempty"`
	// Next hop of the route.
	NextHop string `protobuf:"bytes,4,opt,name=next_hop,json=nextHop,proto3" json:"next_hop,omitempty"`
	// URI of a Compute Engine network.
	NetworkUri string `protobuf:"bytes,5,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// Priority of the route.
	Priority int32 `protobuf:"varint,6,opt,name=priority,proto3" json:"priority,omitempty"`
	// Instance tags of the route.
	InstanceTags []string `protobuf:"bytes,7,rep,name=instance_tags,json=instanceTags,proto3" json:"instance_tags,omitempty"`
}

func (x *RouteInfo) Reset() {
	*x = RouteInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteInfo) ProtoMessage() {}

func (x *RouteInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteInfo.ProtoReflect.Descriptor instead.
func (*RouteInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{5}
}

func (x *RouteInfo) GetRouteType() RouteInfo_RouteType {
	if x != nil {
		return x.RouteType
	}
	return RouteInfo_ROUTE_TYPE_UNSPECIFIED
}

func (x *RouteInfo) GetNextHopType() RouteInfo_NextHopType {
	if x != nil {
		return x.NextHopType
	}
	return RouteInfo_NEXT_HOP_TYPE_UNSPECIFIED
}

func (x *RouteInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *RouteInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *RouteInfo) GetDestIpRange() string {
	if x != nil {
		return x.DestIpRange
	}
	return ""
}

func (x *RouteInfo) GetNextHop() string {
	if x != nil {
		return x.NextHop
	}
	return ""
}

func (x *RouteInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

func (x *RouteInfo) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *RouteInfo) GetInstanceTags() []string {
	if x != nil {
		return x.InstanceTags
	}
	return nil
}

// For display only. Metadata associated with a Compute Engine forwarding rule.
type ForwardingRuleInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a Compute Engine forwarding rule.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a Compute Engine forwarding rule.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Protocol defined in the forwarding rule that matches the test.
	MatchedProtocol string `protobuf:"bytes,3,opt,name=matched_protocol,json=matchedProtocol,proto3" json:"matched_protocol,omitempty"`
	// Port range defined in the forwarding rule that matches the test.
	MatchedPortRange string `protobuf:"bytes,6,opt,name=matched_port_range,json=matchedPortRange,proto3" json:"matched_port_range,omitempty"`
	// VIP of the forwarding rule.
	Vip string `protobuf:"bytes,4,opt,name=vip,proto3" json:"vip,omitempty"`
	// Target type of the forwarding rule.
	Target string `protobuf:"bytes,5,opt,name=target,proto3" json:"target,omitempty"`
	// Network URI. Only valid for Internal Load Balancer.
	NetworkUri string `protobuf:"bytes,7,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
}

func (x *ForwardingRuleInfo) Reset() {
	*x = ForwardingRuleInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForwardingRuleInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardingRuleInfo) ProtoMessage() {}

func (x *ForwardingRuleInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardingRuleInfo.ProtoReflect.Descriptor instead.
func (*ForwardingRuleInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{6}
}

func (x *ForwardingRuleInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ForwardingRuleInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *ForwardingRuleInfo) GetMatchedProtocol() string {
	if x != nil {
		return x.MatchedProtocol
	}
	return ""
}

func (x *ForwardingRuleInfo) GetMatchedPortRange() string {
	if x != nil {
		return x.MatchedPortRange
	}
	return ""
}

func (x *ForwardingRuleInfo) GetVip() string {
	if x != nil {
		return x.Vip
	}
	return ""
}

func (x *ForwardingRuleInfo) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *ForwardingRuleInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

// For display only. Metadata associated with a load balancer.
type LoadBalancerInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the load balancer.
	LoadBalancerType LoadBalancerInfo_LoadBalancerType `protobuf:"varint,1,opt,name=load_balancer_type,json=loadBalancerType,proto3,enum=google.cloud.networkmanagement.v1.LoadBalancerInfo_LoadBalancerType" json:"load_balancer_type,omitempty"`
	// URI of the health check for the load balancer.
	HealthCheckUri string `protobuf:"bytes,2,opt,name=health_check_uri,json=healthCheckUri,proto3" json:"health_check_uri,omitempty"`
	// Information for the loadbalancer backends.
	Backends []*LoadBalancerBackend `protobuf:"bytes,3,rep,name=backends,proto3" json:"backends,omitempty"`
	// Type of load balancer's backend configuration.
	BackendType LoadBalancerInfo_BackendType `protobuf:"varint,4,opt,name=backend_type,json=backendType,proto3,enum=google.cloud.networkmanagement.v1.LoadBalancerInfo_BackendType" json:"backend_type,omitempty"`
	// Backend configuration URI.
	BackendUri string `protobuf:"bytes,5,opt,name=backend_uri,json=backendUri,proto3" json:"backend_uri,omitempty"`
}

func (x *LoadBalancerInfo) Reset() {
	*x = LoadBalancerInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadBalancerInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancerInfo) ProtoMessage() {}

func (x *LoadBalancerInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancerInfo.ProtoReflect.Descriptor instead.
func (*LoadBalancerInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{7}
}

func (x *LoadBalancerInfo) GetLoadBalancerType() LoadBalancerInfo_LoadBalancerType {
	if x != nil {
		return x.LoadBalancerType
	}
	return LoadBalancerInfo_LOAD_BALANCER_TYPE_UNSPECIFIED
}

func (x *LoadBalancerInfo) GetHealthCheckUri() string {
	if x != nil {
		return x.HealthCheckUri
	}
	return ""
}

func (x *LoadBalancerInfo) GetBackends() []*LoadBalancerBackend {
	if x != nil {
		return x.Backends
	}
	return nil
}

func (x *LoadBalancerInfo) GetBackendType() LoadBalancerInfo_BackendType {
	if x != nil {
		return x.BackendType
	}
	return LoadBalancerInfo_BACKEND_TYPE_UNSPECIFIED
}

func (x *LoadBalancerInfo) GetBackendUri() string {
	if x != nil {
		return x.BackendUri
	}
	return ""
}

// For display only. Metadata associated with a specific load balancer backend.
type LoadBalancerBackend struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a Compute Engine instance or network endpoint.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a Compute Engine instance or network endpoint.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// State of the health check firewall configuration.
	HealthCheckFirewallState LoadBalancerBackend_HealthCheckFirewallState `protobuf:"varint,3,opt,name=health_check_firewall_state,json=healthCheckFirewallState,proto3,enum=google.cloud.networkmanagement.v1.LoadBalancerBackend_HealthCheckFirewallState" json:"health_check_firewall_state,omitempty"`
	// A list of firewall rule URIs allowing probes from health check IP ranges.
	HealthCheckAllowingFirewallRules []string `protobuf:"bytes,4,rep,name=health_check_allowing_firewall_rules,json=healthCheckAllowingFirewallRules,proto3" json:"health_check_allowing_firewall_rules,omitempty"`
	// A list of firewall rule URIs blocking probes from health check IP ranges.
	HealthCheckBlockingFirewallRules []string `protobuf:"bytes,5,rep,name=health_check_blocking_firewall_rules,json=healthCheckBlockingFirewallRules,proto3" json:"health_check_blocking_firewall_rules,omitempty"`
}

func (x *LoadBalancerBackend) Reset() {
	*x = LoadBalancerBackend{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadBalancerBackend) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancerBackend) ProtoMessage() {}

func (x *LoadBalancerBackend) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancerBackend.ProtoReflect.Descriptor instead.
func (*LoadBalancerBackend) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{8}
}

func (x *LoadBalancerBackend) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *LoadBalancerBackend) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *LoadBalancerBackend) GetHealthCheckFirewallState() LoadBalancerBackend_HealthCheckFirewallState {
	if x != nil {
		return x.HealthCheckFirewallState
	}
	return LoadBalancerBackend_HEALTH_CHECK_FIREWALL_STATE_UNSPECIFIED
}

func (x *LoadBalancerBackend) GetHealthCheckAllowingFirewallRules() []string {
	if x != nil {
		return x.HealthCheckAllowingFirewallRules
	}
	return nil
}

func (x *LoadBalancerBackend) GetHealthCheckBlockingFirewallRules() []string {
	if x != nil {
		return x.HealthCheckBlockingFirewallRules
	}
	return nil
}

// For display only. Metadata associated with a Compute Engine VPN gateway.
type VpnGatewayInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a VPN gateway.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a VPN gateway.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// URI of a Compute Engine network where the VPN gateway is configured.
	NetworkUri string `protobuf:"bytes,3,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// IP address of the VPN gateway.
	IpAddress string `protobuf:"bytes,4,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// A VPN tunnel that is associated with this VPN gateway.
	// There may be multiple VPN tunnels configured on a VPN gateway, and only
	// the one relevant to the test is displayed.
	VpnTunnelUri string `protobuf:"bytes,5,opt,name=vpn_tunnel_uri,json=vpnTunnelUri,proto3" json:"vpn_tunnel_uri,omitempty"`
	// Name of a Google Cloud region where this VPN gateway is configured.
	Region string `protobuf:"bytes,6,opt,name=region,proto3" json:"region,omitempty"`
}

func (x *VpnGatewayInfo) Reset() {
	*x = VpnGatewayInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VpnGatewayInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VpnGatewayInfo) ProtoMessage() {}

func (x *VpnGatewayInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VpnGatewayInfo.ProtoReflect.Descriptor instead.
func (*VpnGatewayInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{9}
}

func (x *VpnGatewayInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *VpnGatewayInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *VpnGatewayInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

func (x *VpnGatewayInfo) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *VpnGatewayInfo) GetVpnTunnelUri() string {
	if x != nil {
		return x.VpnTunnelUri
	}
	return ""
}

func (x *VpnGatewayInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

// For display only. Metadata associated with a Compute Engine VPN tunnel.
type VpnTunnelInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a VPN tunnel.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a VPN tunnel.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// URI of the VPN gateway at local end of the tunnel.
	SourceGateway string `protobuf:"bytes,3,opt,name=source_gateway,json=sourceGateway,proto3" json:"source_gateway,omitempty"`
	// URI of a VPN gateway at remote end of the tunnel.
	RemoteGateway string `protobuf:"bytes,4,opt,name=remote_gateway,json=remoteGateway,proto3" json:"remote_gateway,omitempty"`
	// Remote VPN gateway's IP address.
	RemoteGatewayIp string `protobuf:"bytes,5,opt,name=remote_gateway_ip,json=remoteGatewayIp,proto3" json:"remote_gateway_ip,omitempty"`
	// Local VPN gateway's IP address.
	SourceGatewayIp string `protobuf:"bytes,6,opt,name=source_gateway_ip,json=sourceGatewayIp,proto3" json:"source_gateway_ip,omitempty"`
	// URI of a Compute Engine network where the VPN tunnel is configured.
	NetworkUri string `protobuf:"bytes,7,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// Name of a Google Cloud region where this VPN tunnel is configured.
	Region string `protobuf:"bytes,8,opt,name=region,proto3" json:"region,omitempty"`
	// Type of the routing policy.
	RoutingType VpnTunnelInfo_RoutingType `protobuf:"varint,9,opt,name=routing_type,json=routingType,proto3,enum=google.cloud.networkmanagement.v1.VpnTunnelInfo_RoutingType" json:"routing_type,omitempty"`
}

func (x *VpnTunnelInfo) Reset() {
	*x = VpnTunnelInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VpnTunnelInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VpnTunnelInfo) ProtoMessage() {}

func (x *VpnTunnelInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VpnTunnelInfo.ProtoReflect.Descriptor instead.
func (*VpnTunnelInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{10}
}

func (x *VpnTunnelInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *VpnTunnelInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *VpnTunnelInfo) GetSourceGateway() string {
	if x != nil {
		return x.SourceGateway
	}
	return ""
}

func (x *VpnTunnelInfo) GetRemoteGateway() string {
	if x != nil {
		return x.RemoteGateway
	}
	return ""
}

func (x *VpnTunnelInfo) GetRemoteGatewayIp() string {
	if x != nil {
		return x.RemoteGatewayIp
	}
	return ""
}

func (x *VpnTunnelInfo) GetSourceGatewayIp() string {
	if x != nil {
		return x.SourceGatewayIp
	}
	return ""
}

func (x *VpnTunnelInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

func (x *VpnTunnelInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *VpnTunnelInfo) GetRoutingType() VpnTunnelInfo_RoutingType {
	if x != nil {
		return x.RoutingType
	}
	return VpnTunnelInfo_ROUTING_TYPE_UNSPECIFIED
}

// For display only. The specification of the endpoints for the test.
// EndpointInfo is derived from source and destination Endpoint and validated
// by the backend data plane model.
type EndpointInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source IP address.
	SourceIp string `protobuf:"bytes,1,opt,name=source_ip,json=sourceIp,proto3" json:"source_ip,omitempty"`
	// Destination IP address.
	DestinationIp string `protobuf:"bytes,2,opt,name=destination_ip,json=destinationIp,proto3" json:"destination_ip,omitempty"`
	// IP protocol in string format, for example: "TCP", "UDP", "ICMP".
	Protocol string `protobuf:"bytes,3,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// Source port. Only valid when protocol is TCP or UDP.
	SourcePort int32 `protobuf:"varint,4,opt,name=source_port,json=sourcePort,proto3" json:"source_port,omitempty"`
	// Destination port. Only valid when protocol is TCP or UDP.
	DestinationPort int32 `protobuf:"varint,5,opt,name=destination_port,json=destinationPort,proto3" json:"destination_port,omitempty"`
	// URI of the network where this packet originates from.
	SourceNetworkUri string `protobuf:"bytes,6,opt,name=source_network_uri,json=sourceNetworkUri,proto3" json:"source_network_uri,omitempty"`
	// URI of the network where this packet is sent to.
	DestinationNetworkUri string `protobuf:"bytes,7,opt,name=destination_network_uri,json=destinationNetworkUri,proto3" json:"destination_network_uri,omitempty"`
}

func (x *EndpointInfo) Reset() {
	*x = EndpointInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndpointInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndpointInfo) ProtoMessage() {}

func (x *EndpointInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndpointInfo.ProtoReflect.Descriptor instead.
func (*EndpointInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{11}
}

func (x *EndpointInfo) GetSourceIp() string {
	if x != nil {
		return x.SourceIp
	}
	return ""
}

func (x *EndpointInfo) GetDestinationIp() string {
	if x != nil {
		return x.DestinationIp
	}
	return ""
}

func (x *EndpointInfo) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *EndpointInfo) GetSourcePort() int32 {
	if x != nil {
		return x.SourcePort
	}
	return 0
}

func (x *EndpointInfo) GetDestinationPort() int32 {
	if x != nil {
		return x.DestinationPort
	}
	return 0
}

func (x *EndpointInfo) GetSourceNetworkUri() string {
	if x != nil {
		return x.SourceNetworkUri
	}
	return ""
}

func (x *EndpointInfo) GetDestinationNetworkUri() string {
	if x != nil {
		return x.DestinationNetworkUri
	}
	return ""
}

// Details of the final state "deliver" and associated resource.
type DeliverInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target type where the packet is delivered to.
	Target DeliverInfo_Target `protobuf:"varint,1,opt,name=target,proto3,enum=google.cloud.networkmanagement.v1.DeliverInfo_Target" json:"target,omitempty"`
	// URI of the resource that the packet is delivered to.
	ResourceUri string `protobuf:"bytes,2,opt,name=resource_uri,json=resourceUri,proto3" json:"resource_uri,omitempty"`
}

func (x *DeliverInfo) Reset() {
	*x = DeliverInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeliverInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeliverInfo) ProtoMessage() {}

func (x *DeliverInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeliverInfo.ProtoReflect.Descriptor instead.
func (*DeliverInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{12}
}

func (x *DeliverInfo) GetTarget() DeliverInfo_Target {
	if x != nil {
		return x.Target
	}
	return DeliverInfo_TARGET_UNSPECIFIED
}

func (x *DeliverInfo) GetResourceUri() string {
	if x != nil {
		return x.ResourceUri
	}
	return ""
}

// Details of the final state "forward" and associated resource.
type ForwardInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target type where this packet is forwarded to.
	Target ForwardInfo_Target `protobuf:"varint,1,opt,name=target,proto3,enum=google.cloud.networkmanagement.v1.ForwardInfo_Target" json:"target,omitempty"`
	// URI of the resource that the packet is forwarded to.
	ResourceUri string `protobuf:"bytes,2,opt,name=resource_uri,json=resourceUri,proto3" json:"resource_uri,omitempty"`
}

func (x *ForwardInfo) Reset() {
	*x = ForwardInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForwardInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardInfo) ProtoMessage() {}

func (x *ForwardInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardInfo.ProtoReflect.Descriptor instead.
func (*ForwardInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{13}
}

func (x *ForwardInfo) GetTarget() ForwardInfo_Target {
	if x != nil {
		return x.Target
	}
	return ForwardInfo_TARGET_UNSPECIFIED
}

func (x *ForwardInfo) GetResourceUri() string {
	if x != nil {
		return x.ResourceUri
	}
	return ""
}

// Details of the final state "abort" and associated resource.
type AbortInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Causes that the analysis is aborted.
	Cause AbortInfo_Cause `protobuf:"varint,1,opt,name=cause,proto3,enum=google.cloud.networkmanagement.v1.AbortInfo_Cause" json:"cause,omitempty"`
	// URI of the resource that caused the abort.
	ResourceUri string `protobuf:"bytes,2,opt,name=resource_uri,json=resourceUri,proto3" json:"resource_uri,omitempty"`
}

func (x *AbortInfo) Reset() {
	*x = AbortInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AbortInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AbortInfo) ProtoMessage() {}

func (x *AbortInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AbortInfo.ProtoReflect.Descriptor instead.
func (*AbortInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{14}
}

func (x *AbortInfo) GetCause() AbortInfo_Cause {
	if x != nil {
		return x.Cause
	}
	return AbortInfo_CAUSE_UNSPECIFIED
}

func (x *AbortInfo) GetResourceUri() string {
	if x != nil {
		return x.ResourceUri
	}
	return ""
}

// Details of the final state "drop" and associated resource.
type DropInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cause that the packet is dropped.
	Cause DropInfo_Cause `protobuf:"varint,1,opt,name=cause,proto3,enum=google.cloud.networkmanagement.v1.DropInfo_Cause" json:"cause,omitempty"`
	// URI of the resource that caused the drop.
	ResourceUri string `protobuf:"bytes,2,opt,name=resource_uri,json=resourceUri,proto3" json:"resource_uri,omitempty"`
}

func (x *DropInfo) Reset() {
	*x = DropInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DropInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DropInfo) ProtoMessage() {}

func (x *DropInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DropInfo.ProtoReflect.Descriptor instead.
func (*DropInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{15}
}

func (x *DropInfo) GetCause() DropInfo_Cause {
	if x != nil {
		return x.Cause
	}
	return DropInfo_CAUSE_UNSPECIFIED
}

func (x *DropInfo) GetResourceUri() string {
	if x != nil {
		return x.ResourceUri
	}
	return ""
}

// For display only. Metadata associated with a Google Kubernetes Engine (GKE)
// cluster master.
type GKEMasterInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI of a GKE cluster.
	ClusterUri string `protobuf:"bytes,2,opt,name=cluster_uri,json=clusterUri,proto3" json:"cluster_uri,omitempty"`
	// URI of a GKE cluster network.
	ClusterNetworkUri string `protobuf:"bytes,4,opt,name=cluster_network_uri,json=clusterNetworkUri,proto3" json:"cluster_network_uri,omitempty"`
	// Internal IP address of a GKE cluster master.
	InternalIp string `protobuf:"bytes,5,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// External IP address of a GKE cluster master.
	ExternalIp string `protobuf:"bytes,6,opt,name=external_ip,json=externalIp,proto3" json:"external_ip,omitempty"`
}

func (x *GKEMasterInfo) Reset() {
	*x = GKEMasterInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GKEMasterInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GKEMasterInfo) ProtoMessage() {}

func (x *GKEMasterInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GKEMasterInfo.ProtoReflect.Descriptor instead.
func (*GKEMasterInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{16}
}

func (x *GKEMasterInfo) GetClusterUri() string {
	if x != nil {
		return x.ClusterUri
	}
	return ""
}

func (x *GKEMasterInfo) GetClusterNetworkUri() string {
	if x != nil {
		return x.ClusterNetworkUri
	}
	return ""
}

func (x *GKEMasterInfo) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *GKEMasterInfo) GetExternalIp() string {
	if x != nil {
		return x.ExternalIp
	}
	return ""
}

// For display only. Metadata associated with a Cloud SQL instance.
type CloudSQLInstanceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of a Cloud SQL instance.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// URI of a Cloud SQL instance.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// URI of a Cloud SQL instance network or empty string if the instance does
	// not have one.
	NetworkUri string `protobuf:"bytes,4,opt,name=network_uri,json=networkUri,proto3" json:"network_uri,omitempty"`
	// Internal IP address of a Cloud SQL instance.
	InternalIp string `protobuf:"bytes,5,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// External IP address of a Cloud SQL instance.
	ExternalIp string `protobuf:"bytes,6,opt,name=external_ip,json=externalIp,proto3" json:"external_ip,omitempty"`
	// Region in which the Cloud SQL instance is running.
	Region string `protobuf:"bytes,7,opt,name=region,proto3" json:"region,omitempty"`
}

func (x *CloudSQLInstanceInfo) Reset() {
	*x = CloudSQLInstanceInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudSQLInstanceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudSQLInstanceInfo) ProtoMessage() {}

func (x *CloudSQLInstanceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudSQLInstanceInfo.ProtoReflect.Descriptor instead.
func (*CloudSQLInstanceInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP(), []int{17}
}

func (x *CloudSQLInstanceInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *CloudSQLInstanceInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *CloudSQLInstanceInfo) GetNetworkUri() string {
	if x != nil {
		return x.NetworkUri
	}
	return ""
}

func (x *CloudSQLInstanceInfo) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *CloudSQLInstanceInfo) GetExternalIp() string {
	if x != nil {
		return x.ExternalIp
	}
	return ""
}

func (x *CloudSQLInstanceInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

var File_google_cloud_networkmanagement_v1_trace_proto protoreflect.FileDescriptor

var file_google_cloud_networkmanagement_v1_trace_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x9c, 0x01, 0x0a, 0x05, 0x54, 0x72, 0x61, 0x63, 0x65, 0x12, 0x54, 0x0a, 0x0d, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x3d, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x22,
	0xb8, 0x0f, 0x0a, 0x04, 0x53, 0x74, 0x65, 0x70, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74,
	0x65, 0x70, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x63, 0x61, 0x75, 0x73, 0x65, 0x73, 0x5f, 0x64, 0x72, 0x6f, 0x70, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x63, 0x61, 0x75, 0x73, 0x65, 0x73, 0x44, 0x72, 0x6f, 0x70,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12,
	0x4d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x4d,
	0x0a, 0x08, 0x66, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x49, 0x6e, 0x66,
	0x6f, 0x48, 0x00, 0x52, 0x08, 0x66, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x12, 0x44, 0x0a,
	0x05, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x05, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x12, 0x4d, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x12, 0x60, 0x0a, 0x0f, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x48, 0x00, 0x52, 0x0e, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x52, 0x75, 0x6c, 0x65, 0x12, 0x54, 0x0a, 0x0b, 0x76, 0x70, 0x6e, 0x5f, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x70,
	0x6e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0a,
	0x76, 0x70, 0x6e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x51, 0x0a, 0x0a, 0x76, 0x70,
	0x6e, 0x5f, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x66, 0x6f,
	0x48, 0x00, 0x52, 0x09, 0x76, 0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x4a, 0x0a,
	0x07, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00,
	0x52, 0x07, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x12, 0x4a, 0x0a, 0x07, 0x66, 0x6f, 0x72,
	0x77, 0x61, 0x72, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x07, 0x66, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x12, 0x44, 0x0a, 0x05, 0x61, 0x62, 0x6f, 0x72, 0x74, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x62, 0x6f, 0x72, 0x74, 0x49, 0x6e,
	0x66, 0x6f, 0x48, 0x00, 0x52, 0x05, 0x61, 0x62, 0x6f, 0x72, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x64,
	0x72, 0x6f, 0x70, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x72,
	0x6f, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x04, 0x64, 0x72, 0x6f, 0x70, 0x12, 0x5a,
	0x0a, 0x0d, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0c, 0x6c, 0x6f,
	0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x12, 0x4a, 0x0a, 0x07, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x07, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x51, 0x0a, 0x0a, 0x67, 0x6b, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x4b, 0x45, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x09,
	0x67, 0x6b, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x12, 0x67, 0x0a, 0x12, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53,
	0x51, 0x4c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00,
	0x52, 0x10, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x22, 0xb8, 0x04, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x46, 0x52, 0x4f,
	0x4d, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13,
	0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52,
	0x4e, 0x45, 0x54, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x46,
	0x52, 0x4f, 0x4d, 0x5f, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x4e, 0x45, 0x54, 0x57,
	0x4f, 0x52, 0x4b, 0x10, 0x03, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x46,
	0x52, 0x4f, 0x4d, 0x5f, 0x47, 0x4b, 0x45, 0x5f, 0x4d, 0x41, 0x53, 0x54, 0x45, 0x52, 0x10, 0x15,
	0x12, 0x21, 0x0a, 0x1d, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x43,
	0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43,
	0x45, 0x10, 0x16, 0x12, 0x1f, 0x0a, 0x1b, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x5f, 0x49, 0x4e, 0x47,
	0x52, 0x45, 0x53, 0x53, 0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x52, 0x55,
	0x4c, 0x45, 0x10, 0x04, 0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x5f, 0x45, 0x47,
	0x52, 0x45, 0x53, 0x53, 0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x52, 0x55,
	0x4c, 0x45, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x5f, 0x52, 0x4f,
	0x55, 0x54, 0x45, 0x10, 0x06, 0x12, 0x19, 0x0a, 0x15, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x5f, 0x46,
	0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x10, 0x07,
	0x12, 0x15, 0x0a, 0x11, 0x53, 0x50, 0x4f, 0x4f, 0x46, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x50, 0x50,
	0x52, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x08, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x52, 0x52, 0x49, 0x56,
	0x45, 0x5f, 0x41, 0x54, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x09, 0x12,
	0x24, 0x0a, 0x20, 0x41, 0x52, 0x52, 0x49, 0x56, 0x45, 0x5f, 0x41, 0x54, 0x5f, 0x49, 0x4e, 0x54,
	0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e,
	0x43, 0x45, 0x52, 0x10, 0x0a, 0x12, 0x24, 0x0a, 0x20, 0x41, 0x52, 0x52, 0x49, 0x56, 0x45, 0x5f,
	0x41, 0x54, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x4c, 0x4f, 0x41, 0x44,
	0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x10, 0x0b, 0x12, 0x19, 0x0a, 0x15, 0x41,
	0x52, 0x52, 0x49, 0x56, 0x45, 0x5f, 0x41, 0x54, 0x5f, 0x56, 0x50, 0x4e, 0x5f, 0x47, 0x41, 0x54,
	0x45, 0x57, 0x41, 0x59, 0x10, 0x0c, 0x12, 0x18, 0x0a, 0x14, 0x41, 0x52, 0x52, 0x49, 0x56, 0x45,
	0x5f, 0x41, 0x54, 0x5f, 0x56, 0x50, 0x4e, 0x5f, 0x54, 0x55, 0x4e, 0x4e, 0x45, 0x4c, 0x10, 0x0d,
	0x12, 0x07, 0x0a, 0x03, 0x4e, 0x41, 0x54, 0x10, 0x0e, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x52, 0x4f,
	0x58, 0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0f, 0x12,
	0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x49, 0x56, 0x45, 0x52, 0x10, 0x10, 0x12, 0x08, 0x0a, 0x04,
	0x44, 0x52, 0x4f, 0x50, 0x10, 0x11, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52,
	0x44, 0x10, 0x12, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x42, 0x4f, 0x52, 0x54, 0x10, 0x13, 0x12, 0x1d,
	0x0a, 0x19, 0x56, 0x49, 0x45, 0x57, 0x45, 0x52, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x10, 0x14, 0x42, 0x0b, 0x0a,
	0x09, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x94, 0x02, 0x0a, 0x0c, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10,
	0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69,
	0x12, 0x1c, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x1f,
	0x0a, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12,
	0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70,
	0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49,
	0x70, 0x12, 0x21, 0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x61, 0x67,
	0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x54, 0x61, 0x67, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x22, 0x6c, 0x0a, 0x0b, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x28, 0x0a, 0x10, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64,
	0x5f, 0x69, 0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x22,
	0xad, 0x04, 0x0a, 0x0c, 0x46, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1c, 0x0a, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x70,
	0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x61, 0x67, 0x73, 0x12, 0x36, 0x0a, 0x17, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x15, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x6e, 0x0a, 0x12, 0x66, 0x69, 0x72,
	0x65, 0x77, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x72, 0x65, 0x77, 0x61,
	0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x46, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x52,
	0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x10, 0x66, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c,
	0x6c, 0x52, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x93, 0x01, 0x0a, 0x10, 0x46, 0x69,
	0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x52, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22,
	0x0a, 0x1e, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x25, 0x0a, 0x21, 0x48, 0x49, 0x45, 0x52, 0x41, 0x52, 0x43, 0x48, 0x49, 0x43,
	0x41, 0x4c, 0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x50, 0x4f, 0x4c, 0x49,
	0x43, 0x59, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x56, 0x50, 0x43,
	0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x10, 0x02,
	0x12, 0x1d, 0x0a, 0x19, 0x49, 0x4d, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x5f, 0x56, 0x50, 0x43, 0x5f,
	0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x10, 0x03, 0x22,
	0xbc, 0x06, 0x0a, 0x09, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x55, 0x0a,
	0x0a, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x5c, 0x0a, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x68, 0x6f, 0x70,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x4e, 0x65, 0x78, 0x74, 0x48, 0x6f,
	0x70, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x6e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x22, 0x0a, 0x0d, 0x64, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x74, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x68, 0x6f, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e,
	0x65, 0x78, 0x74, 0x48, 0x6f, 0x70, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x74, 0x61, 0x67, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x54, 0x61, 0x67, 0x73, 0x22, 0x89, 0x01, 0x0a, 0x09, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x55, 0x42, 0x4e, 0x45, 0x54, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x53, 0x54, 0x41, 0x54, 0x49, 0x43, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x59,
	0x4e, 0x41, 0x4d, 0x49, 0x43, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x45, 0x45, 0x52, 0x49,
	0x4e, 0x47, 0x5f, 0x53, 0x55, 0x42, 0x4e, 0x45, 0x54, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x50,
	0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x49, 0x43, 0x10, 0x05, 0x12,
	0x13, 0x0a, 0x0f, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x44, 0x59, 0x4e, 0x41, 0x4d,
	0x49, 0x43, 0x10, 0x06, 0x22, 0x97, 0x02, 0x0a, 0x0b, 0x4e, 0x65, 0x78, 0x74, 0x48, 0x6f, 0x70,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f,
	0x49, 0x50, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50,
	0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x4e,
	0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10,
	0x03, 0x12, 0x14, 0x0a, 0x10, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x50, 0x45,
	0x45, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x19, 0x0a, 0x15, 0x4e, 0x45, 0x58, 0x54, 0x5f,
	0x48, 0x4f, 0x50, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54,
	0x10, 0x05, 0x12, 0x17, 0x0a, 0x13, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x56,
	0x50, 0x4e, 0x5f, 0x54, 0x55, 0x4e, 0x4e, 0x45, 0x4c, 0x10, 0x06, 0x12, 0x18, 0x0a, 0x14, 0x4e,
	0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x56, 0x50, 0x4e, 0x5f, 0x47, 0x41, 0x54, 0x45,
	0x57, 0x41, 0x59, 0x10, 0x07, 0x12, 0x1d, 0x0a, 0x19, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f,
	0x50, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x45, 0x54, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57,
	0x41, 0x59, 0x10, 0x08, 0x12, 0x16, 0x0a, 0x12, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50,
	0x5f, 0x42, 0x4c, 0x41, 0x43, 0x4b, 0x48, 0x4f, 0x4c, 0x45, 0x10, 0x09, 0x12, 0x10, 0x0a, 0x0c,
	0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x49, 0x4c, 0x42, 0x10, 0x0a, 0x22, 0xed,
	0x01, 0x0a, 0x12, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x29, 0x0a, 0x10, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x2c, 0x0a, 0x12, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64,
	0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x10, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x50, 0x6f, 0x72, 0x74, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x76, 0x69, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x76, 0x69, 0x70, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x1f, 0x0a,
	0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x22, 0xee,
	0x04, 0x0a, 0x10, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x72, 0x0a, 0x12, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72,
	0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65,
	0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x10, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x68, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x55, 0x72,
	0x69, 0x12, 0x52, 0x0a, 0x08, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x72, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x52, 0x08, 0x62, 0x61, 0x63,
	0x6b, 0x65, 0x6e, 0x64, 0x73, 0x12, 0x62, 0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f,
	0x2e, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x62, 0x61,
	0x63, 0x6b, 0x65, 0x6e, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x62, 0x61, 0x63,
	0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x55, 0x72, 0x69, 0x22, 0x8f, 0x01, 0x0a, 0x10, 0x4c,
	0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x22, 0x0a, 0x1e, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f,
	0x54, 0x43, 0x50, 0x5f, 0x55, 0x44, 0x50, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x4e, 0x45, 0x54,
	0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x54, 0x43, 0x50, 0x5f, 0x55, 0x44, 0x50, 0x10, 0x02, 0x12, 0x0e,
	0x0a, 0x0a, 0x48, 0x54, 0x54, 0x50, 0x5f, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x10, 0x03, 0x12, 0x0d,
	0x0a, 0x09, 0x54, 0x43, 0x50, 0x5f, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x10, 0x04, 0x12, 0x0d, 0x0a,
	0x09, 0x53, 0x53, 0x4c, 0x5f, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x10, 0x05, 0x22, 0x51, 0x0a, 0x0b,
	0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x42,
	0x41, 0x43, 0x4b, 0x45, 0x4e, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x42, 0x41, 0x43,
	0x4b, 0x45, 0x4e, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x01, 0x12, 0x0f,
	0x0a, 0x0b, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x50, 0x4f, 0x4f, 0x4c, 0x10, 0x02, 0x22,
	0xe7, 0x03, 0x0a, 0x13, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72,
	0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72,
	0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x8e, 0x01, 0x0a,
	0x1b, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x66, 0x69,
	0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x65, 0x72, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x46, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x18, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x46, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4e, 0x0a,
	0x24, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x5f,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x20, 0x68, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67,
	0x46, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x4e, 0x0a,
	0x24, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x5f,
	0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x20, 0x68, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x6e, 0x67,
	0x46, 0x69, 0x72, 0x65, 0x77, 0x61, 0x6c, 0x6c, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x6a, 0x0a,
	0x18, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x46, 0x69, 0x72, 0x65,
	0x77, 0x61, 0x6c, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2b, 0x0a, 0x27, 0x48, 0x45, 0x41,
	0x4c, 0x54, 0x48, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x5f, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41,
	0x4c, 0x4c, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47,
	0x55, 0x52, 0x45, 0x44, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4d, 0x49, 0x53, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x47, 0x55, 0x52, 0x45, 0x44, 0x10, 0x02, 0x22, 0xc3, 0x01, 0x0a, 0x0e, 0x56, 0x70,
	0x6e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72,
	0x69, 0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55,
	0x72, 0x69, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x24, 0x0a, 0x0e, 0x76, 0x70, 0x6e, 0x5f, 0x74, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x76, 0x70, 0x6e, 0x54, 0x75,
	0x6e, 0x6e, 0x65, 0x6c, 0x55, 0x72, 0x69, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x22,
	0xe1, 0x03, 0x0a, 0x0d, 0x56, 0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x25, 0x0a,
	0x0e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x12, 0x2a, 0x0a, 0x11, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x70,
	0x12, 0x2a, 0x0a, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x5f, 0x69, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x70, 0x12, 0x1f, 0x0a, 0x0b,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x16, 0x0a,
	0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x0c, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x70, 0x6e, 0x54, 0x75, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x52, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x72, 0x6f, 0x75, 0x74, 0x69,
	0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x22, 0x5b, 0x0a, 0x0b, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x4f, 0x55, 0x54, 0x49, 0x4e, 0x47,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x42, 0x41, 0x53,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x42,
	0x41, 0x53, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49,
	0x43, 0x10, 0x03, 0x22, 0xa0, 0x02, 0x0a, 0x0c, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69,
	0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49,
	0x70, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x70, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70,
	0x6f, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x72, 0x74,
	0x12, 0x2c, 0x0a, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x36,
	0x0a, 0x17, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x15, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x22, 0xf5, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4d, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x69, 0x22, 0x74, 0x0a, 0x06, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e,
	0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x54, 0x45,
	0x52, 0x4e, 0x45, 0x54, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45,
	0x5f, 0x41, 0x50, 0x49, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x47, 0x4b, 0x45, 0x5f, 0x4d, 0x41,
	0x53, 0x54, 0x45, 0x52, 0x10, 0x04, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f,
	0x53, 0x51, 0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x05, 0x22, 0xa2,
	0x02, 0x0a, 0x0b, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4d,
	0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x21, 0x0a,
	0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x69,
	0x22, 0xa0, 0x01, 0x0a, 0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x54,
	0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x56,
	0x50, 0x43, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x56, 0x50, 0x4e, 0x5f, 0x47, 0x41, 0x54, 0x45,
	0x57, 0x41, 0x59, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x43, 0x4f,
	0x4e, 0x4e, 0x45, 0x43, 0x54, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x47, 0x4b, 0x45, 0x5f, 0x4d,
	0x41, 0x53, 0x54, 0x45, 0x52, 0x10, 0x04, 0x12, 0x22, 0x0a, 0x1e, 0x49, 0x4d, 0x50, 0x4f, 0x52,
	0x54, 0x45, 0x44, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45,
	0x5f, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x48, 0x4f, 0x50, 0x10, 0x05, 0x12, 0x16, 0x0a, 0x12, 0x43,
	0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43,
	0x45, 0x10, 0x06, 0x22, 0xf6, 0x03, 0x0a, 0x09, 0x41, 0x62, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x48, 0x0a, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x62, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x43,
	0x61, 0x75, 0x73, 0x65, 0x52, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x69, 0x22, 0xfb,
	0x02, 0x0a, 0x05, 0x43, 0x61, 0x75, 0x73, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x41, 0x55, 0x53,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x13, 0x0a, 0x0f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f,
	0x52, 0x4b, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f,
	0x49, 0x50, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f,
	0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x45, 0x52,
	0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x04,
	0x12, 0x16, 0x0a, 0x12, 0x4e, 0x4f, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x4c, 0x4f,
	0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x05, 0x12, 0x14, 0x0a, 0x10, 0x49, 0x4e, 0x56, 0x41,
	0x4c, 0x49, 0x44, 0x5f, 0x41, 0x52, 0x47, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x06, 0x12, 0x12,
	0x0a, 0x0e, 0x4e, 0x4f, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x49, 0x50,
	0x10, 0x07, 0x12, 0x1a, 0x0a, 0x16, 0x55, 0x4e, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x44, 0x45, 0x44,
	0x5f, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x08, 0x12, 0x12,
	0x0a, 0x0e, 0x54, 0x52, 0x41, 0x43, 0x45, 0x5f, 0x54, 0x4f, 0x4f, 0x5f, 0x4c, 0x4f, 0x4e, 0x47,
	0x10, 0x09, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x10, 0x0a, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x5f, 0x45, 0x4e, 0x44, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f,
	0x55, 0x4e, 0x44, 0x10, 0x0b, 0x12, 0x1d, 0x0a, 0x19, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43,
	0x48, 0x45, 0x44, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f,
	0x52, 0x4b, 0x10, 0x0c, 0x12, 0x22, 0x0a, 0x1e, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x4e, 0x44, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x4e, 0x4f, 0x54,
	0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x0d, 0x12, 0x22, 0x0a, 0x1e, 0x4d, 0x49, 0x53, 0x4d,
	0x41, 0x54, 0x43, 0x48, 0x45, 0x44, 0x5f, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x0e, 0x22, 0xae, 0x06, 0x0a,
	0x08, 0x44, 0x72, 0x6f, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x47, 0x0a, 0x05, 0x63, 0x61, 0x75,
	0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x72, 0x6f,
	0x70, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x43, 0x61, 0x75, 0x73, 0x65, 0x52, 0x05, 0x63, 0x61, 0x75,
	0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x55, 0x72, 0x69, 0x22, 0xb5, 0x05, 0x0a, 0x05, 0x43, 0x61, 0x75, 0x73, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x43, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x41, 0x44, 0x44, 0x52, 0x45,
	0x53, 0x53, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x46, 0x4f, 0x52, 0x45, 0x49, 0x47, 0x4e, 0x5f,
	0x49, 0x50, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x11, 0x0a, 0x0d, 0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x52, 0x55, 0x4c, 0x45,
	0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x4e, 0x4f, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x10, 0x04,
	0x12, 0x13, 0x0a, 0x0f, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x42, 0x4c, 0x41, 0x43, 0x4b, 0x48,
	0x4f, 0x4c, 0x45, 0x10, 0x05, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x5f, 0x57,
	0x52, 0x4f, 0x4e, 0x47, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x06, 0x12, 0x1f,
	0x0a, 0x1b, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49,
	0x43, 0x5f, 0x54, 0x4f, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x45, 0x54, 0x10, 0x07, 0x12,
	0x24, 0x0a, 0x20, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x47, 0x4f, 0x4f, 0x47, 0x4c,
	0x45, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x4c, 0x4c, 0x4f,
	0x57, 0x45, 0x44, 0x10, 0x08, 0x12, 0x17, 0x0a, 0x13, 0x4e, 0x4f, 0x5f, 0x45, 0x58, 0x54, 0x45,
	0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x10, 0x09, 0x12, 0x1c,
	0x0a, 0x18, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e,
	0x41, 0x4c, 0x5f, 0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x10, 0x0a, 0x12, 0x1c, 0x0a, 0x18,
	0x46, 0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x5f,
	0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x0b, 0x12, 0x20, 0x0a, 0x1c, 0x46, 0x4f,
	0x52, 0x57, 0x41, 0x52, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x5f, 0x4e, 0x4f,
	0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x53, 0x10, 0x0c, 0x12, 0x38, 0x0a, 0x34,
	0x46, 0x49, 0x52, 0x45, 0x57, 0x41, 0x4c, 0x4c, 0x5f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x49, 0x4e,
	0x47, 0x5f, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x52, 0x5f,
	0x42, 0x41, 0x43, 0x4b, 0x45, 0x4e, 0x44, 0x5f, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x43,
	0x48, 0x45, 0x43, 0x4b, 0x10, 0x0d, 0x12, 0x18, 0x0a, 0x14, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e,
	0x43, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x0e,
	0x12, 0x18, 0x0a, 0x14, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x45, 0x44, 0x10, 0x0f, 0x12, 0x22, 0x0a, 0x1e, 0x47, 0x4b,
	0x45, 0x5f, 0x4d, 0x41, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x41, 0x55, 0x54, 0x48, 0x4f,
	0x52, 0x49, 0x5a, 0x45, 0x44, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x10, 0x12, 0x2a,
	0x0a, 0x26, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54,
	0x41, 0x4e, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x5a, 0x45,
	0x44, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x11, 0x12, 0x1e, 0x0a, 0x1a, 0x44, 0x52,
	0x4f, 0x50, 0x50, 0x45, 0x44, 0x5f, 0x49, 0x4e, 0x53, 0x49, 0x44, 0x45, 0x5f, 0x47, 0x4b, 0x45,
	0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x12, 0x12, 0x24, 0x0a, 0x20, 0x44, 0x52,
	0x4f, 0x50, 0x50, 0x45, 0x44, 0x5f, 0x49, 0x4e, 0x53, 0x49, 0x44, 0x45, 0x5f, 0x43, 0x4c, 0x4f,
	0x55, 0x44, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x13,
	0x12, 0x25, 0x0a, 0x21, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47,
	0x45, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x4e, 0x4f, 0x5f, 0x50, 0x45,
	0x45, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x14, 0x12, 0x24, 0x0a, 0x20, 0x43, 0x4c, 0x4f, 0x55, 0x44,
	0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x4e, 0x4f,
	0x5f, 0x49, 0x50, 0x5f, 0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x10, 0x15, 0x22, 0xa2, 0x01,
	0x0a, 0x0d, 0x47, 0x4b, 0x45, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x1f, 0x0a, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x55, 0x72, 0x69,
	0x12, 0x2e, 0x0a, 0x13, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69,
	0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49,
	0x70, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x49, 0x70, 0x22, 0xc6, 0x01, 0x0a, 0x14, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x51, 0x4c, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10,
	0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69,
	0x12, 0x1f, 0x0a, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72,
	0x69, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x49, 0x70, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69,
	0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x49, 0x70, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x42, 0xf8, 0x01, 0x0a, 0x25,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x0a, 0x54, 0x72, 0x61, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x52, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2f, 0x76, 0x31, 0x3b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x21, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5c, 0x56, 0x31, 0xea,
	0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networkmanagement_v1_trace_proto_rawDescOnce sync.Once
	file_google_cloud_networkmanagement_v1_trace_proto_rawDescData = file_google_cloud_networkmanagement_v1_trace_proto_rawDesc
)

func file_google_cloud_networkmanagement_v1_trace_proto_rawDescGZIP() []byte {
	file_google_cloud_networkmanagement_v1_trace_proto_rawDescOnce.Do(func() {
		file_google_cloud_networkmanagement_v1_trace_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networkmanagement_v1_trace_proto_rawDescData)
	})
	return file_google_cloud_networkmanagement_v1_trace_proto_rawDescData
}

var file_google_cloud_networkmanagement_v1_trace_proto_enumTypes = make([]protoimpl.EnumInfo, 12)
var file_google_cloud_networkmanagement_v1_trace_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_google_cloud_networkmanagement_v1_trace_proto_goTypes = []interface{}{
	(Step_State)(0),                                   // 0: google.cloud.networkmanagement.v1.Step.State
	(FirewallInfo_FirewallRuleType)(0),                // 1: google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType
	(RouteInfo_RouteType)(0),                          // 2: google.cloud.networkmanagement.v1.RouteInfo.RouteType
	(RouteInfo_NextHopType)(0),                        // 3: google.cloud.networkmanagement.v1.RouteInfo.NextHopType
	(LoadBalancerInfo_LoadBalancerType)(0),            // 4: google.cloud.networkmanagement.v1.LoadBalancerInfo.LoadBalancerType
	(LoadBalancerInfo_BackendType)(0),                 // 5: google.cloud.networkmanagement.v1.LoadBalancerInfo.BackendType
	(LoadBalancerBackend_HealthCheckFirewallState)(0), // 6: google.cloud.networkmanagement.v1.LoadBalancerBackend.HealthCheckFirewallState
	(VpnTunnelInfo_RoutingType)(0),                    // 7: google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType
	(DeliverInfo_Target)(0),                           // 8: google.cloud.networkmanagement.v1.DeliverInfo.Target
	(ForwardInfo_Target)(0),                           // 9: google.cloud.networkmanagement.v1.ForwardInfo.Target
	(AbortInfo_Cause)(0),                              // 10: google.cloud.networkmanagement.v1.AbortInfo.Cause
	(DropInfo_Cause)(0),                               // 11: google.cloud.networkmanagement.v1.DropInfo.Cause
	(*Trace)(nil),                                     // 12: google.cloud.networkmanagement.v1.Trace
	(*Step)(nil),                                      // 13: google.cloud.networkmanagement.v1.Step
	(*InstanceInfo)(nil),                              // 14: google.cloud.networkmanagement.v1.InstanceInfo
	(*NetworkInfo)(nil),                               // 15: google.cloud.networkmanagement.v1.NetworkInfo
	(*FirewallInfo)(nil),                              // 16: google.cloud.networkmanagement.v1.FirewallInfo
	(*RouteInfo)(nil),                                 // 17: google.cloud.networkmanagement.v1.RouteInfo
	(*ForwardingRuleInfo)(nil),                        // 18: google.cloud.networkmanagement.v1.ForwardingRuleInfo
	(*LoadBalancerInfo)(nil),                          // 19: google.cloud.networkmanagement.v1.LoadBalancerInfo
	(*LoadBalancerBackend)(nil),                       // 20: google.cloud.networkmanagement.v1.LoadBalancerBackend
	(*VpnGatewayInfo)(nil),                            // 21: google.cloud.networkmanagement.v1.VpnGatewayInfo
	(*VpnTunnelInfo)(nil),                             // 22: google.cloud.networkmanagement.v1.VpnTunnelInfo
	(*EndpointInfo)(nil),                              // 23: google.cloud.networkmanagement.v1.EndpointInfo
	(*DeliverInfo)(nil),                               // 24: google.cloud.networkmanagement.v1.DeliverInfo
	(*ForwardInfo)(nil),                               // 25: google.cloud.networkmanagement.v1.ForwardInfo
	(*AbortInfo)(nil),                                 // 26: google.cloud.networkmanagement.v1.AbortInfo
	(*DropInfo)(nil),                                  // 27: google.cloud.networkmanagement.v1.DropInfo
	(*GKEMasterInfo)(nil),                             // 28: google.cloud.networkmanagement.v1.GKEMasterInfo
	(*CloudSQLInstanceInfo)(nil),                      // 29: google.cloud.networkmanagement.v1.CloudSQLInstanceInfo
}
var file_google_cloud_networkmanagement_v1_trace_proto_depIdxs = []int32{
	23, // 0: google.cloud.networkmanagement.v1.Trace.endpoint_info:type_name -> google.cloud.networkmanagement.v1.EndpointInfo
	13, // 1: google.cloud.networkmanagement.v1.Trace.steps:type_name -> google.cloud.networkmanagement.v1.Step
	0,  // 2: google.cloud.networkmanagement.v1.Step.state:type_name -> google.cloud.networkmanagement.v1.Step.State
	14, // 3: google.cloud.networkmanagement.v1.Step.instance:type_name -> google.cloud.networkmanagement.v1.InstanceInfo
	16, // 4: google.cloud.networkmanagement.v1.Step.firewall:type_name -> google.cloud.networkmanagement.v1.FirewallInfo
	17, // 5: google.cloud.networkmanagement.v1.Step.route:type_name -> google.cloud.networkmanagement.v1.RouteInfo
	23, // 6: google.cloud.networkmanagement.v1.Step.endpoint:type_name -> google.cloud.networkmanagement.v1.EndpointInfo
	18, // 7: google.cloud.networkmanagement.v1.Step.forwarding_rule:type_name -> google.cloud.networkmanagement.v1.ForwardingRuleInfo
	21, // 8: google.cloud.networkmanagement.v1.Step.vpn_gateway:type_name -> google.cloud.networkmanagement.v1.VpnGatewayInfo
	22, // 9: google.cloud.networkmanagement.v1.Step.vpn_tunnel:type_name -> google.cloud.networkmanagement.v1.VpnTunnelInfo
	24, // 10: google.cloud.networkmanagement.v1.Step.deliver:type_name -> google.cloud.networkmanagement.v1.DeliverInfo
	25, // 11: google.cloud.networkmanagement.v1.Step.forward:type_name -> google.cloud.networkmanagement.v1.ForwardInfo
	26, // 12: google.cloud.networkmanagement.v1.Step.abort:type_name -> google.cloud.networkmanagement.v1.AbortInfo
	27, // 13: google.cloud.networkmanagement.v1.Step.drop:type_name -> google.cloud.networkmanagement.v1.DropInfo
	19, // 14: google.cloud.networkmanagement.v1.Step.load_balancer:type_name -> google.cloud.networkmanagement.v1.LoadBalancerInfo
	15, // 15: google.cloud.networkmanagement.v1.Step.network:type_name -> google.cloud.networkmanagement.v1.NetworkInfo
	28, // 16: google.cloud.networkmanagement.v1.Step.gke_master:type_name -> google.cloud.networkmanagement.v1.GKEMasterInfo
	29, // 17: google.cloud.networkmanagement.v1.Step.cloud_sql_instance:type_name -> google.cloud.networkmanagement.v1.CloudSQLInstanceInfo
	1,  // 18: google.cloud.networkmanagement.v1.FirewallInfo.firewall_rule_type:type_name -> google.cloud.networkmanagement.v1.FirewallInfo.FirewallRuleType
	2,  // 19: google.cloud.networkmanagement.v1.RouteInfo.route_type:type_name -> google.cloud.networkmanagement.v1.RouteInfo.RouteType
	3,  // 20: google.cloud.networkmanagement.v1.RouteInfo.next_hop_type:type_name -> google.cloud.networkmanagement.v1.RouteInfo.NextHopType
	4,  // 21: google.cloud.networkmanagement.v1.LoadBalancerInfo.load_balancer_type:type_name -> google.cloud.networkmanagement.v1.LoadBalancerInfo.LoadBalancerType
	20, // 22: google.cloud.networkmanagement.v1.LoadBalancerInfo.backends:type_name -> google.cloud.networkmanagement.v1.LoadBalancerBackend
	5,  // 23: google.cloud.networkmanagement.v1.LoadBalancerInfo.backend_type:type_name -> google.cloud.networkmanagement.v1.LoadBalancerInfo.BackendType
	6,  // 24: google.cloud.networkmanagement.v1.LoadBalancerBackend.health_check_firewall_state:type_name -> google.cloud.networkmanagement.v1.LoadBalancerBackend.HealthCheckFirewallState
	7,  // 25: google.cloud.networkmanagement.v1.VpnTunnelInfo.routing_type:type_name -> google.cloud.networkmanagement.v1.VpnTunnelInfo.RoutingType
	8,  // 26: google.cloud.networkmanagement.v1.DeliverInfo.target:type_name -> google.cloud.networkmanagement.v1.DeliverInfo.Target
	9,  // 27: google.cloud.networkmanagement.v1.ForwardInfo.target:type_name -> google.cloud.networkmanagement.v1.ForwardInfo.Target
	10, // 28: google.cloud.networkmanagement.v1.AbortInfo.cause:type_name -> google.cloud.networkmanagement.v1.AbortInfo.Cause
	11, // 29: google.cloud.networkmanagement.v1.DropInfo.cause:type_name -> google.cloud.networkmanagement.v1.DropInfo.Cause
	30, // [30:30] is the sub-list for method output_type
	30, // [30:30] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_google_cloud_networkmanagement_v1_trace_proto_init() }
func file_google_cloud_networkmanagement_v1_trace_proto_init() {
	if File_google_cloud_networkmanagement_v1_trace_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Step); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstanceInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FirewallInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ForwardingRuleInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadBalancerInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadBalancerBackend); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VpnGatewayInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VpnTunnelInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndpointInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeliverInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ForwardInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AbortInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DropInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GKEMasterInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudSQLInstanceInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_networkmanagement_v1_trace_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*Step_Instance)(nil),
		(*Step_Firewall)(nil),
		(*Step_Route)(nil),
		(*Step_Endpoint)(nil),
		(*Step_ForwardingRule)(nil),
		(*Step_VpnGateway)(nil),
		(*Step_VpnTunnel)(nil),
		(*Step_Deliver)(nil),
		(*Step_Forward)(nil),
		(*Step_Abort)(nil),
		(*Step_Drop)(nil),
		(*Step_LoadBalancer)(nil),
		(*Step_Network)(nil),
		(*Step_GkeMaster)(nil),
		(*Step_CloudSqlInstance)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networkmanagement_v1_trace_proto_rawDesc,
			NumEnums:      12,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_networkmanagement_v1_trace_proto_goTypes,
		DependencyIndexes: file_google_cloud_networkmanagement_v1_trace_proto_depIdxs,
		EnumInfos:         file_google_cloud_networkmanagement_v1_trace_proto_enumTypes,
		MessageInfos:      file_google_cloud_networkmanagement_v1_trace_proto_msgTypes,
	}.Build()
	File_google_cloud_networkmanagement_v1_trace_proto = out.File
	file_google_cloud_networkmanagement_v1_trace_proto_rawDesc = nil
	file_google_cloud_networkmanagement_v1_trace_proto_goTypes = nil
	file_google_cloud_networkmanagement_v1_trace_proto_depIdxs = nil
}
