// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/vision/v1/image_annotator.proto

package visionpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ImageAnnotator_BatchAnnotateImages_FullMethodName      = "/google.cloud.vision.v1.ImageAnnotator/BatchAnnotateImages"
	ImageAnnotator_BatchAnnotateFiles_FullMethodName       = "/google.cloud.vision.v1.ImageAnnotator/BatchAnnotateFiles"
	ImageAnnotator_AsyncBatchAnnotateImages_FullMethodName = "/google.cloud.vision.v1.ImageAnnotator/AsyncBatchAnnotateImages"
	ImageAnnotator_AsyncBatchAnnotateFiles_FullMethodName  = "/google.cloud.vision.v1.ImageAnnotator/AsyncBatchAnnotateFiles"
)

// ImageAnnotatorClient is the client API for ImageAnnotator service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ImageAnnotatorClient interface {
	// Run image detection and annotation for a batch of images.
	BatchAnnotateImages(ctx context.Context, in *BatchAnnotateImagesRequest, opts ...grpc.CallOption) (*BatchAnnotateImagesResponse, error)
	// Service that performs image detection and annotation for a batch of files.
	// Now only "application/pdf", "image/tiff" and "image/gif" are supported.
	//
	// This service will extract at most 5 (customers can specify which 5 in
	// AnnotateFileRequest.pages) frames (gif) or pages (pdf or tiff) from each
	// file provided and perform detection and annotation for each image
	// extracted.
	BatchAnnotateFiles(ctx context.Context, in *BatchAnnotateFilesRequest, opts ...grpc.CallOption) (*BatchAnnotateFilesResponse, error)
	// Run asynchronous image detection and annotation for a list of images.
	//
	// Progress and results can be retrieved through the
	// `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `OperationMetadata` (metadata).
	// `Operation.response` contains `AsyncBatchAnnotateImagesResponse` (results).
	//
	// This service will write image annotation outputs to json files in customer
	// GCS bucket, each json file containing BatchAnnotateImagesResponse proto.
	AsyncBatchAnnotateImages(ctx context.Context, in *AsyncBatchAnnotateImagesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Run asynchronous image detection and annotation for a list of generic
	// files, such as PDF files, which may contain multiple pages and multiple
	// images per page. Progress and results can be retrieved through the
	// `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `OperationMetadata` (metadata).
	// `Operation.response` contains `AsyncBatchAnnotateFilesResponse` (results).
	AsyncBatchAnnotateFiles(ctx context.Context, in *AsyncBatchAnnotateFilesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type imageAnnotatorClient struct {
	cc grpc.ClientConnInterface
}

func NewImageAnnotatorClient(cc grpc.ClientConnInterface) ImageAnnotatorClient {
	return &imageAnnotatorClient{cc}
}

func (c *imageAnnotatorClient) BatchAnnotateImages(ctx context.Context, in *BatchAnnotateImagesRequest, opts ...grpc.CallOption) (*BatchAnnotateImagesResponse, error) {
	out := new(BatchAnnotateImagesResponse)
	err := c.cc.Invoke(ctx, ImageAnnotator_BatchAnnotateImages_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageAnnotatorClient) BatchAnnotateFiles(ctx context.Context, in *BatchAnnotateFilesRequest, opts ...grpc.CallOption) (*BatchAnnotateFilesResponse, error) {
	out := new(BatchAnnotateFilesResponse)
	err := c.cc.Invoke(ctx, ImageAnnotator_BatchAnnotateFiles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageAnnotatorClient) AsyncBatchAnnotateImages(ctx context.Context, in *AsyncBatchAnnotateImagesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ImageAnnotator_AsyncBatchAnnotateImages_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageAnnotatorClient) AsyncBatchAnnotateFiles(ctx context.Context, in *AsyncBatchAnnotateFilesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ImageAnnotator_AsyncBatchAnnotateFiles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ImageAnnotatorServer is the server API for ImageAnnotator service.
// All implementations should embed UnimplementedImageAnnotatorServer
// for forward compatibility
type ImageAnnotatorServer interface {
	// Run image detection and annotation for a batch of images.
	BatchAnnotateImages(context.Context, *BatchAnnotateImagesRequest) (*BatchAnnotateImagesResponse, error)
	// Service that performs image detection and annotation for a batch of files.
	// Now only "application/pdf", "image/tiff" and "image/gif" are supported.
	//
	// This service will extract at most 5 (customers can specify which 5 in
	// AnnotateFileRequest.pages) frames (gif) or pages (pdf or tiff) from each
	// file provided and perform detection and annotation for each image
	// extracted.
	BatchAnnotateFiles(context.Context, *BatchAnnotateFilesRequest) (*BatchAnnotateFilesResponse, error)
	// Run asynchronous image detection and annotation for a list of images.
	//
	// Progress and results can be retrieved through the
	// `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `OperationMetadata` (metadata).
	// `Operation.response` contains `AsyncBatchAnnotateImagesResponse` (results).
	//
	// This service will write image annotation outputs to json files in customer
	// GCS bucket, each json file containing BatchAnnotateImagesResponse proto.
	AsyncBatchAnnotateImages(context.Context, *AsyncBatchAnnotateImagesRequest) (*longrunningpb.Operation, error)
	// Run asynchronous image detection and annotation for a list of generic
	// files, such as PDF files, which may contain multiple pages and multiple
	// images per page. Progress and results can be retrieved through the
	// `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `OperationMetadata` (metadata).
	// `Operation.response` contains `AsyncBatchAnnotateFilesResponse` (results).
	AsyncBatchAnnotateFiles(context.Context, *AsyncBatchAnnotateFilesRequest) (*longrunningpb.Operation, error)
}

// UnimplementedImageAnnotatorServer should be embedded to have forward compatible implementations.
type UnimplementedImageAnnotatorServer struct {
}

func (UnimplementedImageAnnotatorServer) BatchAnnotateImages(context.Context, *BatchAnnotateImagesRequest) (*BatchAnnotateImagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchAnnotateImages not implemented")
}
func (UnimplementedImageAnnotatorServer) BatchAnnotateFiles(context.Context, *BatchAnnotateFilesRequest) (*BatchAnnotateFilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchAnnotateFiles not implemented")
}
func (UnimplementedImageAnnotatorServer) AsyncBatchAnnotateImages(context.Context, *AsyncBatchAnnotateImagesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AsyncBatchAnnotateImages not implemented")
}
func (UnimplementedImageAnnotatorServer) AsyncBatchAnnotateFiles(context.Context, *AsyncBatchAnnotateFilesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AsyncBatchAnnotateFiles not implemented")
}

// UnsafeImageAnnotatorServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ImageAnnotatorServer will
// result in compilation errors.
type UnsafeImageAnnotatorServer interface {
	mustEmbedUnimplementedImageAnnotatorServer()
}

func RegisterImageAnnotatorServer(s grpc.ServiceRegistrar, srv ImageAnnotatorServer) {
	s.RegisterService(&ImageAnnotator_ServiceDesc, srv)
}

func _ImageAnnotator_BatchAnnotateImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchAnnotateImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageAnnotatorServer).BatchAnnotateImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ImageAnnotator_BatchAnnotateImages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageAnnotatorServer).BatchAnnotateImages(ctx, req.(*BatchAnnotateImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageAnnotator_BatchAnnotateFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchAnnotateFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageAnnotatorServer).BatchAnnotateFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ImageAnnotator_BatchAnnotateFiles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageAnnotatorServer).BatchAnnotateFiles(ctx, req.(*BatchAnnotateFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageAnnotator_AsyncBatchAnnotateImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AsyncBatchAnnotateImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageAnnotatorServer).AsyncBatchAnnotateImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ImageAnnotator_AsyncBatchAnnotateImages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageAnnotatorServer).AsyncBatchAnnotateImages(ctx, req.(*AsyncBatchAnnotateImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageAnnotator_AsyncBatchAnnotateFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AsyncBatchAnnotateFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageAnnotatorServer).AsyncBatchAnnotateFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ImageAnnotator_AsyncBatchAnnotateFiles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageAnnotatorServer).AsyncBatchAnnotateFiles(ctx, req.(*AsyncBatchAnnotateFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ImageAnnotator_ServiceDesc is the grpc.ServiceDesc for ImageAnnotator service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ImageAnnotator_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.vision.v1.ImageAnnotator",
	HandlerType: (*ImageAnnotatorServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BatchAnnotateImages",
			Handler:    _ImageAnnotator_BatchAnnotateImages_Handler,
		},
		{
			MethodName: "BatchAnnotateFiles",
			Handler:    _ImageAnnotator_BatchAnnotateFiles_Handler,
		},
		{
			MethodName: "AsyncBatchAnnotateImages",
			Handler:    _ImageAnnotator_AsyncBatchAnnotateImages_Handler,
		},
		{
			MethodName: "AsyncBatchAnnotateFiles",
			Handler:    _ImageAnnotator_AsyncBatchAnnotateFiles_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/vision/v1/image_annotator.proto",
}
