// This file is part of MinIO Operator
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/minio/operator/pkg/apis/minio.min.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// TenantLister helps list Tenants.
// All objects returned here must be treated as read-only.
type TenantLister interface {
	// List lists all Tenants in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.Tenant, err error)
	// Tenants returns an object that can list and get Tenants.
	Tenants(namespace string) TenantNamespaceLister
	TenantListerExpansion
}

// tenantLister implements the TenantLister interface.
type tenantLister struct {
	indexer cache.Indexer
}

// NewTenantLister returns a new TenantLister.
func NewTenantLister(indexer cache.Indexer) TenantLister {
	return &tenantLister{indexer: indexer}
}

// List lists all Tenants in the indexer.
func (s *tenantLister) List(selector labels.Selector) (ret []*v1.Tenant, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Tenant))
	})
	return ret, err
}

// Tenants returns an object that can list and get Tenants.
func (s *tenantLister) Tenants(namespace string) TenantNamespaceLister {
	return tenantNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// TenantNamespaceLister helps list and get Tenants.
// All objects returned here must be treated as read-only.
type TenantNamespaceLister interface {
	// List lists all Tenants in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.Tenant, err error)
	// Get retrieves the Tenant from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.Tenant, error)
	TenantNamespaceListerExpansion
}

// tenantNamespaceLister implements the TenantNamespaceLister
// interface.
type tenantNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Tenants in the indexer for a given namespace.
func (s tenantNamespaceLister) List(selector labels.Selector) (ret []*v1.Tenant, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Tenant))
	})
	return ret, err
}

// Get retrieves the Tenant from the indexer for a given namespace and name.
func (s tenantNamespaceLister) Get(name string) (*v1.Tenant, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("tenant"), name)
	}
	return obj.(*v1.Tenant), nil
}
