// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/bigquery/migration/v2alpha/migration_entities.proto

package migration

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	errdetails "google.golang.org/genproto/googleapis/rpc/errdetails"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible migration workflow states.
type MigrationWorkflow_State int32

const (
	// Workflow state is unspecified.
	MigrationWorkflow_STATE_UNSPECIFIED MigrationWorkflow_State = 0
	// Workflow is in draft status, i.e. tasks are not yet eligible for
	// execution.
	MigrationWorkflow_DRAFT MigrationWorkflow_State = 1
	// Workflow is running (i.e. tasks are eligible for execution).
	MigrationWorkflow_RUNNING MigrationWorkflow_State = 2
	// Workflow is paused. Tasks currently in progress may continue, but no
	// further tasks will be scheduled.
	MigrationWorkflow_PAUSED MigrationWorkflow_State = 3
	// Workflow is complete. There should not be any task in a non-terminal
	// state, but if they are (e.g. forced termination), they will not be
	// scheduled.
	MigrationWorkflow_COMPLETED MigrationWorkflow_State = 4
)

// Enum value maps for MigrationWorkflow_State.
var (
	MigrationWorkflow_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "DRAFT",
		2: "RUNNING",
		3: "PAUSED",
		4: "COMPLETED",
	}
	MigrationWorkflow_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"DRAFT":             1,
		"RUNNING":           2,
		"PAUSED":            3,
		"COMPLETED":         4,
	}
)

func (x MigrationWorkflow_State) Enum() *MigrationWorkflow_State {
	p := new(MigrationWorkflow_State)
	*p = x
	return p
}

func (x MigrationWorkflow_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MigrationWorkflow_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_enumTypes[0].Descriptor()
}

func (MigrationWorkflow_State) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_enumTypes[0]
}

func (x MigrationWorkflow_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MigrationWorkflow_State.Descriptor instead.
func (MigrationWorkflow_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_rawDescGZIP(), []int{0, 0}
}

// Possible states of a migration task.
type MigrationTask_State int32

const (
	// The state is unspecified.
	MigrationTask_STATE_UNSPECIFIED MigrationTask_State = 0
	// The task is waiting for orchestration.
	MigrationTask_PENDING MigrationTask_State = 1
	// The task is assigned to an orchestrator.
	MigrationTask_ORCHESTRATING MigrationTask_State = 2
	// The task is running, i.e. its subtasks are ready for execution.
	MigrationTask_RUNNING MigrationTask_State = 3
	// Tha task is paused. Assigned subtasks can continue, but no new subtasks
	// will be scheduled.
	MigrationTask_PAUSED MigrationTask_State = 4
	// The task finished successfully.
	MigrationTask_SUCCEEDED MigrationTask_State = 5
	// The task finished unsuccessfully.
	MigrationTask_FAILED MigrationTask_State = 6
)

// Enum value maps for MigrationTask_State.
var (
	MigrationTask_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "ORCHESTRATING",
		3: "RUNNING",
		4: "PAUSED",
		5: "SUCCEEDED",
		6: "FAILED",
	}
	MigrationTask_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"ORCHESTRATING":     2,
		"RUNNING":           3,
		"PAUSED":            4,
		"SUCCEEDED":         5,
		"FAILED":            6,
	}
)

func (x MigrationTask_State) Enum() *MigrationTask_State {
	p := new(MigrationTask_State)
	*p = x
	return p
}

func (x MigrationTask_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MigrationTask_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_enumTypes[1].Descriptor()
}

func (MigrationTask_State) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_enumTypes[1]
}

func (x MigrationTask_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MigrationTask_State.Descriptor instead.
func (MigrationTask_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_rawDescGZIP(), []int{1, 0}
}

// Possible states of a migration subtask.
type MigrationSubtask_State int32

const (
	// The state is unspecified.
	MigrationSubtask_STATE_UNSPECIFIED MigrationSubtask_State = 0
	// The subtask is ready, i.e. it is ready for execution.
	MigrationSubtask_ACTIVE MigrationSubtask_State = 1
	// The subtask is running, i.e. it is assigned to a worker for execution.
	MigrationSubtask_RUNNING MigrationSubtask_State = 2
	// The subtask finished successfully.
	MigrationSubtask_SUCCEEDED MigrationSubtask_State = 3
	// The subtask finished unsuccessfully.
	MigrationSubtask_FAILED MigrationSubtask_State = 4
	// The subtask is paused, i.e., it will not be scheduled. If it was already
	// assigned,it might still finish but no new lease renewals will be granted.
	MigrationSubtask_PAUSED MigrationSubtask_State = 5
)

// Enum value maps for MigrationSubtask_State.
var (
	MigrationSubtask_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "RUNNING",
		3: "SUCCEEDED",
		4: "FAILED",
		5: "PAUSED",
	}
	MigrationSubtask_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"RUNNING":           2,
		"SUCCEEDED":         3,
		"FAILED":            4,
		"PAUSED":            5,
	}
)

func (x MigrationSubtask_State) Enum() *MigrationSubtask_State {
	p := new(MigrationSubtask_State)
	*p = x
	return p
}

func (x MigrationSubtask_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MigrationSubtask_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_enumTypes[2].Descriptor()
}

func (MigrationSubtask_State) Type() protoreflect.EnumType {
	return &file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_enumTypes[2]
}

func (x MigrationSubtask_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MigrationSubtask_State.Descriptor instead.
func (MigrationSubtask_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_rawDescGZIP(), []int{2, 0}
}

// A migration workflow which specifies what needs to be done for an EDW
// migration.
type MigrationWorkflow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Immutable. The unique identifier for the migration workflow. The ID is
	// server-generated.
	//
	// Example: `projects/123/locations/us/workflows/345`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The display name of the workflow. This can be set to give a workflow
	// a descriptive name. There is no guarantee or enforcement of uniqueness.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The tasks in a workflow in a named map. The name (i.e. key) has no
	// meaning and is merely a convenient way to address a specific task
	// in a workflow.
	Tasks map[string]*MigrationTask `protobuf:"bytes,2,rep,name=tasks,proto3" json:"tasks,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. That status of the workflow.
	State MigrationWorkflow_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.bigquery.migration.v2alpha.MigrationWorkflow_State" json:"state,omitempty"`
	// Time when the workflow was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time when the workflow was last updated.
	LastUpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
}

func (x *MigrationWorkflow) Reset() {
	*x = MigrationWorkflow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MigrationWorkflow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrationWorkflow) ProtoMessage() {}

func (x *MigrationWorkflow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrationWorkflow.ProtoReflect.Descriptor instead.
func (*MigrationWorkflow) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_rawDescGZIP(), []int{0}
}

func (x *MigrationWorkflow) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MigrationWorkflow) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *MigrationWorkflow) GetTasks() map[string]*MigrationTask {
	if x != nil {
		return x.Tasks
	}
	return nil
}

func (x *MigrationWorkflow) GetState() MigrationWorkflow_State {
	if x != nil {
		return x.State
	}
	return MigrationWorkflow_STATE_UNSPECIFIED
}

func (x *MigrationWorkflow) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *MigrationWorkflow) GetLastUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdateTime
	}
	return nil
}

// A single task for a migration which has details about the configuration of
// the task.
type MigrationTask struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The details of the task.
	//
	// Types that are assignable to TaskDetails:
	//	*MigrationTask_AssessmentTaskDetails
	//	*MigrationTask_TranslationTaskDetails
	TaskDetails isMigrationTask_TaskDetails `protobuf_oneof:"task_details"`
	// Output only. Immutable. The unique identifier for the migration task. The ID is server-generated.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The type of the task. This must be a supported task type.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// DEPRECATED! Use one of the task_details below.
	// The details of the task. The type URL must be one of the supported task
	// details messages and correspond to the Task's type.
	Details *anypb.Any `protobuf:"bytes,3,opt,name=details,proto3" json:"details,omitempty"`
	// Output only. The current state of the task.
	State MigrationTask_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.bigquery.migration.v2alpha.MigrationTask_State" json:"state,omitempty"`
	// Output only. An explanation that may be populated when the task is in FAILED state.
	ProcessingError *errdetails.ErrorInfo `protobuf:"bytes,5,opt,name=processing_error,json=processingError,proto3" json:"processing_error,omitempty"`
	// Time when the task was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time when the task was last updated.
	LastUpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
	// Output only. Additional information about the orchestration.
	OrchestrationResult *MigrationTaskOrchestrationResult `protobuf:"bytes,10,opt,name=orchestration_result,json=orchestrationResult,proto3" json:"orchestration_result,omitempty"`
}

func (x *MigrationTask) Reset() {
	*x = MigrationTask{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MigrationTask) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrationTask) ProtoMessage() {}

func (x *MigrationTask) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrationTask.ProtoReflect.Descriptor instead.
func (*MigrationTask) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_rawDescGZIP(), []int{1}
}

func (m *MigrationTask) GetTaskDetails() isMigrationTask_TaskDetails {
	if m != nil {
		return m.TaskDetails
	}
	return nil
}

func (x *MigrationTask) GetAssessmentTaskDetails() *AssessmentTaskDetails {
	if x, ok := x.GetTaskDetails().(*MigrationTask_AssessmentTaskDetails); ok {
		return x.AssessmentTaskDetails
	}
	return nil
}

func (x *MigrationTask) GetTranslationTaskDetails() *TranslationTaskDetails {
	if x, ok := x.GetTaskDetails().(*MigrationTask_TranslationTaskDetails); ok {
		return x.TranslationTaskDetails
	}
	return nil
}

func (x *MigrationTask) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *MigrationTask) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *MigrationTask) GetDetails() *anypb.Any {
	if x != nil {
		return x.Details
	}
	return nil
}

func (x *MigrationTask) GetState() MigrationTask_State {
	if x != nil {
		return x.State
	}
	return MigrationTask_STATE_UNSPECIFIED
}

func (x *MigrationTask) GetProcessingError() *errdetails.ErrorInfo {
	if x != nil {
		return x.ProcessingError
	}
	return nil
}

func (x *MigrationTask) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *MigrationTask) GetLastUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdateTime
	}
	return nil
}

func (x *MigrationTask) GetOrchestrationResult() *MigrationTaskOrchestrationResult {
	if x != nil {
		return x.OrchestrationResult
	}
	return nil
}

type isMigrationTask_TaskDetails interface {
	isMigrationTask_TaskDetails()
}

type MigrationTask_AssessmentTaskDetails struct {
	// Task configuration for Assessment.
	AssessmentTaskDetails *AssessmentTaskDetails `protobuf:"bytes,12,opt,name=assessment_task_details,json=assessmentTaskDetails,proto3,oneof"`
}

type MigrationTask_TranslationTaskDetails struct {
	// Task configuration for Batch/Offline SQL Translation.
	TranslationTaskDetails *TranslationTaskDetails `protobuf:"bytes,13,opt,name=translation_task_details,json=translationTaskDetails,proto3,oneof"`
}

func (*MigrationTask_AssessmentTaskDetails) isMigrationTask_TaskDetails() {}

func (*MigrationTask_TranslationTaskDetails) isMigrationTask_TaskDetails() {}

// A subtask for a migration which carries details about the configuration of
// the subtask. The content of the details should not matter to the end user,
// but is a contract between the subtask creator and subtask worker.
type MigrationSubtask struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Immutable. The resource name for the migration subtask. The ID is
	// server-generated.
	//
	// Example: `projects/123/locations/us/workflows/345/subtasks/678`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The unique ID of the task to which this subtask belongs.
	TaskId string `protobuf:"bytes,2,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// The type of the Subtask. The migration service does not check whether this
	// is a known type. It is up to the task creator (i.e. orchestrator or worker)
	// to ensure it only creates subtasks for which there are compatible workers
	// polling for Subtasks.
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	// Output only. The current state of the subtask.
	State MigrationSubtask_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.bigquery.migration.v2alpha.MigrationSubtask_State" json:"state,omitempty"`
	// Output only. An explanation that may be populated when the task is in FAILED state.
	ProcessingError *errdetails.ErrorInfo `protobuf:"bytes,6,opt,name=processing_error,json=processingError,proto3" json:"processing_error,omitempty"`
	// Output only. Provides details to errors and issues encountered while processing the
	// subtask. Presence of error details does not mean that the subtask failed.
	ResourceErrorDetails []*ResourceErrorDetail `protobuf:"bytes,12,rep,name=resource_error_details,json=resourceErrorDetails,proto3" json:"resource_error_details,omitempty"`
	// The number or resources with errors. Note: This is not the total
	// number of errors as each resource can have more than one error.
	// This is used to indicate truncation by having a `resource_error_count`
	// that is higher than the size of `resource_error_details`.
	ResourceErrorCount int32 `protobuf:"varint,13,opt,name=resource_error_count,json=resourceErrorCount,proto3" json:"resource_error_count,omitempty"`
	// Time when the subtask was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time when the subtask was last updated.
	LastUpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
	// The metrics for the subtask.
	Metrics []*TimeSeries `protobuf:"bytes,11,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *MigrationSubtask) Reset() {
	*x = MigrationSubtask{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MigrationSubtask) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrationSubtask) ProtoMessage() {}

func (x *MigrationSubtask) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrationSubtask.ProtoReflect.Descriptor instead.
func (*MigrationSubtask) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_rawDescGZIP(), []int{2}
}

func (x *MigrationSubtask) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MigrationSubtask) GetTaskId() string {
	if x != nil {
		return x.TaskId
	}
	return ""
}

func (x *MigrationSubtask) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *MigrationSubtask) GetState() MigrationSubtask_State {
	if x != nil {
		return x.State
	}
	return MigrationSubtask_STATE_UNSPECIFIED
}

func (x *MigrationSubtask) GetProcessingError() *errdetails.ErrorInfo {
	if x != nil {
		return x.ProcessingError
	}
	return nil
}

func (x *MigrationSubtask) GetResourceErrorDetails() []*ResourceErrorDetail {
	if x != nil {
		return x.ResourceErrorDetails
	}
	return nil
}

func (x *MigrationSubtask) GetResourceErrorCount() int32 {
	if x != nil {
		return x.ResourceErrorCount
	}
	return 0
}

func (x *MigrationSubtask) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *MigrationSubtask) GetLastUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdateTime
	}
	return nil
}

func (x *MigrationSubtask) GetMetrics() []*TimeSeries {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// Additional information from the orchestrator when it is done with the
// task orchestration.
type MigrationTaskOrchestrationResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details specific to the task type.
	//
	// Types that are assignable to Details:
	//	*MigrationTaskOrchestrationResult_AssessmentDetails
	Details isMigrationTaskOrchestrationResult_Details `protobuf_oneof:"details"`
}

func (x *MigrationTaskOrchestrationResult) Reset() {
	*x = MigrationTaskOrchestrationResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MigrationTaskOrchestrationResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrationTaskOrchestrationResult) ProtoMessage() {}

func (x *MigrationTaskOrchestrationResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrationTaskOrchestrationResult.ProtoReflect.Descriptor instead.
func (*MigrationTaskOrchestrationResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_rawDescGZIP(), []int{3}
}

func (m *MigrationTaskOrchestrationResult) GetDetails() isMigrationTaskOrchestrationResult_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *MigrationTaskOrchestrationResult) GetAssessmentDetails() *AssessmentOrchestrationResultDetails {
	if x, ok := x.GetDetails().(*MigrationTaskOrchestrationResult_AssessmentDetails); ok {
		return x.AssessmentDetails
	}
	return nil
}

type isMigrationTaskOrchestrationResult_Details interface {
	isMigrationTaskOrchestrationResult_Details()
}

type MigrationTaskOrchestrationResult_AssessmentDetails struct {
	// Details specific to assessment task types.
	AssessmentDetails *AssessmentOrchestrationResultDetails `protobuf:"bytes,1,opt,name=assessment_details,json=assessmentDetails,proto3,oneof"`
}

func (*MigrationTaskOrchestrationResult_AssessmentDetails) isMigrationTaskOrchestrationResult_Details() {
}

var File_google_cloud_bigquery_migration_v2alpha_migration_entities_proto protoreflect.FileDescriptor

var file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_rawDesc = []byte{
	0x0a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x61, 0x73, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76,
	0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
	0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcb, 0x05, 0x0a, 0x11, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77,
	0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06,
	0xe0, 0x41, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x5b, 0x0a, 0x05, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x05, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x12, 0x5b, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57,
	0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x6c, 0x61,
	0x73, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x70, 0x0a, 0x0a,
	0x54, 0x61, 0x73, 0x6b, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4c, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x61, 0x73, 0x6b, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x51,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x44, 0x52, 0x41, 0x46, 0x54, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e,
	0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41, 0x55, 0x53, 0x45, 0x44,
	0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10,
	0x04, 0x3a, 0x75, 0xea, 0x41, 0x72, 0x0a, 0x32, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2f, 0x7b, 0x77,
	0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x7d, 0x22, 0x8d, 0x07, 0x0a, 0x0d, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x73, 0x6b, 0x12, 0x78, 0x0a, 0x17, 0x61, 0x73,
	0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74,
	0x54, 0x61, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x15, 0x61,
	0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x7b, 0x0a, 0x18, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x73, 0x6b,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x16, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x12, 0x16, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0,
	0x41, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x2e, 0x0a,
	0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x41, 0x6e, 0x79, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x57, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x61, 0x73, 0x6b, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x45, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x3b, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x6c, 0x61,
	0x73, 0x74, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x81, 0x01, 0x0a, 0x14, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x61, 0x73, 0x6b, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x13, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x22, 0x72, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4f, 0x52, 0x43, 0x48, 0x45, 0x53, 0x54, 0x52, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10,
	0x03, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41, 0x55, 0x53, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0d, 0x0a,
	0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06,
	0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x42, 0x0e, 0x0a, 0x0c, 0x74, 0x61, 0x73, 0x6b,
	0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xe6, 0x06, 0x0a, 0x10, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x74, 0x61, 0x73, 0x6b, 0x12, 0x1a, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03,
	0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x74, 0x61, 0x73,
	0x6b, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x73, 0x6b,
	0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x5a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x74, 0x61, 0x73, 0x6b,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x45, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x49,
	0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x77, 0x0a, 0x16, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x12, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x44, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x07, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0x5e, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45,
	0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12,
	0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a,
	0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41,
	0x55, 0x53, 0x45, 0x44, 0x10, 0x05, 0x3a, 0x88, 0x01, 0xea, 0x41, 0x84, 0x01, 0x0a, 0x31, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x62, 0x74, 0x61, 0x73, 0x6b,
	0x12, 0x4f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x73, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x7d, 0x2f, 0x73,
	0x75, 0x62, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2f, 0x7b, 0x73, 0x75, 0x62, 0x74, 0x61, 0x73, 0x6b,
	0x7d, 0x22, 0xad, 0x01, 0x0a, 0x20, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x61, 0x73, 0x6b, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x7e, 0x0a, 0x12, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x73, 0x73,
	0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x48, 0x00, 0x52, 0x11, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x09, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x42, 0xed, 0x01, 0x0a, 0x2b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x42, 0x16, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x50, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67,
	0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x32, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x3b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0xaa, 0x02, 0x27,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x56, 0x32, 0x41, 0x6c, 0x70, 0x68, 0x61, 0xca, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x5c,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5c, 0x56, 0x32, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_rawDescOnce sync.Once
	file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_rawDescData = file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_rawDesc
)

func file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_rawDescGZIP() []byte {
	file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_rawDescOnce.Do(func() {
		file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_rawDescData)
	})
	return file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_rawDescData
}

var file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_goTypes = []interface{}{
	(MigrationWorkflow_State)(0),                 // 0: google.cloud.bigquery.migration.v2alpha.MigrationWorkflow.State
	(MigrationTask_State)(0),                     // 1: google.cloud.bigquery.migration.v2alpha.MigrationTask.State
	(MigrationSubtask_State)(0),                  // 2: google.cloud.bigquery.migration.v2alpha.MigrationSubtask.State
	(*MigrationWorkflow)(nil),                    // 3: google.cloud.bigquery.migration.v2alpha.MigrationWorkflow
	(*MigrationTask)(nil),                        // 4: google.cloud.bigquery.migration.v2alpha.MigrationTask
	(*MigrationSubtask)(nil),                     // 5: google.cloud.bigquery.migration.v2alpha.MigrationSubtask
	(*MigrationTaskOrchestrationResult)(nil),     // 6: google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult
	nil,                                          // 7: google.cloud.bigquery.migration.v2alpha.MigrationWorkflow.TasksEntry
	(*timestamppb.Timestamp)(nil),                // 8: google.protobuf.Timestamp
	(*AssessmentTaskDetails)(nil),                // 9: google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails
	(*TranslationTaskDetails)(nil),               // 10: google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
	(*anypb.Any)(nil),                            // 11: google.protobuf.Any
	(*errdetails.ErrorInfo)(nil),                 // 12: google.rpc.ErrorInfo
	(*ResourceErrorDetail)(nil),                  // 13: google.cloud.bigquery.migration.v2alpha.ResourceErrorDetail
	(*TimeSeries)(nil),                           // 14: google.cloud.bigquery.migration.v2alpha.TimeSeries
	(*AssessmentOrchestrationResultDetails)(nil), // 15: google.cloud.bigquery.migration.v2alpha.AssessmentOrchestrationResultDetails
}
var file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_depIdxs = []int32{
	7,  // 0: google.cloud.bigquery.migration.v2alpha.MigrationWorkflow.tasks:type_name -> google.cloud.bigquery.migration.v2alpha.MigrationWorkflow.TasksEntry
	0,  // 1: google.cloud.bigquery.migration.v2alpha.MigrationWorkflow.state:type_name -> google.cloud.bigquery.migration.v2alpha.MigrationWorkflow.State
	8,  // 2: google.cloud.bigquery.migration.v2alpha.MigrationWorkflow.create_time:type_name -> google.protobuf.Timestamp
	8,  // 3: google.cloud.bigquery.migration.v2alpha.MigrationWorkflow.last_update_time:type_name -> google.protobuf.Timestamp
	9,  // 4: google.cloud.bigquery.migration.v2alpha.MigrationTask.assessment_task_details:type_name -> google.cloud.bigquery.migration.v2alpha.AssessmentTaskDetails
	10, // 5: google.cloud.bigquery.migration.v2alpha.MigrationTask.translation_task_details:type_name -> google.cloud.bigquery.migration.v2alpha.TranslationTaskDetails
	11, // 6: google.cloud.bigquery.migration.v2alpha.MigrationTask.details:type_name -> google.protobuf.Any
	1,  // 7: google.cloud.bigquery.migration.v2alpha.MigrationTask.state:type_name -> google.cloud.bigquery.migration.v2alpha.MigrationTask.State
	12, // 8: google.cloud.bigquery.migration.v2alpha.MigrationTask.processing_error:type_name -> google.rpc.ErrorInfo
	8,  // 9: google.cloud.bigquery.migration.v2alpha.MigrationTask.create_time:type_name -> google.protobuf.Timestamp
	8,  // 10: google.cloud.bigquery.migration.v2alpha.MigrationTask.last_update_time:type_name -> google.protobuf.Timestamp
	6,  // 11: google.cloud.bigquery.migration.v2alpha.MigrationTask.orchestration_result:type_name -> google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult
	2,  // 12: google.cloud.bigquery.migration.v2alpha.MigrationSubtask.state:type_name -> google.cloud.bigquery.migration.v2alpha.MigrationSubtask.State
	12, // 13: google.cloud.bigquery.migration.v2alpha.MigrationSubtask.processing_error:type_name -> google.rpc.ErrorInfo
	13, // 14: google.cloud.bigquery.migration.v2alpha.MigrationSubtask.resource_error_details:type_name -> google.cloud.bigquery.migration.v2alpha.ResourceErrorDetail
	8,  // 15: google.cloud.bigquery.migration.v2alpha.MigrationSubtask.create_time:type_name -> google.protobuf.Timestamp
	8,  // 16: google.cloud.bigquery.migration.v2alpha.MigrationSubtask.last_update_time:type_name -> google.protobuf.Timestamp
	14, // 17: google.cloud.bigquery.migration.v2alpha.MigrationSubtask.metrics:type_name -> google.cloud.bigquery.migration.v2alpha.TimeSeries
	15, // 18: google.cloud.bigquery.migration.v2alpha.MigrationTaskOrchestrationResult.assessment_details:type_name -> google.cloud.bigquery.migration.v2alpha.AssessmentOrchestrationResultDetails
	4,  // 19: google.cloud.bigquery.migration.v2alpha.MigrationWorkflow.TasksEntry.value:type_name -> google.cloud.bigquery.migration.v2alpha.MigrationTask
	20, // [20:20] is the sub-list for method output_type
	20, // [20:20] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_init() }
func file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_init() {
	if File_google_cloud_bigquery_migration_v2alpha_migration_entities_proto != nil {
		return
	}
	file_google_cloud_bigquery_migration_v2alpha_assessment_task_proto_init()
	file_google_cloud_bigquery_migration_v2alpha_migration_error_details_proto_init()
	file_google_cloud_bigquery_migration_v2alpha_migration_metrics_proto_init()
	file_google_cloud_bigquery_migration_v2alpha_translation_task_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MigrationWorkflow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MigrationTask); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MigrationSubtask); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MigrationTaskOrchestrationResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*MigrationTask_AssessmentTaskDetails)(nil),
		(*MigrationTask_TranslationTaskDetails)(nil),
	}
	file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*MigrationTaskOrchestrationResult_AssessmentDetails)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_goTypes,
		DependencyIndexes: file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_depIdxs,
		EnumInfos:         file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_enumTypes,
		MessageInfos:      file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_msgTypes,
	}.Build()
	File_google_cloud_bigquery_migration_v2alpha_migration_entities_proto = out.File
	file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_rawDesc = nil
	file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_goTypes = nil
	file_google_cloud_bigquery_migration_v2alpha_migration_entities_proto_depIdxs = nil
}
