// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package datacatalog aliases all exported identifiers in package
// "cloud.google.com/go/datacatalog/apiv1/datacatalogpb".
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package datacatalog

import (
	src "cloud.google.com/go/datacatalog/apiv1/datacatalogpb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
const (
	BigQueryConnectionSpec_CLOUD_SQL                         = src.BigQueryConnectionSpec_CLOUD_SQL
	BigQueryConnectionSpec_CONNECTION_TYPE_UNSPECIFIED       = src.BigQueryConnectionSpec_CONNECTION_TYPE_UNSPECIFIED
	CloudSqlBigQueryConnectionSpec_DATABASE_TYPE_UNSPECIFIED = src.CloudSqlBigQueryConnectionSpec_DATABASE_TYPE_UNSPECIFIED
	CloudSqlBigQueryConnectionSpec_MYSQL                     = src.CloudSqlBigQueryConnectionSpec_MYSQL
	CloudSqlBigQueryConnectionSpec_POSTGRES                  = src.CloudSqlBigQueryConnectionSpec_POSTGRES
	DataSource_BIGQUERY                                      = src.DataSource_BIGQUERY
	DataSource_CLOUD_STORAGE                                 = src.DataSource_CLOUD_STORAGE
	DataSource_SERVICE_UNSPECIFIED                           = src.DataSource_SERVICE_UNSPECIFIED
	DatabaseTableSpec_EXTERNAL                               = src.DatabaseTableSpec_EXTERNAL
	DatabaseTableSpec_NATIVE                                 = src.DatabaseTableSpec_NATIVE
	DatabaseTableSpec_TABLE_TYPE_UNSPECIFIED                 = src.DatabaseTableSpec_TABLE_TYPE_UNSPECIFIED
	EntryType_CLUSTER                                        = src.EntryType_CLUSTER
	EntryType_DATABASE                                       = src.EntryType_DATABASE
	EntryType_DATA_SOURCE_CONNECTION                         = src.EntryType_DATA_SOURCE_CONNECTION
	EntryType_DATA_STREAM                                    = src.EntryType_DATA_STREAM
	EntryType_ENTRY_TYPE_UNSPECIFIED                         = src.EntryType_ENTRY_TYPE_UNSPECIFIED
	EntryType_FILESET                                        = src.EntryType_FILESET
	EntryType_LAKE                                           = src.EntryType_LAKE
	EntryType_MODEL                                          = src.EntryType_MODEL
	EntryType_ROUTINE                                        = src.EntryType_ROUTINE
	EntryType_SERVICE                                        = src.EntryType_SERVICE
	EntryType_TABLE                                          = src.EntryType_TABLE
	EntryType_ZONE                                           = src.EntryType_ZONE
	FieldType_BOOL                                           = src.FieldType_BOOL
	FieldType_DOUBLE                                         = src.FieldType_DOUBLE
	FieldType_PRIMITIVE_TYPE_UNSPECIFIED                     = src.FieldType_PRIMITIVE_TYPE_UNSPECIFIED
	FieldType_RICHTEXT                                       = src.FieldType_RICHTEXT
	FieldType_STRING                                         = src.FieldType_STRING
	FieldType_TIMESTAMP                                      = src.FieldType_TIMESTAMP
	IntegratedSystem_BIGQUERY                                = src.IntegratedSystem_BIGQUERY
	IntegratedSystem_CLOUD_PUBSUB                            = src.IntegratedSystem_CLOUD_PUBSUB
	IntegratedSystem_DATAPLEX                                = src.IntegratedSystem_DATAPLEX
	IntegratedSystem_DATAPROC_METASTORE                      = src.IntegratedSystem_DATAPROC_METASTORE
	IntegratedSystem_INTEGRATED_SYSTEM_UNSPECIFIED           = src.IntegratedSystem_INTEGRATED_SYSTEM_UNSPECIFIED
	RoutineSpec_Argument_IN                                  = src.RoutineSpec_Argument_IN
	RoutineSpec_Argument_INOUT                               = src.RoutineSpec_Argument_INOUT
	RoutineSpec_Argument_MODE_UNSPECIFIED                    = src.RoutineSpec_Argument_MODE_UNSPECIFIED
	RoutineSpec_Argument_OUT                                 = src.RoutineSpec_Argument_OUT
	RoutineSpec_PROCEDURE                                    = src.RoutineSpec_PROCEDURE
	RoutineSpec_ROUTINE_TYPE_UNSPECIFIED                     = src.RoutineSpec_ROUTINE_TYPE_UNSPECIFIED
	RoutineSpec_SCALAR_FUNCTION                              = src.RoutineSpec_SCALAR_FUNCTION
	SearchResultType_ENTRY                                   = src.SearchResultType_ENTRY
	SearchResultType_ENTRY_GROUP                             = src.SearchResultType_ENTRY_GROUP
	SearchResultType_SEARCH_RESULT_TYPE_UNSPECIFIED          = src.SearchResultType_SEARCH_RESULT_TYPE_UNSPECIFIED
	SearchResultType_TAG_TEMPLATE                            = src.SearchResultType_TAG_TEMPLATE
	TableSourceType_BIGQUERY_MATERIALIZED_VIEW               = src.TableSourceType_BIGQUERY_MATERIALIZED_VIEW
	TableSourceType_BIGQUERY_TABLE                           = src.TableSourceType_BIGQUERY_TABLE
	TableSourceType_BIGQUERY_VIEW                            = src.TableSourceType_BIGQUERY_VIEW
	TableSourceType_TABLE_SOURCE_TYPE_UNSPECIFIED            = src.TableSourceType_TABLE_SOURCE_TYPE_UNSPECIFIED
	Taxonomy_FINE_GRAINED_ACCESS_CONTROL                     = src.Taxonomy_FINE_GRAINED_ACCESS_CONTROL
	Taxonomy_POLICY_TYPE_UNSPECIFIED                         = src.Taxonomy_POLICY_TYPE_UNSPECIFIED
)

// Deprecated: Please use vars in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
var (
	BigQueryConnectionSpec_ConnectionType_name                           = src.BigQueryConnectionSpec_ConnectionType_name
	BigQueryConnectionSpec_ConnectionType_value                          = src.BigQueryConnectionSpec_ConnectionType_value
	CloudSqlBigQueryConnectionSpec_DatabaseType_name                     = src.CloudSqlBigQueryConnectionSpec_DatabaseType_name
	CloudSqlBigQueryConnectionSpec_DatabaseType_value                    = src.CloudSqlBigQueryConnectionSpec_DatabaseType_value
	DataSource_Service_name                                              = src.DataSource_Service_name
	DataSource_Service_value                                             = src.DataSource_Service_value
	DatabaseTableSpec_TableType_name                                     = src.DatabaseTableSpec_TableType_name
	DatabaseTableSpec_TableType_value                                    = src.DatabaseTableSpec_TableType_value
	EntryType_name                                                       = src.EntryType_name
	EntryType_value                                                      = src.EntryType_value
	FieldType_PrimitiveType_name                                         = src.FieldType_PrimitiveType_name
	FieldType_PrimitiveType_value                                        = src.FieldType_PrimitiveType_value
	File_google_cloud_datacatalog_v1_bigquery_proto                      = src.File_google_cloud_datacatalog_v1_bigquery_proto
	File_google_cloud_datacatalog_v1_common_proto                        = src.File_google_cloud_datacatalog_v1_common_proto
	File_google_cloud_datacatalog_v1_data_source_proto                   = src.File_google_cloud_datacatalog_v1_data_source_proto
	File_google_cloud_datacatalog_v1_datacatalog_proto                   = src.File_google_cloud_datacatalog_v1_datacatalog_proto
	File_google_cloud_datacatalog_v1_dataplex_spec_proto                 = src.File_google_cloud_datacatalog_v1_dataplex_spec_proto
	File_google_cloud_datacatalog_v1_gcs_fileset_spec_proto              = src.File_google_cloud_datacatalog_v1_gcs_fileset_spec_proto
	File_google_cloud_datacatalog_v1_physical_schema_proto               = src.File_google_cloud_datacatalog_v1_physical_schema_proto
	File_google_cloud_datacatalog_v1_policytagmanager_proto              = src.File_google_cloud_datacatalog_v1_policytagmanager_proto
	File_google_cloud_datacatalog_v1_policytagmanagerserialization_proto = src.File_google_cloud_datacatalog_v1_policytagmanagerserialization_proto
	File_google_cloud_datacatalog_v1_schema_proto                        = src.File_google_cloud_datacatalog_v1_schema_proto
	File_google_cloud_datacatalog_v1_search_proto                        = src.File_google_cloud_datacatalog_v1_search_proto
	File_google_cloud_datacatalog_v1_table_spec_proto                    = src.File_google_cloud_datacatalog_v1_table_spec_proto
	File_google_cloud_datacatalog_v1_tags_proto                          = src.File_google_cloud_datacatalog_v1_tags_proto
	File_google_cloud_datacatalog_v1_timestamps_proto                    = src.File_google_cloud_datacatalog_v1_timestamps_proto
	File_google_cloud_datacatalog_v1_usage_proto                         = src.File_google_cloud_datacatalog_v1_usage_proto
	IntegratedSystem_name                                                = src.IntegratedSystem_name
	IntegratedSystem_value                                               = src.IntegratedSystem_value
	RoutineSpec_Argument_Mode_name                                       = src.RoutineSpec_Argument_Mode_name
	RoutineSpec_Argument_Mode_value                                      = src.RoutineSpec_Argument_Mode_value
	RoutineSpec_RoutineType_name                                         = src.RoutineSpec_RoutineType_name
	RoutineSpec_RoutineType_value                                        = src.RoutineSpec_RoutineType_value
	SearchResultType_name                                                = src.SearchResultType_name
	SearchResultType_value                                               = src.SearchResultType_value
	TableSourceType_name                                                 = src.TableSourceType_name
	TableSourceType_value                                                = src.TableSourceType_value
	Taxonomy_PolicyType_name                                             = src.Taxonomy_PolicyType_name
	Taxonomy_PolicyType_value                                            = src.Taxonomy_PolicyType_value
)

// Specification for the BigQuery connection.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type BigQueryConnectionSpec = src.BigQueryConnectionSpec
type BigQueryConnectionSpec_CloudSql = src.BigQueryConnectionSpec_CloudSql

// The type of the BigQuery connection.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type BigQueryConnectionSpec_ConnectionType = src.BigQueryConnectionSpec_ConnectionType

// Specification for a group of BigQuery tables with the `[prefix]YYYYMMDD`
// name pattern. For more information, see [Introduction to partitioned tables]
// (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type BigQueryDateShardedSpec = src.BigQueryDateShardedSpec

// Fields specific for BigQuery routines.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type BigQueryRoutineSpec = src.BigQueryRoutineSpec

// Describes a BigQuery table.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type BigQueryTableSpec = src.BigQueryTableSpec
type BigQueryTableSpec_TableSpec = src.BigQueryTableSpec_TableSpec
type BigQueryTableSpec_ViewSpec = src.BigQueryTableSpec_ViewSpec

// Business Context of the entry.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type BusinessContext = src.BusinessContext

// Specification for the BigQuery connection to a Cloud SQL instance.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type CloudSqlBigQueryConnectionSpec = src.CloudSqlBigQueryConnectionSpec

// Supported Cloud SQL database types.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type CloudSqlBigQueryConnectionSpec_DatabaseType = src.CloudSqlBigQueryConnectionSpec_DatabaseType

// A column within a schema. Columns can be nested inside other columns.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ColumnSchema = src.ColumnSchema

// Contact people for the entry.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type Contacts = src.Contacts

// A contact person for the entry.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type Contacts_Person = src.Contacts_Person

// Request message for
// [CreateEntryGroup][google.cloud.datacatalog.v1.DataCatalog.CreateEntryGroup].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type CreateEntryGroupRequest = src.CreateEntryGroupRequest

// Request message for
// [CreateEntry][google.cloud.datacatalog.v1.DataCatalog.CreateEntry].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type CreateEntryRequest = src.CreateEntryRequest

// Request message for
// [CreatePolicyTag][google.cloud.datacatalog.v1.PolicyTagManager.CreatePolicyTag].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type CreatePolicyTagRequest = src.CreatePolicyTagRequest

// Request message for
// [CreateTag][google.cloud.datacatalog.v1.DataCatalog.CreateTag].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type CreateTagRequest = src.CreateTagRequest

// Request message for
// [CreateTagTemplateField][google.cloud.datacatalog.v1.DataCatalog.CreateTagTemplateField].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type CreateTagTemplateFieldRequest = src.CreateTagTemplateFieldRequest

// Request message for
// [CreateTagTemplate][google.cloud.datacatalog.v1.DataCatalog.CreateTagTemplate].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type CreateTagTemplateRequest = src.CreateTagTemplateRequest

// Request message for
// [CreateTaxonomy][google.cloud.datacatalog.v1.PolicyTagManager.CreateTaxonomy].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type CreateTaxonomyRequest = src.CreateTaxonomyRequest

// Cross-regional source used to import an existing taxonomy into a different
// region.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type CrossRegionalSource = src.CrossRegionalSource

// DataCatalogClient is the client API for DataCatalog service. For semantics
// around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type DataCatalogClient = src.DataCatalogClient

// DataCatalogServer is the server API for DataCatalog service.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type DataCatalogServer = src.DataCatalogServer

// Physical location of an entry.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type DataSource = src.DataSource

// Specification that applies to a data source connection. Valid only for
// entries with the `DATA_SOURCE_CONNECTION` type.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type DataSourceConnectionSpec = src.DataSourceConnectionSpec

// Name of a service that stores the data.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type DataSource_Service = src.DataSource_Service
type DataSource_StorageProperties = src.DataSource_StorageProperties

// Specification that applies to a table resource. Valid only for entries with
// the `TABLE` type.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type DatabaseTableSpec = src.DatabaseTableSpec

// Type of the table.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type DatabaseTableSpec_TableType = src.DatabaseTableSpec_TableType

// External table registered by Dataplex. Dataplex publishes data discovered
// from an asset into multiple other systems (BigQuery, DPMS) in form of
// tables. We call them "external tables". External tables are also synced into
// the Data Catalog. This message contains pointers to those external tables
// (fully qualified name, resource name et cetera) within the Data Catalog.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type DataplexExternalTable = src.DataplexExternalTable

// Entry specyfication for a Dataplex fileset.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type DataplexFilesetSpec = src.DataplexFilesetSpec

// Common Dataplex fields.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type DataplexSpec = src.DataplexSpec

// Entry specification for a Dataplex table.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type DataplexTableSpec = src.DataplexTableSpec

// Request message for
// [DeleteEntryGroup][google.cloud.datacatalog.v1.DataCatalog.DeleteEntryGroup].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type DeleteEntryGroupRequest = src.DeleteEntryGroupRequest

// Request message for
// [DeleteEntry][google.cloud.datacatalog.v1.DataCatalog.DeleteEntry].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type DeleteEntryRequest = src.DeleteEntryRequest

// Request message for
// [DeletePolicyTag][google.cloud.datacatalog.v1.PolicyTagManager.DeletePolicyTag].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type DeletePolicyTagRequest = src.DeletePolicyTagRequest

// Request message for
// [DeleteTag][google.cloud.datacatalog.v1.DataCatalog.DeleteTag].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type DeleteTagRequest = src.DeleteTagRequest

// Request message for
// [DeleteTagTemplateField][google.cloud.datacatalog.v1.DataCatalog.DeleteTagTemplateField].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type DeleteTagTemplateFieldRequest = src.DeleteTagTemplateFieldRequest

// Request message for
// [DeleteTagTemplate][google.cloud.datacatalog.v1.DataCatalog.DeleteTagTemplate].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type DeleteTagTemplateRequest = src.DeleteTagTemplateRequest

// Request message for
// [DeleteTaxonomy][google.cloud.datacatalog.v1.PolicyTagManager.DeleteTaxonomy].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type DeleteTaxonomyRequest = src.DeleteTaxonomyRequest

// Entry metadata. A Data Catalog entry represents another resource in Google
// Cloud Platform (such as a BigQuery dataset or a Pub/Sub topic) or outside of
// it. You can use the `linked_resource` field in the entry resource to refer
// to the original resource ID of the source system. An entry resource contains
// resource details, for example, its schema. Additionally, you can attach
// flexible metadata to an entry in the form of a
// [Tag][google.cloud.datacatalog.v1.Tag].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type Entry = src.Entry

// Entry group metadata. An `EntryGroup` resource represents a logical
// grouping of zero or more Data Catalog
// [Entry][google.cloud.datacatalog.v1.Entry] resources.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type EntryGroup = src.EntryGroup

// Entry overview fields for rich text descriptions of entries.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type EntryOverview = src.EntryOverview

// The enum field that lists all the types of entry resources in Data Catalog.
// For example, a BigQuery table entry has the `TABLE` type.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type EntryType = src.EntryType
type Entry_BigqueryDateShardedSpec = src.Entry_BigqueryDateShardedSpec
type Entry_BigqueryTableSpec = src.Entry_BigqueryTableSpec
type Entry_DataSourceConnectionSpec = src.Entry_DataSourceConnectionSpec
type Entry_DatabaseTableSpec = src.Entry_DatabaseTableSpec
type Entry_FilesetSpec = src.Entry_FilesetSpec
type Entry_GcsFilesetSpec = src.Entry_GcsFilesetSpec
type Entry_IntegratedSystem = src.Entry_IntegratedSystem
type Entry_RoutineSpec = src.Entry_RoutineSpec
type Entry_Type = src.Entry_Type
type Entry_UserSpecifiedSystem = src.Entry_UserSpecifiedSystem
type Entry_UserSpecifiedType = src.Entry_UserSpecifiedType

// Request message for
// [ExportTaxonomies][google.cloud.datacatalog.v1.PolicyTagManagerSerialization.ExportTaxonomies].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ExportTaxonomiesRequest = src.ExportTaxonomiesRequest
type ExportTaxonomiesRequest_SerializedTaxonomies = src.ExportTaxonomiesRequest_SerializedTaxonomies

// Response message for
// [ExportTaxonomies][google.cloud.datacatalog.v1.PolicyTagManagerSerialization.ExportTaxonomies].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ExportTaxonomiesResponse = src.ExportTaxonomiesResponse
type FieldType = src.FieldType
type FieldType_EnumType = src.FieldType_EnumType
type FieldType_EnumType_ = src.FieldType_EnumType_
type FieldType_EnumType_EnumValue = src.FieldType_EnumType_EnumValue
type FieldType_PrimitiveType = src.FieldType_PrimitiveType
type FieldType_PrimitiveType_ = src.FieldType_PrimitiveType_

// Specification that applies to a fileset. Valid only for entries with the
// 'FILESET' type.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type FilesetSpec = src.FilesetSpec

// Specification of a single file in Cloud Storage.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type GcsFileSpec = src.GcsFileSpec

// Describes a Cloud Storage fileset entry.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type GcsFilesetSpec = src.GcsFilesetSpec

// Request message for
// [GetEntryGroup][google.cloud.datacatalog.v1.DataCatalog.GetEntryGroup].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type GetEntryGroupRequest = src.GetEntryGroupRequest

// Request message for
// [GetEntry][google.cloud.datacatalog.v1.DataCatalog.GetEntry].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type GetEntryRequest = src.GetEntryRequest

// Request message for
// [GetPolicyTag][google.cloud.datacatalog.v1.PolicyTagManager.GetPolicyTag].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type GetPolicyTagRequest = src.GetPolicyTagRequest

// Request message for
// [GetTagTemplate][google.cloud.datacatalog.v1.DataCatalog.GetTagTemplate].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type GetTagTemplateRequest = src.GetTagTemplateRequest

// Request message for
// [GetTaxonomy][google.cloud.datacatalog.v1.PolicyTagManager.GetTaxonomy].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type GetTaxonomyRequest = src.GetTaxonomyRequest

// Request message for
// [ImportTaxonomies][google.cloud.datacatalog.v1.PolicyTagManagerSerialization.ImportTaxonomies].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ImportTaxonomiesRequest = src.ImportTaxonomiesRequest
type ImportTaxonomiesRequest_CrossRegionalSource = src.ImportTaxonomiesRequest_CrossRegionalSource
type ImportTaxonomiesRequest_InlineSource = src.ImportTaxonomiesRequest_InlineSource

// Response message for
// [ImportTaxonomies][google.cloud.datacatalog.v1.PolicyTagManagerSerialization.ImportTaxonomies].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ImportTaxonomiesResponse = src.ImportTaxonomiesResponse

// Inline source containing taxonomies to import.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type InlineSource = src.InlineSource

// This enum lists all the systems that Data Catalog integrates with.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type IntegratedSystem = src.IntegratedSystem

// Request message for
// [ListEntries][google.cloud.datacatalog.v1.DataCatalog.ListEntries].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ListEntriesRequest = src.ListEntriesRequest

// Response message for
// [ListEntries][google.cloud.datacatalog.v1.DataCatalog.ListEntries].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ListEntriesResponse = src.ListEntriesResponse

// Request message for
// [ListEntryGroups][google.cloud.datacatalog.v1.DataCatalog.ListEntryGroups].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ListEntryGroupsRequest = src.ListEntryGroupsRequest

// Response message for
// [ListEntryGroups][google.cloud.datacatalog.v1.DataCatalog.ListEntryGroups].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ListEntryGroupsResponse = src.ListEntryGroupsResponse

// Request message for
// [ListPolicyTags][google.cloud.datacatalog.v1.PolicyTagManager.ListPolicyTags].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ListPolicyTagsRequest = src.ListPolicyTagsRequest

// Response message for
// [ListPolicyTags][google.cloud.datacatalog.v1.PolicyTagManager.ListPolicyTags].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ListPolicyTagsResponse = src.ListPolicyTagsResponse

// Request message for
// [ListTags][google.cloud.datacatalog.v1.DataCatalog.ListTags].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ListTagsRequest = src.ListTagsRequest

// Response message for
// [ListTags][google.cloud.datacatalog.v1.DataCatalog.ListTags].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ListTagsResponse = src.ListTagsResponse

// Request message for
// [ListTaxonomies][google.cloud.datacatalog.v1.PolicyTagManager.ListTaxonomies].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ListTaxonomiesRequest = src.ListTaxonomiesRequest

// Response message for
// [ListTaxonomies][google.cloud.datacatalog.v1.PolicyTagManager.ListTaxonomies].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ListTaxonomiesResponse = src.ListTaxonomiesResponse

// Request message for
// [LookupEntry][google.cloud.datacatalog.v1.DataCatalog.LookupEntry].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type LookupEntryRequest = src.LookupEntryRequest
type LookupEntryRequest_FullyQualifiedName = src.LookupEntryRequest_FullyQualifiedName
type LookupEntryRequest_LinkedResource = src.LookupEntryRequest_LinkedResource
type LookupEntryRequest_SqlResource = src.LookupEntryRequest_SqlResource

// Request message for
// [ModifyEntryContacts][google.cloud.datacatalog.v1.DataCatalog.ModifyEntryContacts].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ModifyEntryContactsRequest = src.ModifyEntryContactsRequest

// Request message for
// [ModifyEntryOverview][google.cloud.datacatalog.v1.DataCatalog.ModifyEntryOverview].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ModifyEntryOverviewRequest = src.ModifyEntryOverviewRequest

// Entry metadata relevant only to the user and private to them.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type PersonalDetails = src.PersonalDetails

// Native schema used by a resource represented as an entry. Used by query
// engines for deserializing and parsing source data.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type PhysicalSchema = src.PhysicalSchema
type PhysicalSchema_Avro = src.PhysicalSchema_Avro

// Schema in Avro JSON format.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type PhysicalSchema_AvroSchema = src.PhysicalSchema_AvroSchema
type PhysicalSchema_Csv = src.PhysicalSchema_Csv

// Marks a CSV-encoded data source.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type PhysicalSchema_CsvSchema = src.PhysicalSchema_CsvSchema
type PhysicalSchema_Orc = src.PhysicalSchema_Orc

// Marks an ORC-encoded data source.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type PhysicalSchema_OrcSchema = src.PhysicalSchema_OrcSchema
type PhysicalSchema_Parquet = src.PhysicalSchema_Parquet

// Marks a Parquet-encoded data source.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type PhysicalSchema_ParquetSchema = src.PhysicalSchema_ParquetSchema
type PhysicalSchema_Protobuf = src.PhysicalSchema_Protobuf

// Schema in protocol buffer format.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type PhysicalSchema_ProtobufSchema = src.PhysicalSchema_ProtobufSchema
type PhysicalSchema_Thrift = src.PhysicalSchema_Thrift

// Schema in Thrift format.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type PhysicalSchema_ThriftSchema = src.PhysicalSchema_ThriftSchema

// Denotes one policy tag in a taxonomy, for example, SSN. Policy tags can be
// defined in a hierarchy. For example: ``` + Geolocation - LatLong - City -
// ZipCode ``` Where the "Geolocation" policy tag contains three children.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type PolicyTag = src.PolicyTag

// PolicyTagManagerClient is the client API for PolicyTagManager service. For
// semantics around ctx use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type PolicyTagManagerClient = src.PolicyTagManagerClient

// PolicyTagManagerSerializationClient is the client API for
// PolicyTagManagerSerialization service. For semantics around ctx use and
// closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type PolicyTagManagerSerializationClient = src.PolicyTagManagerSerializationClient

// PolicyTagManagerSerializationServer is the server API for
// PolicyTagManagerSerialization service.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type PolicyTagManagerSerializationServer = src.PolicyTagManagerSerializationServer

// PolicyTagManagerServer is the server API for PolicyTagManager service.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type PolicyTagManagerServer = src.PolicyTagManagerServer

// Request message for
// [RenameTagTemplateFieldEnumValue][google.cloud.datacatalog.v1.DataCatalog.RenameTagTemplateFieldEnumValue].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type RenameTagTemplateFieldEnumValueRequest = src.RenameTagTemplateFieldEnumValueRequest

// Request message for
// [RenameTagTemplateField][google.cloud.datacatalog.v1.DataCatalog.RenameTagTemplateField].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type RenameTagTemplateFieldRequest = src.RenameTagTemplateFieldRequest

// Request message for
// [ReplaceTaxonomy][google.cloud.datacatalog.v1.PolicyTagManagerSerialization.ReplaceTaxonomy].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ReplaceTaxonomyRequest = src.ReplaceTaxonomyRequest

// Specification that applies to a routine. Valid only for entries with the
// `ROUTINE` type.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type RoutineSpec = src.RoutineSpec

// Input or output argument of a function or stored procedure.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type RoutineSpec_Argument = src.RoutineSpec_Argument

// The input or output mode of the argument.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type RoutineSpec_Argument_Mode = src.RoutineSpec_Argument_Mode
type RoutineSpec_BigqueryRoutineSpec = src.RoutineSpec_BigqueryRoutineSpec

// The fine-grained type of the routine.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type RoutineSpec_RoutineType = src.RoutineSpec_RoutineType

// Represents a schema, for example, a BigQuery, GoogleSQL, or Avro schema.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type Schema = src.Schema

// Request message for
// [SearchCatalog][google.cloud.datacatalog.v1.DataCatalog.SearchCatalog].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type SearchCatalogRequest = src.SearchCatalogRequest

// The criteria that select the subspace used for query matching.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type SearchCatalogRequest_Scope = src.SearchCatalogRequest_Scope

// Response message for
// [SearchCatalog][google.cloud.datacatalog.v1.DataCatalog.SearchCatalog].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type SearchCatalogResponse = src.SearchCatalogResponse

// Result in the response to a search request. Each result captures details of
// one entry that matches the search.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type SearchCatalogResult = src.SearchCatalogResult
type SearchCatalogResult_IntegratedSystem = src.SearchCatalogResult_IntegratedSystem
type SearchCatalogResult_UserSpecifiedSystem = src.SearchCatalogResult_UserSpecifiedSystem

// The resource types that can be returned in search results.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type SearchResultType = src.SearchResultType

// A nested protocol buffer that represents a policy tag and all its
// descendants.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type SerializedPolicyTag = src.SerializedPolicyTag

// A nested protocol buffer that represents a taxonomy and the hierarchy of
// its policy tags. Used for taxonomy replacement, import, and export.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type SerializedTaxonomy = src.SerializedTaxonomy

// Request message for
// [StarEntry][google.cloud.datacatalog.v1.DataCatalog.StarEntry].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type StarEntryRequest = src.StarEntryRequest

// Response message for
// [StarEntry][google.cloud.datacatalog.v1.DataCatalog.StarEntry]. Empty for
// now
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type StarEntryResponse = src.StarEntryResponse

// Details the properties of the underlying storage.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type StorageProperties = src.StorageProperties

// Timestamps associated with this resource in a particular system.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type SystemTimestamps = src.SystemTimestamps

// Table source type.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type TableSourceType = src.TableSourceType

// Normal BigQuery table specification.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type TableSpec = src.TableSpec

// Tags contain custom metadata and are attached to Data Catalog resources.
// Tags conform with the specification of their tag template. See [Data Catalog
// IAM](https://cloud.google.com/data-catalog/docs/concepts/iam) for
// information on the permissions needed to create or view tags.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type Tag = src.Tag

// Contains the value and additional information on a field within a
// [Tag][google.cloud.datacatalog.v1.Tag].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type TagField = src.TagField
type TagField_BoolValue = src.TagField_BoolValue
type TagField_DoubleValue = src.TagField_DoubleValue

// An enum value.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type TagField_EnumValue = src.TagField_EnumValue
type TagField_EnumValue_ = src.TagField_EnumValue_
type TagField_RichtextValue = src.TagField_RichtextValue
type TagField_StringValue = src.TagField_StringValue
type TagField_TimestampValue = src.TagField_TimestampValue

// A tag template defines a tag that can have one or more typed fields. The
// template is used to create tags that are attached to GCP resources. [Tag
// template roles]
// (https://cloud.google.com/iam/docs/understanding-roles#data-catalog-roles)
// provide permissions to create, edit, and use the template. For example, see
// the [TagTemplate User]
// (https://cloud.google.com/data-catalog/docs/how-to/template-user) role that
// includes a permission to use the tag template to tag resources.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type TagTemplate = src.TagTemplate

// The template for an individual field within a tag template.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type TagTemplateField = src.TagTemplateField
type Tag_Column = src.Tag_Column

// A taxonomy is a collection of hierarchical policy tags that classify data
// along a common axis. For example, a "data sensitivity" taxonomy might
// contain the following policy tags: ``` + PII - Account number - Age - SSN -
// Zipcode + Financials - Revenue ``` A "data origin" taxonomy might contain
// the following policy tags: ``` + User data + Employee data + Partner data +
// Public data ```
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type Taxonomy = src.Taxonomy

// Defines policy types where the policy tags can be used for.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type Taxonomy_PolicyType = src.Taxonomy_PolicyType

// UnimplementedDataCatalogServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type UnimplementedDataCatalogServer = src.UnimplementedDataCatalogServer

// UnimplementedPolicyTagManagerSerializationServer can be embedded to have
// forward compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type UnimplementedPolicyTagManagerSerializationServer = src.UnimplementedPolicyTagManagerSerializationServer

// UnimplementedPolicyTagManagerServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type UnimplementedPolicyTagManagerServer = src.UnimplementedPolicyTagManagerServer

// Request message for
// [UnstarEntry][google.cloud.datacatalog.v1.DataCatalog.UnstarEntry].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type UnstarEntryRequest = src.UnstarEntryRequest

// Response message for
// [UnstarEntry][google.cloud.datacatalog.v1.DataCatalog.UnstarEntry]. Empty
// for now
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type UnstarEntryResponse = src.UnstarEntryResponse

// Request message for
// [UpdateEntryGroup][google.cloud.datacatalog.v1.DataCatalog.UpdateEntryGroup].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type UpdateEntryGroupRequest = src.UpdateEntryGroupRequest

// Request message for
// [UpdateEntry][google.cloud.datacatalog.v1.DataCatalog.UpdateEntry].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type UpdateEntryRequest = src.UpdateEntryRequest

// Request message for
// [UpdatePolicyTag][google.cloud.datacatalog.v1.PolicyTagManager.UpdatePolicyTag].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type UpdatePolicyTagRequest = src.UpdatePolicyTagRequest

// Request message for
// [UpdateTag][google.cloud.datacatalog.v1.DataCatalog.UpdateTag].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type UpdateTagRequest = src.UpdateTagRequest

// Request message for
// [UpdateTagTemplateField][google.cloud.datacatalog.v1.DataCatalog.UpdateTagTemplateField].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type UpdateTagTemplateFieldRequest = src.UpdateTagTemplateFieldRequest

// Request message for
// [UpdateTagTemplate][google.cloud.datacatalog.v1.DataCatalog.UpdateTagTemplate].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type UpdateTagTemplateRequest = src.UpdateTagTemplateRequest

// Request message for
// [UpdateTaxonomy][google.cloud.datacatalog.v1.PolicyTagManager.UpdateTaxonomy].
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type UpdateTaxonomyRequest = src.UpdateTaxonomyRequest

// The set of all usage signals that Data Catalog stores. Note: Usually, these
// signals are updated daily. In rare cases, an update may fail but will be
// performed again on the next day.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type UsageSignal = src.UsageSignal

// Detailed statistics on the entry's usage. Usage statistics have the
// following limitations: - Only BigQuery tables have them. - They only include
// BigQuery query jobs. - They might be underestimated because wildcard table
// references are not yet counted. For more information, see [Querying multiple
// tables using a wildcard table]
// (https://cloud.google.com/bigquery/docs/querying-wildcard-tables)
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type UsageStats = src.UsageStats

// Table view specification.
//
// Deprecated: Please use types in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
type ViewSpec = src.ViewSpec

// Deprecated: Please use funcs in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
func NewDataCatalogClient(cc grpc.ClientConnInterface) DataCatalogClient {
	return src.NewDataCatalogClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
func NewPolicyTagManagerClient(cc grpc.ClientConnInterface) PolicyTagManagerClient {
	return src.NewPolicyTagManagerClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
func NewPolicyTagManagerSerializationClient(cc grpc.ClientConnInterface) PolicyTagManagerSerializationClient {
	return src.NewPolicyTagManagerSerializationClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
func RegisterDataCatalogServer(s *grpc.Server, srv DataCatalogServer) {
	src.RegisterDataCatalogServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
func RegisterPolicyTagManagerSerializationServer(s *grpc.Server, srv PolicyTagManagerSerializationServer) {
	src.RegisterPolicyTagManagerSerializationServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/datacatalog/apiv1/datacatalogpb
func RegisterPolicyTagManagerServer(s *grpc.Server, srv PolicyTagManagerServer) {
	src.RegisterPolicyTagManagerServer(s, srv)
}
