package geohash

//	# Test cases generated with https://github.com/hkwi/python-geohash
//	import sys
//	import random
//	import geohash
//
//	trials_bits = int(sys.argv[1])
//	trials = 1 << trials_bits
//
//	base32_alphabet = '0123456789bcdefghjkmnpqrstuvwxyz'
//
//	print 'package geohash'
//	print
//	print ''.join(['//\t' + line for line in open(__file__, 'r')])
//	print 'var decodecases = []DecodeTestCase{'
//
//	for i in range(trials):
//	    n = random.randrange(1, 13)
//	    hash_str = ''.join([random.choice(base32_alphabet) for i in range(n)])
//	    lat, lng, lat_err, lng_err = geohash.decode_exactly(hash_str)
//	    print '\t{"%s", Box{%s, %s, %s, %s}},' % (hash_str,
//	            lat - lat_err, lat + lat_err,
//	            lng - lng_err, lng + lng_err,)
//
//	print '}'

var decodecases = []DecodeTestCase{
	{"91rc", Box{7.20703125, 7.3828125, -124.1015625, -123.75}},
	{"c", Box{45.0, 90.0, -135.0, -90.0}},
	{"0fuz", Box{-73.30078125, -73.125, -139.5703125, -139.21875}},
	{"dwfcndf", Box{38.1596374512, 38.1610107422, -63.3444213867, -63.3430480957}},
	{"2z7", Box{-4.21875, -2.8125, -142.03125, -140.625}},
	{"7spw2w", Box{-21.3684082031, -21.3629150391, -11.9311523438, -11.9201660156}},
	{"eq", Box{33.75, 39.375, -33.75, -22.5}},
	{"mgff0", Box{-23.5546875, -23.5107421875, 82.6171875, 82.6611328125}},
	{"dp7k386jtk0", Box{41.5306591988, 41.5306605399, -85.3607976437, -85.3607963026}},
	{"pjb", Box{-57.65625, -56.25, 135.0, 136.40625}},
	{"jkc7uh9", Box{-62.5973510742, -62.5959777832, 58.184967041, 58.186340332}},
	{"1gdp9", Box{-68.994140625, -68.9501953125, -98.3935546875, -98.349609375}},
	{"z9yj14mmnxte", Box{55.7359149121, 55.7359150797, 165.988941416, 165.988941751}},
	{"2brk", Box{-42.890625, -42.71484375, -136.0546875, -135.703125}},
	{"dhv5t2qh59", Box{27.3360496759, 27.3360550404, -82.7296471596, -82.7296364307}},
	{"v", Box{45.0, 90.0, 45.0, 90.0}},
	{"3fgd9k15b5k", Box{-29.0691630542, -29.0691617131, -96.2718147039, -96.2718133628}},
	{"j", Box{-90.0, -45.0, 45.0, 90.0}},
	{"b4", Box{56.25, 61.875, -180.0, -168.75}},
	{"sb38", Box{1.40625, 1.58203125, 35.859375, 36.2109375}},
	{"puqeug", Box{-65.4180908203, -65.4125976562, 178.099365234, 178.110351562}},
	{"45", Box{-73.125, -67.5, -90.0, -78.75}},
	{"34b", Box{-29.53125, -28.125, -135.0, -133.59375}},
	{"tqb8jzn9dfqn", Box{38.0074727163, 38.0074728839, 57.2148630023, 57.2148633376}},
	{"9x", Box{39.375, 45.0, -112.5, -101.25}},
	{"tybf7", Box{38.3642578125, 38.408203125, 79.9365234375, 79.98046875}},
	{"9nc", Box{37.96875, 39.375, -133.59375, -132.1875}},
	{"pp21", Box{-49.04296875, -48.8671875, 135.0, 135.3515625}},
	{"s6wjfu76v", Box{15.0970602036, 15.0971031189, 19.8130273819, 19.8130702972}},
	{"wxh8ped7", Box{39.3947410583, 39.3949127197, 119.160804749, 119.161148071}},
	{"8gr", Box{18.28125, 19.6875, -136.40625, -135.0}},
	{"ug6hf", Box{64.1162109375, 64.16015625, 36.650390625, 36.6943359375}},
	{"pb", Box{-90.0, -84.375, 168.75, 180.0}},
	{"nmhvpv", Box{-60.9686279297, -60.9631347656, 108.270263672, 108.28125}},
	{"rxgthm", Box{-0.499877929688, -0.494384765625, 162.608642578, 162.619628906}},
	{"mj8t", Box{-13.18359375, -13.0078125, 45.703125, 46.0546875}},
	{"rkvw", Box{-17.2265625, -17.05078125, 153.984375, 154.3359375}},
	{"j", Box{-90.0, -45.0, 45.0, 90.0}},
	{"u4ryw22k", Box{58.8008880615, 58.8010597229, 11.1734390259, 11.1737823486}},
	{"96bf6jfr", Box{15.8970451355, 15.8972167969, -122.60433197, -122.603988647}},
	{"ubhnbn2n1jvj", Box{46.2219173647, 46.2219175324, 39.3750496209, 39.3750499561}},
	{"3gmczz", Box{-26.3726806641, -26.3671875, -92.8234863281, -92.8125}},
	{"yb4jh3u7px0", Box{45.8890718222, 45.8890731633, 126.75542593, 126.755427271}},
	{"9ex7rkbw1duf", Box{20.2859266475, 20.2859268151, -101.985326596, -101.98532626}},
	{"xrkyg3mj", Box{41.9754981995, 41.9756698608, 153.079376221, 153.079719543}},
	{"z4hn2yfzryjq", Box{57.3869894072, 57.3869895749, 140.662075169, 140.662075505}},
	{"x357", Box{6.15234375, 6.328125, 150.8203125, 151.171875}},
	{"v3pew", Box{51.240234375, 51.2841796875, 67.060546875, 67.1044921875}},
	{"j1", Box{-84.375, -78.75, 45.0, 56.25}},
	{"ec1bkph03", Box{5.70744037628, 5.70748329163, -8.60774517059, -8.60770225525}},
	{"q4t85", Box{-30.9375, -30.8935546875, 97.8662109375, 97.91015625}},
	{"k26z8hf", Box{-42.2492980957, -42.2479248047, 15.119934082, 15.121307373}},
	{"p6fyq2u63", Box{-73.4281110764, -73.428068161, 150.397725105, 150.397768021}},
	{"uqu5w2yu", Box{83.5887908936, 83.5889625549, 17.1589279175, 17.1592712402}},
	{"terbkv", Box{18.3526611328, 18.3581542969, 78.6071777344, 78.6181640625}},
	{"8v2nwkp", Box{30.6958007812, 30.6971740723, -145.96572876, -145.964355469}},
	{"rbktxk2enhr", Box{-42.6030693948, -42.6030680537, 175.397682041, 175.397683382}},
	{"r1pnfct8", Box{-38.1802368164, -38.180065155, 144.97215271, 144.972496033}},
	{"rcmxg", Box{-36.6064453125, -36.5625, 176.616210938, 176.66015625}},
	{"jqw7xjdt8", Box{-52.7911090851, -52.7910661697, 65.350112915, 65.3501558304}},
	{"7mt737xd", Box{-13.4716415405, -13.4714698792, -26.3019561768, -26.301612854}},
	{"2dprx5rg57es", Box{-32.4132534117, -32.413253244, -146.986283138, -146.986282803}},
	{"fpr5d98ws0", Box{86.40583992, 86.4058452845, -80.0455284119, -80.045517683}},
	{"z4cmm3", Box{61.3970947266, 61.4025878906, 136.988525391, 136.999511719}},
	{"gz3b8j", Box{85.8966064453, 85.9020996094, -8.7890625, -8.77807617188}},
	{"svfztv42f2k", Box{33.6897052824, 33.6897066236, 37.8730648756, 37.8730662167}},
	{"z6f3yb6rum", Box{60.7790976763, 60.7791030407, 149.713965654, 149.713976383}},
	{"wvqv397", Box{30.4609680176, 30.4623413086, 133.312225342, 133.313598633}},
	{"r0ce65wshm", Box{-40.1900213957, -40.1900160313, 137.206374407, 137.206385136}},
	{"crqvbtfbjb09", Box{86.8235780485, 86.8235782161, -114.23181586, -114.231815524}},
	{"ptz0vc5z87", Box{-57.5176173449, -57.5176119804, 167.601596117, 167.601606846}},
	{"x806byp", Box{0.516357421875, 0.517730712891, 157.894134521, 157.895507812}},
	{"s", Box{0.0, 45.0, 0.0, 45.0}},
	{"kb23vjn10", Box{-43.2584953308, -43.2584524155, 34.3295288086, 34.3295717239}},
	{"n82kv", Box{-87.7587890625, -87.71484375, 113.071289062, 113.115234375}},
	{"dkhzmmqfg", Box{23.8037252426, 23.803768158, -71.830201149, -71.8301582336}},
	{"y1v", Box{54.84375, 56.25, 97.03125, 98.4375}},
	{"q977h9", Box{-37.4359130859, -37.4304199219, 117.268066406, 117.279052734}},
	{"sdffzu5qzu", Box{15.9753012657, 15.9753066301, 26.7125594616, 26.7125701904}},
	{"n3q", Box{-82.96875, -81.5625, 109.6875, 111.09375}},
	{"fr99zgs7e", Box{87.5149440765, 87.5149869919, -76.2940835953, -76.2940406799}},
	{"4d9cv4cbh", Box{-75.6147766113, -75.614733696, -64.8167610168, -64.8167181015}},
	{"np896wq5", Box{-47.557926178, -47.5577545166, 90.8212280273, 90.8215713501}},
	{"45", Box{-73.125, -67.5, -90.0, -78.75}},
	{"c5srsy", Box{66.0388183594, 66.0443115234, -128.814697266, -128.803710938}},
	{"vcshr", Box{54.1845703125, 54.228515625, 84.6826171875, 84.7265625}},
	{"3zbbs1wnn5", Box{-1.30907356739, -1.30906820297, -100.011034012, -100.011023283}},
	{"jtdvxn", Box{-58.0627441406, -58.0572509766, 71.6748046875, 71.6857910156}},
	{"yz27wu0e", Box{86.4189720154, 86.4191436768, 124.398880005, 124.399223328}},
	{"utb0ck65h9", Box{77.4994522333, 77.4994575977, 22.5578713417, 22.5578820705}},
	{"1t1dvq5jj", Box{-61.3577842712, -61.3577413559, -110.15557766, -110.155534744}},
	{"yzwgy5hvwz", Box{87.8641408682, 87.8641462326, 133.512672186, 133.512682915}},
	{"8dx38y6vby", Box{14.3615233898, 14.3615287542, -147.267919779, -147.26790905}},
	{"9bh", Box{0.0, 1.40625, -95.625, -94.21875}},
	{"2", Box{-45.0, 0.0, -180.0, -135.0}},
	{"x14ve", Box{6.591796875, 6.6357421875, 138.999023438, 139.04296875}},
	{"3603v", Box{-33.4423828125, -33.3984375, -123.178710938, -123.134765625}},
	{"bsuje4cn6", Box{72.7017259598, 72.7017688751, -151.741704941, -151.741662025}},
	{"9nnut36epqhn", Box{34.5484302565, 34.5484304242, -125.273349881, -125.273349546}},
	{"7q27jg", Box{-9.29992675781, -9.29443359375, -33.1457519531, -33.134765625}},
	{"933zzd6", Box{8.40591430664, 8.40728759766, -120.956726074, -120.955352783}},
	{"5743y", Box{-72.8173828125, -72.7734375, -30.322265625, -30.2783203125}},
	{"7m94uc9", Box{-13.5708618164, -13.5694885254, -32.1336364746, -32.1322631836}},
	{"780", Box{-45.0, -43.59375, -22.5, -21.09375}},
	{"sqpqx2w0hh", Box{34.8953461647, 34.8953515291, 21.7723274231, 21.7723381519}},
	{"1ep", Box{-73.125, -71.71875, -102.65625, -101.25}},
	{"k0j", Box{-45.0, -43.59375, 7.03125, 8.4375}},
	{"z1zgr0g440", Box{55.4195022583, 55.4195076227, 146.210260391, 146.21027112}},
	{"681bf", Box{-44.8681640625, -44.82421875, -64.951171875, -64.9072265625}},
	{"dn6j", Box{36.03515625, 36.2109375, -87.1875, -86.8359375}},
	{"m", Box{-45.0, 0.0, 45.0, 90.0}},
	{"t1m", Box{7.03125, 8.4375, 52.03125, 53.4375}},
	{"9qkshh67xe3", Box{35.8833391964, 35.8833405375, -117.242680639, -117.242679298}},
	{"4507gyj", Box{-72.4328613281, -72.4314880371, -89.476776123, -89.475402832}},
	{"bb844h", Box{48.1860351562, 48.1915283203, -146.162109375, -146.151123047}},
	{"trn6yz", Box{39.8968505859, 39.90234375, 65.3356933594, 65.3466796875}},
	{"vb99", Box{47.98828125, 48.1640625, 80.859375, 81.2109375}},
	{"dxpbksmed", Box{39.4428920746, 39.4429349899, -56.3961696625, -56.3961267471}},
	{"zc", Box{50.625, 56.25, 168.75, 180.0}},
	{"3webp3s6hdeb", Box{-8.42890352011, -8.42890335247, -106.901924349, -106.901924014}},
	{"8qg", Box{37.96875, 39.375, -164.53125, -163.125}},
	{"fgwzk", Box{65.9619140625, 66.005859375, -46.58203125, -46.5380859375}},
	{"1q2mxvd", Box{-53.8467407227, -53.8453674316, -123.055114746, -123.053741455}},
	{"sd", Box{11.25, 16.875, 22.5, 33.75}},
	{"8hhwv", Box{23.6865234375, 23.73046875, -173.452148438, -173.408203125}},
	{"1bw", Box{-87.1875, -85.78125, -92.8125, -91.40625}},
	{"66zkh0ex724", Box{-28.824133873, -28.8241325319, -68.3739575744, -68.3739562333}},
	{"w6qpy8", Box{14.0185546875, 14.0240478516, 109.973144531, 109.984130859}},
	{"nux13fvfr", Box{-64.4522809982, -64.4522380829, 133.678851128, 133.678894043}},
	{"cj2", Box{74.53125, 75.9375, -135.0, -133.59375}},
	{"1qrumeqp", Box{-54.0776252747, -54.0774536133, -112.601623535, -112.601280212}},
	{"hhm0", Box{-66.09375, -65.91796875, 7.03125, 7.3828125}},
	{"50cp37u6w86", Box{-84.4858060777, -84.4858047366, -43.5327002406, -43.5326988995}},
	{"0vjjfe5w", Box{-60.8467483521, -60.8465766907, -139.1040802, -139.103736877}},
	{"xm67", Box{30.05859375, 30.234375, 149.4140625, 149.765625}},
	{"1jmnqz1", Box{-59.3316650391, -59.330291748, -127.67074585, -127.669372559}},
	{"jjfh69u78", Box{-56.8989658356, -56.8989229202, 47.9281997681, 47.9282426834}},
	{"9xvnjtj3ytr", Box{44.6762318909, 44.676233232, -105.219552666, -105.219551325}},
	{"ebwk44", Box{3.52661132812, 3.53210449219, -2.373046875, -2.36206054688}},
	{"xej0p", Box{16.875, 16.9189453125, 164.838867188, 164.8828125}},
	{"hm4m", Box{-60.99609375, -60.8203125, 14.4140625, 14.765625}},
	{"71d1uhzq", Box{-36.2277603149, -36.2275886536, -42.0017623901, -42.0014190674}},
	{"u7d8cgc9h4w", Box{64.8401203752, 64.8401217163, 14.8447689414, 14.8447702825}},
	{"zwud", Box{83.3203125, 83.49609375, 163.828125, 164.1796875}},
	{"p4nbh7wnwsb", Box{-78.7296326458, -78.7296313047, 144.687473774, 144.687475115}},
	{"ev", Box{28.125, 33.75, -11.25, 0.0}},
	{"2", Box{-45.0, 0.0, -180.0, -135.0}},
	{"ytj8jhg3vmke", Box{73.1514216028, 73.1514217705, 120.458796099, 120.458796434}},
	{"xn", Box{33.75, 39.375, 135.0, 146.25}},
	{"1t7f", Box{-60.1171875, -59.94140625, -107.2265625, -106.875}},
	{"wjt", Box{30.9375, 32.34375, 97.03125, 98.4375}},
	{"f7j3", Box{62.05078125, 62.2265625, -71.3671875, -71.015625}},
	{"62bd4mvcg", Box{-40.3978013992, -40.3977584839, -77.9399728775, -77.9399299622}},
	{"5", Box{-90.0, -45.0, -45.0, 0.0}},
	{"577epg1nh0be", Box{-71.1738922633, -71.1738920957, -28.4860032052, -28.4860028699}},
	{"pvyz2qtjw6kc", Box{-56.3451739959, -56.3451738283, 178.260314874, 178.26031521}},
	{"2hrf6fbj", Box{-20.6822776794, -20.6821060181, -168.980712891, -168.980369568}},
	{"z1yz7p6dc3h8", Box{56.1584669352, 56.1584671028, 144.627516344, 144.627516679}},
	{"24v5r460td50", Box{-28.9475047588, -28.9475045912, -172.658146173, -172.658145837}},
	{"rdtnyvudc4mu", Box{-29.7189060599, -29.7189058922, 164.834111296, 164.834111631}},
	{"s", Box{0.0, 45.0, 0.0, 45.0}},
	{"e7he", Box{17.40234375, 17.578125, -27.421875, -27.0703125}},
	{"9yrkg", Box{35.9912109375, 36.03515625, -90.9228515625, -90.87890625}},
	{"m", Box{-45.0, 0.0, 45.0, 90.0}},
	{"yppvw0", Box{85.341796875, 85.3472900391, 101.162109375, 101.173095703}},
	{"n3876wh", Box{-80.9582519531, -80.9568786621, 101.716918945, 101.718292236}},
	{"m1vjqf4", Box{-34.2224121094, -34.2210388184, 52.3306274414, 52.3320007324}},
	{"kev", Box{-23.90625, -22.5, 29.53125, 30.9375}},
	{"4qc", Box{-52.03125, -50.625, -77.34375, -75.9375}},
	{"5f4", Box{-78.75, -77.34375, -8.4375, -7.03125}},
	{"ug", Box{61.875, 67.5, 33.75, 45.0}},
	{"g5", Box{61.875, 67.5, -45.0, -33.75}},
	{"7wvx", Box{-5.80078125, -5.625, -14.765625, -14.4140625}},
	{"rx", Box{-5.625, 0.0, 157.5, 168.75}},
	{"jdg0t21qzr", Box{-74.4421631098, -74.4421577454, 71.9514906406, 71.9515013695}},
	{"606yg", Box{-42.4072265625, -42.36328125, -86.0009765625, -85.95703125}},
	{"nxt6zwhgqd", Box{-47.2955739498, -47.2955685854, 120.219204426, 120.219215155}},
	{"e71g7w8dr", Box{17.482380867, 17.4824237823, -31.1342668533, -31.134223938}},
	{"n6u", Box{-74.53125, -73.125, 106.875, 108.28125}},
	{"5", Box{-90.0, -45.0, -45.0, 0.0}},
	{"zfcehd0d3", Box{61.0074663162, 61.0075092316, 171.057858467, 171.057901382}},
	{"hgx5efc24r5e", Box{-69.68212137, -69.6821212023, 43.760362789, 43.7603631243}},
	{"x", Box{0.0, 45.0, 135.0, 180.0}},
	{"q", Box{-45.0, 0.0, 90.0, 135.0}},
	{"zbzg87qu07g", Box{49.8525439203, 49.8525452614, 179.668708295, 179.668709636}},
	{"02urcn", Box{-84.3859863281, -84.3804931641, -162.729492188, -162.718505859}},
	{"p4", Box{-78.75, -73.125, 135.0, 146.25}},
	{"j6xjzcpsk78", Box{-74.9205163121, -74.920514971, 66.4448082447, 66.4448095858}},
	{"svchwhvd08d", Box{33.1612041593, 33.1612055004, 35.4274991155, 35.4275004566}},
	{"yughcgqek2", Box{72.5721216202, 72.5721269846, 128.054763079, 128.054773808}},
	{"18tc1b", Box{-87.01171875, -87.0062255859, -104.337158203, -104.326171875}},
	{"es43c", Box{22.8076171875, 22.8515625, -19.2919921875, -19.248046875}},
	{"zdcephk", Box{61.0194396973, 61.0208129883, 159.922485352, 159.923858643}},
	{"2zqh", Box{-3.515625, -3.33984375, -137.8125, -137.4609375}},
	{"sh9bfh31", Box{25.4678535461, 25.4680252075, 2.55020141602, 2.55054473877}},
	{"62vfgv", Box{-40.2703857422, -40.2648925781, -70.4992675781, -70.48828125}},
	{"u2yn4", Box{50.2734375, 50.3173828125, 19.775390625, 19.8193359375}},
	{"qx5wuf", Box{-4.42749023438, -4.42199707031, 117.630615234, 117.641601562}},
	{"9y163", Box{34.1455078125, 34.189453125, -99.4482421875, -99.404296875}},
	{"7ygu094y", Box{-6.32160186768, -6.3214302063, -5.95081329346, -5.9504699707}},
	{"nkfj9vxh9e6", Box{-62.2834508121, -62.283449471, 104.149084389, 104.14908573}},
	{"n220y9m", Box{-88.4550476074, -88.4536743164, 101.542510986, 101.543884277}},
	{"472p7k4d", Box{-70.4220199585, -70.4218482971, -78.6037445068, -78.6034011841}},
	{"7p", Box{-5.625, 0.0, -45.0, -33.75}},
	{"b1r1n2zp", Box{52.2123527527, 52.2125244141, -169.87197876, -169.871635437}},
	{"neu8fxsk8k4", Box{-68.7324213982, -68.7324200571, 118.943838179, 118.94383952}},
	{"m33fn", Box{-37.6171875, -37.5732421875, 58.974609375, 59.0185546875}},
	{"u6z5je", Box{61.0125732422, 61.0180664062, 21.3354492188, 21.3464355469}},
	{"5e6csnf", Box{-71.4179992676, -71.4166259766, -18.454284668, -18.452911377}},
	{"7f7k4", Box{-31.640625, -31.5966796875, -6.591796875, -6.5478515625}},
	{"ykd07ytm4", Box{70.3930091858, 70.3930521011, 104.23459053, 104.234633446}},
	{"ubyx97", Box{50.5535888672, 50.5590820312, 42.9455566406, 42.9565429688}},
	{"r", Box{-45.0, 0.0, 135.0, 180.0}},
	{"ungw16", Box{84.0344238281, 84.0399169922, 4.97680664062, 4.98779296875}},
	{"k", Box{-45.0, 0.0, 0.0, 45.0}},
	{"bhfkepk0n", Box{72.5495910645, 72.5496339798, -176.698350906, -176.698307991}},
	{"d3", Box{5.625, 11.25, -78.75, -67.5}},
	{"wsenn", Box{26.3671875, 26.4111328125, 116.982421875, 117.026367188}},
	{"b4b6qpqk", Box{60.9047698975, 60.9049415588, -179.376182556, -179.375839233}},
	{"zwjx2wv3", Box{80.0616645813, 80.0618362427, 165.263557434, 165.263900757}},
	{"0", Box{-90.0, -45.0, -180.0, -135.0}},
	{"3sgq6", Box{-17.1826171875, -17.138671875, -107.841796875, -107.797851562}},
	{"9chbq", Box{5.6689453125, 5.712890625, -94.306640625, -94.2626953125}},
	{"37nehnbt", Box{-27.5597190857, -27.5595474243, -114.432907104, -114.432563782}},
	{"uhr5w71b", Box{69.5379638672, 69.5381355286, 10.1208114624, 10.1211547852}},
	{"8", Box{0.0, 45.0, -180.0, -135.0}},
	{"81", Box{5.625, 11.25, -180.0, -168.75}},
	{"vyxn", Box{82.6171875, 82.79296875, 88.59375, 88.9453125}},
	{"73jvv", Box{-38.3642578125, -38.3203125, -25.4443359375, -25.400390625}},
	{"nmw1ysg2f23", Box{-58.7286601961, -58.728658855, 109.977705628, 109.977706969}},
	{"5sv6js2nphq", Box{-62.9052887857, -62.9052874446, -14.8751798272, -14.8751784861}},
	{"289", Box{-42.1875, -40.78125, -156.09375, -154.6875}},
	{"cq9", Box{81.5625, 82.96875, -122.34375, -120.9375}},
	{"mm", Box{-16.875, -11.25, 56.25, 67.5}},
	{"49378fm9v", Box{-82.3408555984, -82.3408126831, -65.7014608383, -65.701417923}},
	{"ee079be", Box{17.492980957, 17.494354248, -22.0674133301, -22.0660400391}},
	{"4m5cs3h", Box{-61.6058349609, -61.6044616699, -73.2843017578, -73.2829284668}},
	{"hpdre", Box{-46.494140625, -46.4501953125, 3.2958984375, 3.33984375}},
	{"06", Box{-78.75, -73.125, -168.75, -157.5}},
	{"3x3r4evkpp1q", Box{-2.9669566825, -2.96695651487, -110.624812357, -110.624812022}},
	{"95074fyh23t", Box{17.4181875587, 17.4181888998, -134.51933071, -134.519329369}},
	{"5tdj7sf", Box{-58.1135559082, -58.1121826172, -19.5309448242, -19.5295715332}},
	{"8r9z", Box{43.41796875, 43.59375, -166.2890625, -165.9375}},
	{"nc", Box{-84.375, -78.75, 123.75, 135.0}},
	{"t2mb", Box{1.40625, 1.58203125, 64.3359375, 64.6875}},
	{"hcs1g2vbkq0g", Box{-81.2506873347, -81.250687167, 39.525902085, 39.5259024203}},
	{"pduzpxt", Box{-73.2595825195, -73.2582092285, 164.516143799, 164.51751709}},
	{"mw9u700", Box{-7.6904296875, -7.68905639648, 70.0927734375, 70.0941467285}},
	{"9y0ttsfr", Box{34.7440910339, 34.7442626953, -100.302085876, -100.301742554}},
	{"ztmu17de4", Box{75.2541160583, 75.2541589737, 165.644388199, 165.644431114}},
	{"1dqmehx", Box{-76.3522338867, -76.3508605957, -103.569488525, -103.568115234}},
	{"5", Box{-90.0, -45.0, -45.0, 0.0}},
	{"6ydvkt6cp", Box{-7.48563766479, -7.48559474945, -52.180981636, -52.1809387207}},
	{"4", Box{-90.0, -45.0, -90.0, -45.0}},
	{"706tn", Box{-42.71484375, -42.6708984375, -41.220703125, -41.1767578125}},
	{"6z89j2x0gun", Box{-2.63382196426, -2.63382062316, -55.3063800931, -55.306378752}},
	{"mt1t", Box{-15.99609375, -15.8203125, 69.609375, 69.9609375}},
	{"95ypdkpcd", Box{22.4343395233, 22.4343824387, -126.452894211, -126.452851295}},
	{"nr1wc", Box{-49.4384765625, -49.39453125, 103.403320312, 103.447265625}},
	{"rb2uxf4", Box{-42.7917480469, -42.7903747559, 170.148010254, 170.149383545}},
	{"gzz5w20e1wk", Box{89.2095328867, 89.2095342278, -1.13083541393, -1.13083407283}},
	{"mtuddkh7my", Box{-12.1942341328, -12.1942287683, 73.9330852032, 73.933095932}},
	{"r15def4", Box{-38.9245605469, -38.9231872559, 140.089416504, 140.090789795}},
	{"9fwcy0d", Box{14.3728637695, 14.3742370605, -91.491394043, -91.490020752}},
	{"6vx9z80hkd", Box{-13.7541425228, -13.7541371584, -45.3733420372, -45.3733313084}},
	{"qqxt55re", Box{-7.54022598267, -7.54005432129, 111.93901062, 111.939353943}},
	{"4hreqy", Box{-65.4895019531, -65.4840087891, -79.1564941406, -79.1455078125}},
	{"9nv6", Box{38.3203125, 38.49609375, -127.6171875, -127.265625}},
	{"k980q", Box{-36.5185546875, -36.474609375, 22.763671875, 22.8076171875}},
	{"zd6qmdhsrtce", Box{58.7666300498, 58.7666302174, 160.912265405, 160.91226574}},
	{"ucz57k", Box{55.4370117188, 55.4425048828, 43.7365722656, 43.7475585938}},
	{"u5pq", Box{62.9296875, 63.10546875, 10.1953125, 10.546875}},
	{"fey0v9", Box{66.2310791016, 66.2365722656, -58.8208007812, -58.8098144531}},
	{"mdtggek9fmh5", Box{-30.2601397969, -30.2601396292, 75.7460278273, 75.7460281625}},
	{"y6nfy", Box{56.7333984375, 56.77734375, 111.005859375, 111.049804688}},
	{"f", Box{45.0, 90.0, -90.0, -45.0}},
	{"33hz5xbsw", Box{-38.1011867523, -38.101143837, -116.915559769, -116.915516853}},
	{"2wnb71890np2", Box{-11.1976110935, -11.1976109259, -147.875280194, -147.875279859}},
	{"7d", Box{-33.75, -28.125, -22.5, -11.25}},
	{"71vsdbh", Box{-34.365234375, -34.363861084, -37.1392822266, -37.1379089355}},
	{"nk", Box{-67.5, -61.875, 101.25, 112.5}},
	{"pn6uks", Box{-54.0747070312, -54.0692138672, 139.064941406, 139.075927734}},
	{"t0", Box{0.0, 5.625, 45.0, 56.25}},
	{"ze7c4z3e", Box{63.4973716736, 63.497543335, 162.896347046, 162.896690369}},
	{"ujq6txghfjdv", Box{75.0141208805, 75.0141210482, 9.03497111052, 9.0349714458}},
	{"40muh9sfm7", Box{-87.8819829226, -87.8819775581, -81.7095601559, -81.709549427}},
	{"0y4kk1", Box{-55.4974365234, -55.4919433594, -142.91015625, -142.899169922}},
	{"q8btfscp1g", Box{-39.7431975603, -39.7431921959, 113.314436674, 113.314447403}},
	{"yg2mxt", Box{64.2755126953, 64.2810058594, 124.431152344, 124.442138672}},
	{"7r5kh", Box{-4.921875, -4.8779296875, -29.00390625, -28.9599609375}},
	{"cvg6t", Box{77.783203125, 77.8271484375, -96.4599609375, -96.416015625}},
	{"msj4q7e3db", Box{-22.0850086212, -22.0850032568, 74.8104894161, 74.810500145}},
	{"1452n4", Box{-78.7390136719, -78.7335205078, -130.166015625, -130.155029297}},
	{"xj3kvwr2d", Box{30.4006290436, 30.4006719589, 137.009553909, 137.009596825}},
	{"2wtvb", Box{-7.4267578125, -7.3828125, -149.4140625, -149.370117188}},
	{"c5x5dhk", Box{65.3260803223, 65.3274536133, -125.062866211, -125.06149292}},
	{"eph56u6", Box{39.9696350098, 39.9710083008, -39.2514038086, -39.2500305176}},
	{"5dhyg0hckf", Box{-77.5632512569, -77.5632458925, -15.6817495823, -15.6817388535}},
	{"9vrb", Box{29.53125, 29.70703125, -90.3515625, -90.0}},
	{"b7nsys", Box{62.7319335938, 62.7374267578, -159.323730469, -159.312744141}},
	{"kmenbsk0", Box{-12.8526306152, -12.8524589539, 15.4962158203, 15.4965591431}},
	{"j35", Box{-84.375, -82.96875, 60.46875, 61.875}},
	{"e7sx", Box{20.91796875, 21.09375, -27.421875, -27.0703125}},
	{"h87mpg", Box{-87.6983642578, -87.6928710938, 27.4108886719, 27.421875}},
	{"qjbtp", Box{-11.77734375, -11.7333984375, 91.0107421875, 91.0546875}},
	{"4zqs2pndx", Box{-48.4327983856, -48.4327554703, -47.100148201, -47.1001052856}},
	{"1fsc5v3", Box{-75.7328796387, -75.7315063477, -94.4041442871, -94.4027709961}},
	{"kp6hptx", Box{-3.48541259766, -3.48403930664, 3.15170288086, 3.15307617188}},
	{"3n77", Box{-9.31640625, -9.140625, -130.4296875, -130.078125}},
	{"q347uc", Box{-38.7103271484, -38.7048339844, 104.622802734, 104.633789062}},
	{"n8gckvg3", Box{-85.5297660828, -85.5295944214, 117.98664093, 117.986984253}},
	{"p7szbr6ceq", Box{-68.9100801945, -68.9100748301, 152.944589853, 152.944600582}},
	{"8w7n", Box{36.2109375, 36.38671875, -153.28125, -152.9296875}},
	{"k4s3ndj8", Box{-30.7507324219, -30.7505607605, 6.26976013184, 6.27010345459}},
	{"fh38ev", Box{69.0216064453, 69.0270996094, -87.7258300781, -87.71484375}},
	{"rzebrsw", Box{-2.74383544922, -2.7424621582, 174.36126709, 174.362640381}},
	{"un", Box{78.75, 84.375, 0.0, 11.25}},
	{"27u3d4ybbkt", Box{-23.6273190379, -23.6273176968, -162.676259726, -162.676258385}},
	{"5hk2", Box{-66.09375, -65.91796875, -39.0234375, -38.671875}},
	{"62f6wqsbfc6n", Box{-40.3059548512, -40.3059546836, -75.3046354651, -75.3046351299}},
	{"r6jvqxczv", Box{-32.7832460403, -32.783203125, 154.624199867, 154.624242783}},
	{"wyg1es5yx", Box{38.2555103302, 38.2555532455, 128.128008842, 128.128051758}},
	{"smp9qbcpnt", Box{28.3500748873, 28.3500802517, 22.0951581001, 22.095168829}},
	{"4q46h", Box{-55.8984375, -55.8544921875, -75.41015625, -75.3662109375}},
	{"9u6v9g2ebcm5", Box{24.8915505968, 24.8915507644, -97.3051826656, -97.3051823303}},
	{"25mwbs3", Box{-25.5088806152, -25.5075073242, -172.242279053, -172.240905762}},
	{"kwf", Box{-7.03125, -5.625, 25.3125, 26.71875}},
	{"ekqgkknev", Box{24.5001554489, 24.5001983643, -24.0619039536, -24.0618610382}},
	{"y9974617cb12", Box{53.9764738083, 53.9764739759, 114.358482845, 114.35848318}},
	{"htuu1sxcpd", Box{-56.9282233715, -56.9282180071, 29.2565703392, 29.256581068}},
	{"150sv8q", Box{-72.2886657715, -72.2872924805, -134.046936035, -134.045562744}},
	{"j36p6wnmqm", Box{-81.6604489088, -81.6604435444, 59.181214571, 59.1812252998}},
	{"py", Box{-56.25, -50.625, 168.75, 180.0}},
	{"8", Box{0.0, 45.0, -180.0, -135.0}},
	{"y87", Box{46.40625, 47.8125, 116.71875, 118.125}},
	{"6v90bwn999", Box{-13.8974422216, -13.8974368572, -54.8127865791, -54.8127758503}},
	{"8kyq", Box{27.7734375, 27.94921875, -159.9609375, -159.609375}},
	{"8cht765b92zg", Box{6.55892824754, 6.55892841518, -139.773838855, -139.77383852}},
	{"nu5jwk23v7f", Box{-66.5095366538, -66.5095353127, 128.243979514, 128.243980855}},
	{"0m10969", Box{-61.7733764648, -61.7720031738, -167.287445068, -167.286071777}},
	{"s29h49frdp", Box{3.52656304836, 3.52656841278, 12.7692890167, 12.7692997456}},
	{"6", Box{-45.0, 0.0, -90.0, -45.0}},
	{"brmmeg2z8r", Box{86.7672246695, 86.7672300339, -161.201351881, -161.201341152}},
	{"r3bngg619d", Box{-33.9516055584, -33.951600194, 146.417605877, 146.417616606}},
	{"rmz76wced8c", Box{-12.0472772419, -12.0472759008, 156.557344347, 156.557345688}},
	{"z", Box{45.0, 90.0, 135.0, 180.0}},
	{"2h", Box{-22.5, -16.875, -180.0, -168.75}},
	{"ty2764x", Box{35.7412719727, 35.7426452637, 79.1990661621, 79.2004394531}},
	{"5yh3330r", Box{-56.0235786438, -56.0234069824, -5.21816253662, -5.21781921387}},
	{"9szz", Box{27.94921875, 28.125, -101.6015625, -101.25}},
	{"x7d41b", Box{20.0390625, 20.0445556641, 149.139404297, 149.150390625}},
	{"dw", Box{33.75, 39.375, -67.5, -56.25}},
	{"gnd4cw", Box{82.0788574219, 82.0843505859, -42.1215820312, -42.1105957031}},
	{"k9bxc2n8", Box{-33.7939453125, -33.7937736511, 23.2669830322, 23.267326355}},
	{"hump4nk", Box{-64.8289489746, -64.8275756836, 40.8746337891, 40.8760070801}},
	{"gkz", Box{71.71875, 73.125, -23.90625, -22.5}},
	{"g9e08yt", Box{53.5610961914, 53.5624694824, -18.2414245605, -18.2400512695}},
	{"3eyuyzpm", Box{-23.0319786072, -23.0318069458, -102.701225281, -102.700881958}},
	{"utpuc59p4m", Box{73.9804154634, 73.9804208279, 33.443852663, 33.4438633919}},
	{"cnqt", Box{81.03515625, 81.2109375, -125.859375, -125.5078125}},
	{"z05xfy72gk0", Box{46.3967871666, 46.3967885077, 140.04732728, 140.047328621}},
	{"skr4zd", Box{24.4006347656, 24.4061279297, 21.4233398438, 21.4343261719}},
	{"h2fe8mdnq", Box{-85.1347303391, -85.1346874237, 14.7796154022, 14.7796583176}},
	{"z18b", Box{53.4375, 53.61328125, 136.0546875, 136.40625}},
	{"6", Box{-45.0, 0.0, -90.0, -45.0}},
	{"vh", Box{67.5, 73.125, 45.0, 56.25}},
	{"v64zfspngxw", Box{57.6354762912, 57.6354776323, 60.2368220687, 60.2368234098}},
	{"w", Box{0.0, 45.0, 90.0, 135.0}},
	{"d800", Box{0.0, 0.17578125, -67.5, -67.1484375}},
	{"s", Box{0.0, 45.0, 0.0, 45.0}},
	{"bnugeje1", Box{83.6143684387, 83.6145401001, -173.184356689, -173.184013367}},
	{"46", Box{-78.75, -73.125, -78.75, -67.5}},
	{"8rsncsbz2mx4", Box{43.4013903514, 43.401390519, -163.058031946, -163.058031611}},
	{"t4w9wh7f98je", Box{14.3499474786, 14.3499476463, 54.4095184654, 54.4095188007}},
	{"nsr1tp2", Box{-65.7902526855, -65.7888793945, 122.563476562, 122.564849854}},
	{"9me", Box{30.9375, 32.34375, -119.53125, -118.125}},
	{"t8250bh2y", Box{1.93372249603, 1.93376541138, 67.5390529633, 67.5390958786}},
	{"1", Box{-90.0, -45.0, -135.0, -90.0}},
	{"uqty0nmvvj0c", Box{82.652533818, 82.6525339857, 19.3440495059, 19.3440498412}},
	{"7nkxt", Box{-8.525390625, -8.4814453125, -38.4521484375, -38.408203125}},
	{"jzev", Box{-46.93359375, -46.7578125, 84.0234375, 84.375}},
	{"dmtj1fktxe", Box{31.8297261, 31.8297314644, -71.6353440285, -71.6353332996}},
	{"0r", Box{-50.625, -45.0, -168.75, -157.5}},
	{"5hqv273y", Box{-65.152015686, -65.1518440247, -35.4944229126, -35.4940795898}},
	{"78k", Box{-43.59375, -42.1875, -16.875, -15.46875}},
	{"f2krt5", Box{47.7410888672, 47.7465820312, -72.5537109375, -72.5427246094}},
	{"ffw63hhzm2u", Box{59.481229037, 59.4812303782, -47.4102383852, -47.4102370441}},
	{"mv3z5k", Box{-14.2163085938, -14.2108154297, 81.3537597656, 81.3647460938}},
	{"f15", Box{50.625, 52.03125, -85.78125, -84.375}},
	{"j710re25dhzs", Box{-73.0625749379, -73.0625747703, 57.9859357327, 57.985936068}},
	{"rtt328k93", Box{-13.8411855698, -13.8411426544, 164.911007881, 164.911050797}},
	{"d2x003t048", Box{2.82073974609, 2.82074511051, -68.8882899284, -68.8882791996}},
	{"22uy0", Box{-39.7265625, -39.6826171875, -162.0703125, -162.026367188}},
	{"tuzxx", Box{28.037109375, 28.0810546875, 89.6044921875, 89.6484375}},
	{"su44fdqr2pv1", Box{22.9970443435, 22.9970445111, 36.6809530556, 36.6809533909}},
	{"yttq", Box{76.9921875, 77.16796875, 119.8828125, 120.234375}},
	{"9fu5vyr", Box{16.1622619629, 16.1636352539, -95.362701416, -95.361328125}},
	{"zwmzk37wsh97", Box{81.4386709593, 81.438671127, 165.777684934, 165.77768527}},
	{"hd777ygzewj", Box{-76.7340624332, -76.7340610921, 27.2404141724, 27.2404155135}},
	{"0b1", Box{-90.0, -88.59375, -144.84375, -143.4375}},
	{"ejmgd", Box{30.146484375, 30.1904296875, -36.826171875, -36.7822265625}},
	{"rzxh6", Box{-2.0654296875, -2.021484375, 178.681640625, 178.725585938}},
	{"0rf4f4u", Box{-45.9077453613, -45.9063720703, -165.844116211, -165.84274292}},
	{"1m23ggbv8", Box{-60.1395893097, -60.1395463943, -123.23261261, -123.232569695}},
	{"gdvt2y6wfv", Box{61.4271193743, 61.4271247387, -14.7291147709, -14.7291040421}},
	{"wxb3eqeug0y0", Box{43.8939468563, 43.8939470239, 112.9996714, 112.999671735}},
	{"516kngbm6", Box{-82.2441244125, -82.2440814972, -41.5388774872, -41.5388345718}},
	{"xtuwe2zu", Box{33.4911346436, 33.4913063049, 163.981590271, 163.981933594}},
	{"dhb1c2jrz6c1", Box{27.027712483, 27.0277126506, -89.9375461042, -89.9375457689}},
	{"23c397n4v8g", Box{-34.8756225407, -34.8756211996, -166.928776056, -166.928774714}},
	{"1w81bnmc3", Box{-53.0953359604, -53.095293045, -112.492060661, -112.492017746}},
	{"03hu77r", Box{-83.6100769043, -83.6087036133, -161.917877197, -161.916503906}},
	{"z2vrm", Box{50.4931640625, 50.537109375, 153.852539062, 153.896484375}},
	{"q630e", Box{-32.255859375, -32.2119140625, 102.788085938, 102.83203125}},
	{"h9uzt", Box{-78.837890625, -78.7939453125, 29.3994140625, 29.443359375}},
	{"x09c9jz", Box{3.10775756836, 3.10913085938, 137.51449585, 137.515869141}},
	{"8", Box{0.0, 45.0, -180.0, -135.0}},
	{"xv9ee3gq2j", Box{31.5634471178, 31.5634524822, 171.006660461, 171.00667119}},
	{"6e8xjp4", Box{-24.0435791016, -24.0422058105, -66.5744018555, -66.5730285645}},
	{"0m8sj439bys", Box{-58.3466801047, -58.3466787636, -167.82505095, -167.825049609}},
	{"khf7yq8js6", Box{-17.5854098797, -17.5854045153, 3.43890309334, 3.43891382217}},
	{"hh", Box{-67.5, -61.875, 0.0, 11.25}},
	{"kcyx9b0rd65e", Box{-33.8365919329, -33.8365917653, 42.967973873, 42.9679742083}},
	{"qcy4pees", Box{-34.7847747803, -34.7846031189, 132.521896362, 132.522239685}},
	{"tc6", Box{7.03125, 8.4375, 81.5625, 82.96875}},
	{"mxhnk2fkh", Box{-4.52156066895, -4.5215177536, 73.3150291443, 73.3150720596}},
	{"1mggmg5x0k", Box{-57.067258358, -57.0672529936, -118.219059706, -118.219048977}},
	{"f1udt102z", Box{55.2888250351, 55.2888679504, -83.4515047073, -83.451461792}},
	{"jjz", Box{-57.65625, -56.25, 54.84375, 56.25}},
	{"1q1dg8peze2", Box{-55.765940398, -55.7659390569, -121.476194859, -121.476193517}},
	{"604unch", Box{-44.2913818359, -44.2900085449, -85.8306884766, -85.8293151855}},
	{"kt", Box{-16.875, -11.25, 22.5, 33.75}},
	{"wpbgc", Box{44.2529296875, 44.296875, 91.0986328125, 91.142578125}},
	{"c", Box{45.0, 90.0, -135.0, -90.0}},
	{"5", Box{-90.0, -45.0, -45.0, 0.0}},
	{"tz2pky3c", Box{42.0901679993, 42.0903396606, 78.9611434937, 78.9614868164}},
	{"j96v3y", Box{-82.0129394531, -82.0074462891, 71.4440917969, 71.455078125}},
	{"vs974dv", Box{70.8549499512, 70.8563232422, 69.3745422363, 69.3759155273}},
	{"dunwchdt7d6", Box{23.712155968, 23.7121573091, -47.061843574, -47.0618422329}},
	{"h2u2nkksw", Box{-85.7571315765, -85.7570886612, 17.5076580048, 17.5077009201}},
	{"z8qtu1", Box{47.4224853516, 47.4279785156, 166.81640625, 166.827392578}},
	{"2677dsdngh", Box{-31.7026162148, -31.7026108503, -164.066948891, -164.066938162}},
	{"4yy", Box{-52.03125, -50.625, -47.8125, -46.40625}},
	{"uym", Box{80.15625, 81.5625, 40.78125, 42.1875}},
	{"m2mssd", Box{-42.7917480469, -42.7862548828, 64.1821289062, 64.1931152344}},
	{"xed3b", Box{19.9951171875, 20.0390625, 160.6640625, 160.708007812}},
	{"rfp4ky", Box{-33.3215332031, -33.3160400391, 178.802490234, 178.813476562}},
	{"83fmm9e", Box{10.7748413086, 10.7762145996, -165.340118408, -165.338745117}},
	{"tr7z2dqh", Box{42.0687103271, 42.0688819885, 61.5536499023, 61.5539932251}},
	{"crsh", Box{87.890625, 88.06640625, -118.125, -117.7734375}},
	{"f", Box{45.0, 90.0, -90.0, -45.0}},
	{"761m6h", Box{-32.8051757812, -32.7996826172, -31.904296875, -31.8933105469}},
	{"7p", Box{-5.625, 0.0, -45.0, -33.75}},
	{"8qu9r5", Box{38.2049560547, 38.2104492188, -162.114257812, -162.103271484}},
	{"5z", Box{-50.625, -45.0, -11.25, 0.0}},
	{"kbz", Box{-40.78125, -39.375, 43.59375, 45.0}},
	{"zdftsw1rbpsf", Box{61.4698768035, 61.4698769711, 161.21510189, 161.215102226}},
	{"n1m105r", Box{-82.7751159668, -82.7737426758, 97.0408630371, 97.0422363281}},
	{"xf4kktnxsz", Box{12.0258611441, 12.0258665085, 172.120946646, 172.120957375}},
	{"kzqyq4m0qtyu", Box{-3.10768313706, -3.10768296942, 43.5130138323, 43.5130141675}},
	{"1j1vy57w7", Box{-60.8453321457, -60.8452892303, -132.27045536, -132.270412445}},
	{"nq4u3", Box{-55.5029296875, -55.458984375, 105.161132812, 105.205078125}},
	{"bhcy", Box{72.7734375, 72.94921875, -177.5390625, -177.1875}},
	{"vjr", Box{74.53125, 75.9375, 54.84375, 56.25}},
	{"uc99nrdsntv", Box{53.6551974714, 53.6551988125, 36.1377520859, 36.137753427}},
	{"3e8zmnz", Box{-24.0010070801, -23.9996337891, -111.2159729, -111.214599609}},
	{"j0yzdvs9", Box{-84.4325065613, -84.4323348999, 54.6192169189, 54.6195602417}},
	{"8chvm4", Box{6.55883789062, 6.56433105469, -139.350585938, -139.339599609}},
	{"ywf6099wx", Box{83.329668045, 83.3297109604, 115.6883955, 115.688438416}},
	{"b", Box{45.0, 90.0, -180.0, -135.0}},
	{"zrc", Box{88.59375, 90.0, 147.65625, 149.0625}},
	{"zq", Box{78.75, 84.375, 146.25, 157.5}},
	{"7xznu50ru", Box{-0.201916694641, -0.201873779297, -12.4799537659, -12.4799108505}},
	{"u", Box{45.0, 90.0, 0.0, 45.0}},
	{"7r", Box{-5.625, 0.0, -33.75, -22.5}},
	{"f27k", Box{47.109375, 47.28515625, -74.1796875, -73.828125}},
	{"0", Box{-90.0, -45.0, -180.0, -135.0}},
	{"b4s13188yv", Box{59.2906218767, 59.2906272411, -174.330078363, -174.330067635}},
	{"q8", Box{-45.0, -39.375, 112.5, 123.75}},
	{"skn7w", Box{23.115234375, 23.1591796875, 20.302734375, 20.3466796875}},
	{"1tzqwzyh5vp", Box{-56.4703863859, -56.4703850448, -101.999646574, -101.999645233}},
	{"r52cmn", Box{-26.4660644531, -26.4605712891, 136.274414062, 136.285400391}},
	{"7bwvbbbru", Box{-41.1713075638, -41.1712646484, -1.72433853149, -1.72429561615}},
	{"ruv0b1n", Box{-18.1439208984, -18.1425476074, 175.789489746, 175.790863037}},
	{"vwf01ujm", Box{82.9915809631, 82.9917526245, 70.3966140747, 70.3969573975}},
	{"0metgxjtrm91", Box{-58.0123747699, -58.0123746023, -163.666450828, -163.666450493}},
	{"2w", Box{-11.25, -5.625, -157.5, -146.25}},
	{"8kmch3", Box{24.0875244141, 24.0930175781, -160.477294922, -160.466308594}},
	{"g6m", Box{57.65625, 59.0625, -26.71875, -25.3125}},
	{"t6v4k2", Box{15.8642578125, 15.8697509766, 63.4680175781, 63.4790039062}},
	{"zr02vfju8hd", Box{84.5186188817, 84.5186202228, 146.862147152, 146.862148494}},
	{"kb8jn751", Box{-41.2919425964, -41.2917709351, 34.0287780762, 34.0291213989}},
	{"mj76", Box{-15.1171875, -14.94140625, 49.5703125, 49.921875}},
	{"f0hwcbkwjnr", Box{46.1889602244, 46.1889615655, -83.5885669291, -83.588565588}},
	{"5", Box{-90.0, -45.0, -45.0, 0.0}},
	{"6rt9btpxj2p1", Box{-2.47621519491, -2.47621502727, -70.9831179678, -70.9831176326}},
	{"wh0s6yb6j", Box{23.2844924927, 23.284535408, 90.8245325089, 90.8245754242}},
	{"65b", Box{-23.90625, -22.5, -90.0, -88.59375}},
	{"r", Box{-45.0, 0.0, 135.0, 180.0}},
	{"z0tpc5d", Box{49.1940307617, 49.1954040527, 142.077941895, 142.079315186}},
	{"fgs2w0", Box{64.775390625, 64.7808837891, -50.009765625, -49.9987792969}},
	{"vfus35qgp", Box{61.2341880798, 61.2342309952, 85.1316404343, 85.1316833496}},
	{"hywnkqdye", Box{-52.3020458221, -52.3020029068, 42.3781728745, 42.3782157898}},
	{"qpwxwun0b", Box{-1.47203922272, -1.47199630737, 99.4454956055, 99.4455385208}},
	{"v88u9rqr24", Box{48.6445963383, 48.6446017027, 68.6182022095, 68.6182129383}},
	{"17x06x4fyw", Box{-70.2295982838, -70.2295929193, -113.792331219, -113.79232049}},
	{"3ykkhjyhrt", Box{-9.1082829237, -9.10827755928, -95.0890946388, -95.08908391}},
	{"mbzkuqw5", Box{-39.910068512, -39.9098968506, 89.1403198242, 89.140663147}},
	{"yqjf0p3mn", Box{79.1422462463, 79.1422891617, 109.337911606, 109.337954521}},
	{"2f", Box{-33.75, -28.125, -146.25, -135.0}},
	{"hqsm3", Box{-52.5146484375, -52.470703125, 17.2705078125, 17.314453125}},
	{"gp1y4wtft1tp", Box{85.4658314399, 85.4658316076, -42.4210815132, -42.4210811779}},
	{"k", Box{-45.0, 0.0, 0.0, 45.0}},
	{"kxxruvh", Box{-1.42272949219, -1.42135620117, 32.9095458984, 32.9109191895}},
	{"08h0ft4vk97r", Box{-89.839789141, -89.8397889733, -151.761162691, -151.761162356}},
	{"y9u8", Box{54.84375, 55.01953125, 118.828125, 119.1796875}},
	{"3zhsk", Box{-4.8779296875, -4.833984375, -94.74609375, -94.7021484375}},
	{"x2", Box{0.0, 5.625, 146.25, 157.5}},
	{"mr7nnvr", Box{-3.13522338867, -3.13385009766, 60.7749938965, 60.7763671875}},
	{"d3g0pn54hr", Box{9.87708985806, 9.87709522247, -74.2193305492, -74.2193198204}},
	{"jv173u", Box{-61.2817382812, -61.2762451172, 80.5847167969, 80.595703125}},
	{"vte", Box{75.9375, 77.34375, 71.71875, 73.125}},
	{"303un61j2s", Box{-42.878715992, -42.8787106276, -132.263009548, -132.262998819}},
	{"m528h", Box{-26.71875, -26.6748046875, 45.87890625, 45.9228515625}},
	{"8", Box{0.0, 45.0, -180.0, -135.0}},
	{"p8h", Box{-90.0, -88.59375, 163.125, 164.53125}},
	{"tzusgm6v33y", Box{44.4584606588, 44.4584619999, 85.2247855067, 85.2247868478}},
	{"26sre", Box{-29.619140625, -29.5751953125, -162.641601562, -162.59765625}},
	{"q1tcnkmh55b", Box{-36.3626660407, -36.3626646996, 98.3675909042, 98.3675922453}},
	{"xs4t1g3", Box{23.3967590332, 23.3981323242, 161.093902588, 161.095275879}},
	{"td", Box{11.25, 16.875, 67.5, 78.75}},
	{"xdvwxsmsjd", Box{16.6353714466, 16.635376811, 165.571753979, 165.571764708}},
	{"dnw", Box{36.5625, 37.96875, -81.5625, -80.15625}},
	{"u7nu2ff43vx", Box{62.6375922561, 62.6375935972, 20.777977556, 20.7779788971}},
	{"0jy2", Box{-57.65625, -57.48046875, -171.2109375, -170.859375}},
	{"u", Box{45.0, 90.0, 0.0, 45.0}},
	{"2yx2k", Box{-8.3935546875, -8.349609375, -135.87890625, -135.834960938}},
	{"g3", Box{50.625, 56.25, -33.75, -22.5}},
	{"6", Box{-45.0, 0.0, -90.0, -45.0}},
	{"vrrpw34jfjs", Box{87.1061190963, 87.1061204374, 66.3712459803, 66.3712473214}},
	{"g2gkzeutg", Box{50.0752973557, 50.075340271, -28.8437891006, -28.8437461853}},
	{"z8ett4zh", Box{48.7950897217, 48.7952613831, 162.6512146, 162.651557922}},
	{"cyspv2k0", Box{82.9261779785, 82.9263496399, -95.3887939453, -95.3884506226}},
	{"fqu7qbshmr", Box{83.5435527563, 83.5435581207, -72.471088171, -72.4710774422}},
	{"578u4ww7", Box{-69.5731544495, -69.5729827881, -32.5768661499, -32.5765228271}},
	{"4gzkwxrzb", Box{-68.0740785599, -68.0740356445, -45.7583999634, -45.758357048}},
	{"g0z038npm1ym", Box{49.2639500834, 49.263950251, -35.0818693265, -35.0818689913}},
	{"vrse4ey62b1y", Box{87.7358303592, 87.7358305268, 62.6966058835, 62.6966062188}},
	{"7x2fkbbj6", Box{-3.81822109222, -3.81817817688, -21.2364864349, -21.2364435196}},
	{"tuvfdxy7b", Box{27.2014188766, 27.201461792, 86.9543838501, 86.9544267654}},
	{"9qzggb", Box{38.6279296875, 38.6334228516, -112.686767578, -112.67578125}},
	{"pupf6", Box{-67.1044921875, -67.060546875, 179.736328125, 179.780273438}},
	{"fknyrbe41k0w", Box{68.6017451808, 68.6017453484, -68.9130621403, -68.9130618051}},
	{"591vk5jz7x4v", Box{-83.4343860112, -83.4343858436, -19.8552309349, -19.8552305996}},
	{"n4psdv", Box{-77.9315185547, -77.9260253906, 100.667724609, 100.678710938}},
	{"zyw2", Box{81.5625, 81.73828125, 177.5390625, 177.890625}},
	{"r0e29", Box{-42.099609375, -42.0556640625, 139.614257812, 139.658203125}},
	{"j9cq7f", Box{-79.0466308594, -79.0411376953, 69.4226074219, 69.43359375}},
	{"n", Box{-90.0, -45.0, 90.0, 135.0}},
	{"m42x20h", Box{-31.0693359375, -31.0679626465, 45.7086181641, 45.7099914551}},
	{"405zg3kz2j", Box{-88.6295574903, -88.6295521259, -84.5772171021, -84.5772063732}},
	{"7vu7httsdm", Box{-12.0978945494, -12.097889185, -5.06803393364, -5.0680232048}},
	{"prznz91", Box{-45.2142333984, -45.2128601074, 156.424713135, 156.426086426}},
	{"46dupvqwbsuj", Box{-75.2043508552, -75.2043506876, -74.5332831144, -74.5332827792}},
	{"7s0", Box{-22.5, -21.09375, -22.5, -21.09375}},
	{"5nhz5er2nnm5", Box{-55.0016444363, -55.0016442686, -38.1562833488, -38.1562830135}},
	{"5qqp", Box{-53.61328125, -53.4375, -25.3125, -24.9609375}},
	{"t4dqn2", Box{15.1171875, 15.1226806641, 48.4387207031, 48.4497070312}},
	{"gmxt", Box{76.81640625, 76.9921875, -23.203125, -22.8515625}},
	{"syuh0ke1syh", Box{38.6968839169, 38.696885258, 39.3903154135, 39.3903167546}},
	{"nvr0", Box{-60.46875, -60.29296875, 133.59375, 133.9453125}},
	{"g4", Box{56.25, 61.875, -45.0, -33.75}},
	{"gnd2kb6w0s32", Box{81.6088713706, 81.6088715382, -41.623740904, -41.6237405688}},
	{"x7hptvsgdvu", Box{18.2242034376, 18.2242047787, 152.134332061, 152.134333402}},
	{"2fc8", Box{-29.53125, -29.35546875, -144.140625, -143.7890625}},
	{"e3fsu48yte7", Box{10.693577081, 10.6935784221, -30.057323724, -30.0573223829}},
	{"pbqhjvqh", Box{-87.8610992432, -87.8609275818, 177.448425293, 177.448768616}},
	{"sqx1nwgn", Box{36.7763900757, 36.7765617371, 21.3835144043, 21.3838577271}},
	{"e6g", Box{15.46875, 16.875, -29.53125, -28.125}},
	{"dt", Box{28.125, 33.75, -67.5, -56.25}},
	{"02s64yzk", Box{-86.7981719971, -86.7980003357, -162.642631531, -162.642288208}},
	{"z9", Box{50.625, 56.25, 157.5, 168.75}},
	{"fjv", Box{77.34375, 78.75, -82.96875, -81.5625}},
	{"5yc0", Box{-52.03125, -51.85546875, -9.84375, -9.4921875}},
	{"y", Box{45.0, 90.0, 90.0, 135.0}},
	{"k3x3j1pmdnfp", Box{-36.3802440651, -36.3802438974, 21.6750839353, 21.6750842705}},
	{"g2pjds", Box{45.9887695312, 45.9942626953, -23.7963867188, -23.7854003906}},
	{"ppw0p3q2gzbk", Box{-47.8054625541, -47.8054623865, 143.764847852, 143.764848188}},
	{"9xwp0kprs0x6", Box{43.4412318841, 43.4412320517, -104.041375928, -104.041375592}},
	{"0gzww7fv7gj", Box{-67.7421551943, -67.7421538532, -135.424522609, -135.424521267}},
	{"sgpt2", Box{17.7978515625, 17.841796875, 44.296875, 44.3408203125}},
	{"3", Box{-45.0, 0.0, -135.0, -90.0}},
	{"rr", Box{-5.625, 0.0, 146.25, 157.5}},
	{"wkqrtvj5", Box{25.2525901794, 25.2527618408, 110.298614502, 110.298957825}},
	{"ngtfyx77u", Box{-69.7886323929, -69.7885894775, 132.126216888, 132.126259804}},
	{"m", Box{-45.0, 0.0, 45.0, 90.0}},
	{"58y", Box{-85.78125, -84.375, -14.0625, -12.65625}},
	{"mvjrxvx", Box{-15.5264282227, -15.5250549316, 86.483001709, 86.484375}},
	{"jgve4ttu", Box{-68.3480072021, -68.3478355408, 86.6021347046, 86.6024780273}},
	{"h9", Box{-84.375, -78.75, 22.5, 33.75}},
	{"ytf9sb6mj27", Box{77.609654814, 77.6096561551, 116.227684468, 116.227685809}},
	{"rk9kv3q", Box{-18.8456726074, -18.8442993164, 148.246765137, 148.248138428}},
	{"kbq8t", Box{-43.505859375, -43.4619140625, 43.1103515625, 43.154296875}},
	{"j8prqp8kx", Box{-88.6836147308, -88.6835718155, 77.9596281052, 77.9596710205}},
	{"8", Box{0.0, 45.0, -180.0, -135.0}},
	{"mq53k", Box{-11.0302734375, -10.986328125, 60.99609375, 61.0400390625}},
	{"d95fw", Box{6.064453125, 6.1083984375, -61.962890625, -61.9189453125}},
	{"x15j3", Box{6.5478515625, 6.591796875, 139.262695312, 139.306640625}},
	{"x0yg7k2b", Box{4.81338500977, 4.81355667114, 144.636039734, 144.636383057}},
	{"dx8x9yxwprk5", Box{43.5426343046, 43.5426344723, -66.7093545198, -66.7093541846}},
	{"v", Box{45.0, 90.0, 45.0, 90.0}},
	{"429ptwcscc3", Box{-85.8312396705, -85.8312383294, -77.0999144018, -77.0999130607}},
	{"ncknjt", Box{-81.8865966797, -81.8811035156, 129.616699219, 129.627685547}},
	{"7ce8p70yc7h", Box{-36.5448457003, -36.5448443592, -6.00843250751, -6.00843116641}},
	{"un1", Box{78.75, 80.15625, 1.40625, 2.8125}},
	{"b6rv0shhd5", Box{58.5579174757, 58.5579228401, -157.824010849, -157.82400012}},
	{"qyg8d", Box{-6.943359375, -6.8994140625, 128.759765625, 128.803710938}},
	{"3p7f2mvx6", Box{-3.79041194916, -3.79036903381, -129.707937241, -129.707894325}},
	{"u0vj", Box{50.09765625, 50.2734375, 7.03125, 7.3828125}},
	{"49m", Box{-82.96875, -81.5625, -60.46875, -59.0625}},
	{"7vhu8hp00j2", Box{-16.0619835556, -16.0619822145, -4.56069946289, -4.56069812179}},
	{"3sh", Box{-22.5, -21.09375, -106.875, -105.46875}},
	{"sexg40hc", Box{20.2150154114, 20.2151870728, 33.4928512573, 33.4931945801}},
	{"4uwxw8u", Box{-63.365020752, -63.3636474609, -46.8182373047, -46.8168640137}},
	{"mr", Box{-5.625, 0.0, 56.25, 67.5}},
	{"1kymkgft79d3", Box{-62.3368896358, -62.3368894681, -114.748610817, -114.748610482}},
	{"3tj", Box{-16.875, -15.46875, -105.46875, -104.0625}},
	{"vxfzth5", Box{89.9340820312, 89.9354553223, 71.5910339355, 71.5924072266}},
	{"h", Box{-90.0, -45.0, 0.0, 45.0}},
	{"e5r9", Box{18.45703125, 18.6328125, -34.453125, -34.1015625}},
	{"hq9bc8pmfk", Box{-53.3046555519, -53.3046501875, 13.7869083881, 13.786919117}},
	{"05t", Box{-70.3125, -68.90625, -172.96875, -171.5625}},
	{"ye6yg", Box{64.4677734375, 64.51171875, 116.499023438, 116.54296875}},
	{"gg4k", Box{62.578125, 62.75390625, -8.0859375, -7.734375}},
	{"50q2fcp", Box{-88.4564208984, -88.4550476074, -36.0804748535, -36.0791015625}},
	{"2hu8d3131", Box{-18.1876945496, -18.1876516342, -173.571238518, -173.571195602}},
	{"08gcdmy84ewg", Box{-85.4859731533, -85.4859729856, -152.118642814, -152.118642479}},
	{"4", Box{-90.0, -45.0, -90.0, -45.0}},
	{"t05v4wzmqmet", Box{0.91691667214, 0.916916839778, 50.3935300559, 50.3935303912}},
	{"3nc", Box{-7.03125, -5.625, -133.59375, -132.1875}},
	{"v", Box{45.0, 90.0, 45.0, 90.0}},
	{"3gvk6zm1869", Box{-23.1190833449, -23.1190820038, -93.7394593656, -93.7394580245}},
	{"39rruq", Box{-36.5734863281, -36.5679931641, -102.117919922, -102.106933594}},
	{"jhkxvqt7q5z", Box{-64.6951617301, -64.6951603889, 51.5663145483, 51.5663158894}},
	{"bb", Box{45.0, 50.625, -146.25, -135.0}},
	{"es26styfpb", Box{24.3776321411, 24.3776375055, -21.9410812855, -21.9410705566}},
	{"500q98r9", Box{-88.8558769226, -88.8557052612, -44.5722198486, -44.5718765259}},
	{"kv", Box{-16.875, -11.25, 33.75, 45.0}},
	{"njf", Box{-57.65625, -56.25, 92.8125, 94.21875}},
	{"whk5vu", Box{24.5874023438, 24.5928955078, 95.8776855469, 95.888671875}},
	{"w9pq4yk4p4qf", Box{6.71437550336, 6.714375671, 122.821964733, 122.821965069}},
	{"yt", Box{73.125, 78.75, 112.5, 123.75}},
	{"ccztdek", Box{55.8283996582, 55.8297729492, -90.5877685547, -90.5863952637}},
	{"ej33gfth2", Box{29.8533296585, 29.8533725739, -43.070526123, -43.0704832077}},
	{"y", Box{45.0, 90.0, 90.0, 135.0}},
	{"hqyfjm", Box{-51.6522216797, -51.6467285156, 20.9729003906, 20.9838867188}},
	{"njcr", Box{-56.42578125, -56.25, 91.7578125, 92.109375}},
	{"48ejbxwrk6", Box{-86.1343038082, -86.1342984438, -63.2505118847, -63.2505011559}},
	{"78f1r09e5v8", Box{-40.558232367, -40.5582310259, -19.3776619434, -19.3776606023}},
	{"ged8fvuhk31", Box{64.8516565561, 64.8516578972, -18.8578484952, -18.8578471541}},
	{"8ss3fn", Box{25.6530761719, 25.6585693359, -151.435546875, -151.424560547}},
	{"v90sp4e6", Box{51.3422012329, 51.3423728943, 68.5152053833, 68.5155487061}},
	{"bx00h848", Box{84.375, 84.3751716614, -157.298812866, -157.298469543}},
	{"9y3", Box{35.15625, 36.5625, -99.84375, -98.4375}},
	{"ehpkg7", Box{23.3514404297, 23.3569335938, -34.6618652344, -34.6508789062}},
	{"r38623wxhs", Box{-36.1575293541, -36.1575239897, 146.621668339, 146.621679068}},
	{"x6yex2zx", Box{16.0893058777, 16.0894775391, 155.719528198, 155.719871521}},
	{"r", Box{-45.0, 0.0, 135.0, 180.0}},
	{"9", Box{0.0, 45.0, -135.0, -90.0}},
	{"6w", Box{-11.25, -5.625, -67.5, -56.25}},
	{"mx6g2d", Box{-3.63647460938, -3.63098144531, 71.3891601562, 71.4001464844}},
	{"vmsh9b6f", Box{76.7302322388, 76.7304039001, 61.9556808472, 61.9560241699}},
	{"7uqbsm728bjw", Box{-20.9769334272, -20.9769332595, -1.56654216349, -1.56654182822}},
	{"nvtqqh0jc3", Box{-57.9409021139, -57.9408967495, 131.396538019, 131.396548748}},
	{"x8", Box{0.0, 5.625, 157.5, 168.75}},
	{"nqx5n", Box{-52.91015625, -52.8662109375, 111.357421875, 111.401367188}},
	{"c4wmv60xtud", Box{60.0855401158, 60.0855414569, -125.979288518, -125.979287177}},
	{"t9", Box{5.625, 11.25, 67.5, 78.75}},
	{"e3nqrsk9fqdu", Box{6.74731470644, 6.74731487408, -24.6250675991, -24.6250672638}},
	{"k", Box{-45.0, 0.0, 0.0, 45.0}},
	{"7x9", Box{-2.8125, -1.40625, -21.09375, -19.6875}},
	{"760qb6yxf", Box{-32.5470399857, -32.5469970703, -33.3784389496, -33.3783960342}},
	{"x7skftff", Box{20.5543899536, 20.554561615, 152.340202332, 152.340545654}},
	{"jv774u", Box{-59.9194335938, -59.9139404297, 83.4411621094, 83.4521484375}},
	{"phh7", Box{-66.97265625, -66.796875, 140.9765625, 141.328125}},
	{"hv4tt0pymy", Box{-60.9070980549, -60.9070926905, 37.4962413311, 37.4962520599}},
	{"3zemdehyubj", Box{-1.82806491852, -1.82806357741, -96.563090533, -96.5630891919}},
	{"v", Box{45.0, 90.0, 45.0, 90.0}},
	{"dep80ett", Box{16.8950843811, 16.8952560425, -56.9235992432, -56.9232559204}},
	{"bbj", Box{45.0, 46.40625, -139.21875, -137.8125}},
	{"k", Box{-45.0, 0.0, 0.0, 45.0}},
	{"v", Box{45.0, 90.0, 45.0, 90.0}},
	{"9k1t0ecqh3v3", Box{23.4005451389, 23.4005453065, -121.616746299, -121.616745964}},
	{"mm5", Box{-16.875, -15.46875, 60.46875, 61.875}},
	{"jz4zmmv2", Box{-49.3190002441, -49.3188285828, 82.8551101685, 82.8554534912}},
	{"bpshcry", Box{88.065032959, 88.06640625, -174.311828613, -174.310455322}},
	{"z", Box{45.0, 90.0, 135.0, 180.0}},
	{"e87b", Box{1.40625, 1.58203125, -17.2265625, -16.875}},
	{"pcphekd1ph0", Box{-83.5590720177, -83.5590706766, 178.739619255, 178.739620596}},
	{"nrwq0", Box{-46.7578125, -46.7138671875, 110.0390625, 110.083007812}},
	{"6k3e7rk823cj", Box{-20.4825823568, -20.4825821891, -76.4916108549, -76.4916105196}},
	{"kkv059k5v", Box{-18.2737398148, -18.2736968994, 18.4407663345, 18.4408092499}},
	{"ep7x2t4t6x", Box{42.084068656, 42.0840740204, -40.0526118279, -40.052601099}},
	{"43hh0", Box{-83.671875, -83.6279296875, -73.125, -73.0810546875}},
	{"rdhfdg0qee", Box{-33.2929354906, -33.2929301262, 164.301030636, 164.301041365}},
	{"znku45j7p", Box{80.8763694763, 80.8764123917, 141.77508831, 141.775131226}},
	{"ju", Box{-67.5, -61.875, 78.75, 90.0}},
	{"b6zckuz", Box{60.7145690918, 60.7159423828, -157.633209229, -157.631835938}},
	{"fm7m", Box{75.41015625, 75.5859375, -74.1796875, -73.828125}},
	{"8xg", Box{43.59375, 45.0, -153.28125, -151.875}},
	{"wfk7q", Box{13.2275390625, 13.271484375, 129.990234375, 130.034179688}},
	{"6r1p9yz6z9", Box{-4.26908433437, -4.26907896996, -77.2565674782, -77.2565567493}},
	{"t", Box{0.0, 45.0, 45.0, 90.0}},
	{"fuzw5", Box{72.7734375, 72.8173828125, -45.5712890625, -45.52734375}},
	{"m33ehjv", Box{-37.4098205566, -37.4084472656, 58.5420227051, 58.5433959961}},
	{"s6stp", Box{14.94140625, 14.9853515625, 17.8857421875, 17.9296875}},
	{"tjxuvxh", Box{31.8109130859, 31.812286377, 56.1456298828, 56.1470031738}},
	{"0vgxezccsf", Box{-56.2950503826, -56.2950450182, -141.160722971, -141.160712242}},
	{"0h", Box{-67.5, -61.875, -180.0, -168.75}},
	{"ge6bb", Box{63.4130859375, 63.45703125, -18.6328125, -18.5888671875}},
	{"h2gyy9", Box{-84.5892333984, -84.5837402344, 16.8090820312, 16.8200683594}},
	{"g0f7xg", Box{49.8504638672, 49.8559570312, -41.4953613281, -41.484375}},
	{"ujfk5", Box{78.046875, 78.0908203125, 3.2958984375, 3.33984375}},
	{"q0b6rwm0", Box{-40.3514099121, -40.3512382507, 90.6880187988, 90.6883621216}},
	{"d", Box{0.0, 45.0, -90.0, -45.0}},
	{"0nyhwsx2g5", Box{-51.2153702974, -51.215364933, -171.266770363, -171.266759634}},
	{"mjpe", Box{-16.34765625, -16.171875, 55.546875, 55.8984375}},
	{"mt", Box{-16.875, -11.25, 67.5, 78.75}},
	{"z49vj0d4zz", Box{59.9446624517, 59.9446678162, 137.683743238, 137.683753967}},
	{"zry97vd3gs", Box{88.8440108299, 88.8440161943, 155.55866003, 155.558670759}},
	{"c", Box{45.0, 90.0, -135.0, -90.0}},
	{"v3syrvc9", Box{54.5678901672, 54.5680618286, 63.2723236084, 63.2726669312}},
	{"nrer", Box{-46.58203125, -46.40625, 105.8203125, 106.171875}},
	{"2hqt8nf65v5e", Box{-20.0895036198, -20.0895034522, -170.856119469, -170.856119134}},
	{"wekgdxc", Box{18.9390563965, 18.9404296875, 119.290924072, 119.292297363}},
	{"6bh43q", Box{-44.5715332031, -44.5660400391, -50.5700683594, -50.5590820312}},
	{"d564", Box{18.6328125, 18.80859375, -87.1875, -86.8359375}},
	{"m85", Box{-45.0, -43.59375, 71.71875, 73.125}},
	{"x4tj5rb77r", Box{14.9845737219, 14.9845790863, 142.174555063, 142.174565792}},
	{"0bwycz8vr", Box{-85.9588766098, -85.9588336945, -136.679577827, -136.679534912}},
	{"ehnu2e", Box{23.2635498047, 23.2690429688, -35.4858398438, -35.4748535156}},
	{"jbe8mk", Box{-87.1215820312, -87.1160888672, 83.9025878906, 83.9135742188}},
	{"ss", Box{22.5, 28.125, 22.5, 33.75}},
	{"8edywpv3ygj3", Box{20.8729668148, 20.8729669824, -153.361634128, -153.361633793}},
	{"xpxu1erq390", Box{42.9095560312, 42.9095573723, 145.974376202, 145.974377543}},
	{"4043qb91kj", Box{-89.7772854567, -89.7772800922, -86.5377616882, -86.5377509594}},
	{"2n7q0j0r", Box{-8.76039505005, -8.76022338867, -175.429344177, -175.429000854}},
	{"cm0n96q3vn8t", Box{74.2802738585, 74.2802740261, -123.686270043, -123.686269708}},
	{"50hgpxg", Box{-89.4300842285, -89.4287109375, -37.9866027832, -37.9852294922}},
	{"2m", Box{-16.875, -11.25, -168.75, -157.5}},
	{"w4s1zj8n9", Box{14.4014453888, 14.4014883041, 95.9326601028, 95.9327030182}},
	{"hxzh", Box{-45.703125, -45.52734375, 32.34375, 32.6953125}},
	{"cn", Box{78.75, 84.375, -135.0, -123.75}},
	{"dpt5k8", Box{42.7587890625, 42.7642822266, -82.7709960938, -82.7600097656}},
	{"gz", Box{84.375, 90.0, -11.25, 0.0}},
	{"d09knt", Box{3.54309082031, 3.54858398438, -87.9565429688, -87.9455566406}},
	{"mrucw", Box{-1.142578125, -1.0986328125, 63.193359375, 63.2373046875}},
	{"055egqf4y", Box{-72.4282693863, -72.4282264709, -174.93229866, -174.932255745}},
	{"qphu", Box{-4.921875, -4.74609375, 96.6796875, 97.03125}},
	{"dfeh", Box{14.765625, 14.94140625, -52.03125, -51.6796875}},
	{"00qfn4ctp57", Box{-88.2262055576, -88.2262042165, -170.241776258, -170.241774917}},
	{"q9xx27p2trn", Box{-35.2714830637, -35.2714817226, 123.06805104, 123.068052381}},
	{"10bhfgfsj8m", Box{-84.9250017107, -84.9250003695, -134.875474423, -134.875473082}},
	{"6k", Box{-22.5, -16.875, -78.75, -67.5}},
	{"zyvjr4m37", Box{83.9041757584, 83.9042186737, 176.096205711, 176.096248627}},
	{"0c8k7gb", Box{-80.7948303223, -80.7934570312, -145.733642578, -145.732269287}},
	{"n7k", Box{-71.71875, -70.3125, 106.875, 108.28125}},
	{"fpj4eecz", Box{84.8362541199, 84.8364257812, -82.812538147, -82.8121948242}},
	{"ev", Box{28.125, 33.75, -11.25, 0.0}},
	{"8y", Box{33.75, 39.375, -146.25, -135.0}},
	{"x9xd1q", Box{8.82202148438, 8.82751464844, 168.101806641, 168.112792969}},
	{"x", Box{0.0, 45.0, 135.0, 180.0}},
	{"d1pmefm0t", Box{6.60424232483, 6.60428524017, -79.6328115463, -79.632768631}},
	{"tmy", Box{32.34375, 33.75, 64.6875, 66.09375}},
	{"phu6jzv0z", Box{-62.8869867325, -62.8869438171, 141.236414909, 141.236457825}},
	{"zv7pjxpuwjbq", Box{75.8009752259, 75.8009753935, 173.221350051, 173.221350387}},
	{"9gegu1", Box{20.3521728516, 20.3576660156, -95.80078125, -95.7897949219}},
	{"tq33", Box{35.33203125, 35.5078125, 58.0078125, 58.359375}},
	{"e", Box{0.0, 45.0, -45.0, 0.0}},
	{"y6z1sy", Box{60.7653808594, 60.7708740234, 111.302490234, 111.313476562}},
	{"3", Box{-45.0, 0.0, -135.0, -90.0}},
	{"q", Box{-45.0, 0.0, 90.0, 135.0}},
	{"mtyyw7", Box{-11.4971923828, -11.4916992188, 77.2668457031, 77.2778320312}},
	{"2sqmb", Box{-20.0830078125, -20.0390625, -148.7109375, -148.666992188}},
	{"yp487k", Box{84.4409179688, 84.4464111328, 93.6584472656, 93.6694335938}},
	{"nyn5k1fc", Box{-55.668926239, -55.6687545776, 132.3670578, 132.367401123}},
	{"gnqk77v", Box{80.9239196777, 80.9252929688, -36.0612487793, -36.0598754883}},
	{"yw12", Box{78.75, 78.92578125, 114.2578125, 114.609375}},
	{"vcgqqmd", Box{55.9725952148, 55.9739685059, 83.5977172852, 83.5990905762}},
	{"27zp3q", Box{-22.5988769531, -22.5933837891, -158.851318359, -158.840332031}},
	{"cg4tb6", Box{62.8967285156, 62.9022216797, -97.7233886719, -97.7124023438}},
	{"w5njb9rnp5e", Box{17.8936573863, 17.8936587274, 98.4693901241, 98.4693914652}},
	{"9y6rp4pptv", Box{36.3990193605, 36.399024725, -97.7684605122, -97.7684497833}},
	{"pjup17j08hup", Box{-56.4091892727, -56.409189105, 140.68680346, 140.686803795}},
	{"vz52f33z9mu", Box{84.5150206983, 84.5150220394, 83.421651721, 83.4216530621}},
	{"zd", Box{56.25, 61.875, 157.5, 168.75}},
	{"q", Box{-45.0, 0.0, 90.0, 135.0}},
	{"dm46s", Box{28.564453125, 28.6083984375, -75.41015625, -75.3662109375}},
	{"d7dnvbu", Box{20.8781433105, 20.8795166016, -75.6793212891, -75.677947998}},
	{"02ercsvx0h", Box{-85.7978796959, -85.7978743315, -164.106216431, -164.106205702}},
	{"hnfx5f", Box{-50.7897949219, -50.7843017578, 3.68041992188, 3.69140625}},
	{"evb677f6t", Box{32.7602863312, 32.7603292465, -10.7523107529, -10.7522678375}},
	{"sg43r7p151", Box{17.1113830805, 17.1113884449, 37.2424077988, 37.2424185276}},
	{"441mdz5", Box{-77.7447509766, -77.7433776855, -88.1172180176, -88.1158447266}},
	{"k2qrsc7hr81", Box{-42.2677946091, -42.267793268, 20.2522458136, 20.2522471547}},
	{"d0ydzxhjwr", Box{4.74158227444, 4.74158763885, -80.5240237713, -80.5240130424}},
	{"4cn", Box{-84.375, -82.96875, -47.8125, -46.40625}},
	{"ds2", Box{23.90625, 25.3125, -67.5, -66.09375}},
	{"rxvywy", Box{-0.230712890625, -0.225219726562, 165.882568359, 165.893554688}},
	{"zs2k", Box{69.609375, 69.78515625, 157.8515625, 158.203125}},
	{"kg63", Box{-26.54296875, -26.3671875, 36.9140625, 37.265625}},
	{"hmxh64j", Box{-58.3044433594, -58.3030700684, 21.1885070801, 21.1898803711}},
	{"d5v3", Box{21.26953125, 21.4453125, -82.6171875, -82.265625}},
	{"ddg1", Box{15.64453125, 15.8203125, -63.28125, -62.9296875}},
	{"stf4tug", Box{32.8092956543, 32.8106689453, 25.5693054199, 25.5706787109}},
	{"vgc", Box{66.09375, 67.5, 80.15625, 81.5625}},
	{"jby3xf", Box{-85.5065917969, -85.5010986328, 87.8796386719, 87.890625}},
	{"9b1f419tdjf", Box{0.360777229071, 0.360778570175, -98.6990234256, -98.6990220845}},
	{"0zqp4", Box{-47.98828125, -47.9443359375, -137.724609375, -137.680664062}},
	{"gg292c4wd", Box{63.5075855255, 63.5076284409, -10.5103969574, -10.5103540421}},
	{"zy96qbt", Box{81.9607543945, 81.9621276855, 170.811309814, 170.812683105}},
	{"tz9x7f5c70", Box{43.4731149673, 43.4731203318, 81.0294485092, 81.0294592381}},
	{"rq", Box{-11.25, -5.625, 146.25, 157.5}},
	{"94tt", Box{14.94140625, 15.1171875, -127.265625, -126.9140625}},
	{"h7vnwf8", Box{-67.7499389648, -67.7485656738, 18.5778808594, 18.5792541504}},
	{"4f", Box{-78.75, -73.125, -56.25, -45.0}},
	{"kj3t", Box{-14.58984375, -14.4140625, 2.109375, 2.4609375}},
	{"qspj", Box{-21.62109375, -21.4453125, 122.34375, 122.6953125}},
	{"4y9", Box{-53.4375, -52.03125, -54.84375, -53.4375}},
	{"b05kqcvsm8", Box{45.7574129105, 45.7574182749, -175.125267506, -175.125256777}},
	{"p5zq4f", Box{-67.8405761719, -67.8350830078, 145.316162109, 145.327148438}},
	{"1cgx", Box{-78.92578125, -78.75, -96.328125, -95.9765625}},
	{"m2", Box{-45.0, -39.375, 56.25, 67.5}},
	{"j150xkd492", Box{-84.2619609833, -84.2619556189, 49.5401537418, 49.5401644707}},
	{"05rs", Box{-71.015625, -70.83984375, -169.453125, -169.1015625}},
	{"ve8", Box{64.6875, 66.09375, 67.5, 68.90625}},
	{"r9tv", Box{-35.68359375, -35.5078125, 165.5859375, 165.9375}},
	{"d71r07", Box{18.1219482422, 18.1274414062, -76.9812011719, -76.9702148438}},
	{"b6hepfqk6", Box{56.79043293, 56.7904758453, -162.072629929, -162.072587013}},
	{"md8y86mqjd", Box{-29.7815215588, -29.7815161943, 68.5731196404, 68.5731303692}},
	{"bcgcyq", Box{55.1843261719, 55.1898193359, -140.701904297, -140.690917969}},
	{"e3hpu9352", Box{6.99472904205, 6.9947719574, -27.9258728027, -27.9258298874}},
	{"hsbsq2rkmg", Box{-62.5320607424, -62.532055378, 23.4879863262, 23.4879970551}},
	{"ub2r", Box{47.63671875, 47.8125, 34.1015625, 34.453125}},
	{"d8", Box{0.0, 5.625, -67.5, -56.25}},
	{"gexm9j6y088", Box{65.6841686368, 65.6841699779, -12.2569441795, -12.2569428384}},
	{"15cdq", Box{-68.5107421875, -68.466796875, -132.626953125, -132.583007812}},
	{"9zud17gy", Box{43.9669418335, 43.9671134949, -94.8617935181, -94.8614501953}},
	{"4q3y", Box{-53.7890625, -53.61328125, -76.2890625, -75.9375}},
	{"gph138", Box{84.5947265625, 84.6002197266, -39.3090820312, -39.2980957031}},
	{"m09d8ju2b", Box{-41.7163324356, -41.7162895203, 47.1152114868, 47.1152544022}},
	{"8mszup4gk", Box{32.3388147354, 32.3388576508, -161.890583038, -161.890540123}},
	{"dyrfvtvqh", Box{35.6722640991, 35.6723070145, -45.102481842, -45.1024389267}},
	{"3h9tgkp", Box{-18.6547851562, -18.6534118652, -132.738189697, -132.736816406}},
	{"66gdty14u", Box{-29.0583658218, -29.0583229065, -73.5738945007, -73.5738515854}},
	{"83zp1d", Box{11.0852050781, 11.0906982422, -158.840332031, -158.829345703}},
	{"e7gp0", Box{22.32421875, 22.3681640625, -29.53125, -29.4873046875}},
	{"s0ykfgceytk", Box{5.07498219609, 5.0749835372, 8.91225636005, 8.91225770116}},
	{"zfe7", Box{59.58984375, 59.765625, 173.3203125, 173.671875}},
	{"cr9", Box{87.1875, 88.59375, -122.34375, -120.9375}},
	{"9ugr3kq", Box{28.0165100098, 28.0178833008, -96.6165161133, -96.6151428223}},
	{"2grcq0", Box{-26.4990234375, -26.4935302734, -135.087890625, -135.076904297}},
	{"50bb31vkds3p", Box{-85.726895202, -85.7268950343, -43.8940487802, -43.8940484449}},
	{"qhxdv1hcqe3", Box{-19.1983763874, -19.1983750463, 100.773404986, 100.773406327}},
	{"k2cv0gp2vk", Box{-39.8857140541, -39.8857086897, 13.7540781498, 13.7540888786}},
	{"y5jd", Box{62.2265625, 62.40234375, 97.734375, 98.0859375}},
	{"gnvg3p", Box{83.5784912109, 83.583984375, -36.8701171875, -36.8591308594}},
	{"9g70w", Box{18.369140625, 18.4130859375, -96.767578125, -96.7236328125}},
	{"9g7qsb", Box{19.423828125, 19.4293212891, -96.4709472656, -96.4599609375}},
	{"1zq2u", Box{-49.0869140625, -49.04296875, -92.28515625, -92.2412109375}},
	{"tr", Box{39.375, 45.0, 56.25, 67.5}},
	{"4wmddz9mgk38", Box{-54.3620882928, -54.3620881252, -59.6429172903, -59.6429169551}},
	{"wkcdsn8nbz", Box{27.1951049566, 27.195110321, 103.535188437, 103.535199165}},
	{"1r198wxj", Box{-50.3247642517, -50.3245925903, -121.609039307, -121.608695984}},
	{"eu", Box{22.5, 28.125, -11.25, 0.0}},
	{"k2y7mk6sd0wz", Box{-40.1858386584, -40.1858384907, 20.2733035013, 20.2733038366}},
	{"gms9ytw4v5", Box{76.2758177519, 76.2758231163, -27.1277761459, -27.1277654171}},
	{"2vdkc", Box{-13.2275390625, -13.18359375, -143.041992188, -142.998046875}},
	{"bke7fx3", Box{71.011505127, 71.012878418, -164.068450928, -164.067077637}},
	{"tvnxu7jt8", Box{29.5047283173, 29.5047712326, 88.0849456787, 88.0849885941}},
	{"f864yp3c", Box{46.9296455383, 46.9298171997, -64.4214248657, -64.421081543}},
	{"g8hxr7x150d7", Box{46.2938149832, 46.2938151509, -15.8435266837, -15.8435263485}},
	{"zmk4kmh", Box{74.9542236328, 74.9555969238, 152.067260742, 152.068634033}},
	{"gtqsvep4", Box{75.3830337524, 75.3832054138, -13.1080627441, -13.1077194214}},
	{"trsvy0", Box{43.1982421875, 43.2037353516, 63.193359375, 63.2043457031}},
	{"bevjfs", Box{67.1264648438, 67.1319580078, -150.358886719, -150.347900391}},
	{"ktrb", Box{-15.46875, -15.29296875, 33.3984375, 33.75}},
	{"dn20q1pv", Box{35.2065467834, 35.2067184448, -89.7256851196, -89.7253417969}},
	{"8n3wy5g2", Box{36.3633728027, 36.3635444641, -177.622489929, -177.622146606}},
	{"vyzft", Box{83.408203125, 83.4521484375, 89.8681640625, 89.912109375}},
	{"gwuedjbs8222", Box{83.6163438857, 83.6163440533, -16.0832866654, -16.0832863301}},
	{"fpb89dkktj83", Box{88.6948023923, 88.6948025599, -89.2249056324, -89.2249052972}},
	{"wjjk3", Box{28.8720703125, 28.916015625, 97.4267578125, 97.470703125}},
	{"wx6", Box{40.78125, 42.1875, 115.3125, 116.71875}},
	{"yzpuuv3w0pw", Box{85.2398702502, 85.2398715913, 134.859245718, 134.859247059}},
	{"k2518ucy", Box{-44.7092056274, -44.7090339661, 15.5041122437, 15.5044555664}},
	{"hkjk1075", Box{-66.7949867249, -66.7948150635, 18.6808776855, 18.6812210083}},
	{"btmd", Box{74.8828125, 75.05859375, -149.765625, -149.4140625}},
	{"ucbvmyuw9z", Box{55.8048337698, 55.8048391342, 35.0636279583, 35.0636386871}},
	{"wf86ytd34", Box{14.5762825012, 14.5763254166, 124.390382767, 124.390425682}},
	{"9zjbws3u", Box{39.4869232178, 39.4870948792, -92.8760147095, -92.8756713867}},
	{"rqc", Box{-7.03125, -5.625, 147.65625, 149.0625}},
	{"pwqw8gh8x74", Box{-53.6845904589, -53.6845891178, 166.680077612, 166.680078954}},
	{"5ekn", Box{-70.6640625, -70.48828125, -16.875, -16.5234375}},
	{"mxx0b3mzwxp", Box{-2.67247259617, -2.67247125506, 77.3629210889, 77.36292243}},
	{"tn", Box{33.75, 39.375, 45.0, 56.25}},
	{"ju59u9b8grr", Box{-67.1826021373, -67.1826007962, 83.8704644144, 83.8704657555}},
	{"hmte6v6jzq84", Box{-58.4613495693, -58.4613494016, 19.1082823277, 19.1082826629}},
	{"t3", Box{5.625, 11.25, 56.25, 67.5}},
	{"es9g6", Box{25.8837890625, 25.927734375, -19.951171875, -19.9072265625}},
	{"2bwcdk6y", Box{-41.8994522095, -41.8992805481, -136.655158997, -136.654815674}},
	{"4ew3jn8umh", Box{-70.1002621651, -70.1002568007, -58.4899663925, -58.4899556637}},
	{"0meekufm4x3", Box{-58.4642212093, -58.4642198682, -163.616186231, -163.61618489}},
	{"02", Box{-90.0, -84.375, -168.75, -157.5}},
	{"9yuv0t43sv0", Box{38.8754063845, 38.8754077256, -94.5450460911, -94.54504475}},
	{"u0g7y8444", Box{49.8782730103, 49.8783159256, 4.85878944397, 4.85883235931}},
	{"r4", Box{-33.75, -28.125, 135.0, 146.25}},
	{"1ps631dwde", Box{-47.4076205492, -47.4076151848, -128.975951672, -128.975940943}},
	{"vbmfdm", Box{46.8731689453, 46.8786621094, 86.9348144531, 86.9458007812}},
	{"s7gmxm8vhn5v", Box{22.0916506089, 22.0916507766, 16.1401226744, 16.1401230097}},
	{"mcwrh68t", Box{-35.317440033, -35.3172683716, 87.7265167236, 87.7268600464}},
	{"9yt5645jq9r9", Box{37.145683486, 37.1456836537, -94.1264504939, -94.1264501587}},
	{"61t1x3z", Box{-36.2892150879, -36.2878417969, -82.6405334473, -82.6391601562}},
	{"wmzkmbm", Box{33.0921936035, 33.0935668945, 111.704864502, 111.706237793}},
	{"jy", Box{-56.25, -50.625, 78.75, 90.0}},
	{"9ctckntmvgkr", Box{8.69393778965, 8.69393795729, -92.9808190092, -92.980818674}},
	{"8rnugbss4gd", Box{40.2134129405, 40.2134142816, -159.086717069, -159.086715728}},
	{"ek8", Box{25.3125, 26.71875, -33.75, -32.34375}},
	{"nvqegbu", Box{-59.8054504395, -59.8040771484, 133.060913086, 133.062286377}},
	{"h0u7v6pujp5", Box{-85.1103597879, -85.1103584468, 6.21813699603, 6.21813833714}},
	{"2rj", Box{-5.625, -4.21875, -161.71875, -160.3125}},
	{"jk38", Box{-66.09375, -65.91796875, 58.359375, 58.7109375}},
	{"c67qe30m", Box{58.8051795959, 58.8053512573, -119.036521912, -119.036178589}},
	{"xhtwk", Box{26.4111328125, 26.455078125, 142.91015625, 142.954101562}},
	{"pw6ue97rjn11", Box{-54.0446339361, -54.0446337685, 161.525675207, 161.525675543}},
	{"xpmw424pk6", Box{41.8371927738, 41.8371981382, 142.836180925, 142.836191654}},
	{"rk", Box{-22.5, -16.875, 146.25, 157.5}},
	{"hmfmn5uwdh2", Box{-56.755605787, -56.7556044459, 14.6840000153, 14.6840013564}},
	{"defvfj", Box{22.1319580078, 22.1374511719, -63.544921875, -63.5339355469}},
	{"sg7jd89w", Box{19.2518234253, 19.2519950867, 38.0806732178, 38.0810165405}},
	{"yn0", Box{78.75, 80.15625, 90.0, 91.40625}},
	{"3n7re6gv2e92", Box{-8.50936442614, -8.5093642585, -130.281692259, -130.281691924}},
	{"vyj", Box{78.75, 80.15625, 85.78125, 87.1875}},
	{"9cntsz", Box{6.63024902344, 6.6357421875, -91.9006347656, -91.8896484375}},
	{"w4uwq3d", Box{16.5756225586, 16.5769958496, 96.6055297852, 96.6069030762}},
	{"zffrf", Box{61.8310546875, 61.875, 172.001953125, 172.045898438}},
	{"hq6142s", Box{-54.665222168, -54.663848877, 14.1668701172, 14.1682434082}},
	{"m7srp977", Box{-24.0746498108, -24.0744781494, 62.5606155396, 62.5609588623}},
	{"8v6hxy3sz", Box{30.3574132919, 30.3574562073, -143.094563484, -143.094520569}},
	{"rf4snrh70h", Box{-33.0078864098, -33.0078810453, 172.54611969, 172.546130419}},
	{"6", Box{-45.0, 0.0, -90.0, -45.0}},
	{"ssr6y", Box{24.3896484375, 24.43359375, 32.958984375, 33.0029296875}},
	{"z", Box{45.0, 90.0, 135.0, 180.0}},
	{"yz", Box{84.375, 90.0, 123.75, 135.0}},
	{"n2", Box{-90.0, -84.375, 101.25, 112.5}},
	{"vfe", Box{59.0625, 60.46875, 82.96875, 84.375}},
	{"h", Box{-90.0, -45.0, 0.0, 45.0}},
	{"z3", Box{50.625, 56.25, 146.25, 157.5}},
	{"z2web5usz", Box{48.4930944443, 48.4931373596, 155.397105217, 155.397148132}},
	{"8gkc", Box{18.45703125, 18.6328125, -139.5703125, -139.21875}},
	{"17de4", Box{-69.78515625, -69.7412109375, -120.146484375, -120.102539062}},
	{"ky71b3fwd2vv", Box{-9.52539911494, -9.5253989473, 37.9832738265, 37.9832741618}},
	{"e4gfcm", Box{15.9796142578, 15.9851074219, -39.6716308594, -39.6606445312}},
	{"kdgwxnnb", Box{-28.3557128906, -28.3555412292, 27.7387619019, 27.7391052246}},
	{"4nyn2chy", Box{-50.9260940552, -50.9259223938, -81.5230178833, -81.5226745605}},
	{"u6je3kk57", Box{56.8451929092, 56.8452358246, 19.0449285507, 19.0449714661}},
	{"nrs9j1hj5tj", Box{-47.630340457, -47.6303391159, 107.803501636, 107.803502977}},
	{"j", Box{-90.0, -45.0, 45.0, 90.0}},
	{"krqrcc2hm9uq", Box{-2.84883890301, -2.84883873537, 20.116208531, 20.1162088662}},
	{"fmceu", Box{78.0029296875, 78.046875, -76.46484375, -76.4208984375}},
	{"q3w576", Box{-35.9802246094, -35.9747314453, 109.830322266, 109.841308594}},
	{"19ehn", Box{-80.859375, -80.8154296875, -108.017578125, -107.973632812}},
	{"zpkvjk", Box{86.6821289062, 86.6876220703, 141.910400391, 141.921386719}},
	{"7cgwy9jm", Box{-33.9633750916, -33.9632034302, -6.03527069092, -6.03492736816}},
	{"jju1cefk5v1", Box{-57.3273199797, -57.3273186386, 50.6941701472, 50.6941714883}},
	{"5tfpq6", Box{-56.3708496094, -56.3653564453, -19.4128417969, -19.4018554688}},
	{"j", Box{-90.0, -45.0, 45.0, 90.0}},
	{"dm0vh8", Box{29.00390625, 29.0093994141, -77.4975585938, -77.4865722656}},
	{"jt5c8hhd58b", Box{-61.5890081227, -61.5890067816, 72.7797675133, 72.7797688544}},
	{"4ttr", Box{-57.83203125, -57.65625, -60.1171875, -59.765625}},
	{"d", Box{0.0, 45.0, -90.0, -45.0}},
	{"sp2d3v6wz", Box{41.2067556381, 41.2067985535, 0.783762931824, 0.783805847168}},
	{"up1yhbspqy", Box{85.4337108135, 85.4337161779, 2.67546057701, 2.67547130585}},
	{"1z4bx8dp1ex1", Box{-50.5331422202, -50.5331420526, -97.0504023135, -97.0504019782}},
	{"76qbnz5n1937", Box{-32.3042606749, -32.3042605072, -23.9569957182, -23.9569953829}},
	{"0w1bvcjb40xd", Box{-56.112667881, -56.1126677133, -154.778384641, -154.778384306}},
	{"x", Box{0.0, 45.0, 135.0, 180.0}},
	{"yqbjwyvsmc", Box{83.9733606577, 83.9733660221, 101.554430723, 101.554441452}},
	{"0hdp2tdy5", Box{-63.3818435669, -63.3818006516, -177.161622047, -177.161579132}},
	{"s8yv34v", Box{5.15670776367, 5.15808105469, 32.0429992676, 32.0443725586}},
	{"uc60k7w6", Box{52.0947647095, 52.0949363708, 36.757850647, 36.7581939697}},
	{"en6h7me8", Box{35.9335327148, 35.9337043762, -42.0398712158, -42.0395278931}},
	{"1bks34", Box{-87.8356933594, -87.8302001953, -94.8779296875, -94.8669433594}},
	{"65", Box{-28.125, -22.5, -90.0, -78.75}},
	{"qwrquvr", Box{-8.62838745117, -8.62701416016, 122.913665771, 122.915039062}},
	{"3dmchcusw83", Box{-32.1575818956, -32.1575805545, -104.198862165, -104.198860824}},
	{"urfeh", Box{89.12109375, 89.1650390625, 14.94140625, 14.9853515625}},
	{"d3g6rs", Box{10.2612304688, 10.2667236328, -73.8500976562, -73.8391113281}},
	{"wx0v", Box{40.25390625, 40.4296875, 113.5546875, 113.90625}},
	{"7", Box{-45.0, 0.0, -45.0, 0.0}},
	{"et", Box{28.125, 33.75, -22.5, -11.25}},
	{"dqtd0", Box{36.9140625, 36.9580078125, -71.015625, -70.9716796875}},
	{"vtzuwhxhgjv8", Box{78.1603311002, 78.1603312679, 78.6718585342, 78.6718588695}},
	{"bn9", Box{81.5625, 82.96875, -178.59375, -177.1875}},
	{"685n", Box{-43.9453125, -43.76953125, -63.28125, -62.9296875}},
	{"fqy4nhy", Box{83.3464050293, 83.3477783203, -70.0405883789, -70.0392150879}},
	{"5q1dw", Box{-55.810546875, -55.7666015625, -31.376953125, -31.3330078125}},
	{"0sv8m11dgkf", Box{-63.2313139737, -63.2313126326, -149.543696344, -149.543695003}},
	{"vp435nn", Box{84.5837402344, 84.5851135254, 48.3041381836, 48.3055114746}},
	{"wydj", Box{37.44140625, 37.6171875, 126.5625, 126.9140625}},
	{"ebg8", Box{4.21875, 4.39453125, -6.328125, -5.9765625}},
	{"ksmb6pfxe4", Box{-21.0059344769, -21.0059291124, 30.6773900986, 30.6774008274}},
	{"8bv63qv96dp", Box{4.65156197548, 4.65156331658, -138.804586083, -138.804584742}},
	{"0s0d53hd", Box{-67.1426010132, -67.1424293518, -156.647872925, -156.647529602}},
	{"1yjf34ubpm", Box{-55.8393591642, -55.8393537998, -93.1132829189, -93.1132721901}},
	{"823y79hmfe", Box{2.51137912273, 2.51138448715, -166.129310131, -166.129299402}},
	{"xynnrv", Box{34.8760986328, 34.8815917969, 177.528076172, 177.5390625}},
	{"9b9ejqcqqdu", Box{3.37801024318, 3.37801158428, -98.9079111814, -98.9079098403}},
	{"cuuhfkd", Box{72.5784301758, 72.5798034668, -95.5233764648, -95.5220031738}},
	{"khwceh", Box{-19.4018554688, -19.3963623047, 9.6240234375, 9.63500976562}},
	{"z8vub32sy6", Box{50.061403513, 50.0614088774, 165.597878695, 165.597889423}},
	{"4s", Box{-67.5, -61.875, -67.5, -56.25}},
	{"bsrb4qeqt7eq", Box{68.9430911466, 68.9430913143, -146.497992687, -146.497992352}},
	{"b1x0sc", Box{53.5308837891, 53.5363769531, -169.947509766, -169.936523438}},
	{"1ngn2bn2vub", Box{-50.9324629605, -50.9324616194, -130.739461184, -130.739459842}},
	{"bsm", Box{68.90625, 70.3125, -150.46875, -149.0625}},
	{"xyzd7", Box{38.3642578125, 38.408203125, 179.428710938, 179.47265625}},
	{"cvvf1tqs", Box{77.7248382568, 77.7250099182, -93.0892181396, -93.0888748169}},
	{"fz2tpb1xj", Box{86.6613578796, 86.661400795, -55.2040243149, -55.2039813995}},
	{"r4zqr7", Box{-28.4161376953, -28.4106445312, 145.513916016, 145.524902344}},
	{"wth", Box{28.125, 29.53125, 118.125, 119.53125}},
	{"n", Box{-90.0, -45.0, 90.0, 135.0}},
	{"4j0ff5xs58h", Box{-61.3716888428, -61.3716875017, -88.8469666243, -88.8469652832}},
	{"c15", Box{50.625, 52.03125, -130.78125, -129.375}},
	{"tnkgyg", Box{35.8319091797, 35.8374023438, 51.9763183594, 51.9873046875}},
	{"e99", Box{8.4375, 9.84375, -21.09375, -19.6875}},
	{"bcrz69", Box{53.3111572266, 53.3166503906, -135.241699219, -135.230712891}},
	{"e5w29f6", Box{19.7877502441, 19.7891235352, -36.1312866211, -36.1299133301}},
	{"gykjjcq656b5", Box{81.0423812829, 81.0423814505, -5.36359190941, -5.36359157413}},
	{"7j62nzypd3be", Box{-15.4248806275, -15.4248804599, -41.5309696645, -41.5309693292}},
	{"rrsgbbvwt9r7", Box{-2.14807743207, -2.14807726443, 152.970445342, 152.970445678}},
	{"93kub", Box{7.8662109375, 7.91015625, -117.0703125, -117.026367188}},
	{"8", Box{0.0, 45.0, -180.0, -135.0}},
	{"02bcjtw5f84", Box{-85.5746126175, -85.5746112764, -167.445263565, -167.445262223}},
	{"262dqsqs1", Box{-31.9242095947, -31.9241666794, -167.752261162, -167.752218246}},
	{"185ss806c", Box{-89.2085123062, -89.2084693909, -107.379984856, -107.37994194}},
	{"9s6", Box{23.90625, 25.3125, -109.6875, -108.28125}},
	{"ych1d25e", Box{50.8891868591, 50.8893585205, 129.478683472, 129.479026794}},
	{"7f2qcykht0d", Box{-31.1221191287, -31.1221177876, -10.8158227801, -10.815821439}},
	{"5gk7qw", Box{-71.1145019531, -71.1090087891, -4.98779296875, -4.97680664062}},
	{"7kjutjpu98", Box{-21.6807460785, -21.6807407141, -25.4336285591, -25.4336178303}},
	{"h64", Box{-78.75, -77.34375, 14.0625, 15.46875}},
	{"uy57", Box{79.27734375, 79.453125, 38.3203125, 38.671875}},
	{"r5dtqkydk796", Box{-24.3631505594, -24.3631503917, 138.799393661, 138.799393997}},
	{"5j", Box{-61.875, -56.25, -45.0, -33.75}},
	{"xzbszzeu", Box{44.4705963135, 44.4707679749, 169.798851013, 169.799194336}},
	{"wqjz0fj5e", Box{34.9920558929, 34.9920988083, 109.375891685, 109.375934601}},
	{"dekz", Box{19.51171875, 19.6875, -60.8203125, -60.46875}},
	{"bbyux", Box{50.009765625, 50.0537109375, -136.450195312, -136.40625}},
	{"rctysz36", Box{-35.3797531128, -35.3795814514, 177.046394348, 177.046737671}},
	{"xmhvqm1wcw7", Box{29.0765096247, 29.0765109658, 153.206474036, 153.206475377}},
	{"nhw6c", Box{-64.2041015625, -64.16015625, 98.8330078125, 98.876953125}},
	{"u9d3gdu", Box{53.7602233887, 53.7615966797, 25.8233642578, 25.8247375488}},
	{"xenu1tyd0q", Box{17.6100862026, 17.610091567, 167.067042589, 167.067053318}},
	{"qm70t", Box{-15.380859375, -15.3369140625, 105.688476562, 105.732421875}},
	{"3g0", Box{-28.125, -26.71875, -101.25, -99.84375}},
	{"fg", Box{61.875, 67.5, -56.25, -45.0}},
	{"jq1tn6nn0hfs", Box{-55.3590513021, -55.3590511344, 58.642276302, 58.6422766373}},
	{"b9kmw", Box{52.998046875, 53.0419921875, -151.259765625, -151.215820312}},
	{"z7f9pj6", Box{66.2983703613, 66.2997436523, 150.07598877, 150.077362061}},
	{"k", Box{-45.0, 0.0, 0.0, 45.0}},
	{"hqbvrz4x", Box{-51.0687446594, -51.068572998, 12.6486968994, 12.6490402222}},
	{"2", Box{-45.0, 0.0, -180.0, -135.0}},
	{"81es", Box{9.140625, 9.31640625, -175.078125, -174.7265625}},
	{"nyn6mf2", Box{-55.8421325684, -55.8407592773, 132.791748047, 132.793121338}},
	{"6", Box{-45.0, 0.0, -90.0, -45.0}},
	{"46hfqnuv", Box{-78.3165550232, -78.3163833618, -71.8001174927, -71.7997741699}},
	{"7tne", Box{-16.34765625, -16.171875, -13.359375, -13.0078125}},
	{"z7pkduh4g2c", Box{62.6884643734, 62.6884657145, 156.571796089, 156.571797431}},
	{"xgmm", Box{19.16015625, 19.3359375, 176.1328125, 176.484375}},
	{"he054x", Box{-72.5592041016, -72.5537109375, 22.6098632812, 22.6208496094}},
	{"rqnu21r8g", Box{-10.4959344864, -10.495891571, 155.752615929, 155.752658844}},
	{"k8xg8n36", Box{-41.5375900269, -41.5374183655, 33.4001541138, 33.4004974365}},
	{"d60md", Box{12.216796875, 12.2607421875, -78.310546875, -78.2666015625}},
	{"50tqctv", Box{-85.9693908691, -85.9680175781, -37.5444030762, -37.5430297852}},
	{"yxknv54eqnz", Box{86.984847039, 86.9848483801, 118.34842667, 118.348428011}},
	{"5zpczbcjgj", Box{-50.3122490644, -50.3122437, -0.00948429107666, -0.0094735622406}},
	{"yp7nz0rr7d8", Box{86.9704046845, 86.9704060256, 94.5364737511, 94.5364750922}},
	{"kfjb9s772f", Box{-33.6381947994, -33.638189435, 41.9063508511, 41.9063615799}},
	{"q", Box{-45.0, 0.0, 90.0, 135.0}},
	{"cx1f", Box{84.7265625, 84.90234375, -110.0390625, -109.6875}},
	{"y", Box{45.0, 90.0, 90.0, 135.0}},
	{"hdtcdg62524", Box{-75.6559753418, -75.6559740007, 30.7100191712, 30.7100205123}},
	{"fpy32", Box{88.8134765625, 88.857421875, -81.2109375, -81.1669921875}},
	{"256qs", Box{-25.576171875, -25.5322265625, -176.66015625, -176.616210938}},
	{"6rgzd89v3r48", Box{-0.0842052698135, -0.0842051021755, -73.3642389625, -73.3642386273}},
	{"c8430hd23", Box{45.2005434036, 45.200586319, -109.33280468, -109.332761765}},
	{"xtn", Box{28.125, 29.53125, 165.9375, 167.34375}},
	{"1u2s9", Box{-65.302734375, -65.2587890625, -100.502929688, -100.458984375}},
	{"5c80k35m35p", Box{-81.512144208, -81.5121428668, -11.058716923, -11.0587155819}},
	{"5", Box{-90.0, -45.0, -45.0, 0.0}},
	{"u7c0rfsdjn", Box{66.1518037319, 66.1518090963, 13.0032205582, 13.003231287}},
	{"f4ce8gy", Box{61.1045837402, 61.1059570312, -87.8494262695, -87.8480529785}},
	{"pbd4y02", Box{-86.7027282715, -86.7013549805, 171.826171875, 171.827545166}},
	{"9n", Box{33.75, 39.375, -135.0, -123.75}},
	{"ztybk5c8mw", Box{77.4083697796, 77.408375144, 167.170264721, 167.17027545}},
	{"ks8pv0cv5u6j", Box{-18.3201934956, -18.320193328, 22.7222934365, 22.7222937718}},
	{"nuh", Box{-67.5, -66.09375, 129.375, 130.78125}},
	{"6khcf5xumxz", Box{-22.1723856032, -22.1723842621, -71.9715334475, -71.9715321064}},
	{"nj2", Box{-60.46875, -59.0625, 90.0, 91.40625}},
	{"mdd459nebt64", Box{-30.5797721073, -30.5797719397, 70.4752591252, 70.4752594605}},
	{"e7ujxh", Box{22.0825195312, 22.0880126953, -27.8173828125, -27.8063964844}},
	{"eb1zvy9n", Box{1.39904022217, 1.39921188354, -8.53500366211, -8.53466033936}},
	{"1huxmt", Box{-61.9793701172, -61.9738769531, -128.430175781, -128.419189453}},
	{"v4cyrgyg", Box{61.5884971619, 61.5886688232, 47.8107833862, 47.811126709}},
	{"j6h0dvut", Box{-78.6296653748, -78.6294937134, 62.0020294189, 62.0023727417}},
	{"r8j", Box{-45.0, -43.59375, 164.53125, 165.9375}},
	{"feyj018b7", Box{66.9809389114, 66.9809818268, -59.0613412857, -59.0612983704}},
	{"tw33887htf7j", Box{35.4220805503, 35.422080718, 69.2841558158, 69.2841561511}},
	{"3rbgkj8z4cy8", Box{-0.803537517786, -0.803537350148, -122.518374547, -122.518374212}},
	{"gq30gnn9dg", Box{80.3213185072, 80.3213238716, -32.2028696537, -32.2028589249}},
	{"rek4qy2", Box{-26.2889099121, -26.2875366211, 163.421630859, 163.42300415}},
	{"j8", Box{-90.0, -84.375, 67.5, 78.75}},
	{"f2rev1d7", Box{47.0741844177, 47.0743560791, -67.9803085327, -67.97996521}},
	{"rw1sg2f78x", Box{-10.4102808237, -10.4102754593, 159.755308628, 159.755319357}},
	{"r", Box{-45.0, 0.0, 135.0, 180.0}},
	{"8xfw", Box{44.6484375, 44.82421875, -153.984375, -153.6328125}},
	{"fj20", Box{74.53125, 74.70703125, -90.0, -89.6484375}},
	{"m76w867pt9yj", Box{-25.5625145696, -25.562514402, 59.7809752822, 59.7809756175}},
	{"n", Box{-90.0, -45.0, 90.0, 135.0}},
	{"wdb4v9vwt4ez", Box{15.9628918581, 15.9628920257, 112.749471925, 112.74947226}},
	{"m53rvw", Box{-25.3234863281, -25.3179931641, 46.9995117188, 47.0104980469}},
	{"f33", Box{52.03125, 53.4375, -77.34375, -75.9375}},
	{"0t36bun98", Box{-59.9631214142, -59.9630784988, -155.700302124, -155.700259209}},
	{"ezs1", Box{42.36328125, 42.5390625, -5.625, -5.2734375}},
	{"jb", Box{-90.0, -84.375, 78.75, 90.0}},
	{"vd0k", Box{56.953125, 57.12890625, 67.8515625, 68.203125}},
	{"39cqr9bd", Box{-34.0476608276, -34.0474891663, -110.411911011, -110.411567688}},
	{"n8r", Box{-88.59375, -87.1875, 122.34375, 123.75}},
	{"1b6", Box{-88.59375, -87.1875, -98.4375, -97.03125}},
	{"358wn7v3tch", Box{-24.2369502783, -24.2369489372, -134.014754891, -134.01475355}},
	{"d506n2v77qf", Box{17.2312764823, 17.2312778234, -89.366427362, -89.3664260209}},
	{"qb", Box{-45.0, -39.375, 123.75, 135.0}},
	{"sn", Box{33.75, 39.375, 0.0, 11.25}},
	{"5rj", Box{-50.625, -49.21875, -26.71875, -25.3125}},
	{"0y51c", Box{-55.9423828125, -55.8984375, -141.987304688, -141.943359375}},
	{"r85z8", Box{-43.681640625, -43.6376953125, 162.7734375, 162.817382812}},
	{"rk5z", Box{-21.26953125, -21.09375, 151.5234375, 151.875}},
	{"vzn2", Box{84.375, 84.55078125, 87.5390625, 87.890625}},
	{"bjvk", Box{78.046875, 78.22265625, -172.6171875, -172.265625}},
	{"b9f", Box{54.84375, 56.25, -154.6875, -153.28125}},
	{"q0u1y3mu4k", Box{-40.4660582542, -40.4660528898, 95.907651186, 95.9076619148}},
	{"r7", Box{-28.125, -22.5, 146.25, 157.5}},
	{"cv90dz31", Box{76.0653877258, 76.0655593872, -99.7215270996, -99.7211837769}},
	{"gxfeekgv9sng", Box{89.2360430025, 89.2360431701, -18.8363294676, -18.8363291323}},
	{"92t", Box{2.8125, 4.21875, -116.71875, -115.3125}},
	{"m06", Box{-43.59375, -42.1875, 47.8125, 49.21875}},
	{"n27p3f3c", Box{-87.306804657, -87.3066329956, 105.548057556, 105.548400879}},
	{"jjptjwvt2", Box{-60.9581136703, -60.958070755, 55.7961273193, 55.7961702347}},
	{"u258hxwr", Box{45.0424003601, 45.0425720215, 16.3782119751, 16.3785552979}},
	{"t47", Box{12.65625, 14.0625, 49.21875, 50.625}},
	{"e", Box{0.0, 45.0, -45.0, 0.0}},
	{"0s", Box{-67.5, -61.875, -157.5, -146.25}},
	{"4drwu7v94g3", Box{-76.1364381015, -76.1364367604, -56.758684963, -56.7586836219}},
	{"wk14pc", Box{22.8570556641, 22.8625488281, 102.996826172, 103.0078125}},
	{"w5xg", Box{20.21484375, 20.390625, 100.8984375, 101.25}},
	{"f2z2dvf7", Box{49.3387413025, 49.3389129639, -68.4307479858, -68.4304046631}},
	{"duk0212sgtp", Box{23.9579039812, 23.9579053223, -50.6241537631, -50.624152422}},
	{"h7z", Box{-68.90625, -67.5, 21.09375, 22.5}},
	{"31k02yzy90", Box{-37.8866100311, -37.8866046667, -129.331355095, -129.331344366}},
	{"vus0k", Box{70.3564453125, 70.400390625, 84.55078125, 84.5947265625}},
	{"5m0sjm4rrvf", Box{-61.1431337893, -61.1431324482, -32.8127369285, -32.8127355874}},
	{"4syd3n9", Box{-62.8500366211, -62.8486633301, -58.3140563965, -58.3126831055}},
	{"n", Box{-90.0, -45.0, 90.0, 135.0}},
	{"g", Box{45.0, 90.0, -45.0, 0.0}},
	{"ntn69zcu", Box{-61.392288208, -61.3921165466, 121.368370056, 121.368713379}},
	{"vnc4m", Box{83.3642578125, 83.408203125, 46.6259765625, 46.669921875}},
	{"sy848jtk7wdj", Box{37.0329307951, 37.0329309627, 33.7573626637, 33.757362999}},
	{"ry7y", Box{-8.7890625, -8.61328125, 174.0234375, 174.375}},
	{"5k7gesef08j", Box{-65.453453064, -65.4534517229, -28.3175759017, -28.3175745606}},
	{"n5gnev", Box{-67.7362060547, -67.7307128906, 94.3835449219, 94.39453125}},
	{"kz3eeg1trf7", Box{-3.58612284064, -3.58612149954, 36.0265664756, 36.0265678167}},
	{"t55rxfr7", Box{18.2062339783, 18.2064056396, 49.9208450317, 49.9211883545}},
	{"tm9", Box{30.9375, 32.34375, 57.65625, 59.0625}},
	{"pjw", Box{-59.0625, -57.65625, 143.4375, 144.84375}},
	{"f", Box{45.0, 90.0, -90.0, -45.0}},
	{"2my", Box{-12.65625, -11.25, -160.3125, -158.90625}},
	{"3w6bwyt", Box{-9.72015380859, -9.71878051758, -108.329315186, -108.327941895}},
	{"v4s8r3q", Box{59.1133117676, 59.1146850586, 51.6549682617, 51.6563415527}},
	{"ggx8be488kyn", Box{64.8359277472, 64.8359279148, -0.677700340748, -0.677700005472}},
	{"95w", Box{19.6875, 21.09375, -126.5625, -125.15625}},
	{"9jck7spubf", Box{33.1136190891, 33.1136244535, -133.077703714, -133.077692986}},
	{"f1zfe", Box{55.283203125, 55.3271484375, -78.9697265625, -78.92578125}},
	{"p5ycnk9j", Box{-68.7048912048, -68.7047195435, 144.768218994, 144.768562317}},
	{"v", Box{45.0, 90.0, 45.0, 90.0}},
	{"zk", Box{67.5, 73.125, 146.25, 157.5}},
	{"rkq7z", Box{-20.4345703125, -20.390625, 155.346679688, 155.390625}},
	{"j5wsc3t4", Box{-69.4689559937, -69.4687843323, 54.2024230957, 54.2027664185}},
	{"56szw", Box{-74.619140625, -74.5751953125, -26.806640625, -26.7626953125}},
	{"6xp21s7", Box{-5.60165405273, -5.60028076172, -57.2346496582, -57.2332763672}},
	{"gbmymdgc5x", Box{47.520198226, 47.5202035904, -2.91706323624, -2.9170525074}},
	{"bmm935md5m", Box{74.7691994905, 74.769204855, -160.963987112, -160.963976383}},
	{"z2v55d8", Box{49.7598266602, 49.7611999512, 153.435058594, 153.436431885}},
	{"q232vgb0", Box{-43.4413146973, -43.4411430359, 103.260498047, 103.26084137}},
	{"b7kf7b5uz4", Box{63.6775839329, 63.6775892973, -161.900067329, -161.900056601}},
	{"y6", Box{56.25, 61.875, 101.25, 112.5}},
	{"3xdf2ts4d", Box{-2.38635063171, -2.38630771637, -108.605260849, -108.605217934}},
	{"0szy1551", Box{-62.2099113464, -62.2097396851, -146.553497314, -146.553153992}},
	{"z", Box{45.0, 90.0, 135.0, 180.0}},
	{"kk86s", Box{-19.248046875, -19.2041015625, 11.77734375, 11.8212890625}},
	{"tqq", Box{35.15625, 36.5625, 64.6875, 66.09375}},
	{"3gcy97b", Box{-22.7430725098, -22.7416992188, -98.7341308594, -98.7327575684}},
	{"5dnz5z1d", Box{-77.4807357788, -77.4805641174, -12.8409576416, -12.8406143188}},
	{"eumv1pe", Box{24.8263549805, 24.8277282715, -3.11599731445, -3.11462402344}},
	{"2kxmbgqtfc3", Box{-18.6579112709, -18.6579099298, -158.512682766, -158.512681425}},
	{"hc5uf211rpb", Box{-83.5397829115, -83.5397815704, 39.1239881516, 39.1239894927}},
	{"p4khbd21", Box{-76.496257782, -76.4960861206, 140.646972656, 140.647315979}},
	{"xuq", Box{23.90625, 25.3125, 177.1875, 178.59375}},
	{"gn63cf91nhf", Box{80.47779724, 80.4777985811, -41.7573997378, -41.7573983967}},
	{"5hd1nh3", Box{-64.4883728027, -64.4869995117, -41.922454834, -41.921081543}},
	{"ustjn5", Box{71.2078857422, 71.2133789062, 29.794921875, 29.8059082031}},
	{"btv2", Box{77.34375, 77.51953125, -150.1171875, -149.765625}},
	{"7ds5rkh3u1", Box{-30.3439325094, -30.343927145, -16.5503883362, -16.5503776073}},
	{"54", Box{-78.75, -73.125, -45.0, -33.75}},
	{"7sr", Box{-21.09375, -19.6875, -12.65625, -11.25}},
	{"kr552fbb", Box{-5.03860473633, -5.03843307495, 15.5027389526, 15.5030822754}},
	{"8uc453nv4qq4", Box{27.0766978338, 27.0766980015, -144.691553414, -144.691553079}},
	{"6n3m", Box{-8.96484375, -8.7890625, -88.2421875, -87.890625}},
	{"rptzf8", Box{-1.4501953125, -1.44470214844, 143.195800781, 143.206787109}},
	{"x63b", Box{12.65625, 12.83203125, 148.7109375, 149.0625}},
	{"qwj7353", Box{-10.6608581543, -10.6594848633, 119.928131104, 119.929504395}},
	{"j", Box{-90.0, -45.0, 45.0, 90.0}},
	{"v6", Box{56.25, 61.875, 56.25, 67.5}},
	{"5mpwtp", Box{-60.6939697266, -60.6884765625, -22.9833984375, -22.9724121094}},
	{"ukgs", Box{72.421875, 72.59765625, 16.171875, 16.5234375}},
	{"qxyb4g6qf", Box{-1.3872385025, -1.38719558716, 122.116212845, 122.11625576}},
	{"qhww7zdb5v", Box{-18.5476416349, -18.5476362705, 99.3093574047, 99.3093681335}},
	{"wfwffcw5vd", Box{14.5547926426, 14.554798007, 133.37151289, 133.371523619}},
	{"rynp", Box{-10.01953125, -9.84375, 177.1875, 177.5390625}},
	{"fb57ykxryn82", Box{45.6852641702, 45.6852643378, -51.3948151097, -51.3948147744}},
	{"30sq", Box{-41.1328125, -40.95703125, -129.0234375, -128.671875}},
	{"9", Box{0.0, 45.0, -135.0, -90.0}},
	{"e5gjz7", Box{22.1209716797, 22.1264648438, -40.4626464844, -40.4516601562}},
	{"t6vkbx", Box{16.3421630859, 16.34765625, 63.6547851562, 63.6657714844}},
	{"3e", Box{-28.125, -22.5, -112.5, -101.25}},
	{"th", Box{22.5, 28.125, 45.0, 56.25}},
	{"7j", Box{-16.875, -11.25, -45.0, -33.75}},
	{"2", Box{-45.0, 0.0, -180.0, -135.0}},
	{"1r15z2z5", Box{-49.9611854553, -49.9610137939, -122.015533447, -122.015190125}},
	{"k9e57kg2f3", Box{-35.9649842978, -35.9649789333, 26.866132021, 26.8661427498}},
	{"4w", Box{-56.25, -50.625, -67.5, -56.25}},
	{"82c582qhsx7", Box{4.83616903424, 4.83617037535, -167.324326783, -167.324325442}},
	{"qzdzkwwdc", Box{-1.50190830231, -1.50186538696, 127.823910713, 127.823953629}},
	{"6xn26p6fnr0", Box{-5.54084837437, -5.54084703326, -58.6190021038, -58.6190007627}},
	{"wm4y0xu8ee", Box{29.2223614454, 29.2223668098, 105.14549017, 105.145500898}},
	{"rke5rewv", Box{-19.0961265564, -19.095954895, 150.807609558, 150.807952881}},
	{"0bn3vwcjj", Box{-89.6544456482, -89.6544027328, -137.217650414, -137.217607498}},
	{"5", Box{-90.0, -45.0, -45.0, 0.0}},
	{"red", Box{-25.3125, -23.90625, 160.3125, 161.71875}},
	{"r2", Box{-45.0, -39.375, 146.25, 157.5}},
	{"v7qptt2u5k", Box{64.6291565895, 64.6291619539, 64.9303686619, 64.9303793907}},
	{"pey", Box{-68.90625, -67.5, 165.9375, 167.34375}},
	{"r7cg5cz8", Box{-23.3692932129, -23.3691215515, 148.886032104, 148.886375427}},
	{"9", Box{0.0, 45.0, -135.0, -90.0}},
	{"qqr5mxz", Box{-9.22988891602, -9.228515625, 111.345062256, 111.346435547}},
	{"wuuvdz7x2", Box{27.7266168594, 27.7266597748, 130.555343628, 130.555386543}},
	{"t", Box{0.0, 45.0, 45.0, 90.0}},
	{"4mgwkd9yp3r5", Box{-56.5428471006, -56.542846933, -73.6276473105, -73.6276469752}},
	{"dpk6jbemhyvh", Box{41.1364542693, 41.1364544369, -83.7660782039, -83.7660778686}},
	{"768py6th4818", Box{-29.5607757568, -29.5607755892, -33.4683660418, -33.4683657065}},
	{"q8", Box{-45.0, -39.375, 112.5, 123.75}},
	{"xmgvmq9cf", Box{33.3026075363, 33.3026504517, 151.756639481, 151.756682396}},
	{"6rhhdy3", Box{-4.79965209961, -4.79827880859, -73.0027770996, -73.0014038086}},
	{"05dd6myj4xqj", Box{-69.884508457, -69.8845082894, -176.377142966, -176.377142631}},
	{"yw6", Box{80.15625, 81.5625, 115.3125, 116.71875}},
	{"6mt6h4jrw", Box{-13.6986637115, -13.6986207962, -71.1839389801, -71.1838960648}},
	{"86ymqv2s", Box{16.4211273193, 16.4212989807, -159.663619995, -159.663276672}},
	{"vygq9vr6umc", Box{84.1406701505, 84.1406714916, 83.4073568881, 83.4073582292}},
	{"89g6sp8p81", Box{10.3256946802, 10.3257000446, -152.75390625, -152.753895521}},
	{"w", Box{0.0, 45.0, 90.0, 135.0}},
	{"6st", Box{-19.6875, -18.28125, -60.46875, -59.0625}},
	{"v", Box{45.0, 90.0, 45.0, 90.0}},
	{"sk", Box{22.5, 28.125, 11.25, 22.5}},
	{"t", Box{0.0, 45.0, 45.0, 90.0}},
	{"2", Box{-45.0, 0.0, -180.0, -135.0}},
	{"f3pf69r61v4", Box{51.0277444124, 51.0277457535, -67.7316650748, -67.7316637337}},
	{"r9qde0cj", Box{-37.5243186951, -37.5241470337, 166.773834229, 166.774177551}},
	{"nbm5pqh", Box{-88.0334472656, -88.0320739746, 131.10534668, 131.106719971}},
	{"u7f9fh2dzpw9", Box{66.4252256043, 66.425225772, 14.8545113951, 14.8545117304}},
	{"pnzr19j29", Box{-50.7952022552, -50.7951593399, 145.268483162, 145.268526077}},
	{"3e7rf8ww4fe5", Box{-25.3526548482, -25.3526546806, -107.810775787, -107.810775451}},
	{"1x", Box{-50.625, -45.0, -112.5, -101.25}},
	{"4", Box{-90.0, -45.0, -90.0, -45.0}},
	{"4h4swejxpzv", Box{-66.6912616789, -66.6912603378, -86.1908380687, -86.1908367276}},
	{"hy6gnf0u", Box{-54.3047332764, -54.304561615, 37.9148483276, 37.9151916504}},
	{"xnycujudf", Box{38.3084249496, 38.308467865, 144.67423439, 144.674277306}},
	{"t6bypmux9z54", Box{16.5563485399, 16.5563487075, 57.6295499504, 57.6295502856}},
	{"ufw1c6xp2t", Box{59.3851214647, 59.3851268291, 42.2520661354, 42.2520768642}},
	{"42jpxwe9byn", Box{-88.6456024647, -88.6456011236, -71.3843134046, -71.3843120635}},
	{"5", Box{-90.0, -45.0, -45.0, 0.0}},
	{"tj0de", Box{28.564453125, 28.6083984375, 45.8349609375, 45.87890625}},
	{"e0kqd", Box{2.548828125, 2.5927734375, -38.935546875, -38.8916015625}},
	{"bzysgj0rr", Box{89.4574213028, 89.4574642181, -136.976895332, -136.976852417}},
	{"bxdp8ycgtcqt", Box{88.543546591, 88.5435467586, -154.651882276, -154.651881941}},
	{"k0kx2785", Box{-42.2995948792, -42.2994232178, 6.33911132812, 6.33945465088}},
	{"75ugg", Box{-23.2470703125, -23.203125, -38.1884765625, -38.14453125}},
	{"sbbsbv2r", Box{5.08375167847, 5.08392333984, 34.4864273071, 34.4867706299}},
	{"u7vunvq7rn", Box{66.8263041973, 66.8263095617, 19.6414518356, 19.6414625645}},
	{"w4m7uexcx", Box{13.3349132538, 13.3349561691, 97.591509819, 97.5915527344}},
	{"350g", Box{-27.59765625, -27.421875, -133.9453125, -133.59375}},
	{"p", Box{-90.0, -45.0, 135.0, 180.0}},
	{"t8w2g1m1", Box{2.95137405396, 2.95154571533, 76.4277648926, 76.4281082153}},
	{"96k738f", Box{13.2316589355, 13.2330322266, -117.704772949, -117.703399658}},
	{"c26nv174", Box{47.5999832153, 47.6001548767, -120.713653564, -120.713310242}},
	{"s67g9ehvds", Box{13.2889294624, 13.2889348269, 16.5959858894, 16.5959966183}},
	{"4ybt4sw", Box{-51.1276245117, -51.1262512207, -55.4287719727, -55.4273986816}},
	{"5jqnz9zqyk12", Box{-59.2714333534, -59.2714331858, -36.2226838991, -36.2226835638}},
	{"31d5nguy", Box{-36.0135269165, -36.0133552551, -131.884346008, -131.884002686}},
	{"m4bbcg", Box{-29.3829345703, -29.3774414062, 46.1315917969, 46.142578125}},
	{"u", Box{45.0, 90.0, 0.0, 45.0}},
	{"mkx0hzzq", Box{-19.6438980103, -19.6437263489, 66.3124465942, 66.312789917}},
	{"9bv7x0", Box{4.833984375, 4.83947753906, -93.5595703125, -93.5485839844}},
	{"k", Box{-45.0, 0.0, 0.0, 45.0}},
	{"0x7pv0083h", Box{-47.8563809395, -47.8563755751, -153.060793877, -153.060783148}},
	{"ruqzw0ztgw", Box{-19.7702515125, -19.7702461481, 178.516309261, 178.51631999}},
	{"xpy5c3c", Box{44.2625427246, 44.2639160156, 143.493804932, 143.495178223}},
	{"bnn6fxqm", Box{79.2740821838, 79.2742538452, -171.09249115, -171.092147827}},
	{"fnm9u1t", Box{80.4721069336, 80.4734802246, -82.0829772949, -82.0816040039}},
	{"jfvn54", Box{-73.4655761719, -73.4600830078, 85.9130859375, 85.9240722656}},
	{"dj", Box{28.125, 33.75, -90.0, -78.75}},
	{"mxfstk2s", Box{-0.591201782227, -0.59103012085, 71.2470245361, 71.2473678589}},
	{"v", Box{45.0, 90.0, 45.0, 90.0}},
	{"4xy4p", Box{-46.0546875, -46.0107421875, -58.7548828125, -58.7109375}},
	{"cbdg47d", Box{48.3590698242, 48.3604431152, -97.2811889648, -97.2798156738}},
	{"1ddv9", Box{-74.970703125, -74.9267578125, -108.588867188, -108.544921875}},
	{"4cn07cd", Box{-84.3228149414, -84.3214416504, -47.6449584961, -47.6435852051}},
	{"dq8fjtv64n", Box{36.9460237026, 36.946029067, -77.4463176727, -77.4463069439}},
	{"gx2qc4", Box{86.9787597656, 86.9842529297, -22.1044921875, -22.0935058594}},
	{"yx", Box{84.375, 90.0, 112.5, 123.75}},
	{"44", Box{-78.75, -73.125, -90.0, -78.75}},
	{"zz679sbs", Box{86.4232635498, 86.4234352112, 171.980667114, 171.981010437}},
	{"2fdh2u769u7y", Box{-30.1666307822, -30.1666306145, -143.399997689, -143.399997354}},
	{"k", Box{-45.0, 0.0, 0.0, 45.0}},
	{"11cxx", Box{-78.837890625, -78.7939453125, -132.583007812, -132.5390625}},
	{"ygf2", Box{66.09375, 66.26953125, 126.9140625, 127.265625}},
	{"m0uscc", Box{-39.9407958984, -39.9353027344, 51.4050292969, 51.416015625}},
	{"y", Box{45.0, 90.0, 90.0, 135.0}},
	{"kn2m", Box{-8.96484375, -8.7890625, 0.3515625, 0.703125}},
	{"k56d043m45", Box{-26.3539534807, -26.3539481163, 3.51742744446, 3.51743817329}},
	{"m7", Box{-28.125, -22.5, 56.25, 67.5}},
	{"pwe", Box{-53.4375, -52.03125, 161.71875, 163.125}},
	{"1j7q0hs8u", Box{-59.3892145157, -59.3891716003, -130.423336029, -130.423293114}},
	{"f264077wzn", Box{46.776856184, 46.7768615484, -75.9214067459, -75.9213960171}},
	{"2jvn", Box{-11.6015625, -11.42578125, -172.96875, -172.6171875}},
	{"4d4ghmzzsjb9", Box{-78.1897520833, -78.1897519156, -63.4352295846, -63.4352292493}},
	{"1h2n6vef0we", Box{-64.9645265937, -64.9645252526, -134.873975068, -134.873973727}},
	{"vnfc1v2yh", Box{83.1744003296, 83.1744432449, 48.9452934265, 48.9453363419}},
	{"2b5brk", Box{-44.9340820312, -44.9285888672, -140.657958984, -140.646972656}},
	{"yntb", Box{81.5625, 81.73828125, 98.0859375, 98.4375}},
	{"5fj85yy", Box{-78.7129211426, -78.7115478516, -3.34259033203, -3.34121704102}},
	{"cm36wevqn", Box{74.9923324585, 74.9923753738, -121.699075699, -121.699032784}},
	{"7hf52n", Box{-17.6770019531, -17.6715087891, -42.1875, -42.1765136719}},
	{"dh1sz", Box{23.3349609375, 23.37890625, -87.5830078125, -87.5390625}},
	{"h", Box{-90.0, -45.0, 0.0, 45.0}},
	{"7ny5k0k28", Box{-6.4585018158, -6.45845890045, -36.3808822632, -36.3808393478}},
	{"w7", Box{16.875, 22.5, 101.25, 112.5}},
	{"f9j0296wjz", Box{50.6768792868, 50.6768846512, -60.443097353, -60.4430866241}},
	{"v316n9gu7y5", Box{50.9869372845, 50.9869386256, 58.2987718284, 58.2987731695}},
	{"9", Box{0.0, 45.0, -135.0, -90.0}},
	{"0jt97bxt", Box{-58.8391685486, -58.8389968872, -172.090530396, -172.090187073}},
	{"cfdbvrc", Box{59.236907959, 59.23828125, -97.1507263184, -97.1493530273}},
	{"95d", Box{19.6875, 21.09375, -132.1875, -130.78125}},
	{"my", Box{-11.25, -5.625, 78.75, 90.0}},
	{"5t", Box{-61.875, -56.25, -22.5, -11.25}},
	{"n", Box{-90.0, -45.0, 90.0, 135.0}},
	{"4", Box{-90.0, -45.0, -90.0, -45.0}},
	{"k2j", Box{-45.0, -43.59375, 18.28125, 19.6875}},
	{"rjygh", Box{-12.12890625, -12.0849609375, 144.66796875, 144.711914062}},
	{"xs79f", Box{24.2138671875, 24.2578125, 162.509765625, 162.553710938}},
	{"nmz3x305vedq", Box{-57.3864214495, -57.3864212818, 111.764155068, 111.764155403}},
	{"u1hq", Box{51.6796875, 51.85546875, 5.9765625, 6.328125}},
	{"2v8jpgs92zxm", Box{-13.1641120277, -13.1641118601, -145.903202109, -145.903201774}},
	{"f54n04uq", Box{62.9458236694, 62.9459953308, -87.1816635132, -87.1813201904}},
	{"8zkv13p8", Box{41.6656494141, 41.6658210754, -139.505081177, -139.504737854}},
	{"z03j6ktm2", Box{47.354722023, 47.3547649384, 136.512336731, 136.512379646}},
	{"qd266u", Box{-31.9262695312, -31.9207763672, 112.972412109, 112.983398438}},
	{"783q5", Box{-42.5390625, -42.4951171875, -20.6103515625, -20.56640625}},
	{"ynqe7fy5s9m6", Box{80.7432531193, 80.7432532869, 99.3138598278, 99.3138601631}},
	{"pp", Box{-50.625, -45.0, 135.0, 146.25}},
	{"bd", Box{56.25, 61.875, -157.5, -146.25}},
	{"8573xzmt2qy", Box{18.5856847465, 18.5856860876, -175.081539452, -175.081538111}},
	{"gwhbzrftu0", Box{78.9253950119, 78.9254003763, -15.4981040955, -15.4980933666}},
	{"h42w9e805", Box{-76.1819458008, -76.1819028854, 0.769171714783, 0.769214630127}},
	{"uzbhd66135d1", Box{89.397358764, 89.3973589316, 33.8516691327, 33.851669468}},
	{"zf", Box{56.25, 61.875, 168.75, 180.0}},
	{"6q2r", Box{-8.61328125, -8.4375, -78.3984375, -78.046875}},
	{"qtxy7v4w9", Box{-12.9352855682, -12.9352426529, 123.566708565, 123.56675148}},
	{"58", Box{-90.0, -84.375, -22.5, -11.25}},
	{"r", Box{-45.0, 0.0, 135.0, 180.0}},
	{"8u9qjb5qw", Box{26.368303299, 26.3683462143, -144.234781265, -144.23473835}},
	{"48sx", Box{-85.95703125, -85.78125, -61.171875, -60.8203125}},
	{"690tdt6", Box{-38.3793640137, -38.3779907227, -66.6842651367, -66.6828918457}},
	{"qm8", Box{-14.0625, -12.65625, 101.25, 102.65625}},
	{"2mj", Box{-16.875, -15.46875, -161.71875, -160.3125}},
	{"3e5", Box{-28.125, -26.71875, -108.28125, -106.875}},
	{"t", Box{0.0, 45.0, 45.0, 90.0}},
	{"f6dg1tndqxy", Box{59.6177373827, 59.6177387238, -74.8076811433, -74.8076798022}},
	{"c", Box{45.0, 90.0, -135.0, -90.0}},
	{"9f3eqkhmf", Box{13.2504987717, 13.250541687, -98.8600444794, -98.860001564}},
	{"yuqghk1x5z", Box{69.4568055868, 69.4568109512, 133.431175947, 133.431186676}},
	{"w30rynrjmy", Box{7.02257037163, 7.02257573605, 101.875094175, 101.875104904}},
	{"m25ergh6", Box{-44.4118881226, -44.4117164612, 61.5182876587, 61.5186309814}},
	{"jqznhq", Box{-50.9436035156, -50.9381103516, 66.2805175781, 66.2915039062}},
	{"3u4", Box{-22.5, -21.09375, -98.4375, -97.03125}},
	{"fzr", Box{85.78125, 87.1875, -46.40625, -45.0}},
	{"je", Box{-73.125, -67.5, 67.5, 78.75}},
	{"pmztf5q7e7d4", Box{-56.6270351037, -56.6270349361, 156.893490851, 156.893491186}},
	{"xdknsz", Box{13.8372802734, 13.8427734375, 163.333740234, 163.344726562}},
	{"736h1c7d5h", Box{-37.2583937645, -37.2583884001, -30.8556604385, -30.8556497097}},
	{"c57pmmv9u", Box{64.5875501633, 64.5875930786, -130.542812347, -130.542769432}},
	{"80qnjsh", Box{2.48291015625, 2.48428344727, -171.315307617, -171.313934326}},
	{"kp", Box{-5.625, 0.0, 0.0, 11.25}},
	{"u6yufbthbdw", Box{61.3072863221, 61.3072876632, 20.8699330688, 20.8699344099}},
	{"c4yj93f16ys", Box{61.4454093575, 61.4454106987, -126.504698396, -126.504697055}},
	{"ygkp", Box{64.51171875, 64.6875, 129.375, 129.7265625}},
	{"h1ypf", Box{-78.7939453125, -78.75, 8.525390625, 8.5693359375}},
	{"hz76my5h4qe", Box{-48.7895616889, -48.7895603478, 38.5772185028, 38.5772198439}},
	{"zh1cw", Box{67.763671875, 67.8076171875, 137.724609375, 137.768554688}},
	{"00", Box{-90.0, -84.375, -180.0, -168.75}},
	{"h9be5u0k", Box{-79.6062469482, -79.6060752869, 23.3682632446, 23.3686065674}},
	{"4btv", Box{-86.30859375, -86.1328125, -48.1640625, -47.8125}},
	{"42hz7pm83dt", Box{-88.6857041717, -88.6857028306, -71.9308523834, -71.9308510423}},
	{"qv49", Box{-16.69921875, -16.5234375, 127.265625, 127.6171875}},
	{"0nwzwd", Box{-52.1081542969, -52.1026611328, -170.222167969, -170.211181641}},
	{"jhkmc", Box{-65.0830078125, -65.0390625, 51.0205078125, 51.064453125}},
	{"sysens0py", Box{37.1131467819, 37.1131896973, 40.3640270233, 40.3640699387}},
	{"5q792kbf", Box{-54.5975875854, -54.5974159241, -28.8161087036, -28.8157653809}},
	{"624gbe", Box{-44.3243408203, -44.3188476562, -74.8608398438, -74.8498535156}},
	{"gtkjfqg", Box{75.5790710449, 75.5804443359, -16.7720031738, -16.7706298828}},
	{"nv4", Box{-61.875, -60.46875, 126.5625, 127.96875}},
	{"dcwv6uu0", Box{9.3864440918, 9.38661575317, -46.6314697266, -46.6311264038}},
	{"vvgtyfv9", Box{78.36977005, 78.3699417114, 83.97605896, 83.9764022827}},
	{"53rjpqr6zt9", Box{-82.0550099015, -82.0550085604, -23.5773669183, -23.5773655772}},
	{"vmyp4dnemp6", Box{78.5858018696, 78.5858032107, 64.8065069318, 64.8065082729}},
	{"t9xqjxjpv", Box{9.53197002411, 9.53201293945, 77.9440927505, 77.9441356659}},
	{"sby32e", Box{4.45495605469, 4.46044921875, 42.5610351562, 42.5720214844}},
	{"sjfgy", Box{33.0029296875, 33.046875, 4.130859375, 4.1748046875}},
	{"k7q0z2b2du", Box{-26.5826869011, -26.5826815367, 20.0065648556, 20.0065755844}},
	{"nt", Box{-61.875, -56.25, 112.5, 123.75}},
	{"1", Box{-90.0, -45.0, -135.0, -90.0}},
	{"mpfpfd32e", Box{-0.0314998626709, -0.0314569473267, 47.9242086411, 47.9242515564}},
	{"hqjqn", Box{-55.1953125, -55.1513671875, 18.896484375, 18.9404296875}},
	{"9q7chj6u2uw", Box{35.3616240621, 35.3616254032, -118.296964467, -118.296963125}},
	{"0wsf47v9c", Box{-53.0650377274, -53.064994812, -150.713839531, -150.713796616}},
	{"kdv72env8xke", Box{-28.9424979128, -28.9424977452, 29.9140823632, 29.9140826985}},
	{"trfx", Box{44.82421875, 45.0, 59.765625, 60.1171875}},
	{"02uttm", Box{-84.7869873047, -84.7814941406, -162.191162109, -162.180175781}},
	{"hhjgb5s3vv39", Box{-66.8212655, -66.8212653324, 8.0920227617, 8.09202309698}},
	{"r16", Box{-37.96875, -36.5625, 137.8125, 139.21875}},
	{"4xy44eer4t3", Box{-46.0342316329, -46.0342302918, -58.9480648935, -58.9480635524}},
	{"8b", Box{0.0, 5.625, -146.25, -135.0}},
	{"zd", Box{56.25, 61.875, 157.5, 168.75}},
	{"z0x", Box{47.8125, 49.21875, 144.84375, 146.25}},
	{"4967", Box{-82.44140625, -82.265625, -64.3359375, -63.984375}},
	{"2vf4", Box{-12.3046875, -12.12890625, -143.4375, -143.0859375}},
	{"tzp3t0rtg", Box{39.6410322189, 39.6410751343, 89.1754674911, 89.1755104065}},
	{"75yry", Box{-22.5439453125, -22.5, -35.947265625, -35.9033203125}},
	{"bdgtu", Box{61.4794921875, 61.5234375, -152.40234375, -152.358398438}},
	{"u1", Box{50.625, 56.25, 0.0, 11.25}},
	{"rz2bgp7hds", Box{-4.04629468918, -4.04628932476, 169.940750599, 169.940761328}},
	{"g", Box{45.0, 90.0, -45.0, 0.0}},
	{"psptppx32e", Box{-66.5796643496, -66.5796589851, 168.364470005, 168.364480734}},
	{"gshfctpwf1", Box{68.0120283365, 68.0120337009, -15.7440090179, -15.7439982891}},
	{"3yq", Box{-9.84375, -8.4375, -92.8125, -91.40625}},
	{"685zv36e0fd2", Box{-43.6303004622, -43.6303002946, -61.9923811778, -61.9923808426}},
	{"7gf5fd", Box{-23.2360839844, -23.2305908203, -8.32763671875, -8.31665039062}},
	{"bmmzfq", Box{75.9265136719, 75.9320068359, -160.565185547, -160.554199219}},
	{"m40", Box{-33.75, -32.34375, 45.0, 46.40625}},
	{"tx45501g7v", Box{39.9029284716, 39.902933836, 70.4469001293, 70.4469108582}},
	{"u", Box{45.0, 90.0, 0.0, 45.0}},
	{"ej054jn", Box{28.6798095703, 28.6811828613, -44.9038696289, -44.9024963379}},
	{"n1g7d", Box{-79.541015625, -79.4970703125, 94.658203125, 94.7021484375}},
	{"nn6ejehuf", Box{-54.2991113663, -54.2990684509, 93.7639331818, 93.7639760971}},
	{"qs8e93xwrrc", Box{-19.0629114211, -19.06291008, 113.268668801, 113.268670142}},
	{"f2", Box{45.0, 50.625, -78.75, -67.5}},
	{"gm", Box{73.125, 78.75, -33.75, -22.5}},
	{"npp4rnm", Box{-50.1951599121, -50.1937866211, 100.158233643, 100.159606934}},
	{"6t", Box{-16.875, -11.25, -67.5, -56.25}},
	{"2f4fe3d5", Box{-33.3017921448, -33.3016204834, -142.237243652, -142.23690033}},
	{"s7r00k0196", Box{18.3034908772, 18.3034962416, 21.1047899723, 21.1048007011}},
	{"st084", Box{28.125, 28.1689453125, 23.291015625, 23.3349609375}},
	{"p6f3bv9f1", Box{-74.1930770874, -74.1930341721, 149.449467659, 149.449510574}},
	{"fgk5j", Box{63.80859375, 63.8525390625, -50.4052734375, -50.361328125}},
	{"yeu22jjtp", Box{66.1660194397, 66.166062355, 118.484416008, 118.484458923}},
	{"3bcn7gkusn25", Box{-39.6639578976, -39.6639577299, -99.6722602844, -99.6722599491}},
	{"1", Box{-90.0, -45.0, -135.0, -90.0}},
	{"6q4dh71sqn", Box{-10.8811962605, -10.881190896, -75.0452899933, -75.0452792645}},
	{"p", Box{-90.0, -45.0, 135.0, 180.0}},
	{"6uy2kbef9yg", Box{-18.2340927422, -18.2340914011, -47.2469682992, -47.246966958}},
	{"58j", Box{-90.0, -88.59375, -15.46875, -14.0625}},
	{"j", Box{-90.0, -45.0, 45.0, 90.0}},
	{"mh6x", Box{-19.86328125, -19.6875, 48.515625, 48.8671875}},
	{"cgq4xrjz", Box{63.7603569031, 63.7605285645, -92.486000061, -92.4856567383}},
	{"n", Box{-90.0, -45.0, 90.0, 135.0}},
	{"ppqg570sk3n", Box{-48.6741918325, -48.6741904914, 144.635886848, 144.635888189}},
	{"1suyu1k", Box{-62.0878601074, -62.0864868164, -105.639038086, -105.637664795}},
	{"xm4xkzsnvux", Box{29.4417956471, 29.4417969882, 149.980114549, 149.980115891}},
	{"8p3xj", Box{42.01171875, 42.0556640625, -177.670898438, -177.626953125}},
	{"ef92nkk", Box{14.0858459473, 14.0872192383, -9.21203613281, -9.2106628418}},
	{"qnrf101", Box{-9.4921875, -9.49081420898, 100.943756104, 100.945129395}},
	{"2qt", Box{-8.4375, -7.03125, -161.71875, -160.3125}},
	{"c2q7e", Box{47.021484375, 47.0654296875, -114.829101562, -114.78515625}},
	{"w", Box{0.0, 45.0, 90.0, 135.0}},
	{"j6t0bwpjpusg", Box{-75.7718221284, -75.7718219608, 63.3131746575, 63.3131749928}},
	{"wrq", Box{40.78125, 42.1875, 109.6875, 111.09375}},
	{"xvf2jk", Box{32.3657226562, 32.3712158203, 172.144775391, 172.155761719}},
	{"xy0p5y", Box{35.0134277344, 35.0189208984, 168.914794922, 168.92578125}},
	{"bsh9xbd", Box{67.766418457, 67.767791748, -150.828552246, -150.827178955}},
	{"g675yc", Box{58.3209228516, 58.3264160156, -29.2346191406, -29.2236328125}},
	{"dkrnq7", Box{25.0213623047, 25.0268554688, -68.6315917969, -68.6206054688}},
	{"6q4uk3dyk5", Box{-10.4936009645, -10.4935956001, -74.6920967102, -74.6920859814}},
	{"t58tp1kxb54p", Box{20.5746203475, 20.5746205151, 46.0169246793, 46.0169250146}},
	{"bbw73yzeuy", Box{48.4215438366, 48.421549201, -137.373529673, -137.373518944}},
	{"gnq", Box{80.15625, 81.5625, -36.5625, -35.15625}},
	{"3j", Box{-16.875, -11.25, -135.0, -123.75}},
	{"7dx2c", Box{-30.8056640625, -30.76171875, -12.2607421875, -12.216796875}},
	{"vn9", Box{81.5625, 82.96875, 46.40625, 47.8125}},
	{"4kj", Box{-67.5, -66.09375, -71.71875, -70.3125}},
	{"cuvj4trg5nb8", Box{72.6270465553, 72.6270467229, -94.0981142968, -94.0981139615}},
	{"uetmbuswe", Box{65.7240772247, 65.7241201401, 29.92208004, 29.9221229553}},
	{"z", Box{45.0, 90.0, 135.0, 180.0}},
	{"f", Box{45.0, 90.0, -90.0, -45.0}},
	{"jg", Box{-73.125, -67.5, 78.75, 90.0}},
	{"ycz", Box{54.84375, 56.25, 133.59375, 135.0}},
	{"pevtd", Box{-67.939453125, -67.8955078125, 165.322265625, 165.366210938}},
	{"gf7fm3hmb8", Box{58.0582380295, 58.0582433939, -5.73999166489, -5.73998093605}},
	{"w7zwjnh24qd", Box{22.1814313531, 22.1814326942, 112.022537291, 112.022538632}},
	{"nfesgy", Box{-75.0695800781, -75.0640869141, 128.836669922, 128.84765625}},
	{"s", Box{0.0, 45.0, 0.0, 45.0}},
	{"efq0q0dg0g0n", Box{12.7034739777, 12.7034741454, -2.5450193882, -2.54501905292}},
	{"kkucr8pk", Box{-18.060836792, -18.0606651306, 18.2692337036, 18.2695770264}},
	{"5zdg4zvz", Box{-47.2413825989, -47.2412109375, -7.25406646729, -7.25372314453}},
	{"fuw", Box{70.3125, 71.71875, -47.8125, -46.40625}},
	{"x51mnftp8", Box{17.7689266205, 17.7689695358, 137.061309814, 137.06135273}},
	{"y0", Box{45.0, 50.625, 90.0, 101.25}},
	{"ndufku4sr", Box{-74.1130399704, -74.1129970551, 119.392161369, 119.392204285}},
	{"ydwndhywhg8", Box{60.232219398, 60.2322207391, 121.034520864, 121.034522206}},
	{"gj6ehkq0", Box{75.0819396973, 75.0821113586, -41.2893676758, -41.289024353}},
	{"m3hfct0", Box{-38.8641357422, -38.8627624512, 62.9956054688, 62.9969787598}},
	{"6745yupp70qu", Box{-27.4426010996, -27.442600932, -75.631118305, -75.6311179698}},
	{"d7b0m9dzj213", Box{21.1471368559, 21.1471370235, -78.504297249, -78.5042969137}},
	{"py", Box{-56.25, -50.625, 168.75, 180.0}},
	{"4vhrpypw", Box{-60.6105422974, -60.610370636, -49.9225616455, -49.9222183228}},
	{"xwyyj1xz5kzw", Box{39.0329053625, 39.0329055302, 167.222706601, 167.222706936}},
	{"18ht0j2w8ste", Box{-89.0911141969, -89.0911140293, -106.171159521, -106.171159185}},
	{"vynwqurve", Box{79.8729228973, 79.8729658127, 88.1980276108, 88.1980705261}},
	{"s77hhn", Box{19.0173339844, 19.0228271484, 15.64453125, 15.6555175781}},
	{"hj66tgs86", Box{-60.0100278854, -60.0099849701, 3.42301368713, 3.42305660248}},
	{"e5nh4k", Box{17.6000976562, 17.6055908203, -36.4636230469, -36.4526367188}},
	{"jk", Box{-67.5, -61.875, 56.25, 67.5}},
	{"7", Box{-45.0, 0.0, -45.0, 0.0}},
	{"f0p3v5", Box{45.3240966797, 45.3295898438, -79.5849609375, -79.5739746094}},
	{"numc175r1", Box{-65.9002876282, -65.9002447128, 131.895375252, 131.895418167}},
	{"7pc", Box{-1.40625, 0.0, -43.59375, -42.1875}},
	{"b7qw82mfqc4", Box{64.4255930185, 64.4255943596, -159.590199888, -159.590198547}},
	{"qfe", Box{-30.9375, -29.53125, 127.96875, 129.375}},
	{"mw9kj6nrue61", Box{-7.72204069421, -7.72204052657, 69.4973042607, 69.497304596}},
	{"6en5d6psj", Box{-27.4980926514, -27.498049736, -58.9531087875, -58.9530658722}},
	{"mk80", Box{-19.6875, -19.51171875, 56.25, 56.6015625}},
	{"d2fbpmpyjv", Box{4.24727261066, 4.24727797508, -74.5533192158, -74.5533084869}},
	{"pf84wbwguh9", Box{-75.4946324229, -75.4946310818, 169.056073576, 169.056074917}},
	{"ncj8287", Box{-84.3296813965, -84.3283081055, 131.510467529, 131.51184082}},
	{"smd4t", Box{31.376953125, 31.4208984375, 14.2822265625, 14.326171875}},
	{"4ryj3jjxrd", Box{-45.4546773434, -45.454671979, -70.2606797218, -70.260668993}},
	{"udffsxnn8", Box{60.9477710724, 60.9478139877, 26.5731811523, 26.5732240677}},
	{"cub7vr", Box{72.4163818359, 72.421875, -100.667724609, -100.656738281}},
	{"y7c6s4", Box{66.5441894531, 66.5496826172, 103.18359375, 103.194580078}},
	{"t253", Box{0.17578125, 0.3515625, 60.8203125, 61.171875}},
	{"1e2bhmk9ybw", Box{-71.6896077991, -71.6896064579, -111.252067387, -111.252066046}},
	{"k", Box{-45.0, 0.0, 0.0, 45.0}},
	{"99r75", Box{7.55859375, 7.6025390625, -102.172851562, -102.12890625}},
	{"knbr2kzz1791", Box{-5.72952283546, -5.72952266783, 0.373246818781, 0.373247154057}},
	{"v8h", Box{45.0, 46.40625, 73.125, 74.53125}},
	{"sm6xvf3bc", Box{30.9060430527, 30.906085968, 15.0207567215, 15.0207996368}},
	{"vu", Box{67.5, 73.125, 78.75, 90.0}},
	{"w56htc6", Box{19.0791320801, 19.0805053711, 93.0679321289, 93.0693054199}},
	{"t", Box{0.0, 45.0, 45.0, 90.0}},
	{"k", Box{-45.0, 0.0, 0.0, 45.0}},
	{"5hm57j8", Box{-65.4922485352, -65.4908752441, -37.8369140625, -37.8355407715}},
	{"k8qwr0e", Box{-42.4923706055, -42.4909973145, 31.9523620605, 31.9537353516}},
	{"716e0", Box{-37.44140625, -37.3974609375, -41.484375, -41.4404296875}},
	{"wz71b", Box{41.0888671875, 41.1328125, 127.96875, 128.012695312}},
	{"w", Box{0.0, 45.0, 90.0, 135.0}},
	{"v", Box{45.0, 90.0, 45.0, 90.0}},
	{"89x2", Box{8.4375, 8.61328125, -147.3046875, -146.953125}},
	{"rcr37p", Box{-37.7105712891, -37.705078125, 179.077148438, 179.088134766}},
	{"4xzjc7vmstr", Box{-45.3739361465, -45.3739348054, -57.5939060748, -57.5939047337}},
	{"tv07ndf8", Box{28.6674499512, 28.6676216125, 79.3906402588, 79.3909835815}},
	{"qb2z", Box{-42.36328125, -42.1875, 124.8046875, 125.15625}},
	{"xjq0fjferr", Box{29.6952670813, 29.6952724457, 143.529134989, 143.529145718}},
	{"zwn6", Box{79.1015625, 79.27734375, 166.2890625, 166.640625}},
	{"7xc", Box{-1.40625, 0.0, -21.09375, -19.6875}},
	{"m", Box{-45.0, 0.0, 45.0, 90.0}},
	{"vw4sy8z", Box{79.5890808105, 79.5904541016, 71.3108825684, 71.3122558594}},
	{"djg8s3pre", Box{32.4384212494, 32.4384641647, -84.881272316, -84.8812294006}},
	{"vpn8t", Box{84.462890625, 84.5068359375, 54.3603515625, 54.404296875}},
	{"1sse8x6", Box{-64.0324401855, -64.0310668945, -106.147155762, -106.145782471}},
	{"snm4", Box{35.5078125, 35.68359375, 7.03125, 7.3828125}},
	{"t", Box{0.0, 45.0, 45.0, 90.0}},
	{"5rb", Box{-46.40625, -45.0, -33.75, -32.34375}},
	{"q7", Box{-28.125, -22.5, 101.25, 112.5}},
	{"8", Box{0.0, 45.0, -180.0, -135.0}},
	{"hn5sw9rbvjk3", Box{-55.4519608431, -55.4519606754, 5.21838281304, 5.21838314831}},
	{"y0f7w5tep1f", Box{49.8537348211, 49.8537361622, 93.4355905652, 93.4355919063}},
	{"xts0uk", Box{31.0913085938, 31.0968017578, 163.311767578, 163.322753906}},
	{"ftybqfey", Box{77.4024581909, 77.4026298523, -57.7060317993, -57.7056884766}},
	{"eqvhf", Box{38.8037109375, 38.84765625, -26.630859375, -26.5869140625}},
	{"ctpbp73", Box{73.1428527832, 73.1442260742, -101.281585693, -101.280212402}},
	{"15czhy35", Box{-67.6409339905, -67.6407623291, -132.328948975, -132.328605652}},
	{"1", Box{-90.0, -45.0, -135.0, -90.0}},
	{"vk6mwwrysbf", Box{69.9084989727, 69.9085003138, 59.7105565667, 59.7105579078}},
	{"4yfcbqvevqy", Box{-51.6858740151, -51.685872674, -52.3640397191, -52.364038378}},
	{"d6qm1q41g", Box{13.5684156418, 13.5684585571, -69.9031305313, -69.903087616}},
	{"kjqew1cty", Box{-14.842915535, -14.8428726196, 9.40661430359, 9.40665721893}},
	{"hf9zn39ewerv", Box{-74.6981724165, -74.6981722489, 36.4879449829, 36.4879453182}},
	{"1j", Box{-61.875, -56.25, -135.0, -123.75}},
	{"u41", Box{56.25, 57.65625, 1.40625, 2.8125}},
	{"pd8sbu5sk", Box{-75.0798368454, -75.0797939301, 158.241062164, 158.24110508}},
	{"k7", Box{-28.125, -22.5, 11.25, 22.5}},
	{"fx6xcm", Box{87.1710205078, 87.1765136719, -63.9294433594, -63.9184570312}},
	{"k1nwc4mun", Box{-38.1754302979, -38.1753873825, 9.19272422791, 9.19276714325}},
	{"nechx1mg", Box{-68.1078529358, -68.1076812744, 114.221763611, 114.222106934}},
	{"8et6dbj4g", Box{20.1274251938, 20.1274681091, -149.98934269, -149.989299774}},
	{"7e", Box{-28.125, -22.5, -22.5, -11.25}},
	{"vqcthybtw0", Box{83.885679245, 83.8856846094, 58.5690593719, 58.5690701008}},
	{"r6qdv32n", Box{-31.8524551392, -31.8522834778, 155.621337891, 155.621681213}},
	{"tbhh", Box{0.703125, 0.87890625, 84.375, 84.7265625}},
	{"0c5fpu", Box{-84.0014648438, -83.9959716797, -140.635986328, -140.625}},
	{"7b", Box{-45.0, -39.375, -11.25, 0.0}},
	{"9vzmkfvug", Box{33.2825231552, 33.2825660706, -90.8379220963, -90.8378791809}},
	{"68t", Box{-42.1875, -40.78125, -60.46875, -59.0625}},
	{"ef1szshm45h", Box{12.1078079939, 12.107809335, -8.80510747433, -8.80510613322}},
	{"21dgj4", Box{-36.0241699219, -36.0186767578, -175.913085938, -175.902099609}},
	{"109q9yt", Box{-86.0092163086, -86.0078430176, -133.158416748, -133.157043457}},
	{"nhj3b9vc", Box{-67.182598114, -67.1824264526, 97.4126815796, 97.4130249023}},
	{"nye5uzgb", Box{-52.735748291, -52.7355766296, 128.182640076, 128.182983398}},
	{"dhz5f", Box{27.3779296875, 27.421875, -80.068359375, -80.0244140625}},
	{"g1verehd", Box{55.4318618774, 55.4320335388, -36.9298553467, -36.9295120239}},
	{"jtr", Box{-60.46875, -59.0625, 77.34375, 78.75}},
	{"m5nbruj", Box{-28.0590820312, -28.0577087402, 54.839630127, 54.841003418}},
	{"p", Box{-90.0, -45.0, 135.0, 180.0}},
	{"h", Box{-90.0, -45.0, 0.0, 45.0}},
	{"bm3gr", Box{75.1025390625, 75.146484375, -165.981445312, -165.9375}},
	{"e7my1m0qp", Box{19.3644332886, 19.3644762039, -25.6084871292, -25.6084442139}},
	{"fzue", Box{89.12109375, 89.296875, -49.921875, -49.5703125}},
	{"q70", Box{-28.125, -26.71875, 101.25, 102.65625}},
	{"sjeed", Box{31.552734375, 31.5966796875, 5.009765625, 5.0537109375}},
	{"cvsuyyw", Box{76.8081665039, 76.8095397949, -94.2654418945, -94.2640686035}},
	{"7dnp", Box{-32.51953125, -32.34375, -14.0625, -13.7109375}},
	{"tf9kr1u", Box{14.8191833496, 14.8205566406, 80.8209228516, 80.8222961426}},
	{"j38nduwqew", Box{-80.3940546513, -80.3940492868, 56.3795828819, 56.3795936108}},
	{"444y82r", Box{-77.606048584, -77.604675293, -86.1122131348, -86.1108398438}},
	{"1rwzsww", Box{-46.4584350586, -46.4570617676, -114.051818848, -114.050445557}},
	{"98vu", Box{4.921875, 5.09765625, -104.4140625, -104.0625}},
	{"f0hu79k2y84", Box{45.7540655136, 45.7540668547, -83.1603857875, -83.1603844464}},
	{"35399zm2gnn", Box{-26.415091753, -26.4150904119, -132.806374133, -132.806372792}},
	{"qzxy", Box{-1.7578125, -1.58203125, 134.6484375, 135.0}},
	{"7gpr25", Box{-26.8341064453, -26.8286132812, -1.0546875, -1.04370117188}},
	{"xucdp", Box{27.0703125, 27.1142578125, 171.166992188, 171.2109375}},
	{"db3mpnz89zq", Box{2.32235983014, 2.32236117125, -54.1741874814, -54.1741861403}},
	{"p", Box{-90.0, -45.0, 135.0, 180.0}},
	{"94m52", Box{13.2275390625, 13.271484375, -127.96875, -127.924804688}},
	{"u7ucp", Box{66.26953125, 66.3134765625, 18.2373046875, 18.28125}},
	{"81qq43p", Box{8.09143066406, 8.09280395508, -171.10244751, -171.101074219}},
	{"f80w8", Box{46.142578125, 46.1865234375, -66.796875, -66.7529296875}},
	{"8j5z", Box{29.35546875, 29.53125, -174.7265625, -174.375}},
	{"56q", Box{-77.34375, -75.9375, -25.3125, -23.90625}},
	{"b72vvhj", Box{64.3139648438, 64.3153381348, -167.468719482, -167.467346191}},
	{"5j", Box{-61.875, -56.25, -45.0, -33.75}},
	{"42hm9tj0rn", Box{-89.0056622028, -89.0056568384, -72.7003526688, -72.7003419399}},
	{"cbxx9q2c89", Box{49.1654545069, 49.1654598713, -90.6471419334, -90.6471312046}},
	{"43", Box{-84.375, -78.75, -78.75, -67.5}},
	{"rvmw", Box{-14.4140625, -14.23828125, 176.484375, 176.8359375}},
	{"jwmeyr4hj7", Box{-54.1454154253, -54.1454100609, 75.5120050907, 75.5120158195}},
	{"b3y", Box{54.84375, 56.25, -160.3125, -158.90625}},
	{"4y3n0e7u8j", Box{-53.7704104185, -53.7704050541, -54.8166275024, -54.8166167736}},
	{"m0k0x", Box{-43.505859375, -43.4619140625, 50.9326171875, 50.9765625}},
	{"2zc1v219ev8z", Box{-1.09834464267, -1.09834447503, -144.610815234, -144.610814899}},
	{"3rvj3ezyffez", Box{-0.46162577346, -0.461625605822, -116.64206598, -116.642065644}},
	{"35bdpq", Box{-23.5217285156, -23.5162353516, -133.978271484, -133.967285156}},
	{"qdqrzp2e7b", Box{-30.9410619736, -30.9410566092, 121.597527266, 121.597537994}},
	{"vmrsrejf", Box{75.2951431274, 75.2953147888, 67.1343612671, 67.1347045898}},
	{"up", Box{84.375, 90.0, 0.0, 11.25}},
	{"bzy", Box{88.59375, 90.0, -137.8125, -136.40625}},
	{"3rnm42gs62", Box{-4.7412443161, -4.74123895168, -114.857157469, -114.85714674}},
	{"yhekty3621c", Box{71.1382435262, 71.1382448673, 94.8247160017, 94.8247173429}},
	{"ektx", Box{26.54296875, 26.71875, -26.015625, -25.6640625}},
	{"9nxkb4u9f6", Box{37.4128782749, 37.4128836393, -124.798411131, -124.798400402}},
	{"fg", Box{61.875, 67.5, -56.25, -45.0}},
	{"66e4x10k68", Box{-30.4918241501, -30.4918187857, -74.2231822014, -74.2231714725}},
	{"me", Box{-28.125, -22.5, 67.5, 78.75}},
	{"r385f5q9", Box{-35.8852958679, -35.8851242065, 146.346817017, 146.347160339}},
	{"xbdc8wgn0", Box{3.11428070068, 3.11432361603, 172.643280029, 172.643322945}},
	{"74s", Box{-30.9375, -29.53125, -39.375, -37.96875}},
	{"dg8t7", Box{20.6103515625, 20.654296875, -55.4150390625, -55.37109375}},
	{"nf7", Box{-77.34375, -75.9375, 127.96875, 129.375}},
	{"6nzfqpxy", Box{-6.59351348877, -6.59334182739, -78.8272476196, -78.8269042969}},
	{"0ux06p9jktht", Box{-64.6014270745, -64.6014269069, -136.31678693, -136.316786595}},
	{"nb8pxznpjh", Box{-85.8294653893, -85.8294600248, 124.099030495, 124.099041224}},
	{"6qks2x97hzm", Box{-9.05492708087, -9.05492573977, -72.3979751766, -72.3979738355}},
	{"us6qrd43em", Box{70.0161534548, 70.0161588192, 25.9968817234, 25.9968924522}},
	{"tp2eh", Box{41.30859375, 41.3525390625, 45.87890625, 45.9228515625}},
	{"vcgf16q2", Box{55.2076721191, 55.2078437805, 84.0869522095, 84.0872955322}},
	{"qt15nkc82kz", Box{-16.3214953244, -16.3214939833, 114.182988256, 114.182989597}},
	{"t6t", Box{14.0625, 15.46875, 63.28125, 64.6875}},
	{"yx53b3kj32", Box{84.6903848648, 84.6903902292, 117.086845636, 117.086856365}},
	{"twqdxev4cx", Box{35.6168121099, 35.6168174744, 76.9771456718, 76.9771564007}},
	{"p", Box{-90.0, -45.0, 135.0, 180.0}},
	{"4gty084hgddy", Box{-69.2569826916, -69.2569825239, -48.13918937, -48.1391890347}},
	{"c7", Box{61.875, 67.5, -123.75, -112.5}},
	{"ywffc641", Box{83.463306427, 83.4634780884, 116.424865723, 116.425209045}},
	{"k0km", Box{-42.71484375, -42.5390625, 5.9765625, 6.328125}},
	{"17k4fg", Box{-71.2188720703, -71.2133789062, -118.004150391, -117.993164062}},
	{"9fr", Box{12.65625, 14.0625, -91.40625, -90.0}},
	{"w", Box{0.0, 45.0, 90.0, 135.0}},
	{"h08scsx", Box{-86.3278198242, -86.3264465332, 0.778656005859, 0.780029296875}},
	{"8f8nq48", Box{15.1748657227, 15.1762390137, -145.986328125, -145.984954834}},
	{"hecr6qx49k0", Box{-67.59567976, -67.5956784189, 24.3663561344, 24.3663574755}},
	{"jn", Box{-56.25, -50.625, 45.0, 56.25}},
	{"qwx7j", Box{-7.91015625, -7.8662109375, 122.915039062, 122.958984375}},
	{"z", Box{45.0, 90.0, 135.0, 180.0}},
	{"wxcj4", Box{44.47265625, 44.5166015625, 113.994140625, 114.038085938}},
	{"gw63h", Box{80.33203125, 80.3759765625, -19.16015625, -19.1162109375}},
	{"hp7b6f27tq6p", Box{-49.1618095525, -49.1618093848, 5.3948584199, 5.39485875517}},
	{"kd", Box{-33.75, -28.125, 22.5, 33.75}},
	{"fbweu", Box{48.4716796875, 48.515625, -46.93359375, -46.8896484375}},
	{"m1fcuue7nm1g", Box{-34.8233712651, -34.8233710974, 49.080661498, 49.0806618333}},
	{"h9j", Box{-84.375, -82.96875, 29.53125, 30.9375}},
	{"n9d3g5uv", Box{-81.2334251404, -81.233253479, 115.80242157, 115.802764893}},
	{"nhpp1spf", Box{-66.247215271, -66.2470436096, 99.9203109741, 99.9206542969}},
	{"7jg2w13b23h", Box{-12.5614446402, -12.5614432991, -40.1635962725, -40.1635949314}},
	{"6q4z0ebf3", Box{-9.99854564667, -9.99850273132, -74.8597669601, -74.8597240448}},
	{"sv9vqgeecr", Box{31.8802589178, 31.8802642822, 36.5124285221, 36.5124392509}},
	{"wqd4", Box{36.9140625, 37.08984375, 104.0625, 104.4140625}},
	{"bwqgj", Box{80.68359375, 80.7275390625, -147.788085938, -147.744140625}},
	{"hk73qx", Box{-65.8355712891, -65.830078125, 16.1059570312, 16.1169433594}},
	{"gdx1d6hr76v", Box{59.3384175003, 59.3384188414, -12.5513903797, -12.5513890386}},
	{"47czd", Box{-67.587890625, -67.5439453125, -76.201171875, -76.1572265625}},
	{"1kpebdk50", Box{-66.8279457092, -66.8279027939, -113.17565918, -113.175616264}},
	{"g3z7", Box{55.37109375, 55.546875, -23.5546875, -23.203125}},
	{"8x", Box{39.375, 45.0, -157.5, -146.25}},
	{"nczvrs", Box{-79.2114257812, -79.2059326172, 134.978027344, 134.989013672}},
	{"fbyjmwc6", Box{50.1790237427, 50.1791954041, -47.5690841675, -47.5687408447}},
	{"yhz41tus5wm", Box{72.1026183665, 72.1026197076, 99.9160046875, 99.9160060287}},
	{"uktff1pp0", Box{70.8025932312, 70.8026361465, 19.4334411621, 19.4334840775}},
	{"hrt8", Box{-47.8125, -47.63671875, 18.984375, 19.3359375}},
	{"b5vkzheshz3", Box{66.9541557133, 66.9541570544, -172.304558605, -172.304557264}},
	{"v", Box{45.0, 90.0, 45.0, 90.0}},
	{"h6mvgwv1kmp", Box{-76.2956875563, -76.2956862152, 19.4968043268, 19.4968056679}},
	{"etzq7udz", Box{33.4683036804, 33.4684753418, -12.1361160278, -12.1357727051}},
	{"rf2x5pd6", Box{-31.0717391968, -31.0715675354, 169.588050842, 169.588394165}},
	{"k8kquxqbt2", Box{-42.3673152924, -42.3673099279, 28.6838114262, 28.683822155}},
	{"bz91jncb2c7", Box{87.4004097283, 87.4004110694, -144.621583968, -144.621582627}},
	{"3uk4y5r6sjwr", Box{-20.5920389481, -20.5920387805, -95.3511917219, -95.3511913866}},
	{"d", Box{0.0, 45.0, -90.0, -45.0}},
	{"y95n1hd", Box{51.7044067383, 51.7057800293, 116.765441895, 116.766815186}},
	{"629k5b3kbkc", Box{-41.4821608365, -41.4821594954, -76.8256638944, -76.8256625533}},
	{"pp42st7vp5", Box{-50.5073958635, -50.5073904991, 138.367266655, 138.367277384}},
	{"u17e", Box{52.55859375, 52.734375, 4.921875, 5.2734375}},
	{"s", Box{0.0, 45.0, 0.0, 45.0}},
	{"ex5w6znubms", Box{40.5129298568, 40.5129311979, -17.447989583, -17.4479882419}},
	{"8jsn", Box{31.9921875, 32.16796875, -174.375, -174.0234375}},
	{"6", Box{-45.0, 0.0, -90.0, -45.0}},
	{"mht9efkj", Box{-19.410610199, -19.4104385376, 52.9046630859, 52.9050064087}},
	{"kkbcqqfcsz", Box{-18.0241495371, -18.0241441727, 12.5833261013, 12.5833368301}},
	{"866rppwznm", Box{13.9291459322, 13.9291512966, -165.268782377, -165.268771648}},
	{"96wj53wczp0c", Box{14.9499841221, 14.9499842897, -115.160106607, -115.160106272}},
	{"9ctzrj", Box{9.73937988281, 9.74487304688, -92.8564453125, -92.8454589844}},
	{"d", Box{0.0, 45.0, -90.0, -45.0}},
	{"wfq5hd", Box{13.1945800781, 13.2000732422, 132.385253906, 132.396240234}},
	{"9y6vu2v8wm5", Box{36.1712247133, 36.1712260544, -97.1882195771, -97.188218236}},
	{"6xcpg", Box{-0.0439453125, 0.0, -65.9619140625, -65.91796875}},
	{"rxqgqmc", Box{-3.61587524414, -3.61450195312, 167.268218994, 167.269592285}},
	{"yye", Box{81.5625, 82.96875, 127.96875, 129.375}},
	{"r3", Box{-39.375, -33.75, 146.25, 157.5}},
	{"x7t", Box{19.6875, 21.09375, 153.28125, 154.6875}},
	{"3", Box{-45.0, 0.0, -135.0, -90.0}},
	{"g9mmh9sku8h", Box{52.9192113876, 52.9192127287, -14.9133986235, -14.9133972824}},
	{"v2q6qu3", Box{46.8251037598, 46.8264770508, 65.3370666504, 65.3384399414}},
	{"7j9ckmu00j", Box{-13.8111609221, -13.8111555576, -42.3468017578, -42.346791029}},
	{"4q3td", Box{-53.876953125, -53.8330078125, -76.552734375, -76.5087890625}},
	{"9ve2c92z33ke", Box{31.077454146, 31.0774543136, -96.6126798838, -96.6126795486}},
	{"9sscvm0mw1kw", Box{25.6485348567, 25.6485350244, -105.58899276, -105.588992424}},
	{"9u", Box{22.5, 28.125, -101.25, -90.0}},
	{"nv4j7yb8mjjy", Box{-60.9149988368, -60.9149986692, 126.728203855, 126.728204191}},
	{"80w8", Box{2.8125, 2.98828125, -170.859375, -170.5078125}},
	{"q06ch78z1", Box{-43.3975410461, -43.3974981308, 94.0550279617, 94.0550708771}},
	{"u", Box{45.0, 90.0, 0.0, 45.0}},
	{"gzw", Box{87.1875, 88.59375, -2.8125, -1.40625}},
	{"1", Box{-90.0, -45.0, -135.0, -90.0}},
	{"u", Box{45.0, 90.0, 0.0, 45.0}},
	{"furb", Box{68.90625, 69.08203125, -45.3515625, -45.0}},
	{"xen8pyc36", Box{16.9122934341, 16.9123363495, 166.983003616, 166.983046532}},
	{"n1gc29sd", Box{-79.9279403687, -79.9277687073, 95.3015899658, 95.3019332886}},
	{"cjvu", Box{78.046875, 78.22265625, -126.9140625, -126.5625}},
	{"w7x53f7fb0", Box{20.2716207504, 20.2716261148, 111.175804138, 111.175814867}},
	{"hz", Box{-50.625, -45.0, 33.75, 45.0}},
	{"8tz14", Box{32.51953125, 32.5634765625, -147.568359375, -147.524414062}},
	{"z", Box{45.0, 90.0, 135.0, 180.0}},
	{"pyfunm", Box{-51.3006591797, -51.2951660156, 172.891845703, 172.902832031}},
	{"b", Box{45.0, 90.0, -180.0, -135.0}},
	{"7xre21ceuxv", Box{-3.63716259599, -3.63716125488, -11.9508652389, -11.9508638978}},
	{"17", Box{-73.125, -67.5, -123.75, -112.5}},
	{"ru", Box{-22.5, -16.875, 168.75, 180.0}},
	{"bdjs6y77m", Box{57.0319604874, 57.0320034027, -149.640097618, -149.640054703}},
	{"u1vsgx2", Box{55.718536377, 55.719909668, 7.88818359375, 7.88955688477}},
	{"pj5e80uz", Box{-61.2544441223, -61.2542724609, 139.928398132, 139.928741455}},
	{"ju01xcg9", Box{-67.2265434265, -67.2263717651, 79.0953826904, 79.0957260132}},
	{"4", Box{-90.0, -45.0, -90.0, -45.0}},
	{"k05kz1", Box{-44.1595458984, -44.1540527344, 4.8779296875, 4.88891601562}},
	{"ru2h1xc", Box{-20.3480529785, -20.3466796875, 168.81729126, 168.818664551}},
	{"ud2s6zr", Box{58.443145752, 58.444519043, 23.3335876465, 23.3349609375}},
	{"mrq5fm1zrqp", Box{-3.5308277607, -3.53082641959, 64.7891007364, 64.7891020775}},
	{"0y2u0dg2rg", Box{-54.1254597902, -54.1254544258, -145.168544054, -145.168533325}},
	{"9nkt0rnyx3", Box{36.0747295618, 36.0747349262, -128.651307821, -128.651297092}},
	{"77q", Box{-26.71875, -25.3125, -25.3125, -23.90625}},
	{"ng76t7", Box{-71.2628173828, -71.2573242188, 128.551025391, 128.562011719}},
	{"4ewypr0y27up", Box{-69.2182661779, -69.2182660103, -57.6881629229, -57.6881625876}},
	{"ge7vkm2x73", Box{64.2341905832, 64.2341959476, -17.0389688015, -17.0389580727}},
	{"3qm4d", Box{-9.404296875, -9.3603515625, -116.630859375, -116.586914062}},
	{"6gqw9", Box{-25.576171875, -25.5322265625, -47.0654296875, -47.021484375}},
	{"32", Box{-45.0, -39.375, -123.75, -112.5}},
	{"ns85", Box{-64.16015625, -63.984375, 112.5, 112.8515625}},
	{"hzy00b4j5tcj", Box{-46.4053600095, -46.4053598419, 42.2233571112, 42.2233574465}},
	{"7qrk5nt", Box{-9.10491943359, -9.10354614258, -23.4159851074, -23.4146118164}},
	{"vd4219t7th", Box{56.2588620186, 56.258867383, 70.7374048233, 70.7374155521}},
	{"g", Box{45.0, 90.0, -45.0, 0.0}},
	{"pq1p16t", Box{-55.0057983398, -55.0044250488, 147.718048096, 147.719421387}},
	{"gryfsc3wgn", Box{89.0412604809, 89.0412658453, -24.0468835831, -24.0468728542}},
	{"np0u", Box{-49.921875, -49.74609375, 91.0546875, 91.40625}},
	{"u87", Box{46.40625, 47.8125, 26.71875, 28.125}},
	{"9qz2", Box{37.96875, 38.14453125, -113.5546875, -113.203125}},
	{"xunf", Box{22.8515625, 23.02734375, 178.2421875, 178.59375}},
	{"ve", Box{61.875, 67.5, 67.5, 78.75}},
	{"s2c1tf2bvp4s", Box{4.49494846165, 4.49494862929, 12.9101834446, 12.9101837799}},
	{"5znd0f", Box{-50.2624511719, -50.2569580078, -2.07641601562, -2.0654296875}},
	{"dn90ug", Box{36.7108154297, 36.7163085938, -88.3850097656, -88.3740234375}},
	{"24bg3", Box{-28.9599609375, -28.916015625, -178.901367188, -178.857421875}},
	{"x46xpb2", Box{13.888092041, 13.889465332, 138.856201172, 138.857574463}},
	{"83q", Box{7.03125, 8.4375, -160.3125, -158.90625}},
	{"2pup20sqj", Box{-0.128059387207, -0.128016471863, -174.368948936, -174.368906021}},
	{"07", Box{-73.125, -67.5, -168.75, -157.5}},
	{"jj7nh21g4zk", Box{-59.4135086238, -59.4135072827, 49.408044219, 49.4080455601}},
	{"19up4rw9", Box{-78.8844108582, -78.8842391968, -106.767196655, -106.766853333}},
	{"2j", Box{-16.875, -11.25, -180.0, -168.75}},
	{"14uexty", Box{-73.8844299316, -73.8830566406, -128.33404541, -128.332672119}},
	{"t3wtb", Box{9.4482421875, 9.4921875, 65.390625, 65.4345703125}},
	{"wv0z", Box{29.35546875, 29.53125, 124.8046875, 125.15625}},
	{"jj6gcte19u", Box{-59.7790789604, -59.779073596, 48.9373004436, 48.9373111725}},
	{"xz0wc0te1bbe", Box{40.5647895299, 40.5647896975, 169.504699185, 169.504699521}},
	{"d", Box{0.0, 45.0, -90.0, -45.0}},
	{"zyejp1um86c", Box{82.4519781768, 82.4519795179, 173.282215744, 173.282217085}},
	{"ft915xruxj8n", Box{76.1539096758, 76.1539098434, -65.9289979935, -65.9289976582}},
	{"vchvx0yp5c", Box{51.5971237421, 51.5971291065, 85.7457053661, 85.745716095}},
	{"x5x", Box{19.6875, 21.09375, 144.84375, 146.25}},
	{"0ykju58", Box{-53.8137817383, -53.8124084473, -140.44921875, -140.447845459}},
	{"d2yk35fd", Box{4.98676300049, 4.98693466187, -69.91355896, -69.9132156372}},
	{"6ymr7k8", Box{-8.54461669922, -8.5432434082, -48.7243652344, -48.7229919434}},
	{"pjsxb9f", Box{-57.6905822754, -57.6892089844, 141.352844238, 141.354217529}},
	{"trydkh27gn2t", Box{44.0132818557, 44.0132820234, 65.5668789893, 65.5668793246}},
	{"k72c0uqqw2", Box{-26.5185070038, -26.5185016394, 12.3464977741, 12.346508503}},
	{"s8trjfz", Box{4.05807495117, 4.05944824219, 30.145111084, 30.146484375}},
	{"57ffkwfnrh1", Box{-68.4725689888, -68.4725676477, -29.6820102632, -29.6820089221}},
	{"x", Box{0.0, 45.0, 135.0, 180.0}},
	{"u2k", Box{46.40625, 47.8125, 16.875, 18.28125}},
	{"nndqt", Box{-52.294921875, -52.2509765625, 93.3837890625, 93.427734375}},
	{"w7", Box{16.875, 22.5, 101.25, 112.5}},
	{"r6c7x00p6", Box{-28.91477108, -28.9147281647, 148.315515518, 148.315558434}},
	{"mdrgz", Box{-31.6845703125, -31.640625, 78.7060546875, 78.75}},
	{"f1dzhud0j", Box{54.6926879883, 54.6927309036, -85.9211111069, -85.9210681915}},
	{"yqh", Box{78.75, 80.15625, 106.875, 108.28125}},
	{"9jp43kj", Box{28.5424804688, 28.5438537598, -125.094451904, -125.093078613}},
	{"14pb4v5q", Box{-78.7215042114, -78.72133255, -123.976249695, -123.975906372}},
	{"bjzkjzr9hsvc", Box{78.0868977495, 78.0868979171, -169.54150144, -169.541501105}},
	{"svjbhs9e9g8", Box{28.1503388286, 28.1503401697, 42.0358264446, 42.0358277857}},
	{"guuxc8c5v", Box{73.0858182907, 73.0858612061, -4.85436916351, -4.85432624817}},
	{"utu2603h0ru5", Box{77.3897973262, 77.3897974938, 28.5658425093, 28.5658428445}},
	{"bq", Box{78.75, 84.375, -168.75, -157.5}},
	{"kk", Box{-22.5, -16.875, 11.25, 22.5}},
	{"6vxq65mhx", Box{-12.9452419281, -12.9451990128, -45.9596300125, -45.9595870972}},
	{"f4sb", Box{59.0625, 59.23828125, -83.3203125, -82.96875}},
	{"y5p4", Box{62.2265625, 62.40234375, 99.84375, 100.1953125}},
	{"bs6cju", Box{69.1040039062, 69.1094970703, -153.380126953, -153.369140625}},
	{"5j", Box{-61.875, -56.25, -45.0, -33.75}},
	{"4e8z0qpsppx", Box{-69.048345387, -69.0483440459, -66.4237166941, -66.423715353}},
	{"nbyg", Box{-85.25390625, -85.078125, 133.2421875, 133.59375}},
	{"8jn2dnxvbd", Box{28.2495939732, 28.2495993376, -171.112382412, -171.112371683}},
	{"0h6ej9g", Box{-65.5567932129, -65.5554199219, -176.238555908, -176.237182617}},
	{"9j18njf9mc", Box{28.1568056345, 28.1568109989, -132.623273134, -132.623262405}},
	{"pf93jtqd2xm9", Box{-75.7324543409, -75.7324541733, 170.758466944, 170.758467279}},
	{"hc2", Box{-82.96875, -81.5625, 33.75, 35.15625}},
	{"g", Box{45.0, 90.0, -45.0, 0.0}},
	{"cewhub", Box{65.5224609375, 65.5279541016, -103.853759766, -103.842773438}},
	{"2vcrfbgsv2sx", Box{-11.2890061922, -11.2890060246, -144.366300032, -144.366299696}},
	{"mxdsnv", Box{-2.08190917969, -2.07641601562, 71.3122558594, 71.3232421875}},
	{"03", Box{-84.375, -78.75, -168.75, -157.5}},
	{"u73kybuxbq", Box{64.1216933727, 64.1216987371, 13.3106338978, 13.3106446266}},
	{"uz2", Box{85.78125, 87.1875, 33.75, 35.15625}},
	{"3w", Box{-11.25, -5.625, -112.5, -101.25}},
	{"j", Box{-90.0, -45.0, 45.0, 90.0}},
	{"q8kttcg9t", Box{-42.6170825958, -42.6170396805, 119.085831642, 119.085874557}},
	{"j8w8vhmh9d", Box{-87.0315349102, -87.0315295458, 76.8672823906, 76.8672931194}},
	{"qxn54fn91g", Box{-5.08648216724, -5.08647680283, 121.067351103, 121.067361832}},
	{"9", Box{0.0, 45.0, -135.0, -90.0}},
	{"3h2p4vmu", Box{-19.8337554932, -19.8335838318, -134.871253967, -134.870910645}},
	{"j4re6xcw", Box{-76.7288589478, -76.7286872864, 55.6587982178, 55.6591415405}},
	{"ugkmrc1vj", Box{64.2104530334, 64.2104959488, 40.0697565079, 40.0697994232}},
	{"n1mj98dq", Box{-81.9981765747, -81.9980049133, 97.1002578735, 97.1006011963}},
	{"r6c", Box{-29.53125, -28.125, 147.65625, 149.0625}},
	{"9uksmr", Box{24.6917724609, 24.697265625, -94.6911621094, -94.6801757812}},
	{"dmve", Box{32.87109375, 33.046875, -71.015625, -70.6640625}},
	{"jgrdkvuq", Box{-71.2906265259, -71.2904548645, 89.5114517212, 89.5117950439}},
	{"94g", Box{15.46875, 16.875, -130.78125, -129.375}},
	{"2vj4gt", Box{-16.3641357422, -16.3586425781, -139.064941406, -139.053955078}},
	{"q39q2pm5kxt", Box{-35.4234436154, -35.4234422743, 103.01487878, 103.014880121}},
	{"qcuy493hpwdf", Box{-34.0939741954, -34.0939740278, 130.541249625, 130.541249961}},
	{"nhfpjqpyqnv3", Box{-62.0167130046, -62.0167128369, 93.0541204289, 93.0541207641}},
	{"838kk", Box{9.1845703125, 9.228515625, -168.22265625, -168.178710938}},
	{"zx2fdg", Box{86.2371826172, 86.2426757812, 158.675537109, 158.686523438}},
	{"j7ktd1g4", Box{-70.7419967651, -70.7418251038, 62.670135498, 62.6704788208}},
	{"yzp", Box{84.375, 85.78125, 133.59375, 135.0}},
	{"76kf7tcsnb94", Box{-31.9159668311, -31.9159666635, -26.91415295, -26.9141526148}},
	{"9jb", Box{32.34375, 33.75, -135.0, -133.59375}},
	{"6w", Box{-11.25, -5.625, -67.5, -56.25}},
	{"f2zs58", Box{49.921875, 49.9273681641, -68.0493164062, -68.0383300781}},
	{"f0", Box{45.0, 50.625, -90.0, -78.75}},
	{"mnqum74bk", Box{-9.08015727997, -9.08011436462, 54.7268486023, 54.7268915176}},
	{"t6rhggbn5", Box{13.512840271, 13.5128831863, 66.2586736679, 66.2587165833}},
	{"g9q", Box{52.03125, 53.4375, -14.0625, -12.65625}},
	{"7vr", Box{-15.46875, -14.0625, -1.40625, 0.0}},
	{"t6sr47h", Box{15.3094482422, 15.3108215332, 62.3309326172, 62.3323059082}},
	{"076vzrw", Box{-70.666809082, -70.665435791, -164.555969238, -164.554595947}},
	{"s2", Box{0.0, 5.625, 11.25, 22.5}},
	{"gd7350xxrrs", Box{57.8360626101, 57.8360639513, -17.7872353792, -17.7872340381}},
	{"0p8sgbg", Box{-46.9734191895, -46.9720458984, -179.127960205, -179.126586914}},
	{"5zsn39", Box{-46.7083740234, -46.7028808594, -5.55908203125, -5.54809570312}},
	{"80f", Box{4.21875, 5.625, -177.1875, -175.78125}},
	{"cymr4xm05c0", Box{81.4265495539, 81.426550895, -93.7502968311, -93.75029549}},
	{"qmjmz", Box{-15.8642578125, -15.8203125, 108.940429688, 108.984375}},
	{"39c0", Box{-35.15625, -34.98046875, -111.09375, -110.7421875}},
	{"pgxnue0jpfn", Box{-69.1086280346, -69.1086266935, 178.791844547, 178.791845888}},
	{"nytxjp", Box{-52.1685791016, -52.1630859375, 131.704101562, 131.715087891}},
	{"q1mvpgze", Box{-37.0687294006, -37.0685577393, 98.4368133545, 98.4371566772}},
	{"tqjgn4h", Box{34.2883300781, 34.2897033691, 64.6051025391, 64.6064758301}},
	{"tjn18qrtdk", Box{28.4239697456, 28.4239751101, 53.4588825703, 53.4588932991}},
	{"qq3w12r", Box{-8.78768920898, -8.78631591797, 103.423919678, 103.425292969}},
	{"zzdu8g6", Box{87.9963684082, 87.9977416992, 172.652893066, 172.654266357}},
	{"mz72xeccms3t", Box{-4.11002179608, -4.11002162844, 83.6525436491, 83.6525439844}},
	{"s7fnw5nzhbs4", Box{22.2540122643, 22.2540124319, 14.3356508017, 14.3356511369}},
	{"76rtxb6nkdm", Box{-31.3744948804, -31.3744935393, -22.8596024215, -22.8596010804}},
	{"znbejer93dr", Box{83.5141731799, 83.514174521, 135.955197662, 135.955199003}},
	{"smk7u7bz27", Box{30.212289691, 30.2122950554, 17.4143707752, 17.4143815041}},
	{"yvmurs", Box{75.3002929688, 75.3057861328, 132.165527344, 132.176513672}},
	{"tnjn6dgd8", Box{34.8641681671, 34.8642110825, 52.1459197998, 52.1459627151}},
	{"gyee1hnu", Box{82.1125030518, 82.1126747131, -6.27490997314, -6.27456665039}},
	{"gjwh9n02wfmc", Box{76.7615726776, 76.7615728453, -36.5179139748, -36.5179136395}},
	{"n6jh51hrnfws", Box{-78.0401661247, -78.0401659571, 108.41922082, 108.419221155}},
	{"shgszu46pudj", Box{27.5760518946, 27.5760520622, 5.26587635279, 5.26587668806}},
	{"3c", Box{-39.375, -33.75, -101.25, -90.0}},
	{"fy", Box{78.75, 84.375, -56.25, -45.0}},
	{"s75d5tn3m", Box{17.254242897, 17.2542858124, 16.3344812393, 16.3345241547}},
	{"2c1c9kkw8dk5", Box{-39.0868538059, -39.0868536383, -143.727924228, -143.727923892}},
	{"5yugurey8e2", Box{-51.3297383487, -51.3297370076, -4.37837362289, -4.37837228179}},
	{"rd", Box{-33.75, -28.125, 157.5, 168.75}},
	{"um", Box{73.125, 78.75, 11.25, 22.5}},
	{"bkgc", Box{71.89453125, 72.0703125, -163.4765625, -163.125}},
	{"8cfxnrphhu0", Box{11.1133790016, 11.1133803427, -142.449899912, -142.449898571}},
	{"tdm", Box{12.65625, 14.0625, 74.53125, 75.9375}},
	{"y9usehucn02q", Box{55.6610321626, 55.6610323302, 118.966741897, 118.966742232}},
	{"vk7kbfk0vf33", Box{69.7537115403, 69.7537117079, 60.859013088, 60.8590134233}},
	{"ewyx82", Box{39.287109375, 39.2926025391, -13.3483886719, -13.3374023438}},
	{"ev8c3", Box{31.1572265625, 31.201171875, -10.1513671875, -10.107421875}},
	{"37p4fhuc", Box{-27.6153373718, -27.6151657104, -113.811836243, -113.81149292}},
	{"0yvh2p9wbu", Box{-51.2418007851, -51.2417954206, -139.216657877, -139.216647148}},
	{"81k", Box{7.03125, 8.4375, -174.375, -172.96875}},
	{"7", Box{-45.0, 0.0, -45.0, 0.0}},
	{"5c67rs", Box{-82.3754882812, -82.3699951172, -7.75634765625, -7.74536132812}},
	{"udjvtg", Box{57.2332763672, 57.2387695312, 30.8386230469, 30.849609375}},
	{"8b56vfqrppu", Box{0.497001260519, 0.497002601624, -141.418113112, -141.418111771}},
	{"xv50", Box{28.125, 28.30078125, 172.96875, 173.3203125}},
	{"7ep", Box{-28.125, -26.71875, -12.65625, -11.25}},
	{"bxzp4746", Box{89.8410415649, 89.8412132263, -147.554283142, -147.553939819}},
	{"5d54r", Box{-78.3544921875, -78.310546875, -17.9736328125, -17.9296875}},
	{"hhknsytff", Box{-64.9149942398, -64.9149513245, 5.8417224884, 5.84176540375}},
	{"gvjjq75", Box{74.0643310547, 74.0657043457, -3.93997192383, -3.93859863281}},
	{"6ryrt5", Box{-0.0714111328125, -0.06591796875, -69.7412109375, -69.7302246094}},
	{"tykj1vq1gj", Box{36.0643225908, 36.0643279552, 84.460272789, 84.4602835178}},
	{"20tdw84b1w", Box{-41.7480146885, -41.7480093241, -171.976139545, -171.976128817}},
	{"r", Box{-45.0, 0.0, 135.0, 180.0}},
	{"sbwdq1c4355", Box{3.21802318096, 3.21802452207, 43.1557171047, 43.1557184458}},
	{"rwhkzg", Box{-10.3985595703, -10.3930664062, 163.817138672, 163.828125}},
	{"wrzphwjw57", Box{44.8582237959, 44.8582291603, 111.299196482, 111.299207211}},
	{"674", Box{-28.125, -26.71875, -75.9375, -74.53125}},
	{"z8kb", Box{46.40625, 46.58203125, 164.1796875, 164.53125}},
	{"pmudq9vs33", Box{-57.2503942251, -57.2503888607, 152.871376276, 152.871387005}},
	{"j1br4n9", Box{-78.8900756836, -78.8887023926, 45.440826416, 45.442199707}},
	{"ccc", Box{54.84375, 56.25, -99.84375, -98.4375}},
	{"src", Box{43.59375, 45.0, 12.65625, 14.0625}},
	{"cc51keq", Box{50.8625793457, 50.8639526367, -96.8252563477, -96.8238830566}},
	{"pr", Box{-50.625, -45.0, 146.25, 157.5}},
	{"tvd9", Box{31.11328125, 31.2890625, 82.265625, 82.6171875}},
	{"489bdms44x", Box{-87.069016099, -87.0690107346, -64.9345850945, -64.9345743656}},
	{"cmn23svsyv", Box{73.1958800554, 73.1958854198, -114.887176752, -114.887166023}},
	{"dm9vug1194", Box{31.9649899006, 31.964995265, -76.0789060593, -76.0788953304}},
	{"45f7", Box{-68.37890625, -68.203125, -86.8359375, -86.484375}},
	{"mxuxkdtgy50", Box{-0.117443203926, -0.117441862822, 74.0340328217, 74.0340341628}},
	{"tdwd7", Box{14.4580078125, 14.501953125, 76.7724609375, 76.81640625}},
	{"s", Box{0.0, 45.0, 0.0, 45.0}},
	{"jss4y", Box{-64.2041015625, -64.16015625, 73.388671875, 73.4326171875}},
	{"tmcs", Box{33.046875, 33.22265625, 58.359375, 58.7109375}},
	{"x", Box{0.0, 45.0, 135.0, 180.0}},
	{"gc61ncnxuec", Box{52.2138749063, 52.2138762474, -8.13174828887, -8.13174694777}},
	{"jwpc", Box{-56.07421875, -55.8984375, 78.3984375, 78.75}},
	{"yq5gn", Box{79.27734375, 79.3212890625, 106.787109375, 106.831054688}},
	{"uhtmex", Box{71.3177490234, 71.3232421875, 7.53662109375, 7.54760742188}},
	{"n0hbvyc", Box{-89.8310852051, -89.8297119141, 96.9337463379, 96.9351196289}},
	{"kp8q0gk0h", Box{-1.7399597168, -1.73991680145, 0.390186309814, 0.390229225159}},
	{"yjzduj46p", Box{77.8549575806, 77.8550004959, 100.726046562, 100.726089478}},
	{"8hhkjyy4v5s", Box{23.2406947017, 23.2406960428, -173.762292266, -173.762290925}},
	{"7", Box{-45.0, 0.0, -45.0, 0.0}},
	{"0", Box{-90.0, -45.0, -180.0, -135.0}},
	{"wwu63", Box{38.3642578125, 38.408203125, 118.520507812, 118.564453125}},
	{"z9rnym", Box{53.2452392578, 53.2507324219, 167.618408203, 167.629394531}},
	{"78fnfc", Box{-39.5892333984, -39.5837402344, -19.5666503906, -19.5556640625}},
	{"8dc1mqyer", Box{15.7261133194, 15.7261562347, -155.85381031, -155.853767395}},
	{"b5", Box{61.875, 67.5, -180.0, -168.75}},
	{"q3zq3gz6w7", Box{-34.0365725756, -34.0365672112, 111.532441378, 111.532452106}},
	{"xx6", Box{40.78125, 42.1875, 160.3125, 161.71875}},
	{"r3", Box{-39.375, -33.75, 146.25, 157.5}},
	{"dytz0swq74e", Box{37.8187742829, 37.818775624, -48.1333740056, -48.1333726645}},
	{"gpwu", Box{87.890625, 88.06640625, -35.5078125, -35.15625}},
	{"9ywdf6cr2w7", Box{37.0622827113, 37.0622840524, -92.0087559521, -92.008754611}},
	{"3", Box{-45.0, 0.0, -135.0, -90.0}},
	{"ues", Box{64.6875, 66.09375, 28.125, 29.53125}},
	{"qggvs5q7pr", Box{-22.9210478067, -22.9210424423, 129.208112955, 129.208123684}},
	{"fy9d8y2mv2", Box{82.0372724533, 82.0372778177, -54.1070973873, -54.1070866585}},
	{"bxx92bb60s", Box{87.411711216, 87.4117165804, -146.919801235, -146.919790506}},
	{"uugkmp4jkm0", Box{72.5052005053, 72.5052018464, 38.5429680347, 38.5429693758}},
	{"7mmd13sd30", Box{-15.1085615158, -15.1085561514, -25.9544706345, -25.9544599056}},
	{"5nn2", Box{-56.25, -56.07421875, -36.2109375, -35.859375}},
	{"jf9sz2r", Box{-75.1011657715, -75.0997924805, 81.1875915527, 81.1889648438}},
	{"3r", Box{-5.625, 0.0, -123.75, -112.5}},
	{"yw", Box{78.75, 84.375, 112.5, 123.75}},
	{"yt31y5hwc3c5", Box{74.8565152846, 74.8565154523, 114.17615667, 114.176157005}},
	{"7vgv9xhmn", Box{-11.6501426697, -11.6500997543, -5.90455055237, -5.90450763702}},
	{"f10tgm4q6", Box{51.6642808914, 51.6643238068, -89.1508769989, -89.1508340836}},
	{"hepj84tfcj", Box{-72.143971324, -72.1439659595, 32.3516893387, 32.3517000675}},
	{"zg", Box{61.875, 67.5, 168.75, 180.0}},
	{"by12", Box{78.75, 78.92578125, -144.4921875, -144.140625}},
	{"51", Box{-84.375, -78.75, -45.0, -33.75}},
	{"w44s78ur", Box{12.0023918152, 12.0025634766, 93.6752700806, 93.6756134033}},
	{"2tcr0", Box{-11.42578125, -11.3818359375, -155.7421875, -155.698242188}},
	{"p0n", Box{-90.0, -88.59375, 143.4375, 144.84375}},
	{"u1", Box{50.625, 56.25, 0.0, 11.25}},
	{"nygu1mshqxku", Box{-51.2971434742, -51.2971433066, 129.084147625, 129.08414796}},
	{"3khrs6gty5", Box{-21.1655312777, -21.1655259132, -117.581605911, -117.581595182}},
	{"4n", Box{-56.25, -50.625, -90.0, -78.75}},
	{"tj8pjxb5", Box{32.2110557556, 32.211227417, 45.2416992188, 45.2420425415}},
	{"7nhpg3stdjgu", Box{-9.87847991288, -9.87847974524, -39.225907065, -39.2259067297}},
	{"rhtcg24t2s50", Box{-19.3789601326, -19.378959965, 143.232218474, 143.232218809}},
	{"5vx7c75x", Box{-58.3856391907, -58.3854675293, -0.99494934082, -0.994606018066}},
	{"cs4kgc65z", Box{68.3424711227, 68.3425140381, -109.168095589, -109.168052673}},
	{"k3sn2mb", Box{-35.4322814941, -35.4309082031, 16.8859863281, 16.8873596191}},
	{"ud7s8v", Box{58.4747314453, 58.4802246094, 27.4548339844, 27.4658203125}},
	{"8qqg2ue1mr6b", Box{35.7525117695, 35.7525119372, -159.220504649, -159.220504314}},
	{"k", Box{-45.0, 0.0, 0.0, 45.0}},
	{"kwtg55d3me", Box{-7.89069950581, -7.89069414139, 30.7210993767, 30.7211101055}},
	{"mqsedtkq3", Box{-7.79235363007, -7.79231071472, 62.6938676834, 62.6939105988}},
	{"94j6tg", Box{11.7059326172, 11.7114257812, -127.364501953, -127.353515625}},
	{"wd45s", Box{11.865234375, 11.9091796875, 115.48828125, 115.532226562}},
	{"fwgxjq0n2", Box{84.233250618, 84.2332935333, -62.3474121094, -62.347369194}},
	{"1k8fh1", Box{-64.3304443359, -64.3249511719, -122.51953125, -122.508544922}},
	{"h", Box{-90.0, -45.0, 0.0, 45.0}},
	{"f", Box{45.0, 90.0, -90.0, -45.0}},
	{"6", Box{-45.0, 0.0, -90.0, -45.0}},
	{"qh", Box{-22.5, -16.875, 90.0, 101.25}},
	{"24nszw5", Box{-32.8820800781, -32.8807067871, -170.525665283, -170.524291992}},
	{"p8rfy", Box{-88.1103515625, -88.06640625, 168.662109375, 168.706054688}},
	{"st23m", Box{29.7509765625, 29.794921875, 23.0712890625, 23.115234375}},
	{"zgg3", Box{66.26953125, 66.4453125, 173.3203125, 173.671875}},
	{"zgsgk7bcz8k", Box{65.2796901762, 65.2796915174, 175.617812276, 175.617813617}},
	{"js0", Box{-67.5, -66.09375, 67.5, 68.90625}},
	{"9zs3bh", Box{42.5170898438, 42.5225830078, -95.2734375, -95.2624511719}},
	{"k8qd0d6mqfz", Box{-43.2289119065, -43.2289105654, 31.6659866273, 31.6659879684}},
	{"xrj", Box{39.375, 40.78125, 153.28125, 154.6875}},
	{"0mbxv2r4", Box{-56.2922286987, -56.2920570374, -167.806549072, -167.80620575}},
	{"bdf8wz8g1", Box{60.5983543396, 60.5983972549, -153.686671257, -153.686628342}},
	{"emgeh3mkyu", Box{32.8787970543, 32.8788024187, -28.6338579655, -28.6338472366}},
	{"5", Box{-90.0, -45.0, -45.0, 0.0}},
	{"156p3nxfwq", Box{-70.4081690311, -70.4081636667, -132.132643461, -132.132632732}},
	{"stduvpcnp4", Box{31.8160736561, 31.8160790205, 26.5885877609, 26.5885984898}},
	{"shk8evrmmbgr", Box{24.0238861553, 24.023886323, 6.50312740356, 6.50312773883}},
	{"7ynw", Box{-10.1953125, -10.01953125, -2.109375, -1.7578125}},
	{"r4zgvkp", Box{-28.8500976562, -28.8487243652, 146.138763428, 146.140136719}},
	{"5b9p", Box{-85.95703125, -85.78125, -9.84375, -9.4921875}},
	{"gsp", Box{67.5, 68.90625, -12.65625, -11.25}},
	{"ek4mmvr", Box{23.4516906738, 23.4530639648, -30.323638916, -30.322265625}},
	{"hd2nu", Box{-76.1572265625, -76.11328125, 22.67578125, 22.7197265625}},
	{"xzp0t", Box{39.462890625, 39.5068359375, 178.813476562, 178.857421875}},
	{"fycjx9", Box{83.9410400391, 83.9465332031, -54.5141601562, -54.5031738281}},
	{"x4ygy62x5", Box{16.1414909363, 16.1415338516, 144.767661095, 144.76770401}},
	{"37", Box{-28.125, -22.5, -123.75, -112.5}},
	{"m40", Box{-33.75, -32.34375, 45.0, 46.40625}},
	{"m", Box{-45.0, 0.0, 45.0, 90.0}},
	{"b5", Box{61.875, 67.5, -180.0, -168.75}},
	{"zwd", Box{81.5625, 82.96875, 160.3125, 161.71875}},
	{"qgnb2g", Box{-28.0645751953, -28.0590820312, 133.275146484, 133.286132812}},
	{"7w", Box{-11.25, -5.625, -22.5, -11.25}},
	{"v6x", Box{59.0625, 60.46875, 66.09375, 67.5}},
	{"018v8j6y", Box{-80.5658340454, -80.565662384, -178.94153595, -178.941192627}},
	{"mm4p02h18xc", Box{-15.6442321837, -15.6442308426, 59.079002291, 59.0790036321}},
	{"6cty1v7", Box{-35.4789733887, -35.4776000977, -48.0830383301, -48.0816650391}},
	{"g6rzs", Box{58.974609375, 59.0185546875, -22.67578125, -22.6318359375}},
	{"58qb", Box{-88.59375, -88.41796875, -13.0078125, -12.65625}},
	{"n8v", Box{-85.78125, -84.375, 119.53125, 120.9375}},
	{"h1nj4b1uv", Box{-83.4952783585, -83.4952354431, 8.56096744537, 8.56101036072}},
	{"qt4ukphd", Box{-16.0891342163, -16.0889625549, 116.54914856, 116.549491882}},
	{"n2", Box{-90.0, -84.375, 101.25, 112.5}},
	{"50sux01hejpj", Box{-86.3956842385, -86.3956840709, -38.0111838877, -38.0111835524}},
	{"4exy", Box{-69.2578125, -69.08203125, -56.6015625, -56.25}},
	{"x9t8r", Box{8.4814453125, 8.525390625, 165.541992188, 165.5859375}},
	{"785m2wrxgw2", Box{-44.0414522588, -44.0414509177, -17.8972649574, -17.8972636163}},
	{"0exegdddqf", Box{-69.6391904354, -69.639185071, -146.7955935, -146.795582771}},
	{"ynrw", Box{81.2109375, 81.38671875, 100.546875, 100.8984375}},
	{"uqdmuzrz6", Box{82.6143121719, 82.6143550873, 14.6335315704, 14.6335744858}},
	{"gchp3yu15c", Box{51.9366699457, 51.9366753101, -5.54244160652, -5.54243087769}},
	{"415qzwpj2r", Box{-83.154578805, -83.1545734406, -85.0904738903, -85.0904631615}},
	{"v", Box{45.0, 90.0, 45.0, 90.0}},
	{"vzq07z4", Box{85.8636474609, 85.865020752, 87.3550415039, 87.3564147949}},
	{"w43s", Box{13.359375, 13.53515625, 92.109375, 92.4609375}},
	{"b7td", Box{65.0390625, 65.21484375, -161.015625, -160.6640625}},
	{"2fpe", Box{-33.22265625, -33.046875, -135.703125, -135.3515625}},
	{"nyt", Box{-53.4375, -52.03125, 130.78125, 132.1875}},
	{"g", Box{45.0, 90.0, -45.0, 0.0}},
	{"s", Box{0.0, 45.0, 0.0, 45.0}},
	{"dkzk", Box{27.421875, 27.59765625, -68.5546875, -68.203125}},
	{"r3925m207w", Box{-36.5335857868, -36.5335804224, 148.150784969, 148.150795698}},
	{"0zy5gndwbzt3", Box{-45.710165631, -45.7101654634, -137.677191608, -137.677191272}},
	{"46ex1dmu9", Box{-74.6938991547, -74.6938562393, -73.7542676926, -73.7542247772}},
	{"jf74h9rrvnz8", Box{-76.9839544594, -76.9839542918, 83.1766849011, 83.1766852364}},
	{"6vj1jtgv", Box{-16.6667747498, -16.6666030884, -48.9719009399, -48.9715576172}},
	{"ntsx", Box{-57.83203125, -57.65625, 118.828125, 119.1796875}},
	{"ehr3ejb", Box{24.2015075684, 24.2028808594, -34.6728515625, -34.6714782715}},
	{"p7", Box{-73.125, -67.5, 146.25, 157.5}},
	{"re7", Box{-26.71875, -25.3125, 161.71875, 163.125}},
	{"66x6j7sc0t", Box{-30.5665129423, -30.5665075779, -68.3174300194, -68.3174192905}},
	{"mywcjb2q", Box{-8.25931549072, -8.25914382935, 88.4952163696, 88.4955596924}},
	{"f88jrw", Box{48.7683105469, 48.7738037109, -67.1704101562, -67.1594238281}},
	{"bjty3ef9n3y6", Box{77.0569135621, 77.0569137298, -171.844434701, -171.844434366}},
	{"jhz66rh4fj7s", Box{-62.8467891365, -62.8467889689, 55.2997731417, 55.299773477}},
	{"u16r3nm", Box{53.3399963379, 53.3413696289, 3.21487426758, 3.21624755859}},
	{"b", Box{45.0, 90.0, -180.0, -135.0}},
	{"q5rwnj4", Box{-25.6365966797, -25.6352233887, 100.813293457, 100.814666748}},
	{"dsqd4vc85c", Box{24.2894035578, 24.2894089222, -58.2363045216, -58.2362937927}},
	{"bzpu7z2qxf9", Box{85.1630249619, 85.1630263031, -135.18609032, -135.186088979}},
	{"e805cvqt", Box{0.688877105713, 0.68904876709, -22.4141693115, -22.4138259888}},
	{"y9su01vg", Box{54.1507530212, 54.1509246826, 119.187583923, 119.187927246}},
	{"41", Box{-84.375, -78.75, -90.0, -78.75}},
	{"vu3f", Box{69.2578125, 69.43359375, 81.2109375, 81.5625}},
	{"86", Box{11.25, 16.875, -168.75, -157.5}},
	{"wpuksnn65", Box{44.4180679321, 44.4181108475, 96.1610555649, 96.1610984802}},
	{"w", Box{0.0, 45.0, 90.0, 135.0}},
	{"nrqk483fq0kp", Box{-48.5138629563, -48.5138627887, 110.151591897, 110.151592232}},
	{"cg0mc", Box{62.8857421875, 62.9296875, -100.854492188, -100.810546875}},
	{"myt75g", Box{-7.89367675781, -7.88818359375, 86.2976074219, 86.30859375}},
	{"ugxe27b", Box{65.2793884277, 65.2807617188, 44.3078613281, 44.3092346191}},
	{"wd845dtbhs8", Box{14.42781955, 14.4278208911, 112.661898136, 112.661899477}},
	{"c8ef9h6mr", Box{48.2762002945, 48.2762432098, -107.179226875, -107.17918396}},
	{"bx", Box{84.375, 90.0, -157.5, -146.25}},
	{"qduv3", Box{-28.6083984375, -28.564453125, 119.223632812, 119.267578125}},
	{"j86depxm", Box{-88.1122398376, -88.1120681763, 71.1574172974, 71.1577606201}},
	{"4semjs5hr9p", Box{-63.7858861685, -63.7858848274, -62.6835371554, -62.6835358143}},
	{"ee", Box{16.875, 22.5, -22.5, -11.25}},
	{"jxv25m96n", Box{-46.3756942749, -46.3756513596, 75.0276088715, 75.0276517868}},
	{"vx7gj0006xwe", Box{86.3086774014, 86.308677569, 72.993280068, 72.9932804033}},
	{"6c", Box{-39.375, -33.75, -56.25, -45.0}},
	{"ukstfgt78f", Box{71.3430798054, 71.3430851698, 17.7062165737, 17.7062273026}},
	{"g1h0ye", Box{50.7733154297, 50.7788085938, -39.0893554688, -39.0783691406}},
	{"5s3j5er", Box{-65.1969909668, -65.1956176758, -20.9303283691, -20.9289550781}},
	{"6yrnnwq1", Box{-8.75455856323, -8.75438690186, -46.1123657227, -46.1120223999}},
	{"20fjy", Box{-39.7705078125, -39.7265625, -176.923828125, -176.879882812}},
	{"1tt417q", Box{-58.6930847168, -58.6917114258, -105.405578613, -105.404205322}},
	{"hh68", Box{-66.09375, -65.91796875, 3.515625, 3.8671875}},
	{"85s823r7j", Box{19.7388267517, 19.7388696671, -173.650717735, -173.65067482}},
	{"3u6n", Box{-20.0390625, -19.86328125, -98.4375, -98.0859375}},
	{"7w5y8", Box{-10.107421875, -10.0634765625, -17.2265625, -17.1826171875}},
	{"5", Box{-90.0, -45.0, -45.0, 0.0}},
	{"zk8j", Box{71.19140625, 71.3671875, 146.25, 146.6015625}},
	{"mgm1evw0", Box{-26.4248657227, -26.4246940613, 85.954284668, 85.9546279907}},
	{"m7nzv", Box{-26.7626953125, -26.71875, 65.9619140625, 66.005859375}},
	{"ev89re48", Box{31.1737060547, 31.1738777161, -10.2138519287, -10.213508606}},
	{"dnc7mrxvb3", Box{38.5822302103, 38.5822355747, -88.0008208752, -88.0008101463}},
	{"2", Box{-45.0, 0.0, -180.0, -135.0}},
	{"wbksmz281", Box{2.19314575195, 2.1931886673, 130.331540108, 130.331583023}},
	{"0x3zqt", Box{-47.9168701172, -47.9113769531, -154.753417969, -154.742431641}},
	{"h97q", Box{-81.9140625, -81.73828125, 27.0703125, 27.421875}},
	{"ypjt38wtc", Box{85.3015851974, 85.3016281128, 97.8092622757, 97.809305191}},
	{"d3ey054b7p", Box{9.50874745846, 9.50875282288, -73.4726572037, -73.4726464748}},
	{"zpbkps3qd9r", Box{89.3213434517, 89.3213447928, 135.682985634, 135.682986975}},
	{"sqxhhhs68mxy", Box{37.2908039019, 37.2908040695, 21.2753888592, 21.2753891945}},
	{"293cyj4g6q", Box{-37.6330769062, -37.6330715418, -154.771517515, -154.771506786}},
	{"w3", Box{5.625, 11.25, 101.25, 112.5}},
	{"r", Box{-45.0, 0.0, 135.0, 180.0}},
	{"q69s", Box{-30.234375, -30.05859375, 103.359375, 103.7109375}},
	{"fy1qerq2ven", Box{79.9325484037, 79.9325497448, -54.3405380845, -54.3405367434}},
	{"62", Box{-45.0, -39.375, -78.75, -67.5}},
	{"yke1jyek0fg", Box{70.5246882141, 70.5246895552, 105.725934952, 105.725936294}},
	{"2rcbq1z5c", Box{-1.35204792023, -1.35200500488, -166.015734673, -166.015691757}},
	{"gue", Box{70.3125, 71.71875, -7.03125, -5.625}},
	{"t8kqv", Box{2.5927734375, 2.63671875, 73.6962890625, 73.740234375}},
	{"bgtecc1b", Box{65.3521728516, 65.3523445129, -138.436317444, -138.435974121}},
	{"8s550", Box{23.02734375, 23.0712890625, -153.28125, -153.237304688}},
	{"j655kpm1w0b", Box{-78.1386239827, -78.1386226416, 60.6516551971, 60.6516565382}},
	{"980h", Box{0.703125, 0.87890625, -112.5, -112.1484375}},
	{"ssywj", Box{27.7734375, 27.8173828125, 31.8603515625, 31.904296875}},
	{"hrvu", Box{-45.703125, -45.52734375, 19.3359375, 19.6875}},
	{"3ftuv", Box{-30.1025390625, -30.05859375, -92.9443359375, -92.900390625}},
	{"zcphg93jux", Box{51.4678519964, 51.4678573608, 178.749125004, 178.749135733}},
	{"6", Box{-45.0, 0.0, -90.0, -45.0}},
	{"vjxk", Box{76.640625, 76.81640625, 55.1953125, 55.546875}},
	{"t6cgynpnh4", Box{16.161929369, 16.1619347334, 58.9843940735, 58.9844048023}},
	{"jspc", Box{-67.32421875, -67.1484375, 78.3984375, 78.75}},
	{"6w7k2v", Box{-9.06921386719, -9.06372070312, -62.8967285156, -62.8857421875}},
	{"n6z4", Box{-74.1796875, -74.00390625, 111.09375, 111.4453125}},
	{"y507hx0", Box{62.4407958984, 62.4421691895, 90.5493164062, 90.5506896973}},
	{"z17p35rnsc6v", Box{53.3246401884, 53.324640356, 139.272515886, 139.272516221}},
	{"p8uj5760", Box{-84.8844909668, -84.8843193054, 163.270568848, 163.27091217}},
	{"8pcszdrxwp", Box{44.4423955679, 44.4424009323, -177.550477982, -177.550467253}},
	{"mckjc7q4r", Box{-36.9397687912, -36.9397258759, 84.4384717941, 84.4385147095}},
	{"p6sngm70", Box{-74.7221374512, -74.7219657898, 152.021942139, 152.022285461}},
	{"59gcptbk", Box{-79.9481964111, -79.9480247498, -16.8966293335, -16.8962860107}},
	{"n", Box{-90.0, -45.0, 90.0, 135.0}},
	{"fmnv3ug5m", Box{74.0745019913, 74.0745449066, -69.1765737534, -69.176530838}},
	{"qc8kkbc0xev", Box{-35.8112038672, -35.8112025261, 124.312004596, 124.312005937}},
	{"b4", Box{56.25, 61.875, -180.0, -168.75}},
	{"vkxeh", Box{70.83984375, 70.8837890625, 66.97265625, 67.0166015625}},
	{"399qcn2zv", Box{-35.3403139114, -35.3402709961, -110.696997643, -110.696954727}},
	{"ybz3", Box{49.39453125, 49.5703125, 133.9453125, 134.296875}},
	{"d5e25", Box{19.6875, 19.7314453125, -85.2978515625, -85.25390625}},
	{"5n", Box{-56.25, -50.625, -45.0, -33.75}},
	{"wdw", Box{14.0625, 15.46875, 120.9375, 122.34375}},
	{"29q7", Box{-37.44140625, -37.265625, -148.7109375, -148.359375}},
	{"tqe1y4trw", Box{36.885137558, 36.8851804733, 60.7398891449, 60.7399320602}},
	{"zfwy172d", Box{60.135383606, 60.1355552673, 178.297805786, 178.298149109}},
	{"tfd57f", Box{14.6447753906, 14.6502685547, 81.7272949219, 81.73828125}},
	{"27f6s6h", Box{-23.4558105469, -23.4544372559, -165.393676758, -165.392303467}},
	{"zk2q2ph7db", Box{70.0439357758, 70.0439411402, 146.607517004, 146.607527733}},
	{"ptp", Box{-61.875, -60.46875, 167.34375, 168.75}},
	{"7pcgp042wz", Box{-0.878782868385, -0.878777503967, -42.2280657291, -42.2280550003}},
	{"9t", Box{28.125, 33.75, -112.5, -101.25}},
	{"d", Box{0.0, 45.0, -90.0, -45.0}},
	{"qd0pwby4y", Box{-32.4270486832, -32.4270057678, 112.805128098, 112.805171013}},
	{"b", Box{45.0, 90.0, -180.0, -135.0}},
	{"yet", Box{64.6875, 66.09375, 119.53125, 120.9375}},
	{"v4pbsh7cp", Box{56.3614082336, 56.361451149, 56.0796689987, 56.0797119141}},
	{"kvr7u7pm7jeu", Box{-14.7921594232, -14.7921592556, 44.1421702132, 44.1421705484}},
	{"687jj", Box{-42.71484375, -42.6708984375, -63.0615234375, -63.017578125}},
	{"4w29", Box{-54.66796875, -54.4921875, -66.796875, -66.4453125}},
	{"6bz45dve", Box{-40.4140663147, -40.4138946533, -46.2448883057, -46.2445449829}},
	{"gfysykk0nw29", Box{61.32709058, 61.3270907477, -1.82894401252, -1.82894367725}},
	{"pdw4scw", Box{-75.4898071289, -75.4884338379, 166.15447998, 166.155853271}},
	{"65f4", Box{-23.5546875, -23.37890625, -87.1875, -86.8359375}},
	{"jc9g6tpd08j", Box{-80.9634017944, -80.9634004533, 81.3311286271, 81.3311299682}},
	{"ckw1tvf18r09", Box{70.608052779, 70.6080529466, -115.057056472, -115.057056136}},
	{"2cbtp", Box{-34.27734375, -34.2333984375, -145.239257812, -145.1953125}},
	{"54myf", Box{-76.1572265625, -76.11328125, -36.826171875, -36.7822265625}},
	{"kw", Box{-11.25, -5.625, 22.5, 33.75}},
	{"mw", Box{-11.25, -5.625, 67.5, 78.75}},
	{"2bjvee8sgek", Box{-44.0131442249, -44.0131428838, -138.009411693, -138.009410352}},
	{"yj6r4eyxuv1", Box{75.783675313, 75.7836766541, 93.2830573618, 93.2830587029}},
	{"n", Box{-90.0, -45.0, 90.0, 135.0}},
	{"pkec4ng", Box{-64.4746398926, -64.4732666016, 151.615447998, 151.616821289}},
	{"uvpynzd0v", Box{74.2210149765, 74.2210578918, 44.9480295181, 44.9480724335}},
	{"grxrc9by8g4", Box{88.5605496168, 88.5605509579, -23.4877046943, -23.4877033532}},
	{"6z0", Box{-5.625, -4.21875, -56.25, -54.84375}},
	{"s", Box{0.0, 45.0, 0.0, 45.0}},
	{"6npe6", Box{-10.6787109375, -10.634765625, -79.365234375, -79.3212890625}},
	{"04wzmgz23", Box{-74.6424436569, -74.6424007416, -170.245127678, -170.245084763}},
	{"dmfzk9", Box{33.6236572266, 33.6291503906, -74.6850585938, -74.6740722656}},
	{"eeu", Box{21.09375, 22.5, -16.875, -15.46875}},
	{"84bd9k3t", Box{15.9324073792, 15.9325790405, -179.239883423, -179.2395401}},
	{"7q6ywwxq2kc", Box{-8.664367944, -8.6643666029, -29.5871995389, -29.5871981978}},
	{"bve6jyuwk", Box{76.327214241, 76.3272571564, -141.420650482, -141.420607567}},
	{"h558", Box{-73.125, -72.94921875, 4.921875, 5.2734375}},
	{"sk4f3d2h1vq", Box{22.9085822403, 22.9085835814, 15.1831886172, 15.1831899583}},
	{"tffnvn", Box{16.6882324219, 16.6937255859, 81.7822265625, 81.7932128906}},
	{"eppvmm886m", Box{40.3281337023, 40.3281390667, -33.8700664043, -33.8700556755}},
	{"d2w", Box{2.8125, 4.21875, -70.3125, -68.90625}},
	{"sd3", Box{12.65625, 14.0625, 23.90625, 25.3125}},
	{"q73kk", Box{-25.9716796875, -25.927734375, 103.18359375, 103.227539062}},
	{"wtz5yx", Box{33.0413818359, 33.046875, 122.629394531, 122.640380859}},
	{"xw8z", Box{37.79296875, 37.96875, 158.5546875, 158.90625}},
	{"dyhuchkt7qr", Box{34.6092416346, 34.6092429757, -49.5200385153, -49.5200371742}},
	{"pyb1es47f", Box{-51.7449617386, -51.7449188232, 168.906984329, 168.907027245}},
	{"v6jcgfj1nus", Box{56.5687993169, 56.568800658, 64.5078939199, 64.507895261}},
	{"xxe", Box{42.1875, 43.59375, 161.71875, 163.125}},
	{"7xdvcext7rq", Box{-1.78159162402, -1.78159028292, -18.5564473271, -18.556445986}},
	{"1f35b7w", Box{-76.6653442383, -76.6639709473, -99.8245239258, -99.8231506348}},
	{"he675b8pjek", Box{-71.187440604, -71.1874392629, 25.8290988207, 25.8291001618}},
	{"pzj3", Box{-50.44921875, -50.2734375, 176.1328125, 176.484375}},
	{"1s1m8j10zwq3", Box{-66.5055748634, -66.5055746958, -110.740483962, -110.740483627}},
	{"sk4xsg4ufxm", Box{23.8356931508, 23.8356944919, 14.9782557786, 14.9782571197}},
	{"r3m2ker83", Box{-37.906908989, -37.9068660736, 153.840909004, 153.84095192}},
	{"p7bj", Box{-68.02734375, -67.8515625, 146.25, 146.6015625}},
	{"4wws597u", Box{-52.7268218994, -52.726650238, -58.2004165649, -58.2000732422}},
	{"u9rk", Box{52.734375, 52.91015625, 32.6953125, 33.046875}},
	{"2mv856bp9uj4", Box{-12.6398345456, -12.6398343779, -160.872720927, -160.872720592}},
	{"57th4543xnbs", Box{-69.5926011354, -69.5926009677, -26.6274683923, -26.627468057}},
	{"8pct", Box{44.47265625, 44.6484375, -177.890625, -177.5390625}},
	{"me0skjqbk8", Box{-27.3490476608, -27.3490422964, 68.3883690834, 68.3883798122}},
	{"30s74", Box{-41.66015625, -41.6162109375, -128.935546875, -128.891601562}},
	{"9r0h9fedn", Box{40.1800918579, 40.1801347733, -123.668031693, -123.667988777}},
	{"9v6gvte7r", Box{30.2211999893, 30.2212429047, -97.136349678, -97.1363067627}},
	{"j5d", Box{-70.3125, -68.90625, 47.8125, 49.21875}},
	{"hf8ge", Box{-75.322265625, -75.2783203125, 34.9365234375, 34.98046875}},
	{"hf2hmz", Box{-76.5582275391, -76.552734375, 34.0026855469, 34.013671875}},
	{"5wc405", Box{-51.6632080078, -51.6577148438, -21.09375, -21.0827636719}},
	{"x2dk49y7p8", Box{3.52575302124, 3.52575838566, 149.532830715, 149.532841444}},
	{"350jjfux7dbk", Box{-27.2297275811, -27.2297274135, -134.740984105, -134.740983769}},
	{"04wd", Box{-75.5859375, -75.41015625, -170.859375, -170.5078125}},
	{"1zxmhstk", Box{-46.9081878662, -46.9080162048, -90.8497238159, -90.8493804932}},
	{"b2sj26ddce3", Box{48.7495739758, 48.7495753169, -163.11051473, -163.110513389}},
	{"vznd8mz363", Box{84.8462587595, 84.8462641239, 87.9116642475, 87.9116749763}},
	{"f", Box{45.0, 90.0, -90.0, -45.0}},
	{"0", Box{-90.0, -45.0, -180.0, -135.0}},
	{"kw", Box{-11.25, -5.625, 22.5, 33.75}},
	{"1s0nq579", Box{-66.3833427429, -66.3831710815, -112.231521606, -112.231178284}},
	{"mzky2scd", Box{-3.09368133545, -3.09350967407, 85.4537200928, 85.4540634155}},
	{"kctpzwx2rxg", Box{-35.1644052565, -35.1644039154, 41.121122092, 41.1211234331}},
	{"19", Box{-84.375, -78.75, -112.5, -101.25}},
	{"pmg4wc8pn", Box{-57.2073554993, -57.2073125839, 150.765638351, 150.765681267}},
	{"sxcn0yd0jck", Box{44.6841497719, 44.684151113, 23.9422076941, 23.9422090352}},
	{"000dsj4g", Box{-89.5325660706, -89.5323944092, -179.1173172, -179.116973877}},
	{"pgv0", Box{-68.90625, -68.73046875, 175.78125, 176.1328125}},
	{"dhw0935d8", Box{25.4063129425, 25.4063558578, -81.5027618408, -81.5027189255}},
	{"4gvz08kbk9", Box{-67.6743596792, -67.6743543148, -48.1353735924, -48.1353628635}},
	{"djz4g1m", Box{32.8340148926, 32.8353881836, -80.0175476074, -80.0161743164}},
	{"x4yhn1h5m1z", Box{16.1779354513, 16.1779367924, 143.706889004, 143.706890345}},
	{"9t", Box{28.125, 33.75, -112.5, -101.25}},
	{"d", Box{0.0, 45.0, -90.0, -45.0}},
	{"4fgytpvp2v", Box{-73.3448284864, -73.344823122, -50.7499372959, -50.7499265671}},
	{"jggxx", Box{-67.587890625, -67.5439453125, 83.9794921875, 84.0234375}},
	{"mye8t1", Box{-8.34411621094, -8.33862304688, 83.8916015625, 83.9025878906}},
	{"bssun7dstj", Box{71.0356503725, 71.0356557369, -150.542006493, -150.541995764}},
	{"ehhv", Box{23.37890625, 23.5546875, -38.3203125, -37.96875}},
	{"484tc", Box{-88.9892578125, -88.9453125, -63.9404296875, -63.896484375}},
	{"d4tjtv", Box{15.0567626953, 15.0622558594, -82.7160644531, -82.705078125}},
	{"2z", Box{-5.625, 0.0, -146.25, -135.0}},
	{"t5ey32", Box{20.7861328125, 20.7916259766, 50.3283691406, 50.3393554688}},
	{"um", Box{73.125, 78.75, 11.25, 22.5}},
	{"pe", Box{-73.125, -67.5, 157.5, 168.75}},
	{"2x05zw6z", Box{-4.93028640747, -4.93011474609, -157.166633606, -157.166290283}},
	{"67", Box{-28.125, -22.5, -78.75, -67.5}},
	{"dxfr3yndexbg", Box{44.9015942775, 44.9015944451, -64.249955602, -64.2499552667}},
	{"y87", Box{46.40625, 47.8125, 116.71875, 118.125}},
	{"2h29w", Box{-20.830078125, -20.7861328125, -179.033203125, -178.989257812}},
	{"cv", Box{73.125, 78.75, -101.25, -90.0}},
	{"jcx2m1mjy9e", Box{-81.5106931329, -81.5106917918, 89.1721884906, 89.1721898317}},
	{"ryj9w", Box{-10.986328125, -10.9423828125, 176.748046875, 176.791992188}},
	{"g5sftxrhf40", Box{65.1676046848, 65.1676060259, -38.0689144135, -38.0689130723}},
	{"nhs95z98z", Box{-64.4703912735, -64.4703483582, 96.4952802658, 96.4953231812}},
	{"s7n00se8u3n", Box{16.8998533487, 16.8998546898, 19.7144696116, 19.7144709527}},
	{"4310r6m", Box{-84.3186950684, -84.3173217773, -77.0182800293, -77.0169067383}},
	{"7kkmp", Box{-20.21484375, -20.1708984375, -27.4658203125, -27.421875}},
	{"3dvnpf13665", Box{-28.4653508663, -28.4653495252, -105.126356632, -105.12635529}},
	{"1cv2hegqd1s7", Box{-80.1345262863, -80.1345261186, -93.6648788676, -93.6648785323}},
	{"uy0yttxwk65", Box{79.9238741398, 79.9238754809, 35.0568728149, 35.056874156}},
	{"166cs2etxffy", Box{-77.0763716474, -77.0763714798, -119.690902121, -119.690901786}},
	{"bm7n7", Box{75.6298828125, 75.673828125, -164.399414062, -164.35546875}},
	{"5r7q", Box{-48.1640625, -47.98828125, -29.1796875, -28.828125}},
	{"ymjqjv6", Box{74.2085266113, 74.2098999023, 108.888244629, 108.88961792}},
	{"jx95kpvmv9", Box{-47.1976464987, -47.1976411343, 69.0894770622, 69.0894877911}},
	{"f1m4m9", Box{52.4322509766, 52.4377441406, -82.7270507812, -82.7160644531}},
	{"0cdr1wfep", Box{-80.2944374084, -80.2943944931, -143.016285896, -143.016242981}},
	{"fe4q2v7", Box{63.0024719238, 63.0038452148, -64.2988586426, -64.2974853516}},
	{"9pxfyb9p", Box{42.6748466492, 42.6750183105, -123.80355835, -123.803215027}},
	{"8w088r", Box{33.8763427734, 33.8818359375, -156.785888672, -156.774902344}},
	{"u569fj", Box{63.6163330078, 63.6218261719, 3.603515625, 3.61450195312}},
	{"smvm0syj0kst", Box{33.2496320643, 33.2496322319, 18.6630416662, 18.6630420014}},
	{"vx", Box{84.375, 90.0, 67.5, 78.75}},
	{"zj", Box{73.125, 78.75, 135.0, 146.25}},
	{"5", Box{-90.0, -45.0, -45.0, 0.0}},
	{"3", Box{-45.0, 0.0, -135.0, -90.0}},
	{"69n85w0", Box{-39.3420410156, -39.3406677246, -58.2055664062, -58.2041931152}},
	{"ywmj", Box{81.03515625, 81.2109375, 119.53125, 119.8828125}},
	{"2717c52t", Box{-27.4471092224, -27.446937561, -166.947555542, -166.947212219}},
	{"t1h", Box{5.625, 7.03125, 50.625, 52.03125}},
	{"c", Box{45.0, 90.0, -135.0, -90.0}},
	{"5xphd2", Box{-49.833984375, -49.8284912109, -12.5573730469, -12.5463867188}},
	{"xy8", Box{36.5625, 37.96875, 168.75, 170.15625}},
	{"t", Box{0.0, 45.0, 45.0, 90.0}},
	{"3pet007v7qb", Box{-1.93128302693, -1.93128168583, -130.072835684, -130.072834343}},
	{"dyuz", Box{39.19921875, 39.375, -49.5703125, -49.21875}},
	{"6r", Box{-5.625, 0.0, -78.75, -67.5}},
	{"y8v06s5", Box{49.2846679688, 49.2860412598, 119.645233154, 119.646606445}},
	{"6", Box{-45.0, 0.0, -90.0, -45.0}},
	{"mfuy2m", Box{-28.4051513672, -28.3996582031, 85.4406738281, 85.4516601562}},
	{"dnp2u", Box{33.8818359375, 33.92578125, -79.62890625, -79.5849609375}},
	{"g4u3ehx6", Box{60.757484436, 60.7576560974, -38.8816452026, -38.8813018799}},
	{"q14h9tg88tx", Box{-38.5522833467, -38.5522820055, 92.8832553327, 92.8832566738}},
	{"d4m6rn", Box{13.0847167969, 13.0902099609, -82.3095703125, -82.2985839844}},
	{"64", Box{-33.75, -28.125, -90.0, -78.75}},
	{"y2nzb", Box{46.3623046875, 46.40625, 110.7421875, 110.786132812}},
	{"yhs5m8ytcgxb", Box{70.8889147639, 70.8889149316, 95.8757111058, 95.875711441}},
	{"ytp9j8f0dv8", Box{73.305016458, 73.3050177991, 123.291438818, 123.291440159}},
	{"pxcpm2h", Box{-45.1318359375, -45.1304626465, 159.142456055, 159.143829346}},
	{"5zyf9", Box{-45.966796875, -45.9228515625, -1.7138671875, -1.669921875}},
	{"wmz7v2", Box{33.0029296875, 33.0084228516, 111.676025391, 111.687011719}},
	{"3fb7hkc8wus", Box{-28.9777037501, -28.977702409, -100.709314942, -100.709313601}},
	{"ssstmsrv", Box{26.2595558167, 26.259727478, 29.0804672241, 29.0808105469}},
	{"21", Box{-39.375, -33.75, -180.0, -168.75}},
	{"w0du7r8257", Box{3.60078513622, 3.60079050064, 94.0104925632, 94.0105032921}},
	{"fhx", Box{70.3125, 71.71875, -80.15625, -78.75}},
	{"1xd", Box{-47.8125, -46.40625, -109.6875, -108.28125}},
	{"s040p9v3shb2", Box{0.00989601016045, 0.00989617779851, 3.14947161824, 3.14947195351}},
	{"gq", Box{78.75, 84.375, -33.75, -22.5}},
	{"0", Box{-90.0, -45.0, -180.0, -135.0}},
	{"17b4wsgdq0q", Box{-68.4403167665, -68.4403154254, -123.459283412, -123.45928207}},
	{"x3qs", Box{7.734375, 7.91015625, 155.390625, 155.7421875}},
	{"rc", Box{-39.375, -33.75, 168.75, 180.0}},
	{"sfxjv06b9", Box{15.0747013092, 15.0747442245, 43.8172960281, 43.8173389435}},
	{"6", Box{-45.0, 0.0, -90.0, -45.0}},
	{"ngveyg", Box{-68.2305908203, -68.2250976562, 131.781005859, 131.791992188}},
	{"pmxd5bd39qp", Box{-58.7079012394, -58.7078998983, 156.964822859, 156.9648242}},
	{"xhw6", Box{25.6640625, 25.83984375, 143.7890625, 144.140625}},
	{"bc6vx6", Box{53.0090332031, 53.0145263672, -142.064208984, -142.053222656}},
	{"uuxy5sbu", Box{71.3939666748, 71.3941383362, 44.803276062, 44.8036193848}},
	{"yu", Box{67.5, 73.125, 123.75, 135.0}},
	{"610pf9c3ebh", Box{-38.0028247833, -38.0028234422, -89.888253808, -89.8882524669}},
	{"9d", Box{11.25, 16.875, -112.5, -101.25}},
	{"1s0tk4yp", Box{-66.5608406067, -66.5606689453, -111.612854004, -111.612510681}},
	{"ss7yjqhs5su", Box{24.9946086109, 24.994609952, 28.0104857683, 28.0104871094}},
	{"krqww1d0kp", Box{-3.06785166264, -3.06784629822, 20.6572151184, 20.6572258472}},
	{"4yzg18c07qnm", Box{-51.4997104369, -51.4997102693, -45.2841233835, -45.2841230482}},
	{"5wf241", Box{-52.0257568359, -52.0202636719, -19.248046875, -19.2370605469}},
	{"gxrh60ce", Box{86.5329551697, 86.5331268311, -12.5662994385, -12.5659561157}},
	{"5rzrgr9qf", Box{-45.0015878677, -45.0015449524, -23.4100627899, -23.4100198746}},
	{"u3", Box{50.625, 56.25, 11.25, 22.5}},
	{"8tm4uz7c", Box{30.0546455383, 30.0548171997, -150.254859924, -150.254516602}},
	{"wz5f3", Box{39.7705078125, 39.814453125, 129.067382812, 129.111328125}},
	{"ckz", Box{71.71875, 73.125, -113.90625, -112.5}},
	{"h4s31", Box{-75.76171875, -75.7177734375, 6.0205078125, 6.064453125}},
	{"hguje", Box{-67.939453125, -67.8955078125, 39.5068359375, 39.55078125}},
	{"4rnfer", Box{-50.1470947266, -50.1416015625, -69.1149902344, -69.1040039062}},
	{"gj", Box{73.125, 78.75, -45.0, -33.75}},
	{"04", Box{-78.75, -73.125, -180.0, -168.75}},
	{"kvj", Box{-16.875, -15.46875, 40.78125, 42.1875}},
	{"7c3p", Box{-36.73828125, -36.5625, -9.84375, -9.4921875}},
	{"rdw55", Box{-30.41015625, -30.3662109375, 166.069335938, 166.11328125}},
	{"7spe18wk094b", Box{-21.969217658, -21.9692174904, -11.8785988167, -11.8785984814}},
	{"uxumm", Box{89.5166015625, 89.560546875, 28.6962890625, 28.740234375}},
	{"1n0sh0", Box{-55.546875, -55.5413818359, -134.12109375, -134.110107422}},
	{"cphmy", Box{85.3857421875, 85.4296875, -128.759765625, -128.715820312}},
	{"sd", Box{11.25, 16.875, 22.5, 33.75}},
	{"h6jbb2gxyd0", Box{-78.6127030849, -78.6127017438, 19.3520092964, 19.3520106375}},
	{"x3", Box{5.625, 11.25, 146.25, 157.5}},
	{"yv289c0nbs", Box{74.625813961, 74.6258193254, 124.530050755, 124.530061483}},
	{"g1fxbp5", Box{56.2445068359, 56.245880127, -41.480255127, -41.4788818359}},
	{"bqdh", Box{82.265625, 82.44140625, -165.9375, -165.5859375}},
	{"w558neznn3", Box{16.8966346979, 16.8966400623, 95.2174007893, 95.2174115181}},
	{"up", Box{84.375, 90.0, 0.0, 11.25}},
	{"pmy73pm2r", Box{-57.0450925827, -57.0450496674, 155.090517998, 155.090560913}},
	{"jzerkufsjnh", Box{-46.5112745762, -46.5112732351, 83.5327059031, 83.5327072442}},
	{"8eks", Box{18.984375, 19.16015625, -151.171875, -150.8203125}},
	{"3rryyvfxc", Box{-2.99931049347, -2.99926757812, -112.551455498, -112.551412582}},
	{"vn0cz", Box{79.0576171875, 79.1015625, 46.3623046875, 46.40625}},
	{"skb5cnez", Box{27.4148368835, 27.4150085449, 11.2990951538, 11.2994384766}},
	{"3p5cu0yju", Box{-5.31227588654, -5.31223297119, -129.542369843, -129.542326927}},
	{"8yrwss1y2s", Box{36.3218951225, 36.3219004869, -135.502946377, -135.502935648}},
	{"7x9kys4ydp", Box{-1.95441305637, -1.95440769196, -20.4526805878, -20.4526698589}},
	{"u7gscks3", Box{66.9536018372, 66.9537734985, 16.2326431274, 16.2329864502}},
	{"30c8pz7", Box{-40.7414245605, -40.7400512695, -132.545928955, -132.544555664}},
	{"umertwj6wxuc", Box{77.2892892547, 77.2892894223, 16.0695068166, 16.0695071518}},
	{"n6", Box{-78.75, -73.125, 101.25, 112.5}},
	{"br8dqrhg058f", Box{87.6219940558, 87.6219942234, -167.765692659, -167.765692323}},
	{"tp", Box{39.375, 45.0, 45.0, 56.25}},
	{"33uy", Box{-34.1015625, -33.92578125, -117.0703125, -116.71875}},
	{"u3ps1jnxg", Box{51.356921196, 51.3569641113, 21.8498754501, 21.8499183655}},
	{"nqwmqymbyz", Box{-52.4801498652, -52.4801445007, 110.343879461, 110.34389019}},
	{"wfugcgd", Box{16.1471557617, 16.1485290527, 130.509338379, 130.51071167}},
	{"vp7g2eg", Box{86.3731384277, 86.3745117188, 50.2995300293, 50.3009033203}},
	{"zz", Box{84.375, 90.0, 168.75, 180.0}},
	{"859t0xmm6gwk", Box{20.6071523577, 20.6071525253, -177.861316167, -177.861315832}},
	{"bvjnf49wp1hu", Box{74.3262923509, 74.3262925185, -139.128492661, -139.128492326}},
	{"08ybs", Box{-85.693359375, -85.6494140625, -147.83203125, -147.788085938}},
	{"dr908p7", Box{42.3152160645, 42.3165893555, -77.339630127, -77.3382568359}},
	{"gufpbsu", Box{73.1071472168, 73.1085205078, -8.41003417969, -8.40866088867}},
	{"623c388eg2t", Box{-43.3706304431, -43.370629102, -76.2223117054, -76.2223103642}},
	{"8rc", Box{43.59375, 45.0, -167.34375, -165.9375}},
	{"h4", Box{-78.75, -73.125, 0.0, 11.25}},
	{"x84", Box{0.0, 1.40625, 160.3125, 161.71875}},
	{"bbxgcx6nyzk", Box{48.5127027333, 48.5127040744, -135.282602906, -135.282601565}},
	{"tqg06239nrht", Box{38.014278654, 38.0142788216, 60.5699611455, 60.5699614808}},
	{"05fd", Box{-68.5546875, -68.37890625, -176.484375, -176.1328125}},
	{"wuc", Box{26.71875, 28.125, 125.15625, 126.5625}},
	{"m3hh", Box{-38.671875, -38.49609375, 61.875, 62.2265625}},
	{"m2w4ru", Box{-41.7700195312, -41.7645263672, 65.0280761719, 65.0390625}},
	{"4cz3k", Box{-79.9365234375, -79.892578125, -45.87890625, -45.8349609375}},
	{"jqefz9v", Box{-52.9444885254, -52.9431152344, 61.8598937988, 61.8612670898}},
	{"qqcnf60wjf", Box{-5.83269953728, -5.83269417286, 102.756060362, 102.756071091}},
	{"n", Box{-90.0, -45.0, 90.0, 135.0}},
	{"n8qen549x9vr", Box{-88.0496587045, -88.0496585369, 121.908059008, 121.908059344}},
	{"g01nwm2wyj", Box{46.1726027727, 46.1726081371, -43.3181476593, -43.3181369305}},
	{"6xc", Box{-1.40625, 0.0, -66.09375, -64.6875}},
	{"v", Box{45.0, 90.0, 45.0, 90.0}},
	{"nmjjnhz67", Box{-60.9696149826, -60.9695720673, 108.555006981, 108.555049896}},
	{"2gzwv1zggqg", Box{-22.7094335854, -22.7094322443, -135.472611934, -135.472610593}},
	{"dt", Box{28.125, 33.75, -67.5, -56.25}},
	{"v33ysf2y0s", Box{53.1872391701, 53.1872445345, 58.9207291603, 58.9207398891}},
	{"fwy6tccjp3", Box{83.4186798334, 83.4186851978, -58.4565675259, -58.456556797}},
	{"qug6fjx4ue8k", Box{-17.7671476454, -17.7671474777, 128.418009616, 128.418009952}},
	{"8y59duq21", Box{34.0370178223, 34.0370607376, -141.198649406, -141.198606491}},
	{"pxgfrpkhdnk", Box{-45.9701107442, -45.9701094031, 163.086639047, 163.086640388}},
	{"91b", Box{9.84375, 11.25, -135.0, -133.59375}},
	{"v83mnvugmh", Box{47.3173213005, 47.3173266649, 69.5611810684, 69.5611917973}},
	{"k76cem9", Box{-26.4248657227, -26.4234924316, 15.2613830566, 15.2627563477}},
	{"ydjq0mk", Box{57.3335266113, 57.3348999023, 119.899291992, 119.900665283}},
	{"cdsuf", Box{59.8974609375, 59.94140625, -105.732421875, -105.688476562}},
	{"tuyz3", Box{27.9931640625, 28.037109375, 88.2861328125, 88.330078125}},
	{"r7r2skwfj00", Box{-26.605796814, -26.6057954729, 156.641564369, 156.64156571}},
	{"8hx507p9f5x", Box{25.8566424251, 25.8566437662, -170.134868771, -170.13486743}},
	{"cc", Box{50.625, 56.25, -101.25, -90.0}},
	{"pkuuvxz1z3", Box{-62.4034112692, -62.4034059048, 153.181310892, 153.181321621}},
	{"4", Box{-90.0, -45.0, -90.0, -45.0}},
	{"7vvz9gbf", Box{-11.316947937, -11.3167762756, -3.08612823486, -3.08578491211}},
	{"54r", Box{-77.34375, -75.9375, -35.15625, -33.75}},
	{"5r0mm0pwj1j", Box{-49.7011131048, -49.7011117637, -33.1681899726, -33.1681886315}},
	{"mx", Box{-5.625, 0.0, 67.5, 78.75}},
	{"rm39jwc", Box{-15.2558898926, -15.2545166016, 148.60244751, 148.603820801}},
	{"x", Box{0.0, 45.0, 135.0, 180.0}},
	{"k", Box{-45.0, 0.0, 0.0, 45.0}},
	{"4gqrkyvqc", Box{-70.4060983658, -70.4060554504, -47.2449445724, -47.2449016571}},
	{"9s36btfr9", Box{24.4225215912, 24.4225645065, -110.717082024, -110.717039108}},
	{"dxt5", Box{42.71484375, 42.890625, -60.46875, -60.1171875}},
	{"21x8tven9", Box{-36.4432811737, -36.4432382584, -169.196276665, -169.196233749}},
	{"7hh", Box{-22.5, -21.09375, -39.375, -37.96875}},
	{"v7nm8q7s", Box{62.8768157959, 62.8769874573, 65.0548553467, 65.0551986694}},
	{"e9qxh", Box{8.26171875, 8.3056640625, -13.18359375, -13.1396484375}},
	{"273", Box{-26.71875, -25.3125, -167.34375, -165.9375}},
	{"p99qpkcvb", Box{-80.4807329178, -80.4806900024, 159.578819275, 159.57886219}},
	{"q2062f9csybw", Box{-44.5904645696, -44.590464402, 101.637129262, 101.637129597}},
	{"btsq32", Box{77.0361328125, 77.0416259766, -151.468505859, -151.457519531}},
	{"1cj5", Box{-83.84765625, -83.671875, -94.21875, -93.8671875}},
	{"j71pemzwqxt9", Box{-71.7739416473, -71.7739414796, 57.8096582741, 57.8096586093}},
	{"qnqcbndu0nf", Box{-9.49970439076, -9.49970304966, 99.4959667325, 99.4959680736}},
	{"2v7cm6junqb", Box{-15.237314254, -15.2373129129, -140.737684965, -140.737683624}},
	{"e7", Box{16.875, 22.5, -33.75, -22.5}},
	{"s91p45", Box{6.87194824219, 6.87744140625, 23.994140625, 24.0051269531}},
	{"xwk1de36", Box{35.438117981, 35.4382896423, 163.236579895, 163.236923218}},
	{"gf2", Box{57.65625, 59.0625, -11.25, -9.84375}},
	{"d1m", Box{7.03125, 8.4375, -82.96875, -81.5625}},
	{"0b", Box{-90.0, -84.375, -146.25, -135.0}},
	{"rw4", Box{-11.25, -9.84375, 160.3125, 161.71875}},
	{"74pk9xsb", Box{-32.9177856445, -32.9176139832, -34.7322463989, -34.7319030762}},
	{"4ghe0cn8s", Box{-72.5920772552, -72.5920343399, -49.8798179626, -49.8797750473}},
	{"tw4", Box{33.75, 35.15625, 70.3125, 71.71875}},
	{"gevx3", Box{67.3681640625, 67.412109375, -14.7216796875, -14.677734375}},
	{"kw8w6yqc1ks", Box{-7.30433911085, -7.30433776975, 23.3333033323, 23.3333046734}},
	{"vbdjwzpg7", Box{48.8183069229, 48.8183498383, 81.8699026108, 81.8699455261}},
	{"tp", Box{39.375, 45.0, 45.0, 56.25}},
	{"751q", Box{-27.0703125, -26.89453125, -43.2421875, -42.890625}},
	{"yeurzu", Box{67.4780273438, 67.4835205078, 118.817138672, 118.828125}},
	{"svx", Box{30.9375, 32.34375, 43.59375, 45.0}},
	{"4yrg1w", Box{-54.2834472656, -54.2779541016, -45.2856445312, -45.2746582031}},
	{"h6xmxenmzkc", Box{-74.9532110989, -74.9532097578, 21.7837978899, 21.7837992311}},
	{"j5uzmqughwj1", Box{-67.5942097418, -67.5942095742, 51.9171233475, 51.9171236828}},
	{"26trngxu", Box{-29.6871185303, -29.6869468689, -161.059913635, -161.059570312}},
	{"9", Box{0.0, 45.0, -135.0, -90.0}},
	{"h58jxs7g", Box{-69.3218421936, -69.3216705322, 0.334739685059, 0.335083007812}},
	{"tg2kgbk3", Box{19.1177558899, 19.1179275513, 79.2721939087, 79.2725372314}},
	{"x34hfu", Box{6.48193359375, 6.48742675781, 149.183349609, 149.194335938}},
	{"774j", Box{-27.24609375, -27.0703125, -30.9375, -30.5859375}},
	{"yf", Box{56.25, 61.875, 123.75, 135.0}},
	{"0", Box{-90.0, -45.0, -180.0, -135.0}},
	{"e273k4gje9s", Box{1.64203494787, 1.64203628898, -28.9996308088, -28.9996294677}},
	{"e", Box{0.0, 45.0, -45.0, 0.0}},
	{"hx", Box{-50.625, -45.0, 22.5, 33.75}},
	{"wz", Box{39.375, 45.0, 123.75, 135.0}},
	{"w7p94b", Box{17.05078125, 17.0562744141, 111.917724609, 111.928710938}},
	{"69sgzyb46pbs", Box{-35.8658129722, -35.8658128045, -60.4796498269, -60.4796494916}},
	{"7f7m8k2u5", Box{-31.3529205322, -31.3528776169, -6.66754245758, -6.66749954224}},
	{"gq4n7m", Box{79.8760986328, 79.8815917969, -30.7946777344, -30.7836914062}},
	{"c1srg1pz8kt", Box{54.8066094518, 54.8066107929, -128.880941123, -128.880939782}},
	{"b2h1dy", Box{45.2966308594, 45.3021240234, -163.004150391, -162.993164062}},
	{"7170zy", Box{-37.8039550781, -37.7984619141, -40.4406738281, -40.4296875}},
	{"p09", Box{-87.1875, -85.78125, 136.40625, 137.8125}},
	{"sw970ux6", Box{37.114906311, 37.1150779724, 24.3007278442, 24.301071167}},
	{"rc8hsdptqn", Box{-35.7595646381, -35.7595592737, 168.958311081, 168.95832181}},
	{"qp3jujqc1", Box{-3.17899703979, -3.17895412445, 91.5913438797, 91.591386795}},
	{"dn7n9krj2tgg", Box{36.3231066428, 36.3231068105, -85.7166788355, -85.7166785002}},
	{"23e7vwt", Box{-35.8676147461, -35.8662414551, -163.931121826, -163.929748535}},
	{"um", Box{73.125, 78.75, 11.25, 22.5}},
	{"p8ws1", Box{-86.484375, -86.4404296875, 166.684570312, 166.728515625}},
	{"vqt63tm6xx", Box{81.9873136282, 81.9873189926, 63.7062621117, 63.7062728405}},
	{"b", Box{45.0, 90.0, -180.0, -135.0}},
	{"5", Box{-90.0, -45.0, -45.0, 0.0}},
	{"bm20d", Box{74.619140625, 74.6630859375, -168.662109375, -168.618164062}},
	{"p3t4k9c0", Box{-81.1573791504, -81.157207489, 153.480377197, 153.48072052}},
	{"x", Box{0.0, 45.0, 135.0, 180.0}},
	{"8rsnr3k0", Box{43.2929992676, 43.293170929, -162.80090332, -162.800559998}},
	{"b739vykqw", Box{63.6243152618, 63.6243581772, -166.381845474, -166.381802559}},
	{"m", Box{-45.0, 0.0, 45.0, 90.0}},
	{"13zrrq", Box{-78.8488769531, -78.8433837891, -113.236083984, -113.225097656}},
	{"6yk9jt", Box{-9.64050292969, -9.63500976562, -49.6801757812, -49.6691894531}},
	{"zmn0", Box{73.125, 73.30078125, 154.6875, 155.0390625}},
	{"k", Box{-45.0, 0.0, 0.0, 45.0}},
	{"ps151cxkk8", Box{-66.9636869431, -66.9636815786, 158.993303776, 158.993314505}},
	{"tn", Box{33.75, 39.375, 45.0, 56.25}},
	{"u7", Box{61.875, 67.5, 11.25, 22.5}},
	{"55yuz", Box{-68.0712890625, -68.02734375, -35.2001953125, -35.15625}},
	{"x0p3grv8k", Box{0.350232124329, 0.350275039673, 145.345859528, 145.345902443}},
	{"y5c6gjhshg", Box{66.6053169966, 66.605322361, 91.896032095, 91.8960428238}},
	{"6fd2j", Box{-30.9375, -30.8935546875, -52.8662109375, -52.822265625}},
	{"gegbfkt19cj6", Box{66.2505683675, 66.2505685352, -17.1207369491, -17.1207366139}},
	{"k7", Box{-28.125, -22.5, 11.25, 22.5}},
	{"y1ydbr", Box{55.3656005859, 55.37109375, 99.1516113281, 99.1625976562}},
	{"byqsd", Box{80.947265625, 80.9912109375, -137.021484375, -136.977539062}},
	{"mfcbxhf", Box{-29.4172668457, -29.4158935547, 81.5213012695, 81.5226745605}},
	{"yxwd5901", Box{87.5447273254, 87.5448989868, 121.794433594, 121.794776917}},
	{"24k7s7y0gqgj", Box{-31.7077504657, -31.7077502981, -173.828286678, -173.828286342}},
	{"9031fbu", Box{1.71798706055, 1.71936035156, -133.467407227, -133.466033936}},
	{"xqusuduvmc", Box{38.8197237253, 38.8197290897, 152.782648802, 152.782659531}},
	{"5bxw", Box{-86.1328125, -85.95703125, -0.703125, -0.3515625}},
	{"xw593h52f", Box{33.9918279648, 33.9918708801, 162.470369339, 162.470412254}},
	{"3", Box{-45.0, 0.0, -135.0, -90.0}},
	{"9xxm2s", Box{43.1323242188, 43.1378173828, -102.282714844, -102.271728516}},
	{"byf7t", Box{83.583984375, 83.6279296875, -142.866210938, -142.822265625}},
	{"v6", Box{56.25, 61.875, 56.25, 67.5}},
	{"yh", Box{67.5, 73.125, 90.0, 101.25}},
	{"d6k43xp", Box{13.0902099609, 13.091583252, -73.0494689941, -73.0480957031}},
	{"k4m5h", Box{-31.81640625, -31.7724609375, 7.20703125, 7.2509765625}},
	{"r1t7", Box{-36.03515625, -35.859375, 142.3828125, 142.734375}},
	{"cs4kvrjdkm7", Box{68.3738274872, 68.3738288283, -109.097485095, -109.097483754}},
	{"unu", Box{82.96875, 84.375, 5.625, 7.03125}},
	{"59xp", Box{-80.33203125, -80.15625, -12.65625, -12.3046875}},
	{"542p4hbm", Box{-76.0863304138, -76.0861587524, -44.9117660522, -44.9114227295}},
	{"5j", Box{-61.875, -56.25, -45.0, -33.75}},
	{"v3", Box{50.625, 56.25, 56.25, 67.5}},
	{"mstr13c0", Box{-18.4474182129, -18.4472465515, 74.9391174316, 74.9394607544}},
	{"wcvtdg61swv8", Box{10.8286933601, 10.8286935277, 131.608171687, 131.608172022}},
	{"3cm40m0w91z3", Box{-37.5885963254, -37.5885961577, -94.207024388, -94.2070240527}},
	{"m9fup0", Box{-34.453125, -34.4476318359, 71.6748046875, 71.6857910156}},
	{"jx", Box{-50.625, -45.0, 67.5, 78.75}},
	{"7myut8cg", Box{-11.8605995178, -11.8604278564, -24.013710022, -24.0133666992}},
	{"d", Box{0.0, 45.0, -90.0, -45.0}},
	{"5dgu11uuf12g", Box{-73.8176893629, -73.8176891953, -17.1760072187, -17.1760068834}},
	{"qp1ens1zqg", Box{-5.07442295551, -5.07441759109, 92.3977124691, 92.3977231979}},
	{"vusxu8ewwbrz", Box{71.6786695831, 71.6786697507, 85.2809854969, 85.2809858322}},
	{"8qjtgd1q", Box{34.7727584839, 34.7729301453, -160.860099792, -160.85975647}},
	{"60dppvw", Box{-40.9268188477, -40.9254455566, -86.838684082, -86.837310791}},
	{"tygxz83s2", Box{39.3331575394, 39.3332004547, 84.0035247803, 84.0035676956}},
	{"e0qwrc", Box{2.51037597656, 2.51586914062, -35.5187988281, -35.5078125}},
	{"5wyh2qbz", Box{-51.2458992004, -51.2457275391, -14.0504837036, -14.0501403809}},
	{"0zqs", Box{-48.515625, -48.33984375, -137.109375, -136.7578125}},
	{"n5ss", Box{-69.609375, -69.43359375, 96.328125, 96.6796875}},
	{"5", Box{-90.0, -45.0, -45.0, 0.0}},
	{"v9q84x9n8ktx", Box{52.0735898428, 52.0735900104, 76.7518796772, 76.7518800125}},
	{"4", Box{-90.0, -45.0, -90.0, -45.0}},
	{"j", Box{-90.0, -45.0, 45.0, 90.0}},
	{"2eh8wf4ktz", Box{-28.0253130198, -28.0253076553, -150.871907473, -150.871896744}},
	{"cr96dg281x", Box{87.6448434591, 87.6448488235, -121.870586872, -121.870576143}},
	{"56u", Box{-74.53125, -73.125, -28.125, -26.71875}},
	{"628vt", Box{-41.220703125, -41.1767578125, -77.4755859375, -77.431640625}},
	{"0heb", Box{-64.6875, -64.51171875, -174.7265625, -174.375}},
	{"8q5skg4mk", Box{34.5144510269, 34.5144939423, -163.616123199, -163.616080284}},
	{"7x0pw97495hw", Box{-4.2993279174, -4.29932774976, -22.2101866454, -22.2101863101}},
	{"1j4vjyz1dqx", Box{-60.9587225318, -60.9587211907, -130.870407969, -130.870406628}},
	{"u4q1szh", Box{57.9583740234, 57.9597473145, 8.65173339844, 8.65310668945}},
	{"3v3dbm2uv2", Box{-14.9556970596, -14.9556916952, -99.1283833981, -99.1283726692}},
	{"te3jtfwjnq", Box{19.2626702785, 19.262675643, 69.1674435139, 69.1674542427}},
	{"sgvgx3ey6qe", Box{21.7183318734, 21.7183332145, 42.1597914398, 42.1597927809}},
	{"2sw", Box{-19.6875, -18.28125, -149.0625, -147.65625}},
	{"wzy2pqu8e", Box{43.6309146881, 43.6309576035, 132.863974571, 132.864017487}},
	{"dk2849", Box{23.9117431641, 23.9172363281, -77.9370117188, -77.9260253906}},
	{"0d65", Box{-76.81640625, -76.640625, -154.6875, -154.3359375}},
	{"84", Box{11.25, 16.875, -180.0, -168.75}},
	{"q17", Box{-37.96875, -36.5625, 94.21875, 95.625}},
	{"x9wzer", Box{9.79431152344, 9.7998046875, 167.135009766, 167.145996094}},
	{"7xk2s7425n6", Box{-4.1143463552, -4.1143450141, -16.3334485888, -16.3334472477}},
	{"jv", Box{-61.875, -56.25, 78.75, 90.0}},
	{"u5juvw", Box{62.7429199219, 62.7484130859, 8.32763671875, 8.33862304688}},
	{"cnuczt0c", Box{83.3040046692, 83.3041763306, -127.989692688, -127.989349365}},
	{"7f3jv330zuh", Box{-31.3259911537, -31.3259898126, -9.61132586002, -9.61132451892}},
	{"5", Box{-90.0, -45.0, -45.0, 0.0}},
	{"70jqgb8uv", Box{-43.8099145889, -43.8098716736, -37.4511480331, -37.4511051178}},
	{"u5t5d155", Box{65.3087425232, 65.3089141846, 7.12326049805, 7.1236038208}},
	{"r9hy1gz8m4p", Box{-38.2996594906, -38.2996581495, 164.267115444, 164.267116785}},
	{"qwmurb9920", Box{-9.09371852875, -9.09371316433, 120.928573608, 120.928584337}},
	{"d2pt693fw4", Box{0.930157899857, 0.930163264275, -68.0906009674, -68.0905902386}},
	{"zfgbx", Box{60.556640625, 60.6005859375, 174.331054688, 174.375}},
	{"c7mtdqkfuuc", Box{64.2828767002, 64.2828780413, -115.910019726, -115.910018384}},
	{"9", Box{0.0, 45.0, -135.0, -90.0}},
	{"w89eqd", Box{3.39477539062, 3.40026855469, 114.895019531, 114.906005859}},
	{"75mtem68vx", Box{-25.7229477167, -25.7229423523, -37.1191334724, -37.1191227436}},
	{"12e9fwr", Box{-86.8455505371, -86.8441772461, -118.708648682, -118.707275391}},
	{"v", Box{45.0, 90.0, 45.0, 90.0}},
	{"nq", Box{-56.25, -50.625, 101.25, 112.5}},
	{"svnx", Box{29.35546875, 29.53125, 42.890625, 43.2421875}},
	{"0e1kd5pxdgt", Box{-72.316198647, -72.3161973059, -155.64387247, -155.643871129}},
	{"pgk", Box{-71.71875, -70.3125, 174.375, 175.78125}},
	{"vry9q", Box{88.8134765625, 88.857421875, 65.654296875, 65.6982421875}},
	{"6f2x91u", Box{-31.0157775879, -31.0144042969, -55.4974365234, -55.4960632324}},
	{"3hefw", Box{-19.248046875, -19.2041015625, -129.462890625, -129.418945312}},
	{"g", Box{45.0, 90.0, -45.0, 0.0}},
	{"m66erp", Box{-31.7340087891, -31.728515625, 60.0732421875, 60.0842285156}},
	{"5nwny", Box{-52.2509765625, -52.20703125, -36.298828125, -36.2548828125}},
	{"d5", Box{16.875, 22.5, -90.0, -78.75}},
	{"wuphy8", Box{23.3349609375, 23.3404541016, 133.879394531, 133.890380859}},
	{"b8u631kf", Box{49.6214675903, 49.6216392517, -151.472969055, -151.472625732}},
	{"34d8j", Box{-30.9375, -30.8935546875, -131.264648438, -131.220703125}},
	{"x", Box{0.0, 45.0, 135.0, 180.0}},
	{"he", Box{-73.125, -67.5, 22.5, 33.75}},
	{"yec1yepjd", Box{66.4187908173, 66.4188337326, 114.201593399, 114.201636314}},
	{"h0p58hpz", Box{-89.3615913391, -89.3614196777, 9.85439300537, 9.85473632812}},
	{"8u", Box{22.5, 28.125, -146.25, -135.0}},
	{"hg9sxf0mu", Box{-69.509510994, -69.5094680786, 36.200466156, 36.2005090714}},
	{"7zdg4c9868", Box{-2.27687358856, -2.27686822414, -7.25979566574, -7.2597849369}},
	{"1h", Box{-67.5, -61.875, -135.0, -123.75}},
	{"k7h239zr4097", Box{-28.0702368356, -28.070236668, 17.3025243357, 17.302524671}},
	{"9h", Box{22.5, 28.125, -135.0, -123.75}},
	{"fx", Box{84.375, 90.0, -67.5, -56.25}},
	{"sf66h05", Box{13.0078125, 13.009185791, 37.093963623, 37.0953369141}},
	{"4ge39", Box{-70.048828125, -70.0048828125, -51.6357421875, -51.591796875}},
	{"w", Box{0.0, 45.0, 90.0, 135.0}},
	{"7", Box{-45.0, 0.0, -45.0, 0.0}},
	{"ypd", Box{87.1875, 88.59375, 92.8125, 94.21875}},
	{"gbzh2r", Box{50.0042724609, 50.009765625, -1.39526367188, -1.38427734375}},
	{"h0", Box{-90.0, -84.375, 0.0, 11.25}},
	{"nk7wkxwvku2", Box{-64.952994436, -64.9529930949, 106.379102468, 106.37910381}},
	{"23qu", Box{-37.265625, -37.08984375, -159.2578125, -158.90625}},
	{"n15b3", Box{-84.3310546875, -84.287109375, 95.3173828125, 95.361328125}},
	{"8x9c6f1cjkn", Box{42.4184060097, 42.4184073508, -154.915576279, -154.915574938}},
	{"5dr", Box{-77.34375, -75.9375, -12.65625, -11.25}},
	{"022q4", Box{-87.5390625, -87.4951171875, -168.310546875, -168.266601562}},
	{"52", Box{-90.0, -84.375, -33.75, -22.5}},
	{"s0j8hb", Box{0.0, 0.0054931640625, 7.94311523438, 7.9541015625}},
	{"58ygg9vn9nj", Box{-85.1113092899, -85.1113079488, -12.8470878303, -12.8470864892}},
	{"ztzqs1", Box{78.4918212891, 78.4973144531, 167.87109375, 167.882080078}},
	{"n5x", Box{-70.3125, -68.90625, 99.84375, 101.25}},
	{"jh593g3fsf", Box{-67.261980772, -67.2619754076, 50.001386404, 50.0013971329}},
	{"8vjg52364", Box{28.6540603638, 28.6541032791, -138.01943779, -138.019394875}},
	{"dqeh1", Box{37.265625, 37.3095703125, -74.4873046875, -74.443359375}},
	{"2", Box{-45.0, 0.0, -180.0, -135.0}},
	{"m1mjx", Box{-37.001953125, -36.9580078125, 52.3388671875, 52.3828125}},
	{"w4fr", Box{16.69921875, 16.875, 93.1640625, 93.515625}},
	{"k2v0kj", Box{-40.7098388672, -40.7043457031, 18.45703125, 18.4680175781}},
	{"ytmdb30u", Box{75.0208282471, 75.0209999084, 120.246391296, 120.246734619}},
	{"wzuhv", Box{44.4287109375, 44.47265625, 129.594726562, 129.638671875}},
	{"84m2ue733hx1", Box{12.8061776049, 12.8061777726, -172.414918095, -172.41491776}},
	{"02", Box{-90.0, -84.375, -168.75, -157.5}},
	{"x8j5vd68s", Box{0.671625137329, 0.671668052673, 164.776554108, 164.776597023}},
	{"7k", Box{-22.5, -16.875, -33.75, -22.5}},
	{"4xtrffmbtxr", Box{-46.4377109706, -46.4377096295, -59.9881960452, -59.9881947041}},
	{"k8x", Box{-42.1875, -40.78125, 32.34375, 33.75}},
	{"yyxsh", Box{82.265625, 82.3095703125, 134.47265625, 134.516601562}},
	{"f2rqpzxu", Box{47.502822876, 47.5029945374, -68.2034683228, -68.203125}},
	{"d6h4jg", Box{11.6180419922, 11.6235351562, -72.8723144531, -72.861328125}},
	{"e7d", Box{19.6875, 21.09375, -30.9375, -29.53125}},
	{"bbs0tcr5wc9", Box{47.9078659415, 47.9078672826, -140.362410396, -140.362409055}},
	{"7fuf", Box{-29.1796875, -29.00390625, -4.5703125, -4.21875}},
	{"n", Box{-90.0, -45.0, 90.0, 135.0}},
	{"tt9p6y", Box{32.2448730469, 32.2503662109, 69.0270996094, 69.0380859375}},
	{"xypsv42g6pr", Box{34.5979173481, 34.5979186893, 179.517726749, 179.51772809}},
	{"p4gvh3sr97h", Box{-73.6428004503, -73.6427991092, 140.466100574, 140.466101915}},
	{"4", Box{-90.0, -45.0, -90.0, -45.0}},
	{"6ecy4rk", Box{-22.8117370605, -22.8103637695, -64.9346923828, -64.9333190918}},
	{"045xe38uj", Box{-77.4227142334, -77.4226713181, -174.934058189, -174.934015274}},
	{"xyunrc48", Box{39.0728759766, 39.0730476379, 174.719009399, 174.719352722}},
	{"enm03", Box{35.2001953125, 35.244140625, -37.9248046875, -37.880859375}},
	{"n7r9k6ecbhm", Box{-71.4849673212, -71.4849659801, 111.988799125, 111.988800466}},
	{"2bpxnf2", Box{-43.7571716309, -43.7557983398, -135.406494141, -135.40512085}},
	{"4", Box{-90.0, -45.0, -90.0, -45.0}},
	{"vs65p7h9m", Box{69.4502878189, 69.4503307343, 70.6374979019, 70.6375408173}},
	{"j6vt6yyjmms", Box{-73.5703888535, -73.5703875124, 64.1136950254, 64.1136963665}},
	{"pp7z8s7", Box{-47.8770446777, -47.8756713867, 140.299530029, 140.30090332}},
	{"skxsqyzdgn", Box{26.0971534252, 26.0971587896, 22.103934288, 22.1039450169}},
	{"y1x7mdy", Box{54.0238952637, 54.0252685547, 100.445251465, 100.446624756}},
	{"ck9n9vptne", Box{71.4834183455, 71.4834237099, -122.256267071, -122.256256342}},
	{"fq7u12930mgt", Box{80.862324927, 80.8623250946, -73.4198988229, -73.4198984876}},
	{"zs50j6", Box{67.5109863281, 67.5164794922, 161.949462891, 161.960449219}},
	{"9jccmq0j", Box{32.5972938538, 32.5974655151, -132.308349609, -132.308006287}},
	{"y", Box{45.0, 90.0, 90.0, 135.0}},
	{"hhtn7", Box{-63.5888671875, -63.544921875, 7.1630859375, 7.20703125}},
	{"480spdnxu", Box{-89.2845582962, -89.2845153809, -66.4581871033, -66.4581441879}},
	{"ghz87yh", Box{71.7956542969, 71.7970275879, -34.2828369141, -34.281463623}},
	{"cf", Box{56.25, 61.875, -101.25, -90.0}},
	{"gd1n5pnc8p7", Box{57.3434360325, 57.3434373736, -20.9526403248, -20.9526389837}},
	{"hef9dvw3q", Box{-68.6121511459, -68.6121082306, 26.1453151703, 26.1453580856}},
	{"wbjwhe8rkyf0", Box{1.07519432902, 1.07519449666, 131.682678759, 131.682679094}},
	{"pndb3wg", Box{-53.3564758301, -53.3551025391, 138.937225342, 138.938598633}},
	{"bh2k52ewybs", Box{69.6132829785, 69.6132843196, -179.500513673, -179.500512332}},
	{"t4r", Box{12.65625, 14.0625, 54.84375, 56.25}},
	{"s7215", Box{18.45703125, 18.5009765625, 11.3818359375, 11.42578125}},
	{"u8", Box{45.0, 50.625, 22.5, 33.75}},
	{"f2", Box{45.0, 50.625, -78.75, -67.5}},
	{"3hwb5r0etbt", Box{-19.6484443545, -19.6484430134, -125.36405012, -125.364048779}},
	{"wendsfh63", Box{17.3258256912, 17.3258686066, 121.855244637, 121.855287552}},
	{"90n", Box{0.0, 1.40625, -126.5625, -125.15625}},
	{"e5mx13zs4t2", Box{19.5220465958, 19.5220479369, -37.2002863884, -37.2002850473}},
	{"6kngstqxn", Box{-21.854724884, -21.8546819687, -69.0508747101, -69.0508317947}},
	{"rgs", Box{-25.3125, -23.90625, 174.375, 175.78125}},
	{"sbd1n1z90", Box{2.99806594849, 2.99810886383, 36.8364715576, 36.836514473}},
	{"693c7m26y6", Box{-37.7197015285, -37.7196961641, -64.8956286907, -64.8956179619}},
	{"ynu", Box{82.96875, 84.375, 95.625, 97.03125}},
	{"68t74uch2444", Box{-41.6333230957, -41.6333229281, -59.9949619174, -59.9949615821}},
	{"jcmv2zscc", Box{-82.0043992996, -82.0043563843, 86.875462532, 86.8755054474}},
	{"3c", Box{-39.375, -33.75, -101.25, -90.0}},
	{"r76ymc", Box{-25.6146240234, -25.6091308594, 150.369873047, 150.380859375}},
	{"kj9vj024cd", Box{-13.1817376614, -13.1817322969, 2.68072843552, 2.68073916435}},
	{"scr", Box{7.03125, 8.4375, 43.59375, 45.0}},
	{"57g8wvk", Box{-68.7895202637, -68.7881469727, -28.5260009766, -28.5246276855}},
	{"8qde6", Box{37.1337890625, 37.177734375, -165.146484375, -165.102539062}},
	{"7ve260", Box{-14.0185546875, -14.0130615234, -6.591796875, -6.58081054688}},
	{"trcxzhy6", Box{44.9824905396, 44.9826622009, 58.6755752563, 58.6759185791}},
	{"syqw7fyhx", Box{36.2707614899, 36.2708044052, 43.0639600754, 43.0640029907}},
	{"tb0", Box{0.0, 1.40625, 78.75, 80.15625}},
	{"dttugd1xtj5p", Box{31.7847627215, 31.7847628891, -59.2579753697, -59.2579750344}},
	{"v899zsbyh7f2", Box{48.1472598016, 48.1472599693, 69.9401802197, 69.940180555}},
	{"8e", Box{16.875, 22.5, -157.5, -146.25}},
	{"s", Box{0.0, 45.0, 0.0, 45.0}},
	{"ny4017r8x", Box{-56.2320613861, -56.2320184708, 126.628031731, 126.628074646}},
	{"8ued", Box{25.6640625, 25.83984375, -141.328125, -140.9765625}},
	{"bqpsbj0h9p1t", Box{79.6132376231, 79.6132377908, -158.203080073, -158.203079738}},
	{"s", Box{0.0, 45.0, 0.0, 45.0}},
	{"b5m", Box{63.28125, 64.6875, -172.96875, -171.5625}},
	{"t", Box{0.0, 45.0, 45.0, 90.0}},
	{"w722c", Box{18.4130859375, 18.45703125, 101.645507812, 101.689453125}},
	{"ey", Box{33.75, 39.375, -11.25, 0.0}},
	{"6ndrutd", Box{-7.04498291016, -7.04360961914, -86.6354370117, -86.6340637207}},
	{"c", Box{45.0, 90.0, -135.0, -90.0}},
	{"47jtykh", Box{-72.0922851562, -72.0909118652, -70.7354736328, -70.7341003418}},
	{"krb5qvkb", Box{-0.806121826172, -0.805950164795, 11.5531539917, 11.5534973145}},
	{"mtpgnes7uugs", Box{-16.3277602941, -16.3277601264, 78.6901270598, 78.6901273951}},
	{"6062z", Box{-43.4619140625, -43.41796875, -86.5283203125, -86.484375}},
	{"241quukp", Box{-32.5389289856, -32.5387573242, -178.027954102, -178.027610779}},
	{"g4m49", Box{58.095703125, 58.1396484375, -37.9248046875, -37.880859375}},
	{"wwq", Box{35.15625, 36.5625, 120.9375, 122.34375}},
	{"beujb1c", Box{67.1141052246, 67.1154785156, -151.873626709, -151.872253418}},
	{"h4", Box{-78.75, -73.125, 0.0, 11.25}},
	{"69xq1n9v", Box{-35.4712486267, -35.4710769653, -57.2583389282, -57.2579956055}},
	{"cjpu", Box{73.828125, 74.00390625, -124.1015625, -123.75}},
	{"pmks2611hw", Box{-59.7104895115, -59.7104841471, 152.590677738, 152.590688467}},
	{"zd78cuj300z8", Box{57.8102342784, 57.8102344461, 162.505999133, 162.505999468}},
	{"g9h460p7719", Box{51.0210737586, 51.0210750997, -16.777022928, -16.7770215869}},
	{"crncwf7g0c", Box{84.6515518427, 84.6515572071, -113.955999613, -113.955988884}},
	{"mp4", Box{-5.625, -4.21875, 47.8125, 49.21875}},
	{"3ghgz3gsjgr", Box{-27.4555031955, -27.4555018544, -94.2466463149, -94.2466449738}},
	{"m2g9", Box{-40.60546875, -40.4296875, 61.171875, 61.5234375}},
	{"ngt309w", Box{-70.1284790039, -70.1271057129, 131.163024902, 131.164398193}},
	{"hgn9u3537p", Box{-72.8116375208, -72.8116321564, 43.08198452, 43.0819952488}},
	{"6spnhu", Box{-21.4233398438, -21.4178466797, -57.4475097656, -57.4365234375}},
	{"z22v4r0d82", Box{47.3240375519, 47.3240429163, 147.404261827, 147.404272556}},
	{"ytypn", Box{78.57421875, 78.6181640625, 121.201171875, 121.245117188}},
	{"qstc", Box{-19.51171875, -19.3359375, 120.5859375, 120.9375}},
	{"y8r48c5", Box{46.8511962891, 46.8525695801, 122.380828857, 122.382202148}},
	{"uq2xybqqg", Box{81.5210866928, 81.5211296082, 12.2584676743, 12.2585105896}},
	{"95xm8dtz5u42", Box{20.6692528725, 20.6692530401, -124.77465447, -124.774654135}},
	{"x0uqxwj", Box{5.39428710938, 5.39566040039, 141.313018799, 141.31439209}},
	{"0kve9v", Box{-62.6385498047, -62.6330566406, -160.938720703, -160.927734375}},
	{"szwv1er87", Box{43.0843019485, 43.0843448639, 43.3185338974, 43.3185768127}},
	{"88zscymedp", Box{5.08868157864, 5.08868694305, -146.868581772, -146.868571043}},
	{"pd", Box{-78.75, -73.125, 157.5, 168.75}},
	{"g6", Box{56.25, 61.875, -33.75, -22.5}},
	{"3pg6r201vv51", Box{-1.01041479036, -1.01041462272, -130.110833198, -130.110832863}},
	{"y", Box{45.0, 90.0, 90.0, 135.0}},
	{"g02", Box{46.40625, 47.8125, -45.0, -43.59375}},
	{"jx", Box{-50.625, -45.0, 67.5, 78.75}},
	{"zksxs2nz2j3", Box{71.6321320832, 71.6321334243, 152.774163634, 152.774164975}},
	{"erqyg8ff4d", Box{41.9722473621, 41.9722527266, -24.1001200676, -24.1001093388}},
	{"n3wm1r3p4jev", Box{-80.6425363384, -80.6425361708, 110.095458291, 110.095458627}},
	{"sqfbq13pjp9", Box{38.0208036304, 38.0208049715, 15.3824485838, 15.3824499249}},
	{"2", Box{-45.0, 0.0, -180.0, -135.0}},
	{"y0", Box{45.0, 50.625, 90.0, 101.25}},
	{"04q3tpcc68bq", Box{-77.0372864977, -77.03728633, -170.988700055, -170.988699719}},
	{"81", Box{5.625, 11.25, -180.0, -168.75}},
	{"nj", Box{-61.875, -56.25, 90.0, 101.25}},
	{"b", Box{45.0, 90.0, -180.0, -135.0}},
	{"8bxs0rfgp3n7", Box{3.55871787295, 3.55871804059, -135.688042603, -135.688042268}},
	{"j0rm6", Box{-87.6708984375, -87.626953125, 55.283203125, 55.3271484375}},
	{"86v9", Box{15.64453125, 15.8203125, -161.015625, -160.6640625}},
	{"c", Box{45.0, 90.0, -135.0, -90.0}},
	{"nmcsv", Box{-56.8212890625, -56.77734375, 103.579101562, 103.623046875}},
	{"cqytkn1d56", Box{83.9249145985, 83.9249199629, -114.431394339, -114.43138361}},
	{"jfpcxxud86r9", Box{-78.4433147125, -78.4433145449, 89.9842279404, 89.9842282757}},
	{"zf8cm8fkrg", Box{59.2870920897, 59.2870974541, 170.049809217, 170.049819946}},
	{"98x", Box{2.8125, 4.21875, -102.65625, -101.25}},
	{"e5mbzuu", Box{18.4391784668, 18.4405517578, -36.5679931641, -36.566619873}},
	{"03g5kqkcp", Box{-79.5504570007, -79.5504140854, -164.337658882, -164.337615967}},
	{"b362q0b79x2", Box{52.0799548924, 52.0799562335, -165.321857929, -165.321856588}},
	{"m3pq", Box{-38.3203125, -38.14453125, 66.4453125, 66.796875}},
	{"6564m2w5b0", Box{-26.3198518753, -26.3198465109, -86.9485473633, -86.9485366344}},
	{"m9puw71wrf", Box{-38.5664212704, -38.566415906, 78.6754882336, 78.6754989624}},
	{"z", Box{45.0, 90.0, 135.0, 180.0}},
	{"9t34u", Box{30.0146484375, 30.05859375, -110.91796875, -110.874023438}},
	{"hewq3", Box{-69.2138671875, -69.169921875, 31.3330078125, 31.376953125}},
	{"2m2uy1tgg0", Box{-14.6249055862, -14.6249002218, -167.423615456, -167.423604727}},
	{"qu8dxgebd9wz", Box{-19.22872575, -19.2287255824, 124.798967354, 124.798967689}},
	{"scwmj", Box{9.31640625, 9.3603515625, 42.7587890625, 42.802734375}},
	{"9", Box{0.0, 45.0, -135.0, -90.0}},
	{"zm02460g", Box{73.1365013123, 73.1366729736, 146.701469421, 146.701812744}},
	{"cgtd84ky", Box{65.1403427124, 65.1405143738, -93.5091018677, -93.5087585449}},
	{"eq", Box{33.75, 39.375, -33.75, -22.5}},
	{"ht26dn8h", Box{-59.9929046631, -59.9927330017, 22.939453125, 22.9397964478}},
	{"c", Box{45.0, 90.0, -135.0, -90.0}},
	{"b", Box{45.0, 90.0, -180.0, -135.0}},
	{"j70dzsu", Box{-72.6155090332, -72.6141357422, 57.2882080078, 57.2895812988}},
	{"y241djby0dk", Box{45.2962996066, 45.2963009477, 104.151447415, 104.151448756}},
	{"un9", Box{81.5625, 82.96875, 1.40625, 2.8125}},
	{"2kzdj9", Box{-17.9241943359, -17.9187011719, -157.961425781, -157.950439453}},
	{"m7b3gj70", Box{-23.5697937012, -23.5696220398, 56.7375183105, 56.7378616333}},
	{"vvpmy3", Box{74.1412353516, 74.1467285156, 89.2199707031, 89.2309570312}},
	{"ym0n0", Box{74.1796875, 74.2236328125, 101.25, 101.293945312}},
	{"k6", Box{-33.75, -28.125, 11.25, 22.5}},
	{"d96nj5sqmjfn", Box{8.10626830906, 8.10626847669, -64.4617196918, -64.4617193565}},
	{"9yfrdwk", Box{39.3214416504, 39.3228149414, -97.9705810547, -97.9692077637}},
	{"8vj712jd0kv", Box{28.6527125537, 28.6527138948, -138.804685324, -138.804683983}},
	{"bk86yhd", Box{70.8206176758, 70.8219909668, -168.132019043, -168.130645752}},
	{"6e3pb2s87q10", Box{-25.3536236286, -25.353623461, -66.0764430463, -66.0764427111}},
	{"nxbn2n7yn", Box{-45.2722549438, -45.2722120285, 112.505407333, 112.505450249}},
	{"cg4n", Box{62.9296875, 63.10546875, -98.4375, -98.0859375}},
	{"4de6s37sk467", Box{-75.4904382862, -75.4904381186, -62.7379387245, -62.7379383892}},
	{"pzegg", Box{-47.1533203125, -47.109375, 174.155273438, 174.19921875}},
	{"xytyx62", Box{37.7174377441, 37.7188110352, 177.154541016, 177.155914307}},
	{"2x4", Box{-5.625, -4.21875, -154.6875, -153.28125}},
	{"j11m8j1eywcu", Box{-83.3800566941, -83.3800565265, 46.7601537332, 46.7601540685}},
	{"k2xw57e", Box{-41.1135864258, -41.1122131348, 21.9438171387, 21.9451904297}},
	{"2q74", Box{-9.4921875, -9.31640625, -164.53125, -164.1796875}},
	{"9tp1960t8", Box{28.4006023407, 28.400645256, -102.600631714, -102.600588799}},
	{"0", Box{-90.0, -45.0, -180.0, -135.0}},
	{"2b2mwb", Box{-42.626953125, -42.6214599609, -145.601806641, -145.590820312}},
	{"b7ts80s", Box{65.481262207, 65.482635498, -161.010131836, -161.008758545}},
	{"10x0", Box{-87.1875, -87.01171875, -125.15625, -124.8046875}},
	{"c5p9s65qqch", Box{62.1507364511, 62.1507377923, -124.261599183, -124.261597842}},
	{"n1j", Box{-84.375, -82.96875, 97.03125, 98.4375}},
	{"gjy9e2g7hcvc", Box{77.6120662875, 77.6120664552, -35.7118779793, -35.7118776441}},
	{"d0nngw26hnc0", Box{1.22123524547, 1.2212354131, -81.408175081, -81.4081747457}},
	{"sqqh99ewn", Box{35.9565353394, 35.9565782547, 19.7584819794, 19.7585248947}},
	{"27", Box{-28.125, -22.5, -168.75, -157.5}},
	{"9", Box{0.0, 45.0, -135.0, -90.0}},
	{"uv", Box{73.125, 78.75, 33.75, 45.0}},
	{"nu6", Box{-66.09375, -64.6875, 126.5625, 127.96875}},
	{"hjg9s97mjbfp", Box{-57.3848481663, -57.3848479986, 5.12434154749, 5.12434188277}},
	{"cekd", Box{63.6328125, 63.80859375, -106.171875, -105.8203125}},
	{"fx2s", Box{86.484375, 86.66015625, -66.796875, -66.4453125}},
	{"zxx5n4wh37", Box{87.7293223143, 87.7293276787, 167.615715265, 167.615725994}},
	{"k0redc", Box{-42.9730224609, -42.9675292969, 10.6677246094, 10.6787109375}},
	{"xhj810f1r7", Box{22.504350543, 22.5043559074, 142.781378031, 142.78138876}},
	{"9j", Box{28.125, 33.75, -135.0, -123.75}},
	{"3", Box{-45.0, 0.0, -135.0, -90.0}},
	{"z59900erg", Box{64.8673582077, 64.867401123, 137.113966942, 137.114009857}},
	{"6dnccesgx8ts", Box{-33.4225525707, -33.4225524031, -57.9350421578, -57.9350418225}},
	{"jx", Box{-50.625, -45.0, 67.5, 78.75}},
	{"312y4y56", Box{-36.8807601929, -36.8805885315, -133.819999695, -133.819656372}},
	{"32vk3g9np", Box{-40.013923645, -40.0138807297, -116.288609505, -116.288566589}},
	{"kn39", Box{-9.66796875, -9.4921875, 2.109375, 2.4609375}},
	{"eed4ybdn4mpp", Box{20.1747029833, 20.174703151, -19.3880166113, -19.3880162761}},
	{"st", Box{28.125, 33.75, 22.5, 33.75}},
	{"7", Box{-45.0, 0.0, -45.0, 0.0}},
	{"0t8kw4xyhu5x", Box{-58.2566988654, -58.2566986978, -156.873914078, -156.873913743}},
	{"dcy", Box{9.84375, 11.25, -47.8125, -46.40625}},
	{"p3r", Box{-82.96875, -81.5625, 156.09375, 157.5}},
	{"wdc0w9tbd6", Box{15.5649769306, 15.564982295, 114.199887514, 114.199898243}},
	{"j3jc", Box{-84.19921875, -84.0234375, 64.3359375, 64.6875}},
	{"k5cw3t", Box{-22.7801513672, -22.7746582031, 2.17529296875, 2.18627929688}},
	{"pd6m", Box{-76.46484375, -76.2890625, 160.6640625, 161.015625}},
	{"hnfqkjqrqnh", Box{-50.9025013447, -50.9025000036, 3.34868967533, 3.34869101644}},
	{"6qkwd", Box{-8.701171875, -8.6572265625, -72.333984375, -72.2900390625}},
	{"1q2x", Box{-53.61328125, -53.4375, -123.046875, -122.6953125}},
	{"3nps1et4nde", Box{-10.527292192, -10.5272908509, -124.380057603, -124.380056262}},
	{"gq2c8qnkx2", Box{80.4536533356, 80.4536587, -32.6754319668, -32.6754212379}},
	{"q7d", Box{-25.3125, -23.90625, 104.0625, 105.46875}},
	{"560", Box{-78.75, -77.34375, -33.75, -32.34375}},
	{"j855ffmuxv4s", Box{-89.3276607245, -89.3276605569, 71.8478319794, 71.8478323147}},
	{"sumfzt8z4", Box{24.4210624695, 24.4211053848, 42.1666431427, 42.166686058}},
	{"bje9d2n0", Box{76.201171875, 76.2013435364, -174.971008301, -174.970664978}},
	{"y943", Box{50.80078125, 50.9765625, 115.6640625, 116.015625}},
	{"3", Box{-45.0, 0.0, -135.0, -90.0}},
	{"gmn", Box{73.125, 74.53125, -25.3125, -23.90625}},
	{"1djwe5s", Box{-77.5881958008, -77.5868225098, -104.628295898, -104.626922607}},
	{"tb5wv3", Box{1.19201660156, 1.19750976562, 83.9025878906, 83.9135742188}},
	{"58h3qnfv9m", Box{-89.7422236204, -89.742218256, -16.2559354305, -16.2559247017}},
	{"f0du0sguugkg", Box{48.5425508581, 48.5425510257, -86.1054797843, -86.105479449}},
	{"h6zyvwk", Box{-73.3103942871, -73.3090209961, 22.3956298828, 22.3970031738}},
	{"vg2nu", Box{64.4677734375, 64.51171875, 78.92578125, 78.9697265625}},
	{"j7r7de", Box{-71.0870361328, -71.0815429688, 66.5551757812, 66.5661621094}},
	{"hjshn", Box{-58.359375, -58.3154296875, 5.888671875, 5.9326171875}},
	{"46khrs1t", Box{-76.5738487244, -76.573677063, -72.7933502197, -72.793006897}},
	{"g5p5p", Box{62.40234375, 62.4462890625, -34.8486328125, -34.8046875}},
	{"7pxgy2sf", Box{-2.15023040771, -2.15005874634, -33.8203811646, -33.8200378418}},
	{"vrz", Box{88.59375, 90.0, 66.09375, 67.5}},
	{"bry3ngyuq", Box{88.7908601761, 88.7909030914, -159.654779434, -159.654736519}},
	{"9cu9t1g3cs", Box{10.1173567772, 10.1173621416, -94.6976208687, -94.6976101398}},
	{"82", Box{0.0, 5.625, -168.75, -157.5}},
	{"m9yzmzsmxx", Box{-33.8396555185, -33.8396501541, 77.2510313988, 77.2510421276}},
	{"4wv4wwxb2dr2", Box{-51.5560363233, -51.5560361557, -60.1724312827, -60.1724309474}},
	{"j7ufy8", Box{-68.4228515625, -68.4173583984, 63.2153320312, 63.2263183594}},
	{"hzrjzg9xjj", Box{-48.1875532866, -48.1875479221, 43.9366006851, 43.936611414}},
	{"z5eh3ghtm7", Box{65.4519671202, 65.4519724846, 139.302059412, 139.302070141}},
	{"6sjhet2cts", Box{-21.6798663139, -21.6798609495, -60.3136754036, -60.3136646748}},
	{"vjyn6v", Box{78.4698486328, 78.4753417969, 53.5583496094, 53.5693359375}},
	{"hysxqy94", Box{-52.1270370483, -52.126865387, 40.3761291504, 40.3764724731}},
	{"8yd4qxm0d", Box{36.9979190826, 36.997961998, -143.144903183, -143.144860268}},
	{"w43b42f", Box{12.660369873, 12.6617431641, 92.5625610352, 92.5639343262}},
	{"7suc291x", Box{-18.0548286438, -18.0546569824, -15.7962799072, -15.7959365845}},
	{"pq", Box{-56.25, -50.625, 146.25, 157.5}},
	{"frd", Box{87.1875, 88.59375, -75.9375, -74.53125}},
	{"r2", Box{-45.0, -39.375, 146.25, 157.5}},
	{"5rs1x50fe5m", Box{-47.531902045, -47.5319007039, -27.8162173927, -27.8162160516}},
	{"zjv30682s21k", Box{77.5333506614, 77.533350829, 142.394326217, 142.394326553}},
	{"zbbtmw", Box{50.1745605469, 50.1800537109, 169.694824219, 169.705810547}},
	{"e56k", Box{18.984375, 19.16015625, -41.8359375, -41.484375}},
	{"v7dzp", Box{65.91796875, 65.9619140625, 60.4248046875, 60.46875}},
	{"n2z8qt2hnzss", Box{-85.707738027, -85.7077378593, 112.082815245, 112.08281558}},
	{"zbp8bt07bb5", Box{45.159945488, 45.1599468291, 179.319227189, 179.31922853}},
	{"s551t", Box{17.138671875, 17.1826171875, 4.4384765625, 4.482421875}},
	{"5zp7trjp", Box{-49.9701118469, -49.9699401855, -0.817108154297, -0.816764831543}},
	{"81n2z7dz", Box{5.77726364136, 5.77743530273, -170.888557434, -170.888214111}},
	{"dw", Box{33.75, 39.375, -67.5, -56.25}},
	{"vvw35", Box{76.11328125, 76.1572265625, 87.6708984375, 87.71484375}},
	{"zhtuc3b8bg5n", Box{71.1572198197, 71.1572199874, 143.141591996, 143.141592331}},
	{"042w4qgx", Box{-76.2507820129, -76.2506103516, -179.193191528, -179.192848206}},
	{"9sntb7", Box{23.5272216797, 23.5327148438, -103.348388672, -103.337402344}},
	{"wt6x5nxk", Box{30.7981109619, 30.7982826233, 116.157417297, 116.15776062}},
	{"spzwehn", Box{44.7583007812, 44.7596740723, 10.6869506836, 10.6883239746}},
	{"hv70sbbpw64", Box{-60.3754413128, -60.3754399717, 38.1777611375, 38.1777624786}},
	{"wxt", Box{42.1875, 43.59375, 119.53125, 120.9375}},
	{"7dvqsskj8", Box{-28.3643817902, -28.3643388748, -14.9139404297, -14.9138975143}},
	{"wm22", Box{29.53125, 29.70703125, 101.6015625, 101.953125}},
	{"5t4kf", Box{-61.0400390625, -60.99609375, -19.248046875, -19.2041015625}},
	{"5sy67z47fz1", Box{-62.846608758, -62.8466074169, -13.542933315, -13.5429319739}},
	{"c36nw2msv0t", Box{53.1760194898, 53.1760208309, -120.655067414, -120.655066073}},
	{"311v", Box{-38.49609375, -38.3203125, -132.5390625, -132.1875}},
	{"x", Box{0.0, 45.0, 135.0, 180.0}},
	{"xcykeys", Box{10.6704711914, 10.6718444824, 177.709350586, 177.710723877}},
	{"gtmvbbv", Box{75.5461120605, 75.5474853516, -14.3742370605, -14.3728637695}},
	{"5n1", Box{-56.25, -54.84375, -43.59375, -42.1875}},
	{"y08uf", Box{48.6474609375, 48.69140625, 91.142578125, 91.1865234375}},
	{"ds4", Box{22.5, 23.90625, -64.6875, -63.28125}},
	{"1t49n9", Box{-61.6937255859, -61.6882324219, -108.698730469, -108.687744141}},
	{"v81d55x758", Box{45.3713035583, 45.3713089228, 69.7513175011, 69.7513282299}},
	{"39j80vxmjh", Box{-39.3439078331, -39.3439024687, -104.722495079, -104.72248435}},
	{"x3vd66k2vj46", Box{10.251773335, 10.2517735027, 154.089306034, 154.089306369}},
	{"vg", Box{61.875, 67.5, 78.75, 90.0}},
	{"06q04jnnuyz", Box{-77.3150892556, -77.3150879145, -160.216156393, -160.216155052}},
	{"cvws", Box{76.640625, 76.81640625, -92.109375, -91.7578125}},
	{"9d5j84gmgbv", Box{12.2328941524, 12.2328954935, -108.276619166, -108.276617825}},
	{"mjg", Box{-12.65625, -11.25, 49.21875, 50.625}},
	{"k7gspu", Box{-23.1811523438, -23.1756591797, 16.5124511719, 16.5234375}},
	{"13nrmggfx", Box{-83.0795574188, -83.0795145035, -114.702801704, -114.702758789}},
	{"ypj759", Box{84.9078369141, 84.9133300781, 97.5366210938, 97.5476074219}},
	{"hhy3z0zjn", Box{-62.9686546326, -62.9686117172, 9.10655021667, 9.10659313202}},
	{"b0xhjv", Box{48.5430908203, 48.5485839844, -169.903564453, -169.892578125}},
	{"xucn7t7t11", Box{27.8470855951, 27.8470909595, 170.314908028, 170.314918756}},
	{"f0yqwpw6", Box{50.4028701782, 50.4030418396, -80.9386825562, -80.9383392334}},
	{"hcud164f7z", Box{-79.7932773829, -79.7932720184, 40.1369941235, 40.1370048523}},
	{"k7b09t", Box{-23.7908935547, -23.7854003906, 11.3159179688, 11.3269042969}},
	{"gzttr69", Box{88.1240844727, 88.1254577637, -3.19564819336, -3.19427490234}},
	{"z1", Box{50.625, 56.25, 135.0, 146.25}},
	{"mt", Box{-16.875, -11.25, 67.5, 78.75}},
	{"vgpm3pe", Box{62.839050293, 62.840423584, 88.9933776855, 88.9947509766}},
	{"xc2xk", Box{8.3056640625, 8.349609375, 169.62890625, 169.672851562}},
	{"7gpegjrrn", Box{-27.4357795715, -27.4357366562, -0.561075210571, -0.561032295227}},
	{"5m00s41bg21m", Box{-61.7759934627, -61.775993295, -33.5716743395, -33.5716740042}},
	{"ybz9un", Box{49.5593261719, 49.5648193359, 134.47265625, 134.483642578}},
	{"5cxhpu5jy6y", Box{-80.8364005387, -80.8363991976, -1.06127768755, -1.06127634645}},
	{"0gk7412", Box{-71.1845397949, -71.1831665039, -140.185546875, -140.184173584}},
	{"zj2", Box{74.53125, 75.9375, 135.0, 136.40625}},
	{"6jj5vt6zv5", Box{-16.1856347322, -16.1856293678, -82.7230596542, -82.7230489254}},
	{"mdp7x0cy8x", Box{-33.1294924021, -33.1294870377, 78.0053544044, 78.0053651333}},
	{"515", Box{-84.375, -82.96875, -40.78125, -39.375}},
	{"rcrpxqxje", Box{-36.613740921, -36.6136980057, 178.922095299, 178.922138214}},
	{"ydd5n3qr6tu", Box{59.5979855955, 59.5979869366, 115.595853925, 115.595855266}},
	{"hd", Box{-78.75, -73.125, 22.5, 33.75}},
	{"rj4uc", Box{-16.0400390625, -15.99609375, 138.911132812, 138.955078125}},
	{"0r3x", Box{-47.98828125, -47.8125, -166.640625, -166.2890625}},
	{"490rp8g4y", Box{-83.1399393082, -83.1398963928, -66.8144702911, -66.8144273758}},
	{"v19nuj", Box{54.6514892578, 54.6569824219, 46.58203125, 46.5930175781}},
	{"wrg3hx7", Box{43.8093566895, 43.8107299805, 106.022186279, 106.02355957}},
	{"ntzjry4", Box{-56.7004394531, -56.6990661621, 122.687072754, 122.688446045}},
	{"3s5c85t2d", Box{-22.2170162201, -22.2169733047, -107.219266891, -107.219223976}},
	{"wyy", Box{37.96875, 39.375, 132.1875, 133.59375}},
	{"6wk17", Box{-9.6240234375, -9.580078125, -61.7431640625, -61.69921875}},
	{"7m5wqccz7meg", Box{-15.7654795982, -15.7654794306, -28.5289463773, -28.5289460421}},
	{"sk8n5z1qd2", Box{26.4067554474, 26.4067608118, 11.4166080952, 11.416618824}},
	{"kw8hyjjj384", Box{-7.57417201996, -7.57417067885, 22.7706053853, 22.7706067264}},
	{"14rw6bt3vx9v", Box{-76.2420291267, -76.2420289591, -124.324827231, -124.324826896}},
	{"9cdu", Box{9.140625, 9.31640625, -97.3828125, -97.03125}},
	{"0cptj3e6crgm", Box{-83.4873395227, -83.4873393551, -135.467890911, -135.467890576}},
	{"0m", Box{-61.875, -56.25, -168.75, -157.5}},
	{"mx", Box{-5.625, 0.0, 67.5, 78.75}},
	{"p1sfuc", Box{-81.0736083984, -81.0681152344, 141.888427734, 141.899414062}},
	{"03nduncm", Box{-83.8536643982, -83.8534927368, -159.431877136, -159.431533813}},
	{"0m0j", Box{-60.99609375, -60.8203125, -168.75, -168.3984375}},
	{"7", Box{-45.0, 0.0, -45.0, 0.0}},
	{"fn", Box{78.75, 84.375, -90.0, -78.75}},
	{"srddrb0", Box{42.5830078125, 42.5843811035, 15.1062011719, 15.1075744629}},
	{"wpbf1dnj", Box{43.957157135, 43.9573287964, 91.1288452148, 91.1291885376}},
	{"nv8k1f98", Box{-58.3456420898, -58.3454704285, 124.180526733, 124.180870056}},
	{"7upj4ct1", Box{-21.6126823425, -21.6125106812, -1.27853393555, -1.27819061279}},
	{"k312nzxpwm", Box{-39.3324869871, -39.3324816227, 13.3143246174, 13.3143353462}},
	{"s", Box{0.0, 45.0, 0.0, 45.0}},
	{"qure08zn2n", Box{-20.5611813068, -20.5611759424, 134.328460693, 134.328471422}},
	{"m1", Box{-39.375, -33.75, 45.0, 56.25}},
	{"q7wbtv20e", Box{-25.195684433, -25.1956415176, 110.995001793, 110.995044708}},
	{"fsqx0ywr3s", Box{70.1736903191, 70.1736956835, -58.3177685738, -58.3177578449}},
	{"rn9k7k2927vd", Box{-7.66684871167, -7.66684854403, 136.901339516, 136.901339851}},
	{"8ypg", Box{34.27734375, 34.453125, -135.3515625, -135.0}},
	{"42ru", Box{-87.890625, -87.71484375, -67.8515625, -67.5}},
	{"z3efhtnprhw", Box{53.8177970052, 53.8177983463, 151.729739606, 151.729740947}},
	{"c", Box{45.0, 90.0, -135.0, -90.0}},
	{"fu", Box{67.5, 73.125, -56.25, -45.0}},
	{"uz9", Box{87.1875, 88.59375, 35.15625, 36.5625}},
	{"bqdnsr4y4", Box{82.7445602417, 82.744603157, -165.746870041, -165.746827126}},
	{"rshpnngvd", Box{-21.231508255, -21.2314653397, 163.393907547, 163.393950462}},
	{"4egtrvjfe", Box{-67.9555034637, -67.9554605484, -62.2295236588, -62.2294807434}},
	{"w", Box{0.0, 45.0, 90.0, 135.0}},
	{"7", Box{-45.0, 0.0, -45.0, 0.0}},
	{"r2m2yc", Box{-43.4564208984, -43.4509277344, 153.929443359, 153.940429688}},
	{"v9vps2z7", Box{56.1667442322, 56.1669158936, 74.727973938, 74.7283172607}},
	{"dh", Box{22.5, 28.125, -90.0, -78.75}},
	{"k", Box{-45.0, 0.0, 0.0, 45.0}},
	{"7", Box{-45.0, 0.0, -45.0, 0.0}},
	{"rrtp", Box{-1.58203125, -1.40625, 153.28125, 153.6328125}},
	{"57wdet", Box{-69.8455810547, -69.8400878906, -24.4555664062, -24.4445800781}},
	{"sxm3rvsc1x0y", Box{41.031399183, 41.0313993506, 30.229977183, 30.2299775183}},
	{"k", Box{-45.0, 0.0, 0.0, 45.0}},
	{"fmwp70q5", Box{77.2138023376, 77.213973999, -70.1724243164, -70.1720809937}},
	{"vq3whey", Box{81.2315368652, 81.2329101562, 58.5653686523, 58.5667419434}},
	{"vm55829xumn", Box{73.7443381548, 73.7443394959, 60.4819867015, 60.4819880426}},
	{"pc", Box{-84.375, -78.75, 168.75, 180.0}},
	{"76j", Box{-33.75, -32.34375, -26.71875, -25.3125}},
	{"du5md", Box{23.466796875, 23.5107421875, -51.591796875, -51.5478515625}},
	{"0b800r9", Box{-87.1463012695, -87.1449279785, -146.237640381, -146.23626709}},
	{"r96suj", Box{-37.1063232422, -37.1008300781, 161.19140625, 161.202392578}},
	{"dqn86", Box{33.7939453125, 33.837890625, -69.521484375, -69.4775390625}},
	{"62jjysq7fun", Box{-43.9652466774, -43.9652453363, -71.4243963361, -71.424394995}},
	{"s623s4p3v", Box{12.9312086105, 12.9312515259, 11.7875146866, 11.7875576019}},
	{"j9w5", Box{-81.03515625, -80.859375, 75.9375, 76.2890625}},
	{"cku2qh5ee64", Box{71.7852795124, 71.7852808535, -117.504816949, -117.504815608}},
	{"ypmy864vvgs", Box{86.9358202815, 86.9358216226, 98.1009525061, 98.1009538472}},
	{"kwe", Box{-8.4375, -7.03125, 26.71875, 28.125}},
	{"gmq7083dvewj", Box{75.0604587235, 75.0604588911, -24.9366608262, -24.9366604909}},
	{"9er", Box{18.28125, 19.6875, -102.65625, -101.25}},
	{"5p89tmjs9j5", Box{-47.5205630064, -47.5205616653, -44.0585620701, -44.058560729}},
	{"x", Box{0.0, 45.0, 135.0, 180.0}},
	{"ewy", Box{37.96875, 39.375, -14.0625, -12.65625}},
	{"jtgef", Box{-56.9970703125, -56.953125, 72.509765625, 72.5537109375}},
	{"9yjjw", Box{34.716796875, 34.7607421875, -93.955078125, -93.9111328125}},
	{"926", Box{1.40625, 2.8125, -120.9375, -119.53125}},
	{"bz1", Box{84.375, 85.78125, -144.84375, -143.4375}},
	{"yjjpq0ecnve", Box{74.4023618102, 74.4023631513, 97.3003654182, 97.3003667593}},
	{"w5e", Box{19.6875, 21.09375, 94.21875, 95.625}},
	{"hqcn9wtcr", Box{-50.8527517319, -50.8527088165, 12.7303647995, 12.7304077148}},
	{"qfh6xphngs", Box{-33.2709145546, -33.2709091902, 130.039823055, 130.039833784}},
	{"1he586fypp", Box{-64.0560919046, -64.0560865402, -130.766186714, -130.766175985}},
	{"4cc5sh9n3s", Box{-79.5152020454, -79.515196681, -54.666531086, -54.6665203571}},
	{"9y5wfm", Box{34.9639892578, 34.9694824219, -96.2292480469, -96.2182617188}},
	{"c97809", Box{52.0367431641, 52.0422363281, -107.556152344, -107.545166016}},
	{"k9g2nkbm3j5h", Box{-35.1292287558, -35.1292285882, 27.3453609645, 27.3453612998}},
	{"thdwugw196t", Box{26.5185204148, 26.5185217559, 48.7326653302, 48.7326666713}},
	{"34nm41n89c8v", Box{-32.8655058704, -32.8655057028, -126.114044376, -126.11404404}},
	{"buf7qgu", Box{72.3106384277, 72.3120117188, -142.783813477, -142.782440186}},
	{"mhvh0u7f4", Box{-17.55443573, -17.5543928146, 52.0694446564, 52.0694875717}},
	{"t", Box{0.0, 45.0, 45.0, 90.0}},
	{"f0vdwj1bu", Box{49.6857976913, 49.6858406067, -81.9993782043, -81.999335289}},
	{"kcke59", Box{-37.4359130859, -37.4304199219, 40.2319335938, 40.2429199219}},
	{"9rws4p0", Box{42.9290771484, 42.9304504395, -114.521484375, -114.520111084}},
	{"fhj1u03epu", Box{67.8095269203, 67.8095322847, -82.7905762196, -82.7905654907}},
	{"13296d9gwq1", Box{-82.734657526, -82.7346561849, -122.934338897, -122.934337556}},
	{"4j", Box{-61.875, -56.25, -90.0, -78.75}},
	{"gk5u1y2", Box{68.2374572754, 68.2388305664, -28.3996582031, -28.3982849121}},
	{"9v6yrwx00", Box{30.6655883789, 30.6656312943, -97.0436096191, -97.0435667038}},
	{"mc92", Box{-36.5625, -36.38671875, 80.5078125, 80.859375}},
	{"m", Box{-45.0, 0.0, 45.0, 90.0}},
	{"vtzr1we0jh5", Box{78.6099457741, 78.6099471152, 77.7655689418, 77.7655702829}},
	{"ytmmrjr08p", Box{75.4830640554, 75.4830694199, 120.200042725, 120.200053453}},
	{"y7q525c0mgkz", Box{63.8731999509, 63.8732001185, 109.689126424, 109.68912676}},
	{"s5nc", Box{17.05078125, 17.2265625, 9.4921875, 9.84375}},
	{"wk2", Box{23.90625, 25.3125, 101.25, 102.65625}},
	{"f4beky4z04y", Box{61.0742144287, 61.0742157698, -89.0843501687, -89.0843488276}},
	{"ywdu5yj95", Box{82.2987556458, 82.2987985611, 116.539664268, 116.539707184}},
	{"n3", Box{-84.375, -78.75, 101.25, 112.5}},
	{"0334vnb6", Box{-82.4479293823, -82.4477577209, -167.123680115, -167.123336792}},
	{"xg65", Box{18.80859375, 18.984375, 171.5625, 171.9140625}},
	{"0ebmse71br", Box{-67.9212623835, -67.921257019, -156.946552992, -156.946542263}},
	{"ycwd9fc", Box{53.8920593262, 53.8934326172, 132.968902588, 132.970275879}},
	{"0z2gsvd0tfzy", Box{-48.573201634, -48.5732014664, -144.983568527, -144.983568192}},
	{"e041", Box{0.17578125, 0.3515625, -42.1875, -41.8359375}},
	{"ntzdfpdcphj7", Box{-57.1314592101, -57.1314590424, 123.138849624, 123.138849959}},
	{"jx1bfyyhgds1", Box{-50.4552562349, -50.4552560672, 70.0901824236, 70.0901827589}},
	{"dhzuvhgspbew", Box{27.5804938003, 27.580493968, -78.8766921312, -78.8766917959}},
	{"4", Box{-90.0, -45.0, -90.0, -45.0}},
	{"teyjc173t", Box{22.1116161346, 22.11165905, 75.986123085, 75.9861660004}},
	{"bg57uz4rxw5", Box{62.5739514828, 62.5739528239, -141.467531472, -141.467530131}},
	{"52dtfpdc", Box{-86.1353874207, -86.1352157593, -30.1427078247, -30.142364502}},
	{"vx1j39e", Box{85.3060913086, 85.3074645996, 68.9762878418, 68.9776611328}},
	{"2", Box{-45.0, 0.0, -180.0, -135.0}},
	{"psmpz5", Box{-64.7149658203, -64.7094726562, 164.838867188, 164.849853516}},
	{"4xr95eeee", Box{-49.023141861, -49.0230989456, -56.7943811417, -56.7943382263}},
	{"5j", Box{-61.875, -56.25, -45.0, -33.75}},
	{"kpb", Box{-1.40625, 0.0, 0.0, 1.40625}},
	{"dsub48epk", Box{26.722741127, 26.7227840424, -60.7061576843, -60.706114769}},
	{"2urtnwtdw17", Box{-20.1787023246, -20.1787009835, -135.409665853, -135.409664512}},
	{"e6s30gwjxm", Box{14.2584782839, 14.2584836483, -27.7319276333, -27.7319169044}},
	{"qtx", Box{-14.0625, -12.65625, 122.34375, 123.75}},
	{"qj0qvndweq3k", Box{-15.651620999, -15.6516208313, 90.5748634413, 90.5748637766}},
	{"ffetyh28uyj", Box{60.0967490673, 60.0967504084, -51.0635559261, -51.063554585}},
	{"z56t8nwqq7", Box{64.2848414183, 64.2848467827, 138.52447629, 138.524487019}},
	{"7h", Box{-22.5, -16.875, -45.0, -33.75}},
	{"9tuuw1pkyh", Box{33.1410956383, 33.1411010027, -105.546426773, -105.546416044}},
	{"2m", Box{-16.875, -11.25, -168.75, -157.5}},
	{"h7qt", Box{-70.83984375, -70.6640625, 20.390625, 20.7421875}},
	{"t832ztb6psn", Box{1.57003641129, 1.57003775239, 69.5880755782, 69.5880769193}},
	{"wk", Box{22.5, 28.125, 101.25, 112.5}},
	{"ndjbb8w3n", Box{-78.6152458191, -78.6152029037, 120.616750717, 120.616793633}},
	{"14pf3eqg4zd5", Box{-78.3360836841, -78.3360835165, -124.026254117, -124.026253782}},
	{"9j", Box{28.125, 33.75, -135.0, -123.75}},
	{"fr6ng34", Box{86.9732666016, 86.9746398926, -75.7919311523, -75.7905578613}},
	{"p3ggurx2c", Box{-79.455742836, -79.4556999207, 151.720204353, 151.720247269}},
	{"1h1pg1myn06", Box{-66.1297975481, -66.129796207, -133.453757465, -133.453756124}},
	{"cqsue", Box{82.353515625, 82.3974609375, -116.938476562, -116.89453125}},
	{"w", Box{0.0, 45.0, 90.0, 135.0}},
	{"s8jkw", Box{0.791015625, 0.8349609375, 30.146484375, 30.1904296875}},
	{"67", Box{-28.125, -22.5, -78.75, -67.5}},
	{"ywe4mn", Box{81.9909667969, 81.9964599609, 116.938476562, 116.949462891}},
	{"0f5te71q9g", Box{-77.7655917406, -77.7655863762, -141.183511019, -141.18350029}},
	{"v9s6tw70swwv", Box{53.911406938, 53.9114071056, 73.7225837633, 73.7225840986}},
	{"0jbutv", Box{-56.8377685547, -56.8322753906, -178.692626953, -178.681640625}},
	{"bn271bp", Box{80.68359375, 80.684967041, -179.561920166, -179.560546875}},
	{"1vvyth", Box{-56.4916992188, -56.4862060547, -92.9443359375, -92.9333496094}},
	{"7ruk94vup", Box{-0.59944152832, -0.599398612976, -27.7212953568, -27.7212524414}},
	{"3hf", Box{-18.28125, -16.875, -132.1875, -130.78125}},
	{"741rwgds3m4k", Box{-32.4116574973, -32.4116573296, -42.9420667514, -42.9420664161}},
	{"2pye", Box{-0.87890625, -0.703125, -170.859375, -170.5078125}},
	{"2", Box{-45.0, 0.0, -180.0, -135.0}},
	{"e7", Box{16.875, 22.5, -33.75, -22.5}},
	{"f", Box{45.0, 90.0, -90.0, -45.0}},
	{"6", Box{-45.0, 0.0, -90.0, -45.0}},
	{"4c5p5ke", Box{-83.1198120117, -83.1184387207, -51.8843078613, -51.8829345703}},
	{"h7q", Box{-71.71875, -70.3125, 19.6875, 21.09375}},
	{"4fjp8", Box{-77.431640625, -77.3876953125, -49.21875, -49.1748046875}},
	{"p2cbvvvdt8", Box{-85.6173992157, -85.6173938513, 148.971412182, 148.971422911}},
	{"xxjtqz46qmm", Box{40.3367181122, 40.3367194533, 165.534370691, 165.534372032}},
	{"w1e", Box{8.4375, 9.84375, 94.21875, 95.625}},
	{"fxpg4v3e", Box{84.9316978455, 84.9318695068, -56.4786529541, -56.4783096313}},
	{"3be6u", Box{-41.7041015625, -41.66015625, -96.50390625, -96.4599609375}},
	{"9", Box{0.0, 45.0, -135.0, -90.0}},
	{"seqqvkuphz", Box{19.4951051474, 19.4951105118, 31.5254724026, 31.5254831314}},
	{"txy2t7xx", Box{43.7020683289, 43.7022399902, 76.5300750732, 76.530418396}},
	{"s2hc2d2s", Box{0.232772827148, 0.232944488525, 17.9523468018, 17.9526901245}},
	{"8zr0n4f62k", Box{40.7967638969, 40.7967692614, -136.139477491, -136.139466763}},
	{"th1vxpfxnp9", Box{23.5106107593, 23.5106121004, 47.7722467482, 47.7722480893}},
	{"n", Box{-90.0, -45.0, 90.0, 135.0}},
	{"33", Box{-39.375, -33.75, -123.75, -112.5}},
	{"gu", Box{67.5, 73.125, -11.25, 0.0}},
	{"9vq49", Box{29.970703125, 30.0146484375, -92.7685546875, -92.724609375}},
	{"tm", Box{28.125, 33.75, 56.25, 67.5}},
	{"dpzw0p", Box{44.6868896484, 44.6923828125, -79.453125, -79.4421386719}},
	{"gwg12", Box{83.1884765625, 83.232421875, -18.28125, -18.2373046875}},
	{"b8vphv0m5k", Box{50.4775643349, 50.4775696993, -150.259526968, -150.259516239}},
	{"pgpffhw1", Box{-72.6167106628, -72.6165390015, 179.744567871, 179.744911194}},
	{"3r3w", Box{-3.1640625, -2.98828125, -121.640625, -121.2890625}},
	{"u1d", Box{53.4375, 54.84375, 2.8125, 4.21875}},
	{"mznb8v5xu6", Box{-5.50830245018, -5.50829708576, 88.2801353931, 88.280146122}},
	{"8mb57vjrex4", Box{32.9438298941, 32.9438312352, -168.577842414, -168.577841073}},
	{"zm", Box{73.125, 78.75, 146.25, 157.5}},
	{"c9ef6tm74sg", Box{53.8623873889, 53.86238873, -107.109378129, -107.109376788}},
	{"spww", Box{43.2421875, 43.41796875, 9.140625, 9.4921875}},
	{"snp97n", Box{34.0026855469, 34.0081787109, 10.6787109375, 10.6896972656}},
	{"zp9r6emsk8xx", Box{88.4805002622, 88.4805004299, 136.875432059, 136.875432394}},
	{"v", Box{45.0, 90.0, 45.0, 90.0}},
	{"18zsh9bg", Box{-85.0679969788, -85.0678253174, -101.754341125, -101.753997803}},
	{"v28", Box{47.8125, 49.21875, 56.25, 57.65625}},
	{"4e", Box{-73.125, -67.5, -67.5, -56.25}},
	{"evn0wp56", Box{28.2516860962, 28.2518577576, -2.5443649292, -2.54402160645}},
	{"uyf9v", Box{83.2763671875, 83.3203125, 37.4853515625, 37.529296875}},
	{"d7", Box{16.875, 22.5, -78.75, -67.5}},
	{"05", Box{-73.125, -67.5, -180.0, -168.75}},
	{"ujj8", Box{73.125, 73.30078125, 7.734375, 8.0859375}},
	{"wcb7n8", Box{10.37109375, 10.3765869141, 124.387207031, 124.398193359}},
	{"r35s2y4e2", Box{-38.5944128036, -38.5943698883, 151.208267212, 151.208310127}},
	{"k", Box{-45.0, 0.0, 0.0, 45.0}},
	{"8tm3h7b1f", Box{29.7279310226, 29.727973938, -149.930334091, -149.930291176}},
	{"3xecw9gsguw3", Box{-2.53837538883, -2.53837522119, -106.935942136, -106.9359418}},
	{"hqs10v", Box{-53.2342529297, -53.2287597656, 16.9079589844, 16.9189453125}},
	{"b21g", Box{45.52734375, 45.703125, -166.2890625, -165.9375}},
	{"vphhpnjt5b", Box{85.1119422913, 85.1119476557, 50.9403312206, 50.9403419495}},
	{"kbd", Box{-42.1875, -40.78125, 36.5625, 37.96875}},
	{"2c", Box{-39.375, -33.75, -146.25, -135.0}},
	{"07ur", Box{-67.67578125, -67.5, -162.7734375, -162.421875}},
	{"8e5ky1", Box{17.7154541016, 17.7209472656, -152.666015625, -152.655029297}},
	{"k2w84t", Box{-42.1600341797, -42.1545410156, 20.5004882812, 20.5114746094}},
	{"p9t4ncex81m", Box{-81.2014035881, -81.201402247, 164.832694083, 164.832695425}},
	{"q67rduzsu6uz", Box{-30.9984667785, -30.9984666109, 105.951650552, 105.951650888}},
	{"udwkypp0v", Box{59.936041832, 59.9360847473, 31.5625619888, 31.5626049042}},
	{"pjsu1q9qg", Box{-58.3225107193, -58.322467804, 141.7364645, 141.736507416}},
	{"2kj2w9b021b", Box{-22.4024440348, -22.4024426937, -161.081542969, -161.081541628}},
	{"5k0", Box{-67.5, -66.09375, -33.75, -32.34375}},
	{"t626vs8j", Box{13.1652259827, 13.165397644, 56.8432617188, 56.8436050415}},
	{"hd0z4zr73", Box{-77.4791479111, -77.4791049957, 23.6855363846, 23.6855792999}},
	{"79gjppfekhhk", Box{-34.2341917008, -34.2341915332, -17.9700222239, -17.9700218886}},
	{"u9u", Box{54.84375, 56.25, 28.125, 29.53125}},
	{"5zbfmj3n30", Box{-45.9808301926, -45.9808248281, -9.97416973114, -9.9741590023}},
	{"1w1nt3g4t9pp", Box{-55.0973731466, -55.0973729789, -110.858671814, -110.858671479}},
	{"f6bh910940", Box{61.2654304504, 61.2654358149, -78.7052822113, -78.7052714825}},
	{"r65q38x", Box{-32.6486206055, -32.6472473145, 150.895843506, 150.897216797}},
	{"xq2", Box{35.15625, 36.5625, 146.25, 147.65625}},
	{"q87xbntvdv8d", Box{-42.1947657689, -42.1947656013, 117.429890111, 117.429890446}},
	{"w1zhgmbpw", Box{10.7115840912, 10.7116270065, 99.9868297577, 99.986872673}},
	{"5n", Box{-56.25, -50.625, -45.0, -33.75}},
	{"9dz", Box{15.46875, 16.875, -102.65625, -101.25}},
	{"n8r794hh15gv", Box{-87.9668216966, -87.966821529, 122.744798921, 122.744799256}},
	{"px78re9", Box{-49.1555786133, -49.1542053223, 162.752838135, 162.754211426}},
	{"3pps", Box{-4.921875, -4.74609375, -124.453125, -124.1015625}},
	{"3s6um", Box{-20.3466796875, -20.302734375, -108.413085938, -108.369140625}},
	{"9dj7zre6t7", Box{11.9508236647, 11.9508290291, -104.793895483, -104.793884754}},
	{"4v1b", Box{-61.875, -61.69921875, -53.7890625, -53.4375}},
	{"1k35z", Box{-65.4345703125, -65.390625, -122.036132812, -121.9921875}},
	{"7z9n57", Box{-1.74133300781, -1.73583984375, -9.70092773438, -9.68994140625}},
	{"3gzg", Box{-23.37890625, -23.203125, -90.3515625, -90.0}},
	{"hy", Box{-56.25, -50.625, 33.75, 45.0}},
	{"2rj6t", Box{-5.185546875, -5.1416015625, -161.147460938, -161.103515625}},
	{"h", Box{-90.0, -45.0, 0.0, 45.0}},
	{"dp44nc1t", Box{39.7329139709, 39.7330856323, -86.8888092041, -86.8884658813}},
	{"0x1", Box{-50.625, -49.21875, -156.09375, -154.6875}},
	{"dmwxxf", Box{32.2668457031, 32.2723388672, -69.2687988281, -69.2578125}},
	{"khy29", Box{-18.193359375, -18.1494140625, 8.8330078125, 8.876953125}},
	{"v", Box{45.0, 90.0, 45.0, 90.0}},
	{"phn4", Box{-67.1484375, -66.97265625, 143.4375, 143.7890625}},
	{"qzhvp", Box{-4.74609375, -4.7021484375, 130.737304688, 130.78125}},
	{"3n", Box{-11.25, -5.625, -135.0, -123.75}},
	{"0nx", Box{-53.4375, -52.03125, -170.15625, -168.75}},
	{"19uwx04h21", Box{-79.0129369497, -79.0129315853, -105.86151123, -105.861500502}},
	{"7ur1q", Box{-20.8740234375, -20.830078125, -1.142578125, -1.0986328125}},
	{"8yn6q9vmm", Box{34.1560220718, 34.1560649872, -137.167868614, -137.167825699}},
	{"m4zk", Box{-28.828125, -28.65234375, 55.1953125, 55.546875}},
	{"9bgzpypspd0", Box{5.48287510872, 5.48287644982, -95.6253647804, -95.6253634393}},
	{"y1s", Box{53.4375, 54.84375, 95.625, 97.03125}},
	{"qsyp207nvy", Box{-17.0042717457, -17.0042663813, 120.941866636, 120.941877365}},
	{"rfb", Box{-29.53125, -28.125, 168.75, 170.15625}},
	{"j", Box{-90.0, -45.0, 45.0, 90.0}},
	{"5exm5p63", Box{-69.3935966492, -69.3934249878, -12.1697616577, -12.169418335}},
	{"cnv22fdkruw", Box{83.0271819234, 83.0271832645, -127.58079797, -127.580796629}},
	{"n7vg", Box{-68.37890625, -68.203125, 109.3359375, 109.6875}},
	{"whvgd2h3sz9", Box{27.3342821002, 27.3342834413, 98.1908561289, 98.19085747}},
	{"shbfuzk8vr", Box{27.2421401739, 27.2421455383, 1.2698328495, 1.26984357834}},
	{"44vmk", Box{-73.6083984375, -73.564453125, -82.44140625, -82.3974609375}},
	{"uhd1mfq", Box{70.5445861816, 70.5459594727, 3.07342529297, 3.07479858398}},
	{"7bz", Box{-40.78125, -39.375, -1.40625, 0.0}},
	{"h5b2wkdqpz", Box{-68.7925726175, -68.7925672531, 0.629643201828, 0.629653930664}},
	{"h1", Box{-84.375, -78.75, 0.0, 11.25}},
	{"3", Box{-45.0, 0.0, -135.0, -90.0}},
	{"408bm1", Box{-87.1380615234, -87.1325683594, -88.7255859375, -88.7145996094}},
	{"ggysyy5e2be6", Box{66.9622308388, 66.9622310065, -1.80790107697, -1.8079007417}},
	{"w4u7dn8m9ndw", Box{16.1206699535, 16.1206701212, 96.0648427159, 96.0648430511}},
	{"yq", Box{78.75, 84.375, 101.25, 112.5}},
	{"2nwuht4w", Box{-7.70587921143, -7.70570755005, -170.306625366, -170.306282043}},
	{"v5gqe", Box{67.236328125, 67.2802734375, 49.7021484375, 49.74609375}},
	{"0", Box{-90.0, -45.0, -180.0, -135.0}},
	{"cmehghzjm1", Box{76.7994600534, 76.7994654179, -119.389586449, -119.38957572}},
	{"u207q361d", Box{45.5784130096, 45.578455925, 11.8790531158, 11.8790960312}},
	{"n4pgq345pp", Box{-78.1726652384, -78.172659874, 101.176142693, 101.176153421}},
	{"b2mn8", Box{47.548828125, 47.5927734375, -161.71875, -161.674804688}},
	{"qbe6mp0g8et3", Box{-41.7529202811, -41.7529201135, 128.541097529, 128.541097865}},
	{"sr04m", Box{39.7705078125, 39.814453125, 11.4697265625, 11.513671875}},
	{"hfr0y7u988jx", Box{-77.1910560317, -77.1910558641, 43.8746168464, 43.8746171817}},
	{"jrgxg5qkg7p", Box{-45.0252610445, -45.0252597034, 61.3124428689, 61.3124442101}},
	{"gryut", Box{89.384765625, 89.4287109375, -24.0380859375, -23.994140625}},
	{"14d5b766ppxg", Box{-75.2600834705, -75.2600833029, -132.173112966, -132.173112631}},
	{"0ede2rgwt2", Box{-69.6975231171, -69.6975177526, -153.968356848, -153.968346119}},
	{"3", Box{-45.0, 0.0, -135.0, -90.0}},
	{"dj", Box{28.125, 33.75, -90.0, -78.75}},
	{"xf", Box{11.25, 16.875, 168.75, 180.0}},
	{"szf3p5k9rmx", Box{43.7876281142, 43.7876294553, 37.228180021, 37.2281813622}},
	{"b9fqkhfem7", Box{55.9690493345, 55.9690546989, -154.156497717, -154.156486988}},
	{"t7zw8x5c", Box{22.2749519348, 22.2751235962, 66.8239974976, 66.8243408203}},
	{"f87dmh", Box{46.8237304688, 46.8292236328, -62.3583984375, -62.3474121094}},
	{"yrd1swq12", Box{87.4857187271, 87.4857616425, 104.268493652, 104.268536568}},
	{"s2", Box{0.0, 5.625, 11.25, 22.5}},
	{"q9dhkgwy4kum", Box{-35.7951473258, -35.7951471582, 115.530612208, 115.530612543}},
	{"7dr", Box{-32.34375, -30.9375, -12.65625, -11.25}},
	{"v", Box{45.0, 90.0, 45.0, 90.0}},
	{"2rpk2ey43dw", Box{-4.85693067312, -4.85692933202, -158.524402678, -158.524401337}},
	{"3wfeg", Box{-6.3720703125, -6.328125, -108.852539062, -108.80859375}},
	{"ke5k4j", Box{-27.3944091797, -27.3889160156, 27.158203125, 27.1691894531}},
	{"z0xq", Box{48.8671875, 49.04296875, 145.1953125, 145.546875}},
	{"w1sy", Box{9.4921875, 9.66796875, 96.6796875, 97.03125}},
	{"eqm14", Box{35.33203125, 35.3759765625, -26.630859375, -26.5869140625}},
	{"s", Box{0.0, 45.0, 0.0, 45.0}},
	{"hjp9d9f", Box{-61.6017150879, -61.6003417969, 10.6594848633, 10.6608581543}},
	{"p92v0", Box{-82.08984375, -82.0458984375, 158.5546875, 158.598632812}},
	{"36m7g02m", Box{-31.6823387146, -31.6821670532, -116.23500824, -116.234664917}},
	{"5g70e57zjrf", Box{-71.6117633879, -71.6117620468, -6.89403623343, -6.89403489232}},
	{"65rkyfq4se", Box{-25.8709841967, -25.8709788322, -79.4996237755, -79.4996130466}},
	{"eev1", Box{21.26953125, 21.4453125, -15.46875, -15.1171875}},
	{"6", Box{-45.0, 0.0, -90.0, -45.0}},
	{"m75926t", Box{-27.8915405273, -27.8901672363, 61.1897277832, 61.1911010742}},
	{"1kjyeb", Box{-66.357421875, -66.3519287109, -115.499267578, -115.48828125}},
	{"fb8rk2yfwmrp", Box{49.0914924257, 49.0914925933, -55.7021225989, -55.7021222636}},
	{"y2qhd0j8x", Box{47.1973514557, 47.197394371, 109.783244133, 109.783287048}},
	{"m2", Box{-45.0, -39.375, 56.25, 67.5}},
	{"0543np5pgd23", Box{-72.9094239883, -72.9094238207, -176.567995213, -176.567994878}},
	{"3", Box{-45.0, 0.0, -135.0, -90.0}},
	{"d4h5zdhe5gy", Box{11.9207011163, 11.9207024574, -84.0390613675, -84.0390600264}},
	{"9rcd", Box{43.9453125, 44.12109375, -121.640625, -121.2890625}},
	{"ne9nrh75tq3", Box{-69.1898868978, -69.1898855567, 114.218213707, 114.218215048}},
	{"7wk7", Box{-9.31640625, -9.140625, -16.5234375, -16.171875}},
	{"995f97e", Box{6.08367919922, 6.08505249023, -107.167510986, -107.166137695}},
	{"60kmung", Box{-42.5459289551, -42.5445556641, -83.843536377, -83.8421630859}},
	{"845", Box{11.25, 12.65625, -175.78125, -174.375}},
	{"n", Box{-90.0, -45.0, 90.0, 135.0}},
	{"jehdxn0", Box{-72.6525878906, -72.6512145996, 74.1357421875, 74.1371154785}},
	{"y", Box{45.0, 90.0, 90.0, 135.0}},
	{"1d", Box{-78.75, -73.125, -112.5, -101.25}},
	{"rbjy", Box{-43.9453125, -43.76953125, 176.8359375, 177.1875}},
	{"r8qgzf4r9uy", Box{-42.9222710431, -42.922269702, 167.335936725, 167.335938066}},
	{"k5p", Box{-28.125, -26.71875, 9.84375, 11.25}},
	{"f4z7", Box{60.99609375, 61.171875, -79.8046875, -79.453125}},
	{"7rp35b", Box{-5.44921875, -5.44372558594, -23.3898925781, -23.37890625}},
	{"zn71yyn0pbc", Box{80.4968301952, 80.4968315363, 139.52395454, 139.523955882}},
	{"ppj7", Box{-50.09765625, -49.921875, 142.3828125, 142.734375}},
	{"mqv3q", Box{-6.8115234375, -6.767578125, 63.896484375, 63.9404296875}},
	{"tsdtmfq", Box{26.2477111816, 26.2490844727, 71.276550293, 71.277923584}},
	{"72ey8b14uynx", Box{-41.0444164462, -41.0444162786, -28.4420176595, -28.4420173243}},
	{"7qrgb", Box{-9.1845703125, -9.140625, -22.8515625, -22.8076171875}},
	{"w7zmkdpezcm", Box{22.0282383263, 22.0282396674, 111.653705388, 111.653706729}},
	{"kqwr1dh9jdbc", Box{-7.19585834071, -7.19585817307, 20.1113973185, 20.1113976538}},
	{"kv9jx", Box{-13.095703125, -13.0517578125, 35.4638671875, 35.5078125}},
	{"09", Box{-84.375, -78.75, -157.5, -146.25}},
	{"f8ztmmp0", Box{50.1690673828, 50.1692390442, -56.7127990723, -56.7124557495}},
	{"k5dj8cuwbxjg", Box{-24.3348933198, -24.3348931521, 2.85166796297, 2.85166829824}},
	{"xd72j5qndwhn", Box{12.6752517745, 12.6752519421, 162.298391461, 162.298391797}},
	{"esp42d", Box{22.9064941406, 22.9119873047, -12.6342773438, -12.6232910156}},
	{"5sbfys", Box{-62.7758789062, -62.7703857422, -21.1596679688, -21.1486816406}},
	{"8wsz02n", Box{37.79296875, 37.794342041, -150.801086426, -150.799713135}},
	{"zeghw8", Box{66.884765625, 66.8902587891, 162.004394531, 162.015380859}},
	{"u0xg7ug", Box{48.4098815918, 48.4112548828, 11.0673522949, 11.0687255859}},
	{"0jb11", Box{-57.48046875, -57.4365234375, -179.956054688, -179.912109375}},
	{"xv8cwtybm", Box{31.2328004837, 31.232843399, 170.099816322, 170.099859238}},
	{"ef0cwqt7", Box{11.5498924255, 11.5500640869, -9.91344451904, -9.91310119629}},
	{"hrh5k", Box{-50.0537109375, -50.009765625, 17.05078125, 17.0947265625}},
	{"pnpdsx4eb", Box{-55.7714509964, -55.7714080811, 145.748062134, 145.748105049}},
	{"8g2sx4gn", Box{19.0884017944, 19.0885734558, -145.235137939, -145.234794617}},
	{"tsue3yr4z", Box{27.3248434067, 27.324886322, 73.9149427414, 73.9149856567}},
	{"k4vq", Box{-28.4765625, -28.30078125, 7.3828125, 7.734375}},
	{"mr1f1d430h", Box{-5.26225805283, -5.26225268841, 58.7799453735, 58.7799561024}},
	{"dtuqkjybm", Box{33.4740114212, 33.4740543365, -61.3381719589, -61.3381290436}},
	{"p00zpfbj5350", Box{-88.7535613775, -88.7535612099, 136.39540717, 136.395407505}},
	{"n16jy8wrg38", Box{-81.9539228082, -81.9539214671, 93.106867075, 93.1068684161}},
	{"3ckf9t6", Box{-37.5004577637, -37.4990844727, -94.5016479492, -94.5002746582}},
	{"vvch78h7q7", Box{78.0913943052, 78.0913996696, 80.3161633015, 80.3161740303}},
	{"x", Box{0.0, 45.0, 135.0, 180.0}},
	{"qkr8dj44", Box{-20.9780502319, -20.9778785706, 111.887512207, 111.88785553}},
	{"s5dw7s", Box{20.8081054688, 20.8135986328, 3.66943359375, 3.68041992188}},
	{"tpt", Box{42.1875, 43.59375, 52.03125, 53.4375}},
	{"6vqn07ep", Box{-14.3936347961, -14.3934631348, -47.7973937988, -47.7970504761}},
	{"7zbup2", Box{-0.703125, -0.697631835938, -9.87670898438, -9.86572265625}},
	{"xd0j0wrn39f8", Box{12.1643207967, 12.1643209644, 157.531653419, 157.531653754}},
	{"254kywz4", Box{-27.2526168823, -27.2524452209, -176.540679932, -176.540336609}},
	{"6pkmr1875rp", Box{-3.28710615635, -3.28710481524, -83.7153281271, -83.715326786}},
	{"69bmhmbw0de", Box{-34.2447146773, -34.2447133362, -66.9609577954, -66.9609564543}},
	{"47jd", Box{-72.7734375, -72.59765625, -71.015625, -70.6640625}},
	{"mw3ngtnj", Box{-8.6289024353, -8.62873077393, 69.0682983398, 69.0686416626}},
	{"v", Box{45.0, 90.0, 45.0, 90.0}},
	{"4uyq1", Box{-62.2265625, -62.1826171875, -47.4169921875, -47.373046875}},
	{"9748v3e", Box{17.0150756836, 17.0164489746, -119.999542236, -119.998168945}},
	{"sjy7", Box{32.87109375, 33.046875, 8.7890625, 9.140625}},
	{"nc1jb2kb", Box{-83.3628845215, -83.3627128601, 125.17375946, 125.174102783}},
	{"ffryw", Box{58.798828125, 58.8427734375, -45.087890625, -45.0439453125}},
	{"3qfr7scg5s", Box{-5.7302069664, -5.73020160198, -120.429575443, -120.429564714}},
	{"1x", Box{-50.625, -45.0, -112.5, -101.25}},
	{"y", Box{45.0, 90.0, 90.0, 135.0}},
	{"0", Box{-90.0, -45.0, -180.0, -135.0}},
	{"n4wk", Box{-75.234375, -75.05859375, 98.7890625, 99.140625}},
	{"bw2d2", Box{80.5517578125, 80.595703125, -156.796875, -156.752929688}},
	{"ztgehr9mpt", Box{77.9131776094, 77.9131829739, 162.610681057, 162.610691786}},
	{"bnkb", Box{80.15625, 80.33203125, -173.3203125, -172.96875}},
	{"q0fmcn", Box{-39.7375488281, -39.7320556641, 93.2080078125, 93.2189941406}},
	{"e0e1sxt9gwm", Box{3.11770454049, 3.1177058816, -40.5757860839, -40.5757847428}},
	{"9qc", Box{37.96875, 39.375, -122.34375, -120.9375}},
	{"0cybm9snr", Box{-80.1029920578, -80.1029491425, -136.51031971, -136.510276794}},
	{"fp", Box{84.375, 90.0, -90.0, -78.75}},
	{"7u69k7", Box{-20.8575439453, -20.8520507812, -7.54760742188, -7.53662109375}},
	{"guh3mbvnwv7y", Box{67.7249914035, 67.7249915712, -5.01359079033, -5.01359045506}},
	{"vgw4wgnrd58e", Box{65.1447393559, 65.1447395235, 87.4928004295, 87.4928007647}},
	{"rzk732w", Box{-3.64471435547, -3.64334106445, 174.789733887, 174.791107178}},
	{"kf", Box{-33.75, -28.125, 33.75, 45.0}},
	{"rcfr28t0", Box{-33.8790893555, -33.8789176941, 171.942901611, 171.943244934}},
	{"5bqnms", Box{-87.4731445312, -87.4676513672, -2.57080078125, -2.55981445312}},
	{"fs84w", Box{70.751953125, 70.7958984375, -67.236328125, -67.1923828125}},
	{"mcjrsmx", Box{-38.0264282227, -38.0250549316, 86.3291931152, 86.3305664062}},
	{"u84", Box{45.0, 46.40625, 25.3125, 26.71875}},
	{"gkv4g14m", Box{72.2084999084, 72.2086715698, -26.5838241577, -26.583480835}},
	{"27dhxu", Box{-24.4995117188, -24.4940185547, -165.596923828, -165.5859375}},
	{"0v", Box{-61.875, -56.25, -146.25, -135.0}},
	{"bpurn", Box{89.82421875, 89.8681640625, -173.759765625, -173.715820312}},
	{"p5", Box{-73.125, -67.5, 135.0, 146.25}},
	{"f3ffsuh", Box{55.3051757812, 55.3065490723, -74.6685791016, -74.6672058105}},
	{"j0zbr0tb", Box{-85.7345581055, -85.7343864441, 56.2139511108, 56.2142944336}},
	{"vyz", Box{82.96875, 84.375, 88.59375, 90.0}},
	{"082p96b5ey", Box{-87.2596514225, -87.2596460581, -157.444907427, -157.444896698}},
	{"y", Box{45.0, 90.0, 90.0, 135.0}},
	{"g030qs", Box{46.4721679688, 46.4776611328, -43.3081054688, -43.2971191406}},
	{"54", Box{-78.75, -73.125, -45.0, -33.75}},
	{"fp5rcptn2gc", Box{85.7795964181, 85.7795977592, -85.3788422048, -85.3788408637}},
	{"dk8z85s6516h", Box{26.650436148, 26.6504363157, -77.6893445849, -77.6893442497}},
	{"3v1ebh18qujh", Box{-16.1937826127, -16.193782445, -99.1382686794, -99.1382683441}},
	{"un50j3xf9", Box{78.7586688995, 78.7587118149, 4.46014881134, 4.46019172668}},
	{"4b8y3gh", Box{-86.0723876953, -86.0710144043, -55.1129150391, -55.111541748}},
	{"efdgh", Box{14.58984375, 14.6337890625, -7.20703125, -7.1630859375}},
	{"1xxuk2", Box{-47.0654296875, -47.0599365234, -101.414794922, -101.403808594}},
	{"s", Box{0.0, 45.0, 0.0, 45.0}},
	{"1z6", Box{-49.21875, -47.8125, -98.4375, -97.03125}},
	{"s", Box{0.0, 45.0, 0.0, 45.0}},
	{"mxkjr1jdu5ru", Box{-3.28991509974, -3.2899149321, 73.440352343, 73.4403526783}},
	{"x", Box{0.0, 45.0, 135.0, 180.0}},
	{"3kpcn3sm", Box{-22.315120697, -22.3149490356, -112.57106781, -112.570724487}},
	{"buk3t0ctrmt0", Box{69.1749724746, 69.1749726422, -140.051333159, -140.051332824}},
	{"pp", Box{-50.625, -45.0, 135.0, 146.25}},
	{"4h", Box{-67.5, -61.875, -90.0, -78.75}},
	{"fjw1kcg4", Box{76.1671829224, 76.1673545837, -81.3496398926, -81.3492965698}},
	{"877wsvjfz5", Box{19.4517821074, 19.4517874718, -163.611187935, -163.611177206}},
	{"ru3", Box{-21.09375, -19.6875, 170.15625, 171.5625}},
	{"yr", Box{84.375, 90.0, 101.25, 112.5}},
	{"cu5x6cxq", Box{68.7836837769, 68.7838554382, -96.1973190308, -96.196975708}},
	{"w04vuf4bdzjm", Box{1.02185273543, 1.02185290307, 94.0798293427, 94.0798296779}},
	{"8", Box{0.0, 45.0, -180.0, -135.0}},
	{"4zdcmmp2p4", Box{-47.5652968884, -47.5652915239, -52.1418428421, -52.1418321133}},
	{"eft02s1hu", Box{14.1292333603, 14.1292762756, -4.19523239136, -4.19518947601}},
	{"zk4v9qdeg5q1", Box{68.5031637736, 68.5031639412, 150.175689161, 150.175689496}},
	{"8xr", Box{40.78125, 42.1875, -147.65625, -146.25}},
	{"3pxyrt", Box{-1.68640136719, -1.68090820312, -123.771972656, -123.760986328}},
	{"cmh39xszs8", Box{73.4311580658, 73.4311634302, -117.70080328, -117.700792551}},
	{"xrm9d0wb48", Box{41.047668457, 41.0476738214, 154.081642628, 154.081653357}},
	{"d4bh0k", Box{16.1938476562, 16.1993408203, -89.9890136719, -89.9780273438}},
	{"hk8", Box{-64.6875, -63.28125, 11.25, 12.65625}},
	{"9hxqk54m0wn", Box{26.4285027981, 26.4285041392, -124.625786841, -124.6257855}},
	{"mygnv0", Box{-5.8447265625, -5.83923339844, 83.1884765625, 83.1994628906}},
	{"yrjmvs", Box{85.4077148438, 85.4132080078, 108.874511719, 108.885498047}},
	{"52csyemvf12", Box{-84.9274425209, -84.9274411798, -31.3469982147, -31.3469968736}},
	{"4jrvjj", Box{-59.5623779297, -59.5568847656, -78.8818359375, -78.8708496094}},
	{"ys1", Box{67.5, 68.90625, 113.90625, 115.3125}},
	{"unf91", Box{83.14453125, 83.1884765625, 3.5595703125, 3.603515625}},
	{"h5che0vnt", Box{-68.109998703, -68.1099557877, 1.5451669693, 1.54520988464}},
	{"ugrk3", Box{64.0283203125, 64.072265625, 43.9892578125, 44.033203125}},
	{"9ush8c", Box{26.1090087891, 26.1145019531, -95.5920410156, -95.5810546875}},
	{"q92pzb", Box{-36.6064453125, -36.6009521484, 112.840576172, 112.8515625}},
	{"0e", Box{-73.125, -67.5, -157.5, -146.25}},
	{"dbt1mchu", Box{3.03840637207, 3.03857803345, -48.9595413208, -48.959197998}},
	{"98xv2m", Box{3.76281738281, 3.76831054688, -101.590576172, -101.579589844}},
	{"rqd8u195kgu", Box{-8.29684630036, -8.29684495926, 149.942988753, 149.942990094}},
	{"504wk58ccv", Box{-88.8818138838, -88.8818085194, -41.3074886799, -41.307477951}},
	{"0dzjhbn", Box{-73.65234375, -73.650970459, -147.43927002, -147.437896729}},
	{"sgcn", Box{22.1484375, 22.32421875, 35.15625, 35.5078125}},
	{"46k78jw0x65w", Box{-76.6982056573, -76.6982054897, -72.7648819238, -72.7648815885}},
	{"6w2cbxx3nf9", Box{-9.49474900961, -9.4947476685, -66.4130924642, -66.4130911231}},
	{"zxmf4", Box{86.1328125, 86.1767578125, 165.673828125, 165.717773438}},
	{"unf", Box{82.96875, 84.375, 2.8125, 4.21875}},
	{"m4p", Box{-33.75, -32.34375, 54.84375, 56.25}},
	{"dsc1rqss2w", Box{26.9749438763, 26.9749492407, -65.7689452171, -65.7689344883}},
	{"cxp", Box{84.375, 85.78125, -102.65625, -101.25}},
	{"zmh", Box{73.125, 74.53125, 151.875, 153.28125}},
	{"tynvnjc8hdb", Box{34.6605066955, 34.6605080366, 88.5081124306, 88.5081137717}},
	{"uk8hb", Box{71.1474609375, 71.19140625, 11.25, 11.2939453125}},
	{"34d", Box{-30.9375, -29.53125, -132.1875, -130.78125}},
	{"ts39vet4rzw5", Box{24.2335202359, 24.2335204035, 69.8582813144, 69.8582816496}},
	{"3rt1fx5", Box{-2.46643066406, -2.46505737305, -116.604766846, -116.603393555}},
	{"ujn8yhfpg", Box{73.2842588425, 73.2843017578, 9.40717220306, 9.40721511841}},
	{"pdbvhzj", Box{-73.6138916016, -73.6125183105, 158.770294189, 158.77166748}},
	{"q35", Box{-39.375, -37.96875, 105.46875, 106.875}},
	{"szh5424hc", Box{39.9031591415, 39.9032020569, 39.4766664505, 39.4767093658}},
	{"m", Box{-45.0, 0.0, 45.0, 90.0}},
	{"tt1wjkr44e", Box{29.2033928633, 29.2033982277, 69.8498082161, 69.8498189449}},
	{"1u3hdkn", Box{-65.2807617188, -65.2793884277, -99.7366333008, -99.7352600098}},
	{"jc9", Box{-81.5625, -80.15625, 80.15625, 81.5625}},
	{"627pp", Box{-42.36328125, -42.3193359375, -74.2236328125, -74.1796875}},
	{"g46wqb4z", Box{58.7560844421, 58.7562561035, -41.1839675903, -41.1836242676}},
	{"2407674", Box{-33.1622314453, -33.1608581543, -179.546813965, -179.545440674}},
	{"3vbsrcxu", Box{-11.9002532959, -11.9000816345, -100.195655823, -100.1953125}},
	{"u0mr9fpy", Box{47.7366256714, 47.7367973328, 7.47035980225, 7.470703125}},
	{"p1s1", Box{-81.38671875, -81.2109375, 140.625, 140.9765625}},
	{"ce7y6s1ugjpu", Box{64.4026983529, 64.4026985206, -107.11415682, -107.114156485}},
	{"tujn", Box{23.5546875, 23.73046875, 85.78125, 86.1328125}},
	{"fes", Box{64.6875, 66.09375, -61.875, -60.46875}},
	{"28te871t29y", Box{-41.5548755229, -41.5548741817, -149.752549231, -149.75254789}},
	{"2z9j0591", Box{-1.9141960144, -1.91402435303, -144.842376709, -144.842033386}},
	{"e", Box{0.0, 45.0, -45.0, 0.0}},
	{"90", Box{0.0, 5.625, -135.0, -123.75}},
	{"jbfm12r", Box{-84.900970459, -84.899597168, 81.9786071777, 81.9799804688}},
	{"y0ws", Box{48.515625, 48.69140625, 99.140625, 99.4921875}},
	{"m2", Box{-45.0, -39.375, 56.25, 67.5}},
	{"gpspv95sz", Box{88.5561132431, 88.5561561584, -39.1281938553, -39.1281509399}},
	{"7k8u95cyjdx6", Box{-18.8748412952, -18.8748411275, -32.6487181708, -32.6487178355}},
	{"c1fe0r", Box{55.4095458984, 55.4150390625, -131.473388672, -131.462402344}},
	{"668wjecj2d", Box{-29.8613011837, -29.8612958193, -77.8037810326, -77.8037703037}},
	{"dnq3", Box{35.33203125, 35.5078125, -81.2109375, -80.859375}},
	{"m3sxdxnvmrr", Box{-35.2047483623, -35.2047470212, 62.6974926889, 62.69749403}},
	{"zz3qpfvqzu", Box{86.8522238731, 86.8522292376, 170.855931044, 170.855941772}},
	{"98mjjx8bu", Box{2.3264837265, 2.32652664185, -105.225849152, -105.225806236}},
	{"pkmusy0e4j35", Box{-65.2692317404, -65.2692315727, 154.545451552, 154.545451887}},
	{"j3f9dtm5r5n", Box{-79.8631650209, -79.8631636798, 59.8826631904, 59.8826645315}},
	{"67up3c0uh9jn", Box{-22.6256497577, -22.62564959, -73.0468659103, -73.046865575}},
	{"6q0fd9wn2", Box{-10.8012342453, -10.80119133, -77.5772094727, -77.5771665573}},
	{"t82e5zrs", Box{1.97410583496, 1.97427749634, 68.3782196045, 68.3785629272}},
	{"0hstxh", Box{-63.6987304688, -63.6932373047, -173.364257812, -173.353271484}},
	{"qe1egcuetqe", Box{-27.4555715919, -27.4555702507, 114.78057906, 114.780580401}},
	{"yhp25wc4v", Box{67.5375509262, 67.5375938416, 100.350708961, 100.350751877}},
	{"z6uvby2nrt4k", Box{61.5149248391, 61.5149250068, 152.962971367, 152.962971702}},
	{"29sd0863cx", Box{-36.2092262506, -36.2092208862, -151.146748066, -151.146737337}},
	{"kvnx614", Box{-15.5950927734, -15.5937194824, 42.981262207, 42.982635498}},
	{"mu1srk07", Box{-21.7304420471, -21.7302703857, 81.1783218384, 81.1786651611}},
	{"5bz5bmq", Box{-85.0932312012, -85.0918579102, -1.38702392578, -1.38565063477}},
	{"fu4yx9fr8gtk", Box{68.6534980685, 68.6534982361, -52.0500935242, -52.0500931889}},
	{"3hyhj92rn", Box{-17.5700569153, -17.5700139999, -126.320199966, -126.320157051}},
	{"345nw", Box{-32.607421875, -32.5634765625, -130.517578125, -130.473632812}},
	{"q5f2p327mhy", Box{-23.8988001645, -23.8987988234, 93.4832319617, 93.4832333028}},
	{"0wmufb9", Box{-54.0060424805, -54.0046691895, -149.2918396, -149.290466309}},
	{"r", Box{-45.0, 0.0, 135.0, 180.0}},
	{"07d2sde", Box{-70.2108764648, -70.2095031738, -165.384063721, -165.38269043}},
	{"d0r2", Box{1.40625, 1.58203125, -79.8046875, -79.453125}},
	{"znegsexfs23h", Box{82.1973916143, 82.197391782, 140.482018143, 140.482018478}},
	{"sfr69qxg", Box{13.1319236755, 13.1320953369, 44.010887146, 44.0112304688}},
	{"tr44b8brc", Box{39.8638486862, 39.8638916016, 59.0848588943, 59.0849018097}},
	{"tbnqctecsf", Box{1.21700406075, 1.21700942516, 87.6103341579, 87.6103448868}},
	{"jpfy538qu", Box{-45.3421640396, -45.3421211243, 49.0105247498, 49.0105676651}},
	{"u", Box{45.0, 90.0, 0.0, 45.0}},
	{"gskrg0z5e", Box{70.2732753754, 70.2733182907, -16.3818597794, -16.381816864}},
	{"6cz", Box{-35.15625, -33.75, -46.40625, -45.0}},
	{"u67hm7b47423", Box{58.4243181534, 58.424318321, 15.6995919719, 15.6995923072}},
	{"j154zhnnkyt3", Box{-83.8685209863, -83.8685208187, 49.5348178223, 49.5348181576}},
	{"muqdpev4smv", Box{-20.7211281359, -20.7211267948, 88.2272703946, 88.2272717357}},
	{"47h3upynmsru", Box{-72.7737144381, -72.7737142704, -72.589170076, -72.5891697407}},
	{"g6j200", Box{56.25, 56.2554931641, -26.3671875, -26.3562011719}},
	{"tw", Box{33.75, 39.375, 67.5, 78.75}},
	{"c0pjhr520q", Box{45.9173905849, 45.9173959494, -124.965008497, -124.964997768}},
	{"8nx", Box{36.5625, 37.96875, -170.15625, -168.75}},
	{"47b2wvtns", Box{-68.7870311737, -68.7869882584, -78.0947685242, -78.0947256088}},
	{"vrsbq", Box{87.2314453125, 87.275390625, 63.193359375, 63.2373046875}},
	{"sz", Box{39.375, 45.0, 33.75, 45.0}},
	{"xe61b0bnw", Box{18.5941028595, 18.5941457748, 160.312757492, 160.312800407}},
	{"dky6qedz3w", Box{27.1347606182, 27.1347659826, -69.6714520454, -69.6714413166}},
	{"vmvkqx2hb", Box{78.1314611435, 78.1315040588, 63.9184570312, 63.9184999466}},
	{"t96m49xgr1y", Box{7.9189632833, 7.9189646244, 70.7848772407, 70.7848785818}},
	{"brw2urrqcfex", Box{87.3603346758, 87.3603348434, -159.764133766, -159.764133431}},
	{"z7m8", Box{63.28125, 63.45703125, 153.984375, 154.3359375}},
	{"wm6w7f38", Box{30.6422424316, 30.642414093, 104.932479858, 104.932823181}},
	{"rxj23rtt4y", Box{-5.53896546364, -5.53896009922, 164.945415258, 164.945425987}},
	{"sfr9xsyzfn", Box{12.9473769665, 12.9473823309, 44.6358203888, 44.6358311176}},
	{"9ubf9uq02e", Box{27.1816080809, 27.1816134453, -100.110146999, -100.110136271}},
	{"kj25zp1gb6j", Box{-14.7704637051, -14.770462364, 0.310037881136, 0.31003922224}},
	{"x4f", Box{15.46875, 16.875, 137.8125, 139.21875}},
	{"xnn27kkf4c", Box{33.8176399469, 33.8176453114, 143.938525915, 143.938536644}},
	{"61bhs9byn4", Box{-34.3545806408, -34.3545752764, -89.8009586334, -89.8009479046}},
	{"rv2sve92mngr", Box{-14.6144826896, -14.614482522, 169.696759768, 169.696760103}},
	{"zkvq2w", Box{72.8503417969, 72.8558349609, 153.654785156, 153.665771484}},
	{"qprmp68h7kcd", Box{-3.32535546273, -3.32535529509, 100.514057502, 100.514057837}},
	{"77pmzubu", Box{-27.0874786377, -27.0873069763, -23.2130813599, -23.2127380371}},
	{"q73t2sumh3b", Box{-25.7689382136, -25.7689368725, 103.387366533, 103.387367874}},
	{"3kxch9c", Box{-19.5021057129, -19.5007324219, -112.652435303, -112.651062012}},
	{"t", Box{0.0, 45.0, 45.0, 90.0}},
	{"3um1y618chw", Box{-20.7749935985, -20.7749922574, -93.9419808984, -93.9419795573}},
	{"45nj7sxww", Box{-72.1763134003, -72.1762704849, -81.3981342316, -81.3980913162}},
	{"rnkyjdv404", Box{-8.77360224724, -8.77359688282, 141.928253174, 141.928263903}},
	{"p3", Box{-84.375, -78.75, 146.25, 157.5}},
	{"sxbz", Box{44.82421875, 45.0, 23.5546875, 23.90625}},
	{"xuj2k", Box{22.5439453125, 22.587890625, 176.30859375, 176.352539062}},
	{"yhp9", Box{67.67578125, 67.8515625, 100.546875, 100.8984375}},
	{"1yq4", Box{-54.4921875, -54.31640625, -92.8125, -92.4609375}},
	{"u4m2jkw", Box{57.6809692383, 57.6823425293, 7.62176513672, 7.62313842773}},
	{"xb9", Box{2.8125, 4.21875, 170.15625, 171.5625}},
	{"ebf4e478jp", Box{4.67060029507, 4.67060565948, -8.30064296722, -8.30063223839}},
	{"y7venx9", Box{66.6622924805, 66.6636657715, 109.271392822, 109.272766113}},
	{"8qu", Box{37.96875, 39.375, -163.125, -161.71875}},
	{"jw2jbzms66", Box{-53.7924420834, -53.7924367189, 67.5406086445, 67.5406193733}},
	{"n", Box{-90.0, -45.0, 90.0, 135.0}},
	{"jbx", Box{-87.1875, -85.78125, 88.59375, 90.0}},
	{"3v4n", Box{-15.8203125, -15.64453125, -98.4375, -98.0859375}},
	{"0z1theg", Box{-49.7254943848, -49.7241210938, -143.938751221, -143.93737793}},
	{"zbz00jf21m", Box{49.2503625154, 49.2503678799, 178.596893549, 178.596904278}},
	{"dfpq2eg2", Box{12.3692321777, 12.3694038391, -46.0282516479, -46.0279083252}},
	{"z2j5bc1ph562", Box{45.6658919156, 45.6658920832, 153.315756954, 153.31575729}},
	{"3p3g", Box{-3.69140625, -3.515625, -132.5390625, -132.1875}},
	{"4rfgeu3", Box{-45.7676696777, -45.7662963867, -74.7166442871, -74.7152709961}},
	{"nykq", Box{-53.7890625, -53.61328125, 129.7265625, 130.078125}},
	{"h", Box{-90.0, -45.0, 0.0, 45.0}},
	{"85", Box{16.875, 22.5, -180.0, -168.75}},
	{"bdsdxr", Box{59.5404052734, 59.5458984375, -150.853271484, -150.842285156}},
	{"wsyt3duqg2", Box{27.657866478, 27.6578718424, 121.71251893, 121.712529659}},
	{"90", Box{0.0, 5.625, -135.0, -123.75}},
	{"butw", Box{71.3671875, 71.54296875, -138.515625, -138.1640625}},
	{"ddhpjv6b7tqh", Box{12.5093796104, 12.5093797781, -61.6183796525, -61.6183793172}},
	{"18ueqgd", Box{-85.1907348633, -85.1893615723, -105.872497559, -105.871124268}},
	{"v2g8jh1", Box{49.2407226562, 49.2420959473, 61.3929748535, 61.3943481445}},
	{"84umeh3gmupk", Box{16.45947285, 16.4594730176, -173.888941817, -173.888941482}},
	{"s4g900", Box{15.64453125, 15.6500244141, 4.921875, 4.93286132812}},
	{"0b313fz2", Box{-88.3589172363, -88.358745575, -144.756889343, -144.756546021}},
	{"4q", Box{-56.25, -50.625, -78.75, -67.5}},
	{"d61", Box{11.25, 12.65625, -77.34375, -75.9375}},
	{"w5q5298pq", Box{18.8620233536, 18.8620662689, 98.4597301483, 98.4597730637}},
	{"ushgx399", Box{68.1236457825, 68.1238174438, 29.5003509521, 29.5006942749}},
	{"73ngt", Box{-38.759765625, -38.7158203125, -24.0380859375, -23.994140625}},
	{"2f4smcem", Box{-32.9938316345, -32.9936599731, -142.477226257, -142.476882935}},
	{"0", Box{-90.0, -45.0, -180.0, -135.0}},
	{"8", Box{0.0, 45.0, -180.0, -135.0}},
	{"5u14weqgz", Box{-67.0420503616, -67.0420074463, -9.54853534698, -9.54849243164}},
	{"xxhuu8y4xb", Box{40.214509964, 40.2145153284, 164.386013746, 164.386024475}},
	{"272xeqmj", Box{-25.3652000427, -25.3650283813, -167.897186279, -167.896842957}},
	{"2trrhunrd1", Box{-14.215015769, -14.2150104046, -147.087278366, -147.087267637}},
	{"e4", Box{11.25, 16.875, -45.0, -33.75}},
	{"p5duz8tp", Box{-69.4735908508, -69.4734191895, 139.203643799, 139.203987122}},
	{"5qprz78e", Box{-54.8679542542, -54.8677825928, -23.2353973389, -23.2350540161}},
	{"ch5yq40qtu3", Box{68.6107577384, 68.6107590795, -129.462299198, -129.462297857}},
	{"u", Box{45.0, 90.0, 0.0, 45.0}},
	{"7qmv9c5", Box{-8.87145996094, -8.87008666992, -25.5830383301, -25.5816650391}},
	{"c", Box{45.0, 90.0, -135.0, -90.0}},
	{"hp8s7", Box{-47.0654296875, -47.021484375, 0.8349609375, 0.87890625}},
	{"9e4y04d17", Box{17.9436349869, 17.9436779022, -108.629937172, -108.629894257}},
	{"39nh", Box{-38.671875, -38.49609375, -104.0625, -103.7109375}},
	{"6", Box{-45.0, 0.0, -90.0, -45.0}},
	{"pjpxe1pvyzhm", Box{-60.5501220189, -60.5501218513, 145.689649321, 145.689649656}},
	{"drx", Box{42.1875, 43.59375, -68.90625, -67.5}},
	{"zu1c5qg0s", Box{67.7129459381, 67.7129888535, 171.3580513, 171.358094215}},
	{"y", Box{45.0, 90.0, 90.0, 135.0}},
	{"t8d", Box{2.8125, 4.21875, 70.3125, 71.71875}},
	{"d47w70rwe23h", Box{13.7573739141, 13.7573740818, -84.9358485639, -84.9358482286}},
	{"3t617", Box{-15.2490234375, -15.205078125, -109.555664062, -109.51171875}},
	{"qnkq1pz", Box{-8.74649047852, -8.7451171875, 96.0301208496, 96.0314941406}},
	{"fu", Box{67.5, 73.125, -56.25, -45.0}},
	{"7vs", Box{-14.0625, -12.65625, -5.625, -4.21875}},
	{"bztqz0h", Box{88.3740234375, 88.3753967285, -138.554077148, -138.552703857}},
	{"b8j", Box{45.0, 46.40625, -150.46875, -149.0625}},
	{"cetkxmq73", Box{65.5079126358, 65.5079555511, -104.789958, -104.789915085}},
	{"p91", Box{-84.375, -82.96875, 158.90625, 160.3125}},
	{"z4g7bn4w38", Box{61.1619615555, 61.1619669199, 139.573810101, 139.573820829}},
	{"j", Box{-90.0, -45.0, 45.0, 90.0}},
	{"g2eej64jbwj", Box{48.3518493176, 48.3518506587, -28.5946373641, -28.594636023}},
	{"fwshzb30mj", Box{82.398903966, 82.3989093304, -61.5328359604, -61.5328252316}},
	{"fv2mqt", Box{75.4815673828, 75.4870605469, -55.6127929688, -55.6018066406}},
	{"bzr6m3zdun5", Box{86.1868751049, 86.186876446, -135.813499242, -135.813497901}},
	{"et5rq77j8b", Box{29.4182109833, 29.4182163477, -17.6508772373, -17.6508665085}},
	{"1c", Box{-84.375, -78.75, -101.25, -90.0}},
	{"y1hyumh10jq", Box{51.8391890824, 51.8391904235, 96.8719562888, 96.8719576299}},
	{"qd42djnqxq", Box{-33.6334955692, -33.6334902048, 115.76084733, 115.760858059}},
	{"hsd9s", Box{-64.423828125, -64.3798828125, 26.19140625, 26.2353515625}},
	{"8289gq947", Box{3.156208992, 3.15625190735, -167.902550697, -167.902507782}},
	{"em37sw72zq4", Box{30.1809775829, 30.180978924, -31.7896565795, -31.7896552384}},
	{"zms25", Box{75.9375, 75.9814453125, 152.358398438, 152.40234375}},
	{"h25d54", Box{-89.6374511719, -89.6319580078, 16.3037109375, 16.3146972656}},
	{"6qc7y2t4bb", Box{-6.36885166168, -6.36884629726, -76.7106306553, -76.7106199265}},
	{"06vt5z8j", Box{-73.6102867126, -73.6101150513, -160.850830078, -160.850486755}},
	{"37q3", Box{-26.54296875, -26.3671875, -114.9609375, -114.609375}},
	{"sey9wu", Box{21.3793945312, 21.3848876953, 31.9372558594, 31.9482421875}},
	{"qk0jrj", Box{-21.5496826172, -21.5441894531, 101.557617188, 101.568603516}},
	{"8x6jjpm0", Box{41.6999816895, 41.7001533508, -154.460906982, -154.46056366}},
	{"5j1etu", Box{-61.2377929688, -61.2322998047, -42.6379394531, -42.626953125}},
	{"r6b", Box{-29.53125, -28.125, 146.25, 147.65625}},
	{"ddu3vyj07", Box{15.8093690872, 15.8094120026, -61.263756752, -61.2637138367}},
	{"m9fm5q2d91", Box{-34.2425769567, -34.2425715923, 70.8076143265, 70.8076250553}},
	{"0pxdx", Box{-47.373046875, -47.3291015625, -169.145507812, -169.1015625}},
	{"w", Box{0.0, 45.0, 90.0, 135.0}},
	{"q1e", Box{-36.5625, -35.15625, 94.21875, 95.625}},
	{"h3vxhm8tu", Box{-78.8945817947, -78.8945388794, 19.172000885, 19.1720438004}},
	{"bcxsz", Box{54.2724609375, 54.31640625, -135.395507812, -135.3515625}},
	{"crjh", Box{85.078125, 85.25390625, -116.71875, -116.3671875}},
	{"bdqejqqgwj", Box{58.2185536623, 58.2185590267, -148.119134903, -148.119124174}},
	{"x7zhc480u7", Box{21.9425886869, 21.9425940514, 156.137877703, 156.137888432}},
	{"xhr7c9nd6js9", Box{24.5713387616, 24.5713389292, 145.270248726, 145.270249061}},
	{"f25r3r", Box{46.3128662109, 46.318359375, -74.1247558594, -74.1137695312}},
	{"b4v1e8zek", Box{60.7370996475, 60.7371425629, -172.804470062, -172.804427147}},
	{"95cwh1k", Box{22.1553039551, 22.1566772461, -132.709350586, -132.707977295}},
	{"kh1r", Box{-21.26953125, -21.09375, 1.7578125, 2.109375}},
	{"7p", Box{-5.625, 0.0, -45.0, -33.75}},
	{"mgsvj", Box{-24.43359375, -24.3896484375, 85.6494140625, 85.693359375}},
	{"k70", Box{-28.125, -26.71875, 11.25, 12.65625}},
	{"pxjr5g", Box{-49.3780517578, -49.3725585938, 165.047607422, 165.05859375}},
	{"3", Box{-45.0, 0.0, -135.0, -90.0}},
	{"81pv", Box{6.50390625, 6.6796875, -169.1015625, -168.75}},
	{"jjg", Box{-57.65625, -56.25, 49.21875, 50.625}},
	{"732kjtvw", Box{-37.2330093384, -37.232837677, -33.1491851807, -33.1488418579}},
	{"kuc2", Box{-18.28125, -18.10546875, 35.5078125, 35.859375}},
	{"wn91fmw18yp", Box{36.9006192684, 36.9006206095, 91.5134082735, 91.5134096146}},
	{"5wdnzyz5r", Box{-52.2133398056, -52.2132968903, -19.3370103836, -19.3369674683}},
	{"m682wkeu80", Box{-30.8241176605, -30.8241122961, 56.8813705444, 56.8813812733}},
	{"r18jv9k", Box{-35.5448913574, -35.5435180664, 135.247192383, 135.248565674}},
	{"zr079yhvttr", Box{85.0241656601, 85.0241670012, 146.685235351, 146.685236692}},
	{"r4umz4vhvm", Box{-28.5045593977, -28.5045540333, 141.291271448, 141.291282177}},
	{"58gdwpzc3zs", Box{-85.2989700437, -85.2989687026, -17.3037296534, -17.3037283123}},
	{"64frgqpt0yj", Box{-28.1350958347, -28.1350944936, -86.6827766597, -86.6827753186}},
	{"8n18eckkw5", Box{33.8455456495, 33.8455510139, -177.719736099, -177.71972537}},
	{"mz326c81b1", Box{-4.16625916958, -4.16625380516, 80.6286621094, 80.6286728382}},
	{"hx", Box{-50.625, -45.0, 22.5, 33.75}},
	{"ush2juq", Box{67.5233459473, 67.5247192383, 28.737487793, 28.738861084}},
	{"bp6h7m8fe", Box{86.5589618683, 86.5590047836, -177.04351902, -177.043476105}},
	{"111", Box{-84.375, -82.96875, -133.59375, -132.1875}},
	{"m9hwzz", Box{-38.1500244141, -38.14453125, 74.1687011719, 74.1796875}},
	{"100u6e92zuk", Box{-89.2335520685, -89.2335507274, -133.833394647, -133.833393306}},
	{"y", Box{45.0, 90.0, 90.0, 135.0}},
	{"9wbmdmhu", Box{38.9636993408, 38.9638710022, -112.043037415, -112.042694092}},
	{"9p1jg8k", Box{40.3871154785, 40.3884887695, -133.434448242, -133.433074951}},
	{"vqf6kw", Box{83.3972167969, 83.4027099609, 59.6118164062, 59.6228027344}},
	{"gw", Box{78.75, 84.375, -22.5, -11.25}},
	{"h49v9", Box{-74.970703125, -74.9267578125, 2.5048828125, 2.548828125}},
	{"23cmz", Box{-34.1455078125, -34.1015625, -166.684570312, -166.640625}},
	{"71", Box{-39.375, -33.75, -45.0, -33.75}},
	{"5x2kvmbu", Box{-48.3515167236, -48.3513450623, -21.9166946411, -21.9163513184}},
	{"1nywfjs8e", Box{-50.8144283295, -50.8143854141, -125.765175819, -125.765132904}},
	{"7u4vm3b9qy", Box{-21.5672886372, -21.5672832727, -7.15112328529, -7.15111255646}},
	{"rx4n750gn", Box{-4.50937271118, -4.50932979584, 160.445623398, 160.445666313}},
	{"9", Box{0.0, 45.0, -135.0, -90.0}},
	{"nxfyqng3", Box{-45.2703666687, -45.2701950073, 116.635322571, 116.635665894}},
	{"tgnt", Box{17.75390625, 17.9296875, 87.890625, 88.2421875}},
	{"qe2k5jtbm2c", Box{-25.985365659, -25.9853643179, 112.991521508, 112.991522849}},
	{"d", Box{0.0, 45.0, -90.0, -45.0}},
	{"1jhq", Box{-60.8203125, -60.64453125, -129.0234375, -128.671875}},
	{"p874n4ubjm", Box{-88.2270544767, -88.2270491123, 161.989170313, 161.989181042}},
	{"91h2qc", Box{5.67443847656, 5.67993164062, -128.726806641, -128.715820312}},
	{"mzp8s0p", Box{-5.537109375, -5.53573608398, 89.4822692871, 89.4836425781}},
	{"ptp0rem", Box{-61.8132019043, -61.8118286133, 167.680206299, 167.68157959}},
	{"14", Box{-78.75, -73.125, -135.0, -123.75}},
	{"s4dq", Box{15.1171875, 15.29296875, 3.1640625, 3.515625}},
	{"uvs7", Box{76.46484375, 76.640625, 39.7265625, 40.078125}},
	{"wh9xq3mqh", Box{26.5948104858, 26.5948534012, 92.3914146423, 92.3914575577}},
	{"kz", Box{-5.625, 0.0, 33.75, 45.0}},
	{"s8t4hkb3", Box{3.19032669067, 3.19049835205, 29.7183609009, 29.7187042236}},
	{"3ry9w", Box{-1.142578125, -1.0986328125, -114.345703125, -114.301757812}},
	{"mf1wt5", Box{-32.5909423828, -32.5854492188, 81.0791015625, 81.0900878906}},
	{"e", Box{0.0, 45.0, -45.0, 0.0}},
	{"mh", Box{-22.5, -16.875, 45.0, 56.25}},
	{"75y3665k", Box{-23.6748504639, -23.6746788025, -36.1075973511, -36.1072540283}},
	{"sts", Box{30.9375, 32.34375, 28.125, 29.53125}},
	{"6fdmxb", Box{-29.970703125, -29.9652099609, -52.7453613281, -52.734375}},
	{"xcvf9qbx13jx", Box{10.3214901499, 10.3214903176, 176.891616806, 176.891617142}},
	{"n1r6pkxu86t", Box{-82.5916823745, -82.5916810334, 100.524576455, 100.524577796}},
	{"1m2p", Box{-59.23828125, -59.0625, -123.75, -123.3984375}},
	{"fz", Box{84.375, 90.0, -56.25, -45.0}},
	{"hgw", Box{-70.3125, -68.90625, 42.1875, 43.59375}},
	{"ssktp8e5hsub", Box{24.7884432971, 24.7884434648, 29.1620342061, 29.1620345414}},
	{"8wbw4", Box{39.0234375, 39.0673828125, -156.708984375, -156.665039062}},
	{"wbcdsqtpnkh9", Box{4.69513194636, 4.69513211399, 126.053283289, 126.053283624}},
	{"f0md", Box{46.7578125, 46.93359375, -82.265625, -81.9140625}},
	{"hngnmbt2pe4", Box{-50.9298545122, -50.9298531711, 4.478969872, 4.4789712131}},
	{"gbkn8cgjewxc", Box{47.559420336, 47.5594205037, -5.58776054531, -5.58776021004}},
	{"u", Box{45.0, 90.0, 0.0, 45.0}},
	{"b5", Box{61.875, 67.5, -180.0, -168.75}},
	{"w1r042nrqyk", Box{7.0325280726, 7.0325294137, 99.951505065, 99.9515064061}},
	{"tv6r1uuh1h", Box{30.7885193825, 30.7885247469, 81.9965028763, 81.9965136051}},
	{"r1hw8pqpr3", Box{-38.1913465261, -38.1913411617, 141.336675882, 141.336686611}},
	{"j2bcyrxdgj", Box{-85.4319351912, -85.4319298267, 57.5897741318, 57.5897848606}},
	{"m", Box{-45.0, 0.0, 45.0, 90.0}},
	{"qtxvgfvmrbf", Box{-13.0357463658, -13.0357450247, 123.570777476, 123.570778817}},
	{"jp", Box{-50.625, -45.0, 45.0, 56.25}},
	{"f76", Box{63.28125, 64.6875, -75.9375, -74.53125}},
	{"vz9", Box{87.1875, 88.59375, 80.15625, 81.5625}},
	{"wm", Box{28.125, 33.75, 101.25, 112.5}},
	{"c0wn5", Box{48.8671875, 48.9111328125, -126.430664062, -126.38671875}},
	{"7pn7whg", Box{-4.9836730957, -4.98229980469, -35.943145752, -35.9417724609}},
	{"s", Box{0.0, 45.0, 0.0, 45.0}},
	{"txwr3", Box{43.4619140625, 43.505859375, 76.3330078125, 76.376953125}},
	{"zc0", Box{50.625, 52.03125, 168.75, 170.15625}},
	{"sq7pru6gr", Box{36.4545679092, 36.4546108246, 15.8134031296, 15.8134460449}},
	{"nu", Box{-67.5, -61.875, 123.75, 135.0}},
	{"7dkt6vr", Box{-31.3920593262, -31.3906860352, -16.0414123535, -16.0400390625}},
	{"xm2uwefdyf1", Box{30.3433477879, 30.343349129, 147.594056278, 147.59405762}},
	{"mgmnc0", Box{-25.5322265625, -25.5267333984, 85.8251953125, 85.8361816406}},
	{"jj1shq", Box{-61.1389160156, -61.1334228516, 47.2961425781, 47.3071289062}},
	{"3", Box{-45.0, 0.0, -135.0, -90.0}},
	{"0p4y3p8tgr", Box{-49.4841438532, -49.4841384888, -176.088041067, -176.088030338}},
	{"gu", Box{67.5, 73.125, -11.25, 0.0}},
	{"e94", Box{5.625, 7.03125, -19.6875, -18.28125}},
	{"u7khr", Box{64.0283203125, 64.072265625, 17.1826171875, 17.2265625}},
	{"k1k", Box{-37.96875, -36.5625, 5.625, 7.03125}},
	{"wks48m7f", Box{25.7811355591, 25.7813072205, 106.891136169, 106.891479492}},
	{"z91w3", Box{51.7236328125, 51.767578125, 159.653320312, 159.697265625}},
	{"c2d6xmbp1", Box{48.284740448, 48.2847833633, -120.267291069, -120.267248154}},
	{"s9yur", Box{10.5908203125, 10.634765625, 32.2998046875, 32.34375}},
	{"7u09b46", Box{-22.1800231934, -22.1786499023, -10.544128418, -10.542755127}},
	{"8sndxb", Box{22.939453125, 22.9449462891, -148.018798828, -148.0078125}},
	{"j2g761bhsex", Box{-85.1995566487, -85.1995553076, 60.9084056318, 60.9084069729}},
	{"5wg", Box{-52.03125, -50.625, -18.28125, -16.875}},
	{"fzn", Box{84.375, 85.78125, -47.8125, -46.40625}},
	{"ugdpz8p4mu", Box{66.0502123833, 66.0502177477, 36.9019496441, 36.9019603729}},
	{"nx", Box{-50.625, -45.0, 112.5, 123.75}},
	{"d", Box{0.0, 45.0, -90.0, -45.0}},
	{"crr9e8mz59se", Box{86.0475053452, 86.0475055128, -113.041263744, -113.041263409}},
	{"dgmpsg", Box{19.6160888672, 19.6215820312, -49.0100097656, -48.9990234375}},
	{"jcfk52m03", Box{-79.4517087936, -79.4516658783, 82.063794136, 82.0638370514}},
	{"d8trpccuk", Box{4.05331134796, 4.05335426331, -59.7740364075, -59.7739934921}},
	{"93g9665", Box{10.0744628906, 10.0758361816, -118.725128174, -118.723754883}},
	{"sqt7cuf8d0f", Box{37.2478620708, 37.2478634119, 18.7132385373, 18.7132398784}},
	{"f9", Box{50.625, 56.25, -67.5, -56.25}},
	{"k90", Box{-39.375, -37.96875, 22.5, 23.90625}},
	{"k8xdhcv", Box{-41.8263244629, -41.8249511719, 33.2624816895, 33.2638549805}},
	{"4989w4r926t7", Box{-81.2862400152, -81.2862398475, -66.5228856727, -66.5228853375}},
	{"c3", Box{50.625, 56.25, -123.75, -112.5}},
	{"bd908pg0", Box{59.1929626465, 59.1931343079, -156.089630127, -156.089286804}},
	{"bq", Box{78.75, 84.375, -168.75, -157.5}},
	{"chcdt", Box{72.158203125, 72.2021484375, -132.670898438, -132.626953125}},
	{"hff8vsrzhy39", Box{-74.3748327903, -74.3748326227, 37.5181730837, 37.5181734189}},
	{"9gef7g6ezj", Box{20.101531148, 20.1015365124, -95.8080339432, -95.8080232143}},
	{"yc0u2dp", Box{51.3830566406, 51.3844299316, 124.836273193, 124.837646484}},
	{"w0b41f7", Box{4.58267211914, 4.58404541016, 90.0810241699, 90.0823974609}},
	{"8cdmwjc", Box{9.43588256836, 9.43725585938, -142.820892334, -142.819519043}},
	{"p4ngqtjm2", Box{-78.150343895, -78.1503009796, 144.785041809, 144.785084724}},
	{"5", Box{-90.0, -45.0, -45.0, 0.0}},
	{"3qtzqdknx", Box{-7.14961051941, -7.14956760406, -115.372624397, -115.372581482}},
	{"gzjhuv9xmkg5", Box{85.2414438687, 85.2414440364, -4.00772050023, -4.00772016495}},
	{"8g8t7eh4y0fh", Box{20.6273078173, 20.627307985, -145.387313068, -145.387312733}},
	{"39w", Box{-36.5625, -35.15625, -104.0625, -102.65625}},
	{"z34rj8", Box{51.85546875, 51.8609619141, 149.655761719, 149.666748047}},
	{"c9p0zv2", Box{50.7856750488, 50.7870483398, -102.315673828, -102.314300537}},
	{"vh871y", Box{70.8728027344, 70.8782958984, 45.4284667969, 45.439453125}},
	{"7ggt8b4yfw", Box{-22.9382622242, -22.9382568598, -6.29128217697, -6.29127144814}},
	{"3qz3d324z", Box{-6.76023960114, -6.76019668579, -113.455510139, -113.455467224}},
	{"4sm2463w0w", Box{-66.0803282261, -66.0803228617, -60.0162291527, -60.0162184238}},
	{"26ewbu0gw3", Box{-29.728397727, -29.7283923626, -163.793867826, -163.793857098}},
	{"bre7js2w9z", Box{87.7393430471, 87.7393484116, -163.937226534, -163.937215805}},
	{"sy5ug08bn", Box{34.5877075195, 34.5877504349, 39.1565608978, 39.1566038132}},
	{"p4r", Box{-77.34375, -75.9375, 144.84375, 146.25}},
	{"qb", Box{-45.0, -39.375, 123.75, 135.0}},
	{"f4hj", Box{57.12890625, 57.3046875, -84.375, -84.0234375}},
	{"5r0f5t7d5", Box{-50.2442550659, -50.2442121506, -32.5365686417, -32.5365257263}},
	{"2j7n4r6r", Box{-14.3730354309, -14.3728637695, -175.679283142, -175.678939819}},
	{"wu92egv2wsy", Box{25.4211013019, 25.421102643, 125.680104196, 125.680105537}},
	{"vgtwey347bg", Box{65.8648006618, 65.8648020029, 86.6507081687, 86.6507095098}},
	{"q2meny7pbd18", Box{-43.0307328701, -43.0307327025, 109.285149202, 109.285149537}},
	{"rpe", Box{-2.8125, -1.40625, 139.21875, 140.625}},
	{"m69", Box{-30.9375, -29.53125, 57.65625, 59.0625}},
	{"w1zwd8", Box{10.986328125, 10.9918212891, 100.656738281, 100.667724609}},
	{"fzpf", Box{84.7265625, 84.90234375, -45.3515625, -45.0}},
	{"t3w", Box{8.4375, 9.84375, 64.6875, 66.09375}},
	{"zb11", Box{45.17578125, 45.3515625, 170.15625, 170.5078125}},
	{"r2prkmxpgtww", Box{-43.6940126494, -43.6940124817, 156.641852036, 156.641852371}},
	{"zr34g1zcj", Box{86.274433136, 86.2744760513, 147.79894352, 147.798986435}},
	{"19mgdk8", Box{-82.3287963867, -82.3274230957, -104.315185547, -104.313812256}},
	{"mkp", Box{-22.5, -21.09375, 66.09375, 67.5}},
	{"934qy86ssc", Box{6.81367456913, 6.81367993355, -120.296655893, -120.296645164}},
	{"byydj4mrm8", Box{83.3339166641, 83.3339220285, -136.882202625, -136.882191896}},
	{"j", Box{-90.0, -45.0, 45.0, 90.0}},
	{"9cjzqv5n6", Box{6.92795276642, 6.92799568176, -92.8632259369, -92.8631830215}},
	{"vkg1wg6s", Box{72.0009613037, 72.0011329651, 60.7688140869, 60.7691574097}},
	{"ynp42e9x", Box{79.1659355164, 79.1661071777, 99.8677825928, 99.8681259155}},
	{"uv9zwddtwn", Box{77.2705686092, 77.2705739737, 36.5002727509, 36.5002834797}},
	{"t17zkzszpm", Box{8.3480912447, 8.34809660912, 50.4890120029, 50.4890227318}},
	{"tuw779c04ukm", Box{25.8934257366, 25.8934259042, 87.6943681017, 87.6943684369}},
	{"37rm598", Box{-25.8316040039, -25.8302307129, -113.400878906, -113.399505615}},
	{"ymf18", Box{77.607421875, 77.6513671875, 104.0625, 104.106445312}},
	{"gd", Box{56.25, 61.875, -22.5, -11.25}},
	{"smz", Box{32.34375, 33.75, 21.09375, 22.5}},
	{"p", Box{-90.0, -45.0, 135.0, 180.0}},
	{"muzkh95w2u42", Box{-17.5715374947, -17.571537327, 89.1479081288, 89.1479084641}},
	{"hh53c48eg", Box{-67.1780061722, -67.1779632568, 4.61507320404, 4.61511611938}},
	{"739ewv", Box{-35.9197998047, -35.9143066406, -31.3439941406, -31.3330078125}},
	{"cw883", Box{81.6064453125, 81.650390625, -111.752929688, -111.708984375}},
	{"41xu1w37yf", Box{-80.8243882656, -80.8243829012, -79.0336382389, -79.0336275101}},
	{"0y750v2k", Box{-54.2868804932, -54.2867088318, -141.997947693, -141.99760437}},
	{"gqbgw", Box{83.583984375, 83.6279296875, -32.431640625, -32.3876953125}},
	{"pej", Box{-73.125, -71.71875, 164.53125, 165.9375}},
	{"r05t", Box{-44.12109375, -43.9453125, 139.921875, 140.2734375}},
	{"qfuew7wk4f", Box{-28.8960921764, -28.896086812, 130.361484289, 130.361495018}},
	{"nu357yhp72y", Box{-65.4882533848, -65.4882520437, 125.326685607, 125.326686949}},
	{"8qt7rnggz", Box{37.1715116501, 37.1715545654, -161.054120064, -161.054077148}},
	{"dhjq2nz", Box{23.6357116699, 23.6370849609, -82.6075744629, -82.6062011719}},
	{"5s4", Box{-67.5, -66.09375, -19.6875, -18.28125}},
	{"ge8nq842", Box{65.7861328125, 65.7863044739, -22.211265564, -22.2109222412}},
	{"71", Box{-39.375, -33.75, -45.0, -33.75}},
	{"sz59kteks87q", Box{39.625713788, 39.6257139556, 38.8742895797, 38.874289915}},
	{"ur2bh", Box{85.78125, 85.8251953125, 12.48046875, 12.5244140625}},
	{"w140u2f", Box{5.76095581055, 5.76232910156, 93.0020141602, 93.0033874512}},
	{"fpd3zkt6whz4", Box{87.5202913955, 87.5202915631, -86.5098573267, -86.5098569915}},
	{"zmej764h8kb8", Box{76.8721358478, 76.8721360154, 150.614330247, 150.614330582}},
	{"k4p6z", Box{-33.2666015625, -33.22265625, 10.5029296875, 10.546875}},
	{"f8", Box{45.0, 50.625, -67.5, -56.25}},
	{"utsy6pv17m", Box{77.0789462328, 77.0789515972, 29.2745840549, 29.2745947838}},
	{"6z5", Box{-5.625, -4.21875, -52.03125, -50.625}},
	{"mjdc1", Box{-13.88671875, -13.8427734375, 48.9111328125, 48.955078125}},
	{"gjks4c2", Box{75.2412414551, 75.2426147461, -38.5510253906, -38.5496520996}},
	{"fvkvvrh42ju", Box{75.5808614194, 75.5808627605, -49.3341010809, -49.3340997398}},
	{"yp63x30p7u7", Box{86.0516823828, 86.0516837239, 93.4828309715, 93.4828323126}},
	{"6rw", Box{-2.8125, -1.40625, -70.3125, -68.90625}},
	{"28vsqm8sb6", Box{-40.0031411648, -40.0031358004, -149.490269423, -149.490258694}},
	{"be72g2zcek5", Box{63.4174847603, 63.4174861014, -152.776078731, -152.77607739}},
	{"xry6fn699f", Box{44.1117489338, 44.1117542982, 155.130461454, 155.130472183}},
	{"3sf7bw01y4", Box{-17.5888001919, -17.5887948275, -109.313707352, -109.313696623}},
	{"k729yrqr77", Box{-26.3700467348, -26.3700413704, 12.2365057468, 12.2365164757}},
	{"e", Box{0.0, 45.0, -45.0, 0.0}},
	{"63x6dd", Box{-36.1120605469, -36.1065673828, -68.4448242188, -68.4338378906}},
	{"z", Box{45.0, 90.0, 135.0, 180.0}},
	{"mzyj", Box{-0.52734375, -0.3515625, 87.1875, 87.5390625}},
	{"3j6r", Box{-14.23828125, -14.0625, -131.8359375, -131.484375}},
	{"u3q", Box{52.03125, 53.4375, 19.6875, 21.09375}},
	{"nueu7mbnbn4", Box{-63.9076530933, -63.9076517522, 129.166262448, 129.166263789}},
	{"cyq2pkr", Box{80.1795959473, 80.1809692383, -92.1327209473, -92.1313476562}},
	{"gptzzke9hvh", Box{88.5747224092, 88.5747237504, -36.5904432535, -36.5904419124}},
	{"khd", Box{-19.6875, -18.28125, 2.8125, 4.21875}},
	{"ghm92hg6p5", Box{69.1524285078, 69.1524338722, -37.2608613968, -37.260850668}},
	{"n9e20w0", Box{-81.5295410156, -81.5281677246, 117.092285156, 117.093658447}},
	{"826dzs0k", Box{1.91230773926, 1.91247940063, -164.904441833, -164.904098511}},
	{"0d5f2", Box{-78.3544921875, -78.310546875, -152.2265625, -152.182617188}},
	{"70zsyg3", Box{-39.9284362793, -39.9270629883, -34.1551208496, -34.1537475586}},
	{"zykh8gwy", Box{80.9675216675, 80.9676933289, 174.417228699, 174.417572021}},
	{"4spd3s", Box{-67.0825195312, -67.0770263672, -56.8872070312, -56.8762207031}},
	{"r9p6f2t", Box{-38.8888549805, -38.8874816895, 167.801055908, 167.802429199}},
	{"6q3merq7w", Box{-8.83652687073, -8.83648395538, -76.8405246735, -76.8404817581}},
	{"qx1zr32", Box{-4.34371948242, -4.34234619141, 115.279541016, 115.280914307}},
	{"3zfnk", Box{-0.3076171875, -0.263671875, -98.26171875, -98.2177734375}},
	{"kd2e3", Box{-31.7724609375, -31.728515625, 23.2470703125, 23.291015625}},
	{"stkhr6", Box{30.2893066406, 30.2947998047, 28.4436035156, 28.4545898438}},
	{"nh4pzbm", Box{-66.1363220215, -66.1349487305, 93.159942627, 93.161315918}},
	{"zt8tf", Box{76.9482421875, 76.9921875, 158.291015625, 158.334960938}},
	{"gd37", Box{58.18359375, 58.359375, -20.7421875, -20.390625}},
	{"gnx5b45dd", Box{82.2330951691, 82.2331380844, -35.1513576508, -35.1513147354}},
	{"2qm7", Box{-9.31640625, -9.140625, -161.3671875, -161.015625}},
	{"4g0zf0kq9cpp", Box{-71.7601996846, -71.760199517, -55.1015008986, -55.1015005633}},
	{"977tgt", Box{19.3194580078, 19.3249511719, -118.674316406, -118.663330078}},
	{"md0k", Box{-33.046875, -32.87109375, 67.8515625, 68.203125}},
	{"v1q3nvfb3h", Box{52.2386813164, 52.2386866808, 54.089512825, 54.0895235538}},
	{"z96pt6u96w", Box{53.3649623394, 53.3649677038, 160.549499989, 160.549510717}},
	{"pu", Box{-67.5, -61.875, 168.75, 180.0}},
	{"6uydh", Box{-17.9296875, -17.8857421875, -46.93359375, -46.8896484375}},
	{"nx5mt4sk", Box{-49.6437835693, -49.643611908, 117.295875549, 117.296218872}},
	{"nk8jt", Box{-63.720703125, -63.6767578125, 101.469726562, 101.513671875}},
	{"kec1015b", Box{-23.7249755859, -23.7248039246, 23.9113998413, 23.9117431641}},
	{"fk388b", Box{68.994140625, 68.9996337891, -76.6076660156, -76.5966796875}},
	{"nsb", Box{-63.28125, -61.875, 112.5, 113.90625}},
	{"ndbws", Box{-73.388671875, -73.3447265625, 113.37890625, 113.422851562}},
	{"fs5", Box{67.5, 68.90625, -63.28125, -61.875}},
	{"h6x0kbec6p15", Box{-75.8905554749, -75.8905553073, 21.3077272475, 21.3077275828}},
	{"hy78", Box{-54.84375, -54.66796875, 38.671875, 39.0234375}},
	{"vpun9j4ce9", Box{89.7640568018, 89.7640621662, 50.6728720665, 50.6728827953}},
	{"6tyevvqrj665", Box{-11.9670169987, -11.967016831, -58.0978783965, -58.0978780612}},
	{"d3ktekr48n", Box{8.02185416222, 8.02185952663, -72.2694396973, -72.2694289684}},
	{"heyfm2up5", Box{-68.5054206848, -68.5053777695, 32.2285223007, 32.2285652161}},
	{"mn3f7qjr22v", Box{-9.41403463483, -9.41403329372, 47.6109869778, 47.6109883189}},
	{"1wngqx9b", Box{-55.637512207, -55.6373405457, -102.719764709, -102.719421387}},
	{"xc9jv49jej", Box{9.46294605732, 9.46295142174, 170.3774786, 170.377489328}},
	{"27", Box{-28.125, -22.5, -168.75, -157.5}},
	{"6yhqnw", Box{-10.1623535156, -10.1568603516, -49.9877929688, -49.9768066406}},
	{"rmhhu3qd", Box{-16.0328292847, -16.0326576233, 152.07069397, 152.071037292}},
	{"y00b8mhby", Box{45.1154851913, 45.1155281067, 91.0724544525, 91.0724973679}},
	{"yq5tr", Box{79.6728515625, 79.716796875, 106.479492188, 106.5234375}},
	{"cuvxw", Box{73.037109375, 73.0810546875, -93.251953125, -93.2080078125}},
	{"exvb4bcn", Box{43.5988998413, 43.5990715027, -14.2918395996, -14.2914962769}},
	{"uhdpsyx75n0", Box{71.667112112, 71.6671134531, 3.03132534027, 3.03132668138}},
	{"y", Box{45.0, 90.0, 90.0, 135.0}},
	{"qvwbzgw7q", Box{-13.9108800888, -13.9108371735, 133.591604233, 133.591647148}},
	{"u0rqp0bres", Box{47.466366291, 47.4663716555, 10.503423214, 10.5034339428}},
	{"43k2u0vbnrbd", Box{-82.8327522799, -82.8327521123, -72.5894909352, -72.5894905999}},
	{"7r7kwz7xxr", Box{-3.38658392429, -3.38657855988, -28.8779389858, -28.877928257}},
	{"fu2f", Box{69.2578125, 69.43359375, -55.1953125, -54.84375}},
	{"9tkjsvzxw6", Box{30.5309307575, 30.5309361219, -106.655691862, -106.655681133}},
	{"y9x0z", Box{53.5693359375, 53.61328125, 122.651367188, 122.6953125}},
	{"y4rk4b25g", Box{58.3613920212, 58.3614349365, 100.316290855, 100.316333771}},
	{"sxmdmu9xcn", Box{41.202839613, 41.2028449774, 30.4891633987, 30.4891741276}},
	{"fb0", Box{45.0, 46.40625, -56.25, -54.84375}},
	{"7ffkxt5", Box{-28.7127685547, -28.7113952637, -7.7522277832, -7.75085449219}},
	{"n1x5jn4dr", Box{-81.0018110275, -81.0017681122, 100.067210197, 100.067253113}},
	{"uxcdctgmj", Box{89.1095924377, 89.1096353531, 24.6799707413, 24.6800136566}},
	{"h7", Box{-73.125, -67.5, 11.25, 22.5}},
	{"b", Box{45.0, 90.0, -180.0, -135.0}},
	{"us1n4udk", Box{68.5800933838, 68.5802650452, 24.0301895142, 24.0305328369}},
	{"zjtptsj2vn", Box{77.2779929638, 77.2779983282, 142.280373573, 142.280384302}},
	{"x6utsqz", Box{16.4726257324, 16.4739990234, 152.774505615, 152.775878906}},
	{"cs9dn901rqn", Box{70.6698024273, 70.6698037684, -110.104661286, -110.104659945}},
	{"sjbn", Box{33.3984375, 33.57421875, 0.0, 0.3515625}},
	{"0fwxjyc3g9q", Box{-74.6696452796, -74.6696439385, -136.854814589, -136.854813248}},
	{"fk", Box{67.5, 73.125, -78.75, -67.5}},
	{"75hq9jh", Box{-26.9549560547, -26.9535827637, -38.9739990234, -38.9726257324}},
	{"kr3hg1q1", Box{-3.37675094604, -3.37657928467, 12.7963256836, 12.7966690063}},
	{"hfq4d2wu", Box{-76.9008636475, -76.9006919861, 42.2956466675, 42.2959899902}},
	{"rg6ygh", Box{-25.5102539062, -25.5047607422, 172.749023438, 172.760009766}},
	{"995pvrg", Box{7.02987670898, 7.03125, -108.046417236, -108.045043945}},
	{"s5ys", Box{21.796875, 21.97265625, 9.140625, 9.4921875}},
	{"289ucubzj6", Box{-41.3252341747, -41.3252288103, -154.960902929, -154.9608922}},
	{"4", Box{-90.0, -45.0, -90.0, -45.0}},
	{"7g0e3gp7cz", Box{-27.5365501642, -27.5365447998, -10.4599392414, -10.4599285126}},
	{"9suuudg", Box{27.5688171387, 27.5701904297, -105.618438721, -105.61706543}},
	{"8vdt3j8zb0", Box{31.8918943405, 31.8918997049, -142.689399719, -142.68938899}},
	{"cf", Box{56.25, 61.875, -101.25, -90.0}},
	{"jnp33f5pr9", Box{-56.0180372, -56.0180318356, 55.276658535, 55.2766692638}},
	{"czgmgyb", Box{89.6415710449, 89.6429443359, -96.5148925781, -96.5135192871}},
	{"c1kk", Box{52.734375, 52.91015625, -129.0234375, -128.671875}},
	{"kfm4hfe8cp4s", Box{-31.9782876223, -31.9782874547, 40.994843021, 40.9948433563}},
	{"9mnws4hc8h", Box{29.2788434029, 29.2788487673, -114.427070618, -114.427059889}},
	{"t0j7chwg", Box{0.684413909912, 0.684585571289, 52.4360275269, 52.4363708496}},
	{"y", Box{45.0, 90.0, 90.0, 135.0}},
	{"suj", Box{22.5, 23.90625, 40.78125, 42.1875}},
}
