// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package fbsemantic

import (
	"strconv"

	flatbuffers "github.com/google/flatbuffers/go"
)

type MonoType byte

const (
	MonoTypeNONE       MonoType = 0
	MonoTypeBasic      MonoType = 1
	MonoTypeVar        MonoType = 2
	MonoTypeCollection MonoType = 3
	MonoTypeRecord     MonoType = 4
	MonoTypeFun        MonoType = 5
	MonoTypeDict       MonoType = 6
	MonoTypeDynamic    MonoType = 7
)

var EnumNamesMonoType = map[MonoType]string{
	MonoTypeNONE:       "NONE",
	MonoTypeBasic:      "Basic",
	MonoTypeVar:        "Var",
	MonoTypeCollection: "Collection",
	MonoTypeRecord:     "Record",
	MonoTypeFun:        "Fun",
	MonoTypeDict:       "Dict",
	MonoTypeDynamic:    "Dynamic",
}

var EnumValuesMonoType = map[string]MonoType{
	"NONE":       MonoTypeNONE,
	"Basic":      MonoTypeBasic,
	"Var":        MonoTypeVar,
	"Collection": MonoTypeCollection,
	"Record":     MonoTypeRecord,
	"Fun":        MonoTypeFun,
	"Dict":       MonoTypeDict,
	"Dynamic":    MonoTypeDynamic,
}

func (v MonoType) String() string {
	if s, ok := EnumNamesMonoType[v]; ok {
		return s
	}
	return "MonoType(" + strconv.FormatInt(int64(v), 10) + ")"
}

type Type byte

const (
	TypeBool     Type = 0
	TypeInt      Type = 1
	TypeUint     Type = 2
	TypeFloat    Type = 3
	TypeString   Type = 4
	TypeDuration Type = 5
	TypeTime     Type = 6
	TypeRegexp   Type = 7
	TypeBytes    Type = 8
)

var EnumNamesType = map[Type]string{
	TypeBool:     "Bool",
	TypeInt:      "Int",
	TypeUint:     "Uint",
	TypeFloat:    "Float",
	TypeString:   "String",
	TypeDuration: "Duration",
	TypeTime:     "Time",
	TypeRegexp:   "Regexp",
	TypeBytes:    "Bytes",
}

var EnumValuesType = map[string]Type{
	"Bool":     TypeBool,
	"Int":      TypeInt,
	"Uint":     TypeUint,
	"Float":    TypeFloat,
	"String":   TypeString,
	"Duration": TypeDuration,
	"Time":     TypeTime,
	"Regexp":   TypeRegexp,
	"Bytes":    TypeBytes,
}

func (v Type) String() string {
	if s, ok := EnumNamesType[v]; ok {
		return s
	}
	return "Type(" + strconv.FormatInt(int64(v), 10) + ")"
}

type CollectionType byte

const (
	CollectionTypeArray  CollectionType = 0
	CollectionTypeVector CollectionType = 1
	CollectionTypeStream CollectionType = 2
)

var EnumNamesCollectionType = map[CollectionType]string{
	CollectionTypeArray:  "Array",
	CollectionTypeVector: "Vector",
	CollectionTypeStream: "Stream",
}

var EnumValuesCollectionType = map[string]CollectionType{
	"Array":  CollectionTypeArray,
	"Vector": CollectionTypeVector,
	"Stream": CollectionTypeStream,
}

func (v CollectionType) String() string {
	if s, ok := EnumNamesCollectionType[v]; ok {
		return s
	}
	return "CollectionType(" + strconv.FormatInt(int64(v), 10) + ")"
}

type RecordLabel byte

const (
	RecordLabelNONE     RecordLabel = 0
	RecordLabelConcrete RecordLabel = 1
	RecordLabelVar      RecordLabel = 2
)

var EnumNamesRecordLabel = map[RecordLabel]string{
	RecordLabelNONE:     "NONE",
	RecordLabelConcrete: "Concrete",
	RecordLabelVar:      "Var",
}

var EnumValuesRecordLabel = map[string]RecordLabel{
	"NONE":     RecordLabelNONE,
	"Concrete": RecordLabelConcrete,
	"Var":      RecordLabelVar,
}

func (v RecordLabel) String() string {
	if s, ok := EnumNamesRecordLabel[v]; ok {
		return s
	}
	return "RecordLabel(" + strconv.FormatInt(int64(v), 10) + ")"
}

type Kind byte

const (
	KindAddable      Kind = 0
	KindBasic        Kind = 1
	KindSubtractable Kind = 2
	KindDivisible    Kind = 3
	KindNumeric      Kind = 4
	KindComparable   Kind = 5
	KindEquatable    Kind = 6
	KindLabel        Kind = 7
	KindNullable     Kind = 8
	KindRecord       Kind = 9
	KindNegatable    Kind = 10
	KindTimeable     Kind = 11
	KindStringable   Kind = 12
)

var EnumNamesKind = map[Kind]string{
	KindAddable:      "Addable",
	KindBasic:        "Basic",
	KindSubtractable: "Subtractable",
	KindDivisible:    "Divisible",
	KindNumeric:      "Numeric",
	KindComparable:   "Comparable",
	KindEquatable:    "Equatable",
	KindLabel:        "Label",
	KindNullable:     "Nullable",
	KindRecord:       "Record",
	KindNegatable:    "Negatable",
	KindTimeable:     "Timeable",
	KindStringable:   "Stringable",
}

var EnumValuesKind = map[string]Kind{
	"Addable":      KindAddable,
	"Basic":        KindBasic,
	"Subtractable": KindSubtractable,
	"Divisible":    KindDivisible,
	"Numeric":      KindNumeric,
	"Comparable":   KindComparable,
	"Equatable":    KindEquatable,
	"Label":        KindLabel,
	"Nullable":     KindNullable,
	"Record":       KindRecord,
	"Negatable":    KindNegatable,
	"Timeable":     KindTimeable,
	"Stringable":   KindStringable,
}

func (v Kind) String() string {
	if s, ok := EnumNamesKind[v]; ok {
		return s
	}
	return "Kind(" + strconv.FormatInt(int64(v), 10) + ")"
}

type Statement byte

const (
	StatementNONE                     Statement = 0
	StatementOptionStatement          Statement = 1
	StatementBuiltinStatement         Statement = 2
	StatementTestStatement            Statement = 3
	StatementExpressionStatement      Statement = 4
	StatementNativeVariableAssignment Statement = 5
	StatementMemberAssignment         Statement = 6
	StatementReturnStatement          Statement = 7
)

var EnumNamesStatement = map[Statement]string{
	StatementNONE:                     "NONE",
	StatementOptionStatement:          "OptionStatement",
	StatementBuiltinStatement:         "BuiltinStatement",
	StatementTestStatement:            "TestStatement",
	StatementExpressionStatement:      "ExpressionStatement",
	StatementNativeVariableAssignment: "NativeVariableAssignment",
	StatementMemberAssignment:         "MemberAssignment",
	StatementReturnStatement:          "ReturnStatement",
}

var EnumValuesStatement = map[string]Statement{
	"NONE":                     StatementNONE,
	"OptionStatement":          StatementOptionStatement,
	"BuiltinStatement":         StatementBuiltinStatement,
	"TestStatement":            StatementTestStatement,
	"ExpressionStatement":      StatementExpressionStatement,
	"NativeVariableAssignment": StatementNativeVariableAssignment,
	"MemberAssignment":         StatementMemberAssignment,
	"ReturnStatement":          StatementReturnStatement,
}

func (v Statement) String() string {
	if s, ok := EnumNamesStatement[v]; ok {
		return s
	}
	return "Statement(" + strconv.FormatInt(int64(v), 10) + ")"
}

type Assignment byte

const (
	AssignmentNONE                     Assignment = 0
	AssignmentMemberAssignment         Assignment = 1
	AssignmentNativeVariableAssignment Assignment = 2
)

var EnumNamesAssignment = map[Assignment]string{
	AssignmentNONE:                     "NONE",
	AssignmentMemberAssignment:         "MemberAssignment",
	AssignmentNativeVariableAssignment: "NativeVariableAssignment",
}

var EnumValuesAssignment = map[string]Assignment{
	"NONE":                     AssignmentNONE,
	"MemberAssignment":         AssignmentMemberAssignment,
	"NativeVariableAssignment": AssignmentNativeVariableAssignment,
}

func (v Assignment) String() string {
	if s, ok := EnumNamesAssignment[v]; ok {
		return s
	}
	return "Assignment(" + strconv.FormatInt(int64(v), 10) + ")"
}

type Expression byte

const (
	ExpressionNONE                   Expression = 0
	ExpressionStringExpression       Expression = 1
	ExpressionArrayExpression        Expression = 2
	ExpressionDictExpression         Expression = 3
	ExpressionFunctionExpression     Expression = 4
	ExpressionBinaryExpression       Expression = 5
	ExpressionCallExpression         Expression = 6
	ExpressionConditionalExpression  Expression = 7
	ExpressionIdentifierExpression   Expression = 8
	ExpressionLogicalExpression      Expression = 9
	ExpressionMemberExpression       Expression = 10
	ExpressionIndexExpression        Expression = 11
	ExpressionObjectExpression       Expression = 12
	ExpressionUnaryExpression        Expression = 13
	ExpressionBooleanLiteral         Expression = 14
	ExpressionDateTimeLiteral        Expression = 15
	ExpressionDurationLiteral        Expression = 16
	ExpressionFloatLiteral           Expression = 17
	ExpressionIntegerLiteral         Expression = 18
	ExpressionStringLiteral          Expression = 19
	ExpressionRegexpLiteral          Expression = 20
	ExpressionUnsignedIntegerLiteral Expression = 21
)

var EnumNamesExpression = map[Expression]string{
	ExpressionNONE:                   "NONE",
	ExpressionStringExpression:       "StringExpression",
	ExpressionArrayExpression:        "ArrayExpression",
	ExpressionDictExpression:         "DictExpression",
	ExpressionFunctionExpression:     "FunctionExpression",
	ExpressionBinaryExpression:       "BinaryExpression",
	ExpressionCallExpression:         "CallExpression",
	ExpressionConditionalExpression:  "ConditionalExpression",
	ExpressionIdentifierExpression:   "IdentifierExpression",
	ExpressionLogicalExpression:      "LogicalExpression",
	ExpressionMemberExpression:       "MemberExpression",
	ExpressionIndexExpression:        "IndexExpression",
	ExpressionObjectExpression:       "ObjectExpression",
	ExpressionUnaryExpression:        "UnaryExpression",
	ExpressionBooleanLiteral:         "BooleanLiteral",
	ExpressionDateTimeLiteral:        "DateTimeLiteral",
	ExpressionDurationLiteral:        "DurationLiteral",
	ExpressionFloatLiteral:           "FloatLiteral",
	ExpressionIntegerLiteral:         "IntegerLiteral",
	ExpressionStringLiteral:          "StringLiteral",
	ExpressionRegexpLiteral:          "RegexpLiteral",
	ExpressionUnsignedIntegerLiteral: "UnsignedIntegerLiteral",
}

var EnumValuesExpression = map[string]Expression{
	"NONE":                   ExpressionNONE,
	"StringExpression":       ExpressionStringExpression,
	"ArrayExpression":        ExpressionArrayExpression,
	"DictExpression":         ExpressionDictExpression,
	"FunctionExpression":     ExpressionFunctionExpression,
	"BinaryExpression":       ExpressionBinaryExpression,
	"CallExpression":         ExpressionCallExpression,
	"ConditionalExpression":  ExpressionConditionalExpression,
	"IdentifierExpression":   ExpressionIdentifierExpression,
	"LogicalExpression":      ExpressionLogicalExpression,
	"MemberExpression":       ExpressionMemberExpression,
	"IndexExpression":        ExpressionIndexExpression,
	"ObjectExpression":       ExpressionObjectExpression,
	"UnaryExpression":        ExpressionUnaryExpression,
	"BooleanLiteral":         ExpressionBooleanLiteral,
	"DateTimeLiteral":        ExpressionDateTimeLiteral,
	"DurationLiteral":        ExpressionDurationLiteral,
	"FloatLiteral":           ExpressionFloatLiteral,
	"IntegerLiteral":         ExpressionIntegerLiteral,
	"StringLiteral":          ExpressionStringLiteral,
	"RegexpLiteral":          ExpressionRegexpLiteral,
	"UnsignedIntegerLiteral": ExpressionUnsignedIntegerLiteral,
}

func (v Expression) String() string {
	if s, ok := EnumNamesExpression[v]; ok {
		return s
	}
	return "Expression(" + strconv.FormatInt(int64(v), 10) + ")"
}

type Operator int8

const (
	OperatorMultiplicationOperator   Operator = 0
	OperatorDivisionOperator         Operator = 1
	OperatorModuloOperator           Operator = 2
	OperatorPowerOperator            Operator = 3
	OperatorAdditionOperator         Operator = 4
	OperatorSubtractionOperator      Operator = 5
	OperatorLessThanEqualOperator    Operator = 6
	OperatorLessThanOperator         Operator = 7
	OperatorGreaterThanEqualOperator Operator = 8
	OperatorGreaterThanOperator      Operator = 9
	OperatorStartsWithOperator       Operator = 10
	OperatorInOperator               Operator = 11
	OperatorNotOperator              Operator = 12
	OperatorExistsOperator           Operator = 13
	OperatorNotEmptyOperator         Operator = 14
	OperatorEmptyOperator            Operator = 15
	OperatorEqualOperator            Operator = 16
	OperatorNotEqualOperator         Operator = 17
	OperatorRegexpMatchOperator      Operator = 18
	OperatorNotRegexpMatchOperator   Operator = 19
	OperatorInvalidOperator          Operator = 20
)

var EnumNamesOperator = map[Operator]string{
	OperatorMultiplicationOperator:   "MultiplicationOperator",
	OperatorDivisionOperator:         "DivisionOperator",
	OperatorModuloOperator:           "ModuloOperator",
	OperatorPowerOperator:            "PowerOperator",
	OperatorAdditionOperator:         "AdditionOperator",
	OperatorSubtractionOperator:      "SubtractionOperator",
	OperatorLessThanEqualOperator:    "LessThanEqualOperator",
	OperatorLessThanOperator:         "LessThanOperator",
	OperatorGreaterThanEqualOperator: "GreaterThanEqualOperator",
	OperatorGreaterThanOperator:      "GreaterThanOperator",
	OperatorStartsWithOperator:       "StartsWithOperator",
	OperatorInOperator:               "InOperator",
	OperatorNotOperator:              "NotOperator",
	OperatorExistsOperator:           "ExistsOperator",
	OperatorNotEmptyOperator:         "NotEmptyOperator",
	OperatorEmptyOperator:            "EmptyOperator",
	OperatorEqualOperator:            "EqualOperator",
	OperatorNotEqualOperator:         "NotEqualOperator",
	OperatorRegexpMatchOperator:      "RegexpMatchOperator",
	OperatorNotRegexpMatchOperator:   "NotRegexpMatchOperator",
	OperatorInvalidOperator:          "InvalidOperator",
}

var EnumValuesOperator = map[string]Operator{
	"MultiplicationOperator":   OperatorMultiplicationOperator,
	"DivisionOperator":         OperatorDivisionOperator,
	"ModuloOperator":           OperatorModuloOperator,
	"PowerOperator":            OperatorPowerOperator,
	"AdditionOperator":         OperatorAdditionOperator,
	"SubtractionOperator":      OperatorSubtractionOperator,
	"LessThanEqualOperator":    OperatorLessThanEqualOperator,
	"LessThanOperator":         OperatorLessThanOperator,
	"GreaterThanEqualOperator": OperatorGreaterThanEqualOperator,
	"GreaterThanOperator":      OperatorGreaterThanOperator,
	"StartsWithOperator":       OperatorStartsWithOperator,
	"InOperator":               OperatorInOperator,
	"NotOperator":              OperatorNotOperator,
	"ExistsOperator":           OperatorExistsOperator,
	"NotEmptyOperator":         OperatorNotEmptyOperator,
	"EmptyOperator":            OperatorEmptyOperator,
	"EqualOperator":            OperatorEqualOperator,
	"NotEqualOperator":         OperatorNotEqualOperator,
	"RegexpMatchOperator":      OperatorRegexpMatchOperator,
	"NotRegexpMatchOperator":   OperatorNotRegexpMatchOperator,
	"InvalidOperator":          OperatorInvalidOperator,
}

func (v Operator) String() string {
	if s, ok := EnumNamesOperator[v]; ok {
		return s
	}
	return "Operator(" + strconv.FormatInt(int64(v), 10) + ")"
}

type LogicalOperator int8

const (
	LogicalOperatorAndOperator LogicalOperator = 0
	LogicalOperatorOrOperator  LogicalOperator = 1
)

var EnumNamesLogicalOperator = map[LogicalOperator]string{
	LogicalOperatorAndOperator: "AndOperator",
	LogicalOperatorOrOperator:  "OrOperator",
}

var EnumValuesLogicalOperator = map[string]LogicalOperator{
	"AndOperator": LogicalOperatorAndOperator,
	"OrOperator":  LogicalOperatorOrOperator,
}

func (v LogicalOperator) String() string {
	if s, ok := EnumNamesLogicalOperator[v]; ok {
		return s
	}
	return "LogicalOperator(" + strconv.FormatInt(int64(v), 10) + ")"
}

type Fresher struct {
	_tab flatbuffers.Table
}

func GetRootAsFresher(buf []byte, offset flatbuffers.UOffsetT) *Fresher {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Fresher{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsFresher(buf []byte, offset flatbuffers.UOffsetT) *Fresher {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Fresher{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Fresher) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Fresher) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Fresher) U() uint64 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.GetUint64(o + rcv._tab.Pos)
	}
	return 0
}

func (rcv *Fresher) MutateU(n uint64) bool {
	return rcv._tab.MutateUint64Slot(4, n)
}

func FresherStart(builder *flatbuffers.Builder) {
	builder.StartObject(1)
}
func FresherAddU(builder *flatbuffers.Builder, u uint64) {
	builder.PrependUint64Slot(0, u, 0)
}
func FresherEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Packages struct {
	_tab flatbuffers.Table
}

func GetRootAsPackages(buf []byte, offset flatbuffers.UOffsetT) *Packages {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Packages{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsPackages(buf []byte, offset flatbuffers.UOffsetT) *Packages {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Packages{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Packages) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Packages) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Packages) Packages(obj *PackageExports, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *Packages) PackagesLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func PackagesStart(builder *flatbuffers.Builder) {
	builder.StartObject(1)
}
func PackagesAddPackages(builder *flatbuffers.Builder, packages flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(packages), 0)
}
func PackagesStartPackagesVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func PackagesEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type PackageExports struct {
	_tab flatbuffers.Table
}

func GetRootAsPackageExports(buf []byte, offset flatbuffers.UOffsetT) *PackageExports {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &PackageExports{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsPackageExports(buf []byte, offset flatbuffers.UOffsetT) *PackageExports {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &PackageExports{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *PackageExports) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *PackageExports) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *PackageExports) Id() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *PackageExports) Package(obj *TypeEnvironment) *TypeEnvironment {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(TypeEnvironment)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func PackageExportsStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func PackageExportsAddId(builder *flatbuffers.Builder, id flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(id), 0)
}
func PackageExportsAddPackage(builder *flatbuffers.Builder, package_ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(package_), 0)
}
func PackageExportsEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type TypeEnvironment struct {
	_tab flatbuffers.Table
}

func GetRootAsTypeEnvironment(buf []byte, offset flatbuffers.UOffsetT) *TypeEnvironment {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &TypeEnvironment{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsTypeEnvironment(buf []byte, offset flatbuffers.UOffsetT) *TypeEnvironment {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &TypeEnvironment{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *TypeEnvironment) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *TypeEnvironment) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *TypeEnvironment) Assignments(obj *TypeAssignment, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *TypeEnvironment) AssignmentsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func TypeEnvironmentStart(builder *flatbuffers.Builder) {
	builder.StartObject(1)
}
func TypeEnvironmentAddAssignments(builder *flatbuffers.Builder, assignments flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(assignments), 0)
}
func TypeEnvironmentStartAssignmentsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func TypeEnvironmentEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type TypeAssignment struct {
	_tab flatbuffers.Table
}

func GetRootAsTypeAssignment(buf []byte, offset flatbuffers.UOffsetT) *TypeAssignment {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &TypeAssignment{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsTypeAssignment(buf []byte, offset flatbuffers.UOffsetT) *TypeAssignment {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &TypeAssignment{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *TypeAssignment) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *TypeAssignment) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *TypeAssignment) Id() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *TypeAssignment) Ty(obj *PolyType) *PolyType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(PolyType)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func TypeAssignmentStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func TypeAssignmentAddId(builder *flatbuffers.Builder, id flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(id), 0)
}
func TypeAssignmentAddTy(builder *flatbuffers.Builder, ty flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(ty), 0)
}
func TypeAssignmentEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type MonoTypeHolder struct {
	_tab flatbuffers.Table
}

func GetRootAsMonoTypeHolder(buf []byte, offset flatbuffers.UOffsetT) *MonoTypeHolder {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &MonoTypeHolder{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsMonoTypeHolder(buf []byte, offset flatbuffers.UOffsetT) *MonoTypeHolder {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &MonoTypeHolder{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *MonoTypeHolder) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *MonoTypeHolder) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *MonoTypeHolder) TypType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *MonoTypeHolder) MutateTypType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(4, byte(n))
}

func (rcv *MonoTypeHolder) Typ(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func MonoTypeHolderStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func MonoTypeHolderAddTypType(builder *flatbuffers.Builder, typType MonoType) {
	builder.PrependByteSlot(0, byte(typType), 0)
}
func MonoTypeHolderAddTyp(builder *flatbuffers.Builder, typ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(typ), 0)
}
func MonoTypeHolderEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Var struct {
	_tab flatbuffers.Table
}

func GetRootAsVar(buf []byte, offset flatbuffers.UOffsetT) *Var {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Var{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsVar(buf []byte, offset flatbuffers.UOffsetT) *Var {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Var{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Var) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Var) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Var) I() uint64 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.GetUint64(o + rcv._tab.Pos)
	}
	return 0
}

func (rcv *Var) MutateI(n uint64) bool {
	return rcv._tab.MutateUint64Slot(4, n)
}

func VarStart(builder *flatbuffers.Builder) {
	builder.StartObject(1)
}
func VarAddI(builder *flatbuffers.Builder, i uint64) {
	builder.PrependUint64Slot(0, i, 0)
}
func VarEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Basic struct {
	_tab flatbuffers.Table
}

func GetRootAsBasic(buf []byte, offset flatbuffers.UOffsetT) *Basic {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Basic{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsBasic(buf []byte, offset flatbuffers.UOffsetT) *Basic {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Basic{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Basic) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Basic) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Basic) T() Type {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return Type(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *Basic) MutateT(n Type) bool {
	return rcv._tab.MutateByteSlot(4, byte(n))
}

func BasicStart(builder *flatbuffers.Builder) {
	builder.StartObject(1)
}
func BasicAddT(builder *flatbuffers.Builder, t Type) {
	builder.PrependByteSlot(0, byte(t), 0)
}
func BasicEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Collection struct {
	_tab flatbuffers.Table
}

func GetRootAsCollection(buf []byte, offset flatbuffers.UOffsetT) *Collection {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Collection{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsCollection(buf []byte, offset flatbuffers.UOffsetT) *Collection {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Collection{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Collection) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Collection) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Collection) Collection() CollectionType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return CollectionType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *Collection) MutateCollection(n CollectionType) bool {
	return rcv._tab.MutateByteSlot(4, byte(n))
}

func (rcv *Collection) ArgType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *Collection) MutateArgType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(6, byte(n))
}

func (rcv *Collection) Arg(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func CollectionStart(builder *flatbuffers.Builder) {
	builder.StartObject(3)
}
func CollectionAddCollection(builder *flatbuffers.Builder, collection CollectionType) {
	builder.PrependByteSlot(0, byte(collection), 0)
}
func CollectionAddArgType(builder *flatbuffers.Builder, argType MonoType) {
	builder.PrependByteSlot(1, byte(argType), 0)
}
func CollectionAddArg(builder *flatbuffers.Builder, arg flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(arg), 0)
}
func CollectionEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Stream struct {
	_tab flatbuffers.Table
}

func GetRootAsStream(buf []byte, offset flatbuffers.UOffsetT) *Stream {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Stream{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsStream(buf []byte, offset flatbuffers.UOffsetT) *Stream {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Stream{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Stream) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Stream) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Stream) TType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *Stream) MutateTType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(4, byte(n))
}

func (rcv *Stream) T(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func StreamStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func StreamAddTType(builder *flatbuffers.Builder, tType MonoType) {
	builder.PrependByteSlot(0, byte(tType), 0)
}
func StreamAddT(builder *flatbuffers.Builder, t flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(t), 0)
}
func StreamEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Record struct {
	_tab flatbuffers.Table
}

func GetRootAsRecord(buf []byte, offset flatbuffers.UOffsetT) *Record {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Record{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsRecord(buf []byte, offset flatbuffers.UOffsetT) *Record {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Record{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Record) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Record) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Record) Props(obj *Prop, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *Record) PropsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *Record) Extends(obj *Var) *Var {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(Var)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func RecordStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func RecordAddProps(builder *flatbuffers.Builder, props flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(props), 0)
}
func RecordStartPropsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func RecordAddExtends(builder *flatbuffers.Builder, extends flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(extends), 0)
}
func RecordEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Fun struct {
	_tab flatbuffers.Table
}

func GetRootAsFun(buf []byte, offset flatbuffers.UOffsetT) *Fun {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Fun{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsFun(buf []byte, offset flatbuffers.UOffsetT) *Fun {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Fun{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Fun) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Fun) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Fun) Args(obj *Argument, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *Fun) ArgsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *Fun) RetnType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *Fun) MutateRetnType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(6, byte(n))
}

func (rcv *Fun) Retn(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func FunStart(builder *flatbuffers.Builder) {
	builder.StartObject(3)
}
func FunAddArgs(builder *flatbuffers.Builder, args flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(args), 0)
}
func FunStartArgsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func FunAddRetnType(builder *flatbuffers.Builder, retnType MonoType) {
	builder.PrependByteSlot(1, byte(retnType), 0)
}
func FunAddRetn(builder *flatbuffers.Builder, retn flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(retn), 0)
}
func FunEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Dict struct {
	_tab flatbuffers.Table
}

func GetRootAsDict(buf []byte, offset flatbuffers.UOffsetT) *Dict {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Dict{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsDict(buf []byte, offset flatbuffers.UOffsetT) *Dict {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Dict{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Dict) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Dict) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Dict) KType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *Dict) MutateKType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(4, byte(n))
}

func (rcv *Dict) K(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func (rcv *Dict) VType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *Dict) MutateVType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(8, byte(n))
}

func (rcv *Dict) V(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func DictStart(builder *flatbuffers.Builder) {
	builder.StartObject(4)
}
func DictAddKType(builder *flatbuffers.Builder, kType MonoType) {
	builder.PrependByteSlot(0, byte(kType), 0)
}
func DictAddK(builder *flatbuffers.Builder, k flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(k), 0)
}
func DictAddVType(builder *flatbuffers.Builder, vType MonoType) {
	builder.PrependByteSlot(2, byte(vType), 0)
}
func DictAddV(builder *flatbuffers.Builder, v flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(v), 0)
}
func DictEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Dynamic struct {
	_tab flatbuffers.Table
}

func GetRootAsDynamic(buf []byte, offset flatbuffers.UOffsetT) *Dynamic {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Dynamic{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsDynamic(buf []byte, offset flatbuffers.UOffsetT) *Dynamic {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Dynamic{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Dynamic) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Dynamic) Table() flatbuffers.Table {
	return rcv._tab
}

func DynamicStart(builder *flatbuffers.Builder) {
	builder.StartObject(0)
}
func DynamicEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Argument struct {
	_tab flatbuffers.Table
}

func GetRootAsArgument(buf []byte, offset flatbuffers.UOffsetT) *Argument {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Argument{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsArgument(buf []byte, offset flatbuffers.UOffsetT) *Argument {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Argument{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Argument) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Argument) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Argument) Name() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *Argument) TType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *Argument) MutateTType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(6, byte(n))
}

func (rcv *Argument) T(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func (rcv *Argument) Pipe() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *Argument) MutatePipe(n bool) bool {
	return rcv._tab.MutateBoolSlot(10, n)
}

func (rcv *Argument) Optional() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *Argument) MutateOptional(n bool) bool {
	return rcv._tab.MutateBoolSlot(12, n)
}

func ArgumentStart(builder *flatbuffers.Builder) {
	builder.StartObject(5)
}
func ArgumentAddName(builder *flatbuffers.Builder, name flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(name), 0)
}
func ArgumentAddTType(builder *flatbuffers.Builder, tType MonoType) {
	builder.PrependByteSlot(1, byte(tType), 0)
}
func ArgumentAddT(builder *flatbuffers.Builder, t flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(t), 0)
}
func ArgumentAddPipe(builder *flatbuffers.Builder, pipe bool) {
	builder.PrependBoolSlot(3, pipe, false)
}
func ArgumentAddOptional(builder *flatbuffers.Builder, optional bool) {
	builder.PrependBoolSlot(4, optional, false)
}
func ArgumentEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Concrete struct {
	_tab flatbuffers.Table
}

func GetRootAsConcrete(buf []byte, offset flatbuffers.UOffsetT) *Concrete {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Concrete{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsConcrete(buf []byte, offset flatbuffers.UOffsetT) *Concrete {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Concrete{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Concrete) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Concrete) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Concrete) Id() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func ConcreteStart(builder *flatbuffers.Builder) {
	builder.StartObject(1)
}
func ConcreteAddId(builder *flatbuffers.Builder, id flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(id), 0)
}
func ConcreteEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Prop struct {
	_tab flatbuffers.Table
}

func GetRootAsProp(buf []byte, offset flatbuffers.UOffsetT) *Prop {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Prop{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsProp(buf []byte, offset flatbuffers.UOffsetT) *Prop {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Prop{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Prop) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Prop) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Prop) KType() RecordLabel {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return RecordLabel(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *Prop) MutateKType(n RecordLabel) bool {
	return rcv._tab.MutateByteSlot(4, byte(n))
}

func (rcv *Prop) K(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func (rcv *Prop) VType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *Prop) MutateVType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(8, byte(n))
}

func (rcv *Prop) V(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func PropStart(builder *flatbuffers.Builder) {
	builder.StartObject(4)
}
func PropAddKType(builder *flatbuffers.Builder, kType RecordLabel) {
	builder.PrependByteSlot(0, byte(kType), 0)
}
func PropAddK(builder *flatbuffers.Builder, k flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(k), 0)
}
func PropAddVType(builder *flatbuffers.Builder, vType MonoType) {
	builder.PrependByteSlot(2, byte(vType), 0)
}
func PropAddV(builder *flatbuffers.Builder, v flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(v), 0)
}
func PropEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type PolyType struct {
	_tab flatbuffers.Table
}

func GetRootAsPolyType(buf []byte, offset flatbuffers.UOffsetT) *PolyType {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &PolyType{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsPolyType(buf []byte, offset flatbuffers.UOffsetT) *PolyType {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &PolyType{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *PolyType) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *PolyType) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *PolyType) Vars(obj *Var, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *PolyType) VarsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *PolyType) Cons(obj *Constraint, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *PolyType) ConsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *PolyType) ExprType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *PolyType) MutateExprType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(8, byte(n))
}

func (rcv *PolyType) Expr(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func PolyTypeStart(builder *flatbuffers.Builder) {
	builder.StartObject(4)
}
func PolyTypeAddVars(builder *flatbuffers.Builder, vars flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(vars), 0)
}
func PolyTypeStartVarsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func PolyTypeAddCons(builder *flatbuffers.Builder, cons flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(cons), 0)
}
func PolyTypeStartConsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func PolyTypeAddExprType(builder *flatbuffers.Builder, exprType MonoType) {
	builder.PrependByteSlot(2, byte(exprType), 0)
}
func PolyTypeAddExpr(builder *flatbuffers.Builder, expr flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(expr), 0)
}
func PolyTypeEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Constraint struct {
	_tab flatbuffers.Table
}

func GetRootAsConstraint(buf []byte, offset flatbuffers.UOffsetT) *Constraint {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Constraint{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsConstraint(buf []byte, offset flatbuffers.UOffsetT) *Constraint {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Constraint{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Constraint) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Constraint) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Constraint) Tvar(obj *Var) *Var {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(Var)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *Constraint) Kind() Kind {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return Kind(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *Constraint) MutateKind(n Kind) bool {
	return rcv._tab.MutateByteSlot(6, byte(n))
}

func ConstraintStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func ConstraintAddTvar(builder *flatbuffers.Builder, tvar flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(tvar), 0)
}
func ConstraintAddKind(builder *flatbuffers.Builder, kind Kind) {
	builder.PrependByteSlot(1, byte(kind), 0)
}
func ConstraintEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type PackageList struct {
	_tab flatbuffers.Table
}

func GetRootAsPackageList(buf []byte, offset flatbuffers.UOffsetT) *PackageList {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &PackageList{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsPackageList(buf []byte, offset flatbuffers.UOffsetT) *PackageList {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &PackageList{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *PackageList) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *PackageList) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *PackageList) Packages(obj *Package, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *PackageList) PackagesLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func PackageListStart(builder *flatbuffers.Builder) {
	builder.StartObject(1)
}
func PackageListAddPackages(builder *flatbuffers.Builder, packages flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(packages), 0)
}
func PackageListStartPackagesVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func PackageListEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Package struct {
	_tab flatbuffers.Table
}

func GetRootAsPackage(buf []byte, offset flatbuffers.UOffsetT) *Package {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Package{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsPackage(buf []byte, offset flatbuffers.UOffsetT) *Package {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Package{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Package) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Package) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Package) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *Package) Package() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *Package) Files(obj *File, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *Package) FilesLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func PackageStart(builder *flatbuffers.Builder) {
	builder.StartObject(3)
}
func PackageAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func PackageAddPackage(builder *flatbuffers.Builder, package_ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(package_), 0)
}
func PackageAddFiles(builder *flatbuffers.Builder, files flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(files), 0)
}
func PackageStartFilesVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func PackageEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type File struct {
	_tab flatbuffers.Table
}

func GetRootAsFile(buf []byte, offset flatbuffers.UOffsetT) *File {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &File{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsFile(buf []byte, offset flatbuffers.UOffsetT) *File {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &File{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *File) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *File) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *File) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *File) Package(obj *PackageClause) *PackageClause {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(PackageClause)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *File) Imports(obj *ImportDeclaration, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *File) ImportsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *File) Body(obj *WrappedStatement, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *File) BodyLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func FileStart(builder *flatbuffers.Builder) {
	builder.StartObject(4)
}
func FileAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func FileAddPackage(builder *flatbuffers.Builder, package_ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(package_), 0)
}
func FileAddImports(builder *flatbuffers.Builder, imports flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(imports), 0)
}
func FileStartImportsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func FileAddBody(builder *flatbuffers.Builder, body flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(body), 0)
}
func FileStartBodyVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func FileEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type PackageClause struct {
	_tab flatbuffers.Table
}

func GetRootAsPackageClause(buf []byte, offset flatbuffers.UOffsetT) *PackageClause {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &PackageClause{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsPackageClause(buf []byte, offset flatbuffers.UOffsetT) *PackageClause {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &PackageClause{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *PackageClause) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *PackageClause) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *PackageClause) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *PackageClause) Name(obj *Identifier) *Identifier {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(Identifier)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func PackageClauseStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func PackageClauseAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func PackageClauseAddName(builder *flatbuffers.Builder, name flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(name), 0)
}
func PackageClauseEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type ImportDeclaration struct {
	_tab flatbuffers.Table
}

func GetRootAsImportDeclaration(buf []byte, offset flatbuffers.UOffsetT) *ImportDeclaration {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &ImportDeclaration{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsImportDeclaration(buf []byte, offset flatbuffers.UOffsetT) *ImportDeclaration {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &ImportDeclaration{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *ImportDeclaration) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *ImportDeclaration) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *ImportDeclaration) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *ImportDeclaration) Alias(obj *Identifier) *Identifier {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(Identifier)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *ImportDeclaration) Path(obj *StringLiteral) *StringLiteral {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(StringLiteral)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func ImportDeclarationStart(builder *flatbuffers.Builder) {
	builder.StartObject(3)
}
func ImportDeclarationAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func ImportDeclarationAddAlias(builder *flatbuffers.Builder, alias flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(alias), 0)
}
func ImportDeclarationAddPath(builder *flatbuffers.Builder, path flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(path), 0)
}
func ImportDeclarationEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type SourceLocation struct {
	_tab flatbuffers.Table
}

func GetRootAsSourceLocation(buf []byte, offset flatbuffers.UOffsetT) *SourceLocation {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &SourceLocation{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsSourceLocation(buf []byte, offset flatbuffers.UOffsetT) *SourceLocation {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &SourceLocation{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *SourceLocation) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *SourceLocation) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *SourceLocation) File() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *SourceLocation) Start(obj *Position) *Position {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := o + rcv._tab.Pos
		if obj == nil {
			obj = new(Position)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *SourceLocation) End(obj *Position) *Position {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := o + rcv._tab.Pos
		if obj == nil {
			obj = new(Position)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *SourceLocation) Source() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func SourceLocationStart(builder *flatbuffers.Builder) {
	builder.StartObject(4)
}
func SourceLocationAddFile(builder *flatbuffers.Builder, file flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(file), 0)
}
func SourceLocationAddStart(builder *flatbuffers.Builder, start flatbuffers.UOffsetT) {
	builder.PrependStructSlot(1, flatbuffers.UOffsetT(start), 0)
}
func SourceLocationAddEnd(builder *flatbuffers.Builder, end flatbuffers.UOffsetT) {
	builder.PrependStructSlot(2, flatbuffers.UOffsetT(end), 0)
}
func SourceLocationAddSource(builder *flatbuffers.Builder, source flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(source), 0)
}
func SourceLocationEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Position struct {
	_tab flatbuffers.Struct
}

func (rcv *Position) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Position) Table() flatbuffers.Table {
	return rcv._tab.Table
}

func (rcv *Position) Line() int32 {
	return rcv._tab.GetInt32(rcv._tab.Pos + flatbuffers.UOffsetT(0))
}
func (rcv *Position) MutateLine(n int32) bool {
	return rcv._tab.MutateInt32(rcv._tab.Pos+flatbuffers.UOffsetT(0), n)
}

func (rcv *Position) Column() int32 {
	return rcv._tab.GetInt32(rcv._tab.Pos + flatbuffers.UOffsetT(4))
}
func (rcv *Position) MutateColumn(n int32) bool {
	return rcv._tab.MutateInt32(rcv._tab.Pos+flatbuffers.UOffsetT(4), n)
}

func CreatePosition(builder *flatbuffers.Builder, line int32, column int32) flatbuffers.UOffsetT {
	builder.Prep(4, 8)
	builder.PrependInt32(column)
	builder.PrependInt32(line)
	return builder.Offset()
}

type WrappedStatement struct {
	_tab flatbuffers.Table
}

func GetRootAsWrappedStatement(buf []byte, offset flatbuffers.UOffsetT) *WrappedStatement {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &WrappedStatement{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsWrappedStatement(buf []byte, offset flatbuffers.UOffsetT) *WrappedStatement {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &WrappedStatement{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *WrappedStatement) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *WrappedStatement) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *WrappedStatement) StatementType() Statement {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return Statement(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *WrappedStatement) MutateStatementType(n Statement) bool {
	return rcv._tab.MutateByteSlot(4, byte(n))
}

func (rcv *WrappedStatement) Statement(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func WrappedStatementStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func WrappedStatementAddStatementType(builder *flatbuffers.Builder, statementType Statement) {
	builder.PrependByteSlot(0, byte(statementType), 0)
}
func WrappedStatementAddStatement(builder *flatbuffers.Builder, statement flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(statement), 0)
}
func WrappedStatementEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type OptionStatement struct {
	_tab flatbuffers.Table
}

func GetRootAsOptionStatement(buf []byte, offset flatbuffers.UOffsetT) *OptionStatement {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &OptionStatement{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsOptionStatement(buf []byte, offset flatbuffers.UOffsetT) *OptionStatement {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &OptionStatement{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *OptionStatement) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *OptionStatement) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *OptionStatement) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *OptionStatement) AssignmentType() Assignment {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return Assignment(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *OptionStatement) MutateAssignmentType(n Assignment) bool {
	return rcv._tab.MutateByteSlot(6, byte(n))
}

func (rcv *OptionStatement) Assignment(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func OptionStatementStart(builder *flatbuffers.Builder) {
	builder.StartObject(3)
}
func OptionStatementAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func OptionStatementAddAssignmentType(builder *flatbuffers.Builder, assignmentType Assignment) {
	builder.PrependByteSlot(1, byte(assignmentType), 0)
}
func OptionStatementAddAssignment(builder *flatbuffers.Builder, assignment flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(assignment), 0)
}
func OptionStatementEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type BuiltinStatement struct {
	_tab flatbuffers.Table
}

func GetRootAsBuiltinStatement(buf []byte, offset flatbuffers.UOffsetT) *BuiltinStatement {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &BuiltinStatement{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsBuiltinStatement(buf []byte, offset flatbuffers.UOffsetT) *BuiltinStatement {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &BuiltinStatement{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *BuiltinStatement) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *BuiltinStatement) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *BuiltinStatement) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *BuiltinStatement) Id(obj *Identifier) *Identifier {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(Identifier)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func BuiltinStatementStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func BuiltinStatementAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func BuiltinStatementAddId(builder *flatbuffers.Builder, id flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(id), 0)
}
func BuiltinStatementEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type TestStatement struct {
	_tab flatbuffers.Table
}

func GetRootAsTestStatement(buf []byte, offset flatbuffers.UOffsetT) *TestStatement {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &TestStatement{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsTestStatement(buf []byte, offset flatbuffers.UOffsetT) *TestStatement {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &TestStatement{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *TestStatement) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *TestStatement) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *TestStatement) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *TestStatement) Assignment(obj *NativeVariableAssignment) *NativeVariableAssignment {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(NativeVariableAssignment)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func TestStatementStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func TestStatementAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func TestStatementAddAssignment(builder *flatbuffers.Builder, assignment flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(assignment), 0)
}
func TestStatementEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type ExpressionStatement struct {
	_tab flatbuffers.Table
}

func GetRootAsExpressionStatement(buf []byte, offset flatbuffers.UOffsetT) *ExpressionStatement {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &ExpressionStatement{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsExpressionStatement(buf []byte, offset flatbuffers.UOffsetT) *ExpressionStatement {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &ExpressionStatement{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *ExpressionStatement) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *ExpressionStatement) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *ExpressionStatement) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *ExpressionStatement) ExpressionType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *ExpressionStatement) MutateExpressionType(n Expression) bool {
	return rcv._tab.MutateByteSlot(6, byte(n))
}

func (rcv *ExpressionStatement) Expression(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func ExpressionStatementStart(builder *flatbuffers.Builder) {
	builder.StartObject(3)
}
func ExpressionStatementAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func ExpressionStatementAddExpressionType(builder *flatbuffers.Builder, expressionType Expression) {
	builder.PrependByteSlot(1, byte(expressionType), 0)
}
func ExpressionStatementAddExpression(builder *flatbuffers.Builder, expression flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(expression), 0)
}
func ExpressionStatementEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type ReturnStatement struct {
	_tab flatbuffers.Table
}

func GetRootAsReturnStatement(buf []byte, offset flatbuffers.UOffsetT) *ReturnStatement {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &ReturnStatement{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsReturnStatement(buf []byte, offset flatbuffers.UOffsetT) *ReturnStatement {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &ReturnStatement{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *ReturnStatement) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *ReturnStatement) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *ReturnStatement) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *ReturnStatement) ArgumentType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *ReturnStatement) MutateArgumentType(n Expression) bool {
	return rcv._tab.MutateByteSlot(6, byte(n))
}

func (rcv *ReturnStatement) Argument(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func ReturnStatementStart(builder *flatbuffers.Builder) {
	builder.StartObject(3)
}
func ReturnStatementAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func ReturnStatementAddArgumentType(builder *flatbuffers.Builder, argumentType Expression) {
	builder.PrependByteSlot(1, byte(argumentType), 0)
}
func ReturnStatementAddArgument(builder *flatbuffers.Builder, argument flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(argument), 0)
}
func ReturnStatementEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type NativeVariableAssignment struct {
	_tab flatbuffers.Table
}

func GetRootAsNativeVariableAssignment(buf []byte, offset flatbuffers.UOffsetT) *NativeVariableAssignment {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &NativeVariableAssignment{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsNativeVariableAssignment(buf []byte, offset flatbuffers.UOffsetT) *NativeVariableAssignment {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &NativeVariableAssignment{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *NativeVariableAssignment) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *NativeVariableAssignment) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *NativeVariableAssignment) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *NativeVariableAssignment) Identifier(obj *Identifier) *Identifier {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(Identifier)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *NativeVariableAssignment) Init_type() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *NativeVariableAssignment) MutateInit_type(n Expression) bool {
	return rcv._tab.MutateByteSlot(8, byte(n))
}

func (rcv *NativeVariableAssignment) Init_(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func (rcv *NativeVariableAssignment) Typ(obj *PolyType) *PolyType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(PolyType)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func NativeVariableAssignmentStart(builder *flatbuffers.Builder) {
	builder.StartObject(5)
}
func NativeVariableAssignmentAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func NativeVariableAssignmentAddIdentifier(builder *flatbuffers.Builder, identifier flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(identifier), 0)
}
func NativeVariableAssignmentAddInit_type(builder *flatbuffers.Builder, init_type Expression) {
	builder.PrependByteSlot(2, byte(init_type), 0)
}
func NativeVariableAssignmentAddInit_(builder *flatbuffers.Builder, init_ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(init_), 0)
}
func NativeVariableAssignmentAddTyp(builder *flatbuffers.Builder, typ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(4, flatbuffers.UOffsetT(typ), 0)
}
func NativeVariableAssignmentEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type MemberAssignment struct {
	_tab flatbuffers.Table
}

func GetRootAsMemberAssignment(buf []byte, offset flatbuffers.UOffsetT) *MemberAssignment {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &MemberAssignment{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsMemberAssignment(buf []byte, offset flatbuffers.UOffsetT) *MemberAssignment {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &MemberAssignment{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *MemberAssignment) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *MemberAssignment) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *MemberAssignment) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *MemberAssignment) Member(obj *MemberExpression) *MemberExpression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(MemberExpression)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *MemberAssignment) Init_type() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *MemberAssignment) MutateInit_type(n Expression) bool {
	return rcv._tab.MutateByteSlot(8, byte(n))
}

func (rcv *MemberAssignment) Init_(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func MemberAssignmentStart(builder *flatbuffers.Builder) {
	builder.StartObject(4)
}
func MemberAssignmentAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func MemberAssignmentAddMember(builder *flatbuffers.Builder, member flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(member), 0)
}
func MemberAssignmentAddInit_type(builder *flatbuffers.Builder, init_type Expression) {
	builder.PrependByteSlot(2, byte(init_type), 0)
}
func MemberAssignmentAddInit_(builder *flatbuffers.Builder, init_ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(init_), 0)
}
func MemberAssignmentEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type WrappedExpression struct {
	_tab flatbuffers.Table
}

func GetRootAsWrappedExpression(buf []byte, offset flatbuffers.UOffsetT) *WrappedExpression {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &WrappedExpression{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsWrappedExpression(buf []byte, offset flatbuffers.UOffsetT) *WrappedExpression {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &WrappedExpression{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *WrappedExpression) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *WrappedExpression) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *WrappedExpression) ExpressionType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *WrappedExpression) MutateExpressionType(n Expression) bool {
	return rcv._tab.MutateByteSlot(4, byte(n))
}

func (rcv *WrappedExpression) Expression(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func WrappedExpressionStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func WrappedExpressionAddExpressionType(builder *flatbuffers.Builder, expressionType Expression) {
	builder.PrependByteSlot(0, byte(expressionType), 0)
}
func WrappedExpressionAddExpression(builder *flatbuffers.Builder, expression flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(expression), 0)
}
func WrappedExpressionEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type StringExpression struct {
	_tab flatbuffers.Table
}

func GetRootAsStringExpression(buf []byte, offset flatbuffers.UOffsetT) *StringExpression {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &StringExpression{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsStringExpression(buf []byte, offset flatbuffers.UOffsetT) *StringExpression {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &StringExpression{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *StringExpression) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *StringExpression) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *StringExpression) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *StringExpression) Parts(obj *StringExpressionPart, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *StringExpression) PartsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func StringExpressionStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func StringExpressionAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func StringExpressionAddParts(builder *flatbuffers.Builder, parts flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(parts), 0)
}
func StringExpressionStartPartsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func StringExpressionEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type StringExpressionPart struct {
	_tab flatbuffers.Table
}

func GetRootAsStringExpressionPart(buf []byte, offset flatbuffers.UOffsetT) *StringExpressionPart {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &StringExpressionPart{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsStringExpressionPart(buf []byte, offset flatbuffers.UOffsetT) *StringExpressionPart {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &StringExpressionPart{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *StringExpressionPart) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *StringExpressionPart) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *StringExpressionPart) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *StringExpressionPart) TextValue() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *StringExpressionPart) InterpolatedExpressionType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *StringExpressionPart) MutateInterpolatedExpressionType(n Expression) bool {
	return rcv._tab.MutateByteSlot(8, byte(n))
}

func (rcv *StringExpressionPart) InterpolatedExpression(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func StringExpressionPartStart(builder *flatbuffers.Builder) {
	builder.StartObject(4)
}
func StringExpressionPartAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func StringExpressionPartAddTextValue(builder *flatbuffers.Builder, textValue flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(textValue), 0)
}
func StringExpressionPartAddInterpolatedExpressionType(builder *flatbuffers.Builder, interpolatedExpressionType Expression) {
	builder.PrependByteSlot(2, byte(interpolatedExpressionType), 0)
}
func StringExpressionPartAddInterpolatedExpression(builder *flatbuffers.Builder, interpolatedExpression flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(interpolatedExpression), 0)
}
func StringExpressionPartEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type ArrayExpression struct {
	_tab flatbuffers.Table
}

func GetRootAsArrayExpression(buf []byte, offset flatbuffers.UOffsetT) *ArrayExpression {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &ArrayExpression{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsArrayExpression(buf []byte, offset flatbuffers.UOffsetT) *ArrayExpression {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &ArrayExpression{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *ArrayExpression) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *ArrayExpression) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *ArrayExpression) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *ArrayExpression) Elements(obj *WrappedExpression, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *ArrayExpression) ElementsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *ArrayExpression) TypType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *ArrayExpression) MutateTypType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(8, byte(n))
}

func (rcv *ArrayExpression) Typ(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func ArrayExpressionStart(builder *flatbuffers.Builder) {
	builder.StartObject(4)
}
func ArrayExpressionAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func ArrayExpressionAddElements(builder *flatbuffers.Builder, elements flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(elements), 0)
}
func ArrayExpressionStartElementsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func ArrayExpressionAddTypType(builder *flatbuffers.Builder, typType MonoType) {
	builder.PrependByteSlot(2, byte(typType), 0)
}
func ArrayExpressionAddTyp(builder *flatbuffers.Builder, typ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(typ), 0)
}
func ArrayExpressionEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type DictExpression struct {
	_tab flatbuffers.Table
}

func GetRootAsDictExpression(buf []byte, offset flatbuffers.UOffsetT) *DictExpression {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &DictExpression{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsDictExpression(buf []byte, offset flatbuffers.UOffsetT) *DictExpression {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &DictExpression{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *DictExpression) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *DictExpression) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *DictExpression) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *DictExpression) Elements(obj *DictItem, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *DictExpression) ElementsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *DictExpression) TypType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *DictExpression) MutateTypType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(8, byte(n))
}

func (rcv *DictExpression) Typ(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func DictExpressionStart(builder *flatbuffers.Builder) {
	builder.StartObject(4)
}
func DictExpressionAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func DictExpressionAddElements(builder *flatbuffers.Builder, elements flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(elements), 0)
}
func DictExpressionStartElementsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func DictExpressionAddTypType(builder *flatbuffers.Builder, typType MonoType) {
	builder.PrependByteSlot(2, byte(typType), 0)
}
func DictExpressionAddTyp(builder *flatbuffers.Builder, typ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(typ), 0)
}
func DictExpressionEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type DictItem struct {
	_tab flatbuffers.Table
}

func GetRootAsDictItem(buf []byte, offset flatbuffers.UOffsetT) *DictItem {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &DictItem{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsDictItem(buf []byte, offset flatbuffers.UOffsetT) *DictItem {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &DictItem{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *DictItem) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *DictItem) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *DictItem) KeyType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *DictItem) MutateKeyType(n Expression) bool {
	return rcv._tab.MutateByteSlot(4, byte(n))
}

func (rcv *DictItem) Key(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func (rcv *DictItem) ValType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *DictItem) MutateValType(n Expression) bool {
	return rcv._tab.MutateByteSlot(8, byte(n))
}

func (rcv *DictItem) Val(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func DictItemStart(builder *flatbuffers.Builder) {
	builder.StartObject(4)
}
func DictItemAddKeyType(builder *flatbuffers.Builder, keyType Expression) {
	builder.PrependByteSlot(0, byte(keyType), 0)
}
func DictItemAddKey(builder *flatbuffers.Builder, key flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(key), 0)
}
func DictItemAddValType(builder *flatbuffers.Builder, valType Expression) {
	builder.PrependByteSlot(2, byte(valType), 0)
}
func DictItemAddVal(builder *flatbuffers.Builder, val flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(val), 0)
}
func DictItemEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type FunctionExpression struct {
	_tab flatbuffers.Table
}

func GetRootAsFunctionExpression(buf []byte, offset flatbuffers.UOffsetT) *FunctionExpression {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &FunctionExpression{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsFunctionExpression(buf []byte, offset flatbuffers.UOffsetT) *FunctionExpression {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &FunctionExpression{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *FunctionExpression) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *FunctionExpression) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *FunctionExpression) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *FunctionExpression) Params(obj *FunctionParameter, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *FunctionExpression) ParamsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *FunctionExpression) Body(obj *Block) *Block {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(Block)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *FunctionExpression) TypType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *FunctionExpression) MutateTypType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(10, byte(n))
}

func (rcv *FunctionExpression) Typ(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func (rcv *FunctionExpression) Vectorized(obj *FunctionExpression) *FunctionExpression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(FunctionExpression)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func FunctionExpressionStart(builder *flatbuffers.Builder) {
	builder.StartObject(6)
}
func FunctionExpressionAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func FunctionExpressionAddParams(builder *flatbuffers.Builder, params flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(params), 0)
}
func FunctionExpressionStartParamsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func FunctionExpressionAddBody(builder *flatbuffers.Builder, body flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(body), 0)
}
func FunctionExpressionAddTypType(builder *flatbuffers.Builder, typType MonoType) {
	builder.PrependByteSlot(3, byte(typType), 0)
}
func FunctionExpressionAddTyp(builder *flatbuffers.Builder, typ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(4, flatbuffers.UOffsetT(typ), 0)
}
func FunctionExpressionAddVectorized(builder *flatbuffers.Builder, vectorized flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(5, flatbuffers.UOffsetT(vectorized), 0)
}
func FunctionExpressionEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type FunctionParameter struct {
	_tab flatbuffers.Table
}

func GetRootAsFunctionParameter(buf []byte, offset flatbuffers.UOffsetT) *FunctionParameter {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &FunctionParameter{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsFunctionParameter(buf []byte, offset flatbuffers.UOffsetT) *FunctionParameter {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &FunctionParameter{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *FunctionParameter) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *FunctionParameter) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *FunctionParameter) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *FunctionParameter) IsPipe() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *FunctionParameter) MutateIsPipe(n bool) bool {
	return rcv._tab.MutateBoolSlot(6, n)
}

func (rcv *FunctionParameter) Key(obj *Identifier) *Identifier {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(Identifier)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *FunctionParameter) DefaultType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *FunctionParameter) MutateDefaultType(n Expression) bool {
	return rcv._tab.MutateByteSlot(10, byte(n))
}

func (rcv *FunctionParameter) Default(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func FunctionParameterStart(builder *flatbuffers.Builder) {
	builder.StartObject(5)
}
func FunctionParameterAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func FunctionParameterAddIsPipe(builder *flatbuffers.Builder, isPipe bool) {
	builder.PrependBoolSlot(1, isPipe, false)
}
func FunctionParameterAddKey(builder *flatbuffers.Builder, key flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(key), 0)
}
func FunctionParameterAddDefaultType(builder *flatbuffers.Builder, defaultType Expression) {
	builder.PrependByteSlot(3, byte(defaultType), 0)
}
func FunctionParameterAddDefault(builder *flatbuffers.Builder, default_ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(4, flatbuffers.UOffsetT(default_), 0)
}
func FunctionParameterEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Block struct {
	_tab flatbuffers.Table
}

func GetRootAsBlock(buf []byte, offset flatbuffers.UOffsetT) *Block {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Block{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsBlock(buf []byte, offset flatbuffers.UOffsetT) *Block {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Block{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Block) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Block) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Block) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *Block) Body(obj *WrappedStatement, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *Block) BodyLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func BlockStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func BlockAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func BlockAddBody(builder *flatbuffers.Builder, body flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(body), 0)
}
func BlockStartBodyVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func BlockEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type BinaryExpression struct {
	_tab flatbuffers.Table
}

func GetRootAsBinaryExpression(buf []byte, offset flatbuffers.UOffsetT) *BinaryExpression {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &BinaryExpression{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsBinaryExpression(buf []byte, offset flatbuffers.UOffsetT) *BinaryExpression {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &BinaryExpression{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *BinaryExpression) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *BinaryExpression) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *BinaryExpression) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *BinaryExpression) Operator() Operator {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return Operator(rcv._tab.GetInt8(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *BinaryExpression) MutateOperator(n Operator) bool {
	return rcv._tab.MutateInt8Slot(6, int8(n))
}

func (rcv *BinaryExpression) LeftType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *BinaryExpression) MutateLeftType(n Expression) bool {
	return rcv._tab.MutateByteSlot(8, byte(n))
}

func (rcv *BinaryExpression) Left(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func (rcv *BinaryExpression) RightType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *BinaryExpression) MutateRightType(n Expression) bool {
	return rcv._tab.MutateByteSlot(12, byte(n))
}

func (rcv *BinaryExpression) Right(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func (rcv *BinaryExpression) TypType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(16))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *BinaryExpression) MutateTypType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(16, byte(n))
}

func (rcv *BinaryExpression) Typ(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(18))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func BinaryExpressionStart(builder *flatbuffers.Builder) {
	builder.StartObject(8)
}
func BinaryExpressionAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func BinaryExpressionAddOperator(builder *flatbuffers.Builder, operator Operator) {
	builder.PrependInt8Slot(1, int8(operator), 0)
}
func BinaryExpressionAddLeftType(builder *flatbuffers.Builder, leftType Expression) {
	builder.PrependByteSlot(2, byte(leftType), 0)
}
func BinaryExpressionAddLeft(builder *flatbuffers.Builder, left flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(left), 0)
}
func BinaryExpressionAddRightType(builder *flatbuffers.Builder, rightType Expression) {
	builder.PrependByteSlot(4, byte(rightType), 0)
}
func BinaryExpressionAddRight(builder *flatbuffers.Builder, right flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(5, flatbuffers.UOffsetT(right), 0)
}
func BinaryExpressionAddTypType(builder *flatbuffers.Builder, typType MonoType) {
	builder.PrependByteSlot(6, byte(typType), 0)
}
func BinaryExpressionAddTyp(builder *flatbuffers.Builder, typ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(7, flatbuffers.UOffsetT(typ), 0)
}
func BinaryExpressionEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type CallExpression struct {
	_tab flatbuffers.Table
}

func GetRootAsCallExpression(buf []byte, offset flatbuffers.UOffsetT) *CallExpression {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &CallExpression{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsCallExpression(buf []byte, offset flatbuffers.UOffsetT) *CallExpression {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &CallExpression{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *CallExpression) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *CallExpression) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *CallExpression) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *CallExpression) CalleeType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *CallExpression) MutateCalleeType(n Expression) bool {
	return rcv._tab.MutateByteSlot(6, byte(n))
}

func (rcv *CallExpression) Callee(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func (rcv *CallExpression) Arguments(obj *Property, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *CallExpression) ArgumentsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *CallExpression) PipeType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *CallExpression) MutatePipeType(n Expression) bool {
	return rcv._tab.MutateByteSlot(12, byte(n))
}

func (rcv *CallExpression) Pipe(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func (rcv *CallExpression) TypType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(16))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *CallExpression) MutateTypType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(16, byte(n))
}

func (rcv *CallExpression) Typ(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(18))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func CallExpressionStart(builder *flatbuffers.Builder) {
	builder.StartObject(8)
}
func CallExpressionAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func CallExpressionAddCalleeType(builder *flatbuffers.Builder, calleeType Expression) {
	builder.PrependByteSlot(1, byte(calleeType), 0)
}
func CallExpressionAddCallee(builder *flatbuffers.Builder, callee flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(callee), 0)
}
func CallExpressionAddArguments(builder *flatbuffers.Builder, arguments flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(arguments), 0)
}
func CallExpressionStartArgumentsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func CallExpressionAddPipeType(builder *flatbuffers.Builder, pipeType Expression) {
	builder.PrependByteSlot(4, byte(pipeType), 0)
}
func CallExpressionAddPipe(builder *flatbuffers.Builder, pipe flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(5, flatbuffers.UOffsetT(pipe), 0)
}
func CallExpressionAddTypType(builder *flatbuffers.Builder, typType MonoType) {
	builder.PrependByteSlot(6, byte(typType), 0)
}
func CallExpressionAddTyp(builder *flatbuffers.Builder, typ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(7, flatbuffers.UOffsetT(typ), 0)
}
func CallExpressionEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type ConditionalExpression struct {
	_tab flatbuffers.Table
}

func GetRootAsConditionalExpression(buf []byte, offset flatbuffers.UOffsetT) *ConditionalExpression {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &ConditionalExpression{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsConditionalExpression(buf []byte, offset flatbuffers.UOffsetT) *ConditionalExpression {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &ConditionalExpression{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *ConditionalExpression) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *ConditionalExpression) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *ConditionalExpression) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *ConditionalExpression) TestType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *ConditionalExpression) MutateTestType(n Expression) bool {
	return rcv._tab.MutateByteSlot(6, byte(n))
}

func (rcv *ConditionalExpression) Test(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func (rcv *ConditionalExpression) AlternateType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *ConditionalExpression) MutateAlternateType(n Expression) bool {
	return rcv._tab.MutateByteSlot(10, byte(n))
}

func (rcv *ConditionalExpression) Alternate(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func (rcv *ConditionalExpression) ConsequentType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *ConditionalExpression) MutateConsequentType(n Expression) bool {
	return rcv._tab.MutateByteSlot(14, byte(n))
}

func (rcv *ConditionalExpression) Consequent(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(16))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func ConditionalExpressionStart(builder *flatbuffers.Builder) {
	builder.StartObject(7)
}
func ConditionalExpressionAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func ConditionalExpressionAddTestType(builder *flatbuffers.Builder, testType Expression) {
	builder.PrependByteSlot(1, byte(testType), 0)
}
func ConditionalExpressionAddTest(builder *flatbuffers.Builder, test flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(test), 0)
}
func ConditionalExpressionAddAlternateType(builder *flatbuffers.Builder, alternateType Expression) {
	builder.PrependByteSlot(3, byte(alternateType), 0)
}
func ConditionalExpressionAddAlternate(builder *flatbuffers.Builder, alternate flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(4, flatbuffers.UOffsetT(alternate), 0)
}
func ConditionalExpressionAddConsequentType(builder *flatbuffers.Builder, consequentType Expression) {
	builder.PrependByteSlot(5, byte(consequentType), 0)
}
func ConditionalExpressionAddConsequent(builder *flatbuffers.Builder, consequent flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(6, flatbuffers.UOffsetT(consequent), 0)
}
func ConditionalExpressionEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type LogicalExpression struct {
	_tab flatbuffers.Table
}

func GetRootAsLogicalExpression(buf []byte, offset flatbuffers.UOffsetT) *LogicalExpression {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &LogicalExpression{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsLogicalExpression(buf []byte, offset flatbuffers.UOffsetT) *LogicalExpression {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &LogicalExpression{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *LogicalExpression) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *LogicalExpression) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *LogicalExpression) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *LogicalExpression) Operator() LogicalOperator {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return LogicalOperator(rcv._tab.GetInt8(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *LogicalExpression) MutateOperator(n LogicalOperator) bool {
	return rcv._tab.MutateInt8Slot(6, int8(n))
}

func (rcv *LogicalExpression) LeftType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *LogicalExpression) MutateLeftType(n Expression) bool {
	return rcv._tab.MutateByteSlot(8, byte(n))
}

func (rcv *LogicalExpression) Left(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func (rcv *LogicalExpression) RightType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *LogicalExpression) MutateRightType(n Expression) bool {
	return rcv._tab.MutateByteSlot(12, byte(n))
}

func (rcv *LogicalExpression) Right(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func (rcv *LogicalExpression) TypType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(16))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *LogicalExpression) MutateTypType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(16, byte(n))
}

func (rcv *LogicalExpression) Typ(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(18))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func LogicalExpressionStart(builder *flatbuffers.Builder) {
	builder.StartObject(8)
}
func LogicalExpressionAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func LogicalExpressionAddOperator(builder *flatbuffers.Builder, operator LogicalOperator) {
	builder.PrependInt8Slot(1, int8(operator), 0)
}
func LogicalExpressionAddLeftType(builder *flatbuffers.Builder, leftType Expression) {
	builder.PrependByteSlot(2, byte(leftType), 0)
}
func LogicalExpressionAddLeft(builder *flatbuffers.Builder, left flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(left), 0)
}
func LogicalExpressionAddRightType(builder *flatbuffers.Builder, rightType Expression) {
	builder.PrependByteSlot(4, byte(rightType), 0)
}
func LogicalExpressionAddRight(builder *flatbuffers.Builder, right flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(5, flatbuffers.UOffsetT(right), 0)
}
func LogicalExpressionAddTypType(builder *flatbuffers.Builder, typType MonoType) {
	builder.PrependByteSlot(6, byte(typType), 0)
}
func LogicalExpressionAddTyp(builder *flatbuffers.Builder, typ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(7, flatbuffers.UOffsetT(typ), 0)
}
func LogicalExpressionEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type MemberExpression struct {
	_tab flatbuffers.Table
}

func GetRootAsMemberExpression(buf []byte, offset flatbuffers.UOffsetT) *MemberExpression {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &MemberExpression{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsMemberExpression(buf []byte, offset flatbuffers.UOffsetT) *MemberExpression {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &MemberExpression{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *MemberExpression) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *MemberExpression) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *MemberExpression) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *MemberExpression) ObjectType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *MemberExpression) MutateObjectType(n Expression) bool {
	return rcv._tab.MutateByteSlot(6, byte(n))
}

func (rcv *MemberExpression) Object(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func (rcv *MemberExpression) Property() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *MemberExpression) TypType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *MemberExpression) MutateTypType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(12, byte(n))
}

func (rcv *MemberExpression) Typ(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func MemberExpressionStart(builder *flatbuffers.Builder) {
	builder.StartObject(6)
}
func MemberExpressionAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func MemberExpressionAddObjectType(builder *flatbuffers.Builder, objectType Expression) {
	builder.PrependByteSlot(1, byte(objectType), 0)
}
func MemberExpressionAddObject(builder *flatbuffers.Builder, object flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(object), 0)
}
func MemberExpressionAddProperty(builder *flatbuffers.Builder, property flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(property), 0)
}
func MemberExpressionAddTypType(builder *flatbuffers.Builder, typType MonoType) {
	builder.PrependByteSlot(4, byte(typType), 0)
}
func MemberExpressionAddTyp(builder *flatbuffers.Builder, typ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(5, flatbuffers.UOffsetT(typ), 0)
}
func MemberExpressionEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type IndexExpression struct {
	_tab flatbuffers.Table
}

func GetRootAsIndexExpression(buf []byte, offset flatbuffers.UOffsetT) *IndexExpression {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &IndexExpression{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsIndexExpression(buf []byte, offset flatbuffers.UOffsetT) *IndexExpression {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &IndexExpression{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *IndexExpression) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *IndexExpression) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *IndexExpression) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *IndexExpression) ArrayType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *IndexExpression) MutateArrayType(n Expression) bool {
	return rcv._tab.MutateByteSlot(6, byte(n))
}

func (rcv *IndexExpression) Array(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func (rcv *IndexExpression) IndexType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *IndexExpression) MutateIndexType(n Expression) bool {
	return rcv._tab.MutateByteSlot(10, byte(n))
}

func (rcv *IndexExpression) Index(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func (rcv *IndexExpression) TypType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *IndexExpression) MutateTypType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(14, byte(n))
}

func (rcv *IndexExpression) Typ(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(16))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func IndexExpressionStart(builder *flatbuffers.Builder) {
	builder.StartObject(7)
}
func IndexExpressionAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func IndexExpressionAddArrayType(builder *flatbuffers.Builder, arrayType Expression) {
	builder.PrependByteSlot(1, byte(arrayType), 0)
}
func IndexExpressionAddArray(builder *flatbuffers.Builder, array flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(array), 0)
}
func IndexExpressionAddIndexType(builder *flatbuffers.Builder, indexType Expression) {
	builder.PrependByteSlot(3, byte(indexType), 0)
}
func IndexExpressionAddIndex(builder *flatbuffers.Builder, index flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(4, flatbuffers.UOffsetT(index), 0)
}
func IndexExpressionAddTypType(builder *flatbuffers.Builder, typType MonoType) {
	builder.PrependByteSlot(5, byte(typType), 0)
}
func IndexExpressionAddTyp(builder *flatbuffers.Builder, typ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(6, flatbuffers.UOffsetT(typ), 0)
}
func IndexExpressionEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type ObjectExpression struct {
	_tab flatbuffers.Table
}

func GetRootAsObjectExpression(buf []byte, offset flatbuffers.UOffsetT) *ObjectExpression {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &ObjectExpression{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsObjectExpression(buf []byte, offset flatbuffers.UOffsetT) *ObjectExpression {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &ObjectExpression{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *ObjectExpression) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *ObjectExpression) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *ObjectExpression) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *ObjectExpression) With(obj *IdentifierExpression) *IdentifierExpression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(IdentifierExpression)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *ObjectExpression) Properties(obj *Property, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *ObjectExpression) PropertiesLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *ObjectExpression) TypType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *ObjectExpression) MutateTypType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(10, byte(n))
}

func (rcv *ObjectExpression) Typ(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func ObjectExpressionStart(builder *flatbuffers.Builder) {
	builder.StartObject(5)
}
func ObjectExpressionAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func ObjectExpressionAddWith(builder *flatbuffers.Builder, with flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(with), 0)
}
func ObjectExpressionAddProperties(builder *flatbuffers.Builder, properties flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(properties), 0)
}
func ObjectExpressionStartPropertiesVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func ObjectExpressionAddTypType(builder *flatbuffers.Builder, typType MonoType) {
	builder.PrependByteSlot(3, byte(typType), 0)
}
func ObjectExpressionAddTyp(builder *flatbuffers.Builder, typ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(4, flatbuffers.UOffsetT(typ), 0)
}
func ObjectExpressionEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type UnaryExpression struct {
	_tab flatbuffers.Table
}

func GetRootAsUnaryExpression(buf []byte, offset flatbuffers.UOffsetT) *UnaryExpression {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &UnaryExpression{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsUnaryExpression(buf []byte, offset flatbuffers.UOffsetT) *UnaryExpression {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &UnaryExpression{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *UnaryExpression) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *UnaryExpression) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *UnaryExpression) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *UnaryExpression) Operator() Operator {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return Operator(rcv._tab.GetInt8(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *UnaryExpression) MutateOperator(n Operator) bool {
	return rcv._tab.MutateInt8Slot(6, int8(n))
}

func (rcv *UnaryExpression) ArgumentType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *UnaryExpression) MutateArgumentType(n Expression) bool {
	return rcv._tab.MutateByteSlot(8, byte(n))
}

func (rcv *UnaryExpression) Argument(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func (rcv *UnaryExpression) TypType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *UnaryExpression) MutateTypType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(12, byte(n))
}

func (rcv *UnaryExpression) Typ(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func UnaryExpressionStart(builder *flatbuffers.Builder) {
	builder.StartObject(6)
}
func UnaryExpressionAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func UnaryExpressionAddOperator(builder *flatbuffers.Builder, operator Operator) {
	builder.PrependInt8Slot(1, int8(operator), 0)
}
func UnaryExpressionAddArgumentType(builder *flatbuffers.Builder, argumentType Expression) {
	builder.PrependByteSlot(2, byte(argumentType), 0)
}
func UnaryExpressionAddArgument(builder *flatbuffers.Builder, argument flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(argument), 0)
}
func UnaryExpressionAddTypType(builder *flatbuffers.Builder, typType MonoType) {
	builder.PrependByteSlot(4, byte(typType), 0)
}
func UnaryExpressionAddTyp(builder *flatbuffers.Builder, typ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(5, flatbuffers.UOffsetT(typ), 0)
}
func UnaryExpressionEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Property struct {
	_tab flatbuffers.Table
}

func GetRootAsProperty(buf []byte, offset flatbuffers.UOffsetT) *Property {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Property{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsProperty(buf []byte, offset flatbuffers.UOffsetT) *Property {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Property{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Property) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Property) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Property) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *Property) Key(obj *Identifier) *Identifier {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(Identifier)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *Property) ValueType() Expression {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return Expression(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *Property) MutateValueType(n Expression) bool {
	return rcv._tab.MutateByteSlot(8, byte(n))
}

func (rcv *Property) Value(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func PropertyStart(builder *flatbuffers.Builder) {
	builder.StartObject(4)
}
func PropertyAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func PropertyAddKey(builder *flatbuffers.Builder, key flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(key), 0)
}
func PropertyAddValueType(builder *flatbuffers.Builder, valueType Expression) {
	builder.PrependByteSlot(2, byte(valueType), 0)
}
func PropertyAddValue(builder *flatbuffers.Builder, value flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(value), 0)
}
func PropertyEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type IdentifierExpression struct {
	_tab flatbuffers.Table
}

func GetRootAsIdentifierExpression(buf []byte, offset flatbuffers.UOffsetT) *IdentifierExpression {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &IdentifierExpression{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsIdentifierExpression(buf []byte, offset flatbuffers.UOffsetT) *IdentifierExpression {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &IdentifierExpression{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *IdentifierExpression) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *IdentifierExpression) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *IdentifierExpression) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *IdentifierExpression) Name() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *IdentifierExpression) TypType() MonoType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return MonoType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *IdentifierExpression) MutateTypType(n MonoType) bool {
	return rcv._tab.MutateByteSlot(8, byte(n))
}

func (rcv *IdentifierExpression) Typ(obj *flatbuffers.Table) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		rcv._tab.Union(obj, o)
		return true
	}
	return false
}

func IdentifierExpressionStart(builder *flatbuffers.Builder) {
	builder.StartObject(4)
}
func IdentifierExpressionAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func IdentifierExpressionAddName(builder *flatbuffers.Builder, name flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(name), 0)
}
func IdentifierExpressionAddTypType(builder *flatbuffers.Builder, typType MonoType) {
	builder.PrependByteSlot(2, byte(typType), 0)
}
func IdentifierExpressionAddTyp(builder *flatbuffers.Builder, typ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(typ), 0)
}
func IdentifierExpressionEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Identifier struct {
	_tab flatbuffers.Table
}

func GetRootAsIdentifier(buf []byte, offset flatbuffers.UOffsetT) *Identifier {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Identifier{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsIdentifier(buf []byte, offset flatbuffers.UOffsetT) *Identifier {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Identifier{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Identifier) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Identifier) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Identifier) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *Identifier) Name() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func IdentifierStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func IdentifierAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func IdentifierAddName(builder *flatbuffers.Builder, name flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(name), 0)
}
func IdentifierEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type BooleanLiteral struct {
	_tab flatbuffers.Table
}

func GetRootAsBooleanLiteral(buf []byte, offset flatbuffers.UOffsetT) *BooleanLiteral {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &BooleanLiteral{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsBooleanLiteral(buf []byte, offset flatbuffers.UOffsetT) *BooleanLiteral {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &BooleanLiteral{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *BooleanLiteral) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *BooleanLiteral) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *BooleanLiteral) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *BooleanLiteral) Value() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *BooleanLiteral) MutateValue(n bool) bool {
	return rcv._tab.MutateBoolSlot(6, n)
}

func BooleanLiteralStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func BooleanLiteralAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func BooleanLiteralAddValue(builder *flatbuffers.Builder, value bool) {
	builder.PrependBoolSlot(1, value, false)
}
func BooleanLiteralEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type DateTimeLiteral struct {
	_tab flatbuffers.Table
}

func GetRootAsDateTimeLiteral(buf []byte, offset flatbuffers.UOffsetT) *DateTimeLiteral {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &DateTimeLiteral{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsDateTimeLiteral(buf []byte, offset flatbuffers.UOffsetT) *DateTimeLiteral {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &DateTimeLiteral{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *DateTimeLiteral) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *DateTimeLiteral) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *DateTimeLiteral) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *DateTimeLiteral) Value(obj *Time) *Time {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(Time)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func DateTimeLiteralStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func DateTimeLiteralAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func DateTimeLiteralAddValue(builder *flatbuffers.Builder, value flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(value), 0)
}
func DateTimeLiteralEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Time struct {
	_tab flatbuffers.Table
}

func GetRootAsTime(buf []byte, offset flatbuffers.UOffsetT) *Time {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Time{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsTime(buf []byte, offset flatbuffers.UOffsetT) *Time {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Time{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Time) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Time) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Time) Secs() int64 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.GetInt64(o + rcv._tab.Pos)
	}
	return 0
}

func (rcv *Time) MutateSecs(n int64) bool {
	return rcv._tab.MutateInt64Slot(4, n)
}

func (rcv *Time) Nsecs() uint32 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.GetUint32(o + rcv._tab.Pos)
	}
	return 0
}

func (rcv *Time) MutateNsecs(n uint32) bool {
	return rcv._tab.MutateUint32Slot(6, n)
}

func (rcv *Time) Offset() int32 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.GetInt32(o + rcv._tab.Pos)
	}
	return 0
}

func (rcv *Time) MutateOffset(n int32) bool {
	return rcv._tab.MutateInt32Slot(8, n)
}

func TimeStart(builder *flatbuffers.Builder) {
	builder.StartObject(3)
}
func TimeAddSecs(builder *flatbuffers.Builder, secs int64) {
	builder.PrependInt64Slot(0, secs, 0)
}
func TimeAddNsecs(builder *flatbuffers.Builder, nsecs uint32) {
	builder.PrependUint32Slot(1, nsecs, 0)
}
func TimeAddOffset(builder *flatbuffers.Builder, offset int32) {
	builder.PrependInt32Slot(2, offset, 0)
}
func TimeEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Duration struct {
	_tab flatbuffers.Table
}

func GetRootAsDuration(buf []byte, offset flatbuffers.UOffsetT) *Duration {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Duration{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsDuration(buf []byte, offset flatbuffers.UOffsetT) *Duration {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Duration{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Duration) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Duration) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Duration) Months() int64 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.GetInt64(o + rcv._tab.Pos)
	}
	return 0
}

func (rcv *Duration) MutateMonths(n int64) bool {
	return rcv._tab.MutateInt64Slot(4, n)
}

func (rcv *Duration) Nanoseconds() int64 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.GetInt64(o + rcv._tab.Pos)
	}
	return 0
}

func (rcv *Duration) MutateNanoseconds(n int64) bool {
	return rcv._tab.MutateInt64Slot(6, n)
}

func (rcv *Duration) Negative() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *Duration) MutateNegative(n bool) bool {
	return rcv._tab.MutateBoolSlot(8, n)
}

func DurationStart(builder *flatbuffers.Builder) {
	builder.StartObject(3)
}
func DurationAddMonths(builder *flatbuffers.Builder, months int64) {
	builder.PrependInt64Slot(0, months, 0)
}
func DurationAddNanoseconds(builder *flatbuffers.Builder, nanoseconds int64) {
	builder.PrependInt64Slot(1, nanoseconds, 0)
}
func DurationAddNegative(builder *flatbuffers.Builder, negative bool) {
	builder.PrependBoolSlot(2, negative, false)
}
func DurationEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type DurationLiteral struct {
	_tab flatbuffers.Table
}

func GetRootAsDurationLiteral(buf []byte, offset flatbuffers.UOffsetT) *DurationLiteral {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &DurationLiteral{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsDurationLiteral(buf []byte, offset flatbuffers.UOffsetT) *DurationLiteral {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &DurationLiteral{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *DurationLiteral) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *DurationLiteral) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *DurationLiteral) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *DurationLiteral) Value(obj *Duration, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *DurationLiteral) ValueLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func DurationLiteralStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func DurationLiteralAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func DurationLiteralAddValue(builder *flatbuffers.Builder, value flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(value), 0)
}
func DurationLiteralStartValueVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func DurationLiteralEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type IntegerLiteral struct {
	_tab flatbuffers.Table
}

func GetRootAsIntegerLiteral(buf []byte, offset flatbuffers.UOffsetT) *IntegerLiteral {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &IntegerLiteral{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsIntegerLiteral(buf []byte, offset flatbuffers.UOffsetT) *IntegerLiteral {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &IntegerLiteral{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *IntegerLiteral) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *IntegerLiteral) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *IntegerLiteral) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *IntegerLiteral) Value() int64 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.GetInt64(o + rcv._tab.Pos)
	}
	return 0
}

func (rcv *IntegerLiteral) MutateValue(n int64) bool {
	return rcv._tab.MutateInt64Slot(6, n)
}

func IntegerLiteralStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func IntegerLiteralAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func IntegerLiteralAddValue(builder *flatbuffers.Builder, value int64) {
	builder.PrependInt64Slot(1, value, 0)
}
func IntegerLiteralEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type FloatLiteral struct {
	_tab flatbuffers.Table
}

func GetRootAsFloatLiteral(buf []byte, offset flatbuffers.UOffsetT) *FloatLiteral {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &FloatLiteral{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsFloatLiteral(buf []byte, offset flatbuffers.UOffsetT) *FloatLiteral {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &FloatLiteral{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *FloatLiteral) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *FloatLiteral) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *FloatLiteral) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *FloatLiteral) Value() float64 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.GetFloat64(o + rcv._tab.Pos)
	}
	return 0.0
}

func (rcv *FloatLiteral) MutateValue(n float64) bool {
	return rcv._tab.MutateFloat64Slot(6, n)
}

func FloatLiteralStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func FloatLiteralAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func FloatLiteralAddValue(builder *flatbuffers.Builder, value float64) {
	builder.PrependFloat64Slot(1, value, 0.0)
}
func FloatLiteralEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type RegexpLiteral struct {
	_tab flatbuffers.Table
}

func GetRootAsRegexpLiteral(buf []byte, offset flatbuffers.UOffsetT) *RegexpLiteral {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &RegexpLiteral{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsRegexpLiteral(buf []byte, offset flatbuffers.UOffsetT) *RegexpLiteral {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &RegexpLiteral{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *RegexpLiteral) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *RegexpLiteral) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *RegexpLiteral) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *RegexpLiteral) Value() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func RegexpLiteralStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func RegexpLiteralAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func RegexpLiteralAddValue(builder *flatbuffers.Builder, value flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(value), 0)
}
func RegexpLiteralEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type StringLiteral struct {
	_tab flatbuffers.Table
}

func GetRootAsStringLiteral(buf []byte, offset flatbuffers.UOffsetT) *StringLiteral {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &StringLiteral{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsStringLiteral(buf []byte, offset flatbuffers.UOffsetT) *StringLiteral {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &StringLiteral{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *StringLiteral) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *StringLiteral) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *StringLiteral) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *StringLiteral) Value() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func StringLiteralStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func StringLiteralAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func StringLiteralAddValue(builder *flatbuffers.Builder, value flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(value), 0)
}
func StringLiteralEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type UnsignedIntegerLiteral struct {
	_tab flatbuffers.Table
}

func GetRootAsUnsignedIntegerLiteral(buf []byte, offset flatbuffers.UOffsetT) *UnsignedIntegerLiteral {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &UnsignedIntegerLiteral{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsUnsignedIntegerLiteral(buf []byte, offset flatbuffers.UOffsetT) *UnsignedIntegerLiteral {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &UnsignedIntegerLiteral{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *UnsignedIntegerLiteral) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *UnsignedIntegerLiteral) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *UnsignedIntegerLiteral) Loc(obj *SourceLocation) *SourceLocation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SourceLocation)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *UnsignedIntegerLiteral) Value() uint64 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.GetUint64(o + rcv._tab.Pos)
	}
	return 0
}

func (rcv *UnsignedIntegerLiteral) MutateValue(n uint64) bool {
	return rcv._tab.MutateUint64Slot(6, n)
}

func UnsignedIntegerLiteralStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func UnsignedIntegerLiteralAddLoc(builder *flatbuffers.Builder, loc flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(loc), 0)
}
func UnsignedIntegerLiteralAddValue(builder *flatbuffers.Builder, value uint64) {
	builder.PrependUint64Slot(1, value, 0)
}
func UnsignedIntegerLiteralEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Module struct {
	_tab flatbuffers.Table
}

func GetRootAsModule(buf []byte, offset flatbuffers.UOffsetT) *Module {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Module{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsModule(buf []byte, offset flatbuffers.UOffsetT) *Module {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Module{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Module) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Module) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Module) Polytype(obj *PolyType) *PolyType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(PolyType)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func (rcv *Module) Code(obj *Package) *Package {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(Package)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

func ModuleStart(builder *flatbuffers.Builder) {
	builder.StartObject(2)
}
func ModuleAddPolytype(builder *flatbuffers.Builder, polytype flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(polytype), 0)
}
func ModuleAddCode(builder *flatbuffers.Builder, code flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(code), 0)
}
func ModuleEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}
