<?php

declare(strict_types=1);

/*
 * Copyright (c) 2017-2023 François Kooman <fkooman@tuxed.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use fkooman\OAuth\Server\OAuthServer;
use fkooman\OAuth\Server\PdoStorage;
use fkooman\OAuth\Server\Signer;
use fkooman\OAuth\Server\StorageInterface;

/**
 * "Wrapper" class to include our environment specifics.
 */
class MyOAuthServer extends OAuthServer
{
    private StorageInterface $storage;

    public function __construct(string $issuerIdentity)
    {
        $this->storage = new PdoStorage(new PDO('sqlite:' . dirname(__DIR__) . '/data/db.sqlite'));
        $this->storage->init();
        parent::__construct(
            $this->storage,
            new MyClientDb(),
            new Signer('k7.sec.YHxW0AzOeqF4zWAX.bpjMLA3ymO6zL5l3l2SH1hCJNHOu2iWtltFtFVqapdcyjiZhPZXg9GivDLV7rfStn87bZboUjjITs_QUsojhjw'),
            $issuerIdentity
        );

        // expire access_token after 30 seconds
        $this->accessTokenExpiry = new DateInterval('PT30S');

        // expire refresh_token after 90 seconds
        $this->refreshTokenExpiry = new DateInterval('PT90S');
    }

    public function getStorage(): StorageInterface
    {
        return $this->storage;
    }
}
