// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/video/stitcher/v1/video_stitcher_service.proto

package stitcherpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for VideoStitcherService.createCdnKey.
type CreateCdnKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project in which the CDN key should be created, in the form
	// of `projects/{project_number}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The CDN key resource to create.
	CdnKey *CdnKey `protobuf:"bytes,2,opt,name=cdn_key,json=cdnKey,proto3" json:"cdn_key,omitempty"`
	// Required. The ID to use for the CDN key, which will become the final
	// component of the CDN key's resource name.
	//
	// This value should conform to RFC-1034, which restricts to
	// lower-case letters, numbers, and hyphen, with the first character a
	// letter, the last a letter or a number, and a 63 character maximum.
	CdnKeyId string `protobuf:"bytes,3,opt,name=cdn_key_id,json=cdnKeyId,proto3" json:"cdn_key_id,omitempty"`
}

func (x *CreateCdnKeyRequest) Reset() {
	*x = CreateCdnKeyRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateCdnKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCdnKeyRequest) ProtoMessage() {}

func (x *CreateCdnKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCdnKeyRequest.ProtoReflect.Descriptor instead.
func (*CreateCdnKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateCdnKeyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCdnKeyRequest) GetCdnKey() *CdnKey {
	if x != nil {
		return x.CdnKey
	}
	return nil
}

func (x *CreateCdnKeyRequest) GetCdnKeyId() string {
	if x != nil {
		return x.CdnKeyId
	}
	return ""
}

// Request message for VideoStitcherService.listCdnKeys.
type ListCdnKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project that contains the list of CDN keys, in the form of
	// `projects/{project_number}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Hint for how to order the results
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListCdnKeysRequest) Reset() {
	*x = ListCdnKeysRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCdnKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCdnKeysRequest) ProtoMessage() {}

func (x *ListCdnKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCdnKeysRequest.ProtoReflect.Descriptor instead.
func (*ListCdnKeysRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListCdnKeysRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCdnKeysRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCdnKeysRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCdnKeysRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListCdnKeysRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for VideoStitcher.ListCdnKeys.
type ListCdnKeysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of CDN keys.
	CdnKeys []*CdnKey `protobuf:"bytes,1,rep,name=cdn_keys,json=cdnKeys,proto3" json:"cdn_keys,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListCdnKeysResponse) Reset() {
	*x = ListCdnKeysResponse{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCdnKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCdnKeysResponse) ProtoMessage() {}

func (x *ListCdnKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCdnKeysResponse.ProtoReflect.Descriptor instead.
func (*ListCdnKeysResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListCdnKeysResponse) GetCdnKeys() []*CdnKey {
	if x != nil {
		return x.CdnKeys
	}
	return nil
}

func (x *ListCdnKeysResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListCdnKeysResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for VideoStitcherService.getCdnKey.
type GetCdnKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CDN key to be retrieved, in the form of
	// `projects/{project}/locations/{location}/cdnKeys/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCdnKeyRequest) Reset() {
	*x = GetCdnKeyRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCdnKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCdnKeyRequest) ProtoMessage() {}

func (x *GetCdnKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCdnKeyRequest.ProtoReflect.Descriptor instead.
func (*GetCdnKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{3}
}

func (x *GetCdnKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.deleteCdnKey.
type DeleteCdnKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CDN key to be deleted, in the form of
	// `projects/{project_number}/locations/{location}/cdnKeys/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteCdnKeyRequest) Reset() {
	*x = DeleteCdnKeyRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteCdnKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCdnKeyRequest) ProtoMessage() {}

func (x *DeleteCdnKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCdnKeyRequest.ProtoReflect.Descriptor instead.
func (*DeleteCdnKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteCdnKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.updateCdnKey.
type UpdateCdnKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The CDN key resource which replaces the resource on the server.
	CdnKey *CdnKey `protobuf:"bytes,1,opt,name=cdn_key,json=cdnKey,proto3" json:"cdn_key,omitempty"`
	// Required. The update mask applies to the resource.
	// For the `FieldMask` definition, see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCdnKeyRequest) Reset() {
	*x = UpdateCdnKeyRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateCdnKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCdnKeyRequest) ProtoMessage() {}

func (x *UpdateCdnKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCdnKeyRequest.ProtoReflect.Descriptor instead.
func (*UpdateCdnKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateCdnKeyRequest) GetCdnKey() *CdnKey {
	if x != nil {
		return x.CdnKey
	}
	return nil
}

func (x *UpdateCdnKeyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for VideoStitcherService.createVodSession
type CreateVodSessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location in which the VOD session should be
	// created, in the form of `projects/{project_number}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Parameters for creating a session.
	VodSession *VodSession `protobuf:"bytes,2,opt,name=vod_session,json=vodSession,proto3" json:"vod_session,omitempty"`
}

func (x *CreateVodSessionRequest) Reset() {
	*x = CreateVodSessionRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateVodSessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateVodSessionRequest) ProtoMessage() {}

func (x *CreateVodSessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateVodSessionRequest.ProtoReflect.Descriptor instead.
func (*CreateVodSessionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{6}
}

func (x *CreateVodSessionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateVodSessionRequest) GetVodSession() *VodSession {
	if x != nil {
		return x.VodSession
	}
	return nil
}

// Request message for VideoStitcherService.getVodSession
type GetVodSessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the VOD session to be retrieved, in the form of
	// `projects/{project_number}/locations/{location}/vodSessions/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVodSessionRequest) Reset() {
	*x = GetVodSessionRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetVodSessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVodSessionRequest) ProtoMessage() {}

func (x *GetVodSessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVodSessionRequest.ProtoReflect.Descriptor instead.
func (*GetVodSessionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{7}
}

func (x *GetVodSessionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.listVodStitchDetails.
type ListVodStitchDetailsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The VOD session where the stitch details belong to, in the form
	// of `projects/{project}/locations/{location}/vodSessions/{id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListVodStitchDetailsRequest) Reset() {
	*x = ListVodStitchDetailsRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListVodStitchDetailsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVodStitchDetailsRequest) ProtoMessage() {}

func (x *ListVodStitchDetailsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVodStitchDetailsRequest.ProtoReflect.Descriptor instead.
func (*ListVodStitchDetailsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{8}
}

func (x *ListVodStitchDetailsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVodStitchDetailsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVodStitchDetailsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for VideoStitcherService.listVodStitchDetails.
type ListVodStitchDetailsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A List of stitch Details.
	VodStitchDetails []*VodStitchDetail `protobuf:"bytes,1,rep,name=vod_stitch_details,json=vodStitchDetails,proto3" json:"vod_stitch_details,omitempty"`
	// The pagination token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListVodStitchDetailsResponse) Reset() {
	*x = ListVodStitchDetailsResponse{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListVodStitchDetailsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVodStitchDetailsResponse) ProtoMessage() {}

func (x *ListVodStitchDetailsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVodStitchDetailsResponse.ProtoReflect.Descriptor instead.
func (*ListVodStitchDetailsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListVodStitchDetailsResponse) GetVodStitchDetails() []*VodStitchDetail {
	if x != nil {
		return x.VodStitchDetails
	}
	return nil
}

func (x *ListVodStitchDetailsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for VideoStitcherService.getVodStitchDetail.
type GetVodStitchDetailRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the stitch detail in the specified VOD session, in
	// the form of
	// `projects/{project}/locations/{location}/vodSessions/{vod_session_id}/vodStitchDetails/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVodStitchDetailRequest) Reset() {
	*x = GetVodStitchDetailRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetVodStitchDetailRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVodStitchDetailRequest) ProtoMessage() {}

func (x *GetVodStitchDetailRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVodStitchDetailRequest.ProtoReflect.Descriptor instead.
func (*GetVodStitchDetailRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{10}
}

func (x *GetVodStitchDetailRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.listVodAdTagDetails.
type ListVodAdTagDetailsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The VOD session which the ad tag details belong to, in the form
	// of `projects/{project}/locations/{location}/vodSessions/{vod_session_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListVodAdTagDetailsRequest) Reset() {
	*x = ListVodAdTagDetailsRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListVodAdTagDetailsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVodAdTagDetailsRequest) ProtoMessage() {}

func (x *ListVodAdTagDetailsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVodAdTagDetailsRequest.ProtoReflect.Descriptor instead.
func (*ListVodAdTagDetailsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{11}
}

func (x *ListVodAdTagDetailsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVodAdTagDetailsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVodAdTagDetailsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for VideoStitcherService.listVodAdTagDetails.
type ListVodAdTagDetailsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A List of ad tag details.
	VodAdTagDetails []*VodAdTagDetail `protobuf:"bytes,1,rep,name=vod_ad_tag_details,json=vodAdTagDetails,proto3" json:"vod_ad_tag_details,omitempty"`
	// The pagination token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListVodAdTagDetailsResponse) Reset() {
	*x = ListVodAdTagDetailsResponse{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListVodAdTagDetailsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVodAdTagDetailsResponse) ProtoMessage() {}

func (x *ListVodAdTagDetailsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVodAdTagDetailsResponse.ProtoReflect.Descriptor instead.
func (*ListVodAdTagDetailsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{12}
}

func (x *ListVodAdTagDetailsResponse) GetVodAdTagDetails() []*VodAdTagDetail {
	if x != nil {
		return x.VodAdTagDetails
	}
	return nil
}

func (x *ListVodAdTagDetailsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for VideoStitcherService.getVodAdTagDetail
type GetVodAdTagDetailRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the ad tag detail for the specified VOD session, in
	// the form of
	// `projects/{project}/locations/{location}/vodSessions/{vod_session_id}/vodAdTagDetails/{vod_ad_tag_detail}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVodAdTagDetailRequest) Reset() {
	*x = GetVodAdTagDetailRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetVodAdTagDetailRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVodAdTagDetailRequest) ProtoMessage() {}

func (x *GetVodAdTagDetailRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVodAdTagDetailRequest.ProtoReflect.Descriptor instead.
func (*GetVodAdTagDetailRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{13}
}

func (x *GetVodAdTagDetailRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.listLiveAdTagDetails.
type ListLiveAdTagDetailsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource parent in the form of
	// `projects/{project}/locations/{location}/liveSessions/{live_session}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The pagination token returned from a previous List request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListLiveAdTagDetailsRequest) Reset() {
	*x = ListLiveAdTagDetailsRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListLiveAdTagDetailsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLiveAdTagDetailsRequest) ProtoMessage() {}

func (x *ListLiveAdTagDetailsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLiveAdTagDetailsRequest.ProtoReflect.Descriptor instead.
func (*ListLiveAdTagDetailsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{14}
}

func (x *ListLiveAdTagDetailsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListLiveAdTagDetailsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListLiveAdTagDetailsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for VideoStitcherService.listLiveAdTagDetails.
type ListLiveAdTagDetailsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of live session ad tag details.
	LiveAdTagDetails []*LiveAdTagDetail `protobuf:"bytes,1,rep,name=live_ad_tag_details,json=liveAdTagDetails,proto3" json:"live_ad_tag_details,omitempty"`
	// The pagination token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListLiveAdTagDetailsResponse) Reset() {
	*x = ListLiveAdTagDetailsResponse{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListLiveAdTagDetailsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLiveAdTagDetailsResponse) ProtoMessage() {}

func (x *ListLiveAdTagDetailsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLiveAdTagDetailsResponse.ProtoReflect.Descriptor instead.
func (*ListLiveAdTagDetailsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{15}
}

func (x *ListLiveAdTagDetailsResponse) GetLiveAdTagDetails() []*LiveAdTagDetail {
	if x != nil {
		return x.LiveAdTagDetails
	}
	return nil
}

func (x *ListLiveAdTagDetailsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for VideoStitcherService.getLiveAdTagDetail
type GetLiveAdTagDetailRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name in the form of
	// `projects/{project}/locations/{location}/liveSessions/{live_session}/liveAdTagDetails/{live_ad_tag_detail}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetLiveAdTagDetailRequest) Reset() {
	*x = GetLiveAdTagDetailRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLiveAdTagDetailRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLiveAdTagDetailRequest) ProtoMessage() {}

func (x *GetLiveAdTagDetailRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLiveAdTagDetailRequest.ProtoReflect.Descriptor instead.
func (*GetLiveAdTagDetailRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{16}
}

func (x *GetLiveAdTagDetailRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.createSlate.
type CreateSlateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project in which the slate should be created, in the form of
	// `projects/{project_number}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The unique identifier for the slate.
	// This value should conform to RFC-1034, which restricts to
	// lower-case letters, numbers, and hyphen, with the first character a
	// letter, the last a letter or a number, and a 63 character maximum.
	SlateId string `protobuf:"bytes,2,opt,name=slate_id,json=slateId,proto3" json:"slate_id,omitempty"`
	// Required. The slate to create.
	Slate *Slate `protobuf:"bytes,3,opt,name=slate,proto3" json:"slate,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported `(00000000-0000-0000-0000-000000000000)`.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateSlateRequest) Reset() {
	*x = CreateSlateRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSlateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSlateRequest) ProtoMessage() {}

func (x *CreateSlateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSlateRequest.ProtoReflect.Descriptor instead.
func (*CreateSlateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{17}
}

func (x *CreateSlateRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSlateRequest) GetSlateId() string {
	if x != nil {
		return x.SlateId
	}
	return ""
}

func (x *CreateSlateRequest) GetSlate() *Slate {
	if x != nil {
		return x.Slate
	}
	return nil
}

func (x *CreateSlateRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for VideoStitcherService.getSlate.
type GetSlateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the slate to be retrieved, of the slate, in the form
	// of `projects/{project_number}/locations/{location}/slates/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSlateRequest) Reset() {
	*x = GetSlateRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSlateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSlateRequest) ProtoMessage() {}

func (x *GetSlateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSlateRequest.ProtoReflect.Descriptor instead.
func (*GetSlateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{18}
}

func (x *GetSlateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.listSlates.
type ListSlatesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project to list slates, in the form of
	// `projects/{project_number}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Hint for how to order the results
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListSlatesRequest) Reset() {
	*x = ListSlatesRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSlatesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSlatesRequest) ProtoMessage() {}

func (x *ListSlatesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSlatesRequest.ProtoReflect.Descriptor instead.
func (*ListSlatesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{19}
}

func (x *ListSlatesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSlatesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSlatesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSlatesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListSlatesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for VideoStitcherService.listSlates.
type ListSlatesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of slates
	Slates []*Slate `protobuf:"bytes,1,rep,name=slates,proto3" json:"slates,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListSlatesResponse) Reset() {
	*x = ListSlatesResponse{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSlatesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSlatesResponse) ProtoMessage() {}

func (x *ListSlatesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSlatesResponse.ProtoReflect.Descriptor instead.
func (*ListSlatesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{20}
}

func (x *ListSlatesResponse) GetSlates() []*Slate {
	if x != nil {
		return x.Slates
	}
	return nil
}

func (x *ListSlatesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListSlatesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for VideoStitcherService.updateSlate.
type UpdateSlateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource with updated fields.
	Slate *Slate `protobuf:"bytes,1,opt,name=slate,proto3" json:"slate,omitempty"`
	// Required. The update mask which specifies fields which should be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSlateRequest) Reset() {
	*x = UpdateSlateRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSlateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSlateRequest) ProtoMessage() {}

func (x *UpdateSlateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSlateRequest.ProtoReflect.Descriptor instead.
func (*UpdateSlateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{21}
}

func (x *UpdateSlateRequest) GetSlate() *Slate {
	if x != nil {
		return x.Slate
	}
	return nil
}

func (x *UpdateSlateRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for VideoStitcherService.deleteSlate.
type DeleteSlateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the slate to be deleted, in the form of
	// `projects/{project_number}/locations/{location}/slates/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSlateRequest) Reset() {
	*x = DeleteSlateRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSlateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSlateRequest) ProtoMessage() {}

func (x *DeleteSlateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSlateRequest.ProtoReflect.Descriptor instead.
func (*DeleteSlateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{22}
}

func (x *DeleteSlateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.createLiveSession.
type CreateLiveSessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location in which the live session should be
	// created, in the form of `projects/{project_number}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Parameters for creating a live session.
	LiveSession *LiveSession `protobuf:"bytes,2,opt,name=live_session,json=liveSession,proto3" json:"live_session,omitempty"`
}

func (x *CreateLiveSessionRequest) Reset() {
	*x = CreateLiveSessionRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateLiveSessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateLiveSessionRequest) ProtoMessage() {}

func (x *CreateLiveSessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateLiveSessionRequest.ProtoReflect.Descriptor instead.
func (*CreateLiveSessionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{23}
}

func (x *CreateLiveSessionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateLiveSessionRequest) GetLiveSession() *LiveSession {
	if x != nil {
		return x.LiveSession
	}
	return nil
}

// Request message for VideoStitcherService.getSession.
type GetLiveSessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the live session, in the form of
	// `projects/{project_number}/locations/{location}/liveSessions/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetLiveSessionRequest) Reset() {
	*x = GetLiveSessionRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLiveSessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLiveSessionRequest) ProtoMessage() {}

func (x *GetLiveSessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLiveSessionRequest.ProtoReflect.Descriptor instead.
func (*GetLiveSessionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{24}
}

func (x *GetLiveSessionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.createLiveConfig
type CreateLiveConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project in which the live config should be created, in
	// the form of `projects/{project_number}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The unique identifier ID to use for the live config.
	LiveConfigId string `protobuf:"bytes,2,opt,name=live_config_id,json=liveConfigId,proto3" json:"live_config_id,omitempty"`
	// Required. The live config resource to create.
	LiveConfig *LiveConfig `protobuf:"bytes,3,opt,name=live_config,json=liveConfig,proto3" json:"live_config,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported `(00000000-0000-0000-0000-000000000000)`.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateLiveConfigRequest) Reset() {
	*x = CreateLiveConfigRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateLiveConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateLiveConfigRequest) ProtoMessage() {}

func (x *CreateLiveConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateLiveConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateLiveConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{25}
}

func (x *CreateLiveConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateLiveConfigRequest) GetLiveConfigId() string {
	if x != nil {
		return x.LiveConfigId
	}
	return ""
}

func (x *CreateLiveConfigRequest) GetLiveConfig() *LiveConfig {
	if x != nil {
		return x.LiveConfig
	}
	return nil
}

func (x *CreateLiveConfigRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for VideoStitcherService.listLiveConfig.
type ListLiveConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project that contains the list of live configs, in the
	// form of `projects/{project_number}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter to apply to list results (see
	// [Filtering](https://google.aip.dev/160)).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specifies the ordering of results following
	// [Cloud API
	// syntax](https://cloud.google.com/apis/design/design_patterns#sorting_order).
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListLiveConfigsRequest) Reset() {
	*x = ListLiveConfigsRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListLiveConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLiveConfigsRequest) ProtoMessage() {}

func (x *ListLiveConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLiveConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListLiveConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{26}
}

func (x *ListLiveConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListLiveConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListLiveConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListLiveConfigsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListLiveConfigsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for VideoStitcher.ListLiveConfig.
type ListLiveConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of live configs.
	LiveConfigs []*LiveConfig `protobuf:"bytes,1,rep,name=live_configs,json=liveConfigs,proto3" json:"live_configs,omitempty"`
	// The pagination token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListLiveConfigsResponse) Reset() {
	*x = ListLiveConfigsResponse{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListLiveConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLiveConfigsResponse) ProtoMessage() {}

func (x *ListLiveConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLiveConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListLiveConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{27}
}

func (x *ListLiveConfigsResponse) GetLiveConfigs() []*LiveConfig {
	if x != nil {
		return x.LiveConfigs
	}
	return nil
}

func (x *ListLiveConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListLiveConfigsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for VideoStitcherService.getLiveConfig.
type GetLiveConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the live config to be retrieved, in the form
	// of
	// `projects/{project_number}/locations/{location}/liveConfigs/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetLiveConfigRequest) Reset() {
	*x = GetLiveConfigRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLiveConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLiveConfigRequest) ProtoMessage() {}

func (x *GetLiveConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLiveConfigRequest.ProtoReflect.Descriptor instead.
func (*GetLiveConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{28}
}

func (x *GetLiveConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.deleteLiveConfig.
type DeleteLiveConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the live config to be deleted, in the form of
	// `projects/{project_number}/locations/{location}/liveConfigs/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteLiveConfigRequest) Reset() {
	*x = DeleteLiveConfigRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteLiveConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteLiveConfigRequest) ProtoMessage() {}

func (x *DeleteLiveConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteLiveConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteLiveConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{29}
}

func (x *DeleteLiveConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.updateLiveConfig.
type UpdateLiveConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The LiveConfig resource which replaces the resource on the
	// server.
	LiveConfig *LiveConfig `protobuf:"bytes,1,opt,name=live_config,json=liveConfig,proto3" json:"live_config,omitempty"`
	// Required. The update mask applies to the resource.
	// For the `FieldMask` definition, see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateLiveConfigRequest) Reset() {
	*x = UpdateLiveConfigRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateLiveConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateLiveConfigRequest) ProtoMessage() {}

func (x *UpdateLiveConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateLiveConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateLiveConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{30}
}

func (x *UpdateLiveConfigRequest) GetLiveConfig() *LiveConfig {
	if x != nil {
		return x.LiveConfig
	}
	return nil
}

func (x *UpdateLiveConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for VideoStitcherService.createVodConfig
type CreateVodConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project in which the VOD config should be created, in
	// the form of `projects/{project_number}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The unique identifier ID to use for the VOD config.
	VodConfigId string `protobuf:"bytes,2,opt,name=vod_config_id,json=vodConfigId,proto3" json:"vod_config_id,omitempty"`
	// Required. The VOD config resource to create.
	VodConfig *VodConfig `protobuf:"bytes,3,opt,name=vod_config,json=vodConfig,proto3" json:"vod_config,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported `(00000000-0000-0000-0000-000000000000)`.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateVodConfigRequest) Reset() {
	*x = CreateVodConfigRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateVodConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateVodConfigRequest) ProtoMessage() {}

func (x *CreateVodConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateVodConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateVodConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{31}
}

func (x *CreateVodConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateVodConfigRequest) GetVodConfigId() string {
	if x != nil {
		return x.VodConfigId
	}
	return ""
}

func (x *CreateVodConfigRequest) GetVodConfig() *VodConfig {
	if x != nil {
		return x.VodConfig
	}
	return nil
}

func (x *CreateVodConfigRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for VideoStitcherService.listVodConfig.
type ListVodConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project that contains the list of VOD configs, in the
	// form of `projects/{project_number}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous List request,
	// if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter to apply to list results (see
	// [Filtering](https://google.aip.dev/160)).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specifies the ordering of results following
	// [Cloud API
	// syntax](https://cloud.google.com/apis/design/design_patterns#sorting_order).
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListVodConfigsRequest) Reset() {
	*x = ListVodConfigsRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListVodConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVodConfigsRequest) ProtoMessage() {}

func (x *ListVodConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVodConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListVodConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{32}
}

func (x *ListVodConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVodConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVodConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListVodConfigsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListVodConfigsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for VideoStitcher.ListVodConfig.
type ListVodConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of VOD configs.
	VodConfigs []*VodConfig `protobuf:"bytes,1,rep,name=vod_configs,json=vodConfigs,proto3" json:"vod_configs,omitempty"`
	// The pagination token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListVodConfigsResponse) Reset() {
	*x = ListVodConfigsResponse{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListVodConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVodConfigsResponse) ProtoMessage() {}

func (x *ListVodConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVodConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListVodConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{33}
}

func (x *ListVodConfigsResponse) GetVodConfigs() []*VodConfig {
	if x != nil {
		return x.VodConfigs
	}
	return nil
}

func (x *ListVodConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListVodConfigsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for VideoStitcherService.getVodConfig.
type GetVodConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the VOD config to be retrieved, in the form
	// of `projects/{project_number}/locations/{location}/vodConfigs/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVodConfigRequest) Reset() {
	*x = GetVodConfigRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetVodConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVodConfigRequest) ProtoMessage() {}

func (x *GetVodConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVodConfigRequest.ProtoReflect.Descriptor instead.
func (*GetVodConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{34}
}

func (x *GetVodConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.deleteVodConfig.
type DeleteVodConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the VOD config to be deleted, in the form of
	// `projects/{project_number}/locations/{location}/vodConfigs/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteVodConfigRequest) Reset() {
	*x = DeleteVodConfigRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteVodConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteVodConfigRequest) ProtoMessage() {}

func (x *DeleteVodConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteVodConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteVodConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{35}
}

func (x *DeleteVodConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.updateVodConfig.
type UpdateVodConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The VOD config resource which replaces the resource on the
	// server.
	VodConfig *VodConfig `protobuf:"bytes,1,opt,name=vod_config,json=vodConfig,proto3" json:"vod_config,omitempty"`
	// Required. The update mask applies to the resource.
	// For the `FieldMask` definition, see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateVodConfigRequest) Reset() {
	*x = UpdateVodConfigRequest{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateVodConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateVodConfigRequest) ProtoMessage() {}

func (x *UpdateVodConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateVodConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateVodConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{36}
}

func (x *UpdateVodConfigRequest) GetVodConfig() *VodConfig {
	if x != nil {
		return x.VodConfig
	}
	return nil
}

func (x *UpdateVodConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{37}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

var File_google_cloud_video_stitcher_v1_video_stitcher_service_proto protoreflect.FileDescriptor

var file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x2f, 0x61, 0x64, 0x5f, 0x74, 0x61, 0x67, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x64, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x2f, 0x76, 0x31, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x6f, 0x64, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xc3, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12,
	0x23, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x64,
	0x6e, 0x4b, 0x65, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x44, 0x0a, 0x07,
	0x63, 0x64, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x64, 0x6e, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x63, 0x64, 0x6e, 0x4b,
	0x65, 0x79, 0x12, 0x21, 0x0a, 0x0a, 0x63, 0x64, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x64, 0x6e,
	0x4b, 0x65, 0x79, 0x49, 0x64, 0x22, 0xc8, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x64,
	0x6e, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x22, 0xa2, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x08, 0x63, 0x64, 0x6e, 0x5f,
	0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x64, 0x6e, 0x4b,
	0x65, 0x79, 0x52, 0x07, 0x63, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x53, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x43, 0x64, 0x6e, 0x4b,
	0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a,
	0x23, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x64,
	0x6e, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x56, 0x0a, 0x13, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74,
	0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x9d, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x64, 0x6e,
	0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x07, 0x63, 0x64,
	0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x64, 0x6e,
	0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x63, 0x64, 0x6e, 0x4b, 0x65, 0x79,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0xb4, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x6f, 0x64,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0b, 0x76, 0x6f, 0x64, 0x5f, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f,
	0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x76,
	0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x5b, 0x0a, 0x14, 0x47, 0x65, 0x74,
	0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74,
	0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa7, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x56,
	0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x64,
	0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xa5, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x64, 0x53, 0x74, 0x69, 0x74,
	0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x5d, 0x0a, 0x12, 0x76, 0x6f, 0x64, 0x5f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x10,
	0x76, 0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x65, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x56,
	0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x64, 0x53, 0x74, 0x69,
	0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xa5, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x64, 0x41, 0x64, 0x54, 0x61, 0x67,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x64, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa2, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74,
	0x56, 0x6f, 0x64, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x12, 0x76, 0x6f, 0x64, 0x5f, 0x61,
	0x64, 0x5f, 0x74, 0x61, 0x67, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x52, 0x0f, 0x76, 0x6f, 0x64, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x63, 0x0a, 0x18,
	0x47, 0x65, 0x74, 0x56, 0x6f, 0x64, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x64,
	0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xa7, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x64,
	0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54, 0x61,
	0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa6, 0x01, 0x0a, 0x1c,
	0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5e, 0x0a, 0x13,
	0x6c, 0x69, 0x76, 0x65, 0x5f, 0x61, 0x64, 0x5f, 0x74, 0x61, 0x67, 0x5f, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73,
	0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x76, 0x65, 0x41,
	0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x10, 0x6c, 0x69, 0x76, 0x65,
	0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x65, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x41,
	0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74,
	0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd9, 0x01, 0x0a, 0x12,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x73,
	0x6c, 0x61, 0x74, 0x65, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x05, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x51, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x53, 0x6c,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24,
	0x0a, 0x22, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x6c, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc6, 0x01, 0x0a, 0x11, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73,
	0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x42, 0x79, 0x22, 0x9d, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3d, 0x0a, 0x06, 0x73, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6c, 0x61, 0x74,
	0x65, 0x52, 0x06, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x22, 0x98, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6c,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x05, 0x73, 0x6c,
	0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73,
	0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6c, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x54,
	0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb9, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c,
	0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x0c, 0x6c,
	0x69, 0x76, 0x65, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x22, 0x5d, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a,
	0x28, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69,
	0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xfe, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x29, 0x12, 0x27, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x0e, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x6c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12,
	0x50, 0x0a, 0x0b, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0xda, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x29, 0x12, 0x27, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xb2, 0x01,
	0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0c, 0x6c, 0x69, 0x76,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x6c, 0x69, 0x76,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x22, 0x5b, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29,
	0x0a, 0x27, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x5e, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29,
	0x0a, 0x27, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xad, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0b, 0x6c,
	0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x6c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0xfc, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x28, 0x12, 0x26, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0d, 0x76, 0x6f, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b,
	0x76, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x4d, 0x0a, 0x0a, 0x76,
	0x6f, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x76, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xe2,
	0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28,
	0x12, 0x26, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56,
	0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x42, 0x79, 0x22, 0xae, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x64, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a,
	0x0a, 0x0b, 0x76, 0x6f, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0a,
	0x76, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x22, 0x59, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x64, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x28, 0x0a, 0x26, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x5c, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a,
	0x26, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f,
	0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa9, 0x01,
	0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x0a, 0x76, 0x6f, 0x64, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f,
	0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x76, 0x6f,
	0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xb3, 0x01, 0x0a, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x76,
	0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x32,
	0xd7, 0x36, 0x0a, 0x14, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x99, 0x02, 0x0a, 0x0c, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73,
	0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb4, 0x01,
	0xca, 0x41, 0x59, 0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x30, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73,
	0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x19, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x64, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x2c, 0x63, 0x64,
	0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x3a, 0x07,
	0x63, 0x64, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x64, 0x6e,
	0x4b, 0x65, 0x79, 0x73, 0x12, 0xb4, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x64, 0x6e,
	0x4b, 0x65, 0x79, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74,
	0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x64,
	0x6e, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3c, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x12, 0xa1, 0x01, 0x0a, 0x09,
	0x47, 0x65, 0x74, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73,
	0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x64,
	0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x64, 0x6e,
	0x4b, 0x65, 0x79, 0x22, 0x3a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xeb, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79,
	0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x86, 0x01, 0xca, 0x41, 0x49, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x12, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d,
	0x2a, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9b, 0x02,
	0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xb6, 0x01, 0xca, 0x41, 0x59, 0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x12,
	0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x13, 0x63, 0x64, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x07, 0x63,
	0x64, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x32, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x64, 0x6e,
	0x5f, 0x6b, 0x65, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd2, 0x01, 0x0a, 0x10,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73,
	0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x59, 0xda, 0x41, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x76, 0x6f, 0x64, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3e, 0x3a, 0x0b, 0x76, 0x6f, 0x64, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0xb1, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74,
	0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe6, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x64,
	0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x56, 0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x56, 0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f,
	0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x6f, 0x64,
	0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0xd3, 0x01,
	0x0a, 0x12, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x64, 0x53, 0x74, 0x69, 0x74,
	0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x22, 0x51, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12,
	0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x76, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x76, 0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xe2, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x64, 0x41,
	0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x56, 0x6f, 0x64, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x64,
	0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x52, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x43, 0x12, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x64, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x6f, 0x64, 0x41, 0x64, 0x54, 0x61,
	0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0xcf, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74,
	0x56, 0x6f, 0x64, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x56, 0x6f, 0x64, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74,
	0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x41, 0x64, 0x54,
	0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x22, 0x50, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x12, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x64, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x64, 0x41, 0x64, 0x54, 0x61, 0x67,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe7, 0x01, 0x0a, 0x14, 0x4c,
	0x69, 0x73, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54,
	0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x54,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x12,
	0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0xd4, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x76, 0x65,
	0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x4c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54, 0x61,
	0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x22, 0x52, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x12, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54, 0x61,
	0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x8f, 0x02, 0x0a, 0x0b,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xac,
	0x01, 0xca, 0x41, 0x58, 0x0a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x30, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73,
	0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x15, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2c, 0x73, 0x6c, 0x61, 0x74,
	0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x3a, 0x05, 0x73, 0x6c, 0x61, 0x74,
	0x65, 0x22, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x12, 0xb0, 0x01,
	0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x12, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x3b, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x12, 0x9d, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x39, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0x91, 0x02, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6c, 0x61, 0x74, 0x65,
	0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xae, 0x01, 0xca, 0x41, 0x58, 0x0a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74,
	0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x12,
	0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x11, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x05, 0x73, 0x6c, 0x61,
	0x74, 0x65, 0x32, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe8, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53,
	0x6c, 0x61, 0x74, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6c, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x85, 0x01, 0xca, 0x41, 0x49, 0x0a, 0x15, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x12, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2c, 0x2a, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xd8, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x76,
	0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x5c, 0xda, 0x41,
	0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x3a, 0x0c, 0x6c, 0x69, 0x76, 0x65,
	0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c, 0x69,
	0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xb5, 0x01, 0x0a, 0x0e, 0x47,
	0x65, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32,
	0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xb5, 0x02, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x76,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c,
	0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xc8, 0x01, 0xca, 0x41, 0x5d, 0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6c, 0x69, 0x76, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x0b, 0x6c, 0x69,
	0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c,
	0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xc4, 0x01, 0x0a, 0x0f, 0x4c,
	0x69, 0x73, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x76, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x40, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31,
	0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x12, 0xb1, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73,
	0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x76, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf7, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x8a, 0x01, 0xca, 0x41, 0x49, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x2a, 0x2f,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xb7, 0x02, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x76, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xca, 0x01, 0xca,
	0x41, 0x5d, 0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x30, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x17, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a,
	0x0b, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x3b, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xae, 0x02, 0x0a, 0x0f, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc3, 0x01, 0xca, 0x41, 0x5c, 0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73,
	0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x76, 0x6f, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x76, 0x6f, 0x64, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x0a,
	0x76, 0x6f, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x2e, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x76, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xc0, 0x01, 0x0a, 0x0e, 0x4c,
	0x69, 0x73, 0x74, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3f, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x76, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xad, 0x01,
	0x0a, 0x0c, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x3d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x76, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf4, 0x01,
	0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x01, 0xca, 0x41, 0x49, 0x0a, 0x15,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x30, 0x2a, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb0, 0x02, 0x0a, 0x0f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56,
	0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74,
	0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xc5, 0x01, 0xca, 0x41, 0x5c, 0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x16, 0x76, 0x6f, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47,
	0x3a, 0x0a, 0x76, 0x6f, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x39, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x76, 0x6f, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x64, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x50, 0xca, 0x41, 0x1c, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x81, 0x01, 0x0a, 0x22, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x42, 0x19, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x70, 0x62, 0x3b, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x70, 0x62, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescOnce sync.Once
	file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescData = file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDesc
)

func file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP() []byte {
	file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescData)
	})
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescData
}

var file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes = make([]protoimpl.MessageInfo, 38)
var file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_goTypes = []any{
	(*CreateCdnKeyRequest)(nil),          // 0: google.cloud.video.stitcher.v1.CreateCdnKeyRequest
	(*ListCdnKeysRequest)(nil),           // 1: google.cloud.video.stitcher.v1.ListCdnKeysRequest
	(*ListCdnKeysResponse)(nil),          // 2: google.cloud.video.stitcher.v1.ListCdnKeysResponse
	(*GetCdnKeyRequest)(nil),             // 3: google.cloud.video.stitcher.v1.GetCdnKeyRequest
	(*DeleteCdnKeyRequest)(nil),          // 4: google.cloud.video.stitcher.v1.DeleteCdnKeyRequest
	(*UpdateCdnKeyRequest)(nil),          // 5: google.cloud.video.stitcher.v1.UpdateCdnKeyRequest
	(*CreateVodSessionRequest)(nil),      // 6: google.cloud.video.stitcher.v1.CreateVodSessionRequest
	(*GetVodSessionRequest)(nil),         // 7: google.cloud.video.stitcher.v1.GetVodSessionRequest
	(*ListVodStitchDetailsRequest)(nil),  // 8: google.cloud.video.stitcher.v1.ListVodStitchDetailsRequest
	(*ListVodStitchDetailsResponse)(nil), // 9: google.cloud.video.stitcher.v1.ListVodStitchDetailsResponse
	(*GetVodStitchDetailRequest)(nil),    // 10: google.cloud.video.stitcher.v1.GetVodStitchDetailRequest
	(*ListVodAdTagDetailsRequest)(nil),   // 11: google.cloud.video.stitcher.v1.ListVodAdTagDetailsRequest
	(*ListVodAdTagDetailsResponse)(nil),  // 12: google.cloud.video.stitcher.v1.ListVodAdTagDetailsResponse
	(*GetVodAdTagDetailRequest)(nil),     // 13: google.cloud.video.stitcher.v1.GetVodAdTagDetailRequest
	(*ListLiveAdTagDetailsRequest)(nil),  // 14: google.cloud.video.stitcher.v1.ListLiveAdTagDetailsRequest
	(*ListLiveAdTagDetailsResponse)(nil), // 15: google.cloud.video.stitcher.v1.ListLiveAdTagDetailsResponse
	(*GetLiveAdTagDetailRequest)(nil),    // 16: google.cloud.video.stitcher.v1.GetLiveAdTagDetailRequest
	(*CreateSlateRequest)(nil),           // 17: google.cloud.video.stitcher.v1.CreateSlateRequest
	(*GetSlateRequest)(nil),              // 18: google.cloud.video.stitcher.v1.GetSlateRequest
	(*ListSlatesRequest)(nil),            // 19: google.cloud.video.stitcher.v1.ListSlatesRequest
	(*ListSlatesResponse)(nil),           // 20: google.cloud.video.stitcher.v1.ListSlatesResponse
	(*UpdateSlateRequest)(nil),           // 21: google.cloud.video.stitcher.v1.UpdateSlateRequest
	(*DeleteSlateRequest)(nil),           // 22: google.cloud.video.stitcher.v1.DeleteSlateRequest
	(*CreateLiveSessionRequest)(nil),     // 23: google.cloud.video.stitcher.v1.CreateLiveSessionRequest
	(*GetLiveSessionRequest)(nil),        // 24: google.cloud.video.stitcher.v1.GetLiveSessionRequest
	(*CreateLiveConfigRequest)(nil),      // 25: google.cloud.video.stitcher.v1.CreateLiveConfigRequest
	(*ListLiveConfigsRequest)(nil),       // 26: google.cloud.video.stitcher.v1.ListLiveConfigsRequest
	(*ListLiveConfigsResponse)(nil),      // 27: google.cloud.video.stitcher.v1.ListLiveConfigsResponse
	(*GetLiveConfigRequest)(nil),         // 28: google.cloud.video.stitcher.v1.GetLiveConfigRequest
	(*DeleteLiveConfigRequest)(nil),      // 29: google.cloud.video.stitcher.v1.DeleteLiveConfigRequest
	(*UpdateLiveConfigRequest)(nil),      // 30: google.cloud.video.stitcher.v1.UpdateLiveConfigRequest
	(*CreateVodConfigRequest)(nil),       // 31: google.cloud.video.stitcher.v1.CreateVodConfigRequest
	(*ListVodConfigsRequest)(nil),        // 32: google.cloud.video.stitcher.v1.ListVodConfigsRequest
	(*ListVodConfigsResponse)(nil),       // 33: google.cloud.video.stitcher.v1.ListVodConfigsResponse
	(*GetVodConfigRequest)(nil),          // 34: google.cloud.video.stitcher.v1.GetVodConfigRequest
	(*DeleteVodConfigRequest)(nil),       // 35: google.cloud.video.stitcher.v1.DeleteVodConfigRequest
	(*UpdateVodConfigRequest)(nil),       // 36: google.cloud.video.stitcher.v1.UpdateVodConfigRequest
	(*OperationMetadata)(nil),            // 37: google.cloud.video.stitcher.v1.OperationMetadata
	(*CdnKey)(nil),                       // 38: google.cloud.video.stitcher.v1.CdnKey
	(*fieldmaskpb.FieldMask)(nil),        // 39: google.protobuf.FieldMask
	(*VodSession)(nil),                   // 40: google.cloud.video.stitcher.v1.VodSession
	(*VodStitchDetail)(nil),              // 41: google.cloud.video.stitcher.v1.VodStitchDetail
	(*VodAdTagDetail)(nil),               // 42: google.cloud.video.stitcher.v1.VodAdTagDetail
	(*LiveAdTagDetail)(nil),              // 43: google.cloud.video.stitcher.v1.LiveAdTagDetail
	(*Slate)(nil),                        // 44: google.cloud.video.stitcher.v1.Slate
	(*LiveSession)(nil),                  // 45: google.cloud.video.stitcher.v1.LiveSession
	(*LiveConfig)(nil),                   // 46: google.cloud.video.stitcher.v1.LiveConfig
	(*VodConfig)(nil),                    // 47: google.cloud.video.stitcher.v1.VodConfig
	(*timestamppb.Timestamp)(nil),        // 48: google.protobuf.Timestamp
	(*longrunningpb.Operation)(nil),      // 49: google.longrunning.Operation
}
var file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_depIdxs = []int32{
	38, // 0: google.cloud.video.stitcher.v1.CreateCdnKeyRequest.cdn_key:type_name -> google.cloud.video.stitcher.v1.CdnKey
	38, // 1: google.cloud.video.stitcher.v1.ListCdnKeysResponse.cdn_keys:type_name -> google.cloud.video.stitcher.v1.CdnKey
	38, // 2: google.cloud.video.stitcher.v1.UpdateCdnKeyRequest.cdn_key:type_name -> google.cloud.video.stitcher.v1.CdnKey
	39, // 3: google.cloud.video.stitcher.v1.UpdateCdnKeyRequest.update_mask:type_name -> google.protobuf.FieldMask
	40, // 4: google.cloud.video.stitcher.v1.CreateVodSessionRequest.vod_session:type_name -> google.cloud.video.stitcher.v1.VodSession
	41, // 5: google.cloud.video.stitcher.v1.ListVodStitchDetailsResponse.vod_stitch_details:type_name -> google.cloud.video.stitcher.v1.VodStitchDetail
	42, // 6: google.cloud.video.stitcher.v1.ListVodAdTagDetailsResponse.vod_ad_tag_details:type_name -> google.cloud.video.stitcher.v1.VodAdTagDetail
	43, // 7: google.cloud.video.stitcher.v1.ListLiveAdTagDetailsResponse.live_ad_tag_details:type_name -> google.cloud.video.stitcher.v1.LiveAdTagDetail
	44, // 8: google.cloud.video.stitcher.v1.CreateSlateRequest.slate:type_name -> google.cloud.video.stitcher.v1.Slate
	44, // 9: google.cloud.video.stitcher.v1.ListSlatesResponse.slates:type_name -> google.cloud.video.stitcher.v1.Slate
	44, // 10: google.cloud.video.stitcher.v1.UpdateSlateRequest.slate:type_name -> google.cloud.video.stitcher.v1.Slate
	39, // 11: google.cloud.video.stitcher.v1.UpdateSlateRequest.update_mask:type_name -> google.protobuf.FieldMask
	45, // 12: google.cloud.video.stitcher.v1.CreateLiveSessionRequest.live_session:type_name -> google.cloud.video.stitcher.v1.LiveSession
	46, // 13: google.cloud.video.stitcher.v1.CreateLiveConfigRequest.live_config:type_name -> google.cloud.video.stitcher.v1.LiveConfig
	46, // 14: google.cloud.video.stitcher.v1.ListLiveConfigsResponse.live_configs:type_name -> google.cloud.video.stitcher.v1.LiveConfig
	46, // 15: google.cloud.video.stitcher.v1.UpdateLiveConfigRequest.live_config:type_name -> google.cloud.video.stitcher.v1.LiveConfig
	39, // 16: google.cloud.video.stitcher.v1.UpdateLiveConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	47, // 17: google.cloud.video.stitcher.v1.CreateVodConfigRequest.vod_config:type_name -> google.cloud.video.stitcher.v1.VodConfig
	47, // 18: google.cloud.video.stitcher.v1.ListVodConfigsResponse.vod_configs:type_name -> google.cloud.video.stitcher.v1.VodConfig
	47, // 19: google.cloud.video.stitcher.v1.UpdateVodConfigRequest.vod_config:type_name -> google.cloud.video.stitcher.v1.VodConfig
	39, // 20: google.cloud.video.stitcher.v1.UpdateVodConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	48, // 21: google.cloud.video.stitcher.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	48, // 22: google.cloud.video.stitcher.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	0,  // 23: google.cloud.video.stitcher.v1.VideoStitcherService.CreateCdnKey:input_type -> google.cloud.video.stitcher.v1.CreateCdnKeyRequest
	1,  // 24: google.cloud.video.stitcher.v1.VideoStitcherService.ListCdnKeys:input_type -> google.cloud.video.stitcher.v1.ListCdnKeysRequest
	3,  // 25: google.cloud.video.stitcher.v1.VideoStitcherService.GetCdnKey:input_type -> google.cloud.video.stitcher.v1.GetCdnKeyRequest
	4,  // 26: google.cloud.video.stitcher.v1.VideoStitcherService.DeleteCdnKey:input_type -> google.cloud.video.stitcher.v1.DeleteCdnKeyRequest
	5,  // 27: google.cloud.video.stitcher.v1.VideoStitcherService.UpdateCdnKey:input_type -> google.cloud.video.stitcher.v1.UpdateCdnKeyRequest
	6,  // 28: google.cloud.video.stitcher.v1.VideoStitcherService.CreateVodSession:input_type -> google.cloud.video.stitcher.v1.CreateVodSessionRequest
	7,  // 29: google.cloud.video.stitcher.v1.VideoStitcherService.GetVodSession:input_type -> google.cloud.video.stitcher.v1.GetVodSessionRequest
	8,  // 30: google.cloud.video.stitcher.v1.VideoStitcherService.ListVodStitchDetails:input_type -> google.cloud.video.stitcher.v1.ListVodStitchDetailsRequest
	10, // 31: google.cloud.video.stitcher.v1.VideoStitcherService.GetVodStitchDetail:input_type -> google.cloud.video.stitcher.v1.GetVodStitchDetailRequest
	11, // 32: google.cloud.video.stitcher.v1.VideoStitcherService.ListVodAdTagDetails:input_type -> google.cloud.video.stitcher.v1.ListVodAdTagDetailsRequest
	13, // 33: google.cloud.video.stitcher.v1.VideoStitcherService.GetVodAdTagDetail:input_type -> google.cloud.video.stitcher.v1.GetVodAdTagDetailRequest
	14, // 34: google.cloud.video.stitcher.v1.VideoStitcherService.ListLiveAdTagDetails:input_type -> google.cloud.video.stitcher.v1.ListLiveAdTagDetailsRequest
	16, // 35: google.cloud.video.stitcher.v1.VideoStitcherService.GetLiveAdTagDetail:input_type -> google.cloud.video.stitcher.v1.GetLiveAdTagDetailRequest
	17, // 36: google.cloud.video.stitcher.v1.VideoStitcherService.CreateSlate:input_type -> google.cloud.video.stitcher.v1.CreateSlateRequest
	19, // 37: google.cloud.video.stitcher.v1.VideoStitcherService.ListSlates:input_type -> google.cloud.video.stitcher.v1.ListSlatesRequest
	18, // 38: google.cloud.video.stitcher.v1.VideoStitcherService.GetSlate:input_type -> google.cloud.video.stitcher.v1.GetSlateRequest
	21, // 39: google.cloud.video.stitcher.v1.VideoStitcherService.UpdateSlate:input_type -> google.cloud.video.stitcher.v1.UpdateSlateRequest
	22, // 40: google.cloud.video.stitcher.v1.VideoStitcherService.DeleteSlate:input_type -> google.cloud.video.stitcher.v1.DeleteSlateRequest
	23, // 41: google.cloud.video.stitcher.v1.VideoStitcherService.CreateLiveSession:input_type -> google.cloud.video.stitcher.v1.CreateLiveSessionRequest
	24, // 42: google.cloud.video.stitcher.v1.VideoStitcherService.GetLiveSession:input_type -> google.cloud.video.stitcher.v1.GetLiveSessionRequest
	25, // 43: google.cloud.video.stitcher.v1.VideoStitcherService.CreateLiveConfig:input_type -> google.cloud.video.stitcher.v1.CreateLiveConfigRequest
	26, // 44: google.cloud.video.stitcher.v1.VideoStitcherService.ListLiveConfigs:input_type -> google.cloud.video.stitcher.v1.ListLiveConfigsRequest
	28, // 45: google.cloud.video.stitcher.v1.VideoStitcherService.GetLiveConfig:input_type -> google.cloud.video.stitcher.v1.GetLiveConfigRequest
	29, // 46: google.cloud.video.stitcher.v1.VideoStitcherService.DeleteLiveConfig:input_type -> google.cloud.video.stitcher.v1.DeleteLiveConfigRequest
	30, // 47: google.cloud.video.stitcher.v1.VideoStitcherService.UpdateLiveConfig:input_type -> google.cloud.video.stitcher.v1.UpdateLiveConfigRequest
	31, // 48: google.cloud.video.stitcher.v1.VideoStitcherService.CreateVodConfig:input_type -> google.cloud.video.stitcher.v1.CreateVodConfigRequest
	32, // 49: google.cloud.video.stitcher.v1.VideoStitcherService.ListVodConfigs:input_type -> google.cloud.video.stitcher.v1.ListVodConfigsRequest
	34, // 50: google.cloud.video.stitcher.v1.VideoStitcherService.GetVodConfig:input_type -> google.cloud.video.stitcher.v1.GetVodConfigRequest
	35, // 51: google.cloud.video.stitcher.v1.VideoStitcherService.DeleteVodConfig:input_type -> google.cloud.video.stitcher.v1.DeleteVodConfigRequest
	36, // 52: google.cloud.video.stitcher.v1.VideoStitcherService.UpdateVodConfig:input_type -> google.cloud.video.stitcher.v1.UpdateVodConfigRequest
	49, // 53: google.cloud.video.stitcher.v1.VideoStitcherService.CreateCdnKey:output_type -> google.longrunning.Operation
	2,  // 54: google.cloud.video.stitcher.v1.VideoStitcherService.ListCdnKeys:output_type -> google.cloud.video.stitcher.v1.ListCdnKeysResponse
	38, // 55: google.cloud.video.stitcher.v1.VideoStitcherService.GetCdnKey:output_type -> google.cloud.video.stitcher.v1.CdnKey
	49, // 56: google.cloud.video.stitcher.v1.VideoStitcherService.DeleteCdnKey:output_type -> google.longrunning.Operation
	49, // 57: google.cloud.video.stitcher.v1.VideoStitcherService.UpdateCdnKey:output_type -> google.longrunning.Operation
	40, // 58: google.cloud.video.stitcher.v1.VideoStitcherService.CreateVodSession:output_type -> google.cloud.video.stitcher.v1.VodSession
	40, // 59: google.cloud.video.stitcher.v1.VideoStitcherService.GetVodSession:output_type -> google.cloud.video.stitcher.v1.VodSession
	9,  // 60: google.cloud.video.stitcher.v1.VideoStitcherService.ListVodStitchDetails:output_type -> google.cloud.video.stitcher.v1.ListVodStitchDetailsResponse
	41, // 61: google.cloud.video.stitcher.v1.VideoStitcherService.GetVodStitchDetail:output_type -> google.cloud.video.stitcher.v1.VodStitchDetail
	12, // 62: google.cloud.video.stitcher.v1.VideoStitcherService.ListVodAdTagDetails:output_type -> google.cloud.video.stitcher.v1.ListVodAdTagDetailsResponse
	42, // 63: google.cloud.video.stitcher.v1.VideoStitcherService.GetVodAdTagDetail:output_type -> google.cloud.video.stitcher.v1.VodAdTagDetail
	15, // 64: google.cloud.video.stitcher.v1.VideoStitcherService.ListLiveAdTagDetails:output_type -> google.cloud.video.stitcher.v1.ListLiveAdTagDetailsResponse
	43, // 65: google.cloud.video.stitcher.v1.VideoStitcherService.GetLiveAdTagDetail:output_type -> google.cloud.video.stitcher.v1.LiveAdTagDetail
	49, // 66: google.cloud.video.stitcher.v1.VideoStitcherService.CreateSlate:output_type -> google.longrunning.Operation
	20, // 67: google.cloud.video.stitcher.v1.VideoStitcherService.ListSlates:output_type -> google.cloud.video.stitcher.v1.ListSlatesResponse
	44, // 68: google.cloud.video.stitcher.v1.VideoStitcherService.GetSlate:output_type -> google.cloud.video.stitcher.v1.Slate
	49, // 69: google.cloud.video.stitcher.v1.VideoStitcherService.UpdateSlate:output_type -> google.longrunning.Operation
	49, // 70: google.cloud.video.stitcher.v1.VideoStitcherService.DeleteSlate:output_type -> google.longrunning.Operation
	45, // 71: google.cloud.video.stitcher.v1.VideoStitcherService.CreateLiveSession:output_type -> google.cloud.video.stitcher.v1.LiveSession
	45, // 72: google.cloud.video.stitcher.v1.VideoStitcherService.GetLiveSession:output_type -> google.cloud.video.stitcher.v1.LiveSession
	49, // 73: google.cloud.video.stitcher.v1.VideoStitcherService.CreateLiveConfig:output_type -> google.longrunning.Operation
	27, // 74: google.cloud.video.stitcher.v1.VideoStitcherService.ListLiveConfigs:output_type -> google.cloud.video.stitcher.v1.ListLiveConfigsResponse
	46, // 75: google.cloud.video.stitcher.v1.VideoStitcherService.GetLiveConfig:output_type -> google.cloud.video.stitcher.v1.LiveConfig
	49, // 76: google.cloud.video.stitcher.v1.VideoStitcherService.DeleteLiveConfig:output_type -> google.longrunning.Operation
	49, // 77: google.cloud.video.stitcher.v1.VideoStitcherService.UpdateLiveConfig:output_type -> google.longrunning.Operation
	49, // 78: google.cloud.video.stitcher.v1.VideoStitcherService.CreateVodConfig:output_type -> google.longrunning.Operation
	33, // 79: google.cloud.video.stitcher.v1.VideoStitcherService.ListVodConfigs:output_type -> google.cloud.video.stitcher.v1.ListVodConfigsResponse
	47, // 80: google.cloud.video.stitcher.v1.VideoStitcherService.GetVodConfig:output_type -> google.cloud.video.stitcher.v1.VodConfig
	49, // 81: google.cloud.video.stitcher.v1.VideoStitcherService.DeleteVodConfig:output_type -> google.longrunning.Operation
	49, // 82: google.cloud.video.stitcher.v1.VideoStitcherService.UpdateVodConfig:output_type -> google.longrunning.Operation
	53, // [53:83] is the sub-list for method output_type
	23, // [23:53] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_init() }
func file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_init() {
	if File_google_cloud_video_stitcher_v1_video_stitcher_service_proto != nil {
		return
	}
	file_google_cloud_video_stitcher_v1_ad_tag_details_proto_init()
	file_google_cloud_video_stitcher_v1_cdn_keys_proto_init()
	file_google_cloud_video_stitcher_v1_live_configs_proto_init()
	file_google_cloud_video_stitcher_v1_sessions_proto_init()
	file_google_cloud_video_stitcher_v1_slates_proto_init()
	file_google_cloud_video_stitcher_v1_stitch_details_proto_init()
	file_google_cloud_video_stitcher_v1_vod_configs_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   38,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes,
	}.Build()
	File_google_cloud_video_stitcher_v1_video_stitcher_service_proto = out.File
	file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDesc = nil
	file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_goTypes = nil
	file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// VideoStitcherServiceClient is the client API for VideoStitcherService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VideoStitcherServiceClient interface {
	// Creates a new CDN key.
	CreateCdnKey(ctx context.Context, in *CreateCdnKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all CDN keys in the specified project and location.
	ListCdnKeys(ctx context.Context, in *ListCdnKeysRequest, opts ...grpc.CallOption) (*ListCdnKeysResponse, error)
	// Returns the specified CDN key.
	GetCdnKey(ctx context.Context, in *GetCdnKeyRequest, opts ...grpc.CallOption) (*CdnKey, error)
	// Deletes the specified CDN key.
	DeleteCdnKey(ctx context.Context, in *DeleteCdnKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the specified CDN key. Only update fields specified
	// in the call method body.
	UpdateCdnKey(ctx context.Context, in *UpdateCdnKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a client side playback VOD session and returns the full
	// tracking and playback metadata of the session.
	CreateVodSession(ctx context.Context, in *CreateVodSessionRequest, opts ...grpc.CallOption) (*VodSession, error)
	// Returns the full tracking, playback metadata, and relevant ad-ops
	// logs for the specified VOD session.
	GetVodSession(ctx context.Context, in *GetVodSessionRequest, opts ...grpc.CallOption) (*VodSession, error)
	// Returns a list of detailed stitching information of the specified VOD
	// session.
	ListVodStitchDetails(ctx context.Context, in *ListVodStitchDetailsRequest, opts ...grpc.CallOption) (*ListVodStitchDetailsResponse, error)
	// Returns the specified stitching information for the specified VOD session.
	GetVodStitchDetail(ctx context.Context, in *GetVodStitchDetailRequest, opts ...grpc.CallOption) (*VodStitchDetail, error)
	// Return the list of ad tag details for the specified VOD session.
	ListVodAdTagDetails(ctx context.Context, in *ListVodAdTagDetailsRequest, opts ...grpc.CallOption) (*ListVodAdTagDetailsResponse, error)
	// Returns the specified ad tag detail for the specified VOD session.
	GetVodAdTagDetail(ctx context.Context, in *GetVodAdTagDetailRequest, opts ...grpc.CallOption) (*VodAdTagDetail, error)
	// Return the list of ad tag details for the specified live session.
	ListLiveAdTagDetails(ctx context.Context, in *ListLiveAdTagDetailsRequest, opts ...grpc.CallOption) (*ListLiveAdTagDetailsResponse, error)
	// Returns the specified ad tag detail for the specified live session.
	GetLiveAdTagDetail(ctx context.Context, in *GetLiveAdTagDetailRequest, opts ...grpc.CallOption) (*LiveAdTagDetail, error)
	// Creates a slate.
	CreateSlate(ctx context.Context, in *CreateSlateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all slates in the specified project and location.
	ListSlates(ctx context.Context, in *ListSlatesRequest, opts ...grpc.CallOption) (*ListSlatesResponse, error)
	// Returns the specified slate.
	GetSlate(ctx context.Context, in *GetSlateRequest, opts ...grpc.CallOption) (*Slate, error)
	// Updates the specified slate.
	UpdateSlate(ctx context.Context, in *UpdateSlateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the specified slate.
	DeleteSlate(ctx context.Context, in *DeleteSlateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new live session.
	CreateLiveSession(ctx context.Context, in *CreateLiveSessionRequest, opts ...grpc.CallOption) (*LiveSession, error)
	// Returns the details for the specified live session.
	GetLiveSession(ctx context.Context, in *GetLiveSessionRequest, opts ...grpc.CallOption) (*LiveSession, error)
	// Registers the live config with the provided unique ID in
	// the specified region.
	CreateLiveConfig(ctx context.Context, in *CreateLiveConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all live configs managed by the Video Stitcher that
	// belong to the specified project and region.
	ListLiveConfigs(ctx context.Context, in *ListLiveConfigsRequest, opts ...grpc.CallOption) (*ListLiveConfigsResponse, error)
	// Returns the specified live config managed by the Video
	// Stitcher service.
	GetLiveConfig(ctx context.Context, in *GetLiveConfigRequest, opts ...grpc.CallOption) (*LiveConfig, error)
	// Deletes the specified live config.
	DeleteLiveConfig(ctx context.Context, in *DeleteLiveConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the specified LiveConfig. Only update fields specified
	// in the call method body.
	UpdateLiveConfig(ctx context.Context, in *UpdateLiveConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Registers the VOD config with the provided unique ID in
	// the specified region.
	CreateVodConfig(ctx context.Context, in *CreateVodConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all VOD configs managed by the Video Stitcher API that
	// belong to the specified project and region.
	ListVodConfigs(ctx context.Context, in *ListVodConfigsRequest, opts ...grpc.CallOption) (*ListVodConfigsResponse, error)
	// Returns the specified VOD config managed by the Video
	// Stitcher API service.
	GetVodConfig(ctx context.Context, in *GetVodConfigRequest, opts ...grpc.CallOption) (*VodConfig, error)
	// Deletes the specified VOD config.
	DeleteVodConfig(ctx context.Context, in *DeleteVodConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the specified VOD config. Only update fields specified
	// in the call method body.
	UpdateVodConfig(ctx context.Context, in *UpdateVodConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type videoStitcherServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVideoStitcherServiceClient(cc grpc.ClientConnInterface) VideoStitcherServiceClient {
	return &videoStitcherServiceClient{cc}
}

func (c *videoStitcherServiceClient) CreateCdnKey(ctx context.Context, in *CreateCdnKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateCdnKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListCdnKeys(ctx context.Context, in *ListCdnKeysRequest, opts ...grpc.CallOption) (*ListCdnKeysResponse, error) {
	out := new(ListCdnKeysResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/ListCdnKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetCdnKey(ctx context.Context, in *GetCdnKeyRequest, opts ...grpc.CallOption) (*CdnKey, error) {
	out := new(CdnKey)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/GetCdnKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) DeleteCdnKey(ctx context.Context, in *DeleteCdnKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/DeleteCdnKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) UpdateCdnKey(ctx context.Context, in *UpdateCdnKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/UpdateCdnKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) CreateVodSession(ctx context.Context, in *CreateVodSessionRequest, opts ...grpc.CallOption) (*VodSession, error) {
	out := new(VodSession)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateVodSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetVodSession(ctx context.Context, in *GetVodSessionRequest, opts ...grpc.CallOption) (*VodSession, error) {
	out := new(VodSession)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/GetVodSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListVodStitchDetails(ctx context.Context, in *ListVodStitchDetailsRequest, opts ...grpc.CallOption) (*ListVodStitchDetailsResponse, error) {
	out := new(ListVodStitchDetailsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/ListVodStitchDetails", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetVodStitchDetail(ctx context.Context, in *GetVodStitchDetailRequest, opts ...grpc.CallOption) (*VodStitchDetail, error) {
	out := new(VodStitchDetail)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/GetVodStitchDetail", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListVodAdTagDetails(ctx context.Context, in *ListVodAdTagDetailsRequest, opts ...grpc.CallOption) (*ListVodAdTagDetailsResponse, error) {
	out := new(ListVodAdTagDetailsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/ListVodAdTagDetails", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetVodAdTagDetail(ctx context.Context, in *GetVodAdTagDetailRequest, opts ...grpc.CallOption) (*VodAdTagDetail, error) {
	out := new(VodAdTagDetail)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/GetVodAdTagDetail", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListLiveAdTagDetails(ctx context.Context, in *ListLiveAdTagDetailsRequest, opts ...grpc.CallOption) (*ListLiveAdTagDetailsResponse, error) {
	out := new(ListLiveAdTagDetailsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/ListLiveAdTagDetails", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetLiveAdTagDetail(ctx context.Context, in *GetLiveAdTagDetailRequest, opts ...grpc.CallOption) (*LiveAdTagDetail, error) {
	out := new(LiveAdTagDetail)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/GetLiveAdTagDetail", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) CreateSlate(ctx context.Context, in *CreateSlateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateSlate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListSlates(ctx context.Context, in *ListSlatesRequest, opts ...grpc.CallOption) (*ListSlatesResponse, error) {
	out := new(ListSlatesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/ListSlates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetSlate(ctx context.Context, in *GetSlateRequest, opts ...grpc.CallOption) (*Slate, error) {
	out := new(Slate)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/GetSlate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) UpdateSlate(ctx context.Context, in *UpdateSlateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/UpdateSlate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) DeleteSlate(ctx context.Context, in *DeleteSlateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/DeleteSlate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) CreateLiveSession(ctx context.Context, in *CreateLiveSessionRequest, opts ...grpc.CallOption) (*LiveSession, error) {
	out := new(LiveSession)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateLiveSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetLiveSession(ctx context.Context, in *GetLiveSessionRequest, opts ...grpc.CallOption) (*LiveSession, error) {
	out := new(LiveSession)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/GetLiveSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) CreateLiveConfig(ctx context.Context, in *CreateLiveConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateLiveConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListLiveConfigs(ctx context.Context, in *ListLiveConfigsRequest, opts ...grpc.CallOption) (*ListLiveConfigsResponse, error) {
	out := new(ListLiveConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/ListLiveConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetLiveConfig(ctx context.Context, in *GetLiveConfigRequest, opts ...grpc.CallOption) (*LiveConfig, error) {
	out := new(LiveConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/GetLiveConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) DeleteLiveConfig(ctx context.Context, in *DeleteLiveConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/DeleteLiveConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) UpdateLiveConfig(ctx context.Context, in *UpdateLiveConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/UpdateLiveConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) CreateVodConfig(ctx context.Context, in *CreateVodConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateVodConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListVodConfigs(ctx context.Context, in *ListVodConfigsRequest, opts ...grpc.CallOption) (*ListVodConfigsResponse, error) {
	out := new(ListVodConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/ListVodConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetVodConfig(ctx context.Context, in *GetVodConfigRequest, opts ...grpc.CallOption) (*VodConfig, error) {
	out := new(VodConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/GetVodConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) DeleteVodConfig(ctx context.Context, in *DeleteVodConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/DeleteVodConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) UpdateVodConfig(ctx context.Context, in *UpdateVodConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/UpdateVodConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoStitcherServiceServer is the server API for VideoStitcherService service.
type VideoStitcherServiceServer interface {
	// Creates a new CDN key.
	CreateCdnKey(context.Context, *CreateCdnKeyRequest) (*longrunningpb.Operation, error)
	// Lists all CDN keys in the specified project and location.
	ListCdnKeys(context.Context, *ListCdnKeysRequest) (*ListCdnKeysResponse, error)
	// Returns the specified CDN key.
	GetCdnKey(context.Context, *GetCdnKeyRequest) (*CdnKey, error)
	// Deletes the specified CDN key.
	DeleteCdnKey(context.Context, *DeleteCdnKeyRequest) (*longrunningpb.Operation, error)
	// Updates the specified CDN key. Only update fields specified
	// in the call method body.
	UpdateCdnKey(context.Context, *UpdateCdnKeyRequest) (*longrunningpb.Operation, error)
	// Creates a client side playback VOD session and returns the full
	// tracking and playback metadata of the session.
	CreateVodSession(context.Context, *CreateVodSessionRequest) (*VodSession, error)
	// Returns the full tracking, playback metadata, and relevant ad-ops
	// logs for the specified VOD session.
	GetVodSession(context.Context, *GetVodSessionRequest) (*VodSession, error)
	// Returns a list of detailed stitching information of the specified VOD
	// session.
	ListVodStitchDetails(context.Context, *ListVodStitchDetailsRequest) (*ListVodStitchDetailsResponse, error)
	// Returns the specified stitching information for the specified VOD session.
	GetVodStitchDetail(context.Context, *GetVodStitchDetailRequest) (*VodStitchDetail, error)
	// Return the list of ad tag details for the specified VOD session.
	ListVodAdTagDetails(context.Context, *ListVodAdTagDetailsRequest) (*ListVodAdTagDetailsResponse, error)
	// Returns the specified ad tag detail for the specified VOD session.
	GetVodAdTagDetail(context.Context, *GetVodAdTagDetailRequest) (*VodAdTagDetail, error)
	// Return the list of ad tag details for the specified live session.
	ListLiveAdTagDetails(context.Context, *ListLiveAdTagDetailsRequest) (*ListLiveAdTagDetailsResponse, error)
	// Returns the specified ad tag detail for the specified live session.
	GetLiveAdTagDetail(context.Context, *GetLiveAdTagDetailRequest) (*LiveAdTagDetail, error)
	// Creates a slate.
	CreateSlate(context.Context, *CreateSlateRequest) (*longrunningpb.Operation, error)
	// Lists all slates in the specified project and location.
	ListSlates(context.Context, *ListSlatesRequest) (*ListSlatesResponse, error)
	// Returns the specified slate.
	GetSlate(context.Context, *GetSlateRequest) (*Slate, error)
	// Updates the specified slate.
	UpdateSlate(context.Context, *UpdateSlateRequest) (*longrunningpb.Operation, error)
	// Deletes the specified slate.
	DeleteSlate(context.Context, *DeleteSlateRequest) (*longrunningpb.Operation, error)
	// Creates a new live session.
	CreateLiveSession(context.Context, *CreateLiveSessionRequest) (*LiveSession, error)
	// Returns the details for the specified live session.
	GetLiveSession(context.Context, *GetLiveSessionRequest) (*LiveSession, error)
	// Registers the live config with the provided unique ID in
	// the specified region.
	CreateLiveConfig(context.Context, *CreateLiveConfigRequest) (*longrunningpb.Operation, error)
	// Lists all live configs managed by the Video Stitcher that
	// belong to the specified project and region.
	ListLiveConfigs(context.Context, *ListLiveConfigsRequest) (*ListLiveConfigsResponse, error)
	// Returns the specified live config managed by the Video
	// Stitcher service.
	GetLiveConfig(context.Context, *GetLiveConfigRequest) (*LiveConfig, error)
	// Deletes the specified live config.
	DeleteLiveConfig(context.Context, *DeleteLiveConfigRequest) (*longrunningpb.Operation, error)
	// Updates the specified LiveConfig. Only update fields specified
	// in the call method body.
	UpdateLiveConfig(context.Context, *UpdateLiveConfigRequest) (*longrunningpb.Operation, error)
	// Registers the VOD config with the provided unique ID in
	// the specified region.
	CreateVodConfig(context.Context, *CreateVodConfigRequest) (*longrunningpb.Operation, error)
	// Lists all VOD configs managed by the Video Stitcher API that
	// belong to the specified project and region.
	ListVodConfigs(context.Context, *ListVodConfigsRequest) (*ListVodConfigsResponse, error)
	// Returns the specified VOD config managed by the Video
	// Stitcher API service.
	GetVodConfig(context.Context, *GetVodConfigRequest) (*VodConfig, error)
	// Deletes the specified VOD config.
	DeleteVodConfig(context.Context, *DeleteVodConfigRequest) (*longrunningpb.Operation, error)
	// Updates the specified VOD config. Only update fields specified
	// in the call method body.
	UpdateVodConfig(context.Context, *UpdateVodConfigRequest) (*longrunningpb.Operation, error)
}

// UnimplementedVideoStitcherServiceServer can be embedded to have forward compatible implementations.
type UnimplementedVideoStitcherServiceServer struct {
}

func (*UnimplementedVideoStitcherServiceServer) CreateCdnKey(context.Context, *CreateCdnKeyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCdnKey not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) ListCdnKeys(context.Context, *ListCdnKeysRequest) (*ListCdnKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCdnKeys not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) GetCdnKey(context.Context, *GetCdnKeyRequest) (*CdnKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCdnKey not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) DeleteCdnKey(context.Context, *DeleteCdnKeyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCdnKey not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) UpdateCdnKey(context.Context, *UpdateCdnKeyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCdnKey not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) CreateVodSession(context.Context, *CreateVodSessionRequest) (*VodSession, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVodSession not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) GetVodSession(context.Context, *GetVodSessionRequest) (*VodSession, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVodSession not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) ListVodStitchDetails(context.Context, *ListVodStitchDetailsRequest) (*ListVodStitchDetailsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVodStitchDetails not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) GetVodStitchDetail(context.Context, *GetVodStitchDetailRequest) (*VodStitchDetail, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVodStitchDetail not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) ListVodAdTagDetails(context.Context, *ListVodAdTagDetailsRequest) (*ListVodAdTagDetailsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVodAdTagDetails not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) GetVodAdTagDetail(context.Context, *GetVodAdTagDetailRequest) (*VodAdTagDetail, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVodAdTagDetail not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) ListLiveAdTagDetails(context.Context, *ListLiveAdTagDetailsRequest) (*ListLiveAdTagDetailsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLiveAdTagDetails not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) GetLiveAdTagDetail(context.Context, *GetLiveAdTagDetailRequest) (*LiveAdTagDetail, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLiveAdTagDetail not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) CreateSlate(context.Context, *CreateSlateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSlate not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) ListSlates(context.Context, *ListSlatesRequest) (*ListSlatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSlates not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) GetSlate(context.Context, *GetSlateRequest) (*Slate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSlate not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) UpdateSlate(context.Context, *UpdateSlateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSlate not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) DeleteSlate(context.Context, *DeleteSlateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSlate not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) CreateLiveSession(context.Context, *CreateLiveSessionRequest) (*LiveSession, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateLiveSession not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) GetLiveSession(context.Context, *GetLiveSessionRequest) (*LiveSession, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLiveSession not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) CreateLiveConfig(context.Context, *CreateLiveConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateLiveConfig not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) ListLiveConfigs(context.Context, *ListLiveConfigsRequest) (*ListLiveConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLiveConfigs not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) GetLiveConfig(context.Context, *GetLiveConfigRequest) (*LiveConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLiveConfig not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) DeleteLiveConfig(context.Context, *DeleteLiveConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteLiveConfig not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) UpdateLiveConfig(context.Context, *UpdateLiveConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateLiveConfig not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) CreateVodConfig(context.Context, *CreateVodConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVodConfig not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) ListVodConfigs(context.Context, *ListVodConfigsRequest) (*ListVodConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVodConfigs not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) GetVodConfig(context.Context, *GetVodConfigRequest) (*VodConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVodConfig not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) DeleteVodConfig(context.Context, *DeleteVodConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVodConfig not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) UpdateVodConfig(context.Context, *UpdateVodConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVodConfig not implemented")
}

func RegisterVideoStitcherServiceServer(s *grpc.Server, srv VideoStitcherServiceServer) {
	s.RegisterService(&_VideoStitcherService_serviceDesc, srv)
}

func _VideoStitcherService_CreateCdnKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCdnKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).CreateCdnKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateCdnKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).CreateCdnKey(ctx, req.(*CreateCdnKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListCdnKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCdnKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListCdnKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/ListCdnKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListCdnKeys(ctx, req.(*ListCdnKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetCdnKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCdnKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetCdnKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/GetCdnKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetCdnKey(ctx, req.(*GetCdnKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_DeleteCdnKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCdnKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).DeleteCdnKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/DeleteCdnKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).DeleteCdnKey(ctx, req.(*DeleteCdnKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_UpdateCdnKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCdnKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).UpdateCdnKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/UpdateCdnKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).UpdateCdnKey(ctx, req.(*UpdateCdnKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_CreateVodSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVodSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).CreateVodSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateVodSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).CreateVodSession(ctx, req.(*CreateVodSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetVodSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVodSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetVodSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/GetVodSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetVodSession(ctx, req.(*GetVodSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListVodStitchDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVodStitchDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListVodStitchDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/ListVodStitchDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListVodStitchDetails(ctx, req.(*ListVodStitchDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetVodStitchDetail_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVodStitchDetailRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetVodStitchDetail(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/GetVodStitchDetail",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetVodStitchDetail(ctx, req.(*GetVodStitchDetailRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListVodAdTagDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVodAdTagDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListVodAdTagDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/ListVodAdTagDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListVodAdTagDetails(ctx, req.(*ListVodAdTagDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetVodAdTagDetail_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVodAdTagDetailRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetVodAdTagDetail(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/GetVodAdTagDetail",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetVodAdTagDetail(ctx, req.(*GetVodAdTagDetailRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListLiveAdTagDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLiveAdTagDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListLiveAdTagDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/ListLiveAdTagDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListLiveAdTagDetails(ctx, req.(*ListLiveAdTagDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetLiveAdTagDetail_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLiveAdTagDetailRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetLiveAdTagDetail(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/GetLiveAdTagDetail",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetLiveAdTagDetail(ctx, req.(*GetLiveAdTagDetailRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_CreateSlate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSlateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).CreateSlate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateSlate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).CreateSlate(ctx, req.(*CreateSlateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListSlates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSlatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListSlates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/ListSlates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListSlates(ctx, req.(*ListSlatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetSlate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSlateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetSlate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/GetSlate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetSlate(ctx, req.(*GetSlateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_UpdateSlate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSlateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).UpdateSlate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/UpdateSlate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).UpdateSlate(ctx, req.(*UpdateSlateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_DeleteSlate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSlateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).DeleteSlate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/DeleteSlate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).DeleteSlate(ctx, req.(*DeleteSlateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_CreateLiveSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateLiveSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).CreateLiveSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateLiveSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).CreateLiveSession(ctx, req.(*CreateLiveSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetLiveSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLiveSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetLiveSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/GetLiveSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetLiveSession(ctx, req.(*GetLiveSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_CreateLiveConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateLiveConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).CreateLiveConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateLiveConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).CreateLiveConfig(ctx, req.(*CreateLiveConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListLiveConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLiveConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListLiveConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/ListLiveConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListLiveConfigs(ctx, req.(*ListLiveConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetLiveConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLiveConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetLiveConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/GetLiveConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetLiveConfig(ctx, req.(*GetLiveConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_DeleteLiveConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLiveConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).DeleteLiveConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/DeleteLiveConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).DeleteLiveConfig(ctx, req.(*DeleteLiveConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_UpdateLiveConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateLiveConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).UpdateLiveConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/UpdateLiveConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).UpdateLiveConfig(ctx, req.(*UpdateLiveConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_CreateVodConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVodConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).CreateVodConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateVodConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).CreateVodConfig(ctx, req.(*CreateVodConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListVodConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVodConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListVodConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/ListVodConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListVodConfigs(ctx, req.(*ListVodConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetVodConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVodConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetVodConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/GetVodConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetVodConfig(ctx, req.(*GetVodConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_DeleteVodConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVodConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).DeleteVodConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/DeleteVodConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).DeleteVodConfig(ctx, req.(*DeleteVodConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_UpdateVodConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVodConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).UpdateVodConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/UpdateVodConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).UpdateVodConfig(ctx, req.(*UpdateVodConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoStitcherService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.video.stitcher.v1.VideoStitcherService",
	HandlerType: (*VideoStitcherServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateCdnKey",
			Handler:    _VideoStitcherService_CreateCdnKey_Handler,
		},
		{
			MethodName: "ListCdnKeys",
			Handler:    _VideoStitcherService_ListCdnKeys_Handler,
		},
		{
			MethodName: "GetCdnKey",
			Handler:    _VideoStitcherService_GetCdnKey_Handler,
		},
		{
			MethodName: "DeleteCdnKey",
			Handler:    _VideoStitcherService_DeleteCdnKey_Handler,
		},
		{
			MethodName: "UpdateCdnKey",
			Handler:    _VideoStitcherService_UpdateCdnKey_Handler,
		},
		{
			MethodName: "CreateVodSession",
			Handler:    _VideoStitcherService_CreateVodSession_Handler,
		},
		{
			MethodName: "GetVodSession",
			Handler:    _VideoStitcherService_GetVodSession_Handler,
		},
		{
			MethodName: "ListVodStitchDetails",
			Handler:    _VideoStitcherService_ListVodStitchDetails_Handler,
		},
		{
			MethodName: "GetVodStitchDetail",
			Handler:    _VideoStitcherService_GetVodStitchDetail_Handler,
		},
		{
			MethodName: "ListVodAdTagDetails",
			Handler:    _VideoStitcherService_ListVodAdTagDetails_Handler,
		},
		{
			MethodName: "GetVodAdTagDetail",
			Handler:    _VideoStitcherService_GetVodAdTagDetail_Handler,
		},
		{
			MethodName: "ListLiveAdTagDetails",
			Handler:    _VideoStitcherService_ListLiveAdTagDetails_Handler,
		},
		{
			MethodName: "GetLiveAdTagDetail",
			Handler:    _VideoStitcherService_GetLiveAdTagDetail_Handler,
		},
		{
			MethodName: "CreateSlate",
			Handler:    _VideoStitcherService_CreateSlate_Handler,
		},
		{
			MethodName: "ListSlates",
			Handler:    _VideoStitcherService_ListSlates_Handler,
		},
		{
			MethodName: "GetSlate",
			Handler:    _VideoStitcherService_GetSlate_Handler,
		},
		{
			MethodName: "UpdateSlate",
			Handler:    _VideoStitcherService_UpdateSlate_Handler,
		},
		{
			MethodName: "DeleteSlate",
			Handler:    _VideoStitcherService_DeleteSlate_Handler,
		},
		{
			MethodName: "CreateLiveSession",
			Handler:    _VideoStitcherService_CreateLiveSession_Handler,
		},
		{
			MethodName: "GetLiveSession",
			Handler:    _VideoStitcherService_GetLiveSession_Handler,
		},
		{
			MethodName: "CreateLiveConfig",
			Handler:    _VideoStitcherService_CreateLiveConfig_Handler,
		},
		{
			MethodName: "ListLiveConfigs",
			Handler:    _VideoStitcherService_ListLiveConfigs_Handler,
		},
		{
			MethodName: "GetLiveConfig",
			Handler:    _VideoStitcherService_GetLiveConfig_Handler,
		},
		{
			MethodName: "DeleteLiveConfig",
			Handler:    _VideoStitcherService_DeleteLiveConfig_Handler,
		},
		{
			MethodName: "UpdateLiveConfig",
			Handler:    _VideoStitcherService_UpdateLiveConfig_Handler,
		},
		{
			MethodName: "CreateVodConfig",
			Handler:    _VideoStitcherService_CreateVodConfig_Handler,
		},
		{
			MethodName: "ListVodConfigs",
			Handler:    _VideoStitcherService_ListVodConfigs_Handler,
		},
		{
			MethodName: "GetVodConfig",
			Handler:    _VideoStitcherService_GetVodConfig_Handler,
		},
		{
			MethodName: "DeleteVodConfig",
			Handler:    _VideoStitcherService_DeleteVodConfig_Handler,
		},
		{
			MethodName: "UpdateVodConfig",
			Handler:    _VideoStitcherService_UpdateVodConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/video/stitcher/v1/video_stitcher_service.proto",
}
