// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.3
// source: google/analytics/admin/v1alpha/analytics_admin.proto

package adminpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AnalyticsAdminService_GetAccount_FullMethodName                                   = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAccount"
	AnalyticsAdminService_ListAccounts_FullMethodName                                 = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAccounts"
	AnalyticsAdminService_DeleteAccount_FullMethodName                                = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteAccount"
	AnalyticsAdminService_UpdateAccount_FullMethodName                                = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateAccount"
	AnalyticsAdminService_ProvisionAccountTicket_FullMethodName                       = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ProvisionAccountTicket"
	AnalyticsAdminService_ListAccountSummaries_FullMethodName                         = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAccountSummaries"
	AnalyticsAdminService_GetProperty_FullMethodName                                  = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetProperty"
	AnalyticsAdminService_ListProperties_FullMethodName                               = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListProperties"
	AnalyticsAdminService_CreateProperty_FullMethodName                               = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateProperty"
	AnalyticsAdminService_DeleteProperty_FullMethodName                               = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteProperty"
	AnalyticsAdminService_UpdateProperty_FullMethodName                               = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateProperty"
	AnalyticsAdminService_CreateFirebaseLink_FullMethodName                           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateFirebaseLink"
	AnalyticsAdminService_DeleteFirebaseLink_FullMethodName                           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteFirebaseLink"
	AnalyticsAdminService_ListFirebaseLinks_FullMethodName                            = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListFirebaseLinks"
	AnalyticsAdminService_GetGlobalSiteTag_FullMethodName                             = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetGlobalSiteTag"
	AnalyticsAdminService_CreateGoogleAdsLink_FullMethodName                          = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateGoogleAdsLink"
	AnalyticsAdminService_UpdateGoogleAdsLink_FullMethodName                          = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateGoogleAdsLink"
	AnalyticsAdminService_DeleteGoogleAdsLink_FullMethodName                          = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteGoogleAdsLink"
	AnalyticsAdminService_ListGoogleAdsLinks_FullMethodName                           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListGoogleAdsLinks"
	AnalyticsAdminService_GetDataSharingSettings_FullMethodName                       = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDataSharingSettings"
	AnalyticsAdminService_GetMeasurementProtocolSecret_FullMethodName                 = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetMeasurementProtocolSecret"
	AnalyticsAdminService_ListMeasurementProtocolSecrets_FullMethodName               = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListMeasurementProtocolSecrets"
	AnalyticsAdminService_CreateMeasurementProtocolSecret_FullMethodName              = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateMeasurementProtocolSecret"
	AnalyticsAdminService_DeleteMeasurementProtocolSecret_FullMethodName              = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteMeasurementProtocolSecret"
	AnalyticsAdminService_UpdateMeasurementProtocolSecret_FullMethodName              = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateMeasurementProtocolSecret"
	AnalyticsAdminService_AcknowledgeUserDataCollection_FullMethodName                = "/google.analytics.admin.v1alpha.AnalyticsAdminService/AcknowledgeUserDataCollection"
	AnalyticsAdminService_GetSKAdNetworkConversionValueSchema_FullMethodName          = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetSKAdNetworkConversionValueSchema"
	AnalyticsAdminService_CreateSKAdNetworkConversionValueSchema_FullMethodName       = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateSKAdNetworkConversionValueSchema"
	AnalyticsAdminService_DeleteSKAdNetworkConversionValueSchema_FullMethodName       = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteSKAdNetworkConversionValueSchema"
	AnalyticsAdminService_UpdateSKAdNetworkConversionValueSchema_FullMethodName       = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateSKAdNetworkConversionValueSchema"
	AnalyticsAdminService_ListSKAdNetworkConversionValueSchemas_FullMethodName        = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListSKAdNetworkConversionValueSchemas"
	AnalyticsAdminService_SearchChangeHistoryEvents_FullMethodName                    = "/google.analytics.admin.v1alpha.AnalyticsAdminService/SearchChangeHistoryEvents"
	AnalyticsAdminService_GetGoogleSignalsSettings_FullMethodName                     = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetGoogleSignalsSettings"
	AnalyticsAdminService_UpdateGoogleSignalsSettings_FullMethodName                  = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateGoogleSignalsSettings"
	AnalyticsAdminService_CreateConversionEvent_FullMethodName                        = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateConversionEvent"
	AnalyticsAdminService_UpdateConversionEvent_FullMethodName                        = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateConversionEvent"
	AnalyticsAdminService_GetConversionEvent_FullMethodName                           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetConversionEvent"
	AnalyticsAdminService_DeleteConversionEvent_FullMethodName                        = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteConversionEvent"
	AnalyticsAdminService_ListConversionEvents_FullMethodName                         = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListConversionEvents"
	AnalyticsAdminService_CreateKeyEvent_FullMethodName                               = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateKeyEvent"
	AnalyticsAdminService_UpdateKeyEvent_FullMethodName                               = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateKeyEvent"
	AnalyticsAdminService_GetKeyEvent_FullMethodName                                  = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetKeyEvent"
	AnalyticsAdminService_DeleteKeyEvent_FullMethodName                               = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteKeyEvent"
	AnalyticsAdminService_ListKeyEvents_FullMethodName                                = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListKeyEvents"
	AnalyticsAdminService_GetDisplayVideo360AdvertiserLink_FullMethodName             = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDisplayVideo360AdvertiserLink"
	AnalyticsAdminService_ListDisplayVideo360AdvertiserLinks_FullMethodName           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListDisplayVideo360AdvertiserLinks"
	AnalyticsAdminService_CreateDisplayVideo360AdvertiserLink_FullMethodName          = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateDisplayVideo360AdvertiserLink"
	AnalyticsAdminService_DeleteDisplayVideo360AdvertiserLink_FullMethodName          = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteDisplayVideo360AdvertiserLink"
	AnalyticsAdminService_UpdateDisplayVideo360AdvertiserLink_FullMethodName          = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateDisplayVideo360AdvertiserLink"
	AnalyticsAdminService_GetDisplayVideo360AdvertiserLinkProposal_FullMethodName     = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDisplayVideo360AdvertiserLinkProposal"
	AnalyticsAdminService_ListDisplayVideo360AdvertiserLinkProposals_FullMethodName   = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListDisplayVideo360AdvertiserLinkProposals"
	AnalyticsAdminService_CreateDisplayVideo360AdvertiserLinkProposal_FullMethodName  = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateDisplayVideo360AdvertiserLinkProposal"
	AnalyticsAdminService_DeleteDisplayVideo360AdvertiserLinkProposal_FullMethodName  = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteDisplayVideo360AdvertiserLinkProposal"
	AnalyticsAdminService_ApproveDisplayVideo360AdvertiserLinkProposal_FullMethodName = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ApproveDisplayVideo360AdvertiserLinkProposal"
	AnalyticsAdminService_CancelDisplayVideo360AdvertiserLinkProposal_FullMethodName  = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CancelDisplayVideo360AdvertiserLinkProposal"
	AnalyticsAdminService_CreateCustomDimension_FullMethodName                        = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateCustomDimension"
	AnalyticsAdminService_UpdateCustomDimension_FullMethodName                        = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateCustomDimension"
	AnalyticsAdminService_ListCustomDimensions_FullMethodName                         = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListCustomDimensions"
	AnalyticsAdminService_ArchiveCustomDimension_FullMethodName                       = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ArchiveCustomDimension"
	AnalyticsAdminService_GetCustomDimension_FullMethodName                           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetCustomDimension"
	AnalyticsAdminService_CreateCustomMetric_FullMethodName                           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateCustomMetric"
	AnalyticsAdminService_UpdateCustomMetric_FullMethodName                           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateCustomMetric"
	AnalyticsAdminService_ListCustomMetrics_FullMethodName                            = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListCustomMetrics"
	AnalyticsAdminService_ArchiveCustomMetric_FullMethodName                          = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ArchiveCustomMetric"
	AnalyticsAdminService_GetCustomMetric_FullMethodName                              = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetCustomMetric"
	AnalyticsAdminService_GetDataRetentionSettings_FullMethodName                     = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDataRetentionSettings"
	AnalyticsAdminService_UpdateDataRetentionSettings_FullMethodName                  = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateDataRetentionSettings"
	AnalyticsAdminService_CreateDataStream_FullMethodName                             = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateDataStream"
	AnalyticsAdminService_DeleteDataStream_FullMethodName                             = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteDataStream"
	AnalyticsAdminService_UpdateDataStream_FullMethodName                             = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateDataStream"
	AnalyticsAdminService_ListDataStreams_FullMethodName                              = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListDataStreams"
	AnalyticsAdminService_GetDataStream_FullMethodName                                = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDataStream"
	AnalyticsAdminService_GetAudience_FullMethodName                                  = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAudience"
	AnalyticsAdminService_ListAudiences_FullMethodName                                = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAudiences"
	AnalyticsAdminService_CreateAudience_FullMethodName                               = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateAudience"
	AnalyticsAdminService_UpdateAudience_FullMethodName                               = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateAudience"
	AnalyticsAdminService_ArchiveAudience_FullMethodName                              = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ArchiveAudience"
	AnalyticsAdminService_GetSearchAds360Link_FullMethodName                          = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetSearchAds360Link"
	AnalyticsAdminService_ListSearchAds360Links_FullMethodName                        = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListSearchAds360Links"
	AnalyticsAdminService_CreateSearchAds360Link_FullMethodName                       = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateSearchAds360Link"
	AnalyticsAdminService_DeleteSearchAds360Link_FullMethodName                       = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteSearchAds360Link"
	AnalyticsAdminService_UpdateSearchAds360Link_FullMethodName                       = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateSearchAds360Link"
	AnalyticsAdminService_GetAttributionSettings_FullMethodName                       = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAttributionSettings"
	AnalyticsAdminService_UpdateAttributionSettings_FullMethodName                    = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateAttributionSettings"
	AnalyticsAdminService_RunAccessReport_FullMethodName                              = "/google.analytics.admin.v1alpha.AnalyticsAdminService/RunAccessReport"
	AnalyticsAdminService_CreateAccessBinding_FullMethodName                          = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateAccessBinding"
	AnalyticsAdminService_GetAccessBinding_FullMethodName                             = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAccessBinding"
	AnalyticsAdminService_UpdateAccessBinding_FullMethodName                          = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateAccessBinding"
	AnalyticsAdminService_DeleteAccessBinding_FullMethodName                          = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteAccessBinding"
	AnalyticsAdminService_ListAccessBindings_FullMethodName                           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAccessBindings"
	AnalyticsAdminService_BatchCreateAccessBindings_FullMethodName                    = "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchCreateAccessBindings"
	AnalyticsAdminService_BatchGetAccessBindings_FullMethodName                       = "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchGetAccessBindings"
	AnalyticsAdminService_BatchUpdateAccessBindings_FullMethodName                    = "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchUpdateAccessBindings"
	AnalyticsAdminService_BatchDeleteAccessBindings_FullMethodName                    = "/google.analytics.admin.v1alpha.AnalyticsAdminService/BatchDeleteAccessBindings"
	AnalyticsAdminService_GetExpandedDataSet_FullMethodName                           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetExpandedDataSet"
	AnalyticsAdminService_ListExpandedDataSets_FullMethodName                         = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListExpandedDataSets"
	AnalyticsAdminService_CreateExpandedDataSet_FullMethodName                        = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateExpandedDataSet"
	AnalyticsAdminService_UpdateExpandedDataSet_FullMethodName                        = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateExpandedDataSet"
	AnalyticsAdminService_DeleteExpandedDataSet_FullMethodName                        = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteExpandedDataSet"
	AnalyticsAdminService_GetChannelGroup_FullMethodName                              = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetChannelGroup"
	AnalyticsAdminService_ListChannelGroups_FullMethodName                            = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListChannelGroups"
	AnalyticsAdminService_CreateChannelGroup_FullMethodName                           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateChannelGroup"
	AnalyticsAdminService_UpdateChannelGroup_FullMethodName                           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateChannelGroup"
	AnalyticsAdminService_DeleteChannelGroup_FullMethodName                           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteChannelGroup"
	AnalyticsAdminService_SetAutomatedGa4ConfigurationOptOut_FullMethodName           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/SetAutomatedGa4ConfigurationOptOut"
	AnalyticsAdminService_FetchAutomatedGa4ConfigurationOptOut_FullMethodName         = "/google.analytics.admin.v1alpha.AnalyticsAdminService/FetchAutomatedGa4ConfigurationOptOut"
	AnalyticsAdminService_CreateBigQueryLink_FullMethodName                           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateBigQueryLink"
	AnalyticsAdminService_GetBigQueryLink_FullMethodName                              = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetBigQueryLink"
	AnalyticsAdminService_ListBigQueryLinks_FullMethodName                            = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListBigQueryLinks"
	AnalyticsAdminService_DeleteBigQueryLink_FullMethodName                           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteBigQueryLink"
	AnalyticsAdminService_UpdateBigQueryLink_FullMethodName                           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateBigQueryLink"
	AnalyticsAdminService_GetEnhancedMeasurementSettings_FullMethodName               = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetEnhancedMeasurementSettings"
	AnalyticsAdminService_UpdateEnhancedMeasurementSettings_FullMethodName            = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateEnhancedMeasurementSettings"
	AnalyticsAdminService_CreateConnectedSiteTag_FullMethodName                       = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateConnectedSiteTag"
	AnalyticsAdminService_DeleteConnectedSiteTag_FullMethodName                       = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteConnectedSiteTag"
	AnalyticsAdminService_ListConnectedSiteTags_FullMethodName                        = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListConnectedSiteTags"
	AnalyticsAdminService_FetchConnectedGa4Property_FullMethodName                    = "/google.analytics.admin.v1alpha.AnalyticsAdminService/FetchConnectedGa4Property"
	AnalyticsAdminService_GetAdSenseLink_FullMethodName                               = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetAdSenseLink"
	AnalyticsAdminService_CreateAdSenseLink_FullMethodName                            = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateAdSenseLink"
	AnalyticsAdminService_DeleteAdSenseLink_FullMethodName                            = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteAdSenseLink"
	AnalyticsAdminService_ListAdSenseLinks_FullMethodName                             = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListAdSenseLinks"
	AnalyticsAdminService_GetEventCreateRule_FullMethodName                           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetEventCreateRule"
	AnalyticsAdminService_ListEventCreateRules_FullMethodName                         = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListEventCreateRules"
	AnalyticsAdminService_CreateEventCreateRule_FullMethodName                        = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateEventCreateRule"
	AnalyticsAdminService_UpdateEventCreateRule_FullMethodName                        = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateEventCreateRule"
	AnalyticsAdminService_DeleteEventCreateRule_FullMethodName                        = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteEventCreateRule"
	AnalyticsAdminService_GetEventEditRule_FullMethodName                             = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetEventEditRule"
	AnalyticsAdminService_ListEventEditRules_FullMethodName                           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListEventEditRules"
	AnalyticsAdminService_CreateEventEditRule_FullMethodName                          = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateEventEditRule"
	AnalyticsAdminService_UpdateEventEditRule_FullMethodName                          = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateEventEditRule"
	AnalyticsAdminService_DeleteEventEditRule_FullMethodName                          = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteEventEditRule"
	AnalyticsAdminService_ReorderEventEditRules_FullMethodName                        = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ReorderEventEditRules"
	AnalyticsAdminService_UpdateDataRedactionSettings_FullMethodName                  = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateDataRedactionSettings"
	AnalyticsAdminService_GetDataRedactionSettings_FullMethodName                     = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetDataRedactionSettings"
	AnalyticsAdminService_GetCalculatedMetric_FullMethodName                          = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetCalculatedMetric"
	AnalyticsAdminService_CreateCalculatedMetric_FullMethodName                       = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateCalculatedMetric"
	AnalyticsAdminService_ListCalculatedMetrics_FullMethodName                        = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListCalculatedMetrics"
	AnalyticsAdminService_UpdateCalculatedMetric_FullMethodName                       = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateCalculatedMetric"
	AnalyticsAdminService_DeleteCalculatedMetric_FullMethodName                       = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteCalculatedMetric"
	AnalyticsAdminService_CreateRollupProperty_FullMethodName                         = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateRollupProperty"
	AnalyticsAdminService_GetRollupPropertySourceLink_FullMethodName                  = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetRollupPropertySourceLink"
	AnalyticsAdminService_ListRollupPropertySourceLinks_FullMethodName                = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListRollupPropertySourceLinks"
	AnalyticsAdminService_CreateRollupPropertySourceLink_FullMethodName               = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateRollupPropertySourceLink"
	AnalyticsAdminService_DeleteRollupPropertySourceLink_FullMethodName               = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteRollupPropertySourceLink"
	AnalyticsAdminService_ProvisionSubproperty_FullMethodName                         = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ProvisionSubproperty"
	AnalyticsAdminService_CreateSubpropertyEventFilter_FullMethodName                 = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateSubpropertyEventFilter"
	AnalyticsAdminService_GetSubpropertyEventFilter_FullMethodName                    = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetSubpropertyEventFilter"
	AnalyticsAdminService_ListSubpropertyEventFilters_FullMethodName                  = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListSubpropertyEventFilters"
	AnalyticsAdminService_UpdateSubpropertyEventFilter_FullMethodName                 = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateSubpropertyEventFilter"
	AnalyticsAdminService_DeleteSubpropertyEventFilter_FullMethodName                 = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteSubpropertyEventFilter"
	AnalyticsAdminService_CreateReportingDataAnnotation_FullMethodName                = "/google.analytics.admin.v1alpha.AnalyticsAdminService/CreateReportingDataAnnotation"
	AnalyticsAdminService_GetReportingDataAnnotation_FullMethodName                   = "/google.analytics.admin.v1alpha.AnalyticsAdminService/GetReportingDataAnnotation"
	AnalyticsAdminService_ListReportingDataAnnotations_FullMethodName                 = "/google.analytics.admin.v1alpha.AnalyticsAdminService/ListReportingDataAnnotations"
	AnalyticsAdminService_UpdateReportingDataAnnotation_FullMethodName                = "/google.analytics.admin.v1alpha.AnalyticsAdminService/UpdateReportingDataAnnotation"
	AnalyticsAdminService_DeleteReportingDataAnnotation_FullMethodName                = "/google.analytics.admin.v1alpha.AnalyticsAdminService/DeleteReportingDataAnnotation"
	AnalyticsAdminService_SubmitUserDeletion_FullMethodName                           = "/google.analytics.admin.v1alpha.AnalyticsAdminService/SubmitUserDeletion"
)

// AnalyticsAdminServiceClient is the client API for AnalyticsAdminService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AnalyticsAdminServiceClient interface {
	// Lookup for a single Account.
	GetAccount(ctx context.Context, in *GetAccountRequest, opts ...grpc.CallOption) (*Account, error)
	// Returns all accounts accessible by the caller.
	//
	// Note that these accounts might not currently have GA properties.
	// Soft-deleted (ie: "trashed") accounts are excluded by default.
	// Returns an empty list if no relevant accounts are found.
	ListAccounts(ctx context.Context, in *ListAccountsRequest, opts ...grpc.CallOption) (*ListAccountsResponse, error)
	// Marks target Account as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted accounts.
	// However, they can be restored using the Trash Can UI.
	//
	// If the accounts are not restored before the expiration time, the account
	// and all child resources (eg: Properties, GoogleAdsLinks, Streams,
	// AccessBindings) will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found.
	DeleteAccount(ctx context.Context, in *DeleteAccountRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates an account.
	UpdateAccount(ctx context.Context, in *UpdateAccountRequest, opts ...grpc.CallOption) (*Account, error)
	// Requests a ticket for creating an account.
	ProvisionAccountTicket(ctx context.Context, in *ProvisionAccountTicketRequest, opts ...grpc.CallOption) (*ProvisionAccountTicketResponse, error)
	// Returns summaries of all accounts accessible by the caller.
	ListAccountSummaries(ctx context.Context, in *ListAccountSummariesRequest, opts ...grpc.CallOption) (*ListAccountSummariesResponse, error)
	// Lookup for a single GA Property.
	GetProperty(ctx context.Context, in *GetPropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Returns child Properties under the specified parent Account.
	//
	// Properties will be excluded if the caller does not have access.
	// Soft-deleted (ie: "trashed") properties are excluded by default.
	// Returns an empty list if no relevant properties are found.
	ListProperties(ctx context.Context, in *ListPropertiesRequest, opts ...grpc.CallOption) (*ListPropertiesResponse, error)
	// Creates a Google Analytics property with the specified location and
	// attributes.
	CreateProperty(ctx context.Context, in *CreatePropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Marks target Property as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted properties.
	// However, they can be restored using the Trash Can UI.
	//
	// If the properties are not restored before the expiration time, the Property
	// and all child resources (eg: GoogleAdsLinks, Streams, AccessBindings)
	// will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found.
	DeleteProperty(ctx context.Context, in *DeletePropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Updates a property.
	UpdateProperty(ctx context.Context, in *UpdatePropertyRequest, opts ...grpc.CallOption) (*Property, error)
	// Creates a FirebaseLink.
	//
	// Properties can have at most one FirebaseLink.
	CreateFirebaseLink(ctx context.Context, in *CreateFirebaseLinkRequest, opts ...grpc.CallOption) (*FirebaseLink, error)
	// Deletes a FirebaseLink on a property
	DeleteFirebaseLink(ctx context.Context, in *DeleteFirebaseLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists FirebaseLinks on a property.
	// Properties can have at most one FirebaseLink.
	ListFirebaseLinks(ctx context.Context, in *ListFirebaseLinksRequest, opts ...grpc.CallOption) (*ListFirebaseLinksResponse, error)
	// Returns the Site Tag for the specified web stream.
	// Site Tags are immutable singletons.
	GetGlobalSiteTag(ctx context.Context, in *GetGlobalSiteTagRequest, opts ...grpc.CallOption) (*GlobalSiteTag, error)
	// Creates a GoogleAdsLink.
	CreateGoogleAdsLink(ctx context.Context, in *CreateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error)
	// Updates a GoogleAdsLink on a property
	UpdateGoogleAdsLink(ctx context.Context, in *UpdateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error)
	// Deletes a GoogleAdsLink on a property
	DeleteGoogleAdsLink(ctx context.Context, in *DeleteGoogleAdsLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists GoogleAdsLinks on a property.
	ListGoogleAdsLinks(ctx context.Context, in *ListGoogleAdsLinksRequest, opts ...grpc.CallOption) (*ListGoogleAdsLinksResponse, error)
	// Get data sharing settings on an account.
	// Data sharing settings are singletons.
	GetDataSharingSettings(ctx context.Context, in *GetDataSharingSettingsRequest, opts ...grpc.CallOption) (*DataSharingSettings, error)
	// Lookup for a single MeasurementProtocolSecret.
	GetMeasurementProtocolSecret(ctx context.Context, in *GetMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error)
	// Returns child MeasurementProtocolSecrets under the specified parent
	// Property.
	ListMeasurementProtocolSecrets(ctx context.Context, in *ListMeasurementProtocolSecretsRequest, opts ...grpc.CallOption) (*ListMeasurementProtocolSecretsResponse, error)
	// Creates a measurement protocol secret.
	CreateMeasurementProtocolSecret(ctx context.Context, in *CreateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error)
	// Deletes target MeasurementProtocolSecret.
	DeleteMeasurementProtocolSecret(ctx context.Context, in *DeleteMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a measurement protocol secret.
	UpdateMeasurementProtocolSecret(ctx context.Context, in *UpdateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error)
	// Acknowledges the terms of user data collection for the specified property.
	//
	// This acknowledgement must be completed (either in the Google Analytics UI
	// or through this API) before MeasurementProtocolSecret resources may be
	// created.
	AcknowledgeUserDataCollection(ctx context.Context, in *AcknowledgeUserDataCollectionRequest, opts ...grpc.CallOption) (*AcknowledgeUserDataCollectionResponse, error)
	// Looks up a single SKAdNetworkConversionValueSchema.
	GetSKAdNetworkConversionValueSchema(ctx context.Context, in *GetSKAdNetworkConversionValueSchemaRequest, opts ...grpc.CallOption) (*SKAdNetworkConversionValueSchema, error)
	// Creates a SKAdNetworkConversionValueSchema.
	CreateSKAdNetworkConversionValueSchema(ctx context.Context, in *CreateSKAdNetworkConversionValueSchemaRequest, opts ...grpc.CallOption) (*SKAdNetworkConversionValueSchema, error)
	// Deletes target SKAdNetworkConversionValueSchema.
	DeleteSKAdNetworkConversionValueSchema(ctx context.Context, in *DeleteSKAdNetworkConversionValueSchemaRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a SKAdNetworkConversionValueSchema.
	UpdateSKAdNetworkConversionValueSchema(ctx context.Context, in *UpdateSKAdNetworkConversionValueSchemaRequest, opts ...grpc.CallOption) (*SKAdNetworkConversionValueSchema, error)
	// Lists SKAdNetworkConversionValueSchema on a stream.
	// Properties can have at most one SKAdNetworkConversionValueSchema.
	ListSKAdNetworkConversionValueSchemas(ctx context.Context, in *ListSKAdNetworkConversionValueSchemasRequest, opts ...grpc.CallOption) (*ListSKAdNetworkConversionValueSchemasResponse, error)
	// Searches through all changes to an account or its children given the
	// specified set of filters.
	//
	// Only returns the subset of changes supported by the API. The UI may return
	// additional changes.
	SearchChangeHistoryEvents(ctx context.Context, in *SearchChangeHistoryEventsRequest, opts ...grpc.CallOption) (*SearchChangeHistoryEventsResponse, error)
	// Lookup for Google Signals settings for a property.
	GetGoogleSignalsSettings(ctx context.Context, in *GetGoogleSignalsSettingsRequest, opts ...grpc.CallOption) (*GoogleSignalsSettings, error)
	// Updates Google Signals settings for a property.
	UpdateGoogleSignalsSettings(ctx context.Context, in *UpdateGoogleSignalsSettingsRequest, opts ...grpc.CallOption) (*GoogleSignalsSettings, error)
	// Deprecated: Do not use.
	// Deprecated: Use `CreateKeyEvent` instead.
	// Creates a conversion event with the specified attributes.
	CreateConversionEvent(ctx context.Context, in *CreateConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error)
	// Deprecated: Do not use.
	// Deprecated: Use `UpdateKeyEvent` instead.
	// Updates a conversion event with the specified attributes.
	UpdateConversionEvent(ctx context.Context, in *UpdateConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error)
	// Deprecated: Do not use.
	// Deprecated: Use `GetKeyEvent` instead.
	// Retrieve a single conversion event.
	GetConversionEvent(ctx context.Context, in *GetConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error)
	// Deprecated: Do not use.
	// Deprecated: Use `DeleteKeyEvent` instead.
	// Deletes a conversion event in a property.
	DeleteConversionEvent(ctx context.Context, in *DeleteConversionEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Deprecated: Use `ListKeyEvents` instead.
	// Returns a list of conversion events in the specified parent property.
	//
	// Returns an empty list if no conversion events are found.
	ListConversionEvents(ctx context.Context, in *ListConversionEventsRequest, opts ...grpc.CallOption) (*ListConversionEventsResponse, error)
	// Creates a Key Event.
	CreateKeyEvent(ctx context.Context, in *CreateKeyEventRequest, opts ...grpc.CallOption) (*KeyEvent, error)
	// Updates a Key Event.
	UpdateKeyEvent(ctx context.Context, in *UpdateKeyEventRequest, opts ...grpc.CallOption) (*KeyEvent, error)
	// Retrieve a single Key Event.
	GetKeyEvent(ctx context.Context, in *GetKeyEventRequest, opts ...grpc.CallOption) (*KeyEvent, error)
	// Deletes a Key Event.
	DeleteKeyEvent(ctx context.Context, in *DeleteKeyEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns a list of Key Events in the specified parent property.
	// Returns an empty list if no Key Events are found.
	ListKeyEvents(ctx context.Context, in *ListKeyEventsRequest, opts ...grpc.CallOption) (*ListKeyEventsResponse, error)
	// Look up a single DisplayVideo360AdvertiserLink
	GetDisplayVideo360AdvertiserLink(ctx context.Context, in *GetDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error)
	// Lists all DisplayVideo360AdvertiserLinks on a property.
	ListDisplayVideo360AdvertiserLinks(ctx context.Context, in *ListDisplayVideo360AdvertiserLinksRequest, opts ...grpc.CallOption) (*ListDisplayVideo360AdvertiserLinksResponse, error)
	// Creates a DisplayVideo360AdvertiserLink.
	// This can only be utilized by users who have proper authorization both on
	// the Google Analytics property and on the Display & Video 360 advertiser.
	// Users who do not have access to the Display & Video 360 advertiser should
	// instead seek to create a DisplayVideo360LinkProposal.
	CreateDisplayVideo360AdvertiserLink(ctx context.Context, in *CreateDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error)
	// Deletes a DisplayVideo360AdvertiserLink on a property.
	DeleteDisplayVideo360AdvertiserLink(ctx context.Context, in *DeleteDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a DisplayVideo360AdvertiserLink on a property.
	UpdateDisplayVideo360AdvertiserLink(ctx context.Context, in *UpdateDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error)
	// Lookup for a single DisplayVideo360AdvertiserLinkProposal.
	GetDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *GetDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Lists DisplayVideo360AdvertiserLinkProposals on a property.
	ListDisplayVideo360AdvertiserLinkProposals(ctx context.Context, in *ListDisplayVideo360AdvertiserLinkProposalsRequest, opts ...grpc.CallOption) (*ListDisplayVideo360AdvertiserLinkProposalsResponse, error)
	// Creates a DisplayVideo360AdvertiserLinkProposal.
	CreateDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *CreateDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Deletes a DisplayVideo360AdvertiserLinkProposal on a property.
	// This can only be used on cancelled proposals.
	DeleteDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *DeleteDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Approves a DisplayVideo360AdvertiserLinkProposal.
	// The DisplayVideo360AdvertiserLinkProposal will be deleted and a new
	// DisplayVideo360AdvertiserLink will be created.
	ApproveDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *ApproveDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*ApproveDisplayVideo360AdvertiserLinkProposalResponse, error)
	// Cancels a DisplayVideo360AdvertiserLinkProposal.
	// Cancelling can mean either:
	// - Declining a proposal initiated from Display & Video 360
	// - Withdrawing a proposal initiated from Google Analytics
	// After being cancelled, a proposal will eventually be deleted automatically.
	CancelDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *CancelDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Creates a CustomDimension.
	CreateCustomDimension(ctx context.Context, in *CreateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error)
	// Updates a CustomDimension on a property.
	UpdateCustomDimension(ctx context.Context, in *UpdateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error)
	// Lists CustomDimensions on a property.
	ListCustomDimensions(ctx context.Context, in *ListCustomDimensionsRequest, opts ...grpc.CallOption) (*ListCustomDimensionsResponse, error)
	// Archives a CustomDimension on a property.
	ArchiveCustomDimension(ctx context.Context, in *ArchiveCustomDimensionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup for a single CustomDimension.
	GetCustomDimension(ctx context.Context, in *GetCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error)
	// Creates a CustomMetric.
	CreateCustomMetric(ctx context.Context, in *CreateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error)
	// Updates a CustomMetric on a property.
	UpdateCustomMetric(ctx context.Context, in *UpdateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error)
	// Lists CustomMetrics on a property.
	ListCustomMetrics(ctx context.Context, in *ListCustomMetricsRequest, opts ...grpc.CallOption) (*ListCustomMetricsResponse, error)
	// Archives a CustomMetric on a property.
	ArchiveCustomMetric(ctx context.Context, in *ArchiveCustomMetricRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup for a single CustomMetric.
	GetCustomMetric(ctx context.Context, in *GetCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error)
	// Returns the singleton data retention settings for this property.
	GetDataRetentionSettings(ctx context.Context, in *GetDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error)
	// Updates the singleton data retention settings for this property.
	UpdateDataRetentionSettings(ctx context.Context, in *UpdateDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error)
	// Creates a DataStream.
	CreateDataStream(ctx context.Context, in *CreateDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error)
	// Deletes a DataStream on a property.
	DeleteDataStream(ctx context.Context, in *DeleteDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a DataStream on a property.
	UpdateDataStream(ctx context.Context, in *UpdateDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error)
	// Lists DataStreams on a property.
	ListDataStreams(ctx context.Context, in *ListDataStreamsRequest, opts ...grpc.CallOption) (*ListDataStreamsResponse, error)
	// Lookup for a single DataStream.
	GetDataStream(ctx context.Context, in *GetDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error)
	// Lookup for a single Audience.
	// Audiences created before 2020 may not be supported.
	// Default audiences will not show filter definitions.
	GetAudience(ctx context.Context, in *GetAudienceRequest, opts ...grpc.CallOption) (*Audience, error)
	// Lists Audiences on a property.
	// Audiences created before 2020 may not be supported.
	// Default audiences will not show filter definitions.
	ListAudiences(ctx context.Context, in *ListAudiencesRequest, opts ...grpc.CallOption) (*ListAudiencesResponse, error)
	// Creates an Audience.
	CreateAudience(ctx context.Context, in *CreateAudienceRequest, opts ...grpc.CallOption) (*Audience, error)
	// Updates an Audience on a property.
	UpdateAudience(ctx context.Context, in *UpdateAudienceRequest, opts ...grpc.CallOption) (*Audience, error)
	// Archives an Audience on a property.
	ArchiveAudience(ctx context.Context, in *ArchiveAudienceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Look up a single SearchAds360Link
	GetSearchAds360Link(ctx context.Context, in *GetSearchAds360LinkRequest, opts ...grpc.CallOption) (*SearchAds360Link, error)
	// Lists all SearchAds360Links on a property.
	ListSearchAds360Links(ctx context.Context, in *ListSearchAds360LinksRequest, opts ...grpc.CallOption) (*ListSearchAds360LinksResponse, error)
	// Creates a SearchAds360Link.
	CreateSearchAds360Link(ctx context.Context, in *CreateSearchAds360LinkRequest, opts ...grpc.CallOption) (*SearchAds360Link, error)
	// Deletes a SearchAds360Link on a property.
	DeleteSearchAds360Link(ctx context.Context, in *DeleteSearchAds360LinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a SearchAds360Link on a property.
	UpdateSearchAds360Link(ctx context.Context, in *UpdateSearchAds360LinkRequest, opts ...grpc.CallOption) (*SearchAds360Link, error)
	// Lookup for a AttributionSettings singleton.
	GetAttributionSettings(ctx context.Context, in *GetAttributionSettingsRequest, opts ...grpc.CallOption) (*AttributionSettings, error)
	// Updates attribution settings on a property.
	UpdateAttributionSettings(ctx context.Context, in *UpdateAttributionSettingsRequest, opts ...grpc.CallOption) (*AttributionSettings, error)
	// Returns a customized report of data access records. The report provides
	// records of each time a user reads Google Analytics reporting data. Access
	// records are retained for up to 2 years.
	//
	// Data Access Reports can be requested for a property. Reports may be
	// requested for any property, but dimensions that aren't related to quota can
	// only be requested on Google Analytics 360 properties. This method is only
	// available to Administrators.
	//
	// These data access records include GA UI Reporting, GA UI Explorations,
	// GA Data API, and other products like Firebase & Admob that can retrieve
	// data from Google Analytics through a linkage. These records don't include
	// property configuration changes like adding a stream or changing a
	// property's time zone. For configuration change history, see
	// [searchChangeHistoryEvents](https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1alpha/accounts/searchChangeHistoryEvents).
	//
	// To give your feedback on this API, complete the [Google Analytics Access
	// Reports
	// feedback](https://docs.google.com/forms/d/e/1FAIpQLSdmEBUrMzAEdiEKk5TV5dEHvDUZDRlgWYdQdAeSdtR4hVjEhw/viewform)
	// form.
	RunAccessReport(ctx context.Context, in *RunAccessReportRequest, opts ...grpc.CallOption) (*RunAccessReportResponse, error)
	// Creates an access binding on an account or property.
	CreateAccessBinding(ctx context.Context, in *CreateAccessBindingRequest, opts ...grpc.CallOption) (*AccessBinding, error)
	// Gets information about an access binding.
	GetAccessBinding(ctx context.Context, in *GetAccessBindingRequest, opts ...grpc.CallOption) (*AccessBinding, error)
	// Updates an access binding on an account or property.
	UpdateAccessBinding(ctx context.Context, in *UpdateAccessBindingRequest, opts ...grpc.CallOption) (*AccessBinding, error)
	// Deletes an access binding on an account or property.
	DeleteAccessBinding(ctx context.Context, in *DeleteAccessBindingRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists all access bindings on an account or property.
	ListAccessBindings(ctx context.Context, in *ListAccessBindingsRequest, opts ...grpc.CallOption) (*ListAccessBindingsResponse, error)
	// Creates information about multiple access bindings to an account or
	// property.
	//
	// This method is transactional. If any AccessBinding cannot be created, none
	// of the AccessBindings will be created.
	BatchCreateAccessBindings(ctx context.Context, in *BatchCreateAccessBindingsRequest, opts ...grpc.CallOption) (*BatchCreateAccessBindingsResponse, error)
	// Gets information about multiple access bindings to an account or property.
	BatchGetAccessBindings(ctx context.Context, in *BatchGetAccessBindingsRequest, opts ...grpc.CallOption) (*BatchGetAccessBindingsResponse, error)
	// Updates information about multiple access bindings to an account or
	// property.
	BatchUpdateAccessBindings(ctx context.Context, in *BatchUpdateAccessBindingsRequest, opts ...grpc.CallOption) (*BatchUpdateAccessBindingsResponse, error)
	// Deletes information about multiple users' links to an account or property.
	BatchDeleteAccessBindings(ctx context.Context, in *BatchDeleteAccessBindingsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup for a single ExpandedDataSet.
	GetExpandedDataSet(ctx context.Context, in *GetExpandedDataSetRequest, opts ...grpc.CallOption) (*ExpandedDataSet, error)
	// Lists ExpandedDataSets on a property.
	ListExpandedDataSets(ctx context.Context, in *ListExpandedDataSetsRequest, opts ...grpc.CallOption) (*ListExpandedDataSetsResponse, error)
	// Creates a ExpandedDataSet.
	CreateExpandedDataSet(ctx context.Context, in *CreateExpandedDataSetRequest, opts ...grpc.CallOption) (*ExpandedDataSet, error)
	// Updates a ExpandedDataSet on a property.
	UpdateExpandedDataSet(ctx context.Context, in *UpdateExpandedDataSetRequest, opts ...grpc.CallOption) (*ExpandedDataSet, error)
	// Deletes a ExpandedDataSet on a property.
	DeleteExpandedDataSet(ctx context.Context, in *DeleteExpandedDataSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup for a single ChannelGroup.
	GetChannelGroup(ctx context.Context, in *GetChannelGroupRequest, opts ...grpc.CallOption) (*ChannelGroup, error)
	// Lists ChannelGroups on a property.
	ListChannelGroups(ctx context.Context, in *ListChannelGroupsRequest, opts ...grpc.CallOption) (*ListChannelGroupsResponse, error)
	// Creates a ChannelGroup.
	CreateChannelGroup(ctx context.Context, in *CreateChannelGroupRequest, opts ...grpc.CallOption) (*ChannelGroup, error)
	// Updates a ChannelGroup.
	UpdateChannelGroup(ctx context.Context, in *UpdateChannelGroupRequest, opts ...grpc.CallOption) (*ChannelGroup, error)
	// Deletes a ChannelGroup on a property.
	DeleteChannelGroup(ctx context.Context, in *DeleteChannelGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Sets the opt out status for the automated GA4 setup process for a UA
	// property.
	// Note: this has no effect on GA4 property.
	SetAutomatedGa4ConfigurationOptOut(ctx context.Context, in *SetAutomatedGa4ConfigurationOptOutRequest, opts ...grpc.CallOption) (*SetAutomatedGa4ConfigurationOptOutResponse, error)
	// Fetches the opt out status for the automated GA4 setup process for a UA
	// property.
	// Note: this has no effect on GA4 property.
	FetchAutomatedGa4ConfigurationOptOut(ctx context.Context, in *FetchAutomatedGa4ConfigurationOptOutRequest, opts ...grpc.CallOption) (*FetchAutomatedGa4ConfigurationOptOutResponse, error)
	// Creates a BigQueryLink.
	CreateBigQueryLink(ctx context.Context, in *CreateBigQueryLinkRequest, opts ...grpc.CallOption) (*BigQueryLink, error)
	// Lookup for a single BigQuery Link.
	GetBigQueryLink(ctx context.Context, in *GetBigQueryLinkRequest, opts ...grpc.CallOption) (*BigQueryLink, error)
	// Lists BigQuery Links on a property.
	ListBigQueryLinks(ctx context.Context, in *ListBigQueryLinksRequest, opts ...grpc.CallOption) (*ListBigQueryLinksResponse, error)
	// Deletes a BigQueryLink on a property.
	DeleteBigQueryLink(ctx context.Context, in *DeleteBigQueryLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a BigQueryLink.
	UpdateBigQueryLink(ctx context.Context, in *UpdateBigQueryLinkRequest, opts ...grpc.CallOption) (*BigQueryLink, error)
	// Returns the enhanced measurement settings for this data stream.
	// Note that the stream must enable enhanced measurement for these settings to
	// take effect.
	GetEnhancedMeasurementSettings(ctx context.Context, in *GetEnhancedMeasurementSettingsRequest, opts ...grpc.CallOption) (*EnhancedMeasurementSettings, error)
	// Updates the enhanced measurement settings for this data stream.
	// Note that the stream must enable enhanced measurement for these settings to
	// take effect.
	UpdateEnhancedMeasurementSettings(ctx context.Context, in *UpdateEnhancedMeasurementSettingsRequest, opts ...grpc.CallOption) (*EnhancedMeasurementSettings, error)
	// Creates a connected site tag for a Universal Analytics property. You can
	// create a maximum of 20 connected site tags per property.
	// Note: This API cannot be used on GA4 properties.
	CreateConnectedSiteTag(ctx context.Context, in *CreateConnectedSiteTagRequest, opts ...grpc.CallOption) (*CreateConnectedSiteTagResponse, error)
	// Deletes a connected site tag for a Universal Analytics property.
	// Note: this has no effect on GA4 properties.
	DeleteConnectedSiteTag(ctx context.Context, in *DeleteConnectedSiteTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists the connected site tags for a Universal Analytics property. A maximum
	// of 20 connected site tags will be returned. Note: this has no effect on GA4
	// property.
	ListConnectedSiteTags(ctx context.Context, in *ListConnectedSiteTagsRequest, opts ...grpc.CallOption) (*ListConnectedSiteTagsResponse, error)
	// Given a specified UA property, looks up the GA4 property connected to it.
	// Note: this cannot be used with GA4 properties.
	FetchConnectedGa4Property(ctx context.Context, in *FetchConnectedGa4PropertyRequest, opts ...grpc.CallOption) (*FetchConnectedGa4PropertyResponse, error)
	// Looks up a single AdSenseLink.
	GetAdSenseLink(ctx context.Context, in *GetAdSenseLinkRequest, opts ...grpc.CallOption) (*AdSenseLink, error)
	// Creates an AdSenseLink.
	CreateAdSenseLink(ctx context.Context, in *CreateAdSenseLinkRequest, opts ...grpc.CallOption) (*AdSenseLink, error)
	// Deletes an AdSenseLink.
	DeleteAdSenseLink(ctx context.Context, in *DeleteAdSenseLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists AdSenseLinks on a property.
	ListAdSenseLinks(ctx context.Context, in *ListAdSenseLinksRequest, opts ...grpc.CallOption) (*ListAdSenseLinksResponse, error)
	// Lookup for a single EventCreateRule.
	GetEventCreateRule(ctx context.Context, in *GetEventCreateRuleRequest, opts ...grpc.CallOption) (*EventCreateRule, error)
	// Lists EventCreateRules on a web data stream.
	ListEventCreateRules(ctx context.Context, in *ListEventCreateRulesRequest, opts ...grpc.CallOption) (*ListEventCreateRulesResponse, error)
	// Creates an EventCreateRule.
	CreateEventCreateRule(ctx context.Context, in *CreateEventCreateRuleRequest, opts ...grpc.CallOption) (*EventCreateRule, error)
	// Updates an EventCreateRule.
	UpdateEventCreateRule(ctx context.Context, in *UpdateEventCreateRuleRequest, opts ...grpc.CallOption) (*EventCreateRule, error)
	// Deletes an EventCreateRule.
	DeleteEventCreateRule(ctx context.Context, in *DeleteEventCreateRuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lookup for a single EventEditRule.
	GetEventEditRule(ctx context.Context, in *GetEventEditRuleRequest, opts ...grpc.CallOption) (*EventEditRule, error)
	// Lists EventEditRules on a web data stream.
	ListEventEditRules(ctx context.Context, in *ListEventEditRulesRequest, opts ...grpc.CallOption) (*ListEventEditRulesResponse, error)
	// Creates an EventEditRule.
	CreateEventEditRule(ctx context.Context, in *CreateEventEditRuleRequest, opts ...grpc.CallOption) (*EventEditRule, error)
	// Updates an EventEditRule.
	UpdateEventEditRule(ctx context.Context, in *UpdateEventEditRuleRequest, opts ...grpc.CallOption) (*EventEditRule, error)
	// Deletes an EventEditRule.
	DeleteEventEditRule(ctx context.Context, in *DeleteEventEditRuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Changes the processing order of event edit rules on the specified stream.
	ReorderEventEditRules(ctx context.Context, in *ReorderEventEditRulesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a DataRedactionSettings on a property.
	UpdateDataRedactionSettings(ctx context.Context, in *UpdateDataRedactionSettingsRequest, opts ...grpc.CallOption) (*DataRedactionSettings, error)
	// Lookup for a single DataRedactionSettings.
	GetDataRedactionSettings(ctx context.Context, in *GetDataRedactionSettingsRequest, opts ...grpc.CallOption) (*DataRedactionSettings, error)
	// Lookup for a single CalculatedMetric.
	GetCalculatedMetric(ctx context.Context, in *GetCalculatedMetricRequest, opts ...grpc.CallOption) (*CalculatedMetric, error)
	// Creates a CalculatedMetric.
	CreateCalculatedMetric(ctx context.Context, in *CreateCalculatedMetricRequest, opts ...grpc.CallOption) (*CalculatedMetric, error)
	// Lists CalculatedMetrics on a property.
	ListCalculatedMetrics(ctx context.Context, in *ListCalculatedMetricsRequest, opts ...grpc.CallOption) (*ListCalculatedMetricsResponse, error)
	// Updates a CalculatedMetric on a property.
	UpdateCalculatedMetric(ctx context.Context, in *UpdateCalculatedMetricRequest, opts ...grpc.CallOption) (*CalculatedMetric, error)
	// Deletes a CalculatedMetric on a property.
	DeleteCalculatedMetric(ctx context.Context, in *DeleteCalculatedMetricRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Create a roll-up property and all roll-up property source links.
	CreateRollupProperty(ctx context.Context, in *CreateRollupPropertyRequest, opts ...grpc.CallOption) (*CreateRollupPropertyResponse, error)
	// Lookup for a single roll-up property source Link.
	// Only roll-up properties can have source links, so this method will throw an
	// error if used on other types of properties.
	GetRollupPropertySourceLink(ctx context.Context, in *GetRollupPropertySourceLinkRequest, opts ...grpc.CallOption) (*RollupPropertySourceLink, error)
	// Lists roll-up property source Links on a property.
	// Only roll-up properties can have source links, so this method will throw an
	// error if used on other types of properties.
	ListRollupPropertySourceLinks(ctx context.Context, in *ListRollupPropertySourceLinksRequest, opts ...grpc.CallOption) (*ListRollupPropertySourceLinksResponse, error)
	// Creates a roll-up property source link.
	// Only roll-up properties can have source links, so this method will throw an
	// error if used on other types of properties.
	CreateRollupPropertySourceLink(ctx context.Context, in *CreateRollupPropertySourceLinkRequest, opts ...grpc.CallOption) (*RollupPropertySourceLink, error)
	// Deletes a roll-up property source link.
	// Only roll-up properties can have source links, so this method will throw an
	// error if used on other types of properties.
	DeleteRollupPropertySourceLink(ctx context.Context, in *DeleteRollupPropertySourceLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Create a subproperty and a subproperty event filter that applies to the
	// created subproperty.
	ProvisionSubproperty(ctx context.Context, in *ProvisionSubpropertyRequest, opts ...grpc.CallOption) (*ProvisionSubpropertyResponse, error)
	// Creates a subproperty Event Filter.
	CreateSubpropertyEventFilter(ctx context.Context, in *CreateSubpropertyEventFilterRequest, opts ...grpc.CallOption) (*SubpropertyEventFilter, error)
	// Lookup for a single subproperty Event Filter.
	GetSubpropertyEventFilter(ctx context.Context, in *GetSubpropertyEventFilterRequest, opts ...grpc.CallOption) (*SubpropertyEventFilter, error)
	// List all subproperty Event Filters on a property.
	ListSubpropertyEventFilters(ctx context.Context, in *ListSubpropertyEventFiltersRequest, opts ...grpc.CallOption) (*ListSubpropertyEventFiltersResponse, error)
	// Updates a subproperty Event Filter.
	UpdateSubpropertyEventFilter(ctx context.Context, in *UpdateSubpropertyEventFilterRequest, opts ...grpc.CallOption) (*SubpropertyEventFilter, error)
	// Deletes a subproperty event filter.
	DeleteSubpropertyEventFilter(ctx context.Context, in *DeleteSubpropertyEventFilterRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a Reporting Data Annotation.
	CreateReportingDataAnnotation(ctx context.Context, in *CreateReportingDataAnnotationRequest, opts ...grpc.CallOption) (*ReportingDataAnnotation, error)
	// Lookup a single Reporting Data Annotation.
	GetReportingDataAnnotation(ctx context.Context, in *GetReportingDataAnnotationRequest, opts ...grpc.CallOption) (*ReportingDataAnnotation, error)
	// List all Reporting Data Annotations on a property.
	ListReportingDataAnnotations(ctx context.Context, in *ListReportingDataAnnotationsRequest, opts ...grpc.CallOption) (*ListReportingDataAnnotationsResponse, error)
	// Updates a Reporting Data Annotation.
	UpdateReportingDataAnnotation(ctx context.Context, in *UpdateReportingDataAnnotationRequest, opts ...grpc.CallOption) (*ReportingDataAnnotation, error)
	// Deletes a Reporting Data Annotation.
	DeleteReportingDataAnnotation(ctx context.Context, in *DeleteReportingDataAnnotationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Submits a request for user deletion for a property.
	SubmitUserDeletion(ctx context.Context, in *SubmitUserDeletionRequest, opts ...grpc.CallOption) (*SubmitUserDeletionResponse, error)
}

type analyticsAdminServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAnalyticsAdminServiceClient(cc grpc.ClientConnInterface) AnalyticsAdminServiceClient {
	return &analyticsAdminServiceClient{cc}
}

func (c *analyticsAdminServiceClient) GetAccount(ctx context.Context, in *GetAccountRequest, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetAccount_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListAccounts(ctx context.Context, in *ListAccountsRequest, opts ...grpc.CallOption) (*ListAccountsResponse, error) {
	out := new(ListAccountsResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListAccounts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteAccount(ctx context.Context, in *DeleteAccountRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteAccount_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateAccount(ctx context.Context, in *UpdateAccountRequest, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateAccount_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ProvisionAccountTicket(ctx context.Context, in *ProvisionAccountTicketRequest, opts ...grpc.CallOption) (*ProvisionAccountTicketResponse, error) {
	out := new(ProvisionAccountTicketResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ProvisionAccountTicket_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListAccountSummaries(ctx context.Context, in *ListAccountSummariesRequest, opts ...grpc.CallOption) (*ListAccountSummariesResponse, error) {
	out := new(ListAccountSummariesResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListAccountSummaries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetProperty(ctx context.Context, in *GetPropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetProperty_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListProperties(ctx context.Context, in *ListPropertiesRequest, opts ...grpc.CallOption) (*ListPropertiesResponse, error) {
	out := new(ListPropertiesResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListProperties_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateProperty(ctx context.Context, in *CreatePropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateProperty_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteProperty(ctx context.Context, in *DeletePropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteProperty_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateProperty(ctx context.Context, in *UpdatePropertyRequest, opts ...grpc.CallOption) (*Property, error) {
	out := new(Property)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateProperty_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateFirebaseLink(ctx context.Context, in *CreateFirebaseLinkRequest, opts ...grpc.CallOption) (*FirebaseLink, error) {
	out := new(FirebaseLink)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateFirebaseLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteFirebaseLink(ctx context.Context, in *DeleteFirebaseLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteFirebaseLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListFirebaseLinks(ctx context.Context, in *ListFirebaseLinksRequest, opts ...grpc.CallOption) (*ListFirebaseLinksResponse, error) {
	out := new(ListFirebaseLinksResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListFirebaseLinks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetGlobalSiteTag(ctx context.Context, in *GetGlobalSiteTagRequest, opts ...grpc.CallOption) (*GlobalSiteTag, error) {
	out := new(GlobalSiteTag)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetGlobalSiteTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateGoogleAdsLink(ctx context.Context, in *CreateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error) {
	out := new(GoogleAdsLink)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateGoogleAdsLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateGoogleAdsLink(ctx context.Context, in *UpdateGoogleAdsLinkRequest, opts ...grpc.CallOption) (*GoogleAdsLink, error) {
	out := new(GoogleAdsLink)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateGoogleAdsLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteGoogleAdsLink(ctx context.Context, in *DeleteGoogleAdsLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteGoogleAdsLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListGoogleAdsLinks(ctx context.Context, in *ListGoogleAdsLinksRequest, opts ...grpc.CallOption) (*ListGoogleAdsLinksResponse, error) {
	out := new(ListGoogleAdsLinksResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListGoogleAdsLinks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDataSharingSettings(ctx context.Context, in *GetDataSharingSettingsRequest, opts ...grpc.CallOption) (*DataSharingSettings, error) {
	out := new(DataSharingSettings)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetDataSharingSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetMeasurementProtocolSecret(ctx context.Context, in *GetMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error) {
	out := new(MeasurementProtocolSecret)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetMeasurementProtocolSecret_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListMeasurementProtocolSecrets(ctx context.Context, in *ListMeasurementProtocolSecretsRequest, opts ...grpc.CallOption) (*ListMeasurementProtocolSecretsResponse, error) {
	out := new(ListMeasurementProtocolSecretsResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListMeasurementProtocolSecrets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateMeasurementProtocolSecret(ctx context.Context, in *CreateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error) {
	out := new(MeasurementProtocolSecret)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateMeasurementProtocolSecret_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteMeasurementProtocolSecret(ctx context.Context, in *DeleteMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteMeasurementProtocolSecret_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateMeasurementProtocolSecret(ctx context.Context, in *UpdateMeasurementProtocolSecretRequest, opts ...grpc.CallOption) (*MeasurementProtocolSecret, error) {
	out := new(MeasurementProtocolSecret)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateMeasurementProtocolSecret_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) AcknowledgeUserDataCollection(ctx context.Context, in *AcknowledgeUserDataCollectionRequest, opts ...grpc.CallOption) (*AcknowledgeUserDataCollectionResponse, error) {
	out := new(AcknowledgeUserDataCollectionResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_AcknowledgeUserDataCollection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetSKAdNetworkConversionValueSchema(ctx context.Context, in *GetSKAdNetworkConversionValueSchemaRequest, opts ...grpc.CallOption) (*SKAdNetworkConversionValueSchema, error) {
	out := new(SKAdNetworkConversionValueSchema)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetSKAdNetworkConversionValueSchema_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateSKAdNetworkConversionValueSchema(ctx context.Context, in *CreateSKAdNetworkConversionValueSchemaRequest, opts ...grpc.CallOption) (*SKAdNetworkConversionValueSchema, error) {
	out := new(SKAdNetworkConversionValueSchema)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateSKAdNetworkConversionValueSchema_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteSKAdNetworkConversionValueSchema(ctx context.Context, in *DeleteSKAdNetworkConversionValueSchemaRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteSKAdNetworkConversionValueSchema_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateSKAdNetworkConversionValueSchema(ctx context.Context, in *UpdateSKAdNetworkConversionValueSchemaRequest, opts ...grpc.CallOption) (*SKAdNetworkConversionValueSchema, error) {
	out := new(SKAdNetworkConversionValueSchema)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateSKAdNetworkConversionValueSchema_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListSKAdNetworkConversionValueSchemas(ctx context.Context, in *ListSKAdNetworkConversionValueSchemasRequest, opts ...grpc.CallOption) (*ListSKAdNetworkConversionValueSchemasResponse, error) {
	out := new(ListSKAdNetworkConversionValueSchemasResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListSKAdNetworkConversionValueSchemas_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) SearchChangeHistoryEvents(ctx context.Context, in *SearchChangeHistoryEventsRequest, opts ...grpc.CallOption) (*SearchChangeHistoryEventsResponse, error) {
	out := new(SearchChangeHistoryEventsResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_SearchChangeHistoryEvents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetGoogleSignalsSettings(ctx context.Context, in *GetGoogleSignalsSettingsRequest, opts ...grpc.CallOption) (*GoogleSignalsSettings, error) {
	out := new(GoogleSignalsSettings)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetGoogleSignalsSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateGoogleSignalsSettings(ctx context.Context, in *UpdateGoogleSignalsSettingsRequest, opts ...grpc.CallOption) (*GoogleSignalsSettings, error) {
	out := new(GoogleSignalsSettings)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateGoogleSignalsSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *analyticsAdminServiceClient) CreateConversionEvent(ctx context.Context, in *CreateConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error) {
	out := new(ConversionEvent)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateConversionEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *analyticsAdminServiceClient) UpdateConversionEvent(ctx context.Context, in *UpdateConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error) {
	out := new(ConversionEvent)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateConversionEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *analyticsAdminServiceClient) GetConversionEvent(ctx context.Context, in *GetConversionEventRequest, opts ...grpc.CallOption) (*ConversionEvent, error) {
	out := new(ConversionEvent)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetConversionEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *analyticsAdminServiceClient) DeleteConversionEvent(ctx context.Context, in *DeleteConversionEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteConversionEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *analyticsAdminServiceClient) ListConversionEvents(ctx context.Context, in *ListConversionEventsRequest, opts ...grpc.CallOption) (*ListConversionEventsResponse, error) {
	out := new(ListConversionEventsResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListConversionEvents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateKeyEvent(ctx context.Context, in *CreateKeyEventRequest, opts ...grpc.CallOption) (*KeyEvent, error) {
	out := new(KeyEvent)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateKeyEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateKeyEvent(ctx context.Context, in *UpdateKeyEventRequest, opts ...grpc.CallOption) (*KeyEvent, error) {
	out := new(KeyEvent)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateKeyEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetKeyEvent(ctx context.Context, in *GetKeyEventRequest, opts ...grpc.CallOption) (*KeyEvent, error) {
	out := new(KeyEvent)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetKeyEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteKeyEvent(ctx context.Context, in *DeleteKeyEventRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteKeyEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListKeyEvents(ctx context.Context, in *ListKeyEventsRequest, opts ...grpc.CallOption) (*ListKeyEventsResponse, error) {
	out := new(ListKeyEventsResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListKeyEvents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDisplayVideo360AdvertiserLink(ctx context.Context, in *GetDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error) {
	out := new(DisplayVideo360AdvertiserLink)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetDisplayVideo360AdvertiserLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListDisplayVideo360AdvertiserLinks(ctx context.Context, in *ListDisplayVideo360AdvertiserLinksRequest, opts ...grpc.CallOption) (*ListDisplayVideo360AdvertiserLinksResponse, error) {
	out := new(ListDisplayVideo360AdvertiserLinksResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListDisplayVideo360AdvertiserLinks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateDisplayVideo360AdvertiserLink(ctx context.Context, in *CreateDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error) {
	out := new(DisplayVideo360AdvertiserLink)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateDisplayVideo360AdvertiserLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteDisplayVideo360AdvertiserLink(ctx context.Context, in *DeleteDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteDisplayVideo360AdvertiserLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateDisplayVideo360AdvertiserLink(ctx context.Context, in *UpdateDisplayVideo360AdvertiserLinkRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLink, error) {
	out := new(DisplayVideo360AdvertiserLink)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateDisplayVideo360AdvertiserLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *GetDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error) {
	out := new(DisplayVideo360AdvertiserLinkProposal)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetDisplayVideo360AdvertiserLinkProposal_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListDisplayVideo360AdvertiserLinkProposals(ctx context.Context, in *ListDisplayVideo360AdvertiserLinkProposalsRequest, opts ...grpc.CallOption) (*ListDisplayVideo360AdvertiserLinkProposalsResponse, error) {
	out := new(ListDisplayVideo360AdvertiserLinkProposalsResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListDisplayVideo360AdvertiserLinkProposals_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *CreateDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error) {
	out := new(DisplayVideo360AdvertiserLinkProposal)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateDisplayVideo360AdvertiserLinkProposal_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *DeleteDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteDisplayVideo360AdvertiserLinkProposal_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ApproveDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *ApproveDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*ApproveDisplayVideo360AdvertiserLinkProposalResponse, error) {
	out := new(ApproveDisplayVideo360AdvertiserLinkProposalResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ApproveDisplayVideo360AdvertiserLinkProposal_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CancelDisplayVideo360AdvertiserLinkProposal(ctx context.Context, in *CancelDisplayVideo360AdvertiserLinkProposalRequest, opts ...grpc.CallOption) (*DisplayVideo360AdvertiserLinkProposal, error) {
	out := new(DisplayVideo360AdvertiserLinkProposal)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CancelDisplayVideo360AdvertiserLinkProposal_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateCustomDimension(ctx context.Context, in *CreateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error) {
	out := new(CustomDimension)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateCustomDimension_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateCustomDimension(ctx context.Context, in *UpdateCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error) {
	out := new(CustomDimension)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateCustomDimension_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListCustomDimensions(ctx context.Context, in *ListCustomDimensionsRequest, opts ...grpc.CallOption) (*ListCustomDimensionsResponse, error) {
	out := new(ListCustomDimensionsResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListCustomDimensions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ArchiveCustomDimension(ctx context.Context, in *ArchiveCustomDimensionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ArchiveCustomDimension_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetCustomDimension(ctx context.Context, in *GetCustomDimensionRequest, opts ...grpc.CallOption) (*CustomDimension, error) {
	out := new(CustomDimension)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetCustomDimension_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateCustomMetric(ctx context.Context, in *CreateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error) {
	out := new(CustomMetric)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateCustomMetric_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateCustomMetric(ctx context.Context, in *UpdateCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error) {
	out := new(CustomMetric)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateCustomMetric_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListCustomMetrics(ctx context.Context, in *ListCustomMetricsRequest, opts ...grpc.CallOption) (*ListCustomMetricsResponse, error) {
	out := new(ListCustomMetricsResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListCustomMetrics_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ArchiveCustomMetric(ctx context.Context, in *ArchiveCustomMetricRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ArchiveCustomMetric_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetCustomMetric(ctx context.Context, in *GetCustomMetricRequest, opts ...grpc.CallOption) (*CustomMetric, error) {
	out := new(CustomMetric)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetCustomMetric_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDataRetentionSettings(ctx context.Context, in *GetDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error) {
	out := new(DataRetentionSettings)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetDataRetentionSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateDataRetentionSettings(ctx context.Context, in *UpdateDataRetentionSettingsRequest, opts ...grpc.CallOption) (*DataRetentionSettings, error) {
	out := new(DataRetentionSettings)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateDataRetentionSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateDataStream(ctx context.Context, in *CreateDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error) {
	out := new(DataStream)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateDataStream_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteDataStream(ctx context.Context, in *DeleteDataStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteDataStream_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateDataStream(ctx context.Context, in *UpdateDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error) {
	out := new(DataStream)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateDataStream_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListDataStreams(ctx context.Context, in *ListDataStreamsRequest, opts ...grpc.CallOption) (*ListDataStreamsResponse, error) {
	out := new(ListDataStreamsResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListDataStreams_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDataStream(ctx context.Context, in *GetDataStreamRequest, opts ...grpc.CallOption) (*DataStream, error) {
	out := new(DataStream)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetDataStream_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetAudience(ctx context.Context, in *GetAudienceRequest, opts ...grpc.CallOption) (*Audience, error) {
	out := new(Audience)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetAudience_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListAudiences(ctx context.Context, in *ListAudiencesRequest, opts ...grpc.CallOption) (*ListAudiencesResponse, error) {
	out := new(ListAudiencesResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListAudiences_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateAudience(ctx context.Context, in *CreateAudienceRequest, opts ...grpc.CallOption) (*Audience, error) {
	out := new(Audience)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateAudience_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateAudience(ctx context.Context, in *UpdateAudienceRequest, opts ...grpc.CallOption) (*Audience, error) {
	out := new(Audience)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateAudience_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ArchiveAudience(ctx context.Context, in *ArchiveAudienceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ArchiveAudience_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetSearchAds360Link(ctx context.Context, in *GetSearchAds360LinkRequest, opts ...grpc.CallOption) (*SearchAds360Link, error) {
	out := new(SearchAds360Link)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetSearchAds360Link_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListSearchAds360Links(ctx context.Context, in *ListSearchAds360LinksRequest, opts ...grpc.CallOption) (*ListSearchAds360LinksResponse, error) {
	out := new(ListSearchAds360LinksResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListSearchAds360Links_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateSearchAds360Link(ctx context.Context, in *CreateSearchAds360LinkRequest, opts ...grpc.CallOption) (*SearchAds360Link, error) {
	out := new(SearchAds360Link)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateSearchAds360Link_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteSearchAds360Link(ctx context.Context, in *DeleteSearchAds360LinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteSearchAds360Link_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateSearchAds360Link(ctx context.Context, in *UpdateSearchAds360LinkRequest, opts ...grpc.CallOption) (*SearchAds360Link, error) {
	out := new(SearchAds360Link)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateSearchAds360Link_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetAttributionSettings(ctx context.Context, in *GetAttributionSettingsRequest, opts ...grpc.CallOption) (*AttributionSettings, error) {
	out := new(AttributionSettings)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetAttributionSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateAttributionSettings(ctx context.Context, in *UpdateAttributionSettingsRequest, opts ...grpc.CallOption) (*AttributionSettings, error) {
	out := new(AttributionSettings)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateAttributionSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) RunAccessReport(ctx context.Context, in *RunAccessReportRequest, opts ...grpc.CallOption) (*RunAccessReportResponse, error) {
	out := new(RunAccessReportResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_RunAccessReport_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateAccessBinding(ctx context.Context, in *CreateAccessBindingRequest, opts ...grpc.CallOption) (*AccessBinding, error) {
	out := new(AccessBinding)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateAccessBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetAccessBinding(ctx context.Context, in *GetAccessBindingRequest, opts ...grpc.CallOption) (*AccessBinding, error) {
	out := new(AccessBinding)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetAccessBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateAccessBinding(ctx context.Context, in *UpdateAccessBindingRequest, opts ...grpc.CallOption) (*AccessBinding, error) {
	out := new(AccessBinding)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateAccessBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteAccessBinding(ctx context.Context, in *DeleteAccessBindingRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteAccessBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListAccessBindings(ctx context.Context, in *ListAccessBindingsRequest, opts ...grpc.CallOption) (*ListAccessBindingsResponse, error) {
	out := new(ListAccessBindingsResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListAccessBindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) BatchCreateAccessBindings(ctx context.Context, in *BatchCreateAccessBindingsRequest, opts ...grpc.CallOption) (*BatchCreateAccessBindingsResponse, error) {
	out := new(BatchCreateAccessBindingsResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_BatchCreateAccessBindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) BatchGetAccessBindings(ctx context.Context, in *BatchGetAccessBindingsRequest, opts ...grpc.CallOption) (*BatchGetAccessBindingsResponse, error) {
	out := new(BatchGetAccessBindingsResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_BatchGetAccessBindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) BatchUpdateAccessBindings(ctx context.Context, in *BatchUpdateAccessBindingsRequest, opts ...grpc.CallOption) (*BatchUpdateAccessBindingsResponse, error) {
	out := new(BatchUpdateAccessBindingsResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_BatchUpdateAccessBindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) BatchDeleteAccessBindings(ctx context.Context, in *BatchDeleteAccessBindingsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_BatchDeleteAccessBindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetExpandedDataSet(ctx context.Context, in *GetExpandedDataSetRequest, opts ...grpc.CallOption) (*ExpandedDataSet, error) {
	out := new(ExpandedDataSet)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetExpandedDataSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListExpandedDataSets(ctx context.Context, in *ListExpandedDataSetsRequest, opts ...grpc.CallOption) (*ListExpandedDataSetsResponse, error) {
	out := new(ListExpandedDataSetsResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListExpandedDataSets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateExpandedDataSet(ctx context.Context, in *CreateExpandedDataSetRequest, opts ...grpc.CallOption) (*ExpandedDataSet, error) {
	out := new(ExpandedDataSet)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateExpandedDataSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateExpandedDataSet(ctx context.Context, in *UpdateExpandedDataSetRequest, opts ...grpc.CallOption) (*ExpandedDataSet, error) {
	out := new(ExpandedDataSet)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateExpandedDataSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteExpandedDataSet(ctx context.Context, in *DeleteExpandedDataSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteExpandedDataSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetChannelGroup(ctx context.Context, in *GetChannelGroupRequest, opts ...grpc.CallOption) (*ChannelGroup, error) {
	out := new(ChannelGroup)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetChannelGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListChannelGroups(ctx context.Context, in *ListChannelGroupsRequest, opts ...grpc.CallOption) (*ListChannelGroupsResponse, error) {
	out := new(ListChannelGroupsResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListChannelGroups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateChannelGroup(ctx context.Context, in *CreateChannelGroupRequest, opts ...grpc.CallOption) (*ChannelGroup, error) {
	out := new(ChannelGroup)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateChannelGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateChannelGroup(ctx context.Context, in *UpdateChannelGroupRequest, opts ...grpc.CallOption) (*ChannelGroup, error) {
	out := new(ChannelGroup)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateChannelGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteChannelGroup(ctx context.Context, in *DeleteChannelGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteChannelGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) SetAutomatedGa4ConfigurationOptOut(ctx context.Context, in *SetAutomatedGa4ConfigurationOptOutRequest, opts ...grpc.CallOption) (*SetAutomatedGa4ConfigurationOptOutResponse, error) {
	out := new(SetAutomatedGa4ConfigurationOptOutResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_SetAutomatedGa4ConfigurationOptOut_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) FetchAutomatedGa4ConfigurationOptOut(ctx context.Context, in *FetchAutomatedGa4ConfigurationOptOutRequest, opts ...grpc.CallOption) (*FetchAutomatedGa4ConfigurationOptOutResponse, error) {
	out := new(FetchAutomatedGa4ConfigurationOptOutResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_FetchAutomatedGa4ConfigurationOptOut_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateBigQueryLink(ctx context.Context, in *CreateBigQueryLinkRequest, opts ...grpc.CallOption) (*BigQueryLink, error) {
	out := new(BigQueryLink)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateBigQueryLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetBigQueryLink(ctx context.Context, in *GetBigQueryLinkRequest, opts ...grpc.CallOption) (*BigQueryLink, error) {
	out := new(BigQueryLink)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetBigQueryLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListBigQueryLinks(ctx context.Context, in *ListBigQueryLinksRequest, opts ...grpc.CallOption) (*ListBigQueryLinksResponse, error) {
	out := new(ListBigQueryLinksResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListBigQueryLinks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteBigQueryLink(ctx context.Context, in *DeleteBigQueryLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteBigQueryLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateBigQueryLink(ctx context.Context, in *UpdateBigQueryLinkRequest, opts ...grpc.CallOption) (*BigQueryLink, error) {
	out := new(BigQueryLink)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateBigQueryLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetEnhancedMeasurementSettings(ctx context.Context, in *GetEnhancedMeasurementSettingsRequest, opts ...grpc.CallOption) (*EnhancedMeasurementSettings, error) {
	out := new(EnhancedMeasurementSettings)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetEnhancedMeasurementSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateEnhancedMeasurementSettings(ctx context.Context, in *UpdateEnhancedMeasurementSettingsRequest, opts ...grpc.CallOption) (*EnhancedMeasurementSettings, error) {
	out := new(EnhancedMeasurementSettings)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateEnhancedMeasurementSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateConnectedSiteTag(ctx context.Context, in *CreateConnectedSiteTagRequest, opts ...grpc.CallOption) (*CreateConnectedSiteTagResponse, error) {
	out := new(CreateConnectedSiteTagResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateConnectedSiteTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteConnectedSiteTag(ctx context.Context, in *DeleteConnectedSiteTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteConnectedSiteTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListConnectedSiteTags(ctx context.Context, in *ListConnectedSiteTagsRequest, opts ...grpc.CallOption) (*ListConnectedSiteTagsResponse, error) {
	out := new(ListConnectedSiteTagsResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListConnectedSiteTags_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) FetchConnectedGa4Property(ctx context.Context, in *FetchConnectedGa4PropertyRequest, opts ...grpc.CallOption) (*FetchConnectedGa4PropertyResponse, error) {
	out := new(FetchConnectedGa4PropertyResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_FetchConnectedGa4Property_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetAdSenseLink(ctx context.Context, in *GetAdSenseLinkRequest, opts ...grpc.CallOption) (*AdSenseLink, error) {
	out := new(AdSenseLink)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetAdSenseLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateAdSenseLink(ctx context.Context, in *CreateAdSenseLinkRequest, opts ...grpc.CallOption) (*AdSenseLink, error) {
	out := new(AdSenseLink)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateAdSenseLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteAdSenseLink(ctx context.Context, in *DeleteAdSenseLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteAdSenseLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListAdSenseLinks(ctx context.Context, in *ListAdSenseLinksRequest, opts ...grpc.CallOption) (*ListAdSenseLinksResponse, error) {
	out := new(ListAdSenseLinksResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListAdSenseLinks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetEventCreateRule(ctx context.Context, in *GetEventCreateRuleRequest, opts ...grpc.CallOption) (*EventCreateRule, error) {
	out := new(EventCreateRule)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetEventCreateRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListEventCreateRules(ctx context.Context, in *ListEventCreateRulesRequest, opts ...grpc.CallOption) (*ListEventCreateRulesResponse, error) {
	out := new(ListEventCreateRulesResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListEventCreateRules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateEventCreateRule(ctx context.Context, in *CreateEventCreateRuleRequest, opts ...grpc.CallOption) (*EventCreateRule, error) {
	out := new(EventCreateRule)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateEventCreateRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateEventCreateRule(ctx context.Context, in *UpdateEventCreateRuleRequest, opts ...grpc.CallOption) (*EventCreateRule, error) {
	out := new(EventCreateRule)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateEventCreateRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteEventCreateRule(ctx context.Context, in *DeleteEventCreateRuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteEventCreateRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetEventEditRule(ctx context.Context, in *GetEventEditRuleRequest, opts ...grpc.CallOption) (*EventEditRule, error) {
	out := new(EventEditRule)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetEventEditRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListEventEditRules(ctx context.Context, in *ListEventEditRulesRequest, opts ...grpc.CallOption) (*ListEventEditRulesResponse, error) {
	out := new(ListEventEditRulesResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListEventEditRules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateEventEditRule(ctx context.Context, in *CreateEventEditRuleRequest, opts ...grpc.CallOption) (*EventEditRule, error) {
	out := new(EventEditRule)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateEventEditRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateEventEditRule(ctx context.Context, in *UpdateEventEditRuleRequest, opts ...grpc.CallOption) (*EventEditRule, error) {
	out := new(EventEditRule)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateEventEditRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteEventEditRule(ctx context.Context, in *DeleteEventEditRuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteEventEditRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ReorderEventEditRules(ctx context.Context, in *ReorderEventEditRulesRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ReorderEventEditRules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateDataRedactionSettings(ctx context.Context, in *UpdateDataRedactionSettingsRequest, opts ...grpc.CallOption) (*DataRedactionSettings, error) {
	out := new(DataRedactionSettings)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateDataRedactionSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetDataRedactionSettings(ctx context.Context, in *GetDataRedactionSettingsRequest, opts ...grpc.CallOption) (*DataRedactionSettings, error) {
	out := new(DataRedactionSettings)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetDataRedactionSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetCalculatedMetric(ctx context.Context, in *GetCalculatedMetricRequest, opts ...grpc.CallOption) (*CalculatedMetric, error) {
	out := new(CalculatedMetric)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetCalculatedMetric_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateCalculatedMetric(ctx context.Context, in *CreateCalculatedMetricRequest, opts ...grpc.CallOption) (*CalculatedMetric, error) {
	out := new(CalculatedMetric)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateCalculatedMetric_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListCalculatedMetrics(ctx context.Context, in *ListCalculatedMetricsRequest, opts ...grpc.CallOption) (*ListCalculatedMetricsResponse, error) {
	out := new(ListCalculatedMetricsResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListCalculatedMetrics_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateCalculatedMetric(ctx context.Context, in *UpdateCalculatedMetricRequest, opts ...grpc.CallOption) (*CalculatedMetric, error) {
	out := new(CalculatedMetric)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateCalculatedMetric_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteCalculatedMetric(ctx context.Context, in *DeleteCalculatedMetricRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteCalculatedMetric_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateRollupProperty(ctx context.Context, in *CreateRollupPropertyRequest, opts ...grpc.CallOption) (*CreateRollupPropertyResponse, error) {
	out := new(CreateRollupPropertyResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateRollupProperty_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetRollupPropertySourceLink(ctx context.Context, in *GetRollupPropertySourceLinkRequest, opts ...grpc.CallOption) (*RollupPropertySourceLink, error) {
	out := new(RollupPropertySourceLink)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetRollupPropertySourceLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListRollupPropertySourceLinks(ctx context.Context, in *ListRollupPropertySourceLinksRequest, opts ...grpc.CallOption) (*ListRollupPropertySourceLinksResponse, error) {
	out := new(ListRollupPropertySourceLinksResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListRollupPropertySourceLinks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateRollupPropertySourceLink(ctx context.Context, in *CreateRollupPropertySourceLinkRequest, opts ...grpc.CallOption) (*RollupPropertySourceLink, error) {
	out := new(RollupPropertySourceLink)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateRollupPropertySourceLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteRollupPropertySourceLink(ctx context.Context, in *DeleteRollupPropertySourceLinkRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteRollupPropertySourceLink_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ProvisionSubproperty(ctx context.Context, in *ProvisionSubpropertyRequest, opts ...grpc.CallOption) (*ProvisionSubpropertyResponse, error) {
	out := new(ProvisionSubpropertyResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ProvisionSubproperty_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateSubpropertyEventFilter(ctx context.Context, in *CreateSubpropertyEventFilterRequest, opts ...grpc.CallOption) (*SubpropertyEventFilter, error) {
	out := new(SubpropertyEventFilter)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateSubpropertyEventFilter_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetSubpropertyEventFilter(ctx context.Context, in *GetSubpropertyEventFilterRequest, opts ...grpc.CallOption) (*SubpropertyEventFilter, error) {
	out := new(SubpropertyEventFilter)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetSubpropertyEventFilter_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListSubpropertyEventFilters(ctx context.Context, in *ListSubpropertyEventFiltersRequest, opts ...grpc.CallOption) (*ListSubpropertyEventFiltersResponse, error) {
	out := new(ListSubpropertyEventFiltersResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListSubpropertyEventFilters_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateSubpropertyEventFilter(ctx context.Context, in *UpdateSubpropertyEventFilterRequest, opts ...grpc.CallOption) (*SubpropertyEventFilter, error) {
	out := new(SubpropertyEventFilter)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateSubpropertyEventFilter_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteSubpropertyEventFilter(ctx context.Context, in *DeleteSubpropertyEventFilterRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteSubpropertyEventFilter_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) CreateReportingDataAnnotation(ctx context.Context, in *CreateReportingDataAnnotationRequest, opts ...grpc.CallOption) (*ReportingDataAnnotation, error) {
	out := new(ReportingDataAnnotation)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_CreateReportingDataAnnotation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) GetReportingDataAnnotation(ctx context.Context, in *GetReportingDataAnnotationRequest, opts ...grpc.CallOption) (*ReportingDataAnnotation, error) {
	out := new(ReportingDataAnnotation)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_GetReportingDataAnnotation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) ListReportingDataAnnotations(ctx context.Context, in *ListReportingDataAnnotationsRequest, opts ...grpc.CallOption) (*ListReportingDataAnnotationsResponse, error) {
	out := new(ListReportingDataAnnotationsResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_ListReportingDataAnnotations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) UpdateReportingDataAnnotation(ctx context.Context, in *UpdateReportingDataAnnotationRequest, opts ...grpc.CallOption) (*ReportingDataAnnotation, error) {
	out := new(ReportingDataAnnotation)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_UpdateReportingDataAnnotation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) DeleteReportingDataAnnotation(ctx context.Context, in *DeleteReportingDataAnnotationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_DeleteReportingDataAnnotation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *analyticsAdminServiceClient) SubmitUserDeletion(ctx context.Context, in *SubmitUserDeletionRequest, opts ...grpc.CallOption) (*SubmitUserDeletionResponse, error) {
	out := new(SubmitUserDeletionResponse)
	err := c.cc.Invoke(ctx, AnalyticsAdminService_SubmitUserDeletion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AnalyticsAdminServiceServer is the server API for AnalyticsAdminService service.
// All implementations should embed UnimplementedAnalyticsAdminServiceServer
// for forward compatibility
type AnalyticsAdminServiceServer interface {
	// Lookup for a single Account.
	GetAccount(context.Context, *GetAccountRequest) (*Account, error)
	// Returns all accounts accessible by the caller.
	//
	// Note that these accounts might not currently have GA properties.
	// Soft-deleted (ie: "trashed") accounts are excluded by default.
	// Returns an empty list if no relevant accounts are found.
	ListAccounts(context.Context, *ListAccountsRequest) (*ListAccountsResponse, error)
	// Marks target Account as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted accounts.
	// However, they can be restored using the Trash Can UI.
	//
	// If the accounts are not restored before the expiration time, the account
	// and all child resources (eg: Properties, GoogleAdsLinks, Streams,
	// AccessBindings) will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found.
	DeleteAccount(context.Context, *DeleteAccountRequest) (*emptypb.Empty, error)
	// Updates an account.
	UpdateAccount(context.Context, *UpdateAccountRequest) (*Account, error)
	// Requests a ticket for creating an account.
	ProvisionAccountTicket(context.Context, *ProvisionAccountTicketRequest) (*ProvisionAccountTicketResponse, error)
	// Returns summaries of all accounts accessible by the caller.
	ListAccountSummaries(context.Context, *ListAccountSummariesRequest) (*ListAccountSummariesResponse, error)
	// Lookup for a single GA Property.
	GetProperty(context.Context, *GetPropertyRequest) (*Property, error)
	// Returns child Properties under the specified parent Account.
	//
	// Properties will be excluded if the caller does not have access.
	// Soft-deleted (ie: "trashed") properties are excluded by default.
	// Returns an empty list if no relevant properties are found.
	ListProperties(context.Context, *ListPropertiesRequest) (*ListPropertiesResponse, error)
	// Creates a Google Analytics property with the specified location and
	// attributes.
	CreateProperty(context.Context, *CreatePropertyRequest) (*Property, error)
	// Marks target Property as soft-deleted (ie: "trashed") and returns it.
	//
	// This API does not have a method to restore soft-deleted properties.
	// However, they can be restored using the Trash Can UI.
	//
	// If the properties are not restored before the expiration time, the Property
	// and all child resources (eg: GoogleAdsLinks, Streams, AccessBindings)
	// will be permanently purged.
	// https://support.google.com/analytics/answer/6154772
	//
	// Returns an error if the target is not found.
	DeleteProperty(context.Context, *DeletePropertyRequest) (*Property, error)
	// Updates a property.
	UpdateProperty(context.Context, *UpdatePropertyRequest) (*Property, error)
	// Creates a FirebaseLink.
	//
	// Properties can have at most one FirebaseLink.
	CreateFirebaseLink(context.Context, *CreateFirebaseLinkRequest) (*FirebaseLink, error)
	// Deletes a FirebaseLink on a property
	DeleteFirebaseLink(context.Context, *DeleteFirebaseLinkRequest) (*emptypb.Empty, error)
	// Lists FirebaseLinks on a property.
	// Properties can have at most one FirebaseLink.
	ListFirebaseLinks(context.Context, *ListFirebaseLinksRequest) (*ListFirebaseLinksResponse, error)
	// Returns the Site Tag for the specified web stream.
	// Site Tags are immutable singletons.
	GetGlobalSiteTag(context.Context, *GetGlobalSiteTagRequest) (*GlobalSiteTag, error)
	// Creates a GoogleAdsLink.
	CreateGoogleAdsLink(context.Context, *CreateGoogleAdsLinkRequest) (*GoogleAdsLink, error)
	// Updates a GoogleAdsLink on a property
	UpdateGoogleAdsLink(context.Context, *UpdateGoogleAdsLinkRequest) (*GoogleAdsLink, error)
	// Deletes a GoogleAdsLink on a property
	DeleteGoogleAdsLink(context.Context, *DeleteGoogleAdsLinkRequest) (*emptypb.Empty, error)
	// Lists GoogleAdsLinks on a property.
	ListGoogleAdsLinks(context.Context, *ListGoogleAdsLinksRequest) (*ListGoogleAdsLinksResponse, error)
	// Get data sharing settings on an account.
	// Data sharing settings are singletons.
	GetDataSharingSettings(context.Context, *GetDataSharingSettingsRequest) (*DataSharingSettings, error)
	// Lookup for a single MeasurementProtocolSecret.
	GetMeasurementProtocolSecret(context.Context, *GetMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error)
	// Returns child MeasurementProtocolSecrets under the specified parent
	// Property.
	ListMeasurementProtocolSecrets(context.Context, *ListMeasurementProtocolSecretsRequest) (*ListMeasurementProtocolSecretsResponse, error)
	// Creates a measurement protocol secret.
	CreateMeasurementProtocolSecret(context.Context, *CreateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error)
	// Deletes target MeasurementProtocolSecret.
	DeleteMeasurementProtocolSecret(context.Context, *DeleteMeasurementProtocolSecretRequest) (*emptypb.Empty, error)
	// Updates a measurement protocol secret.
	UpdateMeasurementProtocolSecret(context.Context, *UpdateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error)
	// Acknowledges the terms of user data collection for the specified property.
	//
	// This acknowledgement must be completed (either in the Google Analytics UI
	// or through this API) before MeasurementProtocolSecret resources may be
	// created.
	AcknowledgeUserDataCollection(context.Context, *AcknowledgeUserDataCollectionRequest) (*AcknowledgeUserDataCollectionResponse, error)
	// Looks up a single SKAdNetworkConversionValueSchema.
	GetSKAdNetworkConversionValueSchema(context.Context, *GetSKAdNetworkConversionValueSchemaRequest) (*SKAdNetworkConversionValueSchema, error)
	// Creates a SKAdNetworkConversionValueSchema.
	CreateSKAdNetworkConversionValueSchema(context.Context, *CreateSKAdNetworkConversionValueSchemaRequest) (*SKAdNetworkConversionValueSchema, error)
	// Deletes target SKAdNetworkConversionValueSchema.
	DeleteSKAdNetworkConversionValueSchema(context.Context, *DeleteSKAdNetworkConversionValueSchemaRequest) (*emptypb.Empty, error)
	// Updates a SKAdNetworkConversionValueSchema.
	UpdateSKAdNetworkConversionValueSchema(context.Context, *UpdateSKAdNetworkConversionValueSchemaRequest) (*SKAdNetworkConversionValueSchema, error)
	// Lists SKAdNetworkConversionValueSchema on a stream.
	// Properties can have at most one SKAdNetworkConversionValueSchema.
	ListSKAdNetworkConversionValueSchemas(context.Context, *ListSKAdNetworkConversionValueSchemasRequest) (*ListSKAdNetworkConversionValueSchemasResponse, error)
	// Searches through all changes to an account or its children given the
	// specified set of filters.
	//
	// Only returns the subset of changes supported by the API. The UI may return
	// additional changes.
	SearchChangeHistoryEvents(context.Context, *SearchChangeHistoryEventsRequest) (*SearchChangeHistoryEventsResponse, error)
	// Lookup for Google Signals settings for a property.
	GetGoogleSignalsSettings(context.Context, *GetGoogleSignalsSettingsRequest) (*GoogleSignalsSettings, error)
	// Updates Google Signals settings for a property.
	UpdateGoogleSignalsSettings(context.Context, *UpdateGoogleSignalsSettingsRequest) (*GoogleSignalsSettings, error)
	// Deprecated: Do not use.
	// Deprecated: Use `CreateKeyEvent` instead.
	// Creates a conversion event with the specified attributes.
	CreateConversionEvent(context.Context, *CreateConversionEventRequest) (*ConversionEvent, error)
	// Deprecated: Do not use.
	// Deprecated: Use `UpdateKeyEvent` instead.
	// Updates a conversion event with the specified attributes.
	UpdateConversionEvent(context.Context, *UpdateConversionEventRequest) (*ConversionEvent, error)
	// Deprecated: Do not use.
	// Deprecated: Use `GetKeyEvent` instead.
	// Retrieve a single conversion event.
	GetConversionEvent(context.Context, *GetConversionEventRequest) (*ConversionEvent, error)
	// Deprecated: Do not use.
	// Deprecated: Use `DeleteKeyEvent` instead.
	// Deletes a conversion event in a property.
	DeleteConversionEvent(context.Context, *DeleteConversionEventRequest) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Deprecated: Use `ListKeyEvents` instead.
	// Returns a list of conversion events in the specified parent property.
	//
	// Returns an empty list if no conversion events are found.
	ListConversionEvents(context.Context, *ListConversionEventsRequest) (*ListConversionEventsResponse, error)
	// Creates a Key Event.
	CreateKeyEvent(context.Context, *CreateKeyEventRequest) (*KeyEvent, error)
	// Updates a Key Event.
	UpdateKeyEvent(context.Context, *UpdateKeyEventRequest) (*KeyEvent, error)
	// Retrieve a single Key Event.
	GetKeyEvent(context.Context, *GetKeyEventRequest) (*KeyEvent, error)
	// Deletes a Key Event.
	DeleteKeyEvent(context.Context, *DeleteKeyEventRequest) (*emptypb.Empty, error)
	// Returns a list of Key Events in the specified parent property.
	// Returns an empty list if no Key Events are found.
	ListKeyEvents(context.Context, *ListKeyEventsRequest) (*ListKeyEventsResponse, error)
	// Look up a single DisplayVideo360AdvertiserLink
	GetDisplayVideo360AdvertiserLink(context.Context, *GetDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error)
	// Lists all DisplayVideo360AdvertiserLinks on a property.
	ListDisplayVideo360AdvertiserLinks(context.Context, *ListDisplayVideo360AdvertiserLinksRequest) (*ListDisplayVideo360AdvertiserLinksResponse, error)
	// Creates a DisplayVideo360AdvertiserLink.
	// This can only be utilized by users who have proper authorization both on
	// the Google Analytics property and on the Display & Video 360 advertiser.
	// Users who do not have access to the Display & Video 360 advertiser should
	// instead seek to create a DisplayVideo360LinkProposal.
	CreateDisplayVideo360AdvertiserLink(context.Context, *CreateDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error)
	// Deletes a DisplayVideo360AdvertiserLink on a property.
	DeleteDisplayVideo360AdvertiserLink(context.Context, *DeleteDisplayVideo360AdvertiserLinkRequest) (*emptypb.Empty, error)
	// Updates a DisplayVideo360AdvertiserLink on a property.
	UpdateDisplayVideo360AdvertiserLink(context.Context, *UpdateDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error)
	// Lookup for a single DisplayVideo360AdvertiserLinkProposal.
	GetDisplayVideo360AdvertiserLinkProposal(context.Context, *GetDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Lists DisplayVideo360AdvertiserLinkProposals on a property.
	ListDisplayVideo360AdvertiserLinkProposals(context.Context, *ListDisplayVideo360AdvertiserLinkProposalsRequest) (*ListDisplayVideo360AdvertiserLinkProposalsResponse, error)
	// Creates a DisplayVideo360AdvertiserLinkProposal.
	CreateDisplayVideo360AdvertiserLinkProposal(context.Context, *CreateDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Deletes a DisplayVideo360AdvertiserLinkProposal on a property.
	// This can only be used on cancelled proposals.
	DeleteDisplayVideo360AdvertiserLinkProposal(context.Context, *DeleteDisplayVideo360AdvertiserLinkProposalRequest) (*emptypb.Empty, error)
	// Approves a DisplayVideo360AdvertiserLinkProposal.
	// The DisplayVideo360AdvertiserLinkProposal will be deleted and a new
	// DisplayVideo360AdvertiserLink will be created.
	ApproveDisplayVideo360AdvertiserLinkProposal(context.Context, *ApproveDisplayVideo360AdvertiserLinkProposalRequest) (*ApproveDisplayVideo360AdvertiserLinkProposalResponse, error)
	// Cancels a DisplayVideo360AdvertiserLinkProposal.
	// Cancelling can mean either:
	// - Declining a proposal initiated from Display & Video 360
	// - Withdrawing a proposal initiated from Google Analytics
	// After being cancelled, a proposal will eventually be deleted automatically.
	CancelDisplayVideo360AdvertiserLinkProposal(context.Context, *CancelDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error)
	// Creates a CustomDimension.
	CreateCustomDimension(context.Context, *CreateCustomDimensionRequest) (*CustomDimension, error)
	// Updates a CustomDimension on a property.
	UpdateCustomDimension(context.Context, *UpdateCustomDimensionRequest) (*CustomDimension, error)
	// Lists CustomDimensions on a property.
	ListCustomDimensions(context.Context, *ListCustomDimensionsRequest) (*ListCustomDimensionsResponse, error)
	// Archives a CustomDimension on a property.
	ArchiveCustomDimension(context.Context, *ArchiveCustomDimensionRequest) (*emptypb.Empty, error)
	// Lookup for a single CustomDimension.
	GetCustomDimension(context.Context, *GetCustomDimensionRequest) (*CustomDimension, error)
	// Creates a CustomMetric.
	CreateCustomMetric(context.Context, *CreateCustomMetricRequest) (*CustomMetric, error)
	// Updates a CustomMetric on a property.
	UpdateCustomMetric(context.Context, *UpdateCustomMetricRequest) (*CustomMetric, error)
	// Lists CustomMetrics on a property.
	ListCustomMetrics(context.Context, *ListCustomMetricsRequest) (*ListCustomMetricsResponse, error)
	// Archives a CustomMetric on a property.
	ArchiveCustomMetric(context.Context, *ArchiveCustomMetricRequest) (*emptypb.Empty, error)
	// Lookup for a single CustomMetric.
	GetCustomMetric(context.Context, *GetCustomMetricRequest) (*CustomMetric, error)
	// Returns the singleton data retention settings for this property.
	GetDataRetentionSettings(context.Context, *GetDataRetentionSettingsRequest) (*DataRetentionSettings, error)
	// Updates the singleton data retention settings for this property.
	UpdateDataRetentionSettings(context.Context, *UpdateDataRetentionSettingsRequest) (*DataRetentionSettings, error)
	// Creates a DataStream.
	CreateDataStream(context.Context, *CreateDataStreamRequest) (*DataStream, error)
	// Deletes a DataStream on a property.
	DeleteDataStream(context.Context, *DeleteDataStreamRequest) (*emptypb.Empty, error)
	// Updates a DataStream on a property.
	UpdateDataStream(context.Context, *UpdateDataStreamRequest) (*DataStream, error)
	// Lists DataStreams on a property.
	ListDataStreams(context.Context, *ListDataStreamsRequest) (*ListDataStreamsResponse, error)
	// Lookup for a single DataStream.
	GetDataStream(context.Context, *GetDataStreamRequest) (*DataStream, error)
	// Lookup for a single Audience.
	// Audiences created before 2020 may not be supported.
	// Default audiences will not show filter definitions.
	GetAudience(context.Context, *GetAudienceRequest) (*Audience, error)
	// Lists Audiences on a property.
	// Audiences created before 2020 may not be supported.
	// Default audiences will not show filter definitions.
	ListAudiences(context.Context, *ListAudiencesRequest) (*ListAudiencesResponse, error)
	// Creates an Audience.
	CreateAudience(context.Context, *CreateAudienceRequest) (*Audience, error)
	// Updates an Audience on a property.
	UpdateAudience(context.Context, *UpdateAudienceRequest) (*Audience, error)
	// Archives an Audience on a property.
	ArchiveAudience(context.Context, *ArchiveAudienceRequest) (*emptypb.Empty, error)
	// Look up a single SearchAds360Link
	GetSearchAds360Link(context.Context, *GetSearchAds360LinkRequest) (*SearchAds360Link, error)
	// Lists all SearchAds360Links on a property.
	ListSearchAds360Links(context.Context, *ListSearchAds360LinksRequest) (*ListSearchAds360LinksResponse, error)
	// Creates a SearchAds360Link.
	CreateSearchAds360Link(context.Context, *CreateSearchAds360LinkRequest) (*SearchAds360Link, error)
	// Deletes a SearchAds360Link on a property.
	DeleteSearchAds360Link(context.Context, *DeleteSearchAds360LinkRequest) (*emptypb.Empty, error)
	// Updates a SearchAds360Link on a property.
	UpdateSearchAds360Link(context.Context, *UpdateSearchAds360LinkRequest) (*SearchAds360Link, error)
	// Lookup for a AttributionSettings singleton.
	GetAttributionSettings(context.Context, *GetAttributionSettingsRequest) (*AttributionSettings, error)
	// Updates attribution settings on a property.
	UpdateAttributionSettings(context.Context, *UpdateAttributionSettingsRequest) (*AttributionSettings, error)
	// Returns a customized report of data access records. The report provides
	// records of each time a user reads Google Analytics reporting data. Access
	// records are retained for up to 2 years.
	//
	// Data Access Reports can be requested for a property. Reports may be
	// requested for any property, but dimensions that aren't related to quota can
	// only be requested on Google Analytics 360 properties. This method is only
	// available to Administrators.
	//
	// These data access records include GA UI Reporting, GA UI Explorations,
	// GA Data API, and other products like Firebase & Admob that can retrieve
	// data from Google Analytics through a linkage. These records don't include
	// property configuration changes like adding a stream or changing a
	// property's time zone. For configuration change history, see
	// [searchChangeHistoryEvents](https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1alpha/accounts/searchChangeHistoryEvents).
	//
	// To give your feedback on this API, complete the [Google Analytics Access
	// Reports
	// feedback](https://docs.google.com/forms/d/e/1FAIpQLSdmEBUrMzAEdiEKk5TV5dEHvDUZDRlgWYdQdAeSdtR4hVjEhw/viewform)
	// form.
	RunAccessReport(context.Context, *RunAccessReportRequest) (*RunAccessReportResponse, error)
	// Creates an access binding on an account or property.
	CreateAccessBinding(context.Context, *CreateAccessBindingRequest) (*AccessBinding, error)
	// Gets information about an access binding.
	GetAccessBinding(context.Context, *GetAccessBindingRequest) (*AccessBinding, error)
	// Updates an access binding on an account or property.
	UpdateAccessBinding(context.Context, *UpdateAccessBindingRequest) (*AccessBinding, error)
	// Deletes an access binding on an account or property.
	DeleteAccessBinding(context.Context, *DeleteAccessBindingRequest) (*emptypb.Empty, error)
	// Lists all access bindings on an account or property.
	ListAccessBindings(context.Context, *ListAccessBindingsRequest) (*ListAccessBindingsResponse, error)
	// Creates information about multiple access bindings to an account or
	// property.
	//
	// This method is transactional. If any AccessBinding cannot be created, none
	// of the AccessBindings will be created.
	BatchCreateAccessBindings(context.Context, *BatchCreateAccessBindingsRequest) (*BatchCreateAccessBindingsResponse, error)
	// Gets information about multiple access bindings to an account or property.
	BatchGetAccessBindings(context.Context, *BatchGetAccessBindingsRequest) (*BatchGetAccessBindingsResponse, error)
	// Updates information about multiple access bindings to an account or
	// property.
	BatchUpdateAccessBindings(context.Context, *BatchUpdateAccessBindingsRequest) (*BatchUpdateAccessBindingsResponse, error)
	// Deletes information about multiple users' links to an account or property.
	BatchDeleteAccessBindings(context.Context, *BatchDeleteAccessBindingsRequest) (*emptypb.Empty, error)
	// Lookup for a single ExpandedDataSet.
	GetExpandedDataSet(context.Context, *GetExpandedDataSetRequest) (*ExpandedDataSet, error)
	// Lists ExpandedDataSets on a property.
	ListExpandedDataSets(context.Context, *ListExpandedDataSetsRequest) (*ListExpandedDataSetsResponse, error)
	// Creates a ExpandedDataSet.
	CreateExpandedDataSet(context.Context, *CreateExpandedDataSetRequest) (*ExpandedDataSet, error)
	// Updates a ExpandedDataSet on a property.
	UpdateExpandedDataSet(context.Context, *UpdateExpandedDataSetRequest) (*ExpandedDataSet, error)
	// Deletes a ExpandedDataSet on a property.
	DeleteExpandedDataSet(context.Context, *DeleteExpandedDataSetRequest) (*emptypb.Empty, error)
	// Lookup for a single ChannelGroup.
	GetChannelGroup(context.Context, *GetChannelGroupRequest) (*ChannelGroup, error)
	// Lists ChannelGroups on a property.
	ListChannelGroups(context.Context, *ListChannelGroupsRequest) (*ListChannelGroupsResponse, error)
	// Creates a ChannelGroup.
	CreateChannelGroup(context.Context, *CreateChannelGroupRequest) (*ChannelGroup, error)
	// Updates a ChannelGroup.
	UpdateChannelGroup(context.Context, *UpdateChannelGroupRequest) (*ChannelGroup, error)
	// Deletes a ChannelGroup on a property.
	DeleteChannelGroup(context.Context, *DeleteChannelGroupRequest) (*emptypb.Empty, error)
	// Sets the opt out status for the automated GA4 setup process for a UA
	// property.
	// Note: this has no effect on GA4 property.
	SetAutomatedGa4ConfigurationOptOut(context.Context, *SetAutomatedGa4ConfigurationOptOutRequest) (*SetAutomatedGa4ConfigurationOptOutResponse, error)
	// Fetches the opt out status for the automated GA4 setup process for a UA
	// property.
	// Note: this has no effect on GA4 property.
	FetchAutomatedGa4ConfigurationOptOut(context.Context, *FetchAutomatedGa4ConfigurationOptOutRequest) (*FetchAutomatedGa4ConfigurationOptOutResponse, error)
	// Creates a BigQueryLink.
	CreateBigQueryLink(context.Context, *CreateBigQueryLinkRequest) (*BigQueryLink, error)
	// Lookup for a single BigQuery Link.
	GetBigQueryLink(context.Context, *GetBigQueryLinkRequest) (*BigQueryLink, error)
	// Lists BigQuery Links on a property.
	ListBigQueryLinks(context.Context, *ListBigQueryLinksRequest) (*ListBigQueryLinksResponse, error)
	// Deletes a BigQueryLink on a property.
	DeleteBigQueryLink(context.Context, *DeleteBigQueryLinkRequest) (*emptypb.Empty, error)
	// Updates a BigQueryLink.
	UpdateBigQueryLink(context.Context, *UpdateBigQueryLinkRequest) (*BigQueryLink, error)
	// Returns the enhanced measurement settings for this data stream.
	// Note that the stream must enable enhanced measurement for these settings to
	// take effect.
	GetEnhancedMeasurementSettings(context.Context, *GetEnhancedMeasurementSettingsRequest) (*EnhancedMeasurementSettings, error)
	// Updates the enhanced measurement settings for this data stream.
	// Note that the stream must enable enhanced measurement for these settings to
	// take effect.
	UpdateEnhancedMeasurementSettings(context.Context, *UpdateEnhancedMeasurementSettingsRequest) (*EnhancedMeasurementSettings, error)
	// Creates a connected site tag for a Universal Analytics property. You can
	// create a maximum of 20 connected site tags per property.
	// Note: This API cannot be used on GA4 properties.
	CreateConnectedSiteTag(context.Context, *CreateConnectedSiteTagRequest) (*CreateConnectedSiteTagResponse, error)
	// Deletes a connected site tag for a Universal Analytics property.
	// Note: this has no effect on GA4 properties.
	DeleteConnectedSiteTag(context.Context, *DeleteConnectedSiteTagRequest) (*emptypb.Empty, error)
	// Lists the connected site tags for a Universal Analytics property. A maximum
	// of 20 connected site tags will be returned. Note: this has no effect on GA4
	// property.
	ListConnectedSiteTags(context.Context, *ListConnectedSiteTagsRequest) (*ListConnectedSiteTagsResponse, error)
	// Given a specified UA property, looks up the GA4 property connected to it.
	// Note: this cannot be used with GA4 properties.
	FetchConnectedGa4Property(context.Context, *FetchConnectedGa4PropertyRequest) (*FetchConnectedGa4PropertyResponse, error)
	// Looks up a single AdSenseLink.
	GetAdSenseLink(context.Context, *GetAdSenseLinkRequest) (*AdSenseLink, error)
	// Creates an AdSenseLink.
	CreateAdSenseLink(context.Context, *CreateAdSenseLinkRequest) (*AdSenseLink, error)
	// Deletes an AdSenseLink.
	DeleteAdSenseLink(context.Context, *DeleteAdSenseLinkRequest) (*emptypb.Empty, error)
	// Lists AdSenseLinks on a property.
	ListAdSenseLinks(context.Context, *ListAdSenseLinksRequest) (*ListAdSenseLinksResponse, error)
	// Lookup for a single EventCreateRule.
	GetEventCreateRule(context.Context, *GetEventCreateRuleRequest) (*EventCreateRule, error)
	// Lists EventCreateRules on a web data stream.
	ListEventCreateRules(context.Context, *ListEventCreateRulesRequest) (*ListEventCreateRulesResponse, error)
	// Creates an EventCreateRule.
	CreateEventCreateRule(context.Context, *CreateEventCreateRuleRequest) (*EventCreateRule, error)
	// Updates an EventCreateRule.
	UpdateEventCreateRule(context.Context, *UpdateEventCreateRuleRequest) (*EventCreateRule, error)
	// Deletes an EventCreateRule.
	DeleteEventCreateRule(context.Context, *DeleteEventCreateRuleRequest) (*emptypb.Empty, error)
	// Lookup for a single EventEditRule.
	GetEventEditRule(context.Context, *GetEventEditRuleRequest) (*EventEditRule, error)
	// Lists EventEditRules on a web data stream.
	ListEventEditRules(context.Context, *ListEventEditRulesRequest) (*ListEventEditRulesResponse, error)
	// Creates an EventEditRule.
	CreateEventEditRule(context.Context, *CreateEventEditRuleRequest) (*EventEditRule, error)
	// Updates an EventEditRule.
	UpdateEventEditRule(context.Context, *UpdateEventEditRuleRequest) (*EventEditRule, error)
	// Deletes an EventEditRule.
	DeleteEventEditRule(context.Context, *DeleteEventEditRuleRequest) (*emptypb.Empty, error)
	// Changes the processing order of event edit rules on the specified stream.
	ReorderEventEditRules(context.Context, *ReorderEventEditRulesRequest) (*emptypb.Empty, error)
	// Updates a DataRedactionSettings on a property.
	UpdateDataRedactionSettings(context.Context, *UpdateDataRedactionSettingsRequest) (*DataRedactionSettings, error)
	// Lookup for a single DataRedactionSettings.
	GetDataRedactionSettings(context.Context, *GetDataRedactionSettingsRequest) (*DataRedactionSettings, error)
	// Lookup for a single CalculatedMetric.
	GetCalculatedMetric(context.Context, *GetCalculatedMetricRequest) (*CalculatedMetric, error)
	// Creates a CalculatedMetric.
	CreateCalculatedMetric(context.Context, *CreateCalculatedMetricRequest) (*CalculatedMetric, error)
	// Lists CalculatedMetrics on a property.
	ListCalculatedMetrics(context.Context, *ListCalculatedMetricsRequest) (*ListCalculatedMetricsResponse, error)
	// Updates a CalculatedMetric on a property.
	UpdateCalculatedMetric(context.Context, *UpdateCalculatedMetricRequest) (*CalculatedMetric, error)
	// Deletes a CalculatedMetric on a property.
	DeleteCalculatedMetric(context.Context, *DeleteCalculatedMetricRequest) (*emptypb.Empty, error)
	// Create a roll-up property and all roll-up property source links.
	CreateRollupProperty(context.Context, *CreateRollupPropertyRequest) (*CreateRollupPropertyResponse, error)
	// Lookup for a single roll-up property source Link.
	// Only roll-up properties can have source links, so this method will throw an
	// error if used on other types of properties.
	GetRollupPropertySourceLink(context.Context, *GetRollupPropertySourceLinkRequest) (*RollupPropertySourceLink, error)
	// Lists roll-up property source Links on a property.
	// Only roll-up properties can have source links, so this method will throw an
	// error if used on other types of properties.
	ListRollupPropertySourceLinks(context.Context, *ListRollupPropertySourceLinksRequest) (*ListRollupPropertySourceLinksResponse, error)
	// Creates a roll-up property source link.
	// Only roll-up properties can have source links, so this method will throw an
	// error if used on other types of properties.
	CreateRollupPropertySourceLink(context.Context, *CreateRollupPropertySourceLinkRequest) (*RollupPropertySourceLink, error)
	// Deletes a roll-up property source link.
	// Only roll-up properties can have source links, so this method will throw an
	// error if used on other types of properties.
	DeleteRollupPropertySourceLink(context.Context, *DeleteRollupPropertySourceLinkRequest) (*emptypb.Empty, error)
	// Create a subproperty and a subproperty event filter that applies to the
	// created subproperty.
	ProvisionSubproperty(context.Context, *ProvisionSubpropertyRequest) (*ProvisionSubpropertyResponse, error)
	// Creates a subproperty Event Filter.
	CreateSubpropertyEventFilter(context.Context, *CreateSubpropertyEventFilterRequest) (*SubpropertyEventFilter, error)
	// Lookup for a single subproperty Event Filter.
	GetSubpropertyEventFilter(context.Context, *GetSubpropertyEventFilterRequest) (*SubpropertyEventFilter, error)
	// List all subproperty Event Filters on a property.
	ListSubpropertyEventFilters(context.Context, *ListSubpropertyEventFiltersRequest) (*ListSubpropertyEventFiltersResponse, error)
	// Updates a subproperty Event Filter.
	UpdateSubpropertyEventFilter(context.Context, *UpdateSubpropertyEventFilterRequest) (*SubpropertyEventFilter, error)
	// Deletes a subproperty event filter.
	DeleteSubpropertyEventFilter(context.Context, *DeleteSubpropertyEventFilterRequest) (*emptypb.Empty, error)
	// Creates a Reporting Data Annotation.
	CreateReportingDataAnnotation(context.Context, *CreateReportingDataAnnotationRequest) (*ReportingDataAnnotation, error)
	// Lookup a single Reporting Data Annotation.
	GetReportingDataAnnotation(context.Context, *GetReportingDataAnnotationRequest) (*ReportingDataAnnotation, error)
	// List all Reporting Data Annotations on a property.
	ListReportingDataAnnotations(context.Context, *ListReportingDataAnnotationsRequest) (*ListReportingDataAnnotationsResponse, error)
	// Updates a Reporting Data Annotation.
	UpdateReportingDataAnnotation(context.Context, *UpdateReportingDataAnnotationRequest) (*ReportingDataAnnotation, error)
	// Deletes a Reporting Data Annotation.
	DeleteReportingDataAnnotation(context.Context, *DeleteReportingDataAnnotationRequest) (*emptypb.Empty, error)
	// Submits a request for user deletion for a property.
	SubmitUserDeletion(context.Context, *SubmitUserDeletionRequest) (*SubmitUserDeletionResponse, error)
}

// UnimplementedAnalyticsAdminServiceServer should be embedded to have forward compatible implementations.
type UnimplementedAnalyticsAdminServiceServer struct {
}

func (UnimplementedAnalyticsAdminServiceServer) GetAccount(context.Context, *GetAccountRequest) (*Account, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAccount not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListAccounts(context.Context, *ListAccountsRequest) (*ListAccountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccounts not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteAccount(context.Context, *DeleteAccountRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAccount not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateAccount(context.Context, *UpdateAccountRequest) (*Account, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccount not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ProvisionAccountTicket(context.Context, *ProvisionAccountTicketRequest) (*ProvisionAccountTicketResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProvisionAccountTicket not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListAccountSummaries(context.Context, *ListAccountSummariesRequest) (*ListAccountSummariesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccountSummaries not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetProperty(context.Context, *GetPropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProperty not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListProperties(context.Context, *ListPropertiesRequest) (*ListPropertiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProperties not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateProperty(context.Context, *CreatePropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProperty not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteProperty(context.Context, *DeletePropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProperty not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateProperty(context.Context, *UpdatePropertyRequest) (*Property, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProperty not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateFirebaseLink(context.Context, *CreateFirebaseLinkRequest) (*FirebaseLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFirebaseLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteFirebaseLink(context.Context, *DeleteFirebaseLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFirebaseLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListFirebaseLinks(context.Context, *ListFirebaseLinksRequest) (*ListFirebaseLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFirebaseLinks not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetGlobalSiteTag(context.Context, *GetGlobalSiteTagRequest) (*GlobalSiteTag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGlobalSiteTag not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateGoogleAdsLink(context.Context, *CreateGoogleAdsLinkRequest) (*GoogleAdsLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGoogleAdsLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateGoogleAdsLink(context.Context, *UpdateGoogleAdsLinkRequest) (*GoogleAdsLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGoogleAdsLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteGoogleAdsLink(context.Context, *DeleteGoogleAdsLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGoogleAdsLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListGoogleAdsLinks(context.Context, *ListGoogleAdsLinksRequest) (*ListGoogleAdsLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGoogleAdsLinks not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetDataSharingSettings(context.Context, *GetDataSharingSettingsRequest) (*DataSharingSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataSharingSettings not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetMeasurementProtocolSecret(context.Context, *GetMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMeasurementProtocolSecret not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListMeasurementProtocolSecrets(context.Context, *ListMeasurementProtocolSecretsRequest) (*ListMeasurementProtocolSecretsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMeasurementProtocolSecrets not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateMeasurementProtocolSecret(context.Context, *CreateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMeasurementProtocolSecret not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteMeasurementProtocolSecret(context.Context, *DeleteMeasurementProtocolSecretRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMeasurementProtocolSecret not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateMeasurementProtocolSecret(context.Context, *UpdateMeasurementProtocolSecretRequest) (*MeasurementProtocolSecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMeasurementProtocolSecret not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) AcknowledgeUserDataCollection(context.Context, *AcknowledgeUserDataCollectionRequest) (*AcknowledgeUserDataCollectionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AcknowledgeUserDataCollection not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetSKAdNetworkConversionValueSchema(context.Context, *GetSKAdNetworkConversionValueSchemaRequest) (*SKAdNetworkConversionValueSchema, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSKAdNetworkConversionValueSchema not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateSKAdNetworkConversionValueSchema(context.Context, *CreateSKAdNetworkConversionValueSchemaRequest) (*SKAdNetworkConversionValueSchema, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSKAdNetworkConversionValueSchema not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteSKAdNetworkConversionValueSchema(context.Context, *DeleteSKAdNetworkConversionValueSchemaRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSKAdNetworkConversionValueSchema not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateSKAdNetworkConversionValueSchema(context.Context, *UpdateSKAdNetworkConversionValueSchemaRequest) (*SKAdNetworkConversionValueSchema, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSKAdNetworkConversionValueSchema not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListSKAdNetworkConversionValueSchemas(context.Context, *ListSKAdNetworkConversionValueSchemasRequest) (*ListSKAdNetworkConversionValueSchemasResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSKAdNetworkConversionValueSchemas not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) SearchChangeHistoryEvents(context.Context, *SearchChangeHistoryEventsRequest) (*SearchChangeHistoryEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchChangeHistoryEvents not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetGoogleSignalsSettings(context.Context, *GetGoogleSignalsSettingsRequest) (*GoogleSignalsSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGoogleSignalsSettings not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateGoogleSignalsSettings(context.Context, *UpdateGoogleSignalsSettingsRequest) (*GoogleSignalsSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGoogleSignalsSettings not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateConversionEvent(context.Context, *CreateConversionEventRequest) (*ConversionEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConversionEvent not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateConversionEvent(context.Context, *UpdateConversionEventRequest) (*ConversionEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConversionEvent not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetConversionEvent(context.Context, *GetConversionEventRequest) (*ConversionEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversionEvent not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteConversionEvent(context.Context, *DeleteConversionEventRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConversionEvent not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListConversionEvents(context.Context, *ListConversionEventsRequest) (*ListConversionEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversionEvents not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateKeyEvent(context.Context, *CreateKeyEventRequest) (*KeyEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateKeyEvent not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateKeyEvent(context.Context, *UpdateKeyEventRequest) (*KeyEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateKeyEvent not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetKeyEvent(context.Context, *GetKeyEventRequest) (*KeyEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetKeyEvent not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteKeyEvent(context.Context, *DeleteKeyEventRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteKeyEvent not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListKeyEvents(context.Context, *ListKeyEventsRequest) (*ListKeyEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListKeyEvents not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetDisplayVideo360AdvertiserLink(context.Context, *GetDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDisplayVideo360AdvertiserLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListDisplayVideo360AdvertiserLinks(context.Context, *ListDisplayVideo360AdvertiserLinksRequest) (*ListDisplayVideo360AdvertiserLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDisplayVideo360AdvertiserLinks not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateDisplayVideo360AdvertiserLink(context.Context, *CreateDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDisplayVideo360AdvertiserLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteDisplayVideo360AdvertiserLink(context.Context, *DeleteDisplayVideo360AdvertiserLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDisplayVideo360AdvertiserLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateDisplayVideo360AdvertiserLink(context.Context, *UpdateDisplayVideo360AdvertiserLinkRequest) (*DisplayVideo360AdvertiserLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDisplayVideo360AdvertiserLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetDisplayVideo360AdvertiserLinkProposal(context.Context, *GetDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListDisplayVideo360AdvertiserLinkProposals(context.Context, *ListDisplayVideo360AdvertiserLinkProposalsRequest) (*ListDisplayVideo360AdvertiserLinkProposalsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDisplayVideo360AdvertiserLinkProposals not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateDisplayVideo360AdvertiserLinkProposal(context.Context, *CreateDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteDisplayVideo360AdvertiserLinkProposal(context.Context, *DeleteDisplayVideo360AdvertiserLinkProposalRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ApproveDisplayVideo360AdvertiserLinkProposal(context.Context, *ApproveDisplayVideo360AdvertiserLinkProposalRequest) (*ApproveDisplayVideo360AdvertiserLinkProposalResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApproveDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CancelDisplayVideo360AdvertiserLinkProposal(context.Context, *CancelDisplayVideo360AdvertiserLinkProposalRequest) (*DisplayVideo360AdvertiserLinkProposal, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelDisplayVideo360AdvertiserLinkProposal not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateCustomDimension(context.Context, *CreateCustomDimensionRequest) (*CustomDimension, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomDimension not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateCustomDimension(context.Context, *UpdateCustomDimensionRequest) (*CustomDimension, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomDimension not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListCustomDimensions(context.Context, *ListCustomDimensionsRequest) (*ListCustomDimensionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomDimensions not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ArchiveCustomDimension(context.Context, *ArchiveCustomDimensionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ArchiveCustomDimension not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetCustomDimension(context.Context, *GetCustomDimensionRequest) (*CustomDimension, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomDimension not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateCustomMetric(context.Context, *CreateCustomMetricRequest) (*CustomMetric, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomMetric not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateCustomMetric(context.Context, *UpdateCustomMetricRequest) (*CustomMetric, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomMetric not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListCustomMetrics(context.Context, *ListCustomMetricsRequest) (*ListCustomMetricsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomMetrics not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ArchiveCustomMetric(context.Context, *ArchiveCustomMetricRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ArchiveCustomMetric not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetCustomMetric(context.Context, *GetCustomMetricRequest) (*CustomMetric, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomMetric not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetDataRetentionSettings(context.Context, *GetDataRetentionSettingsRequest) (*DataRetentionSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataRetentionSettings not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateDataRetentionSettings(context.Context, *UpdateDataRetentionSettingsRequest) (*DataRetentionSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataRetentionSettings not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateDataStream(context.Context, *CreateDataStreamRequest) (*DataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataStream not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteDataStream(context.Context, *DeleteDataStreamRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataStream not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateDataStream(context.Context, *UpdateDataStreamRequest) (*DataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataStream not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListDataStreams(context.Context, *ListDataStreamsRequest) (*ListDataStreamsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataStreams not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetDataStream(context.Context, *GetDataStreamRequest) (*DataStream, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataStream not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetAudience(context.Context, *GetAudienceRequest) (*Audience, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAudience not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListAudiences(context.Context, *ListAudiencesRequest) (*ListAudiencesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAudiences not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateAudience(context.Context, *CreateAudienceRequest) (*Audience, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAudience not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateAudience(context.Context, *UpdateAudienceRequest) (*Audience, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAudience not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ArchiveAudience(context.Context, *ArchiveAudienceRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ArchiveAudience not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetSearchAds360Link(context.Context, *GetSearchAds360LinkRequest) (*SearchAds360Link, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSearchAds360Link not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListSearchAds360Links(context.Context, *ListSearchAds360LinksRequest) (*ListSearchAds360LinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSearchAds360Links not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateSearchAds360Link(context.Context, *CreateSearchAds360LinkRequest) (*SearchAds360Link, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSearchAds360Link not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteSearchAds360Link(context.Context, *DeleteSearchAds360LinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSearchAds360Link not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateSearchAds360Link(context.Context, *UpdateSearchAds360LinkRequest) (*SearchAds360Link, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSearchAds360Link not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetAttributionSettings(context.Context, *GetAttributionSettingsRequest) (*AttributionSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAttributionSettings not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateAttributionSettings(context.Context, *UpdateAttributionSettingsRequest) (*AttributionSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAttributionSettings not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) RunAccessReport(context.Context, *RunAccessReportRequest) (*RunAccessReportResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunAccessReport not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateAccessBinding(context.Context, *CreateAccessBindingRequest) (*AccessBinding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAccessBinding not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetAccessBinding(context.Context, *GetAccessBindingRequest) (*AccessBinding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAccessBinding not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateAccessBinding(context.Context, *UpdateAccessBindingRequest) (*AccessBinding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccessBinding not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteAccessBinding(context.Context, *DeleteAccessBindingRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAccessBinding not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListAccessBindings(context.Context, *ListAccessBindingsRequest) (*ListAccessBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccessBindings not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) BatchCreateAccessBindings(context.Context, *BatchCreateAccessBindingsRequest) (*BatchCreateAccessBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateAccessBindings not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) BatchGetAccessBindings(context.Context, *BatchGetAccessBindingsRequest) (*BatchGetAccessBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchGetAccessBindings not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) BatchUpdateAccessBindings(context.Context, *BatchUpdateAccessBindingsRequest) (*BatchUpdateAccessBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateAccessBindings not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) BatchDeleteAccessBindings(context.Context, *BatchDeleteAccessBindingsRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteAccessBindings not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetExpandedDataSet(context.Context, *GetExpandedDataSetRequest) (*ExpandedDataSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExpandedDataSet not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListExpandedDataSets(context.Context, *ListExpandedDataSetsRequest) (*ListExpandedDataSetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExpandedDataSets not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateExpandedDataSet(context.Context, *CreateExpandedDataSetRequest) (*ExpandedDataSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateExpandedDataSet not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateExpandedDataSet(context.Context, *UpdateExpandedDataSetRequest) (*ExpandedDataSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateExpandedDataSet not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteExpandedDataSet(context.Context, *DeleteExpandedDataSetRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteExpandedDataSet not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetChannelGroup(context.Context, *GetChannelGroupRequest) (*ChannelGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetChannelGroup not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListChannelGroups(context.Context, *ListChannelGroupsRequest) (*ListChannelGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListChannelGroups not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateChannelGroup(context.Context, *CreateChannelGroupRequest) (*ChannelGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateChannelGroup not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateChannelGroup(context.Context, *UpdateChannelGroupRequest) (*ChannelGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateChannelGroup not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteChannelGroup(context.Context, *DeleteChannelGroupRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteChannelGroup not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) SetAutomatedGa4ConfigurationOptOut(context.Context, *SetAutomatedGa4ConfigurationOptOutRequest) (*SetAutomatedGa4ConfigurationOptOutResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetAutomatedGa4ConfigurationOptOut not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) FetchAutomatedGa4ConfigurationOptOut(context.Context, *FetchAutomatedGa4ConfigurationOptOutRequest) (*FetchAutomatedGa4ConfigurationOptOutResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchAutomatedGa4ConfigurationOptOut not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateBigQueryLink(context.Context, *CreateBigQueryLinkRequest) (*BigQueryLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBigQueryLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetBigQueryLink(context.Context, *GetBigQueryLinkRequest) (*BigQueryLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBigQueryLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListBigQueryLinks(context.Context, *ListBigQueryLinksRequest) (*ListBigQueryLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBigQueryLinks not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteBigQueryLink(context.Context, *DeleteBigQueryLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBigQueryLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateBigQueryLink(context.Context, *UpdateBigQueryLinkRequest) (*BigQueryLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBigQueryLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetEnhancedMeasurementSettings(context.Context, *GetEnhancedMeasurementSettingsRequest) (*EnhancedMeasurementSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEnhancedMeasurementSettings not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateEnhancedMeasurementSettings(context.Context, *UpdateEnhancedMeasurementSettingsRequest) (*EnhancedMeasurementSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEnhancedMeasurementSettings not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateConnectedSiteTag(context.Context, *CreateConnectedSiteTagRequest) (*CreateConnectedSiteTagResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConnectedSiteTag not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteConnectedSiteTag(context.Context, *DeleteConnectedSiteTagRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConnectedSiteTag not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListConnectedSiteTags(context.Context, *ListConnectedSiteTagsRequest) (*ListConnectedSiteTagsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConnectedSiteTags not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) FetchConnectedGa4Property(context.Context, *FetchConnectedGa4PropertyRequest) (*FetchConnectedGa4PropertyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchConnectedGa4Property not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetAdSenseLink(context.Context, *GetAdSenseLinkRequest) (*AdSenseLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAdSenseLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateAdSenseLink(context.Context, *CreateAdSenseLinkRequest) (*AdSenseLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAdSenseLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteAdSenseLink(context.Context, *DeleteAdSenseLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAdSenseLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListAdSenseLinks(context.Context, *ListAdSenseLinksRequest) (*ListAdSenseLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAdSenseLinks not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetEventCreateRule(context.Context, *GetEventCreateRuleRequest) (*EventCreateRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEventCreateRule not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListEventCreateRules(context.Context, *ListEventCreateRulesRequest) (*ListEventCreateRulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEventCreateRules not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateEventCreateRule(context.Context, *CreateEventCreateRuleRequest) (*EventCreateRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEventCreateRule not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateEventCreateRule(context.Context, *UpdateEventCreateRuleRequest) (*EventCreateRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEventCreateRule not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteEventCreateRule(context.Context, *DeleteEventCreateRuleRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEventCreateRule not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetEventEditRule(context.Context, *GetEventEditRuleRequest) (*EventEditRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEventEditRule not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListEventEditRules(context.Context, *ListEventEditRulesRequest) (*ListEventEditRulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEventEditRules not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateEventEditRule(context.Context, *CreateEventEditRuleRequest) (*EventEditRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEventEditRule not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateEventEditRule(context.Context, *UpdateEventEditRuleRequest) (*EventEditRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEventEditRule not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteEventEditRule(context.Context, *DeleteEventEditRuleRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEventEditRule not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ReorderEventEditRules(context.Context, *ReorderEventEditRulesRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReorderEventEditRules not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateDataRedactionSettings(context.Context, *UpdateDataRedactionSettingsRequest) (*DataRedactionSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataRedactionSettings not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetDataRedactionSettings(context.Context, *GetDataRedactionSettingsRequest) (*DataRedactionSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataRedactionSettings not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetCalculatedMetric(context.Context, *GetCalculatedMetricRequest) (*CalculatedMetric, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCalculatedMetric not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateCalculatedMetric(context.Context, *CreateCalculatedMetricRequest) (*CalculatedMetric, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCalculatedMetric not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListCalculatedMetrics(context.Context, *ListCalculatedMetricsRequest) (*ListCalculatedMetricsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCalculatedMetrics not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateCalculatedMetric(context.Context, *UpdateCalculatedMetricRequest) (*CalculatedMetric, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCalculatedMetric not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteCalculatedMetric(context.Context, *DeleteCalculatedMetricRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCalculatedMetric not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateRollupProperty(context.Context, *CreateRollupPropertyRequest) (*CreateRollupPropertyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRollupProperty not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetRollupPropertySourceLink(context.Context, *GetRollupPropertySourceLinkRequest) (*RollupPropertySourceLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRollupPropertySourceLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListRollupPropertySourceLinks(context.Context, *ListRollupPropertySourceLinksRequest) (*ListRollupPropertySourceLinksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRollupPropertySourceLinks not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateRollupPropertySourceLink(context.Context, *CreateRollupPropertySourceLinkRequest) (*RollupPropertySourceLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRollupPropertySourceLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteRollupPropertySourceLink(context.Context, *DeleteRollupPropertySourceLinkRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRollupPropertySourceLink not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ProvisionSubproperty(context.Context, *ProvisionSubpropertyRequest) (*ProvisionSubpropertyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProvisionSubproperty not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateSubpropertyEventFilter(context.Context, *CreateSubpropertyEventFilterRequest) (*SubpropertyEventFilter, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSubpropertyEventFilter not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetSubpropertyEventFilter(context.Context, *GetSubpropertyEventFilterRequest) (*SubpropertyEventFilter, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSubpropertyEventFilter not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListSubpropertyEventFilters(context.Context, *ListSubpropertyEventFiltersRequest) (*ListSubpropertyEventFiltersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSubpropertyEventFilters not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateSubpropertyEventFilter(context.Context, *UpdateSubpropertyEventFilterRequest) (*SubpropertyEventFilter, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSubpropertyEventFilter not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteSubpropertyEventFilter(context.Context, *DeleteSubpropertyEventFilterRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSubpropertyEventFilter not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) CreateReportingDataAnnotation(context.Context, *CreateReportingDataAnnotationRequest) (*ReportingDataAnnotation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateReportingDataAnnotation not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) GetReportingDataAnnotation(context.Context, *GetReportingDataAnnotationRequest) (*ReportingDataAnnotation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReportingDataAnnotation not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) ListReportingDataAnnotations(context.Context, *ListReportingDataAnnotationsRequest) (*ListReportingDataAnnotationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReportingDataAnnotations not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) UpdateReportingDataAnnotation(context.Context, *UpdateReportingDataAnnotationRequest) (*ReportingDataAnnotation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateReportingDataAnnotation not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) DeleteReportingDataAnnotation(context.Context, *DeleteReportingDataAnnotationRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteReportingDataAnnotation not implemented")
}
func (UnimplementedAnalyticsAdminServiceServer) SubmitUserDeletion(context.Context, *SubmitUserDeletionRequest) (*SubmitUserDeletionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SubmitUserDeletion not implemented")
}

// UnsafeAnalyticsAdminServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AnalyticsAdminServiceServer will
// result in compilation errors.
type UnsafeAnalyticsAdminServiceServer interface {
	mustEmbedUnimplementedAnalyticsAdminServiceServer()
}

func RegisterAnalyticsAdminServiceServer(s grpc.ServiceRegistrar, srv AnalyticsAdminServiceServer) {
	s.RegisterService(&AnalyticsAdminService_ServiceDesc, srv)
}

func _AnalyticsAdminService_GetAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetAccount_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetAccount(ctx, req.(*GetAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListAccounts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListAccounts(ctx, req.(*ListAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteAccount_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteAccount(ctx, req.(*DeleteAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateAccount_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateAccount(ctx, req.(*UpdateAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ProvisionAccountTicket_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProvisionAccountTicketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ProvisionAccountTicket(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ProvisionAccountTicket_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ProvisionAccountTicket(ctx, req.(*ProvisionAccountTicketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListAccountSummaries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAccountSummariesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListAccountSummaries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListAccountSummaries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListAccountSummaries(ctx, req.(*ListAccountSummariesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetProperty_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetProperty(ctx, req.(*GetPropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListProperties_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPropertiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListProperties(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListProperties_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListProperties(ctx, req.(*ListPropertiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateProperty_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateProperty(ctx, req.(*CreatePropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteProperty_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteProperty(ctx, req.(*DeletePropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateProperty_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateProperty(ctx, req.(*UpdatePropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateFirebaseLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFirebaseLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateFirebaseLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateFirebaseLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateFirebaseLink(ctx, req.(*CreateFirebaseLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteFirebaseLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFirebaseLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteFirebaseLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteFirebaseLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteFirebaseLink(ctx, req.(*DeleteFirebaseLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListFirebaseLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFirebaseLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListFirebaseLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListFirebaseLinks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListFirebaseLinks(ctx, req.(*ListFirebaseLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetGlobalSiteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlobalSiteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetGlobalSiteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetGlobalSiteTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetGlobalSiteTag(ctx, req.(*GetGlobalSiteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateGoogleAdsLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGoogleAdsLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateGoogleAdsLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateGoogleAdsLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateGoogleAdsLink(ctx, req.(*CreateGoogleAdsLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateGoogleAdsLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGoogleAdsLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateGoogleAdsLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateGoogleAdsLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateGoogleAdsLink(ctx, req.(*UpdateGoogleAdsLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteGoogleAdsLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGoogleAdsLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteGoogleAdsLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteGoogleAdsLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteGoogleAdsLink(ctx, req.(*DeleteGoogleAdsLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListGoogleAdsLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGoogleAdsLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListGoogleAdsLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListGoogleAdsLinks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListGoogleAdsLinks(ctx, req.(*ListGoogleAdsLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetDataSharingSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataSharingSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetDataSharingSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetDataSharingSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetDataSharingSettings(ctx, req.(*GetDataSharingSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetMeasurementProtocolSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMeasurementProtocolSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetMeasurementProtocolSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetMeasurementProtocolSecret_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetMeasurementProtocolSecret(ctx, req.(*GetMeasurementProtocolSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListMeasurementProtocolSecrets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMeasurementProtocolSecretsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListMeasurementProtocolSecrets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListMeasurementProtocolSecrets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListMeasurementProtocolSecrets(ctx, req.(*ListMeasurementProtocolSecretsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateMeasurementProtocolSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMeasurementProtocolSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateMeasurementProtocolSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateMeasurementProtocolSecret_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateMeasurementProtocolSecret(ctx, req.(*CreateMeasurementProtocolSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteMeasurementProtocolSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMeasurementProtocolSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteMeasurementProtocolSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteMeasurementProtocolSecret_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteMeasurementProtocolSecret(ctx, req.(*DeleteMeasurementProtocolSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateMeasurementProtocolSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMeasurementProtocolSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateMeasurementProtocolSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateMeasurementProtocolSecret_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateMeasurementProtocolSecret(ctx, req.(*UpdateMeasurementProtocolSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_AcknowledgeUserDataCollection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcknowledgeUserDataCollectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).AcknowledgeUserDataCollection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_AcknowledgeUserDataCollection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).AcknowledgeUserDataCollection(ctx, req.(*AcknowledgeUserDataCollectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetSKAdNetworkConversionValueSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSKAdNetworkConversionValueSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetSKAdNetworkConversionValueSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetSKAdNetworkConversionValueSchema_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetSKAdNetworkConversionValueSchema(ctx, req.(*GetSKAdNetworkConversionValueSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateSKAdNetworkConversionValueSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSKAdNetworkConversionValueSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateSKAdNetworkConversionValueSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateSKAdNetworkConversionValueSchema_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateSKAdNetworkConversionValueSchema(ctx, req.(*CreateSKAdNetworkConversionValueSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteSKAdNetworkConversionValueSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSKAdNetworkConversionValueSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteSKAdNetworkConversionValueSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteSKAdNetworkConversionValueSchema_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteSKAdNetworkConversionValueSchema(ctx, req.(*DeleteSKAdNetworkConversionValueSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateSKAdNetworkConversionValueSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSKAdNetworkConversionValueSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateSKAdNetworkConversionValueSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateSKAdNetworkConversionValueSchema_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateSKAdNetworkConversionValueSchema(ctx, req.(*UpdateSKAdNetworkConversionValueSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListSKAdNetworkConversionValueSchemas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSKAdNetworkConversionValueSchemasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListSKAdNetworkConversionValueSchemas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListSKAdNetworkConversionValueSchemas_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListSKAdNetworkConversionValueSchemas(ctx, req.(*ListSKAdNetworkConversionValueSchemasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_SearchChangeHistoryEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchChangeHistoryEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).SearchChangeHistoryEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_SearchChangeHistoryEvents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).SearchChangeHistoryEvents(ctx, req.(*SearchChangeHistoryEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetGoogleSignalsSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGoogleSignalsSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetGoogleSignalsSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetGoogleSignalsSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetGoogleSignalsSettings(ctx, req.(*GetGoogleSignalsSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateGoogleSignalsSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGoogleSignalsSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateGoogleSignalsSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateGoogleSignalsSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateGoogleSignalsSettings(ctx, req.(*UpdateGoogleSignalsSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateConversionEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversionEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateConversionEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateConversionEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateConversionEvent(ctx, req.(*CreateConversionEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateConversionEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConversionEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateConversionEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateConversionEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateConversionEvent(ctx, req.(*UpdateConversionEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetConversionEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversionEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetConversionEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetConversionEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetConversionEvent(ctx, req.(*GetConversionEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteConversionEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConversionEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteConversionEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteConversionEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteConversionEvent(ctx, req.(*DeleteConversionEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListConversionEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversionEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListConversionEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListConversionEvents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListConversionEvents(ctx, req.(*ListConversionEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateKeyEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateKeyEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateKeyEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateKeyEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateKeyEvent(ctx, req.(*CreateKeyEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateKeyEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateKeyEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateKeyEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateKeyEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateKeyEvent(ctx, req.(*UpdateKeyEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetKeyEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKeyEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetKeyEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetKeyEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetKeyEvent(ctx, req.(*GetKeyEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteKeyEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteKeyEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteKeyEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteKeyEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteKeyEvent(ctx, req.(*DeleteKeyEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListKeyEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListKeyEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListKeyEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListKeyEvents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListKeyEvents(ctx, req.(*ListKeyEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetDisplayVideo360AdvertiserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDisplayVideo360AdvertiserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetDisplayVideo360AdvertiserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetDisplayVideo360AdvertiserLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetDisplayVideo360AdvertiserLink(ctx, req.(*GetDisplayVideo360AdvertiserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListDisplayVideo360AdvertiserLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDisplayVideo360AdvertiserLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListDisplayVideo360AdvertiserLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListDisplayVideo360AdvertiserLinks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListDisplayVideo360AdvertiserLinks(ctx, req.(*ListDisplayVideo360AdvertiserLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateDisplayVideo360AdvertiserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDisplayVideo360AdvertiserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateDisplayVideo360AdvertiserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateDisplayVideo360AdvertiserLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateDisplayVideo360AdvertiserLink(ctx, req.(*CreateDisplayVideo360AdvertiserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteDisplayVideo360AdvertiserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDisplayVideo360AdvertiserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteDisplayVideo360AdvertiserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteDisplayVideo360AdvertiserLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteDisplayVideo360AdvertiserLink(ctx, req.(*DeleteDisplayVideo360AdvertiserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateDisplayVideo360AdvertiserLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDisplayVideo360AdvertiserLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateDisplayVideo360AdvertiserLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateDisplayVideo360AdvertiserLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateDisplayVideo360AdvertiserLink(ctx, req.(*UpdateDisplayVideo360AdvertiserLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetDisplayVideo360AdvertiserLinkProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDisplayVideo360AdvertiserLinkProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetDisplayVideo360AdvertiserLinkProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetDisplayVideo360AdvertiserLinkProposal_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetDisplayVideo360AdvertiserLinkProposal(ctx, req.(*GetDisplayVideo360AdvertiserLinkProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListDisplayVideo360AdvertiserLinkProposals_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDisplayVideo360AdvertiserLinkProposalsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListDisplayVideo360AdvertiserLinkProposals(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListDisplayVideo360AdvertiserLinkProposals_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListDisplayVideo360AdvertiserLinkProposals(ctx, req.(*ListDisplayVideo360AdvertiserLinkProposalsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateDisplayVideo360AdvertiserLinkProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDisplayVideo360AdvertiserLinkProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateDisplayVideo360AdvertiserLinkProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateDisplayVideo360AdvertiserLinkProposal_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateDisplayVideo360AdvertiserLinkProposal(ctx, req.(*CreateDisplayVideo360AdvertiserLinkProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteDisplayVideo360AdvertiserLinkProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDisplayVideo360AdvertiserLinkProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteDisplayVideo360AdvertiserLinkProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteDisplayVideo360AdvertiserLinkProposal_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteDisplayVideo360AdvertiserLinkProposal(ctx, req.(*DeleteDisplayVideo360AdvertiserLinkProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ApproveDisplayVideo360AdvertiserLinkProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApproveDisplayVideo360AdvertiserLinkProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ApproveDisplayVideo360AdvertiserLinkProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ApproveDisplayVideo360AdvertiserLinkProposal_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ApproveDisplayVideo360AdvertiserLinkProposal(ctx, req.(*ApproveDisplayVideo360AdvertiserLinkProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CancelDisplayVideo360AdvertiserLinkProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelDisplayVideo360AdvertiserLinkProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CancelDisplayVideo360AdvertiserLinkProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CancelDisplayVideo360AdvertiserLinkProposal_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CancelDisplayVideo360AdvertiserLinkProposal(ctx, req.(*CancelDisplayVideo360AdvertiserLinkProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateCustomDimension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomDimensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateCustomDimension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateCustomDimension_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateCustomDimension(ctx, req.(*CreateCustomDimensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateCustomDimension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomDimensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateCustomDimension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateCustomDimension_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateCustomDimension(ctx, req.(*UpdateCustomDimensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListCustomDimensions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomDimensionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListCustomDimensions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListCustomDimensions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListCustomDimensions(ctx, req.(*ListCustomDimensionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ArchiveCustomDimension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ArchiveCustomDimensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ArchiveCustomDimension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ArchiveCustomDimension_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ArchiveCustomDimension(ctx, req.(*ArchiveCustomDimensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetCustomDimension_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomDimensionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetCustomDimension(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetCustomDimension_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetCustomDimension(ctx, req.(*GetCustomDimensionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateCustomMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateCustomMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateCustomMetric_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateCustomMetric(ctx, req.(*CreateCustomMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateCustomMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateCustomMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateCustomMetric_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateCustomMetric(ctx, req.(*UpdateCustomMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListCustomMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListCustomMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListCustomMetrics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListCustomMetrics(ctx, req.(*ListCustomMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ArchiveCustomMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ArchiveCustomMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ArchiveCustomMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ArchiveCustomMetric_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ArchiveCustomMetric(ctx, req.(*ArchiveCustomMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetCustomMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetCustomMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetCustomMetric_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetCustomMetric(ctx, req.(*GetCustomMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetDataRetentionSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataRetentionSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetDataRetentionSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetDataRetentionSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetDataRetentionSettings(ctx, req.(*GetDataRetentionSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateDataRetentionSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataRetentionSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateDataRetentionSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateDataRetentionSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateDataRetentionSettings(ctx, req.(*UpdateDataRetentionSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateDataStream_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateDataStream(ctx, req.(*CreateDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteDataStream_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteDataStream(ctx, req.(*DeleteDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateDataStream_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateDataStream(ctx, req.(*UpdateDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListDataStreams_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataStreamsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListDataStreams(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListDataStreams_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListDataStreams(ctx, req.(*ListDataStreamsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetDataStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetDataStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetDataStream_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetDataStream(ctx, req.(*GetDataStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetAudience_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAudienceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetAudience(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetAudience_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetAudience(ctx, req.(*GetAudienceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListAudiences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAudiencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListAudiences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListAudiences_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListAudiences(ctx, req.(*ListAudiencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateAudience_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAudienceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateAudience(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateAudience_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateAudience(ctx, req.(*CreateAudienceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateAudience_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAudienceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateAudience(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateAudience_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateAudience(ctx, req.(*UpdateAudienceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ArchiveAudience_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ArchiveAudienceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ArchiveAudience(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ArchiveAudience_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ArchiveAudience(ctx, req.(*ArchiveAudienceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetSearchAds360Link_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSearchAds360LinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetSearchAds360Link(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetSearchAds360Link_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetSearchAds360Link(ctx, req.(*GetSearchAds360LinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListSearchAds360Links_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSearchAds360LinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListSearchAds360Links(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListSearchAds360Links_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListSearchAds360Links(ctx, req.(*ListSearchAds360LinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateSearchAds360Link_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSearchAds360LinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateSearchAds360Link(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateSearchAds360Link_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateSearchAds360Link(ctx, req.(*CreateSearchAds360LinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteSearchAds360Link_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSearchAds360LinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteSearchAds360Link(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteSearchAds360Link_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteSearchAds360Link(ctx, req.(*DeleteSearchAds360LinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateSearchAds360Link_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSearchAds360LinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateSearchAds360Link(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateSearchAds360Link_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateSearchAds360Link(ctx, req.(*UpdateSearchAds360LinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetAttributionSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAttributionSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetAttributionSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetAttributionSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetAttributionSettings(ctx, req.(*GetAttributionSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateAttributionSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAttributionSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateAttributionSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateAttributionSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateAttributionSettings(ctx, req.(*UpdateAttributionSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_RunAccessReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunAccessReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).RunAccessReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_RunAccessReport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).RunAccessReport(ctx, req.(*RunAccessReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateAccessBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAccessBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateAccessBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateAccessBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateAccessBinding(ctx, req.(*CreateAccessBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetAccessBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAccessBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetAccessBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetAccessBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetAccessBinding(ctx, req.(*GetAccessBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateAccessBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAccessBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateAccessBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateAccessBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateAccessBinding(ctx, req.(*UpdateAccessBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteAccessBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAccessBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteAccessBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteAccessBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteAccessBinding(ctx, req.(*DeleteAccessBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListAccessBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListAccessBindings(ctx, req.(*ListAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_BatchCreateAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).BatchCreateAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_BatchCreateAccessBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).BatchCreateAccessBindings(ctx, req.(*BatchCreateAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_BatchGetAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).BatchGetAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_BatchGetAccessBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).BatchGetAccessBindings(ctx, req.(*BatchGetAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_BatchUpdateAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).BatchUpdateAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_BatchUpdateAccessBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).BatchUpdateAccessBindings(ctx, req.(*BatchUpdateAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_BatchDeleteAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).BatchDeleteAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_BatchDeleteAccessBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).BatchDeleteAccessBindings(ctx, req.(*BatchDeleteAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetExpandedDataSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExpandedDataSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetExpandedDataSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetExpandedDataSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetExpandedDataSet(ctx, req.(*GetExpandedDataSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListExpandedDataSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExpandedDataSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListExpandedDataSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListExpandedDataSets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListExpandedDataSets(ctx, req.(*ListExpandedDataSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateExpandedDataSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateExpandedDataSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateExpandedDataSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateExpandedDataSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateExpandedDataSet(ctx, req.(*CreateExpandedDataSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateExpandedDataSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExpandedDataSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateExpandedDataSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateExpandedDataSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateExpandedDataSet(ctx, req.(*UpdateExpandedDataSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteExpandedDataSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteExpandedDataSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteExpandedDataSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteExpandedDataSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteExpandedDataSet(ctx, req.(*DeleteExpandedDataSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetChannelGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetChannelGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetChannelGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetChannelGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetChannelGroup(ctx, req.(*GetChannelGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListChannelGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListChannelGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListChannelGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListChannelGroups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListChannelGroups(ctx, req.(*ListChannelGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateChannelGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateChannelGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateChannelGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateChannelGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateChannelGroup(ctx, req.(*CreateChannelGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateChannelGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateChannelGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateChannelGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateChannelGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateChannelGroup(ctx, req.(*UpdateChannelGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteChannelGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteChannelGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteChannelGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteChannelGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteChannelGroup(ctx, req.(*DeleteChannelGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_SetAutomatedGa4ConfigurationOptOut_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetAutomatedGa4ConfigurationOptOutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).SetAutomatedGa4ConfigurationOptOut(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_SetAutomatedGa4ConfigurationOptOut_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).SetAutomatedGa4ConfigurationOptOut(ctx, req.(*SetAutomatedGa4ConfigurationOptOutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_FetchAutomatedGa4ConfigurationOptOut_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchAutomatedGa4ConfigurationOptOutRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).FetchAutomatedGa4ConfigurationOptOut(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_FetchAutomatedGa4ConfigurationOptOut_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).FetchAutomatedGa4ConfigurationOptOut(ctx, req.(*FetchAutomatedGa4ConfigurationOptOutRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateBigQueryLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBigQueryLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateBigQueryLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateBigQueryLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateBigQueryLink(ctx, req.(*CreateBigQueryLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetBigQueryLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBigQueryLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetBigQueryLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetBigQueryLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetBigQueryLink(ctx, req.(*GetBigQueryLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListBigQueryLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBigQueryLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListBigQueryLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListBigQueryLinks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListBigQueryLinks(ctx, req.(*ListBigQueryLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteBigQueryLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBigQueryLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteBigQueryLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteBigQueryLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteBigQueryLink(ctx, req.(*DeleteBigQueryLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateBigQueryLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBigQueryLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateBigQueryLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateBigQueryLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateBigQueryLink(ctx, req.(*UpdateBigQueryLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetEnhancedMeasurementSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEnhancedMeasurementSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetEnhancedMeasurementSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetEnhancedMeasurementSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetEnhancedMeasurementSettings(ctx, req.(*GetEnhancedMeasurementSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateEnhancedMeasurementSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEnhancedMeasurementSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateEnhancedMeasurementSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateEnhancedMeasurementSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateEnhancedMeasurementSettings(ctx, req.(*UpdateEnhancedMeasurementSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateConnectedSiteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConnectedSiteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateConnectedSiteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateConnectedSiteTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateConnectedSiteTag(ctx, req.(*CreateConnectedSiteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteConnectedSiteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConnectedSiteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteConnectedSiteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteConnectedSiteTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteConnectedSiteTag(ctx, req.(*DeleteConnectedSiteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListConnectedSiteTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConnectedSiteTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListConnectedSiteTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListConnectedSiteTags_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListConnectedSiteTags(ctx, req.(*ListConnectedSiteTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_FetchConnectedGa4Property_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchConnectedGa4PropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).FetchConnectedGa4Property(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_FetchConnectedGa4Property_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).FetchConnectedGa4Property(ctx, req.(*FetchConnectedGa4PropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetAdSenseLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAdSenseLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetAdSenseLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetAdSenseLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetAdSenseLink(ctx, req.(*GetAdSenseLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateAdSenseLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAdSenseLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateAdSenseLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateAdSenseLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateAdSenseLink(ctx, req.(*CreateAdSenseLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteAdSenseLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAdSenseLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteAdSenseLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteAdSenseLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteAdSenseLink(ctx, req.(*DeleteAdSenseLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListAdSenseLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAdSenseLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListAdSenseLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListAdSenseLinks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListAdSenseLinks(ctx, req.(*ListAdSenseLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetEventCreateRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEventCreateRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetEventCreateRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetEventCreateRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetEventCreateRule(ctx, req.(*GetEventCreateRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListEventCreateRules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEventCreateRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListEventCreateRules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListEventCreateRules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListEventCreateRules(ctx, req.(*ListEventCreateRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateEventCreateRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEventCreateRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateEventCreateRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateEventCreateRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateEventCreateRule(ctx, req.(*CreateEventCreateRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateEventCreateRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEventCreateRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateEventCreateRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateEventCreateRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateEventCreateRule(ctx, req.(*UpdateEventCreateRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteEventCreateRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEventCreateRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteEventCreateRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteEventCreateRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteEventCreateRule(ctx, req.(*DeleteEventCreateRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetEventEditRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEventEditRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetEventEditRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetEventEditRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetEventEditRule(ctx, req.(*GetEventEditRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListEventEditRules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEventEditRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListEventEditRules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListEventEditRules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListEventEditRules(ctx, req.(*ListEventEditRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateEventEditRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEventEditRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateEventEditRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateEventEditRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateEventEditRule(ctx, req.(*CreateEventEditRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateEventEditRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEventEditRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateEventEditRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateEventEditRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateEventEditRule(ctx, req.(*UpdateEventEditRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteEventEditRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEventEditRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteEventEditRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteEventEditRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteEventEditRule(ctx, req.(*DeleteEventEditRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ReorderEventEditRules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReorderEventEditRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ReorderEventEditRules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ReorderEventEditRules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ReorderEventEditRules(ctx, req.(*ReorderEventEditRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateDataRedactionSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataRedactionSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateDataRedactionSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateDataRedactionSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateDataRedactionSettings(ctx, req.(*UpdateDataRedactionSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetDataRedactionSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataRedactionSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetDataRedactionSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetDataRedactionSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetDataRedactionSettings(ctx, req.(*GetDataRedactionSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetCalculatedMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCalculatedMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetCalculatedMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetCalculatedMetric_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetCalculatedMetric(ctx, req.(*GetCalculatedMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateCalculatedMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCalculatedMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateCalculatedMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateCalculatedMetric_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateCalculatedMetric(ctx, req.(*CreateCalculatedMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListCalculatedMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCalculatedMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListCalculatedMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListCalculatedMetrics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListCalculatedMetrics(ctx, req.(*ListCalculatedMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateCalculatedMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCalculatedMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateCalculatedMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateCalculatedMetric_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateCalculatedMetric(ctx, req.(*UpdateCalculatedMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteCalculatedMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCalculatedMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteCalculatedMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteCalculatedMetric_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteCalculatedMetric(ctx, req.(*DeleteCalculatedMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateRollupProperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRollupPropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateRollupProperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateRollupProperty_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateRollupProperty(ctx, req.(*CreateRollupPropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetRollupPropertySourceLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRollupPropertySourceLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetRollupPropertySourceLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetRollupPropertySourceLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetRollupPropertySourceLink(ctx, req.(*GetRollupPropertySourceLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListRollupPropertySourceLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRollupPropertySourceLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListRollupPropertySourceLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListRollupPropertySourceLinks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListRollupPropertySourceLinks(ctx, req.(*ListRollupPropertySourceLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateRollupPropertySourceLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRollupPropertySourceLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateRollupPropertySourceLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateRollupPropertySourceLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateRollupPropertySourceLink(ctx, req.(*CreateRollupPropertySourceLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteRollupPropertySourceLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRollupPropertySourceLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteRollupPropertySourceLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteRollupPropertySourceLink_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteRollupPropertySourceLink(ctx, req.(*DeleteRollupPropertySourceLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ProvisionSubproperty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProvisionSubpropertyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ProvisionSubproperty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ProvisionSubproperty_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ProvisionSubproperty(ctx, req.(*ProvisionSubpropertyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateSubpropertyEventFilter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSubpropertyEventFilterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateSubpropertyEventFilter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateSubpropertyEventFilter_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateSubpropertyEventFilter(ctx, req.(*CreateSubpropertyEventFilterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetSubpropertyEventFilter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubpropertyEventFilterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetSubpropertyEventFilter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetSubpropertyEventFilter_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetSubpropertyEventFilter(ctx, req.(*GetSubpropertyEventFilterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListSubpropertyEventFilters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubpropertyEventFiltersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListSubpropertyEventFilters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListSubpropertyEventFilters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListSubpropertyEventFilters(ctx, req.(*ListSubpropertyEventFiltersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateSubpropertyEventFilter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSubpropertyEventFilterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateSubpropertyEventFilter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateSubpropertyEventFilter_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateSubpropertyEventFilter(ctx, req.(*UpdateSubpropertyEventFilterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteSubpropertyEventFilter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSubpropertyEventFilterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteSubpropertyEventFilter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteSubpropertyEventFilter_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteSubpropertyEventFilter(ctx, req.(*DeleteSubpropertyEventFilterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_CreateReportingDataAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReportingDataAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).CreateReportingDataAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_CreateReportingDataAnnotation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).CreateReportingDataAnnotation(ctx, req.(*CreateReportingDataAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_GetReportingDataAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReportingDataAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).GetReportingDataAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_GetReportingDataAnnotation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).GetReportingDataAnnotation(ctx, req.(*GetReportingDataAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_ListReportingDataAnnotations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReportingDataAnnotationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).ListReportingDataAnnotations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_ListReportingDataAnnotations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).ListReportingDataAnnotations(ctx, req.(*ListReportingDataAnnotationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_UpdateReportingDataAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateReportingDataAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).UpdateReportingDataAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_UpdateReportingDataAnnotation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).UpdateReportingDataAnnotation(ctx, req.(*UpdateReportingDataAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_DeleteReportingDataAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReportingDataAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).DeleteReportingDataAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_DeleteReportingDataAnnotation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).DeleteReportingDataAnnotation(ctx, req.(*DeleteReportingDataAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AnalyticsAdminService_SubmitUserDeletion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubmitUserDeletionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AnalyticsAdminServiceServer).SubmitUserDeletion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AnalyticsAdminService_SubmitUserDeletion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AnalyticsAdminServiceServer).SubmitUserDeletion(ctx, req.(*SubmitUserDeletionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AnalyticsAdminService_ServiceDesc is the grpc.ServiceDesc for AnalyticsAdminService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AnalyticsAdminService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.analytics.admin.v1alpha.AnalyticsAdminService",
	HandlerType: (*AnalyticsAdminServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAccount",
			Handler:    _AnalyticsAdminService_GetAccount_Handler,
		},
		{
			MethodName: "ListAccounts",
			Handler:    _AnalyticsAdminService_ListAccounts_Handler,
		},
		{
			MethodName: "DeleteAccount",
			Handler:    _AnalyticsAdminService_DeleteAccount_Handler,
		},
		{
			MethodName: "UpdateAccount",
			Handler:    _AnalyticsAdminService_UpdateAccount_Handler,
		},
		{
			MethodName: "ProvisionAccountTicket",
			Handler:    _AnalyticsAdminService_ProvisionAccountTicket_Handler,
		},
		{
			MethodName: "ListAccountSummaries",
			Handler:    _AnalyticsAdminService_ListAccountSummaries_Handler,
		},
		{
			MethodName: "GetProperty",
			Handler:    _AnalyticsAdminService_GetProperty_Handler,
		},
		{
			MethodName: "ListProperties",
			Handler:    _AnalyticsAdminService_ListProperties_Handler,
		},
		{
			MethodName: "CreateProperty",
			Handler:    _AnalyticsAdminService_CreateProperty_Handler,
		},
		{
			MethodName: "DeleteProperty",
			Handler:    _AnalyticsAdminService_DeleteProperty_Handler,
		},
		{
			MethodName: "UpdateProperty",
			Handler:    _AnalyticsAdminService_UpdateProperty_Handler,
		},
		{
			MethodName: "CreateFirebaseLink",
			Handler:    _AnalyticsAdminService_CreateFirebaseLink_Handler,
		},
		{
			MethodName: "DeleteFirebaseLink",
			Handler:    _AnalyticsAdminService_DeleteFirebaseLink_Handler,
		},
		{
			MethodName: "ListFirebaseLinks",
			Handler:    _AnalyticsAdminService_ListFirebaseLinks_Handler,
		},
		{
			MethodName: "GetGlobalSiteTag",
			Handler:    _AnalyticsAdminService_GetGlobalSiteTag_Handler,
		},
		{
			MethodName: "CreateGoogleAdsLink",
			Handler:    _AnalyticsAdminService_CreateGoogleAdsLink_Handler,
		},
		{
			MethodName: "UpdateGoogleAdsLink",
			Handler:    _AnalyticsAdminService_UpdateGoogleAdsLink_Handler,
		},
		{
			MethodName: "DeleteGoogleAdsLink",
			Handler:    _AnalyticsAdminService_DeleteGoogleAdsLink_Handler,
		},
		{
			MethodName: "ListGoogleAdsLinks",
			Handler:    _AnalyticsAdminService_ListGoogleAdsLinks_Handler,
		},
		{
			MethodName: "GetDataSharingSettings",
			Handler:    _AnalyticsAdminService_GetDataSharingSettings_Handler,
		},
		{
			MethodName: "GetMeasurementProtocolSecret",
			Handler:    _AnalyticsAdminService_GetMeasurementProtocolSecret_Handler,
		},
		{
			MethodName: "ListMeasurementProtocolSecrets",
			Handler:    _AnalyticsAdminService_ListMeasurementProtocolSecrets_Handler,
		},
		{
			MethodName: "CreateMeasurementProtocolSecret",
			Handler:    _AnalyticsAdminService_CreateMeasurementProtocolSecret_Handler,
		},
		{
			MethodName: "DeleteMeasurementProtocolSecret",
			Handler:    _AnalyticsAdminService_DeleteMeasurementProtocolSecret_Handler,
		},
		{
			MethodName: "UpdateMeasurementProtocolSecret",
			Handler:    _AnalyticsAdminService_UpdateMeasurementProtocolSecret_Handler,
		},
		{
			MethodName: "AcknowledgeUserDataCollection",
			Handler:    _AnalyticsAdminService_AcknowledgeUserDataCollection_Handler,
		},
		{
			MethodName: "GetSKAdNetworkConversionValueSchema",
			Handler:    _AnalyticsAdminService_GetSKAdNetworkConversionValueSchema_Handler,
		},
		{
			MethodName: "CreateSKAdNetworkConversionValueSchema",
			Handler:    _AnalyticsAdminService_CreateSKAdNetworkConversionValueSchema_Handler,
		},
		{
			MethodName: "DeleteSKAdNetworkConversionValueSchema",
			Handler:    _AnalyticsAdminService_DeleteSKAdNetworkConversionValueSchema_Handler,
		},
		{
			MethodName: "UpdateSKAdNetworkConversionValueSchema",
			Handler:    _AnalyticsAdminService_UpdateSKAdNetworkConversionValueSchema_Handler,
		},
		{
			MethodName: "ListSKAdNetworkConversionValueSchemas",
			Handler:    _AnalyticsAdminService_ListSKAdNetworkConversionValueSchemas_Handler,
		},
		{
			MethodName: "SearchChangeHistoryEvents",
			Handler:    _AnalyticsAdminService_SearchChangeHistoryEvents_Handler,
		},
		{
			MethodName: "GetGoogleSignalsSettings",
			Handler:    _AnalyticsAdminService_GetGoogleSignalsSettings_Handler,
		},
		{
			MethodName: "UpdateGoogleSignalsSettings",
			Handler:    _AnalyticsAdminService_UpdateGoogleSignalsSettings_Handler,
		},
		{
			MethodName: "CreateConversionEvent",
			Handler:    _AnalyticsAdminService_CreateConversionEvent_Handler,
		},
		{
			MethodName: "UpdateConversionEvent",
			Handler:    _AnalyticsAdminService_UpdateConversionEvent_Handler,
		},
		{
			MethodName: "GetConversionEvent",
			Handler:    _AnalyticsAdminService_GetConversionEvent_Handler,
		},
		{
			MethodName: "DeleteConversionEvent",
			Handler:    _AnalyticsAdminService_DeleteConversionEvent_Handler,
		},
		{
			MethodName: "ListConversionEvents",
			Handler:    _AnalyticsAdminService_ListConversionEvents_Handler,
		},
		{
			MethodName: "CreateKeyEvent",
			Handler:    _AnalyticsAdminService_CreateKeyEvent_Handler,
		},
		{
			MethodName: "UpdateKeyEvent",
			Handler:    _AnalyticsAdminService_UpdateKeyEvent_Handler,
		},
		{
			MethodName: "GetKeyEvent",
			Handler:    _AnalyticsAdminService_GetKeyEvent_Handler,
		},
		{
			MethodName: "DeleteKeyEvent",
			Handler:    _AnalyticsAdminService_DeleteKeyEvent_Handler,
		},
		{
			MethodName: "ListKeyEvents",
			Handler:    _AnalyticsAdminService_ListKeyEvents_Handler,
		},
		{
			MethodName: "GetDisplayVideo360AdvertiserLink",
			Handler:    _AnalyticsAdminService_GetDisplayVideo360AdvertiserLink_Handler,
		},
		{
			MethodName: "ListDisplayVideo360AdvertiserLinks",
			Handler:    _AnalyticsAdminService_ListDisplayVideo360AdvertiserLinks_Handler,
		},
		{
			MethodName: "CreateDisplayVideo360AdvertiserLink",
			Handler:    _AnalyticsAdminService_CreateDisplayVideo360AdvertiserLink_Handler,
		},
		{
			MethodName: "DeleteDisplayVideo360AdvertiserLink",
			Handler:    _AnalyticsAdminService_DeleteDisplayVideo360AdvertiserLink_Handler,
		},
		{
			MethodName: "UpdateDisplayVideo360AdvertiserLink",
			Handler:    _AnalyticsAdminService_UpdateDisplayVideo360AdvertiserLink_Handler,
		},
		{
			MethodName: "GetDisplayVideo360AdvertiserLinkProposal",
			Handler:    _AnalyticsAdminService_GetDisplayVideo360AdvertiserLinkProposal_Handler,
		},
		{
			MethodName: "ListDisplayVideo360AdvertiserLinkProposals",
			Handler:    _AnalyticsAdminService_ListDisplayVideo360AdvertiserLinkProposals_Handler,
		},
		{
			MethodName: "CreateDisplayVideo360AdvertiserLinkProposal",
			Handler:    _AnalyticsAdminService_CreateDisplayVideo360AdvertiserLinkProposal_Handler,
		},
		{
			MethodName: "DeleteDisplayVideo360AdvertiserLinkProposal",
			Handler:    _AnalyticsAdminService_DeleteDisplayVideo360AdvertiserLinkProposal_Handler,
		},
		{
			MethodName: "ApproveDisplayVideo360AdvertiserLinkProposal",
			Handler:    _AnalyticsAdminService_ApproveDisplayVideo360AdvertiserLinkProposal_Handler,
		},
		{
			MethodName: "CancelDisplayVideo360AdvertiserLinkProposal",
			Handler:    _AnalyticsAdminService_CancelDisplayVideo360AdvertiserLinkProposal_Handler,
		},
		{
			MethodName: "CreateCustomDimension",
			Handler:    _AnalyticsAdminService_CreateCustomDimension_Handler,
		},
		{
			MethodName: "UpdateCustomDimension",
			Handler:    _AnalyticsAdminService_UpdateCustomDimension_Handler,
		},
		{
			MethodName: "ListCustomDimensions",
			Handler:    _AnalyticsAdminService_ListCustomDimensions_Handler,
		},
		{
			MethodName: "ArchiveCustomDimension",
			Handler:    _AnalyticsAdminService_ArchiveCustomDimension_Handler,
		},
		{
			MethodName: "GetCustomDimension",
			Handler:    _AnalyticsAdminService_GetCustomDimension_Handler,
		},
		{
			MethodName: "CreateCustomMetric",
			Handler:    _AnalyticsAdminService_CreateCustomMetric_Handler,
		},
		{
			MethodName: "UpdateCustomMetric",
			Handler:    _AnalyticsAdminService_UpdateCustomMetric_Handler,
		},
		{
			MethodName: "ListCustomMetrics",
			Handler:    _AnalyticsAdminService_ListCustomMetrics_Handler,
		},
		{
			MethodName: "ArchiveCustomMetric",
			Handler:    _AnalyticsAdminService_ArchiveCustomMetric_Handler,
		},
		{
			MethodName: "GetCustomMetric",
			Handler:    _AnalyticsAdminService_GetCustomMetric_Handler,
		},
		{
			MethodName: "GetDataRetentionSettings",
			Handler:    _AnalyticsAdminService_GetDataRetentionSettings_Handler,
		},
		{
			MethodName: "UpdateDataRetentionSettings",
			Handler:    _AnalyticsAdminService_UpdateDataRetentionSettings_Handler,
		},
		{
			MethodName: "CreateDataStream",
			Handler:    _AnalyticsAdminService_CreateDataStream_Handler,
		},
		{
			MethodName: "DeleteDataStream",
			Handler:    _AnalyticsAdminService_DeleteDataStream_Handler,
		},
		{
			MethodName: "UpdateDataStream",
			Handler:    _AnalyticsAdminService_UpdateDataStream_Handler,
		},
		{
			MethodName: "ListDataStreams",
			Handler:    _AnalyticsAdminService_ListDataStreams_Handler,
		},
		{
			MethodName: "GetDataStream",
			Handler:    _AnalyticsAdminService_GetDataStream_Handler,
		},
		{
			MethodName: "GetAudience",
			Handler:    _AnalyticsAdminService_GetAudience_Handler,
		},
		{
			MethodName: "ListAudiences",
			Handler:    _AnalyticsAdminService_ListAudiences_Handler,
		},
		{
			MethodName: "CreateAudience",
			Handler:    _AnalyticsAdminService_CreateAudience_Handler,
		},
		{
			MethodName: "UpdateAudience",
			Handler:    _AnalyticsAdminService_UpdateAudience_Handler,
		},
		{
			MethodName: "ArchiveAudience",
			Handler:    _AnalyticsAdminService_ArchiveAudience_Handler,
		},
		{
			MethodName: "GetSearchAds360Link",
			Handler:    _AnalyticsAdminService_GetSearchAds360Link_Handler,
		},
		{
			MethodName: "ListSearchAds360Links",
			Handler:    _AnalyticsAdminService_ListSearchAds360Links_Handler,
		},
		{
			MethodName: "CreateSearchAds360Link",
			Handler:    _AnalyticsAdminService_CreateSearchAds360Link_Handler,
		},
		{
			MethodName: "DeleteSearchAds360Link",
			Handler:    _AnalyticsAdminService_DeleteSearchAds360Link_Handler,
		},
		{
			MethodName: "UpdateSearchAds360Link",
			Handler:    _AnalyticsAdminService_UpdateSearchAds360Link_Handler,
		},
		{
			MethodName: "GetAttributionSettings",
			Handler:    _AnalyticsAdminService_GetAttributionSettings_Handler,
		},
		{
			MethodName: "UpdateAttributionSettings",
			Handler:    _AnalyticsAdminService_UpdateAttributionSettings_Handler,
		},
		{
			MethodName: "RunAccessReport",
			Handler:    _AnalyticsAdminService_RunAccessReport_Handler,
		},
		{
			MethodName: "CreateAccessBinding",
			Handler:    _AnalyticsAdminService_CreateAccessBinding_Handler,
		},
		{
			MethodName: "GetAccessBinding",
			Handler:    _AnalyticsAdminService_GetAccessBinding_Handler,
		},
		{
			MethodName: "UpdateAccessBinding",
			Handler:    _AnalyticsAdminService_UpdateAccessBinding_Handler,
		},
		{
			MethodName: "DeleteAccessBinding",
			Handler:    _AnalyticsAdminService_DeleteAccessBinding_Handler,
		},
		{
			MethodName: "ListAccessBindings",
			Handler:    _AnalyticsAdminService_ListAccessBindings_Handler,
		},
		{
			MethodName: "BatchCreateAccessBindings",
			Handler:    _AnalyticsAdminService_BatchCreateAccessBindings_Handler,
		},
		{
			MethodName: "BatchGetAccessBindings",
			Handler:    _AnalyticsAdminService_BatchGetAccessBindings_Handler,
		},
		{
			MethodName: "BatchUpdateAccessBindings",
			Handler:    _AnalyticsAdminService_BatchUpdateAccessBindings_Handler,
		},
		{
			MethodName: "BatchDeleteAccessBindings",
			Handler:    _AnalyticsAdminService_BatchDeleteAccessBindings_Handler,
		},
		{
			MethodName: "GetExpandedDataSet",
			Handler:    _AnalyticsAdminService_GetExpandedDataSet_Handler,
		},
		{
			MethodName: "ListExpandedDataSets",
			Handler:    _AnalyticsAdminService_ListExpandedDataSets_Handler,
		},
		{
			MethodName: "CreateExpandedDataSet",
			Handler:    _AnalyticsAdminService_CreateExpandedDataSet_Handler,
		},
		{
			MethodName: "UpdateExpandedDataSet",
			Handler:    _AnalyticsAdminService_UpdateExpandedDataSet_Handler,
		},
		{
			MethodName: "DeleteExpandedDataSet",
			Handler:    _AnalyticsAdminService_DeleteExpandedDataSet_Handler,
		},
		{
			MethodName: "GetChannelGroup",
			Handler:    _AnalyticsAdminService_GetChannelGroup_Handler,
		},
		{
			MethodName: "ListChannelGroups",
			Handler:    _AnalyticsAdminService_ListChannelGroups_Handler,
		},
		{
			MethodName: "CreateChannelGroup",
			Handler:    _AnalyticsAdminService_CreateChannelGroup_Handler,
		},
		{
			MethodName: "UpdateChannelGroup",
			Handler:    _AnalyticsAdminService_UpdateChannelGroup_Handler,
		},
		{
			MethodName: "DeleteChannelGroup",
			Handler:    _AnalyticsAdminService_DeleteChannelGroup_Handler,
		},
		{
			MethodName: "SetAutomatedGa4ConfigurationOptOut",
			Handler:    _AnalyticsAdminService_SetAutomatedGa4ConfigurationOptOut_Handler,
		},
		{
			MethodName: "FetchAutomatedGa4ConfigurationOptOut",
			Handler:    _AnalyticsAdminService_FetchAutomatedGa4ConfigurationOptOut_Handler,
		},
		{
			MethodName: "CreateBigQueryLink",
			Handler:    _AnalyticsAdminService_CreateBigQueryLink_Handler,
		},
		{
			MethodName: "GetBigQueryLink",
			Handler:    _AnalyticsAdminService_GetBigQueryLink_Handler,
		},
		{
			MethodName: "ListBigQueryLinks",
			Handler:    _AnalyticsAdminService_ListBigQueryLinks_Handler,
		},
		{
			MethodName: "DeleteBigQueryLink",
			Handler:    _AnalyticsAdminService_DeleteBigQueryLink_Handler,
		},
		{
			MethodName: "UpdateBigQueryLink",
			Handler:    _AnalyticsAdminService_UpdateBigQueryLink_Handler,
		},
		{
			MethodName: "GetEnhancedMeasurementSettings",
			Handler:    _AnalyticsAdminService_GetEnhancedMeasurementSettings_Handler,
		},
		{
			MethodName: "UpdateEnhancedMeasurementSettings",
			Handler:    _AnalyticsAdminService_UpdateEnhancedMeasurementSettings_Handler,
		},
		{
			MethodName: "CreateConnectedSiteTag",
			Handler:    _AnalyticsAdminService_CreateConnectedSiteTag_Handler,
		},
		{
			MethodName: "DeleteConnectedSiteTag",
			Handler:    _AnalyticsAdminService_DeleteConnectedSiteTag_Handler,
		},
		{
			MethodName: "ListConnectedSiteTags",
			Handler:    _AnalyticsAdminService_ListConnectedSiteTags_Handler,
		},
		{
			MethodName: "FetchConnectedGa4Property",
			Handler:    _AnalyticsAdminService_FetchConnectedGa4Property_Handler,
		},
		{
			MethodName: "GetAdSenseLink",
			Handler:    _AnalyticsAdminService_GetAdSenseLink_Handler,
		},
		{
			MethodName: "CreateAdSenseLink",
			Handler:    _AnalyticsAdminService_CreateAdSenseLink_Handler,
		},
		{
			MethodName: "DeleteAdSenseLink",
			Handler:    _AnalyticsAdminService_DeleteAdSenseLink_Handler,
		},
		{
			MethodName: "ListAdSenseLinks",
			Handler:    _AnalyticsAdminService_ListAdSenseLinks_Handler,
		},
		{
			MethodName: "GetEventCreateRule",
			Handler:    _AnalyticsAdminService_GetEventCreateRule_Handler,
		},
		{
			MethodName: "ListEventCreateRules",
			Handler:    _AnalyticsAdminService_ListEventCreateRules_Handler,
		},
		{
			MethodName: "CreateEventCreateRule",
			Handler:    _AnalyticsAdminService_CreateEventCreateRule_Handler,
		},
		{
			MethodName: "UpdateEventCreateRule",
			Handler:    _AnalyticsAdminService_UpdateEventCreateRule_Handler,
		},
		{
			MethodName: "DeleteEventCreateRule",
			Handler:    _AnalyticsAdminService_DeleteEventCreateRule_Handler,
		},
		{
			MethodName: "GetEventEditRule",
			Handler:    _AnalyticsAdminService_GetEventEditRule_Handler,
		},
		{
			MethodName: "ListEventEditRules",
			Handler:    _AnalyticsAdminService_ListEventEditRules_Handler,
		},
		{
			MethodName: "CreateEventEditRule",
			Handler:    _AnalyticsAdminService_CreateEventEditRule_Handler,
		},
		{
			MethodName: "UpdateEventEditRule",
			Handler:    _AnalyticsAdminService_UpdateEventEditRule_Handler,
		},
		{
			MethodName: "DeleteEventEditRule",
			Handler:    _AnalyticsAdminService_DeleteEventEditRule_Handler,
		},
		{
			MethodName: "ReorderEventEditRules",
			Handler:    _AnalyticsAdminService_ReorderEventEditRules_Handler,
		},
		{
			MethodName: "UpdateDataRedactionSettings",
			Handler:    _AnalyticsAdminService_UpdateDataRedactionSettings_Handler,
		},
		{
			MethodName: "GetDataRedactionSettings",
			Handler:    _AnalyticsAdminService_GetDataRedactionSettings_Handler,
		},
		{
			MethodName: "GetCalculatedMetric",
			Handler:    _AnalyticsAdminService_GetCalculatedMetric_Handler,
		},
		{
			MethodName: "CreateCalculatedMetric",
			Handler:    _AnalyticsAdminService_CreateCalculatedMetric_Handler,
		},
		{
			MethodName: "ListCalculatedMetrics",
			Handler:    _AnalyticsAdminService_ListCalculatedMetrics_Handler,
		},
		{
			MethodName: "UpdateCalculatedMetric",
			Handler:    _AnalyticsAdminService_UpdateCalculatedMetric_Handler,
		},
		{
			MethodName: "DeleteCalculatedMetric",
			Handler:    _AnalyticsAdminService_DeleteCalculatedMetric_Handler,
		},
		{
			MethodName: "CreateRollupProperty",
			Handler:    _AnalyticsAdminService_CreateRollupProperty_Handler,
		},
		{
			MethodName: "GetRollupPropertySourceLink",
			Handler:    _AnalyticsAdminService_GetRollupPropertySourceLink_Handler,
		},
		{
			MethodName: "ListRollupPropertySourceLinks",
			Handler:    _AnalyticsAdminService_ListRollupPropertySourceLinks_Handler,
		},
		{
			MethodName: "CreateRollupPropertySourceLink",
			Handler:    _AnalyticsAdminService_CreateRollupPropertySourceLink_Handler,
		},
		{
			MethodName: "DeleteRollupPropertySourceLink",
			Handler:    _AnalyticsAdminService_DeleteRollupPropertySourceLink_Handler,
		},
		{
			MethodName: "ProvisionSubproperty",
			Handler:    _AnalyticsAdminService_ProvisionSubproperty_Handler,
		},
		{
			MethodName: "CreateSubpropertyEventFilter",
			Handler:    _AnalyticsAdminService_CreateSubpropertyEventFilter_Handler,
		},
		{
			MethodName: "GetSubpropertyEventFilter",
			Handler:    _AnalyticsAdminService_GetSubpropertyEventFilter_Handler,
		},
		{
			MethodName: "ListSubpropertyEventFilters",
			Handler:    _AnalyticsAdminService_ListSubpropertyEventFilters_Handler,
		},
		{
			MethodName: "UpdateSubpropertyEventFilter",
			Handler:    _AnalyticsAdminService_UpdateSubpropertyEventFilter_Handler,
		},
		{
			MethodName: "DeleteSubpropertyEventFilter",
			Handler:    _AnalyticsAdminService_DeleteSubpropertyEventFilter_Handler,
		},
		{
			MethodName: "CreateReportingDataAnnotation",
			Handler:    _AnalyticsAdminService_CreateReportingDataAnnotation_Handler,
		},
		{
			MethodName: "GetReportingDataAnnotation",
			Handler:    _AnalyticsAdminService_GetReportingDataAnnotation_Handler,
		},
		{
			MethodName: "ListReportingDataAnnotations",
			Handler:    _AnalyticsAdminService_ListReportingDataAnnotations_Handler,
		},
		{
			MethodName: "UpdateReportingDataAnnotation",
			Handler:    _AnalyticsAdminService_UpdateReportingDataAnnotation_Handler,
		},
		{
			MethodName: "DeleteReportingDataAnnotation",
			Handler:    _AnalyticsAdminService_DeleteReportingDataAnnotation_Handler,
		},
		{
			MethodName: "SubmitUserDeletion",
			Handler:    _AnalyticsAdminService_SubmitUserDeletion_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/analytics/admin/v1alpha/analytics_admin.proto",
}
