// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/security/privateca/v1/service.proto

package privatecapb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CertificateAuthorityService_CreateCertificate_FullMethodName               = "/google.cloud.security.privateca.v1.CertificateAuthorityService/CreateCertificate"
	CertificateAuthorityService_GetCertificate_FullMethodName                  = "/google.cloud.security.privateca.v1.CertificateAuthorityService/GetCertificate"
	CertificateAuthorityService_ListCertificates_FullMethodName                = "/google.cloud.security.privateca.v1.CertificateAuthorityService/ListCertificates"
	CertificateAuthorityService_RevokeCertificate_FullMethodName               = "/google.cloud.security.privateca.v1.CertificateAuthorityService/RevokeCertificate"
	CertificateAuthorityService_UpdateCertificate_FullMethodName               = "/google.cloud.security.privateca.v1.CertificateAuthorityService/UpdateCertificate"
	CertificateAuthorityService_ActivateCertificateAuthority_FullMethodName    = "/google.cloud.security.privateca.v1.CertificateAuthorityService/ActivateCertificateAuthority"
	CertificateAuthorityService_CreateCertificateAuthority_FullMethodName      = "/google.cloud.security.privateca.v1.CertificateAuthorityService/CreateCertificateAuthority"
	CertificateAuthorityService_DisableCertificateAuthority_FullMethodName     = "/google.cloud.security.privateca.v1.CertificateAuthorityService/DisableCertificateAuthority"
	CertificateAuthorityService_EnableCertificateAuthority_FullMethodName      = "/google.cloud.security.privateca.v1.CertificateAuthorityService/EnableCertificateAuthority"
	CertificateAuthorityService_FetchCertificateAuthorityCsr_FullMethodName    = "/google.cloud.security.privateca.v1.CertificateAuthorityService/FetchCertificateAuthorityCsr"
	CertificateAuthorityService_GetCertificateAuthority_FullMethodName         = "/google.cloud.security.privateca.v1.CertificateAuthorityService/GetCertificateAuthority"
	CertificateAuthorityService_ListCertificateAuthorities_FullMethodName      = "/google.cloud.security.privateca.v1.CertificateAuthorityService/ListCertificateAuthorities"
	CertificateAuthorityService_UndeleteCertificateAuthority_FullMethodName    = "/google.cloud.security.privateca.v1.CertificateAuthorityService/UndeleteCertificateAuthority"
	CertificateAuthorityService_DeleteCertificateAuthority_FullMethodName      = "/google.cloud.security.privateca.v1.CertificateAuthorityService/DeleteCertificateAuthority"
	CertificateAuthorityService_UpdateCertificateAuthority_FullMethodName      = "/google.cloud.security.privateca.v1.CertificateAuthorityService/UpdateCertificateAuthority"
	CertificateAuthorityService_CreateCaPool_FullMethodName                    = "/google.cloud.security.privateca.v1.CertificateAuthorityService/CreateCaPool"
	CertificateAuthorityService_UpdateCaPool_FullMethodName                    = "/google.cloud.security.privateca.v1.CertificateAuthorityService/UpdateCaPool"
	CertificateAuthorityService_GetCaPool_FullMethodName                       = "/google.cloud.security.privateca.v1.CertificateAuthorityService/GetCaPool"
	CertificateAuthorityService_ListCaPools_FullMethodName                     = "/google.cloud.security.privateca.v1.CertificateAuthorityService/ListCaPools"
	CertificateAuthorityService_DeleteCaPool_FullMethodName                    = "/google.cloud.security.privateca.v1.CertificateAuthorityService/DeleteCaPool"
	CertificateAuthorityService_FetchCaCerts_FullMethodName                    = "/google.cloud.security.privateca.v1.CertificateAuthorityService/FetchCaCerts"
	CertificateAuthorityService_GetCertificateRevocationList_FullMethodName    = "/google.cloud.security.privateca.v1.CertificateAuthorityService/GetCertificateRevocationList"
	CertificateAuthorityService_ListCertificateRevocationLists_FullMethodName  = "/google.cloud.security.privateca.v1.CertificateAuthorityService/ListCertificateRevocationLists"
	CertificateAuthorityService_UpdateCertificateRevocationList_FullMethodName = "/google.cloud.security.privateca.v1.CertificateAuthorityService/UpdateCertificateRevocationList"
	CertificateAuthorityService_CreateCertificateTemplate_FullMethodName       = "/google.cloud.security.privateca.v1.CertificateAuthorityService/CreateCertificateTemplate"
	CertificateAuthorityService_DeleteCertificateTemplate_FullMethodName       = "/google.cloud.security.privateca.v1.CertificateAuthorityService/DeleteCertificateTemplate"
	CertificateAuthorityService_GetCertificateTemplate_FullMethodName          = "/google.cloud.security.privateca.v1.CertificateAuthorityService/GetCertificateTemplate"
	CertificateAuthorityService_ListCertificateTemplates_FullMethodName        = "/google.cloud.security.privateca.v1.CertificateAuthorityService/ListCertificateTemplates"
	CertificateAuthorityService_UpdateCertificateTemplate_FullMethodName       = "/google.cloud.security.privateca.v1.CertificateAuthorityService/UpdateCertificateTemplate"
)

// CertificateAuthorityServiceClient is the client API for CertificateAuthorityService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CertificateAuthorityServiceClient interface {
	// Create a new [Certificate][google.cloud.security.privateca.v1.Certificate]
	// in a given Project, Location from a particular
	// [CaPool][google.cloud.security.privateca.v1.CaPool].
	CreateCertificate(ctx context.Context, in *CreateCertificateRequest, opts ...grpc.CallOption) (*Certificate, error)
	// Returns a [Certificate][google.cloud.security.privateca.v1.Certificate].
	GetCertificate(ctx context.Context, in *GetCertificateRequest, opts ...grpc.CallOption) (*Certificate, error)
	// Lists [Certificates][google.cloud.security.privateca.v1.Certificate].
	ListCertificates(ctx context.Context, in *ListCertificatesRequest, opts ...grpc.CallOption) (*ListCertificatesResponse, error)
	// Revoke a [Certificate][google.cloud.security.privateca.v1.Certificate].
	RevokeCertificate(ctx context.Context, in *RevokeCertificateRequest, opts ...grpc.CallOption) (*Certificate, error)
	// Update a [Certificate][google.cloud.security.privateca.v1.Certificate].
	// Currently, the only field you can update is the
	// [labels][google.cloud.security.privateca.v1.Certificate.labels] field.
	UpdateCertificate(ctx context.Context, in *UpdateCertificateRequest, opts ...grpc.CallOption) (*Certificate, error)
	// Activate a
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// that is in state
	// [AWAITING_USER_ACTIVATION][google.cloud.security.privateca.v1.CertificateAuthority.State.AWAITING_USER_ACTIVATION]
	// and is of type
	// [SUBORDINATE][google.cloud.security.privateca.v1.CertificateAuthority.Type.SUBORDINATE].
	// After the parent Certificate Authority signs a certificate signing request
	// from
	// [FetchCertificateAuthorityCsr][google.cloud.security.privateca.v1.CertificateAuthorityService.FetchCertificateAuthorityCsr],
	// this method can complete the activation process.
	ActivateCertificateAuthority(ctx context.Context, in *ActivateCertificateAuthorityRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Create a new
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// in a given Project and Location.
	CreateCertificateAuthority(ctx context.Context, in *CreateCertificateAuthorityRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Disable a
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
	DisableCertificateAuthority(ctx context.Context, in *DisableCertificateAuthorityRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Enable a
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
	EnableCertificateAuthority(ctx context.Context, in *EnableCertificateAuthorityRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Fetch a certificate signing request (CSR) from a
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// that is in state
	// [AWAITING_USER_ACTIVATION][google.cloud.security.privateca.v1.CertificateAuthority.State.AWAITING_USER_ACTIVATION]
	// and is of type
	// [SUBORDINATE][google.cloud.security.privateca.v1.CertificateAuthority.Type.SUBORDINATE].
	// The CSR must then be signed by the desired parent Certificate Authority,
	// which could be another
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// resource, or could be an on-prem certificate authority. See also
	// [ActivateCertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthorityService.ActivateCertificateAuthority].
	FetchCertificateAuthorityCsr(ctx context.Context, in *FetchCertificateAuthorityCsrRequest, opts ...grpc.CallOption) (*FetchCertificateAuthorityCsrResponse, error)
	// Returns a
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
	GetCertificateAuthority(ctx context.Context, in *GetCertificateAuthorityRequest, opts ...grpc.CallOption) (*CertificateAuthority, error)
	// Lists
	// [CertificateAuthorities][google.cloud.security.privateca.v1.CertificateAuthority].
	ListCertificateAuthorities(ctx context.Context, in *ListCertificateAuthoritiesRequest, opts ...grpc.CallOption) (*ListCertificateAuthoritiesResponse, error)
	// Undelete a
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// that has been deleted.
	UndeleteCertificateAuthority(ctx context.Context, in *UndeleteCertificateAuthorityRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete a
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
	DeleteCertificateAuthority(ctx context.Context, in *DeleteCertificateAuthorityRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Update a
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
	UpdateCertificateAuthority(ctx context.Context, in *UpdateCertificateAuthorityRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Create a [CaPool][google.cloud.security.privateca.v1.CaPool].
	CreateCaPool(ctx context.Context, in *CreateCaPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Update a [CaPool][google.cloud.security.privateca.v1.CaPool].
	UpdateCaPool(ctx context.Context, in *UpdateCaPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns a [CaPool][google.cloud.security.privateca.v1.CaPool].
	GetCaPool(ctx context.Context, in *GetCaPoolRequest, opts ...grpc.CallOption) (*CaPool, error)
	// Lists [CaPools][google.cloud.security.privateca.v1.CaPool].
	ListCaPools(ctx context.Context, in *ListCaPoolsRequest, opts ...grpc.CallOption) (*ListCaPoolsResponse, error)
	// Delete a [CaPool][google.cloud.security.privateca.v1.CaPool].
	DeleteCaPool(ctx context.Context, in *DeleteCaPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// FetchCaCerts returns the current trust anchor for the
	// [CaPool][google.cloud.security.privateca.v1.CaPool]. This will include CA
	// certificate chains for all certificate authorities in the ENABLED,
	// DISABLED, or STAGED states.
	FetchCaCerts(ctx context.Context, in *FetchCaCertsRequest, opts ...grpc.CallOption) (*FetchCaCertsResponse, error)
	// Returns a
	// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList].
	GetCertificateRevocationList(ctx context.Context, in *GetCertificateRevocationListRequest, opts ...grpc.CallOption) (*CertificateRevocationList, error)
	// Lists
	// [CertificateRevocationLists][google.cloud.security.privateca.v1.CertificateRevocationList].
	ListCertificateRevocationLists(ctx context.Context, in *ListCertificateRevocationListsRequest, opts ...grpc.CallOption) (*ListCertificateRevocationListsResponse, error)
	// Update a
	// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList].
	UpdateCertificateRevocationList(ctx context.Context, in *UpdateCertificateRevocationListRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Create a new
	// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate]
	// in a given Project and Location.
	CreateCertificateTemplate(ctx context.Context, in *CreateCertificateTemplateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// DeleteCertificateTemplate deletes a
	// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate].
	DeleteCertificateTemplate(ctx context.Context, in *DeleteCertificateTemplateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns a
	// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate].
	GetCertificateTemplate(ctx context.Context, in *GetCertificateTemplateRequest, opts ...grpc.CallOption) (*CertificateTemplate, error)
	// Lists
	// [CertificateTemplates][google.cloud.security.privateca.v1.CertificateTemplate].
	ListCertificateTemplates(ctx context.Context, in *ListCertificateTemplatesRequest, opts ...grpc.CallOption) (*ListCertificateTemplatesResponse, error)
	// Update a
	// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate].
	UpdateCertificateTemplate(ctx context.Context, in *UpdateCertificateTemplateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type certificateAuthorityServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCertificateAuthorityServiceClient(cc grpc.ClientConnInterface) CertificateAuthorityServiceClient {
	return &certificateAuthorityServiceClient{cc}
}

func (c *certificateAuthorityServiceClient) CreateCertificate(ctx context.Context, in *CreateCertificateRequest, opts ...grpc.CallOption) (*Certificate, error) {
	out := new(Certificate)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_CreateCertificate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) GetCertificate(ctx context.Context, in *GetCertificateRequest, opts ...grpc.CallOption) (*Certificate, error) {
	out := new(Certificate)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_GetCertificate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) ListCertificates(ctx context.Context, in *ListCertificatesRequest, opts ...grpc.CallOption) (*ListCertificatesResponse, error) {
	out := new(ListCertificatesResponse)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_ListCertificates_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) RevokeCertificate(ctx context.Context, in *RevokeCertificateRequest, opts ...grpc.CallOption) (*Certificate, error) {
	out := new(Certificate)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_RevokeCertificate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) UpdateCertificate(ctx context.Context, in *UpdateCertificateRequest, opts ...grpc.CallOption) (*Certificate, error) {
	out := new(Certificate)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_UpdateCertificate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) ActivateCertificateAuthority(ctx context.Context, in *ActivateCertificateAuthorityRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_ActivateCertificateAuthority_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) CreateCertificateAuthority(ctx context.Context, in *CreateCertificateAuthorityRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_CreateCertificateAuthority_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) DisableCertificateAuthority(ctx context.Context, in *DisableCertificateAuthorityRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_DisableCertificateAuthority_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) EnableCertificateAuthority(ctx context.Context, in *EnableCertificateAuthorityRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_EnableCertificateAuthority_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) FetchCertificateAuthorityCsr(ctx context.Context, in *FetchCertificateAuthorityCsrRequest, opts ...grpc.CallOption) (*FetchCertificateAuthorityCsrResponse, error) {
	out := new(FetchCertificateAuthorityCsrResponse)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_FetchCertificateAuthorityCsr_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) GetCertificateAuthority(ctx context.Context, in *GetCertificateAuthorityRequest, opts ...grpc.CallOption) (*CertificateAuthority, error) {
	out := new(CertificateAuthority)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_GetCertificateAuthority_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) ListCertificateAuthorities(ctx context.Context, in *ListCertificateAuthoritiesRequest, opts ...grpc.CallOption) (*ListCertificateAuthoritiesResponse, error) {
	out := new(ListCertificateAuthoritiesResponse)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_ListCertificateAuthorities_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) UndeleteCertificateAuthority(ctx context.Context, in *UndeleteCertificateAuthorityRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_UndeleteCertificateAuthority_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) DeleteCertificateAuthority(ctx context.Context, in *DeleteCertificateAuthorityRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_DeleteCertificateAuthority_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) UpdateCertificateAuthority(ctx context.Context, in *UpdateCertificateAuthorityRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_UpdateCertificateAuthority_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) CreateCaPool(ctx context.Context, in *CreateCaPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_CreateCaPool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) UpdateCaPool(ctx context.Context, in *UpdateCaPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_UpdateCaPool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) GetCaPool(ctx context.Context, in *GetCaPoolRequest, opts ...grpc.CallOption) (*CaPool, error) {
	out := new(CaPool)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_GetCaPool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) ListCaPools(ctx context.Context, in *ListCaPoolsRequest, opts ...grpc.CallOption) (*ListCaPoolsResponse, error) {
	out := new(ListCaPoolsResponse)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_ListCaPools_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) DeleteCaPool(ctx context.Context, in *DeleteCaPoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_DeleteCaPool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) FetchCaCerts(ctx context.Context, in *FetchCaCertsRequest, opts ...grpc.CallOption) (*FetchCaCertsResponse, error) {
	out := new(FetchCaCertsResponse)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_FetchCaCerts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) GetCertificateRevocationList(ctx context.Context, in *GetCertificateRevocationListRequest, opts ...grpc.CallOption) (*CertificateRevocationList, error) {
	out := new(CertificateRevocationList)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_GetCertificateRevocationList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) ListCertificateRevocationLists(ctx context.Context, in *ListCertificateRevocationListsRequest, opts ...grpc.CallOption) (*ListCertificateRevocationListsResponse, error) {
	out := new(ListCertificateRevocationListsResponse)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_ListCertificateRevocationLists_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) UpdateCertificateRevocationList(ctx context.Context, in *UpdateCertificateRevocationListRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_UpdateCertificateRevocationList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) CreateCertificateTemplate(ctx context.Context, in *CreateCertificateTemplateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_CreateCertificateTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) DeleteCertificateTemplate(ctx context.Context, in *DeleteCertificateTemplateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_DeleteCertificateTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) GetCertificateTemplate(ctx context.Context, in *GetCertificateTemplateRequest, opts ...grpc.CallOption) (*CertificateTemplate, error) {
	out := new(CertificateTemplate)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_GetCertificateTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) ListCertificateTemplates(ctx context.Context, in *ListCertificateTemplatesRequest, opts ...grpc.CallOption) (*ListCertificateTemplatesResponse, error) {
	out := new(ListCertificateTemplatesResponse)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_ListCertificateTemplates_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateAuthorityServiceClient) UpdateCertificateTemplate(ctx context.Context, in *UpdateCertificateTemplateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CertificateAuthorityService_UpdateCertificateTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CertificateAuthorityServiceServer is the server API for CertificateAuthorityService service.
// All implementations should embed UnimplementedCertificateAuthorityServiceServer
// for forward compatibility
type CertificateAuthorityServiceServer interface {
	// Create a new [Certificate][google.cloud.security.privateca.v1.Certificate]
	// in a given Project, Location from a particular
	// [CaPool][google.cloud.security.privateca.v1.CaPool].
	CreateCertificate(context.Context, *CreateCertificateRequest) (*Certificate, error)
	// Returns a [Certificate][google.cloud.security.privateca.v1.Certificate].
	GetCertificate(context.Context, *GetCertificateRequest) (*Certificate, error)
	// Lists [Certificates][google.cloud.security.privateca.v1.Certificate].
	ListCertificates(context.Context, *ListCertificatesRequest) (*ListCertificatesResponse, error)
	// Revoke a [Certificate][google.cloud.security.privateca.v1.Certificate].
	RevokeCertificate(context.Context, *RevokeCertificateRequest) (*Certificate, error)
	// Update a [Certificate][google.cloud.security.privateca.v1.Certificate].
	// Currently, the only field you can update is the
	// [labels][google.cloud.security.privateca.v1.Certificate.labels] field.
	UpdateCertificate(context.Context, *UpdateCertificateRequest) (*Certificate, error)
	// Activate a
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// that is in state
	// [AWAITING_USER_ACTIVATION][google.cloud.security.privateca.v1.CertificateAuthority.State.AWAITING_USER_ACTIVATION]
	// and is of type
	// [SUBORDINATE][google.cloud.security.privateca.v1.CertificateAuthority.Type.SUBORDINATE].
	// After the parent Certificate Authority signs a certificate signing request
	// from
	// [FetchCertificateAuthorityCsr][google.cloud.security.privateca.v1.CertificateAuthorityService.FetchCertificateAuthorityCsr],
	// this method can complete the activation process.
	ActivateCertificateAuthority(context.Context, *ActivateCertificateAuthorityRequest) (*longrunningpb.Operation, error)
	// Create a new
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// in a given Project and Location.
	CreateCertificateAuthority(context.Context, *CreateCertificateAuthorityRequest) (*longrunningpb.Operation, error)
	// Disable a
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
	DisableCertificateAuthority(context.Context, *DisableCertificateAuthorityRequest) (*longrunningpb.Operation, error)
	// Enable a
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
	EnableCertificateAuthority(context.Context, *EnableCertificateAuthorityRequest) (*longrunningpb.Operation, error)
	// Fetch a certificate signing request (CSR) from a
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// that is in state
	// [AWAITING_USER_ACTIVATION][google.cloud.security.privateca.v1.CertificateAuthority.State.AWAITING_USER_ACTIVATION]
	// and is of type
	// [SUBORDINATE][google.cloud.security.privateca.v1.CertificateAuthority.Type.SUBORDINATE].
	// The CSR must then be signed by the desired parent Certificate Authority,
	// which could be another
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// resource, or could be an on-prem certificate authority. See also
	// [ActivateCertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthorityService.ActivateCertificateAuthority].
	FetchCertificateAuthorityCsr(context.Context, *FetchCertificateAuthorityCsrRequest) (*FetchCertificateAuthorityCsrResponse, error)
	// Returns a
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
	GetCertificateAuthority(context.Context, *GetCertificateAuthorityRequest) (*CertificateAuthority, error)
	// Lists
	// [CertificateAuthorities][google.cloud.security.privateca.v1.CertificateAuthority].
	ListCertificateAuthorities(context.Context, *ListCertificateAuthoritiesRequest) (*ListCertificateAuthoritiesResponse, error)
	// Undelete a
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority]
	// that has been deleted.
	UndeleteCertificateAuthority(context.Context, *UndeleteCertificateAuthorityRequest) (*longrunningpb.Operation, error)
	// Delete a
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
	DeleteCertificateAuthority(context.Context, *DeleteCertificateAuthorityRequest) (*longrunningpb.Operation, error)
	// Update a
	// [CertificateAuthority][google.cloud.security.privateca.v1.CertificateAuthority].
	UpdateCertificateAuthority(context.Context, *UpdateCertificateAuthorityRequest) (*longrunningpb.Operation, error)
	// Create a [CaPool][google.cloud.security.privateca.v1.CaPool].
	CreateCaPool(context.Context, *CreateCaPoolRequest) (*longrunningpb.Operation, error)
	// Update a [CaPool][google.cloud.security.privateca.v1.CaPool].
	UpdateCaPool(context.Context, *UpdateCaPoolRequest) (*longrunningpb.Operation, error)
	// Returns a [CaPool][google.cloud.security.privateca.v1.CaPool].
	GetCaPool(context.Context, *GetCaPoolRequest) (*CaPool, error)
	// Lists [CaPools][google.cloud.security.privateca.v1.CaPool].
	ListCaPools(context.Context, *ListCaPoolsRequest) (*ListCaPoolsResponse, error)
	// Delete a [CaPool][google.cloud.security.privateca.v1.CaPool].
	DeleteCaPool(context.Context, *DeleteCaPoolRequest) (*longrunningpb.Operation, error)
	// FetchCaCerts returns the current trust anchor for the
	// [CaPool][google.cloud.security.privateca.v1.CaPool]. This will include CA
	// certificate chains for all certificate authorities in the ENABLED,
	// DISABLED, or STAGED states.
	FetchCaCerts(context.Context, *FetchCaCertsRequest) (*FetchCaCertsResponse, error)
	// Returns a
	// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList].
	GetCertificateRevocationList(context.Context, *GetCertificateRevocationListRequest) (*CertificateRevocationList, error)
	// Lists
	// [CertificateRevocationLists][google.cloud.security.privateca.v1.CertificateRevocationList].
	ListCertificateRevocationLists(context.Context, *ListCertificateRevocationListsRequest) (*ListCertificateRevocationListsResponse, error)
	// Update a
	// [CertificateRevocationList][google.cloud.security.privateca.v1.CertificateRevocationList].
	UpdateCertificateRevocationList(context.Context, *UpdateCertificateRevocationListRequest) (*longrunningpb.Operation, error)
	// Create a new
	// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate]
	// in a given Project and Location.
	CreateCertificateTemplate(context.Context, *CreateCertificateTemplateRequest) (*longrunningpb.Operation, error)
	// DeleteCertificateTemplate deletes a
	// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate].
	DeleteCertificateTemplate(context.Context, *DeleteCertificateTemplateRequest) (*longrunningpb.Operation, error)
	// Returns a
	// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate].
	GetCertificateTemplate(context.Context, *GetCertificateTemplateRequest) (*CertificateTemplate, error)
	// Lists
	// [CertificateTemplates][google.cloud.security.privateca.v1.CertificateTemplate].
	ListCertificateTemplates(context.Context, *ListCertificateTemplatesRequest) (*ListCertificateTemplatesResponse, error)
	// Update a
	// [CertificateTemplate][google.cloud.security.privateca.v1.CertificateTemplate].
	UpdateCertificateTemplate(context.Context, *UpdateCertificateTemplateRequest) (*longrunningpb.Operation, error)
}

// UnimplementedCertificateAuthorityServiceServer should be embedded to have forward compatible implementations.
type UnimplementedCertificateAuthorityServiceServer struct {
}

func (UnimplementedCertificateAuthorityServiceServer) CreateCertificate(context.Context, *CreateCertificateRequest) (*Certificate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCertificate not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) GetCertificate(context.Context, *GetCertificateRequest) (*Certificate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCertificate not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) ListCertificates(context.Context, *ListCertificatesRequest) (*ListCertificatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCertificates not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) RevokeCertificate(context.Context, *RevokeCertificateRequest) (*Certificate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevokeCertificate not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) UpdateCertificate(context.Context, *UpdateCertificateRequest) (*Certificate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCertificate not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) ActivateCertificateAuthority(context.Context, *ActivateCertificateAuthorityRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ActivateCertificateAuthority not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) CreateCertificateAuthority(context.Context, *CreateCertificateAuthorityRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCertificateAuthority not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) DisableCertificateAuthority(context.Context, *DisableCertificateAuthorityRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisableCertificateAuthority not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) EnableCertificateAuthority(context.Context, *EnableCertificateAuthorityRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnableCertificateAuthority not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) FetchCertificateAuthorityCsr(context.Context, *FetchCertificateAuthorityCsrRequest) (*FetchCertificateAuthorityCsrResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchCertificateAuthorityCsr not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) GetCertificateAuthority(context.Context, *GetCertificateAuthorityRequest) (*CertificateAuthority, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCertificateAuthority not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) ListCertificateAuthorities(context.Context, *ListCertificateAuthoritiesRequest) (*ListCertificateAuthoritiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCertificateAuthorities not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) UndeleteCertificateAuthority(context.Context, *UndeleteCertificateAuthorityRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeleteCertificateAuthority not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) DeleteCertificateAuthority(context.Context, *DeleteCertificateAuthorityRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCertificateAuthority not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) UpdateCertificateAuthority(context.Context, *UpdateCertificateAuthorityRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCertificateAuthority not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) CreateCaPool(context.Context, *CreateCaPoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCaPool not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) UpdateCaPool(context.Context, *UpdateCaPoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCaPool not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) GetCaPool(context.Context, *GetCaPoolRequest) (*CaPool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCaPool not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) ListCaPools(context.Context, *ListCaPoolsRequest) (*ListCaPoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCaPools not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) DeleteCaPool(context.Context, *DeleteCaPoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCaPool not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) FetchCaCerts(context.Context, *FetchCaCertsRequest) (*FetchCaCertsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchCaCerts not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) GetCertificateRevocationList(context.Context, *GetCertificateRevocationListRequest) (*CertificateRevocationList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCertificateRevocationList not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) ListCertificateRevocationLists(context.Context, *ListCertificateRevocationListsRequest) (*ListCertificateRevocationListsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCertificateRevocationLists not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) UpdateCertificateRevocationList(context.Context, *UpdateCertificateRevocationListRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCertificateRevocationList not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) CreateCertificateTemplate(context.Context, *CreateCertificateTemplateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCertificateTemplate not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) DeleteCertificateTemplate(context.Context, *DeleteCertificateTemplateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCertificateTemplate not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) GetCertificateTemplate(context.Context, *GetCertificateTemplateRequest) (*CertificateTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCertificateTemplate not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) ListCertificateTemplates(context.Context, *ListCertificateTemplatesRequest) (*ListCertificateTemplatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCertificateTemplates not implemented")
}
func (UnimplementedCertificateAuthorityServiceServer) UpdateCertificateTemplate(context.Context, *UpdateCertificateTemplateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCertificateTemplate not implemented")
}

// UnsafeCertificateAuthorityServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CertificateAuthorityServiceServer will
// result in compilation errors.
type UnsafeCertificateAuthorityServiceServer interface {
	mustEmbedUnimplementedCertificateAuthorityServiceServer()
}

func RegisterCertificateAuthorityServiceServer(s grpc.ServiceRegistrar, srv CertificateAuthorityServiceServer) {
	s.RegisterService(&CertificateAuthorityService_ServiceDesc, srv)
}

func _CertificateAuthorityService_CreateCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).CreateCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_CreateCertificate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).CreateCertificate(ctx, req.(*CreateCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_GetCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).GetCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_GetCertificate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).GetCertificate(ctx, req.(*GetCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_ListCertificates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCertificatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).ListCertificates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_ListCertificates_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).ListCertificates(ctx, req.(*ListCertificatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_RevokeCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevokeCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).RevokeCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_RevokeCertificate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).RevokeCertificate(ctx, req.(*RevokeCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_UpdateCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).UpdateCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_UpdateCertificate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).UpdateCertificate(ctx, req.(*UpdateCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_ActivateCertificateAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ActivateCertificateAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).ActivateCertificateAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_ActivateCertificateAuthority_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).ActivateCertificateAuthority(ctx, req.(*ActivateCertificateAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_CreateCertificateAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCertificateAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).CreateCertificateAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_CreateCertificateAuthority_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).CreateCertificateAuthority(ctx, req.(*CreateCertificateAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_DisableCertificateAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableCertificateAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).DisableCertificateAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_DisableCertificateAuthority_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).DisableCertificateAuthority(ctx, req.(*DisableCertificateAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_EnableCertificateAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableCertificateAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).EnableCertificateAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_EnableCertificateAuthority_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).EnableCertificateAuthority(ctx, req.(*EnableCertificateAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_FetchCertificateAuthorityCsr_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchCertificateAuthorityCsrRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).FetchCertificateAuthorityCsr(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_FetchCertificateAuthorityCsr_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).FetchCertificateAuthorityCsr(ctx, req.(*FetchCertificateAuthorityCsrRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_GetCertificateAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCertificateAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).GetCertificateAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_GetCertificateAuthority_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).GetCertificateAuthority(ctx, req.(*GetCertificateAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_ListCertificateAuthorities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCertificateAuthoritiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).ListCertificateAuthorities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_ListCertificateAuthorities_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).ListCertificateAuthorities(ctx, req.(*ListCertificateAuthoritiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_UndeleteCertificateAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteCertificateAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).UndeleteCertificateAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_UndeleteCertificateAuthority_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).UndeleteCertificateAuthority(ctx, req.(*UndeleteCertificateAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_DeleteCertificateAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCertificateAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).DeleteCertificateAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_DeleteCertificateAuthority_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).DeleteCertificateAuthority(ctx, req.(*DeleteCertificateAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_UpdateCertificateAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCertificateAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).UpdateCertificateAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_UpdateCertificateAuthority_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).UpdateCertificateAuthority(ctx, req.(*UpdateCertificateAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_CreateCaPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCaPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).CreateCaPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_CreateCaPool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).CreateCaPool(ctx, req.(*CreateCaPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_UpdateCaPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCaPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).UpdateCaPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_UpdateCaPool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).UpdateCaPool(ctx, req.(*UpdateCaPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_GetCaPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCaPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).GetCaPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_GetCaPool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).GetCaPool(ctx, req.(*GetCaPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_ListCaPools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCaPoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).ListCaPools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_ListCaPools_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).ListCaPools(ctx, req.(*ListCaPoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_DeleteCaPool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCaPoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).DeleteCaPool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_DeleteCaPool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).DeleteCaPool(ctx, req.(*DeleteCaPoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_FetchCaCerts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchCaCertsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).FetchCaCerts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_FetchCaCerts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).FetchCaCerts(ctx, req.(*FetchCaCertsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_GetCertificateRevocationList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCertificateRevocationListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).GetCertificateRevocationList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_GetCertificateRevocationList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).GetCertificateRevocationList(ctx, req.(*GetCertificateRevocationListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_ListCertificateRevocationLists_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCertificateRevocationListsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).ListCertificateRevocationLists(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_ListCertificateRevocationLists_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).ListCertificateRevocationLists(ctx, req.(*ListCertificateRevocationListsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_UpdateCertificateRevocationList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCertificateRevocationListRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).UpdateCertificateRevocationList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_UpdateCertificateRevocationList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).UpdateCertificateRevocationList(ctx, req.(*UpdateCertificateRevocationListRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_CreateCertificateTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCertificateTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).CreateCertificateTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_CreateCertificateTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).CreateCertificateTemplate(ctx, req.(*CreateCertificateTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_DeleteCertificateTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCertificateTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).DeleteCertificateTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_DeleteCertificateTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).DeleteCertificateTemplate(ctx, req.(*DeleteCertificateTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_GetCertificateTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCertificateTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).GetCertificateTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_GetCertificateTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).GetCertificateTemplate(ctx, req.(*GetCertificateTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_ListCertificateTemplates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCertificateTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).ListCertificateTemplates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_ListCertificateTemplates_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).ListCertificateTemplates(ctx, req.(*ListCertificateTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateAuthorityService_UpdateCertificateTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCertificateTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateAuthorityServiceServer).UpdateCertificateTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CertificateAuthorityService_UpdateCertificateTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateAuthorityServiceServer).UpdateCertificateTemplate(ctx, req.(*UpdateCertificateTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CertificateAuthorityService_ServiceDesc is the grpc.ServiceDesc for CertificateAuthorityService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CertificateAuthorityService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.security.privateca.v1.CertificateAuthorityService",
	HandlerType: (*CertificateAuthorityServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateCertificate",
			Handler:    _CertificateAuthorityService_CreateCertificate_Handler,
		},
		{
			MethodName: "GetCertificate",
			Handler:    _CertificateAuthorityService_GetCertificate_Handler,
		},
		{
			MethodName: "ListCertificates",
			Handler:    _CertificateAuthorityService_ListCertificates_Handler,
		},
		{
			MethodName: "RevokeCertificate",
			Handler:    _CertificateAuthorityService_RevokeCertificate_Handler,
		},
		{
			MethodName: "UpdateCertificate",
			Handler:    _CertificateAuthorityService_UpdateCertificate_Handler,
		},
		{
			MethodName: "ActivateCertificateAuthority",
			Handler:    _CertificateAuthorityService_ActivateCertificateAuthority_Handler,
		},
		{
			MethodName: "CreateCertificateAuthority",
			Handler:    _CertificateAuthorityService_CreateCertificateAuthority_Handler,
		},
		{
			MethodName: "DisableCertificateAuthority",
			Handler:    _CertificateAuthorityService_DisableCertificateAuthority_Handler,
		},
		{
			MethodName: "EnableCertificateAuthority",
			Handler:    _CertificateAuthorityService_EnableCertificateAuthority_Handler,
		},
		{
			MethodName: "FetchCertificateAuthorityCsr",
			Handler:    _CertificateAuthorityService_FetchCertificateAuthorityCsr_Handler,
		},
		{
			MethodName: "GetCertificateAuthority",
			Handler:    _CertificateAuthorityService_GetCertificateAuthority_Handler,
		},
		{
			MethodName: "ListCertificateAuthorities",
			Handler:    _CertificateAuthorityService_ListCertificateAuthorities_Handler,
		},
		{
			MethodName: "UndeleteCertificateAuthority",
			Handler:    _CertificateAuthorityService_UndeleteCertificateAuthority_Handler,
		},
		{
			MethodName: "DeleteCertificateAuthority",
			Handler:    _CertificateAuthorityService_DeleteCertificateAuthority_Handler,
		},
		{
			MethodName: "UpdateCertificateAuthority",
			Handler:    _CertificateAuthorityService_UpdateCertificateAuthority_Handler,
		},
		{
			MethodName: "CreateCaPool",
			Handler:    _CertificateAuthorityService_CreateCaPool_Handler,
		},
		{
			MethodName: "UpdateCaPool",
			Handler:    _CertificateAuthorityService_UpdateCaPool_Handler,
		},
		{
			MethodName: "GetCaPool",
			Handler:    _CertificateAuthorityService_GetCaPool_Handler,
		},
		{
			MethodName: "ListCaPools",
			Handler:    _CertificateAuthorityService_ListCaPools_Handler,
		},
		{
			MethodName: "DeleteCaPool",
			Handler:    _CertificateAuthorityService_DeleteCaPool_Handler,
		},
		{
			MethodName: "FetchCaCerts",
			Handler:    _CertificateAuthorityService_FetchCaCerts_Handler,
		},
		{
			MethodName: "GetCertificateRevocationList",
			Handler:    _CertificateAuthorityService_GetCertificateRevocationList_Handler,
		},
		{
			MethodName: "ListCertificateRevocationLists",
			Handler:    _CertificateAuthorityService_ListCertificateRevocationLists_Handler,
		},
		{
			MethodName: "UpdateCertificateRevocationList",
			Handler:    _CertificateAuthorityService_UpdateCertificateRevocationList_Handler,
		},
		{
			MethodName: "CreateCertificateTemplate",
			Handler:    _CertificateAuthorityService_CreateCertificateTemplate_Handler,
		},
		{
			MethodName: "DeleteCertificateTemplate",
			Handler:    _CertificateAuthorityService_DeleteCertificateTemplate_Handler,
		},
		{
			MethodName: "GetCertificateTemplate",
			Handler:    _CertificateAuthorityService_GetCertificateTemplate_Handler,
		},
		{
			MethodName: "ListCertificateTemplates",
			Handler:    _CertificateAuthorityService_ListCertificateTemplates_Handler,
		},
		{
			MethodName: "UpdateCertificateTemplate",
			Handler:    _CertificateAuthorityService_UpdateCertificateTemplate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/security/privateca/v1/service.proto",
}
