// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/retail/v2beta/import_config.proto

package retailpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	date "google.golang.org/genproto/googleapis/type/date"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Indicates how imported products are reconciled with the existing products
// created or imported before.
type ImportProductsRequest_ReconciliationMode int32

const (
	// Defaults to INCREMENTAL.
	ImportProductsRequest_RECONCILIATION_MODE_UNSPECIFIED ImportProductsRequest_ReconciliationMode = 0
	// Inserts new products or updates existing products.
	ImportProductsRequest_INCREMENTAL ImportProductsRequest_ReconciliationMode = 1
	// Calculates diff and replaces the entire product dataset. Existing
	// products may be deleted if they are not present in the source location.
	ImportProductsRequest_FULL ImportProductsRequest_ReconciliationMode = 2
)

// Enum value maps for ImportProductsRequest_ReconciliationMode.
var (
	ImportProductsRequest_ReconciliationMode_name = map[int32]string{
		0: "RECONCILIATION_MODE_UNSPECIFIED",
		1: "INCREMENTAL",
		2: "FULL",
	}
	ImportProductsRequest_ReconciliationMode_value = map[string]int32{
		"RECONCILIATION_MODE_UNSPECIFIED": 0,
		"INCREMENTAL":                     1,
		"FULL":                            2,
	}
)

func (x ImportProductsRequest_ReconciliationMode) Enum() *ImportProductsRequest_ReconciliationMode {
	p := new(ImportProductsRequest_ReconciliationMode)
	*p = x
	return p
}

func (x ImportProductsRequest_ReconciliationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImportProductsRequest_ReconciliationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_retail_v2beta_import_config_proto_enumTypes[0].Descriptor()
}

func (ImportProductsRequest_ReconciliationMode) Type() protoreflect.EnumType {
	return &file_google_cloud_retail_v2beta_import_config_proto_enumTypes[0]
}

func (x ImportProductsRequest_ReconciliationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImportProductsRequest_ReconciliationMode.Descriptor instead.
func (ImportProductsRequest_ReconciliationMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_import_config_proto_rawDescGZIP(), []int{5, 0}
}

// Google Cloud Storage location for input content.
type GcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Google Cloud Storage URIs to input files. URI can be up to
	// 2000 characters long. URIs can match the full object path (for example,
	// `gs://bucket/directory/object.json`) or a pattern matching one or more
	// files, such as `gs://bucket/directory/*.json`. A request can
	// contain at most 100 files, and each file can be up to 2 GB. See
	// [Importing product
	// information](https://cloud.google.com/retail/recommendations-ai/docs/upload-catalog)
	// for the expected file format and setup instructions.
	InputUris []string `protobuf:"bytes,1,rep,name=input_uris,json=inputUris,proto3" json:"input_uris,omitempty"`
	// The schema to use when parsing the data from the source.
	//
	// Supported values for product imports:
	//
	// * `product` (default): One JSON
	// [Product][google.cloud.retail.v2beta.Product] per line. Each product must
	//
	//	have a valid [Product.id][google.cloud.retail.v2beta.Product.id].
	//   - `product_merchant_center`: See [Importing catalog data from Merchant
	//     Center](https://cloud.google.com/retail/recommendations-ai/docs/upload-catalog#mc).
	//
	// Supported values for user events imports:
	//
	// * `user_event` (default): One JSON
	// [UserEvent][google.cloud.retail.v2beta.UserEvent] per line.
	//   - `user_event_ga360`: Using
	//     https://support.google.com/analytics/answer/3437719.
	//
	// Supported values for control imports:
	//
	// * `control` (default): One JSON
	// [Control][google.cloud.retail.v2beta.Control] per line.
	//
	// Supported values for catalog attribute imports:
	//
	// * `catalog_attribute` (default): One CSV
	// [CatalogAttribute][google.cloud.retail.v2beta.CatalogAttribute] per line.
	DataSchema string `protobuf:"bytes,2,opt,name=data_schema,json=dataSchema,proto3" json:"data_schema,omitempty"`
}

func (x *GcsSource) Reset() {
	*x = GcsSource{}
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsSource) ProtoMessage() {}

func (x *GcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsSource.ProtoReflect.Descriptor instead.
func (*GcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_import_config_proto_rawDescGZIP(), []int{0}
}

func (x *GcsSource) GetInputUris() []string {
	if x != nil {
		return x.InputUris
	}
	return nil
}

func (x *GcsSource) GetDataSchema() string {
	if x != nil {
		return x.DataSchema
	}
	return ""
}

// BigQuery source import data from.
type BigQuerySource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// BigQuery table partition info. Leave this empty if the BigQuery table
	// is not partitioned.
	//
	// Types that are assignable to Partition:
	//
	//	*BigQuerySource_PartitionDate
	Partition isBigQuerySource_Partition `protobuf_oneof:"partition"`
	// The project ID (can be project # or ID) that the BigQuery source is in with
	// a length limit of 128 characters. If not specified, inherits the project
	// ID from the parent request.
	ProjectId string `protobuf:"bytes,5,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The BigQuery data set to copy the data from with a length limit
	// of 1,024 characters.
	DatasetId string `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Required. The BigQuery table to copy the data from with a length limit of
	// 1,024 characters.
	TableId string `protobuf:"bytes,2,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	// Intermediate Cloud Storage directory used for the import with a length
	// limit of 2,000 characters. Can be specified if one wants to have the
	// BigQuery export to a specific Cloud Storage directory.
	GcsStagingDir string `protobuf:"bytes,3,opt,name=gcs_staging_dir,json=gcsStagingDir,proto3" json:"gcs_staging_dir,omitempty"`
	// The schema to use when parsing the data from the source.
	//
	// Supported values for product imports:
	//
	// * `product` (default): One JSON
	// [Product][google.cloud.retail.v2beta.Product] per line. Each product must
	//
	//	have a valid [Product.id][google.cloud.retail.v2beta.Product.id].
	//   - `product_merchant_center`: See [Importing catalog data from Merchant
	//     Center](https://cloud.google.com/retail/recommendations-ai/docs/upload-catalog#mc).
	//
	// Supported values for user events imports:
	//
	// * `user_event` (default): One JSON
	// [UserEvent][google.cloud.retail.v2beta.UserEvent] per line.
	//   - `user_event_ga360`:
	//     The schema is available here:
	//     https://support.google.com/analytics/answer/3437719.
	//   - `user_event_ga4`:
	//     The schema is available here:
	//     https://support.google.com/analytics/answer/7029846.
	//
	// Supported values for autocomplete imports:
	//
	// * `suggestions` (default): One JSON completion suggestion per line.
	// * `denylist`:  One JSON deny suggestion per line.
	// * `allowlist`:  One JSON allow suggestion per line.
	DataSchema string `protobuf:"bytes,4,opt,name=data_schema,json=dataSchema,proto3" json:"data_schema,omitempty"`
}

func (x *BigQuerySource) Reset() {
	*x = BigQuerySource{}
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BigQuerySource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQuerySource) ProtoMessage() {}

func (x *BigQuerySource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQuerySource.ProtoReflect.Descriptor instead.
func (*BigQuerySource) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_import_config_proto_rawDescGZIP(), []int{1}
}

func (m *BigQuerySource) GetPartition() isBigQuerySource_Partition {
	if m != nil {
		return m.Partition
	}
	return nil
}

func (x *BigQuerySource) GetPartitionDate() *date.Date {
	if x, ok := x.GetPartition().(*BigQuerySource_PartitionDate); ok {
		return x.PartitionDate
	}
	return nil
}

func (x *BigQuerySource) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *BigQuerySource) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *BigQuerySource) GetTableId() string {
	if x != nil {
		return x.TableId
	}
	return ""
}

func (x *BigQuerySource) GetGcsStagingDir() string {
	if x != nil {
		return x.GcsStagingDir
	}
	return ""
}

func (x *BigQuerySource) GetDataSchema() string {
	if x != nil {
		return x.DataSchema
	}
	return ""
}

type isBigQuerySource_Partition interface {
	isBigQuerySource_Partition()
}

type BigQuerySource_PartitionDate struct {
	// BigQuery time partitioned table's _PARTITIONDATE in YYYY-MM-DD format.
	PartitionDate *date.Date `protobuf:"bytes,6,opt,name=partition_date,json=partitionDate,proto3,oneof"`
}

func (*BigQuerySource_PartitionDate) isBigQuerySource_Partition() {}

// The inline source for the input config for ImportProducts method.
type ProductInlineSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of products to update/create. Each product must have a
	// valid [Product.id][google.cloud.retail.v2beta.Product.id]. Recommended max
	// of 100 items.
	Products []*Product `protobuf:"bytes,1,rep,name=products,proto3" json:"products,omitempty"`
}

func (x *ProductInlineSource) Reset() {
	*x = ProductInlineSource{}
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProductInlineSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductInlineSource) ProtoMessage() {}

func (x *ProductInlineSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductInlineSource.ProtoReflect.Descriptor instead.
func (*ProductInlineSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_import_config_proto_rawDescGZIP(), []int{2}
}

func (x *ProductInlineSource) GetProducts() []*Product {
	if x != nil {
		return x.Products
	}
	return nil
}

// The inline source for the input config for ImportUserEvents method.
type UserEventInlineSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of user events to import. Recommended max of 10k items.
	UserEvents []*UserEvent `protobuf:"bytes,1,rep,name=user_events,json=userEvents,proto3" json:"user_events,omitempty"`
}

func (x *UserEventInlineSource) Reset() {
	*x = UserEventInlineSource{}
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserEventInlineSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserEventInlineSource) ProtoMessage() {}

func (x *UserEventInlineSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserEventInlineSource.ProtoReflect.Descriptor instead.
func (*UserEventInlineSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_import_config_proto_rawDescGZIP(), []int{3}
}

func (x *UserEventInlineSource) GetUserEvents() []*UserEvent {
	if x != nil {
		return x.UserEvents
	}
	return nil
}

// Configuration of destination for Import related errors.
type ImportErrorsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Errors destination.
	//
	// Types that are assignable to Destination:
	//
	//	*ImportErrorsConfig_GcsPrefix
	Destination isImportErrorsConfig_Destination `protobuf_oneof:"destination"`
}

func (x *ImportErrorsConfig) Reset() {
	*x = ImportErrorsConfig{}
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportErrorsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportErrorsConfig) ProtoMessage() {}

func (x *ImportErrorsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportErrorsConfig.ProtoReflect.Descriptor instead.
func (*ImportErrorsConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_import_config_proto_rawDescGZIP(), []int{4}
}

func (m *ImportErrorsConfig) GetDestination() isImportErrorsConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ImportErrorsConfig) GetGcsPrefix() string {
	if x, ok := x.GetDestination().(*ImportErrorsConfig_GcsPrefix); ok {
		return x.GcsPrefix
	}
	return ""
}

type isImportErrorsConfig_Destination interface {
	isImportErrorsConfig_Destination()
}

type ImportErrorsConfig_GcsPrefix struct {
	// Google Cloud Storage prefix for import errors. This must be an empty,
	// existing Cloud Storage directory. Import errors are written to
	// sharded files in this directory, one per line, as a JSON-encoded
	// `google.rpc.Status` message.
	GcsPrefix string `protobuf:"bytes,1,opt,name=gcs_prefix,json=gcsPrefix,proto3,oneof"`
}

func (*ImportErrorsConfig_GcsPrefix) isImportErrorsConfig_Destination() {}

// Request message for Import methods.
type ImportProductsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	// `projects/1234/locations/global/catalogs/default_catalog/branches/default_branch`
	//
	// If no updateMask is specified, requires products.create permission.
	// If updateMask is specified, requires products.update permission.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Deprecated. This field has no effect.
	//
	// Deprecated: Marked as deprecated in google/cloud/retail/v2beta/import_config.proto.
	RequestId string `protobuf:"bytes,6,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Required. The desired input location of the data.
	InputConfig *ProductInputConfig `protobuf:"bytes,2,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// The desired location of errors incurred during the Import.
	ErrorsConfig *ImportErrorsConfig `protobuf:"bytes,3,opt,name=errors_config,json=errorsConfig,proto3" json:"errors_config,omitempty"`
	// Indicates which fields in the provided imported `products` to update. If
	// not set, all fields are updated. If provided, only the existing product
	// fields are updated. Missing products will not be created.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mode of reconciliation between existing products and the products to be
	// imported. Defaults to
	// [ReconciliationMode.INCREMENTAL][google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode.INCREMENTAL].
	ReconciliationMode ImportProductsRequest_ReconciliationMode `protobuf:"varint,5,opt,name=reconciliation_mode,json=reconciliationMode,proto3,enum=google.cloud.retail.v2beta.ImportProductsRequest_ReconciliationMode" json:"reconciliation_mode,omitempty"`
	// Full Pub/Sub topic name for receiving notification. If this field is set,
	// when the import is finished, a notification is sent to
	// specified Pub/Sub topic. The message data is JSON string of a
	// [Operation][google.longrunning.Operation].
	//
	// Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`. It has
	// to be within the same project as
	// [ImportProductsRequest.parent][google.cloud.retail.v2beta.ImportProductsRequest.parent].
	// Make sure that both
	// `cloud-retail-customer-data-access@system.gserviceaccount.com` and
	// `service-<project number>@gcp-sa-retail.iam.gserviceaccount.com`
	// have the `pubsub.topics.publish` IAM permission on the topic.
	//
	// Only supported when
	// [ImportProductsRequest.reconciliation_mode][google.cloud.retail.v2beta.ImportProductsRequest.reconciliation_mode]
	// is set to `FULL`.
	NotificationPubsubTopic string `protobuf:"bytes,7,opt,name=notification_pubsub_topic,json=notificationPubsubTopic,proto3" json:"notification_pubsub_topic,omitempty"`
}

func (x *ImportProductsRequest) Reset() {
	*x = ImportProductsRequest{}
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportProductsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportProductsRequest) ProtoMessage() {}

func (x *ImportProductsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportProductsRequest.ProtoReflect.Descriptor instead.
func (*ImportProductsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_import_config_proto_rawDescGZIP(), []int{5}
}

func (x *ImportProductsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/retail/v2beta/import_config.proto.
func (x *ImportProductsRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *ImportProductsRequest) GetInputConfig() *ProductInputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

func (x *ImportProductsRequest) GetErrorsConfig() *ImportErrorsConfig {
	if x != nil {
		return x.ErrorsConfig
	}
	return nil
}

func (x *ImportProductsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *ImportProductsRequest) GetReconciliationMode() ImportProductsRequest_ReconciliationMode {
	if x != nil {
		return x.ReconciliationMode
	}
	return ImportProductsRequest_RECONCILIATION_MODE_UNSPECIFIED
}

func (x *ImportProductsRequest) GetNotificationPubsubTopic() string {
	if x != nil {
		return x.NotificationPubsubTopic
	}
	return ""
}

// Request message for the ImportUserEvents request.
type ImportUserEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. `projects/1234/locations/global/catalogs/default_catalog`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The desired input location of the data.
	InputConfig *UserEventInputConfig `protobuf:"bytes,2,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// The desired location of errors incurred during the Import. Cannot be set
	// for inline user event imports.
	ErrorsConfig *ImportErrorsConfig `protobuf:"bytes,3,opt,name=errors_config,json=errorsConfig,proto3" json:"errors_config,omitempty"`
}

func (x *ImportUserEventsRequest) Reset() {
	*x = ImportUserEventsRequest{}
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportUserEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportUserEventsRequest) ProtoMessage() {}

func (x *ImportUserEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportUserEventsRequest.ProtoReflect.Descriptor instead.
func (*ImportUserEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_import_config_proto_rawDescGZIP(), []int{6}
}

func (x *ImportUserEventsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ImportUserEventsRequest) GetInputConfig() *UserEventInputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

func (x *ImportUserEventsRequest) GetErrorsConfig() *ImportErrorsConfig {
	if x != nil {
		return x.ErrorsConfig
	}
	return nil
}

// Request message for ImportCompletionData methods.
type ImportCompletionDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The catalog which the suggestions dataset belongs to.
	//
	// Format: `projects/1234/locations/global/catalogs/default_catalog`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The desired input location of the data.
	InputConfig *CompletionDataInputConfig `protobuf:"bytes,2,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Pub/Sub topic for receiving notification. If this field is set,
	// when the import is finished, a notification is sent to
	// specified Pub/Sub topic. The message data is JSON string of a
	// [Operation][google.longrunning.Operation].
	// Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`.
	NotificationPubsubTopic string `protobuf:"bytes,3,opt,name=notification_pubsub_topic,json=notificationPubsubTopic,proto3" json:"notification_pubsub_topic,omitempty"`
}

func (x *ImportCompletionDataRequest) Reset() {
	*x = ImportCompletionDataRequest{}
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportCompletionDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportCompletionDataRequest) ProtoMessage() {}

func (x *ImportCompletionDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportCompletionDataRequest.ProtoReflect.Descriptor instead.
func (*ImportCompletionDataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_import_config_proto_rawDescGZIP(), []int{7}
}

func (x *ImportCompletionDataRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ImportCompletionDataRequest) GetInputConfig() *CompletionDataInputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

func (x *ImportCompletionDataRequest) GetNotificationPubsubTopic() string {
	if x != nil {
		return x.NotificationPubsubTopic
	}
	return ""
}

// The input config source for products.
type ProductInputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The source of the input.
	//
	// Types that are assignable to Source:
	//
	//	*ProductInputConfig_ProductInlineSource
	//	*ProductInputConfig_GcsSource
	//	*ProductInputConfig_BigQuerySource
	Source isProductInputConfig_Source `protobuf_oneof:"source"`
}

func (x *ProductInputConfig) Reset() {
	*x = ProductInputConfig{}
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProductInputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductInputConfig) ProtoMessage() {}

func (x *ProductInputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductInputConfig.ProtoReflect.Descriptor instead.
func (*ProductInputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_import_config_proto_rawDescGZIP(), []int{8}
}

func (m *ProductInputConfig) GetSource() isProductInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ProductInputConfig) GetProductInlineSource() *ProductInlineSource {
	if x, ok := x.GetSource().(*ProductInputConfig_ProductInlineSource); ok {
		return x.ProductInlineSource
	}
	return nil
}

func (x *ProductInputConfig) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*ProductInputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *ProductInputConfig) GetBigQuerySource() *BigQuerySource {
	if x, ok := x.GetSource().(*ProductInputConfig_BigQuerySource); ok {
		return x.BigQuerySource
	}
	return nil
}

type isProductInputConfig_Source interface {
	isProductInputConfig_Source()
}

type ProductInputConfig_ProductInlineSource struct {
	// The Inline source for the input content for products.
	ProductInlineSource *ProductInlineSource `protobuf:"bytes,1,opt,name=product_inline_source,json=productInlineSource,proto3,oneof"`
}

type ProductInputConfig_GcsSource struct {
	// Google Cloud Storage location for the input content.
	GcsSource *GcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type ProductInputConfig_BigQuerySource struct {
	// BigQuery input source.
	BigQuerySource *BigQuerySource `protobuf:"bytes,3,opt,name=big_query_source,json=bigQuerySource,proto3,oneof"`
}

func (*ProductInputConfig_ProductInlineSource) isProductInputConfig_Source() {}

func (*ProductInputConfig_GcsSource) isProductInputConfig_Source() {}

func (*ProductInputConfig_BigQuerySource) isProductInputConfig_Source() {}

// The input config source for user events.
type UserEventInputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source of the input.
	//
	// Types that are assignable to Source:
	//
	//	*UserEventInputConfig_UserEventInlineSource
	//	*UserEventInputConfig_GcsSource
	//	*UserEventInputConfig_BigQuerySource
	Source isUserEventInputConfig_Source `protobuf_oneof:"source"`
}

func (x *UserEventInputConfig) Reset() {
	*x = UserEventInputConfig{}
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserEventInputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserEventInputConfig) ProtoMessage() {}

func (x *UserEventInputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserEventInputConfig.ProtoReflect.Descriptor instead.
func (*UserEventInputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_import_config_proto_rawDescGZIP(), []int{9}
}

func (m *UserEventInputConfig) GetSource() isUserEventInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *UserEventInputConfig) GetUserEventInlineSource() *UserEventInlineSource {
	if x, ok := x.GetSource().(*UserEventInputConfig_UserEventInlineSource); ok {
		return x.UserEventInlineSource
	}
	return nil
}

func (x *UserEventInputConfig) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*UserEventInputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *UserEventInputConfig) GetBigQuerySource() *BigQuerySource {
	if x, ok := x.GetSource().(*UserEventInputConfig_BigQuerySource); ok {
		return x.BigQuerySource
	}
	return nil
}

type isUserEventInputConfig_Source interface {
	isUserEventInputConfig_Source()
}

type UserEventInputConfig_UserEventInlineSource struct {
	// Required. The Inline source for the input content for UserEvents.
	UserEventInlineSource *UserEventInlineSource `protobuf:"bytes,1,opt,name=user_event_inline_source,json=userEventInlineSource,proto3,oneof"`
}

type UserEventInputConfig_GcsSource struct {
	// Required. Google Cloud Storage location for the input content.
	GcsSource *GcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type UserEventInputConfig_BigQuerySource struct {
	// Required. BigQuery input source.
	BigQuerySource *BigQuerySource `protobuf:"bytes,3,opt,name=big_query_source,json=bigQuerySource,proto3,oneof"`
}

func (*UserEventInputConfig_UserEventInlineSource) isUserEventInputConfig_Source() {}

func (*UserEventInputConfig_GcsSource) isUserEventInputConfig_Source() {}

func (*UserEventInputConfig_BigQuerySource) isUserEventInputConfig_Source() {}

// The input config source for completion data.
type CompletionDataInputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source of the input.
	//
	// Supported
	// [BigQuerySource.data_schema][google.cloud.retail.v2beta.BigQuerySource.data_schema]
	// values for suggestions imports:
	//
	// * `suggestions` (default): One JSON completion suggestion per line.
	// * `denylist`:  One JSON deny suggestion per line.
	// * `allowlist`:  One JSON allow suggestion per line.
	//
	// Types that are assignable to Source:
	//
	//	*CompletionDataInputConfig_BigQuerySource
	Source isCompletionDataInputConfig_Source `protobuf_oneof:"source"`
}

func (x *CompletionDataInputConfig) Reset() {
	*x = CompletionDataInputConfig{}
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CompletionDataInputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompletionDataInputConfig) ProtoMessage() {}

func (x *CompletionDataInputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompletionDataInputConfig.ProtoReflect.Descriptor instead.
func (*CompletionDataInputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_import_config_proto_rawDescGZIP(), []int{10}
}

func (m *CompletionDataInputConfig) GetSource() isCompletionDataInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *CompletionDataInputConfig) GetBigQuerySource() *BigQuerySource {
	if x, ok := x.GetSource().(*CompletionDataInputConfig_BigQuerySource); ok {
		return x.BigQuerySource
	}
	return nil
}

type isCompletionDataInputConfig_Source interface {
	isCompletionDataInputConfig_Source()
}

type CompletionDataInputConfig_BigQuerySource struct {
	// Required. BigQuery input source.
	//
	// Add the IAM permission "BigQuery Data Viewer" for
	// cloud-retail-customer-data-access@system.gserviceaccount.com before
	// using this feature otherwise an error is thrown.
	BigQuerySource *BigQuerySource `protobuf:"bytes,1,opt,name=big_query_source,json=bigQuerySource,proto3,oneof"`
}

func (*CompletionDataInputConfig_BigQuerySource) isCompletionDataInputConfig_Source() {}

// Metadata related to the progress of the Import operation. This is
// returned by the google.longrunning.Operation.metadata field.
type ImportMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation create time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Count of entries that were processed successfully.
	SuccessCount int64 `protobuf:"varint,3,opt,name=success_count,json=successCount,proto3" json:"success_count,omitempty"`
	// Count of entries that encountered errors while processing.
	FailureCount int64 `protobuf:"varint,4,opt,name=failure_count,json=failureCount,proto3" json:"failure_count,omitempty"`
	// Deprecated. This field is never set.
	//
	// Deprecated: Marked as deprecated in google/cloud/retail/v2beta/import_config.proto.
	RequestId string `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Pub/Sub topic for receiving notification. If this field is set,
	// when the import is finished, a notification is sent to
	// specified Pub/Sub topic. The message data is JSON string of a
	// [Operation][google.longrunning.Operation].
	// Format of the Pub/Sub topic is `projects/{project}/topics/{topic}`.
	NotificationPubsubTopic string `protobuf:"bytes,6,opt,name=notification_pubsub_topic,json=notificationPubsubTopic,proto3" json:"notification_pubsub_topic,omitempty"`
}

func (x *ImportMetadata) Reset() {
	*x = ImportMetadata{}
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportMetadata) ProtoMessage() {}

func (x *ImportMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportMetadata.ProtoReflect.Descriptor instead.
func (*ImportMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_import_config_proto_rawDescGZIP(), []int{11}
}

func (x *ImportMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ImportMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ImportMetadata) GetSuccessCount() int64 {
	if x != nil {
		return x.SuccessCount
	}
	return 0
}

func (x *ImportMetadata) GetFailureCount() int64 {
	if x != nil {
		return x.FailureCount
	}
	return 0
}

// Deprecated: Marked as deprecated in google/cloud/retail/v2beta/import_config.proto.
func (x *ImportMetadata) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *ImportMetadata) GetNotificationPubsubTopic() string {
	if x != nil {
		return x.NotificationPubsubTopic
	}
	return ""
}

// Response of the
// [ImportProductsRequest][google.cloud.retail.v2beta.ImportProductsRequest]. If
// the long running operation is done, then this message is returned by the
// google.longrunning.Operations.response field if the operation was successful.
type ImportProductsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A sample of errors encountered while processing the request.
	ErrorSamples []*status.Status `protobuf:"bytes,1,rep,name=error_samples,json=errorSamples,proto3" json:"error_samples,omitempty"`
	// Echoes the destination for the complete errors in the request if set.
	ErrorsConfig *ImportErrorsConfig `protobuf:"bytes,2,opt,name=errors_config,json=errorsConfig,proto3" json:"errors_config,omitempty"`
}

func (x *ImportProductsResponse) Reset() {
	*x = ImportProductsResponse{}
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportProductsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportProductsResponse) ProtoMessage() {}

func (x *ImportProductsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportProductsResponse.ProtoReflect.Descriptor instead.
func (*ImportProductsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_import_config_proto_rawDescGZIP(), []int{12}
}

func (x *ImportProductsResponse) GetErrorSamples() []*status.Status {
	if x != nil {
		return x.ErrorSamples
	}
	return nil
}

func (x *ImportProductsResponse) GetErrorsConfig() *ImportErrorsConfig {
	if x != nil {
		return x.ErrorsConfig
	}
	return nil
}

// Response of the ImportUserEventsRequest. If the long running
// operation was successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was successful.
type ImportUserEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A sample of errors encountered while processing the request.
	ErrorSamples []*status.Status `protobuf:"bytes,1,rep,name=error_samples,json=errorSamples,proto3" json:"error_samples,omitempty"`
	// Echoes the destination for the complete errors if this field was set in
	// the request.
	ErrorsConfig *ImportErrorsConfig `protobuf:"bytes,2,opt,name=errors_config,json=errorsConfig,proto3" json:"errors_config,omitempty"`
	// Aggregated statistics of user event import status.
	ImportSummary *UserEventImportSummary `protobuf:"bytes,3,opt,name=import_summary,json=importSummary,proto3" json:"import_summary,omitempty"`
}

func (x *ImportUserEventsResponse) Reset() {
	*x = ImportUserEventsResponse{}
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportUserEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportUserEventsResponse) ProtoMessage() {}

func (x *ImportUserEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportUserEventsResponse.ProtoReflect.Descriptor instead.
func (*ImportUserEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_import_config_proto_rawDescGZIP(), []int{13}
}

func (x *ImportUserEventsResponse) GetErrorSamples() []*status.Status {
	if x != nil {
		return x.ErrorSamples
	}
	return nil
}

func (x *ImportUserEventsResponse) GetErrorsConfig() *ImportErrorsConfig {
	if x != nil {
		return x.ErrorsConfig
	}
	return nil
}

func (x *ImportUserEventsResponse) GetImportSummary() *UserEventImportSummary {
	if x != nil {
		return x.ImportSummary
	}
	return nil
}

// A summary of import result. The UserEventImportSummary summarizes
// the import status for user events.
type UserEventImportSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Count of user events imported with complete existing catalog information.
	JoinedEventsCount int64 `protobuf:"varint,1,opt,name=joined_events_count,json=joinedEventsCount,proto3" json:"joined_events_count,omitempty"`
	// Count of user events imported, but with catalog information not found
	// in the imported catalog.
	UnjoinedEventsCount int64 `protobuf:"varint,2,opt,name=unjoined_events_count,json=unjoinedEventsCount,proto3" json:"unjoined_events_count,omitempty"`
}

func (x *UserEventImportSummary) Reset() {
	*x = UserEventImportSummary{}
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserEventImportSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserEventImportSummary) ProtoMessage() {}

func (x *UserEventImportSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserEventImportSummary.ProtoReflect.Descriptor instead.
func (*UserEventImportSummary) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_import_config_proto_rawDescGZIP(), []int{14}
}

func (x *UserEventImportSummary) GetJoinedEventsCount() int64 {
	if x != nil {
		return x.JoinedEventsCount
	}
	return 0
}

func (x *UserEventImportSummary) GetUnjoinedEventsCount() int64 {
	if x != nil {
		return x.UnjoinedEventsCount
	}
	return 0
}

// Response of the
// [ImportCompletionDataRequest][google.cloud.retail.v2beta.ImportCompletionDataRequest].
// If the long running operation is done, this message is returned by the
// google.longrunning.Operations.response field if the operation is successful.
type ImportCompletionDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A sample of errors encountered while processing the request.
	ErrorSamples []*status.Status `protobuf:"bytes,1,rep,name=error_samples,json=errorSamples,proto3" json:"error_samples,omitempty"`
}

func (x *ImportCompletionDataResponse) Reset() {
	*x = ImportCompletionDataResponse{}
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportCompletionDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportCompletionDataResponse) ProtoMessage() {}

func (x *ImportCompletionDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_retail_v2beta_import_config_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportCompletionDataResponse.ProtoReflect.Descriptor instead.
func (*ImportCompletionDataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_retail_v2beta_import_config_proto_rawDescGZIP(), []int{15}
}

func (x *ImportCompletionDataResponse) GetErrorSamples() []*status.Status {
	if x != nil {
		return x.ErrorSamples
	}
	return nil
}

var File_google_cloud_retail_v2beta_import_config_proto protoreflect.FileDescriptor

var file_google_cloud_retail_v2beta_import_config_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x69, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x50, 0x0a, 0x09, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x55, 0x72, 0x69, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x85, 0x02, 0x0a, 0x0e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x3a, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44,
	0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x08, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x73,
	0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x67, 0x63, 0x73, 0x53, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x72, 0x12,
	0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x42, 0x0b, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5b, 0x0a,
	0x13, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x44, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x08, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x22, 0x64, 0x0a, 0x15, 0x55, 0x73,
	0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x4b, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73,
	0x22, 0x44, 0x0a, 0x12, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63,
	0x73, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xeb, 0x04, 0x0a, 0x15, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x21,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x12, 0x56, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x53, 0x0a, 0x0d, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x75, 0x0a, 0x13, 0x72,
	0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52, 0x65, 0x63, 0x6f,
	0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x12,
	0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x3a, 0x0a, 0x19, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x22, 0x54,
	0x0a, 0x12, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x6f, 0x64, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x45, 0x43, 0x4f, 0x4e, 0x43, 0x49, 0x4c,
	0x49, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x43,
	0x52, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55,
	0x4c, 0x4c, 0x10, 0x02, 0x22, 0x87, 0x02, 0x0a, 0x17, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x55,
	0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x58, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x53, 0x0a, 0x0d, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xf7,
	0x01, 0x0a, 0x1b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5d, 0x0a,
	0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x0a, 0x19,
	0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x17, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x22, 0xa5, 0x02, 0x0a, 0x12, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x65, 0x0a, 0x15, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x69, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48,
	0x00, 0x52, 0x13, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x46, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x56,
	0x0a, 0x10, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x22, 0xbd, 0x02, 0x0a, 0x14, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x71, 0x0a, 0x18, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x15, 0x75, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4b, 0x0a, 0x0a,
	0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x63,
	0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x09,
	0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5b, 0x0a, 0x10, 0x62, 0x69, 0x67,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x22, 0x82, 0x01, 0x0a, 0x19, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x61, 0x74, 0x61, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5b,
	0x0a, 0x10, 0x62, 0x69, 0x67, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0e, 0x62, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xb3, 0x02, 0x0a, 0x0e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x73, 0x75, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c,
	0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12,
	0x3a, 0x0a, 0x19, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x17, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x22, 0xa6, 0x01, 0x0a, 0x16,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f,
	0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12,
	0x53, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0x83, 0x02, 0x0a, 0x18, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x55,
	0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x37, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x0d, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x59, 0x0a, 0x0e, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x0d, 0x69, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x22, 0x7c, 0x0a, 0x16, 0x55, 0x73,
	0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x6d,
	0x6d, 0x61, 0x72, 0x79, 0x12, 0x2e, 0x0a, 0x13, 0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x11, 0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x75, 0x6e, 0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64,
	0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x13, 0x75, 0x6e, 0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x57, 0x0a, 0x1c, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x73, 0x42, 0xd0, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x42, 0x11, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x72,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70, 0x62, 0x3b, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x70,
	0x62, 0xa2, 0x02, 0x06, 0x52, 0x45, 0x54, 0x41, 0x49, 0x4c, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x56, 0x32, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x5c, 0x56, 0x32,
	0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x3a, 0x3a, 0x56, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_retail_v2beta_import_config_proto_rawDescOnce sync.Once
	file_google_cloud_retail_v2beta_import_config_proto_rawDescData = file_google_cloud_retail_v2beta_import_config_proto_rawDesc
)

func file_google_cloud_retail_v2beta_import_config_proto_rawDescGZIP() []byte {
	file_google_cloud_retail_v2beta_import_config_proto_rawDescOnce.Do(func() {
		file_google_cloud_retail_v2beta_import_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_retail_v2beta_import_config_proto_rawDescData)
	})
	return file_google_cloud_retail_v2beta_import_config_proto_rawDescData
}

var file_google_cloud_retail_v2beta_import_config_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_retail_v2beta_import_config_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_google_cloud_retail_v2beta_import_config_proto_goTypes = []any{
	(ImportProductsRequest_ReconciliationMode)(0), // 0: google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode
	(*GcsSource)(nil),                    // 1: google.cloud.retail.v2beta.GcsSource
	(*BigQuerySource)(nil),               // 2: google.cloud.retail.v2beta.BigQuerySource
	(*ProductInlineSource)(nil),          // 3: google.cloud.retail.v2beta.ProductInlineSource
	(*UserEventInlineSource)(nil),        // 4: google.cloud.retail.v2beta.UserEventInlineSource
	(*ImportErrorsConfig)(nil),           // 5: google.cloud.retail.v2beta.ImportErrorsConfig
	(*ImportProductsRequest)(nil),        // 6: google.cloud.retail.v2beta.ImportProductsRequest
	(*ImportUserEventsRequest)(nil),      // 7: google.cloud.retail.v2beta.ImportUserEventsRequest
	(*ImportCompletionDataRequest)(nil),  // 8: google.cloud.retail.v2beta.ImportCompletionDataRequest
	(*ProductInputConfig)(nil),           // 9: google.cloud.retail.v2beta.ProductInputConfig
	(*UserEventInputConfig)(nil),         // 10: google.cloud.retail.v2beta.UserEventInputConfig
	(*CompletionDataInputConfig)(nil),    // 11: google.cloud.retail.v2beta.CompletionDataInputConfig
	(*ImportMetadata)(nil),               // 12: google.cloud.retail.v2beta.ImportMetadata
	(*ImportProductsResponse)(nil),       // 13: google.cloud.retail.v2beta.ImportProductsResponse
	(*ImportUserEventsResponse)(nil),     // 14: google.cloud.retail.v2beta.ImportUserEventsResponse
	(*UserEventImportSummary)(nil),       // 15: google.cloud.retail.v2beta.UserEventImportSummary
	(*ImportCompletionDataResponse)(nil), // 16: google.cloud.retail.v2beta.ImportCompletionDataResponse
	(*date.Date)(nil),                    // 17: google.type.Date
	(*Product)(nil),                      // 18: google.cloud.retail.v2beta.Product
	(*UserEvent)(nil),                    // 19: google.cloud.retail.v2beta.UserEvent
	(*fieldmaskpb.FieldMask)(nil),        // 20: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),        // 21: google.protobuf.Timestamp
	(*status.Status)(nil),                // 22: google.rpc.Status
}
var file_google_cloud_retail_v2beta_import_config_proto_depIdxs = []int32{
	17, // 0: google.cloud.retail.v2beta.BigQuerySource.partition_date:type_name -> google.type.Date
	18, // 1: google.cloud.retail.v2beta.ProductInlineSource.products:type_name -> google.cloud.retail.v2beta.Product
	19, // 2: google.cloud.retail.v2beta.UserEventInlineSource.user_events:type_name -> google.cloud.retail.v2beta.UserEvent
	9,  // 3: google.cloud.retail.v2beta.ImportProductsRequest.input_config:type_name -> google.cloud.retail.v2beta.ProductInputConfig
	5,  // 4: google.cloud.retail.v2beta.ImportProductsRequest.errors_config:type_name -> google.cloud.retail.v2beta.ImportErrorsConfig
	20, // 5: google.cloud.retail.v2beta.ImportProductsRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 6: google.cloud.retail.v2beta.ImportProductsRequest.reconciliation_mode:type_name -> google.cloud.retail.v2beta.ImportProductsRequest.ReconciliationMode
	10, // 7: google.cloud.retail.v2beta.ImportUserEventsRequest.input_config:type_name -> google.cloud.retail.v2beta.UserEventInputConfig
	5,  // 8: google.cloud.retail.v2beta.ImportUserEventsRequest.errors_config:type_name -> google.cloud.retail.v2beta.ImportErrorsConfig
	11, // 9: google.cloud.retail.v2beta.ImportCompletionDataRequest.input_config:type_name -> google.cloud.retail.v2beta.CompletionDataInputConfig
	3,  // 10: google.cloud.retail.v2beta.ProductInputConfig.product_inline_source:type_name -> google.cloud.retail.v2beta.ProductInlineSource
	1,  // 11: google.cloud.retail.v2beta.ProductInputConfig.gcs_source:type_name -> google.cloud.retail.v2beta.GcsSource
	2,  // 12: google.cloud.retail.v2beta.ProductInputConfig.big_query_source:type_name -> google.cloud.retail.v2beta.BigQuerySource
	4,  // 13: google.cloud.retail.v2beta.UserEventInputConfig.user_event_inline_source:type_name -> google.cloud.retail.v2beta.UserEventInlineSource
	1,  // 14: google.cloud.retail.v2beta.UserEventInputConfig.gcs_source:type_name -> google.cloud.retail.v2beta.GcsSource
	2,  // 15: google.cloud.retail.v2beta.UserEventInputConfig.big_query_source:type_name -> google.cloud.retail.v2beta.BigQuerySource
	2,  // 16: google.cloud.retail.v2beta.CompletionDataInputConfig.big_query_source:type_name -> google.cloud.retail.v2beta.BigQuerySource
	21, // 17: google.cloud.retail.v2beta.ImportMetadata.create_time:type_name -> google.protobuf.Timestamp
	21, // 18: google.cloud.retail.v2beta.ImportMetadata.update_time:type_name -> google.protobuf.Timestamp
	22, // 19: google.cloud.retail.v2beta.ImportProductsResponse.error_samples:type_name -> google.rpc.Status
	5,  // 20: google.cloud.retail.v2beta.ImportProductsResponse.errors_config:type_name -> google.cloud.retail.v2beta.ImportErrorsConfig
	22, // 21: google.cloud.retail.v2beta.ImportUserEventsResponse.error_samples:type_name -> google.rpc.Status
	5,  // 22: google.cloud.retail.v2beta.ImportUserEventsResponse.errors_config:type_name -> google.cloud.retail.v2beta.ImportErrorsConfig
	15, // 23: google.cloud.retail.v2beta.ImportUserEventsResponse.import_summary:type_name -> google.cloud.retail.v2beta.UserEventImportSummary
	22, // 24: google.cloud.retail.v2beta.ImportCompletionDataResponse.error_samples:type_name -> google.rpc.Status
	25, // [25:25] is the sub-list for method output_type
	25, // [25:25] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_google_cloud_retail_v2beta_import_config_proto_init() }
func file_google_cloud_retail_v2beta_import_config_proto_init() {
	if File_google_cloud_retail_v2beta_import_config_proto != nil {
		return
	}
	file_google_cloud_retail_v2beta_product_proto_init()
	file_google_cloud_retail_v2beta_user_event_proto_init()
	file_google_cloud_retail_v2beta_import_config_proto_msgTypes[1].OneofWrappers = []any{
		(*BigQuerySource_PartitionDate)(nil),
	}
	file_google_cloud_retail_v2beta_import_config_proto_msgTypes[4].OneofWrappers = []any{
		(*ImportErrorsConfig_GcsPrefix)(nil),
	}
	file_google_cloud_retail_v2beta_import_config_proto_msgTypes[8].OneofWrappers = []any{
		(*ProductInputConfig_ProductInlineSource)(nil),
		(*ProductInputConfig_GcsSource)(nil),
		(*ProductInputConfig_BigQuerySource)(nil),
	}
	file_google_cloud_retail_v2beta_import_config_proto_msgTypes[9].OneofWrappers = []any{
		(*UserEventInputConfig_UserEventInlineSource)(nil),
		(*UserEventInputConfig_GcsSource)(nil),
		(*UserEventInputConfig_BigQuerySource)(nil),
	}
	file_google_cloud_retail_v2beta_import_config_proto_msgTypes[10].OneofWrappers = []any{
		(*CompletionDataInputConfig_BigQuerySource)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_retail_v2beta_import_config_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_retail_v2beta_import_config_proto_goTypes,
		DependencyIndexes: file_google_cloud_retail_v2beta_import_config_proto_depIdxs,
		EnumInfos:         file_google_cloud_retail_v2beta_import_config_proto_enumTypes,
		MessageInfos:      file_google_cloud_retail_v2beta_import_config_proto_msgTypes,
	}.Build()
	File_google_cloud_retail_v2beta_import_config_proto = out.File
	file_google_cloud_retail_v2beta_import_config_proto_rawDesc = nil
	file_google_cloud_retail_v2beta_import_config_proto_goTypes = nil
	file_google_cloud_retail_v2beta_import_config_proto_depIdxs = nil
}
