package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachDataset invokes the airec.AttachDataset API synchronously
// api document: https://help.aliyun.com/api/airec/attachdataset.html
func (client *Client) AttachDataset(request *AttachDatasetRequest) (response *AttachDatasetResponse, err error) {
	response = CreateAttachDatasetResponse()
	err = client.DoAction(request, response)
	return
}

// AttachDatasetWithChan invokes the airec.AttachDataset API asynchronously
// api document: https://help.aliyun.com/api/airec/attachdataset.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AttachDatasetWithChan(request *AttachDatasetRequest) (<-chan *AttachDatasetResponse, <-chan error) {
	responseChan := make(chan *AttachDatasetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachDataset(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachDatasetWithCallback invokes the airec.AttachDataset API asynchronously
// api document: https://help.aliyun.com/api/airec/attachdataset.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AttachDatasetWithCallback(request *AttachDatasetRequest, callback func(response *AttachDatasetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachDatasetResponse
		var err error
		defer close(result)
		response, err = client.AttachDataset(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachDatasetRequest is the request struct for api AttachDataset
type AttachDatasetRequest struct {
	*requests.RoaRequest
	VersionId  string `position:"Path" name:"VersionId"`
	InstanceId string `position:"Path" name:"InstanceId"`
}

// AttachDatasetResponse is the response struct for api AttachDataset
type AttachDatasetResponse struct {
	*responses.BaseResponse
	RequestId string                `json:"RequestId" xml:"RequestId"`
	Code      string                `json:"Code" xml:"Code"`
	Message   string                `json:"Message" xml:"Message"`
	Result    ResultInAttachDataset `json:"Result" xml:"Result"`
}

// CreateAttachDatasetRequest creates a request to invoke AttachDataset API
func CreateAttachDatasetRequest() (request *AttachDatasetRequest) {
	request = &AttachDatasetRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2018-10-12", "AttachDataset", "/openapi/instances/[InstanceId]/dataSets/[VersionId]/actions/current", "airec", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAttachDatasetResponse creates a response to parse from AttachDataset response
func CreateAttachDatasetResponse() (response *AttachDatasetResponse) {
	response = &AttachDatasetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
