package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckOrganizationDomain invokes the baas.CheckOrganizationDomain API synchronously
// api document: https://help.aliyun.com/api/baas/checkorganizationdomain.html
func (client *Client) CheckOrganizationDomain(request *CheckOrganizationDomainRequest) (response *CheckOrganizationDomainResponse, err error) {
	response = CreateCheckOrganizationDomainResponse()
	err = client.DoAction(request, response)
	return
}

// CheckOrganizationDomainWithChan invokes the baas.CheckOrganizationDomain API asynchronously
// api document: https://help.aliyun.com/api/baas/checkorganizationdomain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckOrganizationDomainWithChan(request *CheckOrganizationDomainRequest) (<-chan *CheckOrganizationDomainResponse, <-chan error) {
	responseChan := make(chan *CheckOrganizationDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckOrganizationDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckOrganizationDomainWithCallback invokes the baas.CheckOrganizationDomain API asynchronously
// api document: https://help.aliyun.com/api/baas/checkorganizationdomain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckOrganizationDomainWithCallback(request *CheckOrganizationDomainRequest, callback func(response *CheckOrganizationDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckOrganizationDomainResponse
		var err error
		defer close(result)
		response, err = client.CheckOrganizationDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckOrganizationDomainRequest is the request struct for api CheckOrganizationDomain
type CheckOrganizationDomainRequest struct {
	*requests.RpcRequest
	DomainCode string `position:"Body" name:"DomainCode"`
	Domain     string `position:"Body" name:"Domain"`
}

// CheckOrganizationDomainResponse is the response struct for api CheckOrganizationDomain
type CheckOrganizationDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateCheckOrganizationDomainRequest creates a request to invoke CheckOrganizationDomain API
func CreateCheckOrganizationDomainRequest() (request *CheckOrganizationDomainRequest) {
	request = &CheckOrganizationDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "CheckOrganizationDomain", "", "")
	return
}

// CreateCheckOrganizationDomainResponse creates a response to parse from CheckOrganizationDomain response
func CreateCheckOrganizationDomainResponse() (response *CheckOrganizationDomainResponse) {
	response = &CheckOrganizationDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
