package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConsortiumChaincodes invokes the baas.DescribeConsortiumChaincodes API synchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiumchaincodes.html
func (client *Client) DescribeConsortiumChaincodes(request *DescribeConsortiumChaincodesRequest) (response *DescribeConsortiumChaincodesResponse, err error) {
	response = CreateDescribeConsortiumChaincodesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConsortiumChaincodesWithChan invokes the baas.DescribeConsortiumChaincodes API asynchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiumchaincodes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsortiumChaincodesWithChan(request *DescribeConsortiumChaincodesRequest) (<-chan *DescribeConsortiumChaincodesResponse, <-chan error) {
	responseChan := make(chan *DescribeConsortiumChaincodesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConsortiumChaincodes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConsortiumChaincodesWithCallback invokes the baas.DescribeConsortiumChaincodes API asynchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiumchaincodes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsortiumChaincodesWithCallback(request *DescribeConsortiumChaincodesRequest, callback func(response *DescribeConsortiumChaincodesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConsortiumChaincodesResponse
		var err error
		defer close(result)
		response, err = client.DescribeConsortiumChaincodes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConsortiumChaincodesRequest is the request struct for api DescribeConsortiumChaincodes
type DescribeConsortiumChaincodesRequest struct {
	*requests.RpcRequest
	Location     string `position:"Body" name:"Location"`
	ConsortiumId string `position:"Body" name:"ConsortiumId"`
}

// DescribeConsortiumChaincodesResponse is the response struct for api DescribeConsortiumChaincodes
type DescribeConsortiumChaincodesResponse struct {
	*responses.BaseResponse
	RequestId string        `json:"RequestId" xml:"RequestId"`
	Success   bool          `json:"Success" xml:"Success"`
	ErrorCode int           `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ChaincodeVO `json:"Result" xml:"Result"`
}

// CreateDescribeConsortiumChaincodesRequest creates a request to invoke DescribeConsortiumChaincodes API
func CreateDescribeConsortiumChaincodesRequest() (request *DescribeConsortiumChaincodesRequest) {
	request = &DescribeConsortiumChaincodesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeConsortiumChaincodes", "", "")
	return
}

// CreateDescribeConsortiumChaincodesResponse creates a response to parse from DescribeConsortiumChaincodes response
func CreateDescribeConsortiumChaincodesResponse() (response *DescribeConsortiumChaincodesResponse) {
	response = &DescribeConsortiumChaincodesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
