package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOrganizations invokes the baas.DescribeOrganizations API synchronously
// api document: https://help.aliyun.com/api/baas/describeorganizations.html
func (client *Client) DescribeOrganizations(request *DescribeOrganizationsRequest) (response *DescribeOrganizationsResponse, err error) {
	response = CreateDescribeOrganizationsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOrganizationsWithChan invokes the baas.DescribeOrganizations API asynchronously
// api document: https://help.aliyun.com/api/baas/describeorganizations.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOrganizationsWithChan(request *DescribeOrganizationsRequest) (<-chan *DescribeOrganizationsResponse, <-chan error) {
	responseChan := make(chan *DescribeOrganizationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOrganizations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOrganizationsWithCallback invokes the baas.DescribeOrganizations API asynchronously
// api document: https://help.aliyun.com/api/baas/describeorganizations.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOrganizationsWithCallback(request *DescribeOrganizationsRequest, callback func(response *DescribeOrganizationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOrganizationsResponse
		var err error
		defer close(result)
		response, err = client.DescribeOrganizations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOrganizationsRequest is the request struct for api DescribeOrganizations
type DescribeOrganizationsRequest struct {
	*requests.RpcRequest
	Location string `position:"Body" name:"Location"`
}

// DescribeOrganizationsResponse is the response struct for api DescribeOrganizations
type DescribeOrganizationsResponse struct {
	*responses.BaseResponse
	RequestId string                              `json:"RequestId" xml:"RequestId"`
	Success   bool                                `json:"Success" xml:"Success"`
	ErrorCode int                                 `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ResultItemInDescribeOrganizations `json:"Result" xml:"Result"`
}

// CreateDescribeOrganizationsRequest creates a request to invoke DescribeOrganizations API
func CreateDescribeOrganizationsRequest() (request *DescribeOrganizationsRequest) {
	request = &DescribeOrganizationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeOrganizations", "", "")
	return
}

// CreateDescribeOrganizationsResponse creates a response to parse from DescribeOrganizations response
func CreateDescribeOrganizationsResponse() (response *DescribeOrganizationsResponse) {
	response = &DescribeOrganizationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
