package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetApplies invokes the baas.GetApplies API synchronously
// api document: https://help.aliyun.com/api/baas/getapplies.html
func (client *Client) GetApplies(request *GetAppliesRequest) (response *GetAppliesResponse, err error) {
	response = CreateGetAppliesResponse()
	err = client.DoAction(request, response)
	return
}

// GetAppliesWithChan invokes the baas.GetApplies API asynchronously
// api document: https://help.aliyun.com/api/baas/getapplies.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetAppliesWithChan(request *GetAppliesRequest) (<-chan *GetAppliesResponse, <-chan error) {
	responseChan := make(chan *GetAppliesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetApplies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAppliesWithCallback invokes the baas.GetApplies API asynchronously
// api document: https://help.aliyun.com/api/baas/getapplies.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetAppliesWithCallback(request *GetAppliesRequest, callback func(response *GetAppliesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAppliesResponse
		var err error
		defer close(result)
		response, err = client.GetApplies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAppliesRequest is the request struct for api GetApplies
type GetAppliesRequest struct {
	*requests.RpcRequest
	Current  requests.Integer `position:"Body" name:"Current"`
	Bizid    string           `position:"Body" name:"Bizid"`
	PageSize requests.Integer `position:"Body" name:"PageSize"`
	Status   string           `position:"Body" name:"Status"`
}

// GetAppliesResponse is the response struct for api GetApplies
type GetAppliesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateGetAppliesRequest creates a request to invoke GetApplies API
func CreateGetAppliesRequest() (request *GetAppliesRequest) {
	request = &GetAppliesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "GetApplies", "", "")
	return
}

// CreateGetAppliesResponse creates a response to parse from GetApplies response
func CreateGetAppliesResponse() (response *GetAppliesResponse) {
	response = &GetAppliesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
