package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SchemaDetail invokes the baas.SchemaDetail API synchronously
// api document: https://help.aliyun.com/api/baas/schemadetail.html
func (client *Client) SchemaDetail(request *SchemaDetailRequest) (response *SchemaDetailResponse, err error) {
	response = CreateSchemaDetailResponse()
	err = client.DoAction(request, response)
	return
}

// SchemaDetailWithChan invokes the baas.SchemaDetail API asynchronously
// api document: https://help.aliyun.com/api/baas/schemadetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SchemaDetailWithChan(request *SchemaDetailRequest) (<-chan *SchemaDetailResponse, <-chan error) {
	responseChan := make(chan *SchemaDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SchemaDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SchemaDetailWithCallback invokes the baas.SchemaDetail API asynchronously
// api document: https://help.aliyun.com/api/baas/schemadetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SchemaDetailWithCallback(request *SchemaDetailRequest, callback func(response *SchemaDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SchemaDetailResponse
		var err error
		defer close(result)
		response, err = client.SchemaDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SchemaDetailRequest is the request struct for api SchemaDetail
type SchemaDetailRequest struct {
	*requests.RpcRequest
	SchemaId requests.Integer `position:"Body" name:"SchemaId"`
	Bizid    string           `position:"Body" name:"Bizid"`
}

// SchemaDetailResponse is the response struct for api SchemaDetail
type SchemaDetailResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateSchemaDetailRequest creates a request to invoke SchemaDetail API
func CreateSchemaDetailRequest() (request *SchemaDetailRequest) {
	request = &SchemaDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "SchemaDetail", "", "")
	return
}

// CreateSchemaDetailResponse creates a response to parse from SchemaDetail response
func CreateSchemaDetailResponse() (response *SchemaDetailResponse) {
	response = &SchemaDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
