package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryPrice invokes the bssopenapi.QueryPrice API synchronously
// api document: https://help.aliyun.com/api/bssopenapi/queryprice.html
func (client *Client) QueryPrice(request *QueryPriceRequest) (response *QueryPriceResponse, err error) {
	response = CreateQueryPriceResponse()
	err = client.DoAction(request, response)
	return
}

// QueryPriceWithChan invokes the bssopenapi.QueryPrice API asynchronously
// api document: https://help.aliyun.com/api/bssopenapi/queryprice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryPriceWithChan(request *QueryPriceRequest) (<-chan *QueryPriceResponse, <-chan error) {
	responseChan := make(chan *QueryPriceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryPrice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryPriceWithCallback invokes the bssopenapi.QueryPrice API asynchronously
// api document: https://help.aliyun.com/api/bssopenapi/queryprice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryPriceWithCallback(request *QueryPriceRequest, callback func(response *QueryPriceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryPriceResponse
		var err error
		defer close(result)
		response, err = client.QueryPrice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryPriceRequest is the request struct for api QueryPrice
type QueryPriceRequest struct {
	*requests.RpcRequest
	ParamStr string `position:"Query" name:"ParamStr"`
}

// QueryPriceResponse is the response struct for api QueryPrice
type QueryPriceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrCode   string `json:"ErrCode" xml:"ErrCode"`
}

// CreateQueryPriceRequest creates a request to invoke QueryPrice API
func CreateQueryPriceRequest() (request *QueryPriceRequest) {
	request = &QueryPriceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "QueryPrice", "", "")
	return
}

// CreateQueryPriceResponse creates a response to parse from QueryPrice response
func CreateQueryPriceResponse() (response *QueryPriceResponse) {
	response = &QueryPriceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
