package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryPriceList invokes the bssopenapi.QueryPriceList API synchronously
// api document: https://help.aliyun.com/api/bssopenapi/querypricelist.html
func (client *Client) QueryPriceList(request *QueryPriceListRequest) (response *QueryPriceListResponse, err error) {
	response = CreateQueryPriceListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryPriceListWithChan invokes the bssopenapi.QueryPriceList API asynchronously
// api document: https://help.aliyun.com/api/bssopenapi/querypricelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryPriceListWithChan(request *QueryPriceListRequest) (<-chan *QueryPriceListResponse, <-chan error) {
	responseChan := make(chan *QueryPriceListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryPriceList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryPriceListWithCallback invokes the bssopenapi.QueryPriceList API asynchronously
// api document: https://help.aliyun.com/api/bssopenapi/querypricelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryPriceListWithCallback(request *QueryPriceListRequest, callback func(response *QueryPriceListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryPriceListResponse
		var err error
		defer close(result)
		response, err = client.QueryPriceList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryPriceListRequest is the request struct for api QueryPriceList
type QueryPriceListRequest struct {
	*requests.RpcRequest
	ModuleCode       string           `position:"Query" name:"ModuleCode"`
	ProductCode      string           `position:"Query" name:"ProductCode"`
	SubscriptionType string           `position:"Query" name:"SubscriptionType"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	ProductType      string           `position:"Query" name:"ProductType"`
}

// QueryPriceListResponse is the response struct for api QueryPriceList
type QueryPriceListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryPriceListRequest creates a request to invoke QueryPriceList API
func CreateQueryPriceListRequest() (request *QueryPriceListRequest) {
	request = &QueryPriceListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "QueryPriceList", "", "")
	return
}

// CreateQueryPriceListResponse creates a response to parse from QueryPriceList response
func CreateQueryPriceListResponse() (response *QueryPriceListResponse) {
	response = &QueryPriceListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
