package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainCCAttackInfo invokes the cdn.DescribeDomainCCAttackInfo API synchronously
// api document: https://help.aliyun.com/api/cdn/describedomainccattackinfo.html
func (client *Client) DescribeDomainCCAttackInfo(request *DescribeDomainCCAttackInfoRequest) (response *DescribeDomainCCAttackInfoResponse, err error) {
	response = CreateDescribeDomainCCAttackInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainCCAttackInfoWithChan invokes the cdn.DescribeDomainCCAttackInfo API asynchronously
// api document: https://help.aliyun.com/api/cdn/describedomainccattackinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDomainCCAttackInfoWithChan(request *DescribeDomainCCAttackInfoRequest) (<-chan *DescribeDomainCCAttackInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainCCAttackInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainCCAttackInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainCCAttackInfoWithCallback invokes the cdn.DescribeDomainCCAttackInfo API asynchronously
// api document: https://help.aliyun.com/api/cdn/describedomainccattackinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDomainCCAttackInfoWithCallback(request *DescribeDomainCCAttackInfoRequest, callback func(response *DescribeDomainCCAttackInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainCCAttackInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainCCAttackInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainCCAttackInfoRequest is the request struct for api DescribeDomainCCAttackInfo
type DescribeDomainCCAttackInfoRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	DomainName    string           `position:"Query" name:"DomainName"`
	EndTime       string           `position:"Query" name:"EndTime"`
	StartTime     string           `position:"Query" name:"StartTime"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDomainCCAttackInfoResponse is the response struct for api DescribeDomainCCAttackInfo
type DescribeDomainCCAttackInfoResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	DomainName          string              `json:"DomainName" xml:"DomainName"`
	StartTime           string              `json:"StartTime" xml:"StartTime"`
	EndTime             string              `json:"EndTime" xml:"EndTime"`
	AttackIpDataList    AttackIpDataList    `json:"AttackIpDataList" xml:"AttackIpDataList"`
	AttackedUrlDataList AttackedUrlDataList `json:"AttackedUrlDataList" xml:"AttackedUrlDataList"`
}

// CreateDescribeDomainCCAttackInfoRequest creates a request to invoke DescribeDomainCCAttackInfo API
func CreateDescribeDomainCCAttackInfoRequest() (request *DescribeDomainCCAttackInfoRequest) {
	request = &DescribeDomainCCAttackInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2014-11-11", "DescribeDomainCCAttackInfo", "", "")
	return
}

// CreateDescribeDomainCCAttackInfoResponse creates a response to parse from DescribeDomainCCAttackInfo response
func CreateDescribeDomainCCAttackInfoResponse() (response *DescribeDomainCCAttackInfoResponse) {
	response = &DescribeDomainCCAttackInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
