package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEslDevice invokes the cloudesl.DeleteEslDevice API synchronously
// api document: https://help.aliyun.com/api/cloudesl/deleteesldevice.html
func (client *Client) DeleteEslDevice(request *DeleteEslDeviceRequest) (response *DeleteEslDeviceResponse, err error) {
	response = CreateDeleteEslDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEslDeviceWithChan invokes the cloudesl.DeleteEslDevice API asynchronously
// api document: https://help.aliyun.com/api/cloudesl/deleteesldevice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteEslDeviceWithChan(request *DeleteEslDeviceRequest) (<-chan *DeleteEslDeviceResponse, <-chan error) {
	responseChan := make(chan *DeleteEslDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEslDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEslDeviceWithCallback invokes the cloudesl.DeleteEslDevice API asynchronously
// api document: https://help.aliyun.com/api/cloudesl/deleteesldevice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteEslDeviceWithCallback(request *DeleteEslDeviceRequest, callback func(response *DeleteEslDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEslDeviceResponse
		var err error
		defer close(result)
		response, err = client.DeleteEslDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEslDeviceRequest is the request struct for api DeleteEslDevice
type DeleteEslDeviceRequest struct {
	*requests.RpcRequest
	EslBarCode string `position:"Query" name:"EslBarCode"`
	StoreId    string `position:"Query" name:"StoreId"`
}

// DeleteEslDeviceResponse is the response struct for api DeleteEslDevice
type DeleteEslDeviceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateDeleteEslDeviceRequest creates a request to invoke DeleteEslDevice API
func CreateDeleteEslDeviceRequest() (request *DeleteEslDeviceRequest) {
	request = &DeleteEslDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2018-08-01", "DeleteEslDevice", "", "")
	return
}

// CreateDeleteEslDeviceResponse creates a response to parse from DeleteEslDevice response
func CreateDeleteEslDeviceResponse() (response *DeleteEslDeviceResponse) {
	response = &DeleteEslDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
