package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeStores invokes the cloudesl.DescribeStores API synchronously
// api document: https://help.aliyun.com/api/cloudesl/describestores.html
func (client *Client) DescribeStores(request *DescribeStoresRequest) (response *DescribeStoresResponse, err error) {
	response = CreateDescribeStoresResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeStoresWithChan invokes the cloudesl.DescribeStores API asynchronously
// api document: https://help.aliyun.com/api/cloudesl/describestores.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeStoresWithChan(request *DescribeStoresRequest) (<-chan *DescribeStoresResponse, <-chan error) {
	responseChan := make(chan *DescribeStoresResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeStores(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeStoresWithCallback invokes the cloudesl.DescribeStores API asynchronously
// api document: https://help.aliyun.com/api/cloudesl/describestores.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeStoresWithCallback(request *DescribeStoresRequest, callback func(response *DescribeStoresResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeStoresResponse
		var err error
		defer close(result)
		response, err = client.DescribeStores(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeStoresRequest is the request struct for api DescribeStores
type DescribeStoresRequest struct {
	*requests.RpcRequest
	ToDate     string           `position:"Query" name:"ToDate"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	StoreName  string           `position:"Query" name:"StoreName"`
	Groups     string           `position:"Query" name:"Groups"`
	StoreId    string           `position:"Query" name:"StoreId"`
	Brand      string           `position:"Query" name:"Brand"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	FromDate   string           `position:"Query" name:"FromDate"`
}

// DescribeStoresResponse is the response struct for api DescribeStores
type DescribeStoresResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Success    bool   `json:"Success" xml:"Success"`
	Message    string `json:"Message" xml:"Message"`
	ErrorCode  string `json:"ErrorCode" xml:"ErrorCode"`
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	PageNumber int    `json:"PageNumber" xml:"PageNumber"`
	PageSize   int    `json:"PageSize" xml:"PageSize"`
	Stores     Stores `json:"Stores" xml:"Stores"`
}

// CreateDescribeStoresRequest creates a request to invoke DescribeStores API
func CreateDescribeStoresRequest() (request *DescribeStoresRequest) {
	request = &DescribeStoresRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2018-08-01", "DescribeStores", "", "")
	return
}

// CreateDescribeStoresResponse creates a response to parse from DescribeStores response
func CreateDescribeStoresResponse() (response *DescribeStoresResponse) {
	response = &DescribeStoresResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
