package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnbindEslDevice invokes the cloudesl.UnbindEslDevice API synchronously
// api document: https://help.aliyun.com/api/cloudesl/unbindesldevice.html
func (client *Client) UnbindEslDevice(request *UnbindEslDeviceRequest) (response *UnbindEslDeviceResponse, err error) {
	response = CreateUnbindEslDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// UnbindEslDeviceWithChan invokes the cloudesl.UnbindEslDevice API asynchronously
// api document: https://help.aliyun.com/api/cloudesl/unbindesldevice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UnbindEslDeviceWithChan(request *UnbindEslDeviceRequest) (<-chan *UnbindEslDeviceResponse, <-chan error) {
	responseChan := make(chan *UnbindEslDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnbindEslDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnbindEslDeviceWithCallback invokes the cloudesl.UnbindEslDevice API asynchronously
// api document: https://help.aliyun.com/api/cloudesl/unbindesldevice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UnbindEslDeviceWithCallback(request *UnbindEslDeviceRequest, callback func(response *UnbindEslDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnbindEslDeviceResponse
		var err error
		defer close(result)
		response, err = client.UnbindEslDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnbindEslDeviceRequest is the request struct for api UnbindEslDevice
type UnbindEslDeviceRequest struct {
	*requests.RpcRequest
	EslBarCode  string `position:"Query" name:"EslBarCode"`
	StoreId     string `position:"Query" name:"StoreId"`
	ItemBarCode string `position:"Query" name:"ItemBarCode"`
}

// UnbindEslDeviceResponse is the response struct for api UnbindEslDevice
type UnbindEslDeviceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateUnbindEslDeviceRequest creates a request to invoke UnbindEslDevice API
func CreateUnbindEslDeviceRequest() (request *UnbindEslDeviceRequest) {
	request = &UnbindEslDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2018-08-01", "UnbindEslDevice", "", "")
	return
}

// CreateUnbindEslDeviceResponse creates a response to parse from UnbindEslDevice response
func CreateUnbindEslDeviceResponse() (response *UnbindEslDeviceResponse) {
	response = &UnbindEslDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
