package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ProfileMedia invokes the cloudwf.ProfileMedia API synchronously
// api document: https://help.aliyun.com/api/cloudwf/profilemedia.html
func (client *Client) ProfileMedia(request *ProfileMediaRequest) (response *ProfileMediaResponse, err error) {
	response = CreateProfileMediaResponse()
	err = client.DoAction(request, response)
	return
}

// ProfileMediaWithChan invokes the cloudwf.ProfileMedia API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/profilemedia.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ProfileMediaWithChan(request *ProfileMediaRequest) (<-chan *ProfileMediaResponse, <-chan error) {
	responseChan := make(chan *ProfileMediaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ProfileMedia(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ProfileMediaWithCallback invokes the cloudwf.ProfileMedia API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/profilemedia.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ProfileMediaWithCallback(request *ProfileMediaRequest, callback func(response *ProfileMediaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ProfileMediaResponse
		var err error
		defer close(result)
		response, err = client.ProfileMedia(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ProfileMediaRequest is the request struct for api ProfileMedia
type ProfileMediaRequest struct {
	*requests.RpcRequest
	BeginDate string           `position:"Query" name:"BeginDate"`
	EndDate   string           `position:"Query" name:"EndDate"`
	DataType  requests.Integer `position:"Query" name:"DataType"`
	Gsid      requests.Integer `position:"Query" name:"Gsid"`
}

// ProfileMediaResponse is the response struct for api ProfileMedia
type ProfileMediaResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateProfileMediaRequest creates a request to invoke ProfileMedia API
func CreateProfileMediaRequest() (request *ProfileMediaRequest) {
	request = &ProfileMediaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ProfileMedia", "cloudwf", "openAPI")
	return
}

// CreateProfileMediaResponse creates a response to parse from ProfileMedia response
func CreateProfileMediaResponse() (response *ProfileMediaResponse) {
	response = &ProfileMediaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
