package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMonitoringTemplate invokes the cms.CreateMonitoringTemplate API synchronously
// api document: https://help.aliyun.com/api/cms/createmonitoringtemplate.html
func (client *Client) CreateMonitoringTemplate(request *CreateMonitoringTemplateRequest) (response *CreateMonitoringTemplateResponse, err error) {
	response = CreateCreateMonitoringTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMonitoringTemplateWithChan invokes the cms.CreateMonitoringTemplate API asynchronously
// api document: https://help.aliyun.com/api/cms/createmonitoringtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateMonitoringTemplateWithChan(request *CreateMonitoringTemplateRequest) (<-chan *CreateMonitoringTemplateResponse, <-chan error) {
	responseChan := make(chan *CreateMonitoringTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMonitoringTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMonitoringTemplateWithCallback invokes the cms.CreateMonitoringTemplate API asynchronously
// api document: https://help.aliyun.com/api/cms/createmonitoringtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateMonitoringTemplateWithCallback(request *CreateMonitoringTemplateRequest, callback func(response *CreateMonitoringTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMonitoringTemplateResponse
		var err error
		defer close(result)
		response, err = client.CreateMonitoringTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMonitoringTemplateRequest is the request struct for api CreateMonitoringTemplate
type CreateMonitoringTemplateRequest struct {
	*requests.RpcRequest
	EventRuleTemplatesJson string `position:"Query" name:"EventRuleTemplatesJson"`
	Name                   string `position:"Query" name:"Name"`
	Namespace              string `position:"Query" name:"Namespace"`
	Description            string `position:"Query" name:"Description"`
	AlertTemplatesJson     string `position:"Query" name:"AlertTemplatesJson"`
}

// CreateMonitoringTemplateResponse is the response struct for api CreateMonitoringTemplate
type CreateMonitoringTemplateResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorCode    int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Id           int    `json:"Id" xml:"Id"`
}

// CreateCreateMonitoringTemplateRequest creates a request to invoke CreateMonitoringTemplate API
func CreateCreateMonitoringTemplateRequest() (request *CreateMonitoringTemplateRequest) {
	request = &CreateMonitoringTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "CreateMonitoringTemplate", "cms", "openAPI")
	return
}

// CreateCreateMonitoringTemplateResponse creates a response to parse from CreateMonitoringTemplate response
func CreateCreateMonitoringTemplateResponse() (response *CreateMonitoringTemplateResponse) {
	response = &CreateMonitoringTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
