package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySystemEventDemo invokes the cms.QuerySystemEventDemo API synchronously
// api document: https://help.aliyun.com/api/cms/querysystemeventdemo.html
func (client *Client) QuerySystemEventDemo(request *QuerySystemEventDemoRequest) (response *QuerySystemEventDemoResponse, err error) {
	response = CreateQuerySystemEventDemoResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySystemEventDemoWithChan invokes the cms.QuerySystemEventDemo API asynchronously
// api document: https://help.aliyun.com/api/cms/querysystemeventdemo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QuerySystemEventDemoWithChan(request *QuerySystemEventDemoRequest) (<-chan *QuerySystemEventDemoResponse, <-chan error) {
	responseChan := make(chan *QuerySystemEventDemoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySystemEventDemo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySystemEventDemoWithCallback invokes the cms.QuerySystemEventDemo API asynchronously
// api document: https://help.aliyun.com/api/cms/querysystemeventdemo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QuerySystemEventDemoWithCallback(request *QuerySystemEventDemoRequest, callback func(response *QuerySystemEventDemoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySystemEventDemoResponse
		var err error
		defer close(result)
		response, err = client.QuerySystemEventDemo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySystemEventDemoRequest is the request struct for api QuerySystemEventDemo
type QuerySystemEventDemoRequest struct {
	*requests.RpcRequest
	Product   string `position:"Query" name:"Product"`
	EventName string `position:"Query" name:"EventName"`
}

// QuerySystemEventDemoResponse is the response struct for api QuerySystemEventDemo
type QuerySystemEventDemoResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateQuerySystemEventDemoRequest creates a request to invoke QuerySystemEventDemo API
func CreateQuerySystemEventDemoRequest() (request *QuerySystemEventDemoRequest) {
	request = &QuerySystemEventDemoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "QuerySystemEventDemo", "cms", "openAPI")
	return
}

// CreateQuerySystemEventDemoResponse creates a response to parse from QuerySystemEventDemo response
func CreateQuerySystemEventDemoResponse() (response *QuerySystemEventDemoResponse) {
	response = &QuerySystemEventDemoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
