package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelRepoBuild invokes the cr.CancelRepoBuild API synchronously
// api document: https://help.aliyun.com/api/cr/cancelrepobuild.html
func (client *Client) CancelRepoBuild(request *CancelRepoBuildRequest) (response *CancelRepoBuildResponse, err error) {
	response = CreateCancelRepoBuildResponse()
	err = client.DoAction(request, response)
	return
}

// CancelRepoBuildWithChan invokes the cr.CancelRepoBuild API asynchronously
// api document: https://help.aliyun.com/api/cr/cancelrepobuild.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CancelRepoBuildWithChan(request *CancelRepoBuildRequest) (<-chan *CancelRepoBuildResponse, <-chan error) {
	responseChan := make(chan *CancelRepoBuildResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelRepoBuild(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelRepoBuildWithCallback invokes the cr.CancelRepoBuild API asynchronously
// api document: https://help.aliyun.com/api/cr/cancelrepobuild.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CancelRepoBuildWithCallback(request *CancelRepoBuildRequest, callback func(response *CancelRepoBuildResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelRepoBuildResponse
		var err error
		defer close(result)
		response, err = client.CancelRepoBuild(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelRepoBuildRequest is the request struct for api CancelRepoBuild
type CancelRepoBuildRequest struct {
	*requests.RoaRequest
	RepoNamespace string `position:"Path" name:"RepoNamespace"`
	RepoName      string `position:"Path" name:"RepoName"`
	BuildId       string `position:"Path" name:"BuildId"`
}

// CancelRepoBuildResponse is the response struct for api CancelRepoBuild
type CancelRepoBuildResponse struct {
	*responses.BaseResponse
}

// CreateCancelRepoBuildRequest creates a request to invoke CancelRepoBuild API
func CreateCancelRepoBuildRequest() (request *CancelRepoBuildRequest) {
	request = &CancelRepoBuildRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "CancelRepoBuild", "/repos/[RepoNamespace]/[RepoName]/build/[BuildId]/cancel", "cr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelRepoBuildResponse creates a response to parse from CancelRepoBuild response
func CreateCancelRepoBuildResponse() (response *CancelRepoBuildResponse) {
	response = &CancelRepoBuildResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
