package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserInfo invokes the cr.GetUserInfo API synchronously
// api document: https://help.aliyun.com/api/cr/getuserinfo.html
func (client *Client) GetUserInfo(request *GetUserInfoRequest) (response *GetUserInfoResponse, err error) {
	response = CreateGetUserInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserInfoWithChan invokes the cr.GetUserInfo API asynchronously
// api document: https://help.aliyun.com/api/cr/getuserinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetUserInfoWithChan(request *GetUserInfoRequest) (<-chan *GetUserInfoResponse, <-chan error) {
	responseChan := make(chan *GetUserInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserInfoWithCallback invokes the cr.GetUserInfo API asynchronously
// api document: https://help.aliyun.com/api/cr/getuserinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetUserInfoWithCallback(request *GetUserInfoRequest, callback func(response *GetUserInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserInfoResponse
		var err error
		defer close(result)
		response, err = client.GetUserInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserInfoRequest is the request struct for api GetUserInfo
type GetUserInfoRequest struct {
	*requests.RoaRequest
}

// GetUserInfoResponse is the response struct for api GetUserInfo
type GetUserInfoResponse struct {
	*responses.BaseResponse
}

// CreateGetUserInfoRequest creates a request to invoke GetUserInfo API
func CreateGetUserInfoRequest() (request *GetUserInfoRequest) {
	request = &GetUserInfoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "GetUserInfo", "/users", "cr", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetUserInfoResponse creates a response to parse from GetUserInfo response
func CreateGetUserInfoResponse() (response *GetUserInfoResponse) {
	response = &GetUserInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
